{block name="head"}
    <link rel="stylesheet" href="{$systemurl}templates/orderforms/{$carttpl}/style.css?v={$assetVersion}">
{/block}

<!-- Main Content -->
<main class="main-content">
  <div class="container">
    
    {if $errormessage}
      <div class="alert alert-danger">
        <strong>Error:</strong> {$errormessage}
      </div>
    {/if}

    <!-- Domain Search Section -->
    <div class="domain-search-section">
      <h1 class="section-title">Find Your Perfect Domain</h1>
      <form method="post" action="{$WEB_ROOT}/cart.php?a=add&domain=register" class="domain-search-form">
        <div class="input-group input-group-lg">
          <input type="text" name="query" class="form-control" placeholder="Search your domain name" required>
          <span class="input-group-btn">
            <button class="btn btn-primary" type="submit">
              <i class="fas fa-search"></i> Search
            </button>
            <a href="{$WEB_ROOT}/cart.php?a=add&domain=transfer" class="btn btn-default">
              Transfer
            </a>
          </span>
        </div>
      </form>
    </div>

    <!-- Products Section with Sidebar -->
    <div class="row">
      <div class="col-md-8">
        
        <h2 class="products-section-title">Choose Your Web Hosting Plan</h2>

        <!-- Product Grid -->
        <div class="products-grid">
          {foreach $products as $product}
            <div class="product{if $product.isFeatured} featured{/if}">
              
              <!-- Featured Badge -->
              {if $product.isFeatured}
                <div class="featured-badge">
                  <span class="badge-text">★ Recommended</span>
                </div>
              {/if}

              <!-- Product Header -->
              <div class="product-header{if $product.isFeatured} ibb-featured{/if}">
                <h3 class="product-title ibb-title">{$product.name}</h3>
              </div>

              <!-- Product Body -->
              <div class="product-body">
                
                <!-- Pricing -->
                <div class="product-pricing">
                  {if $product.paytype eq "free"}
                    <div class="price-wrapper">
                      <span class="price">{$LANG.orderfree}</span>
                    </div>
                  {elseif $product.paytype eq "onetime"}
                    <div class="price-wrapper">
                      <span class="price">{$product.pricing.onetime}</span>
                    </div>
                    <div class="annual-price">One-time payment</div>
                  {else}
                    {* Show monthly price if available *}
                    {if $product.pricing.monthly}
                      <div class="price-wrapper">
                        <span class="price">{$product.pricing.monthly}</span>
                        <span class="cycle">/month</span>
                      </div>
                    {elseif $product.pricing.quarterly}
                      <div class="price-wrapper">
                        <span class="price">{$product.pricing.quarterly}</span>
                        <span class="cycle">/3 months</span>
                      </div>
                    {elseif $product.pricing.semiannually}
                      <div class="price-wrapper">
                        <span class="price">{$product.pricing.semiannually}</span>
                        <span class="cycle">/6 months</span>
                      </div>
                    {elseif $product.pricing.annually}
                      <div class="price-wrapper">
                        <span class="price">{$product.pricing.annually}</span>
                        <span class="cycle">/year</span>
                      </div>
                    {/if}
                    
                    {* Show annual price as secondary if monthly is primary *}
                    {if $product.pricing.monthly && $product.pricing.annually}
                      <div class="annual-price">{$product.pricing.annually} /year</div>
                    {/if}
                  {/if}
                </div>

                <!-- Description -->
                {if $product.description}
                  <p class="product-description">{$product.description}</p>
                {/if}

                <!-- Features -->
                {if $product.features}
                  <ul class="product-features ibb-feats">
                    {foreach $product.features as $feature => $value}
                      <li>
                        <i class="fas fa-check"></i>
                        <span>{$feature}</span>
                      </li>
                    {/foreach}
                  </ul>
                {/if}

                <!-- Note -->
                {if $product.featuresdesc}
                  <p class="product-note">{$product.featuresdesc}</p>
                {/if}

                <!-- Order Button -->
                <form method="post" action="{$WEB_ROOT}/cart.php?a=add&pid={$product.pid}">
                  <input type="hidden" name="pid" value="{$product.pid}">
                  {if $product.pricing.monthly}
                    <input type="hidden" name="billingcycle" value="monthly">
                  {elseif $product.pricing.quarterly}
                    <input type="hidden" name="billingcycle" value="quarterly">
                  {elseif $product.pricing.semiannually}
                    <input type="hidden" name="billingcycle" value="semiannually">
                  {elseif $product.pricing.annually}
                    <input type="hidden" name="billingcycle" value="annually">
                  {/if}
                  <button type="submit" class="btn btn-primary btn-block btn-order">
                    Choose Plan
                  </button>
                </form>

              </div>
            </div>
          {/foreach}
        </div>

      </div>

      <!-- Order Summary Sidebar -->
      <div class="col-md-4">
        <div class="order-summary">
          <h3 class="order-summary-header">Order Summary</h3>
          
          <div class="order-summary-body">
            {if $cartitems == 0}
              <p class="text-center text-muted">Your cart is empty. Choose a plan to get started!</p>
            {else}
              <div class="summary-line">
                <span class="summary-label">Subtotal</span>
                <span class="summary-value">{$subtotal}</span>
              </div>
              
              {if $discount > 0}
                <div class="summary-line">
                  <span class="summary-label">Discount</span>
                  <span class="summary-value">-{$discount}</span>
                </div>
              {/if}
              
              <div class="summary-line summary-total">
                <span class="summary-label"><strong>Total:</strong></span>
                <span class="summary-value summary-total-value">{$total}</span>
              </div>
            {/if}
          </div>
          
          {if $cartitems > 0}
            <form method="post" action="{$WEB_ROOT}/cart.php?a=view">
              <button type="submit" class="btn btn-primary btn-block btn-lg btn-continue">
                Continue <i class="fas fa-arrow-right"></i>
              </button>
            </form>
          {else}
            <div class="empty-cart-total">
              <div class="summary-total">
                <span class="summary-label"><strong>Total:</strong></span>
                <span class="summary-value summary-total-value">$0.00</span>
              </div>
              <button type="button" class="btn btn-primary btn-block btn-lg btn-continue" disabled>
                Continue <i class="fas fa-arrow-right"></i>
              </button>
            </div>
          {/if}
        </div>
      </div>
    </div>

  </div>
</main>

{include file="orderforms/{$carttpl}/includes/footer.tpl"}
