<!-- IBB HEADER (orderform) -->

{* Orderform header for IBrandBiz Comparison *}
{assign var="brandLogoUrl" value="https://ibrandbiz.com/assets/logo.png"}

<!DOCTYPE html>
<html lang="{$language}">
<head>
  <meta charset="{$charset}" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>{if $pagetitle}{$pagetitle} - {/if}{$companyname}</title>

  {include file="$template/includes/head.tpl"}  {* WHMCS core *}

  {* Orderform CSS (this folder) *}
  <link rel="stylesheet" href="{$WEB_ROOT}/templates/orderforms/{$carttpl}/assets/css/style.css?v={$assetVersion}">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" crossorigin="anonymous">

  {* Optional: brand font *}
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
  <style>body{font-family:Inter,system-ui,-apple-system,Segoe UI,Roboto,Helvetica Neue,Arial,Noto Sans,sans-serif}</style>

  {if !empty($headoutput)}{$headoutput}{/if}
</head>

<body class="whmcs-body">
<header class="ibb-header">
  <!-- fluid bar that matches page width -->
  <div class="container">
    <!-- center content to same width as body -->
    <div class="ibb-header-inner">
      <a class="brand" href="{$WEB_ROOT}/">
        <img src="{$brandLogoUrl}" alt="{$companyname}" class="ibrandbiz-logo-header">
      </a>

      <div class="header-actions">
        {if $loggedin}
          <a href="{$WEB_ROOT}/clientarea.php" class="btn btn-sm btn-outline-secondary">Dashboard</a>
          <a href="{$WEB_ROOT}/logout.php" class="btn btn-sm btn-primary ms-2">Logout</a>
        {else}
          <a href="{$WEB_ROOT}/clientarea.php" class="btn btn-sm btn-link">Sign in</a>
          <a href="{$WEB_ROOT}/register.php" class="btn btn-sm btn-success ms-2">Create account</a>
        {/if}
      </div>
    </div>
  </div>
</header>

<main id="main-body" class="py-4">
  <div class="container">
