{* IBrandBiz — 3-up Hosting Cards *}
<div id="order-ibrandbiz" class="ibb-products container">

  {if $errormessage}
    <div class="alert alert-danger">{$errormessage}</div>
  {/if}

  {if $products|@count gt 0}
    <div class="ibb-grid">
      {foreach $products as $product}
        {if $product.hidden neq true}
          <article class="ibb-card {if $product.isFeatured}is-featured{/if}" data-product="{$product.pid}">
            {if $product.isFeatured}
              <div class="ibb-badge">Most Popular</div>
            {/if}

            <header class="ibb-card__head">
              <h3 class="ibb-card__title">{$product.name|escape}</h3>
              {if $product.tagline}<p class="ibb-card__tag">{$product.tagline|escape}</p>{/if}
            </header>

            <div class="ibb-card__price">
              {if $product.pricing.minprice.cycle}
                <div class="ibb-price__value">
                  <span class="ibb-price__amount">
                    {if $product.pricing.minprice.prefix}{$product.pricing.minprice.prefix}{/if}
                    {$product.pricing.minprice.price}
                    {if $product.pricing.minprice.suffix}{$product.pricing.minprice.suffix}{/if}
                  </span>
                  <span class="ibb-price__cycle">/ {$product.pricing.minprice.cycle}</span>
                </div>
              {else}
                <div class="ibb-price__value">
                  <span class="ibb-price__amount">{$LANG.from} {$product.pricing.minprice.price}</span>
                </div>
              {/if}
            </div>

            <ul class="ibb-card__features">
              {if $product.description}
                {assign var=desc value=$product.description|strip_tags:false}
                {foreach from="\n"|explode:$desc item=line}
                  {if $line|trim != ''}<li>{$line|escape}</li>{/if}
                {/foreach}
              {else}
                <li>SSD storage</li>
                <li>Free SSL</li>
                <li>1-click apps</li>
              {/if}
            </ul>

            <div class="ibb-card__cta">
              <a class="btn btn-success ibb-btn" href="{$product.orderurl}">
                {$LANG.orderForm.chooseProduct|default:'Choose'}
              </a>
            </div>
          </article>
        {/if}
      {/foreach}
    </div>
  {else}
    <div class="alert alert-info">
      {$LANG.orderForm.noProducts}{* fallback if group empty *}
    </div>
  {/if}
</div>
