<?php
use WHMCS\View\Menu\Item as MenuItem;

/**
 * IBrandBiz: make primary navbar match "six".
 */
add_hook('ClientAreaPrimaryNavbar', 1, function (MenuItem $primaryNavbar) {
    // Remove unwanted items
    foreach (['Pricing', 'Support'] as $remove) {
        if ($primaryNavbar->getChild($remove)) {
            $primaryNavbar->removeChild($remove);
        }
    }

    // Ensure "Announcements"
    if (!$primaryNavbar->getChild('Announcements')) {
        $primaryNavbar->addChild('Announcements', [
            'label' => \Lang::trans('announcementstitle'),
            'uri'   => 'announcements.php',
            'order' => 30,
        ]);
    }

    // Ensure "Network Status"
    if (!$primaryNavbar->getChild('Network Status')) {
        $primaryNavbar->addChild('Network Status', [
            'label' => \Lang::trans('networkstatustitle'),
            'uri'   => 'serverstatus.php',
            'order' => 50,
        ]);
    }

    // Ensure "Contact Us"
    if (!$primaryNavbar->getChild('Contact Us')) {
        $primaryNavbar->addChild('Contact Us', [
            'label' => \Lang::trans('contactus'),
            'uri'   => 'contact.php',
            'order' => 60,
        ]);
    }

    // Order like six: Home, Store, Announcements, Knowledgebase, Network Status, Contact Us
    $desiredOrder = [
        'Home'            => 10,
        'Store'           => 20,
        'Announcements'   => 30,
        'Knowledgebase'   => 40,
        'Network Status'  => 50,
        'Contact Us'      => 60,
    ];
    foreach ($desiredOrder as $name => $order) {
        if ($child = $primaryNavbar->getChild($name)) {
            $child->setOrder($order);
        }
    }
});
