<!-- IBB HEADER (theme) -->
{* IBrandBiz WHMCS Theme — header.tpl (fixed & safe) *}
{* Normal (non-reversed) logo for the header *}
{assign var="brandLogoUrl" value="https://ibrandbiz.com/assets/logo.png"}

{* Detect if we are on a /store/ page in a Smarty-safe way *}
{assign var=isStore value=false}
{if isset($smarty.get.rp)}
    {if $smarty.get.rp|strstr:'/store/'}
        {assign var=isStore value=true}
    {/if}
{/if}

<!DOCTYPE html>
<html lang="{$language}">
<head>
    <meta charset="{$charset}" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>{if $pagetitle}{$pagetitle} - {/if}{$companyname}</title>

    {* WHMCS core styles/scripts (loads base CSS/JS) *}
        {include file="$template/includes/head.tpl"}

    {* IBrandBiz theme overrides *}
    <link rel="stylesheet" href="{$BASE_PATH_CSS}/custom.css" />
    <link rel="stylesheet" href="{$WEB_ROOT}/templates/{$template}/assets/css/ibb-orderform.css?v={$smarty.now}">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" integrity="sha384-jLKHWMZ8r5..." crossorigin="anonymous">


    {* Cart/orderform-specific styles (safety net) *}
    {if $filename eq 'cart' || (isset($smarty.get.rp) && $smarty.get.rp|strpos:'/store/' !== false)}
        <link rel="stylesheet" href="{$systemurl}templates/orderforms/ibrandbiz_comparison/style.css?v={$assetVersion}">
        <style>
          /* subtle spacing when main navbar is hidden on cart pages */
          #main-body { padding-top: 24px; }
        </style>
    {/if}

    {* Brand font *}
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
      body { font-family: "Inter", system-ui, -apple-system, Segoe UI, Roboto, "Helvetica Neue", Arial, "Noto Sans", "Liberation Sans", sans-serif; }
    </style>

    {* allow WHMCS/orderforms/modules to inject assets into <head> *}
    {if !empty($headoutput)}{$headoutput}{/if}
</head>

<body class="whmcs-body">

<header class="site-header">
  <div class="container-fluid">   {* full width bar *}
    <div class="container ibb-header-inner">  {* same width as body *}
      <a class="brand" href="{$WEB_ROOT}/">
        <img src="https://ibrandbiz.com/assets/logo.png" alt="{$companyname}" class="ibrandbiz-logo-header">
      </a>

      <div class="header-actions pull-right">
        {if $loggedin}
          <a href="{$WEB_ROOT}/clientarea.php" class="btn btn-sm btn-default">Dashboard</a>
          <a href="{$WEB_ROOT}/logout.php" class="btn btn-sm btn-primary">Logout</a>
        {else}
          <a href="{$WEB_ROOT}/clientarea.php" class="btn btn-sm btn-link">Sign in</a>
          <a href="{$WEB_ROOT}/register.php" class="btn btn-sm btn-success">Create account</a>
        {/if}
      </div>
    </div>
  </div>

  {*
    If you include a secondary navbar for non-store pages,
    keep it below; it won’t show on /store when cart template hides it.
  *}
</header>

{* Render the same WHMCS navbars that “six” uses *}
{if isset($primaryNavbar) || isset($secondaryNavbar)}
  <nav class="ibb-greenbar">
      {include file="$template/includes/navbar.tpl"}
  </nav>
{/if}

{* System alerts (maintenance, announcements, etc.) *}
<div class="container mt-3">
  {$systemAlert|default:''}
</div>

{* Breadcrumbs *}
{if $breadcrumbnav}
  <div class="container">
    {include file="$template/includes/breadcrumb.tpl"}
  </div>
{/if}

{* Begin main content wrapper *}
<main id="main-body" class="py-4">
  <div class="container">
