<?php

class provTradeDomain extends openSRS_base {
    private $_dataObject;
    private $_formatHolder = "";
    public $resultFullRaw;
    public $resultRaw;
    public $resultFullFormatted;
    public $resultFormatted;

    public function __construct ($formatString, $dataObject) {
        parent::__construct($dataObject);
        $this->_dataObject = $dataObject;
        $this->_formatHolder = $formatString;
        $this->_validateObject ();
    }

    public function __destruct () {
        parent::__destruct();
    }

    // Validate the object
    private function _validateObject (){
        $allPassed = true;

        $reqData = array (
            "domain",
            "first_name",
            "last_name",
            "org_name",
            "address1",
            "city",
            "state",
            "postal_code",
            "phone",
            "country",
            "email"
        );

        foreach ($reqData as $field) {
            if ($this->_dataObject->data->$field == "") {
                throw new Exception("oSRS Error - ". $field ." is not defined.");
                $allPassed = false;
            }
        }

        # Run the command
        if ($allPassed) {
            $this->processRequest ();
        } else {
            trigger_error ("oSRS Error - Incorrect call.", E_USER_WARNING);
        }
    }

    // Post validation functions
    private function processRequest (){
        $this->_dataObject->data->types = explode (",", $this->_dataObject->data->types);

        $cmd = array(
            'protocol' => 'XCP',
            'action' => 'TRADE_DOMAIN',
            'object' => 'domain',
            'attributes' => array(
                'domain' => $this->_dataObject->data->domain,
                'first_name' => $this->_dataObject->data->first_name,
                'last_name' => $this->_dataObject->data->last_name,
                'org_name' => $this->_dataObject->data->org_name,
                'address1' => $this->_dataObject->data->address1,
                'city' => $this->_dataObject->data->city,
                'state' => $this->_dataObject->data->state,
                'country' => $this->_dataObject->data->country,
                'postal_code' => $this->_dataObject->data->postal_code,
                'phone' => $this->_dataObject->data->phone,
                'fax' => $this->_dataObject->data->fax,
                'email' => $this->_dataObject->data->email
            )
        );

        $xmlCMD = $this->_opsHandler->encode($cmd);					// Flip Array to XML
        $XMLresult = $this->send_cmd($xmlCMD);						// Send XML
        $arrayResult = $this->_opsHandler->decode($XMLresult);		// Flip XML to Array

        // Results
        $this->resultFullRaw = $arrayResult;
        $this->resultRaw = $arrayResult;
        $this->resultFullFormatted = convertArray2Formatted ($this->_formatHolder, $this->resultFullRaw);
        $this->resultFormatted = convertArray2Formatted ($this->_formatHolder, $this->resultRaw);
    }
}