<?php
# Get Registrant Verification Status
class lookupGetRegistrantVerificationStatus extends openSRS_base{
    public function __construct ($formatString, $dataObject) {
        parent::__construct($dataObject);
        $this->_dataObject = $dataObject;
        $this->_process ();
    }
    private function _process(){

        $cmd = array(
            "protocol" => "XCP",
            "action" => "get_registrant_verification_status",
            "object" => "domain",
            "attributes" => array(
                "domain" => $this->_dataObject->data->domain,
            )
        );

        $xmlCMD = $this->_opsHandler->encode($cmd);
        $XMLresult = $this->send_cmd($xmlCMD);
        $arrayResult = $this->_opsHandler->decode($XMLresult);

        // Results
        $this->resultFullRaw = $arrayResult;

        if (isSet($arrayResult['attributes']['lookup']['items'])){
            $this->resultRaw = $arrayResult['attributes']['lookup']['items'];
        } else {
            $this->resultRaw = $arrayResult;
        }

        $this->resultFullFormated = convertArray2Formatted ($this->_formatHolder, $this->resultFullRaw);
        $this->resultFormated = convertArray2Formatted ($this->_formatHolder, $this->resultRaw);
    }

}
?>