<?php
/*
 *  Get ICANN Trade Designated Agent Status
 */

class modifyTradeDAStatus extends openSRS_base {
    private $_dataObject;
    private $_formatHolder = "";
    public $resultFullRaw;
    public $resultRaw;
    public $resultFullFormatted;
    public $resultFormatted;

    public function __construct ($formatString, $dataObject) {
        parent::__construct($dataObject);
        $this->_dataObject = $dataObject;
        $this->_formatHolder = $formatString;
        $this->_validateObject ();
    }

    public function __destruct () {
        parent::__destruct();
    }

    # Validate the object
    private function _validateObject (){
        $allPassed = true;

        if (empty($this->_dataObject->data->domain)) {
            trigger_error ("oSRS Error - Domain name is not defined.", E_USER_WARNING);
            $allPassed = false;
        }

        # Run the command
        if ($allPassed) {
            $this->_processRequest ();
        } else {
            trigger_error ("oSRS Error - Incorrect call.", E_USER_WARNING);
        }
    }

    # Set Request data
    private function _processRequest (){
        $cmd = array(
            'protocol' => 'XCP',
            'action' => 'MODIFY_TRADE_DESIGNATED_AGENT',
            'object' => 'DOMAIN',
            'attributes' => array (
                'domain' => $this->_dataObject->data->domain,
                'enable' => $this->_dataObject->data->enable,
                'ip_address' => $this->_dataObject->data->ip_address
            )
        );

        # Handle Response data format
        $xmlCMD = $this->_opsHandler->encode($cmd);					// Flip Array to XML
        $XMLresult = $this->send_cmd($xmlCMD);						// Send XML
        $arrayResult = $this->_opsHandler->decode($XMLresult);		// Flip XML to Array

        # Output Results in Array
        $this->resultFullRaw = $arrayResult;
        $this->resultRaw = $arrayResult;
        $this->resultFullFormatted = convertArray2Formatted ($this->_formatHolder, $this->resultFullRaw);
        $this->resultFormatted = convertArray2Formatted ($this->_formatHolder, $this->resultRaw);
    }
}
