<?php
/*
 *  Required object values:
 *  data - 
 */
 
class nsAdvancedUpdt extends openSRS_base {
	private $_dataObject;
	private $_formatHolder = "";
	public $resultFullRaw;
	public $resultRaw;
	public $resultFullFormatted;
	public $resultFormatted;

	public function __construct ($formatString, $dataObject) {
		parent::__construct($dataObject);
		$this->_dataObject = $dataObject;
		$this->_formatHolder = $formatString;
		$this->_validateObject ();
	}

	public function __destruct () {
		parent::__destruct();
	}

	// Validate the object
	private function _validateObject (){
		$allPassed = true;

        if (!isSet($this->_dataObject->data->domain) || $this->_dataObject->data->domain == "") {
            trigger_error ("oSRS Error - domain name is not defined.", E_USER_WARNING);
            $allPassed = false;
        }

        if (!isSet($this->_dataObject->data->op_type) || $this->_dataObject->data->op_type == "") {
			trigger_error ("oSRS Error - op_type is not defined.", E_USER_WARNING);
			$allPassed = false;
		}
				
		// Run the command
		if ($allPassed) {
			// Execute the command
			$this->_processRequest ();
		} else {
			trigger_error ("oSRS Error - Incorrect call.", E_USER_WARNING);
		}
	}

	// Post validation functions
	private function _processRequest (){
		$cmd = array(
			'protocol' => 'XCP',
			'action' => 'advanced_update_nameservers',
			'object' => 'domain',
			'attributes' => array (
			    'domain' => $this->_dataObject->data->domain,
				'op_type' => $this->_dataObject->data->op_type
			)
		);

        // Command optional values
		if (isSet($this->_dataObject->data->add_ns) && $this->_dataObject->data->add_ns != "") {
			$tempAdd = explode (",", $this->_dataObject->data->add_ns);
			$cmd['attributes']['add_ns'] = $tempAdd;
		}
		if (isSet($this->_dataObject->data->assign_ns) && $this->_dataObject->data->assign_ns != "") {
			$tempAdd = explode (",", $this->_dataObject->data->assign_ns);
			$cmd['attributes']['assign_ns'] = $tempAdd;
		}
		if (isSet($this->_dataObject->data->remove_ns) && $this->_dataObject->data->remove_ns != "") {
			$tempAdd = explode (",", $this->_dataObject->data->remove_ns);
			$cmd['attributes']['remove_ns'] = $tempAdd;
		}
		
		$xmlCMD = $this->_opsHandler->encode($cmd);					// Flip Array to XML
		$XMLresult = $this->send_cmd($xmlCMD);						// Send XML
		$arrayResult = $this->_opsHandler->decode($XMLresult);		// Flip XML to Array

		// Results
		$this->resultFullRaw = $arrayResult;
		$this->resultRaw = $arrayResult;
		$this->resultFullFormatted = convertArray2Formatted ($this->_formatHolder, $this->resultFullRaw);
		$this->resultFormatted = convertArray2Formatted ($this->_formatHolder, $this->resultRaw);
	}
}