<?php
/*
 *  Enable DA State for New Registrant Contact Set
 */

class enableDATrade extends openSRS_base {
    private $_dataObject;
    private $_formatHolder = "";
    public $resultFullRaw;
    public $resultRaw;
    public $resultFullFormatted;
    public $resultFormatted;

    public function __construct ($formatString, $dataObject) {
        parent::__construct($dataObject);
        $this->_dataObject = $dataObject;
        $this->_formatHolder = $formatString;
        $this->_processRequest ();
    }

    public function __destruct () {
        parent::__destruct();
    }

    # Validate the object
    private function _validateObject (){
        $allPassed = true;

        # New registrant contact info
        $req_data = array('first_name', 'last_name', 'org_name', 'email');
        for ($i = 0; $i < count($req_data); $i++){
            $field = $req_data[$i];
            if ($this->_dataObject->data->$field == "") {
                trigger_error ("oSRS Error - ". $field ." is not defined.", E_USER_WARNING);
                $allPassed = false;
            }
        }

        # Run the command
        if ($allPassed) {
            $this->_processRequest ();
        } else {
            trigger_error ("oSRS Error - Incorrect call.", E_USER_WARNING);
        }
    }

    # Set Request data
    private function _processRequest (){
        $cmd = array(
            'protocol' => 'XCP',
            'action' => 'enable_designated_agent',
            'object' => 'icann_trade_registrant',
            'attributes' => array (
                'owner' => array(
                    'first_name' => $this->_dataObject->data->first_name,
                    'last_name' => $this->_dataObject->data->last_name,
                    'org_name' => $this->_dataObject->data->org_name,
                    'email' => $this->_dataObject->data->email
                ),
                'enable' => $this->_dataObject->data->enable,
                'ip_address' => $this->_dataObject->data->ip_address
            )
        );

        # Handle Response data format
        $xmlCMD = $this->_opsHandler->encode($cmd);					// Flip Array to XML
        $XMLresult = $this->send_cmd($xmlCMD);						// Send XML
        $arrayResult = $this->_opsHandler->decode($XMLresult);		// Flip XML to Array

        opensrspro_logModuleCall("API_Enable_DA", $cmd, $arrayResult, '', []);

        # Output Results in Array
        $this->resultFullRaw = $arrayResult;
        $this->resultRaw = $arrayResult;
        $this->resultFullFormatted = convertArray2Formatted ($this->_formatHolder, $this->resultFullRaw);
        $this->resultFormatted = convertArray2Formatted ($this->_formatHolder, $this->resultRaw);
    }
}