
# OpenSRS Domains Pro Module

Version: 3.7.6

Last Updated: Febrauary 14th, 2023

Website: www.opensrs.com

support: help@opensrs.com


Requirements:

	* WHMCS 7+
	* PHP 5.6+
	* Larvael Library (Included with WHMCS v6+)
	* 'TCP Out' port 55443 must be open both ways
	* White list your WHMCS server IP with OpenSRS


## Installation


1) Unpack module .zip file to local directory
2) Upload all contents inside zip file to your root WHMCS installation and overwrite files.
3) Go to Setup > Products/Services > Domain Registrars and select 'Configure' beside Opensrspro module
4) Configure the module settings then 'Save'.
5) Set domain pricing under Setup > Products/Services > Domain Pricing
6) Set 'Opensrspro' as the default registrar for each TLD


## Product Configuration


**TestUsername:** Your test environment username

**TestAPIKey:** Your test environment API Key> (different from your live key

**ProdUsername:** Your live environment username

**ProdAPIKey:** Your live environment API Key

**Hashkey:** enter a random string of characters. This is used to create strong passwords when provisioning domains and
should never be changed once it is set as it is used to access previously registered domains. *This field is optional

**TestMode:** If checked, your test environment login details will be used

### The rest of the options are optional and can be activated as needed.

**ForceForwardingIP:** Leave Unchecked

**GeneralError:** Enter a general error message users will see when there is an error.

**DisableTemplateChanges:** Enabling this will turn off changes to the template files

In order to process domain contact updates automatically, the following options should be enabled

**ChangeLockedDomains:** Allow WHMCS to make changes to a domain automatically by unlocking and then locking the domain again
LockTechContact: <Use the tech contact provided in RWI instead of what is entered into WHMCS>


## ICANN Trade Policy (IMPORTANT)

1) As per ICANN any update to fields First Name, Last Name, Org Name, or Email will result in a trade of ownership.

2) To automate this process, all existing and new registrants must agree to Tucows Inc. (Registrar) act as their
designated agent (DA). Please update your terms of service if you haven't done so yet.
You can find an updated version of TOS here https://opensrs.com/wp-content/uploads/Tucows_ExhibitA.html

3) All updates to the owner contact on fields First Name, Last Name, Org Name, and/or Email will auto enable DA status
for old and new registrant, then the module will process the contact updates.

5) If the module is unable to enable DA status for old and new registrant, the contact update will still be processed,
however approval will be required through email from both registrants.

For more info on ICANN's trade policy please see OpenSRS's article here:https://opensrs.com/new-transfer-policy-qa/


## Domain Sync Cron Setup (IMPORTANT)

In order to sync domains with OpenSRS, you will need to setup a cron job once a day or as many as you need based on the
number of domains you manage. See WHMCS article regarding domain sync: http://docs.whmcs.com/Domains_Tab#Domain_Sync_Enabled

If you need to sync more than 50 domains, the domain sync cron job must be run multiple times a day.

See WHMCS article on how to setup your domain sync cron job: http://docs.whmcs.com/Crons#Setting_up_the_Cron_Tasks

## Supported TLD's

This module supports all TLDs that do not require additional data. Please refer to OpenSRS reference chart for more
details: http://bit.ly/OpenSRS_TLD_Reference_Chart
Additional data required TLDs:


gTLD
.asia
.aero
.ccop
.mobi
.asia
.tel
.name
.pro
.xxx
.quebec
.jobs
.travel


ccTLD
.ae
.at
.au [.com.au | .net.au | .org.au | .asn.au | .id.au]
.be
.br
.bz
.ca
.cc
.ch
.co
.de
.dk
.es
.eu
.fr
.in
.it
.li
.me
.mx
.nl
.nu
.pw
.ro
.ru
.se
.sg
.tv
.uk [.co.uk | .me.uk | .org.uk]
.us
.ws

Please ensure you understand the requirements for each TLD before enabling them for service in WHMCS. See OpenSRS TLD
reference chart.


## Change Log
Release 3.7.6
- Fixed log error when doing a contact update with trade (owner change). 

Release 3.7.5
- IDNs now work for all operations
- Fixed .FR issues
- Fixed registrant verification bug
- Fixed bug where domain forwarders were not added
- Code compatible with WHMCS 8.61, PHP 8.1 and ioncube 12 
 

Release 3.7.4
- Fixed bug where auth code was not passed over to OpenSRS


Release 3.7.3
- Fixed module logging on domain renewal command

Changed Files:
- /modules/registrars/opensrspro/opensrspro.php

Release 3.7.2
- Fixed .AU registration bug

Changed Files:
- /modules/registrars/opensrspro/opensrs/domains/provisioning/provSWregister.php
- /opensrs_domains_pro/includes/additionaldomainfields.php
- /modules/registrars/opensrspro/opensrspro.php

Release 3.7.1
- Added support for .AE

Changed Files:
- /modules/registrars/opensrspro/opensrspro.php
- /modules/registrars/opensrspro/opensrs/domains/provUpdateContacts.php
- /modules/registrars/opensrspro/opensrs/domains/provTradeDomain.php

Release 3.7
- Fixed domain sync bug when renewing expired domains
- Updated domain sync function
- Added ability to view domain notes
- Added ability to view registration verification status
- Added ability to resend registrant verification email
- Fixed bug with "Check transfer status" function

Changed Files:
- /modules/registrars/opensrspro/opensrspro.php
- /modules/registrars/opensrspro/hooks.php
- /modules/registrars/opensrspro/opensrs/domains/lookupGetRegistrantVerificationStatus.php
- /modules/registrars/opensrspro/opensrs/domains/lookupDomainNotes.php
- /modules/registrars/opensrspro/opensrs/domains/provSendVerificationEmail.php

Release 3.6
- Fixed domain contact update using "Use Existing Contact" function
- Fixed toolkit bug on contact update
- Fixed registration bug on .CA domain names
- Fixed bug that duplicates the country code on phone numbers
- Fixed bug in ICANN trade process

Changed Files:
- /modules/registrars/opensrspro/opensrspro.php
- /modules/registrars/opensrspro/opensrs/domains/provSWregister.php
- /modules/registrars/opensrspro/opensrs/domains/provUpdateContacts.php
- /modules/registrars/opensrspro/opensrs/domains/icanntrade/enableDATrade.php

Release 3.5.1
- Fixed auto unlock of domains names during updates
- Improved error handling and user message for function SaveNameservers(), GetNameservers()
- Cleaned up module log reporting for functions getConnectData(), SaveNameservers(), ModifyRegistrarLock()
- Removed cookie use in function GetNameservers()
- Improved contact set validation for function SaveContactDetails()

Changed Files:
- /modules/registrars/opensrspro/opensrspro.php
- /modules/registrars/opensrspro/opensrs/domains/provModify.php
- /modules/registrars/opensrspro/opensrs/nameservers/nsAdvacedUpdt.php

Release 3.5
- WHCMS v7 compatible
- Implemented new ICANN trade policy for all gTLD (Review new ICANN policy above)
- Automated contact updates to all gTLD by accepting Tucows Inc. as DA
- Registrant IP is logged with OpenSRS API server for ICANN audits on contact updates
- Improved multiple end user error messages
- Improved error handling for contact update function

Changed Files:
- /modules/registrars/opensrspro/opensrspro.php
- /modules/registrars/opensrspro/hooks.php (new)
- /modules/registrars/opensrspro/opensrs/domains/icanntrade/enableDATrade.php (new)
- /modules/registrars/opensrspro/opensrs/domains/icanntrade/getTradeDAStatus.php (new)
- /modules/registrars/opensrspro/opensrs/domains/icanntrade/modifyTradeDAStatus.php (new)
- /modules/registrars/opensrspro/opensrs/domains/icanntrade/modifyTradeLock.php (new)
- /includes/hooks/opensrspro_hooks.php (removed)

Release 3.4.1
- Fixed domain sync function and cron report

Changed Files: 
- /modules/registrars/opensrspro/opensrspro.php

Release 3.4
- Added support for older version of PHP for domain sync function
- .ORG TLD no longer requires organization name

Changed Files: 
- /modules/registrars/opensrspro/opensrspro.php
- /modules/registrars/opensrspro/opensrs/provUpdateContacts.php

Release 3.3
- Fixed domain sync issue with WHMCS v6.3+
- Updated domain sync function to use new Larvael DB library

Changed Files: 
- /modules/registrars/opensrspro/opensrspro.php

Release 3.2
- Added OpenSRS log to module
- Fixed formating issue in append_to_additionaldomainfields.txt file
- Fixed Client Area display errors due to language file
- Fixed Missing "Registrant Verification Status" checkbox in permission profiles

Changed Files: 
- /includes/additionaldomainfields.php
- /includes/append_to_additionaldomainfields.txt
- /includes/hooks/opensrspro_hooks.php

Release 3.1
- Fixed the .SE/.NE domain registration error "Invalid Legal_type"
- Fixed the blank DNS Management page in client area
- Transfer-in sync issue has been fixed (transfer status will update with daily cron)
- Added a "Check Transfer Status" button to Client Profile > Domains (manual check only)
- Fixed second level .NAME transfers and registrations
- Removed the getmypid() requirement

Changed Files: 
- /includes/additionaldomainfields.php
- /includes/append_to_additionaldomainfields.txt
- /modules/registrars/opensrspro/opensrspro.php
- /modules/registrar/tpl/clientareadomaindns.tpl
- /modules/registrars/opensrspro/opensrs/openSRS_ops.php
- /modules/registrars/opensrspro/opensrs/domains/provisioning/provSWregister.php


Release 3.0
- Ending support for WHMCS 5.x branch
- Fixed an issue where new TLDs would not be accepted as valid email addresses
- Fixed an issue where .NAME domains could not be registered as the API was expecting a forwarding_email address
- Fixed an issue with .BE registrations not completing

Changed Files:
- /includes/hooks/opensrspro_hooks.php
- /modules/registrars/opensrspro/opensrspro.php
- /modules/registrars/opensrspro/opensrs/domains/provisioning/provSWregister.php


Release 2.0.8
- Fixes an issue where viewing domain notes for a domain name would reload the domains tab
- Added Transfer, Modify contact details and Get EPP Code to ‘disable registrar commands’ admin role
- Fixed an issue that prevented the ability to remove the admin role ‘View Domain Notes’
- We will no longer be supporting 5.x branch after this release

Changed Files:
- /includes/hooks/opensrspro_hooks.php
- /modules/registrars/opensrspro/opensrspro.php


Release 2.0.7
- Fixed an issue where the logo would overlap some icons in the admin area
- Tested and working in WHMCS 6.x
- Updated the additional domain fields.txt file
- Notes are now viewable under the Domains tab when disabling registrar commands (Admin Roles: Disallow Registrar Operations will remove the ability to register and renew domains)
- Add SRV records via on demand TPL file - Weight/Port/Priority (beta)

Changed Files: 
- /includes/hooks/opensrspro_hooks.php
- /modules/registrars/opensrspro/tpl/ (upload entire folder as this is new)
- /modules/registrars/opensrspro/opensrspro.php


Release 2.0.6
- Reversed changes to .DE made in v2.0.4 as issue has now been fixed at OpenSRS
- Fixed .AU registrations
- Fixed a bug that prevented expired domains from renewing via WHMCS
- Fixed a bug that would send some test requests to the live server
- Removed some hard coded links for resellers using customized installation locations

Changed Files: 
- /modules/registrars/opensrspro/opensrspro.php 
- /modules/registrars/opensrspro/opensrs/domains/provisioning/provSWregister.php 
- /includes/hooks/opensrspro_hooks.php


Release 2.0.5
- Fixed an issue when registering .EU names causing this error “oSRS Error - eu_country is not defined, oSRS Error - owner_confirm_address is not defined, oSRS Error - Incorrect call”
- Removed requirements for .NL billing contact, allowing registrations to complete
- Fixed an issue where a .CA name registration would fail due to an incorrectly formatted phone number
- Added support for .SE/.NU


Release 2.0.4
- Temporary fix for .DE registrations (Fax # is required at this time)
- Added additional fields for .DE registrations (See append_to_additionaldomainfields.txt to enable .DE registrations)
- Domain notes are now viewable under the Domains tab
- Domain notes admin permission is available under the admin permissions page

Changed Files: 
- /modules/registrars/opensrspro/opensrspro.php 
- /modules/registrars/opensrspro/opensrs/domains/provisioning/provSWregister.php 
- /includes/append_to_additionaldomainfields.txt
- /includes/hooks/opensrspro_hooks.php


Release 2.0.3
- Fixed a bug that prevented .ASIA names from registering
- Fixed a bug that prevented .IT names from registering
- Fixed Admin permissions for ‘view registrant verification status’ in domains tab added to Admin Permissions page

Changed Files: 
- /modules/registrars/opensrspro/opensrspro.php 
- /modules/registrars/opensrspro/opensrs/domains/provisioning/provSWregister.php 
- /includes/hooks/opensrspro_hooks.php


Release 2.0.2
- Fixed a bug that prevented updating of admin/tech/billing contacts
- Fixed a bug that prevented deleting the last domain forwarder in DNS management
- Fixed a phone number formatting bug error message
- Admin permissions for ‘view registrant verification status’ in domains tab added to Admin Permissions page
- Fixed some DNS management issues with URL Frame and URL Redirect
- Added module log for domainsync.php to help track down reported issues

Changed Files: 
- modules/registrars/opensrspro/opensrspro.php
- includes/hooks/opensrspro_hooks.php


Release 2.0.1
- Fixed unlocking/locking bug
- Replace all files to upgrade except additionaldomainfields.php and english.php


Release 2.0
- Rewritten and updated the PHP Tool Kit
- Replace all files to upgrade to 2.0 except additionaldomainfields.php and english.php
- Known Issues - Locking/Unlocking does not work


Release 1.3.1
- Removed extra quote from language file
- Fixed dependency issues
- Replace entire folder contents in /modules/registrars/opensrspro/opensrs/
- Replace english language file if you are receiving syntax errors


Release 1.3
- Cleaned up the read me file
- Cleaned up PHP library files (removed files noted below)
- Added full support for registrant verification status and resending of emails (modified: /includes/hooks/opensrspro_customadminfields.php)
- Added support for additional new gTLDs (listed above) (modified append_to_whoisservers.php and append_to_additionaldomainfields.txt)
- To allow for availability checks for new TLDs, copy the contents of 'append_to_whoisservers.php' and place at the end of /includes/whoisservers.php file
- Modified Files: /includes/hooks/opensrspro_customadminfields.php, /modules/registrars/opensrspro/opensrspro.php, /modules/registrars/opensrspro/opensrs/openSRS_config.php, /modules/registrars/opensrspro/opensrs/openSRS_loader.php
- Removed: /modules/registrars/opensrspro/opensrs/mail/*, /modules/registrars/opensrspro/opensrs/plugins/*, /modules/registrars/opensrspro/opensrs/openSRS_mail.php


Release 1.2
- Fixed additional quote syntax error in language file
- Fixed read me file clarification issue
- Fixed a bug that caused expired domains to fail when renewing
- Removed ability to manage/order Contact Privacy from client side. Can only be added via built in WHMCS functionality manually.
- Custom template files/code has been removed. Please replace these files with the original WHMCS versions or remove the custom code that you have added for contact privacy.
- Modified files: Replace all files and remove template files


Release 1.1
- Fixed a bug that prevented admins from updating the contact information on domains
- Modified files: opensrspro.php 


Release 1.0
- Initial release