{*
 * IBrandBiz Comparison Order Form — viewcart.tpl
 * Shopping cart view with IBrandBiz styling
 *}

<link rel="stylesheet" type="text/css" href="{$WEB_ROOT}/templates/orderforms/{$carttpl}/style.css" />

<div id="order-premium_comparison" class="ibb-cart">

    <div class="row">
        <div class="col-md-8">

            <div class="header-lined">
                <h2>{lang key='cartreview'}</h2>
            </div>

            {if $errormessage}
                <div class="alert alert-danger" role="alert">
                    <p class="bold">{lang key='orderForm.correctErrors'}:</p>
                    <ul>
                        {$errormessage}
                    </ul>
                </div>
            {/if}

            {if $promotioncode && $rawdiscount neq "0.00"}
                <div class="alert alert-success" role="alert">
                    <i class="fas fa-check-circle"></i>
                    {lang key='orderForm.promotionCodeApplied'}: <strong>{$promotioncode}</strong> - {$discount}
                </div>
            {/if}

            <div class="panel panel-default">
                <div class="panel-body">

                    {if $cartitems == 0}
                        <div class="text-center">
                            <p>{lang key='cartEmpty'}</p>
                            <p>
                                <a href="{$WEB_ROOT}/cart.php" class="btn btn-primary ibb-btn">
                                    {lang key='orderForm.browsePlans'}
                                </a>
                            </p>
                        </div>
                    {else}
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>{lang key='orderForm.productDescription'}</th>
                                        <th class="text-center">{lang key='orderForm.billingCycle'}</th>
                                        <th class="text-right">{lang key='orderForm.priceCycle'}</th>
                                        <th>&nbsp;</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    {foreach $products as $item}
                                        <tr>
                                            <td>
                                                <strong>{$item.productname}</strong>
                                                {if $item.domain}
                                                    <br><small>{$item.domain}</small>
                                                {/if}
                                                {if $item.configoptions}
                                                    <br>
                                                    {foreach $item.configoptions as $configopt}
                                                        <small>- {$configopt.name}: {$configopt.value}</small><br>
                                                    {/foreach}
                                                {/if}
                                            </td>
                                            <td class="text-center">
                                                {$item.billingcycle}
                                            </td>
                                            <td class="text-right">
                                                {$item.pricingtext}
                                            </td>
                                            <td class="text-center">
                                                <a href="{$WEB_ROOT}/cart.php?a=remove&r={$item.id}" class="btn btn-danger btn-xs" data-testid="button-remove-{$item.id}">
                                                    <i class="fas fa-times"></i>
                                                </a>
                                            </td>
                                        </tr>
                                    {/foreach}
                                </tbody>
                            </table>
                        </div>

                        <div class="text-right">
                            <a href="{$WEB_ROOT}/cart.php?a=empty" class="btn btn-default">
                                {lang key='emptycart'}
                            </a>
                            <a href="{$WEB_ROOT}/cart.php?a=checkout" class="btn btn-success ibb-btn" data-testid="button-checkout">
                                {lang key='checkout'} <i class="fas fa-arrow-right"></i>
                            </a>
                        </div>
                    {/if}

                </div>
            </div>

            {if $promotioncode eq "" && $cartitems > 0}
                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h3 class="panel-title">{lang key='orderForm.havePromoCode'}</h3>
                    </div>
                    <div class="panel-body">
                        <form method="post" action="{$WEB_ROOT}/cart.php?a=view">
                            <div class="input-group">
                                <input type="text" name="promocode" class="form-control" placeholder="{lang key='orderForm.enterPromoCode'}" data-testid="input-promocode">
                                <span class="input-group-btn">
                                    <button type="submit" class="btn btn-primary ibb-btn" data-testid="button-apply-promo">
                                        {lang key='orderForm.apply'}
                                    </button>
                                </span>
                            </div>
                        </form>
                    </div>
                </div>
            {/if}

        </div>

        <div class="col-md-4">
            <div id="orderSummary" class="panel panel-default ibb-summary">
                <div class="panel-heading">
                    <h3 class="panel-title">{lang key='orderSummary'}</h3>
                </div>
                <div class="panel-body">
                    <div class="summary-container">
                        
                        {if $subtotal}
                            <div class="row">
                                <div class="col-xs-6">{lang key='orderForm.subTotal'}:</div>
                                <div class="col-xs-6 text-right">{$subtotal}</div>
                            </div>
                        {/if}

                        {if $discount neq "0.00"}
                            <div class="row text-success">
                                <div class="col-xs-6">{lang key='orderForm.discount'}:</div>
                                <div class="col-xs-6 text-right">-{$discount}</div>
                            </div>
                        {/if}

                        {if $taxtotal neq "0.00"}
                            <div class="row">
                                <div class="col-xs-6">{$taxname} ({$taxrate}%):</div>
                                <div class="col-xs-6 text-right">{$taxtotal}</div>
                            </div>
                        {/if}

                        <hr>

                        <div class="row total-row">
                            <div class="col-xs-6"><strong>{lang key='orderForm.total'}:</strong></div>
                            <div class="col-xs-6 text-right"><strong>{$total}</strong></div>
                        </div>

                        {if $totalrecurringmonthly || $totalrecurringannually}
                            <div class="row">
                                <div class="col-xs-12">
                                    <small class="text-muted">
                                        {if $totalrecurringmonthly}
                                            {lang key='orderForm.recurringEveryMonth'}: {$totalrecurringmonthly}
                                        {/if}
                                        {if $totalrecurringannually}
                                            <br>{lang key='orderForm.recurringEveryYear'}: {$totalrecurringannually}
                                        {/if}
                                    </small>
                                </div>
                            </div>
                        {/if}

                    </div>
                </div>
            </div>
        </div>
    </div>

</div>
