// Visual Template Types for AI Frameworks Builder V3

export interface SwotData {
  strengths: string[];
  weaknesses: string[];
  opportunities: string[];
  threats: string[];
}

export interface PersonaData {
  name: string;
  demographics: string;
  goals: string;
  frustrations: string;
  buyingTriggers: string;
}

export interface TamSamSomData {
  tam: string;
  sam: string;
  som: string;
  sources: string;
}

export interface PricingTierData {
  name: string;
  price: string;
  features: string[];
}

export type VisualTemplateType = 'swot' | 'persona' | 'tam-sam-som' | 'pricing';

export interface VisualTemplate {
  key: VisualTemplateType;
  name: string;
  description: string;
  icon: string;
}

// Default visual templates
export const VISUAL_TEMPLATES: VisualTemplate[] = [
  {
    key: 'swot',
    name: 'SWOT Analysis',
    description: 'Analyze strengths, weaknesses, opportunities, and threats',
    icon: '🎯'
  },
  {
    key: 'persona',
    name: 'Customer Persona',
    description: 'Define your target customer profile',
    icon: '👤'
  },
  {
    key: 'tam-sam-som',
    name: 'TAM/SAM/SOM',
    description: 'Market sizing analysis framework',
    icon: '📊'
  },
  {
    key: 'pricing',
    name: 'Pricing Table',
    description: 'Structure your pricing tiers and features',
    icon: '💰'
  }
];

// Default data structures for initialization
export const DEFAULT_SWOT_DATA: SwotData = {
  strengths: [],
  weaknesses: [],
  opportunities: [],
  threats: []
};

export const DEFAULT_PERSONA_DATA: PersonaData = {
  name: '',
  demographics: '',
  goals: '',
  frustrations: '',
  buyingTriggers: ''
};

export const DEFAULT_TAM_SAM_SOM_DATA: TamSamSomData = {
  tam: '',
  sam: '',
  som: '',
  sources: ''
};

export const DEFAULT_PRICING_TIERS: PricingTierData[] = [
  {
    name: 'Basic',
    price: '$0/month',
    features: []
  },
  {
    name: 'Pro',
    price: '$49/month',
    features: []
  },
  {
    name: 'Enterprise',
    price: 'Contact us',
    features: []
  }
];