// Theme system types for Cover Design

export type CoverStyle = "gradient" | "minimal" | "photo" | "pattern";

export interface CoverTheme {
  id: string;
  name: string;
  style: CoverStyle;
  colors: {
    primary: string;
    secondary: string;
    accent?: string;
    text: string;
    background: string;
  };
  gradients?: {
    background?: string;
    overlay?: string;
  };
  typography: {
    titleFont: string;
    subtitleFont: string;
    titleSize: string;
    subtitleSize: string;
    titleWeight: string;
    subtitleWeight: string;
  };
  effects?: {
    blur?: boolean;
    opacity?: number;
    pattern?: string;
  };
}

export interface CoverConfig {
  title: string;
  subtitle?: string;
  logoUrl?: string;
  theme: CoverTheme;
}

export interface CoverExportOptions {
  width?: number;
  height?: number;
  scale?: number;
  format?: "png" | "jpg";
}