// TypeScript types for Business Plan Outline & Sections
export type SectionId = string;

export type SectionKind =
  | "executive-summary"
  | "company-overview"
  | "products-services"
  | "market-analysis"
  | "marketing-sales"
  | "operations-plan"
  | "org-management"
  | "financial-plan"
  | "milestones-roadmap"
  | "future-expansion"
  | "partnerships-note"
  | "exit-strategy"
  | "custom";

export interface PlanSection {
  id: SectionId;
  kind: SectionKind;
  title: string;
  content: string; // markdown
  isOptional?: boolean; // true for optional sections like exit-strategy
  isEnabled?: boolean; // false means hidden from preview/export
  sortIndex?: number; // for preserving order
  lastUpdated?: string; // ISO timestamp
  savedAt?: string; // ISO timestamp for last save
  children?: PlanSection[]; // subsections (outline tree)
}

export interface TemplateField {
  id: string;
  label: string;
  type: "text" | "textarea" | "number" | "select";
  placeholder?: string;
  options?: string[]; // for select
}

export interface StructuredTemplate {
  key: "swot" | "persona" | "porter5";
  name: string;
  description: string;
  fields: TemplateField[];
}

export interface BusinessBrief {
  company?: string;
  industry?: string;
  businessModel?: string;
  productsServices?: string;
  offeringsFull?: string;
  market?: string;
  differentiator?: string;
  financialHeadline?: string;
}

export interface PlanState {
  planId: string;
  title: string;
  planTitleManuallyEdited?: boolean;
  businessBrief?: BusinessBrief;
  sections: PlanSection[];
}

// AI Integration types
export interface OutlineSuggestion {
  sections: {
    title: string;
    bullets: string[];
  }[];
}

export type ToneOption = "Professional" | "Friendly" | "Bold" | "Minimal";