// Default template content for each Business Plan section
// These are neutral, industry-agnostic starter templates with {{placeholder}} variables

export const SECTION_TEMPLATES: Record<string, string> = {
  "executive-summary": `**Company:** {{CompanyName}}
**Model:** {{BusinessModel}}
**Problem:** {{ProblemStatement}}
**Solution:** {{OneLineSolution}}
**Offerings:** {{ProductsServicesSummary}}
**Market:** {{TargetMarket}} | **Edge:** {{Differentiator}}
**Traction (optional):** {{TractionHighlights}}
**Financials (3-yr):** Rev {{Rev3yr}}, Profit {{Profit3yr}}
**Ask (optional):** {{FundingAsk}} to {{UseOfFunds}}.`,

  "company-overview": `**Mission:** {{Mission}}
**Vision:** {{Vision}}
**Value Proposition:** {{ValueProp}}
**Background/Origin:** {{FoundingStory}}
**Legal Structure & Location:** {{EntityType}}, based in {{Location}}, serving {{Geography}}.
**Current Status:** {{CurrentStage}} (MVP/LA/Scaling).`,

  "products-services": `**Core Offerings:**

- **{{Offering1}}** — {{Offering1Desc}}
- **{{Offering2}}** — {{Offering2Desc}}
- **{{Offering3}}** — {{Offering3Desc}}

**Tiers/Pricing (optional):**

- **{{Tier1}}:** {{Tier1Price}} / {{BillingCycle}}
- **{{Tier2}}:** {{Tier2Price}} / {{BillingCycle}}
- **{{Tier3}}:** {{Tier3Price}} / {{BillingCycle}}

**Benefits:** {{KeyBenefitsList}}
**Roadmap Highlights:** {{ProductRoadmapBlurb}}`,

  "market-analysis": `**Target Customers:** {{ICP}}
**Market Size:** TAM {{TAM}}, SAM {{SAM}}, SOM {{SOM}}.
**Trends:** {{KeyTrends}}
**Competitors:** {{CompetitorA}}, {{CompetitorB}}, {{CompetitorC}}
**Differentiation:** {{DifferentiationPoints}}

**SWOT:**

- **S:** {{Strengths}}
- **W:** {{Weaknesses}}
- **O:** {{Opportunities}}
- **T:** {{Threats}}`,

  "marketing-sales": `**Positioning:** {{PositioningStatement}}
**Channels:** {{ChannelsList}} (e.g., SEO, content, ads, affiliates, partnerships).
**Funnel:** {{TopFunnel}} → {{MidFunnel}} → {{BottomFunnel}}
**Pricing & Offers:** {{PricingNotes}}
**Retention:** {{RetentionTactics}} (onboarding, support, lifecycle emails).
**KPIs:** {{PrimaryKPIs}} (CAC, LTV, MRR, churn).`,

  "operations-plan": `**Tech/Infra:** {{TechStack}} | **Hosting:** {{HostingInfra}} | **Data:** {{DataPolicies}}
**Processes:** {{CoreProcesses}} (support, releases, QA, billing).
**Vendors/Tools:** {{VendorsTools}}
**SLAs & Security:** {{SLA_Security}}
**KPIs:** {{OpsKPIs}} (uptime, response time, ticket SLA).`,

  "org-management": `**Leadership:**

- **Founder & CEO:** {{FounderName}} – {{FounderBioShort}}
- **Strategic AI Partner:** Nova AI — Co-Founder / Operations & Data Intelligence (embedded AI system for strategy, analysis, and operations).

**Team (now):** {{CurrentTeam}}
**Hiring Plan:** {{HiringPlan}} (roles, timing).
**Advisors (optional):** {{Advisors}}`,

  "financial-plan": `**Revenue Streams:** {{RevStreams}} (subscriptions, hosting, domains, templates).
**Assumptions:** {{KeyFinancialAssumptions}}
**Forecast:** {{ForecastSummary}} (Launch {{Year0/Qtrs}}, Growth {{Year1}}, Scale {{Year2}}).
**Break-Even:** {{BreakEvenNote}}
**Funding (optional):** Seeking {{FundingAsk}} to fund {{UseOfFunds}}.
**Risks & Mitigations:** {{FinancialRisks}}`,

  "milestones-roadmap": `**Launch ({{LaunchQuarterYear}}):** {{LaunchMilestones}}

**Growth ({{Year1}}):** {{GrowthMilestones}}

**Scale ({{Year2}}):** {{ScaleMilestones}}

**Beyond:** {{BeyondMilestones}}`,

  "future-expansion": `**Ecosystem Fit:** {{EcosystemContext}}
**Planned Integrations/Products:** {{FutureIntegrations}}
**Partnerships & Channels:** {{PlannedPartnerships}}
**Long-Term Vision:** {{LongTermVision}}`,

  "partnerships-note": `**Why Partners:** {{PartnerRationale}}
**Partner Types:** {{PartnerTypes}} (agencies, resellers, platforms).
**Criteria:** {{PartnerCriteria}} (quality, SLAs, alignment).
**Engagement Model:** {{PartnerModel}} (referrals, rev-share, white-label).
**Customer Benefit:** {{CustomerBenefit}}`,

  "exit-strategy": `**Primary Path:** {{ExitPrimary}} (e.g., acquisition by {{BuyerType}}).
**Alternatives:** {{ExitAlternatives}} (IPO, remain private w/ strategic capital).
**Timing/Triggers:** {{ExitTriggers}} (revenue, EBITDA, growth rate).
**Value Narrative:** {{ExitValueStory}}.`,
};

// Placeholder content for migration of existing plans
export const MIGRATION_PLACEHOLDERS: Record<string, string> = {
  "milestones-roadmap": "This plan includes a phased roadmap covering launch, growth, and scale milestones. Customize key dates and deliverables here.",

  "future-expansion": "Outline how this business expands into adjacent products, integrations, and channels over 2–3 years.",

  "partnerships-note": "Partnerships will complement core offerings (criteria, types, and engagement model to be finalized).",

  "exit-strategy": "Optional investor-only section describing potential exit paths and value story.",
};
