// Shared TypeScript types for Finance functionality
export type Currency = "USD" | "EUR" | "GBP" | "CAD" | "AUD";

export interface FinanceInputs {
  currency: Currency;
  startMonth: string; // YYYY-MM (e.g., "2025-10")
  pricePerUnit: number; // average selling price
  unitsPerMonth: number[]; // length 12, units sold per month
  cogsPercent: number; // 0..100
  fixedMonthlyExpenses: number; // rent, tools, etc.
  variableExpensePerUnit?: number; // optional extra variable cost
  startingCash?: number; // for runway calc
}

export interface MonthlyRow {
  month: string; // e.g., "Oct 2025"
  revenue: number;
  cogs: number;
  grossProfit: number;
  opex: number; // fixedMonthlyExpenses
  profit: number; // grossProfit - opex
  cumulativeProfit: number;
}

export interface FinanceOutputs {
  rows: MonthlyRow[]; // 12 months
  totalRevenue: number;
  totalProfit: number;
  breakevenMonthIndex: number | null; // 0..11 or null
  runwayMonths: number | null; // if startingCash provided
}

// V2 Enhancements
export interface ExpenseRow {
  id: string;
  name: string;
  amount: number;
}

export interface FinanceInputsV2 extends FinanceInputs {
  expenses: ExpenseRow[];
}

export interface MonthlyRowV2 extends MonthlyRow {
  endingCash: number; // for cash flow analysis
}

export interface FinanceOutputsV2 extends FinanceOutputs {
  rows: MonthlyRowV2[];
  cashFlowAnalysis: {
    startingCash: number;
    lowestCash: number;
    lowestCashMonth: number;
    endingCash: number;
  };
}