export interface BrandKit {
  name?: string;
  primary: string;   // hex color code
  secondary?: string; // hex color code
  accent?: string;   // hex color code
  logoUrl?: string;
  fontHead?: string; // CSS font stack for headings
  fontBody?: string; // CSS font stack for body text
}

export const DEFAULT_BRAND_KIT: BrandKit = {
  name: "IBrandBiz",
  primary: "#6D28D9",      // Purple - IBrandBiz brand color
  secondary: "#06B6D4",    // Cyan - Complementary color
  accent: "#F59E0B",       // Amber - Accent color
  logoUrl: "",
  fontHead: "Inter, ui-sans-serif, system-ui, -apple-system, BlinkMacSystemFont, sans-serif",
  fontBody: "Inter, ui-sans-serif, system-ui, -apple-system, BlinkMacSystemFont, sans-serif",
};