// AI Writing Assistant types for AI Frameworks Builder

// Re-export tone option from plan-types for consistency
export type { ToneOption } from "./plan-types";

// Length options for content generation
export type LengthOption = "Short" | "Standard" | "Long";

// AI Actions available for content generation and editing
export type AiAction = 
  | "generate"    // Generate new content from scratch
  | "rephrase"    // Rephrase existing content in different tone
  | "expand"      // Expand content with more details
  | "summarize";  // Summarize content to make it more concise

// AI job request structure for API calls
export interface AiJob {
  action: AiAction;
  tone?: ToneOption;          // Tone preference (defaults to Professional)
  length?: LengthOption;      // Content length preference (defaults to Standard)
  sectionKind: string;        // Business plan section type (e.g., 'executive-summary')
  sectionTitle: string;       // Human-readable section title
  existingContent?: string;   // Current content for rephrase/expand/summarize
  userPrompt?: string;        // Optional user-provided instructions for this section
  context?: {
    businessName?: string;    // Business name for context
    industry?: string;        // Industry for relevant content
    description?: string;     // Brief business description
    businessBrief?: any;      // Complete business brief for context
  };
}

// AI response structure from API
export interface AiResponse {
  success: boolean;
  content?: string;           // Generated/modified content
  error?: string;             // Error message if failed
  usage?: {
    tokens: number;           // Tokens used for the request
    model: string;            // AI model used
  };
}

// AI job status for loading states
export type AiJobStatus = "idle" | "loading" | "success" | "error";

// Error types for AI operations
export type AiError = 
  | "api_key_missing"
  | "rate_limit_exceeded" 
  | "invalid_request"
  | "service_unavailable"
  | "unknown_error";

// AI service configuration
export interface AiConfig {
  model: string;
  maxTokens: number;
  temperature: number;
}