import fs from 'fs';
import path from 'path';

let buildInfo: { sha: string; time: string; env: string } | null = null;

// Try to load build-info.json if it exists (production)
try {
  const buildInfoPath = path.join(process.cwd(), 'dist', 'build-info.json');
  if (fs.existsSync(buildInfoPath)) {
    buildInfo = JSON.parse(fs.readFileSync(buildInfoPath, 'utf-8'));
  }
} catch (e) {
  // Ignore - will use runtime values
}

export const BUILD = buildInfo || {
  sha: process.env.REPL_SLUG || process.env.GIT_COMMIT || new Date().getTime().toString(36),
  time: new Date().toISOString(),
  env: process.env.NODE_ENV || "development",
};
