// Job system initialization
import { jobQueue } from './jobQueue';
import { registerDomainWorker } from './registerDomain';

// Register all job workers
jobQueue.registerWorker('registerDomain', registerDomainWorker);

console.log('🚀 Job system initialized with workers:');
console.log('  - registerDomain: Domain registration processing');

// Export the job queue for use in other parts of the application
export { jobQueue };
export type { Job } from './jobQueue';
export type { DomainRegistrationJobData } from './registerDomain';