import { initializeApp, getApps, getApp, App } from "firebase-admin/app";
import { getStorage } from "firebase-admin/storage";
import { getFirestore } from "firebase-admin/firestore";
import { cert } from "firebase-admin/app";

const STORAGE_BUCKET = process.env.FB_STORAGE_BUCKET || "ibrandbiz-bcfbe.firebasestorage.app";

/**
 * Single Firebase Admin initialization point
 * SN's specification: Initialize ONCE with storageBucket to set the default
 */
function initializeFirebaseAdmin(): App {
  if (getApps().length > 0) {
    return getApp();
  }

  const serviceAccount = process.env.FIREBASE_SERVICE_ACCOUNT_KEY;
  if (!serviceAccount) {
    throw new Error("FIREBASE_SERVICE_ACCOUNT_KEY environment variable not set");
  }

  const serviceAccountData = JSON.parse(serviceAccount);
  
  const app = initializeApp({
    credential: cert(serviceAccountData),
    storageBucket: STORAGE_BUCKET
  });

  console.log("[Admin] Storage bucket:", STORAGE_BUCKET);
  
  return app;
}

// Export singleton instances
export const adminApp = initializeFirebaseAdmin();
// Explicitly pass bucket name to override any cached default (SN's bulletproof method)
export const bucket = getStorage(adminApp).bucket(STORAGE_BUCKET);
export const db = getFirestore(adminApp);

// Safety log
console.log("[Admin] Storage bucket bound to:", bucket.name);
