import { DomainSearchHit, RegistrantContact, DomainRegistrationResult } from "@shared/schema";

export interface DomainSearchInput {
  query: string;
  tlds?: string[]; // Optional TLD filter like ['.com', '.net', '.io']
}

export interface RegisterInput {
  domain: string;
  years: number;
  contact: RegistrantContact;
  privacy: boolean;
  nameservers?: string[];
}

export interface Registrar {
  /**
   * Search for domain availability and pricing
   */
  search(input: DomainSearchInput): Promise<DomainSearchHit[]>;

  /**
   * Register a domain
   */
  register(input: RegisterInput): Promise<DomainRegistrationResult>;

  /**
   * Check if the registrar is properly configured and available
   */
  isConfigured(): boolean;

  /**
   * Get supported TLDs and their pricing
   */
  getSupportedTlds(): Promise<{ tld: string; priceCents: number; }[]>;
}

export interface RegistrarConfig {
  mode: 'test' | 'live';
  baseUrl: string;
  credentials: {
    username: string;
    key: string;
  };
  defaultNameservers?: string[];
  defaultYears?: number;
}