// server/domains/models.ts
export type DomainOrderStatus =
  | "pending"        // user created order pre-checkout
  | "checkout_open"  // user redirected to Stripe
  | "paid"           // stripe paid, job queued
  | "registering"    // in-flight with OpenSRS
  | "active"         // registered
  | "failed";        // registration failed

export type DomainOrder = {
  id: string;                 // uuid
  userId: string;
  domain: string;             // "cafemojo.com"
  years: number;              // 1
  privacy: boolean;           // whois privacy
  priceCents: number;         // retail price we charge
  currency: string;           // "USD"
  status: DomainOrderStatus;
  stripeSessionId?: string;
  provider?: "opensrs";
  providerRegId?: string;     // returned from OpenSRS
  errorMessage?: string;
  createdAt: Date;
  updatedAt: Date;
  // registrant contact (simplified)
  contact: {
    first: string; last: string; email: string; phone: string;
    address1: string; city: string; state: string; postal: string; country: string;
    org?: string;
  };
};