const Stripe = require("stripe");
const stripe = new Stripe(process.env.STRIPE_SECRET_KEY, { apiVersion: "2024-06-20" });

async function setMeta(lookupKey, meta) {
  const price = (await stripe.prices.list({ lookup_keys: [lookupKey] })).data[0];
  if (!price) throw new Error(`Missing price for ${lookupKey}`);
  await stripe.prices.update(price.id, { metadata: meta });
  console.log(`Updated ${lookupKey}`, meta);
}

(async () => {
  await setMeta("stock_starter_mo", { downloads_included: "5", tier: "starter" });
  await setMeta("stock_pro_mo", { downloads_included: "10", tier: "pro" });
  await setMeta("stock_agency_mo", { downloads_included: "25", tier: "agency" });
  await setMeta("ibrandbiz_pro_monthly", { downloads_included: "5", bundle: "core_pro" });
})();