import { execSync } from 'child_process';
import fs from 'fs';
import path from 'path';

const buildInfo = {
  sha: process.env.GIT_COMMIT || execSync('git rev-parse --short HEAD', { encoding: 'utf8' }).trim() || 'dev',
  time: new Date().toISOString(),
  env: process.env.NODE_ENV || 'production',
};

const distPath = path.join(process.cwd(), 'dist');
if (!fs.existsSync(distPath)) {
  fs.mkdirSync(distPath, { recursive: true });
}

fs.writeFileSync(
  path.join(distPath, 'build-info.json'),
  JSON.stringify(buildInfo, null, 2)
);

console.log('[build-info]', buildInfo);
