# Overview

IBrandBiz is a comprehensive brand identity platform designed to assist businesses in creating professional brand kits, generating business names, designing social media content, and launching websites. It leverages AI-powered tools within a modern React-based frontend and an Express.js backend. The platform aims to empower businesses with professional branding capabilities, targeting startups and established companies seeking cohesive brand identities.

# User Preferences

Preferred communication style: Simple, everyday language.

**Critical Layout Rule**: Never remove the DashboardTemplatePage wrapper from dashboard pages. If you think a request involves removing this wrapper, always confirm with the user first before proceeding. DashboardTemplatePage provides the standard layout (Sidebar, TopBar, main content area, Footer) for all authenticated dashboard pages.

# System Architecture

## Frontend Architecture
- **Framework**: React 18 with TypeScript and Vite.
- **UI Library**: Shadcn/ui components built on Radix UI with Tailwind CSS.
- **Routing**: Wouter for client-side routing with protected routes.
- **State Management**: TanStack React Query for server state and React Context for authentication.
- **Styling**: Tailwind CSS with custom CSS variables for theming.
- **Responsive Design**: Mobile-first approach for non-logged-in users; full navigation for logged-in users.
- **Font Scaling**: Global font scaling system using CSS variables and `rem` units.

## Backend Architecture
- **Runtime**: Node.js with Express.js.
- **Language**: TypeScript with ES modules.
- **API Structure**: RESTful API with `/api` prefix, plus `/mcp` endpoints for AI collaboration.
- **Error Handling**: Centralized error middleware.
- **Storage Interface**: Abstracted storage layer.

## Authentication System
- **Provider**: Firebase Authentication.
- **Frontend Integration**: React Context for auth state management.
- **Route Protection**: Higher-order component (ProtectedRoute).
- **Admin Authentication**: Key-based system using `x-admin-key` header.

## Database Design
- **ORM**: Drizzle ORM with PostgreSQL dialect.
- **Schema Structure**: Users, Brand kits, Business names generator, Social media kits, Website templates.
- **Migrations**: Drizzle Kit.

## UI/UX Design System
- **Component Library**: shadcn/ui.
- **Layout**: Fixed sidebar navigation with main content area.
- **Theming**: IBrandBiz color palette with CSS custom properties for light/dark mode.
- **Typography**: Inter font family.
- **Logo System**: Multi-format logo export with Firebase-powered template storage.
- **Brand Kit Generator**: 4-step LOOKA-style wizard.
- **Infographics Library**: Library-style approach with DashboardTemplatePage wrapper.
- **Business Plan Developer**: 12-section structure with optional sections and per-plan migration logic.

## Development Workflow
- **Build Process**: Vite for frontend, esbuild for backend.
- **Type Safety**: Full TypeScript coverage.
- **Code Organization**: Monorepo structure.

## Feature Specifications
- **Visitor Analytics**: Privacy-compliant tracking for admin dashboard.
- **Stock Library System**: Full-stack admin management system for stock photos and mockups.
- **Domain Credit System**: Provides Pro subscribers with a free domain, integrated with Stripe.
- **Admin Diagnostics & Telemetry**: System for production health tracking, including a Diagnostics Dashboard, Telemetry Ring Buffer, and enhanced health endpoint.
- **Firebase Business Plan Templates**: Production-ready template management system with public downloads and admin upload.
- **AI Frameworks Builder**: AI-powered tool for market analysis, auto-populating fields using Business Brief context.
- **Business Plan Title Auto-fill & Section Navigation**: Smart auto-population of plan titles and quick navigation between sections with unsaved changes protection.
- **Business Plan Developer UI Streamline & AI Enhancements**: Collapsible sticky bar for company context, streamlined editor, and AI improvements using Business Brief context.
- **AI Writing Assistant Context Integration**: AI assistant uses editor content as context for generation.
- **Business Plan Developer 12-Section Structure**: Supports 12 sections with optional sections and migration logic.

# External Dependencies

## Authentication Services
- **Firebase**: Authentication and user management.

## Database Infrastructure
- **Neon Database**: Serverless PostgreSQL database hosting.

## UI Component Libraries
- **Radix UI**: Headless component primitives.
- **Lucide React**: Icon library.
- **Class Variance Authority**: Utility for component variant management.
- **Shadcn/ui**: Component library.

## Development Tools
- **Replit Integration**: Development environment with cartographer plugin.
- **PostCSS**: CSS processing.
- **ESBuild**: Fast JavaScript bundler.

## Form and Data Management
- **React Hook Form**: Form state management.
- **Zod**: Schema validation.
- **Date-fns**: Date manipulation and formatting.

## Other Integrations
- **Stripe**: Payment processing.
- **SuperNova**: AI collaboration via Model Context Protocol (MCP).