# IBrandBiz MCP Server Setup

## Files Ready for New Repl:
1. `mcp-server.js` - Main server file ✅
2. `mcp-package.json` - Package configuration ✅  
3. `Procfile` - Deployment configuration ✅

## Replit Secrets to Configure:
```
MCP_BEARER_TOKEN = super-long-random-string-here
GITHUB_TOKEN = your-github-personal-access-token
REPO_OWNER = your-github-username
REPO_NAME = ibrandbiz
APP_LOG = logs/app.log
```

## Deployment Steps:
1. Create new Repl: `ibrandbiz-mcp`
2. Copy files: `mcp-server.js`, rename `mcp-package.json` to `package.json`, `Procfile`
3. Set Replit Secrets (above)
4. Run `npm install` then `npm start`
5. Note the public URL: `https://ibrandbiz-mcp.your-username.repl.co`

## SuperNova Integration:
- Base URL: `https://ibrandbiz-mcp.your-username.repl.co`
- Auth: Bearer token (use MCP_BEARER_TOKEN)
- Endpoints: `/run`, `/logs/tail`, `/files/read`, `/files/write`, `/env/get`, `/env/set`, `/repo/pr`, `/ping`

## First Demo Commands:
1. `GET /ping` - Verify connection
2. `POST /run` `{"cmdKey": "typecheck"}` - Check repo health  
3. `POST /files/read` `{"path": "src/pages/BusinessName.tsx"}` - Read current wizard