var __defProp = Object.defineProperty;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __esm = (fn, res) => function __init() {
  return fn && (res = (0, fn[__getOwnPropNames(fn)[0]])(fn = 0)), res;
};
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};

// shared/schema.ts
import { sql } from "drizzle-orm";
import { pgTable, pgEnum, text, varchar, timestamp, jsonb, boolean, integer, numeric, unique, index, check } from "drizzle-orm/pg-core";
import { createInsertSchema } from "drizzle-zod";
import { z } from "zod";
var CANCELLATION_REASONS, CANCELLATION_REASON_VALUES, DOMAIN_CREDIT_STATUSES, DOMAIN_CREDIT_STATUS_VALUES, COVER_TEMPLATE_CATEGORIES, COVER_TEMPLATE_CATEGORY_VALUES, COVER_TEMPLATE_TOP_TIERS, COVER_TEMPLATE_TOP_TIER_VALUES, COVER_TEMPLATE_APPROVAL_STATUSES, COVER_TEMPLATE_APPROVAL_STATUS_VALUES, COVER_PURCHASE_STATUSES, COVER_PURCHASE_STATUS_VALUES, CREATOR_MIN_PRICE_CENTS, CREATOR_MAX_PRICE_CENTS, CREATOR_ONBOARDING_STATUSES, CREATOR_ONBOARDING_STATUS_VALUES, CREATOR_APPROVAL_STATUSES, CREATOR_APPROVAL_STATUS_VALUES, CREATOR_EARNING_TYPES, CREATOR_EARNING_TYPE_VALUES, CREATOR_PAYOUT_STATUSES, CREATOR_PAYOUT_STATUS_VALUES, creatorOnboardingStatusEnum, creatorApprovalStatusEnum, creatorEarningTypeEnum, creatorPayoutStatusEnum, coverTemplateCategoryEnum, coverTemplateTopTierEnum, coverTemplateApprovalStatusEnum, coverPurchaseStatusEnum, users, brandKits, businessNames, socialMediaKits, templateCategories, templateConfigurations, templateContent, userTemplateCustomizations, templateAssets, websiteTemplates, notifications, cancellations, pauses, auditLogs, domainOrders, domainCredits, domains, importedIcons, visitorSessions, dailyVisitorStats, cartItems, purchases, userEntitlements, creators, assets, creatorAssets, creatorEarnings, coverTemplates, coverPurchases, infographicTemplates, infographicPurchases, presentationTemplates, presentationPurchases, insertUserSchema, insertBrandKitSchema, insertBusinessNameSchema, insertSocialMediaKitSchema, insertWebsiteTemplateSchema, insertTemplateCategorySchema, insertTemplateConfigurationSchema, insertTemplateContentSchema, insertUserTemplateCustomizationSchema, insertTemplateAssetSchema, insertNotificationSchema, insertCancellationSchema, insertPauseSchema, insertDomainOrderSchema, insertDomainCreditSchema, insertDomainSchema, insertImportedIconSchema, insertVisitorSessionSchema, insertDailyVisitorStatsSchema, insertCartItemSchema, insertPurchaseSchema, insertUserEntitlementSchema, insertCreatorSchema, insertAssetSchema, insertCreatorAssetSchema, insertCreatorEarningSchema, insertCoverTemplateSchema, insertCoverPurchaseSchema, insertInfographicTemplateSchema, insertInfographicPurchaseSchema, insertPresentationTemplateSchema, insertPresentationPurchaseSchema;
var init_schema = __esm({
  "shared/schema.ts"() {
    "use strict";
    CANCELLATION_REASONS = {
      TOO_EXPENSIVE: "Too expensive",
      DIDNT_GET_VALUE: "Didn't get value",
      MISSING_FEATURE: "Missing feature",
      TECHNICAL_ISSUES: "Technical issues",
      TEMPORARY_PAUSE: "Temporary pause",
      OTHER: "Other"
    };
    CANCELLATION_REASON_VALUES = Object.values(CANCELLATION_REASONS);
    DOMAIN_CREDIT_STATUSES = {
      AVAILABLE: "available",
      USED: "used",
      EXPIRED: "expired",
      REVOKED: "revoked"
    };
    DOMAIN_CREDIT_STATUS_VALUES = Object.values(DOMAIN_CREDIT_STATUSES);
    COVER_TEMPLATE_CATEGORIES = {
      BUSINESS: "business",
      CREATIVE: "creative",
      MINIMAL: "minimal",
      MODERN: "modern",
      PROFESSIONAL: "professional"
    };
    COVER_TEMPLATE_CATEGORY_VALUES = Object.values(COVER_TEMPLATE_CATEGORIES);
    COVER_TEMPLATE_TOP_TIERS = {
      FIG: "FIG",
      TMT: "TMT",
      HEALTHCARE_PHARMA: "Healthcare/Pharma",
      GENERAL: "General"
    };
    COVER_TEMPLATE_TOP_TIER_VALUES = Object.values(COVER_TEMPLATE_TOP_TIERS);
    COVER_TEMPLATE_APPROVAL_STATUSES = {
      PENDING: "pending",
      APPROVED: "approved",
      REJECTED: "rejected"
    };
    COVER_TEMPLATE_APPROVAL_STATUS_VALUES = Object.values(COVER_TEMPLATE_APPROVAL_STATUSES);
    COVER_PURCHASE_STATUSES = {
      PENDING: "pending",
      PAID: "paid",
      DELIVERED: "delivered",
      FAILED: "failed"
    };
    COVER_PURCHASE_STATUS_VALUES = Object.values(COVER_PURCHASE_STATUSES);
    CREATOR_MIN_PRICE_CENTS = 199;
    CREATOR_MAX_PRICE_CENTS = 4999;
    CREATOR_ONBOARDING_STATUSES = {
      PENDING: "pending",
      IN_PROGRESS: "in_progress",
      COMPLETED: "completed",
      REJECTED: "rejected"
    };
    CREATOR_ONBOARDING_STATUS_VALUES = Object.values(CREATOR_ONBOARDING_STATUSES);
    CREATOR_APPROVAL_STATUSES = {
      PENDING: "pending",
      APPROVED: "approved",
      REJECTED: "rejected",
      CANCELLED: "cancelled"
    };
    CREATOR_APPROVAL_STATUS_VALUES = Object.values(CREATOR_APPROVAL_STATUSES);
    CREATOR_EARNING_TYPES = {
      SALE: "sale",
      COMMISSION: "commission",
      BONUS: "bonus",
      PAYOUT: "payout"
    };
    CREATOR_EARNING_TYPE_VALUES = Object.values(CREATOR_EARNING_TYPES);
    CREATOR_PAYOUT_STATUSES = {
      PENDING: "pending",
      PROCESSING: "processing",
      PAID: "paid",
      FAILED: "failed"
    };
    CREATOR_PAYOUT_STATUS_VALUES = Object.values(CREATOR_PAYOUT_STATUSES);
    creatorOnboardingStatusEnum = pgEnum("creator_onboarding_status", CREATOR_ONBOARDING_STATUS_VALUES);
    creatorApprovalStatusEnum = pgEnum("creator_approval_status", CREATOR_APPROVAL_STATUS_VALUES);
    creatorEarningTypeEnum = pgEnum("creator_earning_type", CREATOR_EARNING_TYPE_VALUES);
    creatorPayoutStatusEnum = pgEnum("creator_payout_status", CREATOR_PAYOUT_STATUS_VALUES);
    coverTemplateCategoryEnum = pgEnum("cover_template_category", COVER_TEMPLATE_CATEGORY_VALUES);
    coverTemplateTopTierEnum = pgEnum("cover_template_top_tier", COVER_TEMPLATE_TOP_TIER_VALUES);
    coverTemplateApprovalStatusEnum = pgEnum("cover_template_approval_status", COVER_TEMPLATE_APPROVAL_STATUS_VALUES);
    coverPurchaseStatusEnum = pgEnum("cover_purchase_status", COVER_PURCHASE_STATUS_VALUES);
    users = pgTable("users", {
      id: varchar("id").primaryKey().default(sql`gen_random_uuid()`),
      firebaseUid: text("firebase_uid").notNull().unique(),
      email: text("email").notNull().unique(),
      displayName: text("display_name").notNull(),
      company: text("company"),
      avatarUrl: text("avatar_url"),
      isPaid: boolean("is_paid").default(false),
      role: text("role").default("user"),
      createdAt: timestamp("created_at").defaultNow(),
      proActivatedAt: timestamp("pro_activated_at"),
      proWelcomeDismissed: boolean("pro_welcome_dismissed").default(false),
      subscriptionStatus: text("subscription_status"),
      pausedAt: timestamp("paused_at", { withTimezone: true }),
      resumeAt: timestamp("resume_at", { withTimezone: true }),
      // TOTP (Two-Factor Authentication) fields
      totpSecret: text("totp_secret"),
      // Encrypted TOTP secret key
      totpEnabled: boolean("totp_enabled").default(false),
      // Whether TOTP is enabled
      totpBackupCodes: text("totp_backup_codes").array(),
      // Array of backup recovery codes
      // Quota tracking fields for subscription download limits
      monthlyDownloadQuota: integer("monthly_download_quota").default(0),
      // Max downloads per month based on subscription
      currentMonthDownloads: integer("current_month_downloads").default(0),
      // Downloads used this month
      quotaResetDate: timestamp("quota_reset_date", { withTimezone: true }),
      // When quota resets (monthly cycle)
      subscriptionLookupKey: text("subscription_lookup_key")
      // Current subscription's lookup_key for quota mapping
    });
    brandKits = pgTable("brand_kits", {
      id: varchar("id").primaryKey().default(sql`gen_random_uuid()`),
      userId: varchar("user_id").notNull().references(() => users.id),
      name: text("name").notNull(),
      businessName: text("business_name"),
      industry: text("industry"),
      personality: text("personality"),
      colors: jsonb("colors"),
      createdAt: timestamp("created_at").defaultNow(),
      updatedAt: timestamp("updated_at").defaultNow()
    });
    businessNames = pgTable("business_names", {
      id: varchar("id").primaryKey().default(sql`gen_random_uuid()`),
      userId: varchar("user_id").notNull().references(() => users.id),
      name: text("name").notNull(),
      industry: text("industry"),
      keywords: text("keywords"),
      isSaved: boolean("is_saved").default(false),
      createdAt: timestamp("created_at").defaultNow()
    });
    socialMediaKits = pgTable("social_media_kits", {
      id: varchar("id").primaryKey().default(sql`gen_random_uuid()`),
      userId: varchar("user_id").notNull().references(() => users.id),
      name: text("name").notNull(),
      platforms: jsonb("platforms"),
      templateCount: integer("template_count").default(0),
      createdAt: timestamp("created_at").defaultNow(),
      updatedAt: timestamp("updated_at").defaultNow()
    });
    templateCategories = pgTable("template_categories", {
      id: varchar("id").primaryKey().default(sql`gen_random_uuid()`),
      name: text("name").notNull(),
      description: text("description"),
      slug: text("slug").notNull().unique(),
      displayOrder: integer("display_order").default(0),
      isActive: boolean("is_active").default(true),
      createdAt: timestamp("created_at").defaultNow()
    });
    templateConfigurations = pgTable("template_configurations", {
      id: varchar("id").primaryKey().default(sql`gen_random_uuid()`),
      templateId: varchar("template_id").notNull(),
      name: text("name").notNull(),
      description: text("description"),
      configType: text("config_type").notNull(),
      // 'color', 'font', 'layout', 'style'
      defaultValue: jsonb("default_value"),
      options: jsonb("options"),
      // Available configuration options
      isRequired: boolean("is_required").default(false),
      displayOrder: integer("display_order").default(0),
      createdAt: timestamp("created_at").defaultNow(),
      updatedAt: timestamp("updated_at").defaultNow()
    });
    templateContent = pgTable("template_content", {
      id: varchar("id").primaryKey().default(sql`gen_random_uuid()`),
      templateId: varchar("template_id").notNull(),
      sectionName: text("section_name").notNull(),
      componentType: text("component_type").notNull(),
      // 'header', 'hero', 'content', 'footer', etc.
      content: jsonb("content").notNull(),
      // Actual content data (text, images, etc.)
      structure: jsonb("structure").notNull(),
      // HTML structure/layout
      styles: jsonb("styles"),
      // CSS styles specific to this section
      displayOrder: integer("display_order").default(0),
      isRequired: boolean("is_required").default(false),
      isCustomizable: boolean("is_customizable").default(true),
      createdAt: timestamp("created_at").defaultNow(),
      updatedAt: timestamp("updated_at").defaultNow()
    });
    userTemplateCustomizations = pgTable("user_template_customizations", {
      id: varchar("id").primaryKey().default(sql`gen_random_uuid()`),
      userId: varchar("user_id").notNull().references(() => users.id),
      templateId: varchar("template_id").notNull(),
      customizationName: text("customization_name"),
      configurations: jsonb("configurations").notNull(),
      // User's configuration choices
      contentOverrides: jsonb("content_overrides"),
      // User's content modifications
      styleOverrides: jsonb("style_overrides"),
      // User's style modifications
      isTemplate: boolean("is_template").default(false),
      // If user wants to save as new template
      isFavorite: boolean("is_favorite").default(false),
      createdAt: timestamp("created_at").defaultNow(),
      updatedAt: timestamp("updated_at").defaultNow()
    });
    templateAssets = pgTable("template_assets", {
      id: varchar("id").primaryKey().default(sql`gen_random_uuid()`),
      templateId: varchar("template_id").notNull(),
      assetType: text("asset_type").notNull(),
      // 'preview', 'thumbnail', 'demo', 'icon'
      fileName: text("file_name").notNull(),
      fileUrl: text("file_url").notNull(),
      fileSize: integer("file_size"),
      mimeType: text("mime_type"),
      altText: text("alt_text"),
      displayOrder: integer("display_order").default(0),
      createdAt: timestamp("created_at").defaultNow()
    });
    websiteTemplates = pgTable("website_templates", {
      id: varchar("id").primaryKey().default(sql`gen_random_uuid()`),
      userId: varchar("user_id").references(() => users.id),
      // Made optional for system templates
      categoryId: varchar("category_id").references(() => templateCategories.id),
      name: text("name").notNull(),
      description: text("description"),
      templateType: text("template_type").notNull(),
      difficulty: text("difficulty").default("beginner"),
      // 'beginner', 'intermediate', 'advanced'
      industry: text("industry"),
      // Target industry
      tags: text("tags").array(),
      // Searchable tags
      demoUrl: text("demo_url"),
      url: text("url"),
      isLive: boolean("is_live").default(false),
      isSystemTemplate: boolean("is_system_template").default(false),
      // Built-in vs user-created
      isFeatured: boolean("is_featured").default(false),
      isActive: boolean("is_active").default(true),
      downloadCount: integer("download_count").default(0),
      rating: numeric("rating", { precision: 3, scale: 2 }),
      // Average rating
      ratingCount: integer("rating_count").default(0),
      price: numeric("price", { precision: 10, scale: 2 }).default("0"),
      // For premium templates
      createdAt: timestamp("created_at").defaultNow(),
      updatedAt: timestamp("updated_at").defaultNow()
    });
    notifications = pgTable("notifications", {
      id: varchar("id").primaryKey().default(sql`gen_random_uuid()`),
      userId: varchar("user_id").notNull().references(() => users.id),
      message: text("message").notNull(),
      type: text("type").notNull(),
      // 'info', 'success', 'warning', 'error', 'pro_welcome', 'system'
      isRead: boolean("is_read").default(false),
      createdAt: timestamp("created_at").defaultNow()
    });
    cancellations = pgTable("cancellations", {
      id: varchar("id").primaryKey().default(sql`gen_random_uuid()`),
      userId: varchar("user_id").notNull().references(() => users.id),
      firebaseUid: text("firebase_uid").notNull(),
      email: text("email").notNull(),
      reason: text("reason").notNull(),
      // 'Too expensive', 'Didn\'t get value', 'Missing feature', 'Technical issues', 'Temporary pause', 'Other'
      note: text("note"),
      // Optional comments
      createdAt: timestamp("created_at").defaultNow()
    });
    pauses = pgTable("pauses", {
      id: varchar("id").primaryKey().default(sql`gen_random_uuid()`),
      uid: text("uid").notNull(),
      // Firebase UID
      email: text("email"),
      stripeSubId: text("stripe_sub_id").notNull(),
      months: integer("months").notNull(),
      reason: text("reason"),
      note: text("note"),
      resumeAt: timestamp("resume_at", { withTimezone: true }).notNull(),
      createdAt: timestamp("created_at", { withTimezone: true }).defaultNow()
    });
    auditLogs = pgTable("audit_logs", {
      id: varchar("id").primaryKey().default(sql`gen_random_uuid()`),
      adminUserId: varchar("admin_user_id").notNull().references(() => users.id),
      adminRole: text("admin_role").notNull(),
      action: text("action").notNull(),
      targetType: text("target_type"),
      // 'user', 'brandkit', 'coupon', etc.
      targetId: text("target_id"),
      // ID of the affected entity
      details: jsonb("details"),
      // Additional action details
      ipAddress: text("ip_address"),
      userAgent: text("user_agent"),
      createdAt: timestamp("created_at").defaultNow()
    });
    domainOrders = pgTable("domain_orders", {
      id: varchar("id").primaryKey().default(sql`gen_random_uuid()`),
      userId: varchar("user_id").notNull().references(() => users.id),
      domain: text("domain").notNull(),
      years: integer("years").notNull().default(1),
      privacy: boolean("privacy").default(true),
      priceCents: integer("price_cents").notNull(),
      status: text("status").notNull().default("pending"),
      // 'pending', 'registering', 'paid', 'active', 'failed', 'refunded'
      stripeSessionId: text("stripe_session_id"),
      providerRegId: text("provider_reg_id"),
      // OpenSRS registration ID
      nameservers: text("nameservers").array(),
      expiresAt: timestamp("expires_at"),
      registrantContact: jsonb("registrant_contact").notNull(),
      errorMessage: text("error_message"),
      createdAt: timestamp("created_at").defaultNow(),
      updatedAt: timestamp("updated_at").defaultNow()
    });
    domainCredits = pgTable("domain_credits", {
      id: varchar("id").primaryKey().default(sql`gen_random_uuid()`),
      userId: varchar("user_id").notNull().references(() => users.id),
      status: text("status").notNull().default("available"),
      // 'available', 'used', 'expired', 'revoked'
      capCents: integer("cap_cents").notNull(),
      // Maximum price this credit can cover in cents
      eligibleTlds: jsonb("eligible_tlds").notNull(),
      // Array of TLDs this credit can be used for
      issuedAt: timestamp("issued_at").defaultNow(),
      expiresAt: timestamp("expires_at").notNull(),
      usedDomain: text("used_domain"),
      // Domain this credit was used for (if status is 'used')
      usedAt: timestamp("used_at"),
      // When this credit was used
      sourceSubscriptionId: text("source_subscription_id").unique()
      // Stripe subscription ID that generated this credit (UNIQUE to prevent duplicates)
    });
    domains = pgTable("domains", {
      id: varchar("id").primaryKey().default(sql`gen_random_uuid()`),
      userId: varchar("user_id").notNull().references(() => users.id),
      domain: text("domain").notNull().unique(),
      tld: text("tld").notNull(),
      // Top-level domain (com, net, org, etc.)
      registeredAt: timestamp("registered_at").defaultNow(),
      expiresAt: timestamp("expires_at").notNull(),
      autorenew: boolean("autorenew").default(true),
      registrar: text("registrar").notNull().default("OpenSRS"),
      premium: boolean("premium").default(false),
      // Whether this is a premium domain
      subscriptionLinked: boolean("subscription_linked").default(false),
      // Whether linked to a subscription
      createdAt: timestamp("created_at").defaultNow(),
      updatedAt: timestamp("updated_at").defaultNow()
    });
    importedIcons = pgTable("imported_icons", {
      id: varchar("id").primaryKey().default(sql`gen_random_uuid()`),
      name: text("name").notNull(),
      svg: text("svg").notNull(),
      style: text("style").notNull().default("flat"),
      // Icon style
      tags: text("tags").array().default([]),
      // Searchable tags  
      importedBy: varchar("imported_by").notNull().references(() => users.id),
      // Admin who imported
      createdAt: timestamp("created_at").defaultNow()
    });
    visitorSessions = pgTable("visitor_sessions", {
      id: varchar("id").primaryKey().default(sql`gen_random_uuid()`),
      sessionId: text("session_id").notNull(),
      // Unique session identifier (hash of IP + user agent + date)
      ipHash: text("ip_hash").notNull(),
      // Salted hash of IP address (privacy-compliant)
      country: text("country"),
      // Country name from geolocation
      countryCode: text("country_code"),
      // ISO country code  
      city: text("city"),
      // City name from geolocation
      latitude: numeric("latitude", { precision: 10, scale: 7 }),
      // Lat/lng for map positioning
      longitude: numeric("longitude", { precision: 10, scale: 7 }),
      userAgent: text("user_agent"),
      // For analytics (device/browser type)
      pageViews: integer("page_views").default(1),
      // Number of page views in this session
      firstPageUrl: text("first_page_url"),
      // First page visited in session
      lastPageUrl: text("last_page_url"),
      // Last page visited in session
      referrer: text("referrer"),
      // HTTP referrer
      isPublicPage: boolean("is_public_page").default(true),
      // Only track public pages
      date: text("date").notNull(),
      // YYYY-MM-DD for daily unique tracking
      createdAt: timestamp("created_at").defaultNow(),
      // First visit time
      updatedAt: timestamp("updated_at").defaultNow()
      // Last activity time
    }, (table) => ({
      // Unique constraint for session ID to prevent duplicates
      sessionIdUnique: unique("visitor_sessions_session_id_unique").on(table.sessionId)
    }));
    dailyVisitorStats = pgTable("daily_visitor_stats", {
      id: varchar("id").primaryKey().default(sql`gen_random_uuid()`),
      date: text("date").notNull(),
      // YYYY-MM-DD format for easy querying
      uniqueVisitors: integer("unique_visitors").default(0),
      // Count of unique sessions
      totalPageViews: integer("total_page_views").default(0),
      // Total page views for the day
      countries: jsonb("countries").default(sql`'{}'`),
      // Object with country counts: { "US": 10, "CA": 5 }
      topPages: jsonb("top_pages").default(sql`'{}'`),
      // Object with page view counts
      createdAt: timestamp("created_at").defaultNow(),
      updatedAt: timestamp("updated_at").defaultNow()
    }, (table) => ({
      // Unique constraint on date to prevent duplicates
      dateUnique: unique().on(table.date)
    }));
    cartItems = pgTable("cart_items", {
      id: varchar("id").primaryKey().default(sql`gen_random_uuid()`),
      userId: varchar("user_id").references(() => users.id),
      sessionId: text("session_id"),
      // For unauthenticated users
      itemType: text("item_type").notNull(),
      // 'stock_photo', 'subscription'
      itemId: text("item_id").notNull(),
      // Stock photo ID or subscription plan ID
      itemName: text("item_name").notNull(),
      itemPrice: integer("item_price_cents").notNull(),
      // Price in cents
      quantity: integer("quantity").default(1),
      metadata: jsonb("metadata"),
      // Additional item data (preview URL, etc.)
      createdAt: timestamp("created_at").defaultNow(),
      updatedAt: timestamp("updated_at").defaultNow()
    });
    purchases = pgTable("purchases", {
      id: varchar("id").primaryKey().default(sql`gen_random_uuid()`),
      userId: varchar("user_id").references(() => users.id),
      stripeSessionId: text("stripe_session_id").notNull().unique(),
      // Stripe checkout session ID
      stripePaymentIntentId: text("stripe_payment_intent_id"),
      status: text("status").notNull().default("pending"),
      // 'pending', 'completed', 'failed', 'refunded'
      totalAmountCents: integer("total_amount_cents").notNull(),
      items: jsonb("items").notNull(),
      // Array of purchased items
      metadata: jsonb("metadata"),
      // Additional purchase data
      createdAt: timestamp("created_at").defaultNow(),
      completedAt: timestamp("completed_at")
    });
    userEntitlements = pgTable("user_entitlements", {
      id: varchar("id").primaryKey().default(sql`gen_random_uuid()`),
      userId: varchar("user_id").notNull().references(() => users.id),
      entitlementType: text("entitlement_type").notNull(),
      // 'stock_photo', 'subscription', 'icons_no_attribution', 'icon_pack'
      entitlementId: text("entitlement_id").notNull(),
      // Stock photo ID or subscription plan
      purchaseId: varchar("purchase_id").references(() => purchases.id),
      subscriptionId: text("subscription_id"),
      // Stripe subscription ID if from subscription
      status: text("status").notNull().default("active"),
      // 'active', 'expired', 'revoked'
      expiresAt: timestamp("expires_at"),
      // For time-limited entitlements
      createdAt: timestamp("created_at").defaultNow(),
      updatedAt: timestamp("updated_at").defaultNow()
    });
    creators = pgTable("creators", {
      id: varchar("id").primaryKey().default(sql`gen_random_uuid()`),
      userId: varchar("user_id").notNull().unique().references(() => users.id, { onDelete: "cascade" }),
      // Unique constraint ensures one creator per user
      stripeConnectAccountId: text("stripe_connect_account_id").unique(),
      // Stripe Connect account ID
      onboardingStatus: creatorOnboardingStatusEnum("onboarding_status").notNull().default("pending"),
      // Database-enforced enum
      onboardingCompletedAt: timestamp("onboarding_completed_at"),
      profileData: jsonb("profile_data"),
      // Creator bio, portfolio links, etc.
      payoutEnabled: boolean("payout_enabled").default(false),
      totalEarnings: integer("total_earnings_cents").default(0),
      // Total earnings in cents
      isActive: boolean("is_active").default(true),
      createdAt: timestamp("created_at").defaultNow(),
      updatedAt: timestamp("updated_at").defaultNow()
    }, (table) => ({
      // Indexes for performance
      userIdIdx: index("creators_user_id_idx").on(table.userId),
      onboardingStatusIdx: index("creators_onboarding_status_idx").on(table.onboardingStatus),
      payoutEnabledIdx: index("creators_payout_enabled_idx").on(table.payoutEnabled),
      isActiveIdx: index("creators_is_active_idx").on(table.isActive)
    }));
    assets = pgTable("assets", {
      id: varchar("id").primaryKey().default(sql`gen_random_uuid()`),
      creatorId: varchar("creator_id").notNull().references(() => creators.id, { onDelete: "cascade" }),
      fileName: text("file_name").notNull(),
      originalFileName: text("original_file_name").notNull(),
      fileUrl: text("file_url").notNull(),
      // Private original file path
      previewUrl: text("preview_url"),
      // Public watermarked preview path
      fileSize: integer("file_size").notNull(),
      // File size in bytes
      mimeType: text("mime_type").notNull(),
      assetType: text("asset_type").notNull(),
      // 'image', 'video', 'audio', 'document', 'template'
      category: text("category"),
      // Asset category for organization
      tags: text("tags").array().default([]),
      // Searchable tags
      metadata: jsonb("metadata"),
      // Additional asset metadata (dimensions, duration, etc.)
      isPublic: boolean("is_public").default(true),
      downloadCount: integer("download_count").default(0),
      createdAt: timestamp("created_at").defaultNow(),
      updatedAt: timestamp("updated_at").defaultNow()
    }, (table) => ({
      // Indexes for performance - removed redundant ownershipUnique as it's not needed
      creatorIdIdx: index("assets_creator_id_idx").on(table.creatorId),
      assetTypeIdx: index("assets_asset_type_idx").on(table.assetType),
      categoryIdx: index("assets_category_idx").on(table.category),
      isPublicIdx: index("assets_is_public_idx").on(table.isPublic),
      downloadCountIdx: index("assets_download_count_idx").on(table.downloadCount)
    }));
    creatorAssets = pgTable("creator_assets", {
      id: varchar("id").primaryKey().default(sql`gen_random_uuid()`),
      creatorId: varchar("creator_id").notNull().references(() => creators.id, { onDelete: "cascade" }),
      assetId: varchar("asset_id").notNull().references(() => assets.id, { onDelete: "cascade" }),
      title: text("title").notNull(),
      description: text("description"),
      price: integer("price_cents").notNull().default(0),
      // Price in cents
      approvalStatus: creatorApprovalStatusEnum("approval_status").notNull().default("pending"),
      // Database-enforced enum
      approvedAt: timestamp("approved_at"),
      approvedBy: varchar("approved_by").references(() => users.id, { onDelete: "set null" }),
      // Admin who approved
      rejectionReason: text("rejection_reason"),
      // Reason for rejection if status is 'rejected'
      cancelledAt: timestamp("cancelled_at", { withTimezone: true }),
      // When the asset was cancelled by creator
      isExclusive: boolean("is_exclusive").default(false),
      // Whether this is an exclusive asset
      salesCount: integer("sales_count").default(0),
      totalRevenue: integer("total_revenue_cents").default(0),
      // Total revenue generated in cents
      createdAt: timestamp("created_at").defaultNow(),
      updatedAt: timestamp("updated_at").defaultNow()
    }, (table) => ({
      // Prevent duplicate listings from the same creator for the same asset
      creatorAssetUnique: unique("creator_assets_creator_asset_unique").on(table.creatorId, table.assetId),
      // Price validation constraints using hardcoded values for now
      priceMinCheck: check("creator_assets_price_min", sql`${table.price} >= 199`),
      priceMaxCheck: check("creator_assets_price_max", sql`${table.price} <= 4999`),
      // Indexes for performance
      creatorIdIdx: index("creator_assets_creator_id_idx").on(table.creatorId),
      assetIdIdx: index("creator_assets_asset_id_idx").on(table.assetId),
      approvalStatusIdx: index("creator_assets_approval_status_idx").on(table.approvalStatus),
      priceIdx: index("creator_assets_price_idx").on(table.price)
    }));
    creatorEarnings = pgTable("creator_earnings", {
      id: varchar("id").primaryKey().default(sql`gen_random_uuid()`),
      creatorId: varchar("creator_id").notNull().references(() => creators.id, { onDelete: "restrict" }),
      creatorAssetId: varchar("creator_asset_id").references(() => creatorAssets.id, { onDelete: "restrict" }),
      purchaseId: varchar("purchase_id").references(() => purchases.id, { onDelete: "restrict" }),
      earningType: creatorEarningTypeEnum("earning_type").notNull(),
      // Database-enforced enum
      grossAmountCents: integer("gross_amount_cents").notNull(),
      // Gross earnings in cents (renamed for consistency)
      platformFeeCents: integer("platform_fee_cents").notNull(),
      // Platform fee in cents
      netAmountCents: integer("net_amount_cents").notNull(),
      // Net earnings after fees in cents
      payoutStatus: creatorPayoutStatusEnum("payout_status").notNull().default("pending"),
      // Database-enforced enum
      payoutDate: timestamp("payout_date"),
      payoutReference: text("payout_reference"),
      // Stripe payout reference
      stripeSessionId: text("stripe_session_id").notNull().unique(),
      // Enterprise security: enforce idempotency at DB level
      occurredAt: timestamp("occurred_at").notNull().defaultNow(),
      // When the earning actually occurred
      metadata: jsonb("metadata"),
      // Additional payout details
      createdAt: timestamp("created_at").defaultNow()
    }, (table) => ({
      // Financial audit trail constraints
      grossAmountNonNegativeCheck: check("creator_earnings_gross_amount_non_negative", sql`${table.grossAmountCents} >= 0`),
      platformFeeNonNegativeCheck: check("creator_earnings_platform_fee_non_negative", sql`${table.platformFeeCents} >= 0`),
      netAmountNonNegativeCheck: check("creator_earnings_net_amount_non_negative", sql`${table.netAmountCents} >= 0`),
      netAmountCalculationCheck: check("creator_earnings_net_calculation", sql`${table.netAmountCents} = ${table.grossAmountCents} - ${table.platformFeeCents}`),
      // Indexes for performance and querying
      creatorIdIdx: index("creator_earnings_creator_id_idx").on(table.creatorId),
      creatorAssetIdIdx: index("creator_earnings_creator_asset_id_idx").on(table.creatorAssetId),
      purchaseIdIdx: index("creator_earnings_purchase_id_idx").on(table.purchaseId),
      payoutStatusIdx: index("creator_earnings_payout_status_idx").on(table.payoutStatus),
      occurredAtIdx: index("creator_earnings_occurred_at_idx").on(table.occurredAt),
      stripeSessionIdIdx: index("creator_earnings_stripe_session_id_idx").on(table.stripeSessionId),
      // Enterprise security: fast lookups
      // Composite index for creator earnings history (most recent first)
      creatorEarningsHistoryIdx: index("creator_earnings_creator_occurred_at_desc_idx").on(table.creatorId, table.occurredAt.desc())
    }));
    coverTemplates = pgTable("cover_templates", {
      id: varchar("id").primaryKey().default(sql`gen_random_uuid()`),
      title: text("title").notNull(),
      category: coverTemplateCategoryEnum("category").notNull(),
      // Database-enforced enum
      topTier: coverTemplateTopTierEnum("top_tier").notNull().default("General"),
      // Top-tier industry classification
      subcategories: text("subcategories").array().default(sql`'{}'`),
      // Array of subcategories
      priceCents: integer("price_cents").notNull().default(1200),
      // Price in cents, default $12.00
      previewUrl: text("preview_url").notNull(),
      // Thumbnail/preview image URL (renamed from preview_image_url)
      baseImageUrl: text("base_image_url"),
      // Optional base image used by template
      // Four preview URLs for lightbox functionality
      coverPreviewUrl: text("cover_preview_url"),
      // Main cover preview for lightbox
      divider1PreviewUrl: text("divider1_preview_url"),
      // First divider preview
      divider2PreviewUrl: text("divider2_preview_url"),
      // Second divider preview  
      divider3PreviewUrl: text("divider3_preview_url"),
      // Third divider preview
      downloadFile: text("download_file").notNull(),
      // Path or URL to PPTX/PDF/PNG bundle
      approvalStatus: coverTemplateApprovalStatusEnum("approval_status").notNull().default("pending"),
      // Approval workflow
      isActive: boolean("is_active").notNull().default(true),
      createdAt: timestamp("created_at", { withTimezone: true }).defaultNow()
    }, (table) => ({
      // Indexes for performance
      categoryIdx: index("cover_templates_category_idx").on(table.category),
      topTierIdx: index("cover_templates_top_tier_idx").on(table.topTier),
      approvalStatusIdx: index("cover_templates_approval_status_idx").on(table.approvalStatus),
      isActiveIdx: index("cover_templates_is_active_idx").on(table.isActive),
      priceCentsIdx: index("cover_templates_price_cents_idx").on(table.priceCents)
    }));
    coverPurchases = pgTable("cover_purchases", {
      id: varchar("id").primaryKey().default(sql`gen_random_uuid()`),
      userId: varchar("user_id").notNull().references(() => users.id, { onDelete: "cascade" }),
      templateId: varchar("template_id").notNull().references(() => coverTemplates.id, { onDelete: "cascade" }),
      customImageUrl: text("custom_image_url"),
      // Optional user-uploaded replacement image
      status: coverPurchaseStatusEnum("status").notNull().default("pending"),
      // Database-enforced enum
      downloadUrl: text("download_url"),
      // Final rendered bundle URL
      createdAt: timestamp("created_at", { withTimezone: true }).defaultNow()
    }, (table) => ({
      // Indexes for performance
      userIdIdx: index("cover_purchases_user_id_idx").on(table.userId),
      templateIdIdx: index("cover_purchases_template_id_idx").on(table.templateId),
      statusIdx: index("cover_purchases_status_idx").on(table.status)
    }));
    infographicTemplates = pgTable("infographic_templates", {
      id: varchar("id").primaryKey().default(sql`gen_random_uuid()`),
      creatorId: varchar("creator_id").references(() => users.id, { onDelete: "set null" }),
      // nullable for admin uploads
      title: text("title").notNull(),
      topTier: coverTemplateTopTierEnum("top_tier").notNull().default("General"),
      // reuse existing enum
      subcategories: text("subcategories").array().default(sql`'{}'`),
      // array of subcategories
      descriptors: text("descriptors").array().default(sql`'{}'`),
      // creator-defined descriptors/tags
      category: text("category").notNull(),
      // style: business|professional|creative|modern
      priceCents: integer("price_cents").notNull().default(1499),
      // MSRP but UI uses bundle price
      currency: text("currency").notNull().default("usd"),
      previewImageUrl: text("preview_image_url").notNull(),
      // thumbnail for gallery
      // Format URLs - at least one should be present
      pptxUrl: text("pptx_url"),
      // PowerPoint format
      keynoteUrl: text("keynote_url"),
      // Keynote format  
      gslidesUrl: text("gslides_url"),
      // Google Slides format
      downloadBundleUrl: text("download_bundle_url"),
      // ZIP or bundle download
      isActive: boolean("is_active").notNull().default(false),
      // admin controlled
      approvalStatus: coverTemplateApprovalStatusEnum("approval_status").notNull().default("pending"),
      // reuse existing enum
      createdAt: timestamp("created_at", { withTimezone: true }).defaultNow()
    }, (table) => ({
      // Indexes for performance
      creatorIdIdx: index("infographic_templates_creator_id_idx").on(table.creatorId),
      topTierIdx: index("infographic_templates_top_tier_idx").on(table.topTier),
      categoryIdx: index("infographic_templates_category_idx").on(table.category),
      approvalStatusIdx: index("infographic_templates_approval_status_idx").on(table.approvalStatus),
      isActiveIdx: index("infographic_templates_is_active_idx").on(table.isActive)
    }));
    infographicPurchases = pgTable("infographic_purchases", {
      id: varchar("id").primaryKey().default(sql`gen_random_uuid()`),
      userId: varchar("user_id").notNull().references(() => users.id, { onDelete: "cascade" }),
      selectedIds: text("selected_ids").array().notNull(),
      // 1-4 template IDs selected at checkout
      status: coverPurchaseStatusEnum("status").notNull().default("pending"),
      // reuse existing enum
      downloadUrl: text("download_url"),
      // Final ZIP bundle URL
      stripeSessionId: text("stripe_session_id"),
      // for webhook correlation
      stripePaymentIntent: text("stripe_payment_intent"),
      // additional tracking
      amountCents: integer("amount_cents").notNull().default(1499),
      // bundle price $14.99
      currency: text("currency").notNull().default("usd"),
      createdAt: timestamp("created_at", { withTimezone: true }).defaultNow()
    }, (table) => ({
      // Indexes for performance
      userIdIdx: index("infographic_purchases_user_id_idx").on(table.userId),
      statusIdx: index("infographic_purchases_status_idx").on(table.status),
      stripeSessionIdIdx: index("infographic_purchases_stripe_session_id_idx").on(table.stripeSessionId)
    }));
    presentationTemplates = pgTable("presentation_templates", {
      id: varchar("id").primaryKey().default(sql`gen_random_uuid()`),
      creatorId: varchar("creator_id").references(() => users.id, { onDelete: "set null" }),
      // nullable for admin uploads
      title: text("title").notNull(),
      topTier: coverTemplateTopTierEnum("top_tier").notNull().default("General"),
      // reuse existing enum
      subcategories: text("subcategories").array().default(sql`'{}'`),
      // array of subcategories
      category: text("category").notNull(),
      // style: business|professional|creative|modern
      previewImageUrl: text("preview_image_url").notNull(),
      // thumbnail for gallery card
      slidePreviews: text("slide_previews").array().notNull().default(sql`'{}'`),
      // array of 24 slide URLs
      // Format URLs - at least one should be present
      pptxUrl: text("pptx_url"),
      // PowerPoint format
      keynoteUrl: text("keynote_url"),
      // Keynote format
      gslidesUrl: text("gslides_url"),
      // Google Slides format
      downloadBundleUrl: text("download_bundle_url"),
      // ZIP or bundle download
      isActive: boolean("is_active").notNull().default(false),
      // admin controlled
      approvalStatus: coverTemplateApprovalStatusEnum("approval_status").notNull().default("pending"),
      // reuse existing enum
      createdAt: timestamp("created_at", { withTimezone: true }).defaultNow()
    }, (table) => ({
      // Indexes for performance
      creatorIdIdx: index("presentation_templates_creator_id_idx").on(table.creatorId),
      topTierIdx: index("presentation_templates_top_tier_idx").on(table.topTier),
      categoryIdx: index("presentation_templates_category_idx").on(table.category),
      approvalStatusIdx: index("presentation_templates_approval_status_idx").on(table.approvalStatus),
      isActiveIdx: index("presentation_templates_is_active_idx").on(table.isActive)
    }));
    presentationPurchases = pgTable("presentation_purchases", {
      id: varchar("id").primaryKey().default(sql`gen_random_uuid()`),
      userId: varchar("user_id").notNull().references(() => users.id, { onDelete: "cascade" }),
      type: text("type").notNull(),
      // 'regular' | 'premium_plus'
      baseTemplateId: varchar("base_template_id").notNull().references(() => presentationTemplates.id, { onDelete: "cascade" }),
      selectedCoverId: varchar("selected_cover_id").references(() => coverTemplates.id, { onDelete: "set null" }),
      // nullable
      selectedInfographicIds: text("selected_infographic_ids").array().default(sql`'{}'`),
      // up to 4 infographic IDs
      status: coverPurchaseStatusEnum("status").notNull().default("pending"),
      // reuse existing enum
      amountCents: integer("amount_cents").notNull(),
      currency: text("currency").notNull().default("usd"),
      stripeSessionId: text("stripe_session_id").unique(),
      stripePaymentIntent: text("stripe_payment_intent"),
      downloadUrl: text("download_url"),
      // signed URL or file path
      createdAt: timestamp("created_at", { withTimezone: true }).defaultNow()
    }, (table) => ({
      // Indexes for performance
      userIdIdx: index("presentation_purchases_user_id_idx").on(table.userId),
      statusIdx: index("presentation_purchases_status_idx").on(table.status),
      typeIdx: index("presentation_purchases_type_idx").on(table.type),
      baseTemplateIdIdx: index("presentation_purchases_base_template_id_idx").on(table.baseTemplateId)
    }));
    insertUserSchema = createInsertSchema(users).omit({
      id: true,
      createdAt: true
    }).extend({
      role: z.enum(["owner", "manager", "staff", "analyst", "user", "pro"]).default("user")
    });
    insertBrandKitSchema = createInsertSchema(brandKits).omit({
      id: true,
      createdAt: true,
      updatedAt: true
    });
    insertBusinessNameSchema = createInsertSchema(businessNames).omit({
      id: true,
      createdAt: true
    });
    insertSocialMediaKitSchema = createInsertSchema(socialMediaKits).omit({
      id: true,
      createdAt: true,
      updatedAt: true
    });
    insertWebsiteTemplateSchema = createInsertSchema(websiteTemplates).omit({
      id: true,
      createdAt: true,
      updatedAt: true,
      downloadCount: true,
      rating: true,
      ratingCount: true
    });
    insertTemplateCategorySchema = createInsertSchema(templateCategories).omit({
      id: true,
      createdAt: true
    });
    insertTemplateConfigurationSchema = createInsertSchema(templateConfigurations).omit({
      id: true,
      createdAt: true,
      updatedAt: true
    });
    insertTemplateContentSchema = createInsertSchema(templateContent).omit({
      id: true,
      createdAt: true,
      updatedAt: true
    });
    insertUserTemplateCustomizationSchema = createInsertSchema(userTemplateCustomizations).omit({
      id: true,
      createdAt: true,
      updatedAt: true
    });
    insertTemplateAssetSchema = createInsertSchema(templateAssets).omit({
      id: true,
      createdAt: true
    });
    insertNotificationSchema = createInsertSchema(notifications).omit({
      id: true,
      createdAt: true
    });
    insertCancellationSchema = createInsertSchema(cancellations).omit({
      id: true,
      createdAt: true
    }).extend({
      reason: z.enum(CANCELLATION_REASON_VALUES)
    });
    insertPauseSchema = createInsertSchema(pauses).omit({
      id: true,
      createdAt: true
    }).extend({
      months: z.number().int().min(1).max(2),
      resumeAt: z.date()
    });
    insertDomainOrderSchema = createInsertSchema(domainOrders).omit({
      id: true,
      createdAt: true,
      updatedAt: true,
      // SECURITY: Remove these server-controlled fields to prevent client tampering
      status: true,
      priceCents: true,
      stripeSessionId: true,
      providerRegId: true,
      expiresAt: true,
      errorMessage: true
    }).extend({
      domain: z.string().min(1).transform((val) => val.toLowerCase().trim()),
      years: z.number().int().min(1).max(10),
      registrantContact: z.object({
        firstName: z.string().min(1).trim(),
        lastName: z.string().min(1).trim(),
        email: z.string().email().toLowerCase().trim(),
        phone: z.string().regex(/^\+[1-9]\d{1,14}$/, "Phone must be in E.164 format (e.g., +1234567890)"),
        organization: z.string().trim().optional(),
        address: z.string().min(1).trim(),
        city: z.string().min(1).trim(),
        state: z.string().trim().optional(),
        // Optional for international addresses
        postalCode: z.string().trim().optional(),
        // Optional for international addresses  
        country: z.string().min(2).max(2).toUpperCase()
        // ISO country code
      })
    });
    insertDomainCreditSchema = createInsertSchema(domainCredits).omit({
      id: true,
      issuedAt: true,
      usedAt: true
    }).extend({
      status: z.enum(DOMAIN_CREDIT_STATUS_VALUES).default("available"),
      capCents: z.number().int().min(0),
      eligibleTlds: z.array(z.string().min(1)),
      expiresAt: z.date(),
      usedDomain: z.string().optional(),
      sourceSubscriptionId: z.string().optional()
    });
    insertDomainSchema = createInsertSchema(domains).omit({
      id: true,
      createdAt: true,
      updatedAt: true
    }).extend({
      domain: z.string().min(1).transform((val) => val.toLowerCase().trim()),
      tld: z.string().min(1).transform((val) => val.toLowerCase().trim()),
      expiresAt: z.date()
    });
    insertImportedIconSchema = createInsertSchema(importedIcons).omit({
      id: true,
      createdAt: true
    }).extend({
      name: z.string().min(1).trim(),
      svg: z.string().min(1),
      style: z.enum(["modern", "classic", "flat", "outlined", "solid", "handdrawn", "isometric", "material"]).default("flat"),
      tags: z.array(z.string()).default([])
    });
    insertVisitorSessionSchema = createInsertSchema(visitorSessions).omit({
      id: true,
      createdAt: true,
      updatedAt: true
    }).extend({
      sessionId: z.string().min(1),
      ipHash: z.string().min(1),
      // Salted hash instead of raw IP
      country: z.string().optional(),
      countryCode: z.string().optional(),
      city: z.string().optional(),
      latitude: z.number().optional(),
      // Fixed: align with database numeric type
      longitude: z.number().optional(),
      userAgent: z.string().optional(),
      pageViews: z.number().int().min(1).default(1),
      firstPageUrl: z.string().optional(),
      lastPageUrl: z.string().optional(),
      referrer: z.string().optional(),
      isPublicPage: z.boolean().default(true),
      date: z.string().regex(/^\d{4}-\d{2}-\d{2}$/)
      // YYYY-MM-DD format
    });
    insertDailyVisitorStatsSchema = createInsertSchema(dailyVisitorStats).omit({
      id: true,
      createdAt: true,
      updatedAt: true
    }).extend({
      date: z.string().regex(/^\d{4}-\d{2}-\d{2}$/),
      // YYYY-MM-DD format
      uniqueVisitors: z.number().int().min(0).default(0),
      totalPageViews: z.number().int().min(0).default(0),
      countries: z.record(z.number()).default({}),
      topPages: z.record(z.number()).default({})
    });
    insertCartItemSchema = createInsertSchema(cartItems).omit({
      id: true,
      createdAt: true,
      updatedAt: true
    }).extend({
      itemType: z.enum(["stock_photo", "subscription"]),
      itemId: z.string().min(1),
      itemName: z.string().min(1),
      itemPrice: z.number().int().min(0),
      // Price in cents
      quantity: z.number().int().min(1).default(1),
      metadata: z.record(z.any()).optional()
    });
    insertPurchaseSchema = createInsertSchema(purchases).omit({
      id: true,
      createdAt: true,
      completedAt: true
    }).extend({
      stripeSessionId: z.string().min(1),
      stripePaymentIntentId: z.string().optional(),
      status: z.enum(["pending", "completed", "failed", "refunded"]).default("pending"),
      totalAmountCents: z.number().int().min(0),
      items: z.array(z.record(z.any())),
      // Array of purchased items
      metadata: z.record(z.any()).optional()
    });
    insertUserEntitlementSchema = createInsertSchema(userEntitlements).omit({
      id: true,
      createdAt: true,
      updatedAt: true
    }).extend({
      entitlementType: z.enum(["stock_photo", "subscription"]),
      entitlementId: z.string().min(1),
      status: z.enum(["active", "expired", "revoked"]).default("active"),
      expiresAt: z.date().optional()
    });
    insertCreatorSchema = createInsertSchema(creators).omit({
      id: true,
      createdAt: true,
      updatedAt: true,
      totalEarnings: true
      // Server-calculated field
    }).extend({
      onboardingStatus: z.enum(CREATOR_ONBOARDING_STATUS_VALUES).default("pending"),
      stripeConnectAccountId: z.string().optional(),
      profileData: z.record(z.any()).optional(),
      payoutEnabled: z.boolean().default(false),
      isActive: z.boolean().default(true)
    });
    insertAssetSchema = createInsertSchema(assets).omit({
      id: true,
      createdAt: true,
      updatedAt: true,
      downloadCount: true
      // Server-tracked field
    }).extend({
      fileName: z.string().min(1),
      originalFileName: z.string().min(1),
      fileUrl: z.string().url(),
      fileSize: z.number().int().min(0),
      mimeType: z.string().min(1),
      assetType: z.enum(["image", "video", "audio", "document", "template"]),
      category: z.string().optional(),
      tags: z.array(z.string()).default([]),
      metadata: z.record(z.any()).optional(),
      isPublic: z.boolean().default(true)
    });
    insertCreatorAssetSchema = createInsertSchema(creatorAssets).omit({
      id: true,
      createdAt: true,
      updatedAt: true,
      approvedAt: true,
      // Server-set field
      salesCount: true,
      // Server-tracked field
      totalRevenue: true
      // Server-calculated field
    }).extend({
      title: z.string().min(1).trim(),
      description: z.string().optional(),
      price: z.number().int().min(CREATOR_MIN_PRICE_CENTS).max(CREATOR_MAX_PRICE_CENTS),
      // Price validation with constants
      approvalStatus: z.enum(CREATOR_APPROVAL_STATUS_VALUES).default("pending"),
      rejectionReason: z.string().optional(),
      isExclusive: z.boolean().default(false)
    });
    insertCreatorEarningSchema = createInsertSchema(creatorEarnings).omit({
      id: true,
      createdAt: true
    }).extend({
      earningType: z.enum(CREATOR_EARNING_TYPE_VALUES),
      grossAmount: z.number().int().min(0),
      // Gross earnings in cents
      platformFeeCents: z.number().int().min(0),
      // Platform fee in cents (updated field name)
      netAmountCents: z.number().int().min(0),
      // Net earnings after fees in cents (updated field name)
      payoutStatus: z.enum(CREATOR_PAYOUT_STATUS_VALUES).default("pending"),
      payoutDate: z.date().optional(),
      payoutReference: z.string().optional(),
      occurredAt: z.date().default(() => /* @__PURE__ */ new Date()),
      // New field for when earning occurred
      metadata: z.record(z.any()).optional()
    });
    insertCoverTemplateSchema = createInsertSchema(coverTemplates).omit({
      id: true,
      createdAt: true
    }).extend({
      title: z.string().min(1).trim(),
      category: z.enum(COVER_TEMPLATE_CATEGORY_VALUES),
      priceCents: z.number().int().min(0).default(1200),
      // Price in cents, default $12.00
      previewUrl: z.string().url(),
      baseImageUrl: z.string().url().optional(),
      downloadFile: z.string().min(1),
      // Can be URL or file path
      isActive: z.boolean().default(true)
    });
    insertCoverPurchaseSchema = createInsertSchema(coverPurchases).omit({
      id: true,
      createdAt: true
    }).extend({
      userId: z.string().min(1),
      templateId: z.string().min(1),
      customImageUrl: z.string().url().optional(),
      status: z.enum(COVER_PURCHASE_STATUS_VALUES).default("pending"),
      downloadUrl: z.string().url().optional()
    });
    insertInfographicTemplateSchema = createInsertSchema(infographicTemplates).omit({
      id: true,
      createdAt: true
    }).extend({
      title: z.string().min(1).trim(),
      topTier: z.enum(COVER_TEMPLATE_TOP_TIER_VALUES).default("General"),
      // reuse existing enum
      subcategories: z.array(z.string()).default([]),
      descriptors: z.array(z.string()).default([]),
      // creator-defined descriptors/tags
      category: z.string().min(1),
      // business|professional|creative|modern
      priceCents: z.number().int().min(0).default(1499),
      // bundle MSRP
      currency: z.string().default("usd"),
      previewImageUrl: z.string().url(),
      // At least one format URL should be provided
      pptxUrl: z.string().url().optional(),
      keynoteUrl: z.string().url().optional(),
      gslidesUrl: z.string().url().optional(),
      downloadBundleUrl: z.string().url().optional(),
      isActive: z.boolean().default(false),
      approvalStatus: z.enum(COVER_TEMPLATE_APPROVAL_STATUS_VALUES).default("pending")
    });
    insertInfographicPurchaseSchema = createInsertSchema(infographicPurchases).omit({
      id: true,
      createdAt: true
    }).extend({
      userId: z.string().min(1),
      selectedIds: z.array(z.string()).min(1).max(4),
      // 1-4 template IDs
      status: z.enum(COVER_PURCHASE_STATUS_VALUES).default("pending"),
      downloadUrl: z.string().url().optional(),
      stripeSessionId: z.string().optional(),
      stripePaymentIntent: z.string().optional(),
      amountCents: z.number().int().min(0).default(1499),
      // $14.99 bundle price
      currency: z.string().default("usd")
    });
    insertPresentationTemplateSchema = createInsertSchema(presentationTemplates).omit({
      id: true,
      createdAt: true
    }).extend({
      title: z.string().min(1).trim(),
      topTier: z.enum(COVER_TEMPLATE_TOP_TIER_VALUES).default("General"),
      // reuse existing enum
      subcategories: z.array(z.string()).default([]),
      category: z.string().min(1),
      // business|professional|creative|modern
      previewImageUrl: z.string().url(),
      slidePreviews: z.array(z.string().url()).length(24),
      // exactly 24 slide URLs required
      // At least one format URL should be provided
      pptxUrl: z.string().url().optional(),
      keynoteUrl: z.string().url().optional(),
      gslidesUrl: z.string().url().optional(),
      downloadBundleUrl: z.string().url().optional(),
      isActive: z.boolean().default(false),
      approvalStatus: z.enum(COVER_TEMPLATE_APPROVAL_STATUS_VALUES).default("pending")
    });
    insertPresentationPurchaseSchema = createInsertSchema(presentationPurchases).omit({
      id: true,
      createdAt: true
    }).extend({
      userId: z.string().min(1),
      type: z.enum(["regular", "premium_plus"]),
      baseTemplateId: z.string().min(1),
      selectedCoverId: z.string().optional(),
      selectedInfographicIds: z.array(z.string()).max(4).default([]),
      // up to 4 infographic IDs
      status: z.enum(COVER_PURCHASE_STATUS_VALUES).default("pending"),
      amountCents: z.number().int().min(0),
      // price depends on type: 2999 or 4999
      currency: z.string().default("usd"),
      downloadUrl: z.string().url().optional()
    });
  }
});

// server/events/notifications.ts
import { EventEmitter } from "events";
var NotificationBroadcaster, notificationBroadcaster;
var init_notifications = __esm({
  "server/events/notifications.ts"() {
    "use strict";
    NotificationBroadcaster = class extends EventEmitter {
      connections = /* @__PURE__ */ new Map();
      keepaliveInterval = null;
      KEEPALIVE_INTERVAL = 3e4;
      // 30 seconds
      constructor() {
        super();
        this.setMaxListeners(200);
        this.startKeepalive();
      }
      // Start keepalive mechanism to detect dead connections
      startKeepalive() {
        if (this.keepaliveInterval) {
          clearInterval(this.keepaliveInterval);
        }
        this.keepaliveInterval = setInterval(() => {
          this.broadcastKeepalive();
        }, this.KEEPALIVE_INTERVAL);
      }
      // Send keepalive to all connections to detect dead ones
      broadcastKeepalive() {
        const message = {
          type: "keepalive",
          timestamp: Date.now()
        };
        const deadConnections = [];
        for (const [tokenId, connection] of this.connections) {
          try {
            connection.response.write(`data: ${JSON.stringify(message)}

`);
          } catch (error) {
            console.log(`Connection ${tokenId} appears dead, marking for removal`);
            deadConnections.push(tokenId);
          }
        }
        for (const tokenId of deadConnections) {
          this.removeConnection(tokenId);
        }
      }
      // Add a new SSE connection
      addConnection(streamToken, userId, response) {
        this.removeConnection(streamToken);
        this.connections.set(streamToken, {
          response,
          userId,
          streamToken,
          connectedAt: /* @__PURE__ */ new Date()
        });
        console.log(`SSE connection added for user ${userId} (token: ${streamToken.substring(0, 8)}...)`);
        response.on("close", () => {
          console.log(`SSE connection closed for user ${userId}`);
          this.removeConnection(streamToken);
        });
        response.on("error", (error) => {
          console.error(`SSE connection error for user ${userId}:`, error);
          this.removeConnection(streamToken);
        });
        const welcomeMessage = {
          type: "connected",
          message: "Notifications stream connected",
          timestamp: Date.now()
        };
        try {
          response.write(`data: ${JSON.stringify(welcomeMessage)}

`);
        } catch (error) {
          console.error("Failed to send welcome message:", error);
          this.removeConnection(streamToken);
        }
      }
      // Remove an SSE connection
      removeConnection(streamToken) {
        const connection = this.connections.get(streamToken);
        if (connection) {
          try {
            if (!connection.response.headersSent) {
              connection.response.end();
            }
          } catch (error) {
          }
          this.connections.delete(streamToken);
          console.log(`SSE connection removed (token: ${streamToken.substring(0, 8)}...)`);
        }
      }
      // Broadcast a notification to specific user
      sendNotificationToUser(userId, notification) {
        const message = {
          type: "notification",
          data: notification,
          timestamp: Date.now()
        };
        const userConnections = Array.from(this.connections.values()).filter((conn) => conn.userId === userId);
        if (userConnections.length === 0) {
          console.log(`No active SSE connections for user ${userId}`);
          return;
        }
        let sentCount = 0;
        const deadConnections = [];
        for (const connection of userConnections) {
          try {
            connection.response.write(`data: ${JSON.stringify(message)}

`);
            sentCount++;
          } catch (error) {
            console.error(`Failed to send notification to user ${userId}:`, error);
            deadConnections.push(connection.streamToken);
          }
        }
        for (const tokenId of deadConnections) {
          this.removeConnection(tokenId);
        }
        console.log(`Notification sent to ${sentCount} connections for user ${userId}`);
      }
      // Broadcast to all connected users (system-wide notifications)
      broadcastToAll(notification) {
        const message = {
          type: "notification",
          data: notification,
          timestamp: Date.now()
        };
        let sentCount = 0;
        const deadConnections = [];
        for (const [tokenId, connection] of this.connections) {
          try {
            connection.response.write(`data: ${JSON.stringify(message)}

`);
            sentCount++;
          } catch (error) {
            console.error(`Failed to send broadcast notification:`, error);
            deadConnections.push(tokenId);
          }
        }
        for (const tokenId of deadConnections) {
          this.removeConnection(tokenId);
        }
        console.log(`Broadcast notification sent to ${sentCount} connections`);
      }
      // Get connection stats
      getStats() {
        const now = /* @__PURE__ */ new Date();
        const connections = Array.from(this.connections.values());
        return {
          totalConnections: connections.length,
          uniqueUsers: new Set(connections.map((c) => c.userId)).size,
          oldestConnection: connections.length > 0 ? Math.min(...connections.map((c) => now.getTime() - c.connectedAt.getTime())) : 0,
          connectionsByUser: connections.reduce((acc, conn) => {
            acc[conn.userId] = (acc[conn.userId] || 0) + 1;
            return acc;
          }, {})
        };
      }
      // Cleanup all connections (for shutdown)
      cleanup() {
        if (this.keepaliveInterval) {
          clearInterval(this.keepaliveInterval);
          this.keepaliveInterval = null;
        }
        for (const [tokenId] of this.connections) {
          this.removeConnection(tokenId);
        }
        this.connections.clear();
        console.log("Notification broadcaster cleanup completed");
      }
    };
    notificationBroadcaster = new NotificationBroadcaster();
    process.on("SIGTERM", () => {
      console.log("SIGTERM received, cleaning up notification broadcaster...");
      notificationBroadcaster.cleanup();
    });
    process.on("SIGINT", () => {
      console.log("SIGINT received, cleaning up notification broadcaster...");
      notificationBroadcaster.cleanup();
    });
  }
});

// server/objectStorage.ts
var objectStorage_exports = {};
__export(objectStorage_exports, {
  ObjectNotFoundError: () => ObjectNotFoundError,
  ObjectStorageService: () => ObjectStorageService,
  objectStorageClient: () => objectStorageClient
});
import { Storage } from "@google-cloud/storage";
import { randomUUID } from "crypto";
function parseObjectPath(path13) {
  if (!path13.startsWith("/")) {
    path13 = `/${path13}`;
  }
  const pathParts = path13.split("/");
  if (pathParts.length < 3) {
    throw new Error("Invalid path: must contain at least a bucket name");
  }
  const bucketName = pathParts[1];
  const objectName = pathParts.slice(2).join("/");
  return {
    bucketName,
    objectName
  };
}
async function signObjectURL({
  bucketName,
  objectName,
  method,
  ttlSec
}) {
  const request = {
    bucket_name: bucketName,
    object_name: objectName,
    method,
    expires_at: new Date(Date.now() + ttlSec * 1e3).toISOString()
  };
  const response = await fetch(
    `${REPLIT_SIDECAR_ENDPOINT}/object-storage/signed-object-url`,
    {
      method: "POST",
      headers: {
        "Content-Type": "application/json"
      },
      body: JSON.stringify(request)
    }
  );
  if (!response.ok) {
    throw new Error(
      `Failed to sign object URL, errorcode: ${response.status}, make sure you're running on Replit`
    );
  }
  const { signed_url: signedURL } = await response.json();
  return signedURL;
}
var REPLIT_SIDECAR_ENDPOINT, objectStorageClient, ObjectNotFoundError, ObjectStorageService;
var init_objectStorage = __esm({
  "server/objectStorage.ts"() {
    "use strict";
    REPLIT_SIDECAR_ENDPOINT = "http://127.0.0.1:1106";
    objectStorageClient = new Storage({
      credentials: {
        audience: "replit",
        subject_token_type: "access_token",
        token_url: `${REPLIT_SIDECAR_ENDPOINT}/token`,
        type: "external_account",
        credential_source: {
          url: `${REPLIT_SIDECAR_ENDPOINT}/credential`,
          format: {
            type: "json",
            subject_token_field_name: "access_token"
          }
        },
        universe_domain: "googleapis.com"
      },
      projectId: ""
    });
    ObjectNotFoundError = class _ObjectNotFoundError extends Error {
      constructor() {
        super("Object not found");
        this.name = "ObjectNotFoundError";
        Object.setPrototypeOf(this, _ObjectNotFoundError.prototype);
      }
    };
    ObjectStorageService = class {
      constructor() {
      }
      // Gets the public object search paths.
      getPublicObjectSearchPaths() {
        const pathsStr = process.env.PUBLIC_OBJECT_SEARCH_PATHS || "";
        const paths = Array.from(
          new Set(
            pathsStr.split(",").map((path13) => path13.trim()).filter((path13) => path13.length > 0)
          )
        );
        if (paths.length === 0) {
          throw new Error(
            "PUBLIC_OBJECT_SEARCH_PATHS not set. Create a bucket in 'Object Storage' tool and set PUBLIC_OBJECT_SEARCH_PATHS env var (comma-separated paths)."
          );
        }
        return paths;
      }
      // Gets the private object directory.
      getPrivateObjectDir() {
        const dir = process.env.PRIVATE_OBJECT_DIR || "";
        if (!dir) {
          throw new Error(
            "PRIVATE_OBJECT_DIR not set. Create a bucket in 'Object Storage' tool and set PRIVATE_OBJECT_DIR env var."
          );
        }
        return dir;
      }
      // Search for a public object from the search paths.
      async searchPublicObject(filePath) {
        for (const searchPath of this.getPublicObjectSearchPaths()) {
          const fullPath = `${searchPath}/${filePath}`;
          const { bucketName, objectName } = parseObjectPath(fullPath);
          const bucket2 = objectStorageClient.bucket(bucketName);
          const file2 = bucket2.file(objectName);
          const [exists] = await file2.exists();
          if (exists) {
            return file2;
          }
        }
        return null;
      }
      // Downloads an object to the response.
      async downloadObject(file2, res, cacheTtlSec = 3600) {
        try {
          const [metadata] = await file2.getMetadata();
          res.set({
            "Content-Type": metadata.contentType || "application/octet-stream",
            "Content-Length": metadata.size,
            "Cache-Control": `public, max-age=${cacheTtlSec}`
          });
          const stream = file2.createReadStream();
          stream.on("error", (err) => {
            console.error("Stream error:", err);
            if (!res.headersSent) {
              res.status(500).json({ error: "Error streaming file" });
            }
          });
          stream.pipe(res);
        } catch (error) {
          console.error("Error downloading file:", error);
          if (!res.headersSent) {
            res.status(500).json({ error: "Error downloading file" });
          }
        }
      }
      // Gets the upload URL for an object entity.
      async getUploadURL(fileName, isPublic = true) {
        const objectId = randomUUID();
        const fileExtension = fileName.split(".").pop() || "";
        const sanitizedFileName = `${objectId}.${fileExtension}`;
        let fullPath;
        if (isPublic) {
          const publicPath = this.getPublicObjectSearchPaths()[0];
          fullPath = `${publicPath}/${sanitizedFileName}`;
        } else {
          const privateDir = this.getPrivateObjectDir();
          fullPath = `${privateDir}/${sanitizedFileName}`;
        }
        const { bucketName, objectName } = parseObjectPath(fullPath);
        return signObjectURL({
          bucketName,
          objectName,
          method: "PUT",
          ttlSec: 900
        });
      }
      // Get public URL for an uploaded file
      getPublicURL(objectPath) {
        if (objectPath.startsWith("http")) {
          return objectPath;
        }
        const { bucketName, objectName } = parseObjectPath(objectPath);
        return `/public-objects/${objectName}`;
      }
      // List files with a given prefix
      async listPrefix(prefix) {
        try {
          const publicPaths = this.getPublicObjectSearchPaths();
          const allFiles = [];
          for (const searchPath of publicPaths) {
            const fullPath = `${searchPath}/${prefix}`;
            const { bucketName, objectName } = parseObjectPath(fullPath);
            const bucket2 = objectStorageClient.bucket(bucketName);
            const [files] = await bucket2.getFiles({ prefix: objectName });
            for (const file2 of files) {
              const [metadata] = await file2.getMetadata();
              allFiles.push({
                key: file2.name,
                size: parseInt(metadata.size || "0"),
                lastModified: new Date(metadata.timeCreated || Date.now())
              });
            }
          }
          return allFiles;
        } catch (error) {
          console.error("Error listing files with prefix:", error);
          return [];
        }
      }
      // Get a readable stream for a file by key
      async getStream(key) {
        try {
          const publicPaths = this.getPublicObjectSearchPaths();
          for (const searchPath of publicPaths) {
            const { bucketName, objectName } = parseObjectPath(searchPath);
            const bucket2 = objectStorageClient.bucket(bucketName);
            const fullObjectKey = objectName ? `${objectName}/${key}` : key;
            const file2 = bucket2.file(fullObjectKey);
            const [exists] = await file2.exists();
            if (exists) {
              return file2.createReadStream();
            }
          }
          throw new ObjectNotFoundError();
        } catch (error) {
          console.error("Error getting file stream:", error);
          throw error;
        }
      }
      // Get public URL from file key
      publicUrlFromKey(key) {
        return `/public-objects/${key}`;
      }
      // Upload a file to object storage
      async uploadFile(fullPath, buffer, contentType) {
        try {
          const { bucketName, objectName } = parseObjectPath(fullPath);
          const bucket2 = objectStorageClient.bucket(bucketName);
          const file2 = bucket2.file(objectName);
          const options = {
            resumable: false
          };
          if (contentType) {
            options.metadata = {
              contentType
            };
          }
          await file2.save(buffer, options);
        } catch (error) {
          console.error("Error uploading file:", error);
          throw error;
        }
      }
      // Delete files from object storage by key pattern
      async deleteFilesByPattern(keyPattern) {
        try {
          const publicPaths = this.getPublicObjectSearchPaths();
          let deletedAny = false;
          for (const searchPath of publicPaths) {
            const { bucketName, objectName } = parseObjectPath(searchPath);
            const bucket2 = objectStorageClient.bucket(bucketName);
            const baseKey = objectName ? `${objectName}/${keyPattern}` : keyPattern;
            const [files] = await bucket2.getFiles({ prefix: baseKey });
            for (const file2 of files) {
              try {
                await file2.delete();
                console.log(`\u{1F5D1}\uFE0F Deleted object storage file: ${file2.name}`);
                deletedAny = true;
              } catch (deleteError) {
                console.warn(`Failed to delete file ${file2.name}:`, deleteError);
              }
            }
          }
          return deletedAny;
        } catch (error) {
          console.error("Error deleting files by pattern:", error);
          throw error;
        }
      }
      // Delete a single file from object storage
      async deleteFile(key) {
        try {
          const publicPaths = this.getPublicObjectSearchPaths();
          for (const searchPath of publicPaths) {
            const { bucketName, objectName } = parseObjectPath(searchPath);
            const bucket2 = objectStorageClient.bucket(bucketName);
            const fullObjectKey = objectName ? `${objectName}/${key}` : key;
            const file2 = bucket2.file(fullObjectKey);
            const [exists] = await file2.exists();
            if (exists) {
              await file2.delete();
              console.log(`\u{1F5D1}\uFE0F Deleted object storage file: ${fullObjectKey}`);
              return true;
            }
          }
          return false;
        } catch (error) {
          console.error("Error deleting single file:", error);
          throw error;
        }
      }
    };
  }
});

// server/storage.ts
import { drizzle } from "drizzle-orm/neon-http";
import { eq, and, or, sql as sql2, gte, lte, ilike, desc } from "drizzle-orm";
import { neon } from "@neondatabase/serverless";
var PostgreSQLStorage, storage;
var init_storage = __esm({
  "server/storage.ts"() {
    "use strict";
    init_schema();
    init_notifications();
    PostgreSQLStorage = class {
      db;
      constructor() {
        if (!process.env.DATABASE_URL) {
          throw new Error("DATABASE_URL environment variable is required");
        }
        const sql3 = neon(process.env.DATABASE_URL);
        this.db = drizzle(sql3);
      }
      // User operations
      async getUser(id) {
        const result = await this.db.select().from(users).where(eq(users.id, id)).limit(1);
        return result[0];
      }
      async getAllUsers() {
        return await this.db.select().from(users);
      }
      async getUserByEmail(email) {
        const result = await this.db.select().from(users).where(eq(users.email, email)).limit(1);
        return result[0];
      }
      async getUserByFirebaseUid(firebaseUid) {
        const result = await this.db.select().from(users).where(eq(users.firebaseUid, firebaseUid)).limit(1);
        return result[0];
      }
      async createUser(user) {
        const result = await this.db.insert(users).values(user).returning();
        return result[0];
      }
      async updateUser(id, user) {
        const result = await this.db.update(users).set(user).where(eq(users.id, id)).returning();
        return result[0];
      }
      async updateUserByFirebaseUid(firebaseUid, data) {
        const result = await this.db.update(users).set(data).where(eq(users.firebaseUid, firebaseUid)).returning();
        return result[0];
      }
      async getUserPreferences(firebaseUid) {
        try {
          const { sql: sql3 } = await import("drizzle-orm");
          await this.db.execute(sql3`
        CREATE TABLE IF NOT EXISTS user_preferences (
          user_uid TEXT PRIMARY KEY,
          email_news BOOLEAN DEFAULT true,
          marketing_emails BOOLEAN DEFAULT false,
          product_updates BOOLEAN DEFAULT true,
          created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
          updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
        )
      `);
          const result = await this.db.execute(sql3`
        SELECT email_news, marketing_emails, product_updates,
               system_notifications, billing_notifications, project_notifications
        FROM user_preferences 
        WHERE user_uid = ${firebaseUid}
      `);
          if (result.rows && result.rows.length > 0) {
            const row = result.rows[0];
            return {
              emailNews: !!row.email_news,
              marketingEmails: !!row.marketing_emails,
              productUpdates: !!row.product_updates,
              systemNotifications: !!row.system_notifications,
              billingNotifications: !!row.billing_notifications,
              projectNotifications: !!row.project_notifications
            };
          }
          return {
            emailNews: true,
            marketingEmails: false,
            productUpdates: true,
            systemNotifications: true,
            billingNotifications: true,
            projectNotifications: true
          };
        } catch (error) {
          console.error("Get user preferences error:", error);
          return {
            emailNews: true,
            marketingEmails: false,
            productUpdates: true
          };
        }
      }
      async setUserPreferences(firebaseUid, prefs) {
        try {
          const { sql: sql3 } = await import("drizzle-orm");
          await this.db.execute(sql3`
        ALTER TABLE user_preferences 
        ADD COLUMN IF NOT EXISTS system_notifications BOOLEAN DEFAULT true,
        ADD COLUMN IF NOT EXISTS billing_notifications BOOLEAN DEFAULT true,
        ADD COLUMN IF NOT EXISTS project_notifications BOOLEAN DEFAULT true
      `);
          await this.db.execute(sql3`
        INSERT INTO user_preferences (
          user_uid, email_news, marketing_emails, product_updates, 
          system_notifications, billing_notifications, project_notifications, updated_at
        )
        VALUES (
          ${firebaseUid}, ${prefs.emailNews}, ${prefs.marketingEmails}, ${prefs.productUpdates},
          ${prefs.systemNotifications ?? true}, ${prefs.billingNotifications ?? true}, ${prefs.projectNotifications ?? true},
          CURRENT_TIMESTAMP
        )
        ON CONFLICT(user_uid) DO UPDATE SET
          email_news = EXCLUDED.email_news,
          marketing_emails = EXCLUDED.marketing_emails,
          product_updates = EXCLUDED.product_updates,
          system_notifications = EXCLUDED.system_notifications,
          billing_notifications = EXCLUDED.billing_notifications,
          project_notifications = EXCLUDED.project_notifications,
          updated_at = CURRENT_TIMESTAMP
      `);
          return true;
        } catch (error) {
          console.error("Set user preferences error:", error);
          return false;
        }
      }
      async deleteUser(id) {
        const result = await this.db.delete(users).where(eq(users.id, id));
        return (result.rowCount ?? 0) > 0;
      }
      // Brand Kit operations
      async getBrandKit(id) {
        const result = await this.db.select().from(brandKits).where(eq(brandKits.id, id)).limit(1);
        return result[0];
      }
      async getAllBrandKits() {
        return await this.db.select().from(brandKits);
      }
      async getBrandKitsByUserId(userId) {
        return await this.db.select().from(brandKits).where(eq(brandKits.userId, userId));
      }
      async createBrandKit(brandKit) {
        const result = await this.db.insert(brandKits).values({
          ...brandKit,
          updatedAt: /* @__PURE__ */ new Date()
        }).returning();
        return result[0];
      }
      async updateBrandKit(id, brandKit) {
        const result = await this.db.update(brandKits).set({
          ...brandKit,
          updatedAt: /* @__PURE__ */ new Date()
        }).where(eq(brandKits.id, id)).returning();
        return result[0];
      }
      async deleteBrandKit(id) {
        const result = await this.db.delete(brandKits).where(eq(brandKits.id, id));
        return (result.rowCount ?? 0) > 0;
      }
      // Business Name operations
      async getBusinessName(id) {
        const result = await this.db.select().from(businessNames).where(eq(businessNames.id, id)).limit(1);
        return result[0];
      }
      async getAllBusinessNames() {
        return await this.db.select().from(businessNames);
      }
      async getBusinessNamesByUserId(userId) {
        return await this.db.select().from(businessNames).where(eq(businessNames.userId, userId));
      }
      async getSavedBusinessNamesByUserId(userId) {
        return await this.db.select().from(businessNames).where(and(eq(businessNames.userId, userId), eq(businessNames.isSaved, true)));
      }
      async createBusinessName(businessName) {
        const result = await this.db.insert(businessNames).values(businessName).returning();
        return result[0];
      }
      async updateBusinessName(id, businessName) {
        const result = await this.db.update(businessNames).set(businessName).where(eq(businessNames.id, id)).returning();
        return result[0];
      }
      async deleteBusinessName(id) {
        const result = await this.db.delete(businessNames).where(eq(businessNames.id, id));
        return (result.rowCount ?? 0) > 0;
      }
      // Social Media Kit operations
      async getSocialMediaKit(id) {
        const result = await this.db.select().from(socialMediaKits).where(eq(socialMediaKits.id, id)).limit(1);
        return result[0];
      }
      async getSocialMediaKitsByUserId(userId) {
        return await this.db.select().from(socialMediaKits).where(eq(socialMediaKits.userId, userId));
      }
      async createSocialMediaKit(socialMediaKit) {
        const result = await this.db.insert(socialMediaKits).values({
          ...socialMediaKit,
          updatedAt: /* @__PURE__ */ new Date()
        }).returning();
        return result[0];
      }
      async updateSocialMediaKit(id, socialMediaKit) {
        const result = await this.db.update(socialMediaKits).set({
          ...socialMediaKit,
          updatedAt: /* @__PURE__ */ new Date()
        }).where(eq(socialMediaKits.id, id)).returning();
        return result[0];
      }
      async deleteSocialMediaKit(id) {
        const result = await this.db.delete(socialMediaKits).where(eq(socialMediaKits.id, id));
        return (result.rowCount ?? 0) > 0;
      }
      // Website Template operations
      async getWebsiteTemplate(id) {
        const result = await this.db.select().from(websiteTemplates).where(eq(websiteTemplates.id, id)).limit(1);
        return result[0];
      }
      async getWebsiteTemplatesByUserId(userId) {
        return await this.db.select().from(websiteTemplates).where(eq(websiteTemplates.userId, userId));
      }
      async createWebsiteTemplate(websiteTemplate) {
        const result = await this.db.insert(websiteTemplates).values({
          ...websiteTemplate,
          updatedAt: /* @__PURE__ */ new Date()
        }).returning();
        return result[0];
      }
      async updateWebsiteTemplate(id, websiteTemplate) {
        const result = await this.db.update(websiteTemplates).set({
          ...websiteTemplate,
          updatedAt: /* @__PURE__ */ new Date()
        }).where(eq(websiteTemplates.id, id)).returning();
        return result[0];
      }
      async deleteWebsiteTemplate(id) {
        const result = await this.db.delete(websiteTemplates).where(eq(websiteTemplates.id, id));
        return (result.rowCount ?? 0) > 0;
      }
      // User Template Customization operations
      async getUserTemplateCustomization(id) {
        const result = await this.db.select().from(userTemplateCustomizations).where(eq(userTemplateCustomizations.id, id)).limit(1);
        return result[0];
      }
      async getUserTemplateCustomizationsByUserId(userId) {
        return await this.db.select().from(userTemplateCustomizations).where(eq(userTemplateCustomizations.userId, userId));
      }
      async getUserTemplateCustomizationByTemplateId(userId, templateId) {
        const result = await this.db.select().from(userTemplateCustomizations).where(and(eq(userTemplateCustomizations.userId, userId), eq(userTemplateCustomizations.templateId, templateId))).limit(1);
        return result[0];
      }
      async createUserTemplateCustomization(customization) {
        const result = await this.db.insert(userTemplateCustomizations).values({
          ...customization,
          updatedAt: /* @__PURE__ */ new Date()
        }).returning();
        return result[0];
      }
      async updateUserTemplateCustomization(id, customization) {
        const result = await this.db.update(userTemplateCustomizations).set({
          ...customization,
          updatedAt: /* @__PURE__ */ new Date()
        }).where(eq(userTemplateCustomizations.id, id)).returning();
        return result[0];
      }
      async deleteUserTemplateCustomization(id) {
        const result = await this.db.delete(userTemplateCustomizations).where(eq(userTemplateCustomizations.id, id));
        return (result.rowCount ?? 0) > 0;
      }
      async duplicateUserTemplateCustomization(id, newName) {
        const original = await this.getUserTemplateCustomization(id);
        if (!original) return void 0;
        const duplicateData = {
          userId: original.userId,
          templateId: original.templateId,
          customizationName: newName,
          configurations: original.configurations,
          contentOverrides: original.contentOverrides,
          styleOverrides: original.styleOverrides,
          isTemplate: false,
          isFavorite: false
        };
        return await this.createUserTemplateCustomization(duplicateData);
      }
      // Notification operations
      async getNotifications(firebaseUid) {
        const user = await this.getUserByFirebaseUid(firebaseUid);
        if (!user) return [];
        const result = await this.db.select().from(notifications).where(eq(notifications.userId, user.id)).orderBy(sql2`${notifications.createdAt} DESC`).limit(50);
        return result;
      }
      async markNotificationRead(id, firebaseUid) {
        const user = await this.getUserByFirebaseUid(firebaseUid);
        if (!user) return false;
        const result = await this.db.update(notifications).set({ isRead: true }).where(and(eq(notifications.id, id), eq(notifications.userId, user.id))).returning();
        return result.length > 0;
      }
      async createNotification(userId, message, type) {
        try {
          const result = await this.db.insert(notifications).values({
            userId,
            message,
            type
          }).returning();
          const notification = result[0];
          const user = await this.getUser(userId);
          if (user && user.firebaseUid) {
            notificationBroadcaster.sendNotificationToUser(user.firebaseUid, {
              id: notification.id,
              userId: user.firebaseUid,
              // Use Firebase UID for frontend matching
              message: notification.message,
              type: notification.type,
              isRead: notification.isRead ?? false,
              createdAt: notification.createdAt?.toISOString() ?? (/* @__PURE__ */ new Date()).toISOString()
            });
          }
          return notification;
        } catch (error) {
          console.error("Failed to create notification:", error);
          throw error;
        }
      }
      // Cancellation operations
      async getCancellation(id) {
        const result = await this.db.select().from(cancellations).where(eq(cancellations.id, id)).limit(1);
        return result[0];
      }
      async getAllCancellations() {
        return await this.db.select().from(cancellations);
      }
      async getCancellationsByUserId(userId) {
        return await this.db.select().from(cancellations).where(eq(cancellations.userId, userId));
      }
      async createCancellation(cancellation) {
        const result = await this.db.insert(cancellations).values(cancellation).returning();
        return result[0];
      }
      // Pause operations
      async getPause(id) {
        const result = await this.db.select().from(pauses).where(eq(pauses.id, id)).limit(1);
        return result[0];
      }
      async getAllPauses() {
        return await this.db.select().from(pauses);
      }
      async getPauseByUid(uid) {
        const result = await this.db.select().from(pauses).where(eq(pauses.uid, uid)).limit(1);
        return result[0];
      }
      async getPausesByStripeSubId(stripeSubId) {
        return await this.db.select().from(pauses).where(eq(pauses.stripeSubId, stripeSubId));
      }
      async createPause(pause) {
        const result = await this.db.insert(pauses).values(pause).returning();
        return result[0];
      }
      async updatePause(id, pause) {
        const result = await this.db.update(pauses).set(pause).where(eq(pauses.id, id)).returning();
        return result[0];
      }
      async deletePause(id) {
        const result = await this.db.delete(pauses).where(eq(pauses.id, id));
        return (result.rowCount ?? 0) > 0;
      }
      // Pause metrics operations
      async getPausedUsersCount() {
        const result = await this.db.select({ count: sql2`count(*)` }).from(users).where(eq(users.subscriptionStatus, "paused"));
        return result[0]?.count || 0;
      }
      async getRecentPauses(limit = 10) {
        const result = await this.db.select({
          id: pauses.id,
          email: pauses.email,
          months: pauses.months,
          resumeAt: pauses.resumeAt,
          createdAt: pauses.createdAt,
          reason: pauses.reason,
          note: pauses.note
        }).from(pauses).orderBy(sql2`${pauses.createdAt} DESC`).limit(limit);
        return result.map((p) => ({
          id: p.id,
          email: p.email || "",
          months: p.months,
          resumeAt: p.resumeAt,
          createdAt: p.createdAt || /* @__PURE__ */ new Date(),
          reason: p.reason || void 0,
          note: p.note || void 0
        }));
      }
      // Domain Order operations
      async getDomainOrder(id) {
        const result = await this.db.select().from(domainOrders).where(eq(domainOrders.id, id)).limit(1);
        return result[0];
      }
      async getDomainOrdersByUserId(userId) {
        return await this.db.select().from(domainOrders).where(eq(domainOrders.userId, userId));
      }
      async createDomainOrder(domainOrder) {
        const result = await this.db.insert(domainOrders).values({
          ...domainOrder,
          updatedAt: /* @__PURE__ */ new Date()
        }).returning();
        return result[0];
      }
      async updateDomainOrder(id, domainOrder) {
        const result = await this.db.update(domainOrders).set({
          ...domainOrder,
          updatedAt: /* @__PURE__ */ new Date()
        }).where(eq(domainOrders.id, id)).returning();
        return result[0];
      }
      async deleteDomainOrder(id) {
        const result = await this.db.delete(domainOrders).where(eq(domainOrders.id, id));
        return (result.rowCount ?? 0) > 0;
      }
      // TOTP operations
      async getTotpSecret(firebaseUid) {
        const user = await this.getUserByFirebaseUid(firebaseUid);
        return user?.totpSecret || void 0;
      }
      async setTotpSecret(firebaseUid, encryptedSecret) {
        try {
          const result = await this.db.update(users).set({ totpSecret: encryptedSecret }).where(eq(users.firebaseUid, firebaseUid)).returning();
          return result.length > 0;
        } catch (error) {
          console.error("Set TOTP secret error:", error);
          return false;
        }
      }
      async enableTotp(firebaseUid, backupCodes) {
        try {
          const result = await this.db.update(users).set({
            totpEnabled: true,
            totpBackupCodes: backupCodes
          }).where(eq(users.firebaseUid, firebaseUid)).returning();
          return result.length > 0;
        } catch (error) {
          console.error("Enable TOTP error:", error);
          return false;
        }
      }
      async disableTotp(firebaseUid) {
        try {
          const result = await this.db.update(users).set({
            totpEnabled: false,
            totpSecret: null,
            totpBackupCodes: null
          }).where(eq(users.firebaseUid, firebaseUid)).returning();
          return result.length > 0;
        } catch (error) {
          console.error("Disable TOTP error:", error);
          return false;
        }
      }
      async getTotpBackupCodes(firebaseUid) {
        const user = await this.getUserByFirebaseUid(firebaseUid);
        return user?.totpBackupCodes || void 0;
      }
      async updateTotpBackupCodes(firebaseUid, backupCodes) {
        try {
          const result = await this.db.update(users).set({ totpBackupCodes: backupCodes }).where(eq(users.firebaseUid, firebaseUid)).returning();
          return result.length > 0;
        } catch (error) {
          console.error("Update TOTP backup codes error:", error);
          return false;
        }
      }
      async useBackupCode(firebaseUid, code) {
        try {
          const user = await this.getUserByFirebaseUid(firebaseUid);
          if (!user?.totpBackupCodes) return false;
          const backupCodes = user.totpBackupCodes;
          const codeIndex = backupCodes.indexOf(code);
          if (codeIndex === -1) return false;
          const updatedCodes = backupCodes.filter((_, index2) => index2 !== codeIndex);
          await this.updateTotpBackupCodes(firebaseUid, updatedCodes);
          return true;
        } catch (error) {
          console.error("Use backup code error:", error);
          return false;
        }
      }
      // Quota tracking operations
      async updateUserQuota(userId, lookupKey, quota, resetDate) {
        try {
          const result = await this.db.update(users).set({
            monthlyDownloadQuota: quota,
            currentMonthDownloads: 0,
            // Reset downloads when quota is updated
            quotaResetDate: resetDate,
            subscriptionLookupKey: lookupKey
          }).where(eq(users.id, userId)).returning();
          console.log(`\u{1F4CA} Updated quota for user ${userId}: ${quota} downloads/month (${lookupKey})`);
          return result[0];
        } catch (error) {
          console.error("Update user quota error:", error);
          return void 0;
        }
      }
      async incrementUserDownloads(userId) {
        try {
          const user = await this.getUser(userId);
          if (!user) {
            return { success: false, remainingDownloads: 0, quotaExceeded: true };
          }
          const currentDownloads = user.currentMonthDownloads || 0;
          const quota = user.monthlyDownloadQuota || 0;
          if (currentDownloads >= quota && quota > 0) {
            return { success: false, remainingDownloads: 0, quotaExceeded: true };
          }
          const result = await this.db.update(users).set({ currentMonthDownloads: currentDownloads + 1 }).where(eq(users.id, userId)).returning();
          const remainingDownloads = Math.max(0, quota - (currentDownloads + 1));
          console.log(`\u{1F4C8} User ${userId} download count: ${currentDownloads + 1}/${quota} (${remainingDownloads} remaining)`);
          return {
            success: true,
            remainingDownloads,
            quotaExceeded: false
          };
        } catch (error) {
          console.error("Increment user downloads error:", error);
          return { success: false, remainingDownloads: 0, quotaExceeded: true };
        }
      }
      async resetUserQuota(userId) {
        try {
          const nextResetDate = /* @__PURE__ */ new Date();
          nextResetDate.setMonth(nextResetDate.getMonth() + 1);
          nextResetDate.setDate(1);
          nextResetDate.setHours(0, 0, 0, 0);
          const result = await this.db.update(users).set({
            currentMonthDownloads: 0,
            quotaResetDate: nextResetDate
          }).where(eq(users.id, userId)).returning();
          console.log(`\u{1F504} Reset quota for user ${userId}, next reset: ${nextResetDate.toISOString()}`);
          return result[0];
        } catch (error) {
          console.error("Reset user quota error:", error);
          return void 0;
        }
      }
      async getUserQuotaStatus(userId) {
        try {
          const user = await this.getUser(userId);
          if (!user) return void 0;
          const quota = user.monthlyDownloadQuota || 0;
          const used = user.currentMonthDownloads || 0;
          const remaining = Math.max(0, quota - used);
          const resetDate = user.quotaResetDate;
          return { quota, used, remaining, resetDate };
        } catch (error) {
          console.error("Get user quota status error:", error);
          return void 0;
        }
      }
      async checkQuotaAvailable(userId) {
        try {
          const status = await this.getUserQuotaStatus(userId);
          if (!status) return false;
          if (status.quota === 0) return true;
          return status.remaining > 0;
        } catch (error) {
          console.error("Check quota available error:", error);
          return false;
        }
      }
      // Domain Credit operations
      async createDomainCredit(credit) {
        try {
          const result = await this.db.insert(domainCredits).values(credit).returning();
          return result[0];
        } catch (error) {
          if (error.code === "23505" && error.constraint?.includes("source_subscription_id")) {
            console.log(`\u26A0\uFE0F Domain credit already exists for subscription ${credit.sourceSubscriptionId}, returning existing credit`);
            const existing = await this.getDomainCreditsBySubscriptionId(credit.sourceSubscriptionId);
            if (existing.length > 0) {
              return existing[0];
            }
          }
          throw error;
        }
      }
      async getDomainCreditsByUserId(userId) {
        return await this.db.select().from(domainCredits).where(eq(domainCredits.userId, userId)).orderBy(sql2`${domainCredits.issuedAt} DESC`);
      }
      async getDomainCreditsBySubscriptionId(subscriptionId) {
        return await this.db.select().from(domainCredits).where(eq(domainCredits.sourceSubscriptionId, subscriptionId)).orderBy(sql2`${domainCredits.issuedAt} DESC`);
      }
      async getAvailableDomainCredits(userId) {
        const now = /* @__PURE__ */ new Date();
        return await this.db.select().from(domainCredits).where(
          and(
            eq(domainCredits.userId, userId),
            eq(domainCredits.status, "available"),
            sql2`${domainCredits.expiresAt} > ${now}`
          )
        ).orderBy(sql2`${domainCredits.expiresAt} ASC`);
      }
      async updateDomainCreditStatus(id, status, usedDomain, usedAt) {
        const updateData = {
          status
        };
        if (status === "used" && usedDomain && usedAt) {
          updateData.usedDomain = usedDomain;
          updateData.usedAt = usedAt;
        }
        const result = await this.db.update(domainCredits).set(updateData).where(eq(domainCredits.id, id)).returning();
        return result[0];
      }
      async expireDomainCredits() {
        const now = /* @__PURE__ */ new Date();
        await this.db.update(domainCredits).set({ status: "expired" }).where(
          and(
            eq(domainCredits.status, "available"),
            sql2`${domainCredits.expiresAt} <= ${now}`
          )
        );
      }
      // Domain operations
      async createDomain(domain) {
        const result = await this.db.insert(domains).values({
          ...domain,
          updatedAt: /* @__PURE__ */ new Date()
        }).returning();
        return result[0];
      }
      async getDomainsByUserId(userId) {
        return await this.db.select().from(domains).where(eq(domains.userId, userId)).orderBy(sql2`${domains.createdAt} DESC`);
      }
      async getDomainByName(domain) {
        const result = await this.db.select().from(domains).where(eq(domains.domain, domain.toLowerCase())).limit(1);
        return result[0] || null;
      }
      async updateDomainRenewal(id, expiresAt, autorenew) {
        const updateData = {
          expiresAt,
          updatedAt: /* @__PURE__ */ new Date()
        };
        if (autorenew !== void 0) {
          updateData.autorenew = autorenew;
        }
        const result = await this.db.update(domains).set(updateData).where(eq(domains.id, id)).returning();
        return result[0];
      }
      // Imported Icon operations
      async getImportedIcon(id) {
        const result = await this.db.select().from(importedIcons).where(eq(importedIcons.id, id)).limit(1);
        return result[0];
      }
      async getAllImportedIcons() {
        return await this.db.select().from(importedIcons).orderBy(sql2`${importedIcons.createdAt} DESC`);
      }
      async getImportedIconsByStyle(style) {
        return await this.db.select().from(importedIcons).where(eq(importedIcons.style, style)).orderBy(sql2`${importedIcons.createdAt} DESC`);
      }
      async searchImportedIcons(query) {
        const searchTerm = `%${query.toLowerCase()}%`;
        return await this.db.select().from(importedIcons).where(
          sql2`LOWER(${importedIcons.name}) LIKE ${searchTerm} OR 
            EXISTS (
              SELECT 1 FROM unnest(${importedIcons.tags}) AS tag 
              WHERE LOWER(tag) LIKE ${searchTerm}
            )`
        ).orderBy(sql2`${importedIcons.createdAt} DESC`);
      }
      async createImportedIcon(icon) {
        const result = await this.db.insert(importedIcons).values(icon).returning();
        return result[0];
      }
      async createImportedIcons(icons) {
        const result = await this.db.insert(importedIcons).values(icons).returning();
        return result;
      }
      async deleteImportedIcon(id) {
        try {
          const icon = await this.getImportedIcon(id);
          if (!icon) {
            return false;
          }
          const { ObjectStorageService: ObjectStorageService2 } = await Promise.resolve().then(() => (init_objectStorage(), objectStorage_exports));
          const objectStorageService3 = new ObjectStorageService2();
          const iconName = icon.name.toLowerCase().replace(/[^a-z0-9]/g, "_");
          const patterns = [
            `icons/preview/${id}`,
            // Preview files by ID
            `icons/svg/${id}`,
            // SVG files by ID  
            `icons/png/${id}`,
            // PNG files by ID
            `icons/preview/*/${iconName}`,
            // Preview files by name in UUID folders
            `icons/svg/*/${iconName}`,
            // SVG files by name in UUID folders
            `icons/png/*/${iconName}`
            // PNG files by name in UUID folders
          ];
          let filesDeleted = false;
          for (const pattern of patterns) {
            try {
              const deleted = await objectStorageService3.deleteFilesByPattern(pattern);
              if (deleted) {
                filesDeleted = true;
                console.log(`\u{1F5D1}\uFE0F Deleted object storage files matching pattern: ${pattern}`);
              }
            } catch (error) {
              console.warn(`Failed to delete files matching pattern ${pattern}:`, error);
            }
          }
          try {
            const exactPatterns = [
              `icons/preview/${id}.png`,
              `icons/svg/${id}.svg`,
              `icons/png/${id}.png`
            ];
            for (const exactPattern of exactPatterns) {
              try {
                const deleted = await objectStorageService3.deleteFile(exactPattern);
                if (deleted) {
                  filesDeleted = true;
                  console.log(`\u{1F5D1}\uFE0F Deleted exact file: ${exactPattern}`);
                }
              } catch (error) {
              }
            }
          } catch (error) {
            console.warn(`Error during exact file deletion:`, error);
          }
          const result = await this.db.delete(importedIcons).where(eq(importedIcons.id, id));
          const dbDeleted = (result.rowCount ?? 0) > 0;
          if (dbDeleted) {
            console.log(`\u2705 Deleted icon "${icon.name}" (ID: ${id}) from database and object storage`);
          }
          return dbDeleted;
        } catch (error) {
          console.error(`Error deleting imported icon ${id}:`, error);
          return false;
        }
      }
      // Visitor Analytics operations
      async getVisitorSessionBySessionId(sessionId) {
        const result = await this.db.select().from(visitorSessions).where(eq(visitorSessions.sessionId, sessionId)).limit(1);
        return result[0];
      }
      async createVisitorSession(session) {
        const result = await this.db.insert(visitorSessions).values({
          ...session,
          updatedAt: /* @__PURE__ */ new Date()
        }).returning();
        return result[0];
      }
      async updateVisitorSession(id, session) {
        const result = await this.db.update(visitorSessions).set({
          ...session,
          updatedAt: /* @__PURE__ */ new Date()
        }).where(eq(visitorSessions.id, id)).returning();
        return result[0];
      }
      async getDailyVisitorStatsByDate(date) {
        const result = await this.db.select().from(dailyVisitorStats).where(eq(dailyVisitorStats.date, date)).limit(1);
        return result[0];
      }
      async createDailyVisitorStats(stats) {
        const result = await this.db.insert(dailyVisitorStats).values({
          ...stats,
          updatedAt: /* @__PURE__ */ new Date()
        }).returning();
        return result[0];
      }
      async updateDailyVisitorStats(id, stats) {
        const result = await this.db.update(dailyVisitorStats).set({
          ...stats,
          updatedAt: /* @__PURE__ */ new Date()
        }).where(eq(dailyVisitorStats.id, id)).returning();
        return result[0];
      }
      async getRecentVisitorSessions(days = 7, limit = 100) {
        const cutoffDate = /* @__PURE__ */ new Date();
        cutoffDate.setDate(cutoffDate.getDate() - days);
        return await this.db.select().from(visitorSessions).where(sql2`${visitorSessions.createdAt} >= ${cutoffDate}`).orderBy(sql2`${visitorSessions.createdAt} DESC`).limit(limit);
      }
      async getDailyVisitorStatsRange(startDate, endDate) {
        return await this.db.select().from(dailyVisitorStats).where(
          and(
            sql2`${dailyVisitorStats.date} >= ${startDate}`,
            sql2`${dailyVisitorStats.date} <= ${endDate}`
          )
        ).orderBy(sql2`${dailyVisitorStats.date} ASC`);
      }
      async deleteVisitorSessionsOlderThan(cutoffDate) {
        await this.db.delete(visitorSessions).where(sql2`${visitorSessions.createdAt} < ${cutoffDate}`);
      }
      // Cart operations
      async getCartItems(userId, sessionId) {
        if (!userId && !sessionId) {
          return [];
        }
        const whereClause = userId ? eq(cartItems.userId, userId) : sessionId ? eq(cartItems.sessionId, sessionId) : sql2`false`;
        return await this.db.select().from(cartItems).where(whereClause);
      }
      async addCartItem(cartItem) {
        const result = await this.db.insert(cartItems).values(cartItem).returning();
        return result[0];
      }
      async updateCartItem(id, cartItem) {
        const result = await this.db.update(cartItems).set({ ...cartItem, updatedAt: /* @__PURE__ */ new Date() }).where(eq(cartItems.id, id)).returning();
        return result[0];
      }
      async removeCartItem(id) {
        const result = await this.db.delete(cartItems).where(eq(cartItems.id, id)).returning();
        return result.length > 0;
      }
      async clearCart(userId, sessionId) {
        if (!userId && !sessionId) {
          return;
        }
        const whereClause = userId ? eq(cartItems.userId, userId) : sessionId ? eq(cartItems.sessionId, sessionId) : sql2`false`;
        await this.db.delete(cartItems).where(whereClause);
      }
      // Purchase operations
      async createPurchase(purchase) {
        const result = await this.db.insert(purchases).values(purchase).returning();
        return result[0];
      }
      async getPurchase(id) {
        const result = await this.db.select().from(purchases).where(eq(purchases.id, id)).limit(1);
        return result[0];
      }
      async getPurchaseByStripeSessionId(stripeSessionId) {
        const result = await this.db.select().from(purchases).where(eq(purchases.stripeSessionId, stripeSessionId)).limit(1);
        return result[0];
      }
      async updatePurchase(id, purchase) {
        const result = await this.db.update(purchases).set(purchase).where(eq(purchases.id, id)).returning();
        return result[0];
      }
      async getUserPurchases(userId) {
        return await this.db.select().from(purchases).where(eq(purchases.userId, userId));
      }
      // User Entitlement operations
      async createUserEntitlement(entitlement) {
        const result = await this.db.insert(userEntitlements).values(entitlement).returning();
        return result[0];
      }
      async getUserEntitlements(userId) {
        return await this.db.select().from(userEntitlements).where(eq(userEntitlements.userId, userId));
      }
      async getUserEntitlementsByType(userId, type) {
        return await this.db.select().from(userEntitlements).where(and(
          eq(userEntitlements.userId, userId),
          eq(userEntitlements.entitlementType, type)
        ));
      }
      async getUserEntitlementByUserAndItem(userId, entitlementType, entitlementId) {
        const result = await this.db.select().from(userEntitlements).where(and(
          eq(userEntitlements.userId, userId),
          eq(userEntitlements.entitlementType, entitlementType),
          eq(userEntitlements.entitlementId, entitlementId),
          eq(userEntitlements.status, "active")
        )).limit(1);
        return result[0];
      }
      async hasEntitlement(userId, entitlementType, entitlementId) {
        const result = await this.db.select().from(userEntitlements).where(and(
          eq(userEntitlements.userId, userId),
          eq(userEntitlements.entitlementType, entitlementType),
          eq(userEntitlements.entitlementId, entitlementId),
          eq(userEntitlements.status, "active")
        )).limit(1);
        return result.length > 0;
      }
      async updateUserEntitlement(id, entitlement) {
        const result = await this.db.update(userEntitlements).set({ ...entitlement, updatedAt: /* @__PURE__ */ new Date() }).where(eq(userEntitlements.id, id)).returning();
        return result[0];
      }
      // Creator Marketplace operations
      // Creator operations
      async getCreator(id) {
        const result = await this.db.select().from(creators).where(eq(creators.id, id)).limit(1);
        return result[0];
      }
      async getCreatorByUserId(userId) {
        const result = await this.db.select().from(creators).where(eq(creators.userId, userId)).limit(1);
        return result[0];
      }
      async getCreatorByStripeAccountId(stripeAccountId) {
        const result = await this.db.select().from(creators).where(eq(creators.stripeConnectAccountId, stripeAccountId)).limit(1);
        return result[0];
      }
      async getAllCreators() {
        return await this.db.select().from(creators);
      }
      async createCreator(creator) {
        const result = await this.db.insert(creators).values({
          ...creator,
          updatedAt: /* @__PURE__ */ new Date()
        }).returning();
        return result[0];
      }
      async updateCreator(id, creator) {
        const result = await this.db.update(creators).set({ ...creator, updatedAt: /* @__PURE__ */ new Date() }).where(eq(creators.id, id)).returning();
        return result[0];
      }
      async deleteCreator(id) {
        const result = await this.db.delete(creators).where(eq(creators.id, id));
        return (result.rowCount ?? 0) > 0;
      }
      async updateCreatorEarnings(creatorId, earningsChange) {
        const result = await this.db.update(creators).set({
          totalEarnings: sql2`${creators.totalEarnings} + ${earningsChange}`,
          updatedAt: /* @__PURE__ */ new Date()
        }).where(eq(creators.id, creatorId)).returning();
        return result[0];
      }
      // Asset operations
      async getAsset(id) {
        const result = await this.db.select().from(assets).where(eq(assets.id, id)).limit(1);
        return result[0];
      }
      async getAssetsByCreatorId(creatorId) {
        return await this.db.select().from(assets).where(eq(assets.creatorId, creatorId));
      }
      async getAllAssets() {
        return await this.db.select().from(assets);
      }
      async getPublicAssets() {
        return await this.db.select().from(assets).where(eq(assets.isPublic, true));
      }
      async createAsset(asset) {
        const result = await this.db.insert(assets).values({
          ...asset,
          updatedAt: /* @__PURE__ */ new Date()
        }).returning();
        return result[0];
      }
      async updateAsset(id, asset) {
        const result = await this.db.update(assets).set({ ...asset, updatedAt: /* @__PURE__ */ new Date() }).where(eq(assets.id, id)).returning();
        return result[0];
      }
      async deleteAsset(id) {
        const result = await this.db.delete(assets).where(eq(assets.id, id));
        return (result.rowCount ?? 0) > 0;
      }
      async incrementAssetDownloadCount(id) {
        const result = await this.db.update(assets).set({
          downloadCount: sql2`${assets.downloadCount} + 1`,
          updatedAt: /* @__PURE__ */ new Date()
        }).where(eq(assets.id, id)).returning();
        return result[0];
      }
      // Creator Asset operations
      async getCreatorAsset(id) {
        const result = await this.db.select().from(creatorAssets).where(eq(creatorAssets.id, id)).limit(1);
        return result[0];
      }
      async getCreatorAssetsByCreatorId(creatorId) {
        return await this.db.select().from(creatorAssets).where(eq(creatorAssets.creatorId, creatorId));
      }
      async getCreatorAssetsByAssetId(assetId) {
        return await this.db.select().from(creatorAssets).where(eq(creatorAssets.assetId, assetId));
      }
      async getCreatorAssetsByStatus(status) {
        return await this.db.select().from(creatorAssets).where(eq(creatorAssets.approvalStatus, status));
      }
      async getAllCreatorAssets() {
        return await this.db.select().from(creatorAssets);
      }
      async createCreatorAsset(creatorAsset) {
        const result = await this.db.insert(creatorAssets).values({
          ...creatorAsset,
          updatedAt: /* @__PURE__ */ new Date()
        }).returning();
        return result[0];
      }
      async updateCreatorAsset(id, creatorAsset) {
        const result = await this.db.update(creatorAssets).set({ ...creatorAsset, updatedAt: /* @__PURE__ */ new Date() }).where(eq(creatorAssets.id, id)).returning();
        return result[0];
      }
      async deleteCreatorAsset(id) {
        const result = await this.db.delete(creatorAssets).where(eq(creatorAssets.id, id));
        return (result.rowCount ?? 0) > 0;
      }
      async approveCreatorAsset(id, approvedBy2) {
        const currentAsset = await this.getCreatorAsset(id);
        if (!currentAsset) {
          throw new Error("Asset not found for approval");
        }
        if (currentAsset.approvalStatus !== "pending") {
          throw new Error(`Invalid state transition: cannot approve asset with status '${currentAsset.approvalStatus}'`);
        }
        const result = await this.db.update(creatorAssets).set({
          approvalStatus: "approved",
          approvedAt: /* @__PURE__ */ new Date(),
          approvedBy: approvedBy2,
          updatedAt: /* @__PURE__ */ new Date()
        }).where(eq(creatorAssets.id, id)).returning();
        const updatedAsset = result[0];
        if (updatedAsset) {
          console.log(`\u{1F4C8} AUDIT: Asset '${currentAsset.title}' (${id}) approved by ${approvedBy2}. Status: ${currentAsset.approvalStatus} \u2192 ${updatedAsset.approvalStatus}`);
        }
        return updatedAsset;
      }
      async rejectCreatorAsset(id, rejectionReason) {
        const currentAsset = await this.getCreatorAsset(id);
        if (!currentAsset) {
          throw new Error("Asset not found for rejection");
        }
        if (!["pending", "approved"].includes(currentAsset.approvalStatus)) {
          throw new Error(`Invalid state transition: cannot reject asset with status '${currentAsset.approvalStatus}'`);
        }
        const result = await this.db.update(creatorAssets).set({
          approvalStatus: "rejected",
          rejectionReason,
          rejectedAt: /* @__PURE__ */ new Date(),
          approvedBy,
          updatedAt: /* @__PURE__ */ new Date()
        }).where(eq(creatorAssets.id, id)).returning();
        return result[0];
      }
      async rejectCreatorAsset(id, rejectionReason) {
        const result = await this.db.update(creatorAssets).set({
          approvalStatus: "rejected",
          rejectionReason,
          updatedAt: /* @__PURE__ */ new Date()
        }).where(eq(creatorAssets.id, id)).returning();
        return result[0];
      }
      async incrementCreatorAssetSales(id, revenue) {
        const result = await this.db.update(creatorAssets).set({
          salesCount: sql2`${creatorAssets.salesCount} + 1`,
          totalRevenue: sql2`${creatorAssets.totalRevenue} + ${revenue}`,
          updatedAt: /* @__PURE__ */ new Date()
        }).where(eq(creatorAssets.id, id)).returning();
        return result[0];
      }
      // Creator Earning operations
      async getCreatorEarning(id) {
        const result = await this.db.select().from(creatorEarnings).where(eq(creatorEarnings.id, id)).limit(1);
        return result[0];
      }
      async getCreatorEarningsByCreatorId(creatorId) {
        return await this.db.select().from(creatorEarnings).where(eq(creatorEarnings.creatorId, creatorId));
      }
      async getCreatorEarningsByStatus(status) {
        return await this.db.select().from(creatorEarnings).where(eq(creatorEarnings.payoutStatus, status));
      }
      async getAllCreatorEarnings() {
        return await this.db.select().from(creatorEarnings);
      }
      async createCreatorEarning(earning) {
        const result = await this.db.insert(creatorEarnings).values(earning).returning();
        return result[0];
      }
      async updateCreatorEarning(id, earning) {
        const result = await this.db.update(creatorEarnings).set(earning).where(eq(creatorEarnings.id, id)).returning();
        return result[0];
      }
      async processCreatorPayout(creatorId, payoutReference) {
        const result = await this.db.update(creatorEarnings).set({
          payoutStatus: "paid",
          payoutDate: /* @__PURE__ */ new Date(),
          payoutReference
        }).where(and(
          eq(creatorEarnings.creatorId, creatorId),
          eq(creatorEarnings.payoutStatus, "pending")
        )).returning();
        return result;
      }
      // Cover Template operations
      async getCoverTemplate(id) {
        const result = await this.db.select().from(coverTemplates).where(eq(coverTemplates.id, id)).limit(1);
        return result[0];
      }
      async getCoverTemplates(opts = {}) {
        const conditions = [];
        if (!opts.includeInactive) {
          conditions.push(eq(coverTemplates.isActive, true));
        }
        if (!opts.includeInactive) {
          conditions.push(eq(coverTemplates.approvalStatus, "approved"));
        }
        if (opts.category) {
          conditions.push(eq(coverTemplates.category, opts.category));
        }
        if (opts.top_tier) {
          conditions.push(eq(coverTemplates.topTier, opts.top_tier));
        }
        if (opts.subcat) {
          conditions.push(sql2`${opts.subcat} = ANY (${coverTemplates.subcategories})`);
        }
        if (opts.min !== void 0) {
          conditions.push(gte(coverTemplates.priceCents, opts.min));
        }
        if (opts.max !== void 0) {
          conditions.push(lte(coverTemplates.priceCents, opts.max));
        }
        if (opts.q) {
          conditions.push(ilike(coverTemplates.title, `%${opts.q}%`));
        }
        const whereCondition = conditions.length > 0 ? and(...conditions) : void 0;
        return await this.db.select().from(coverTemplates).where(whereCondition).orderBy(desc(coverTemplates.createdAt));
      }
      async createCoverTemplate(template) {
        const result = await this.db.insert(coverTemplates).values(template).returning();
        return result[0];
      }
      async updateCoverTemplate(id, template) {
        const result = await this.db.update(coverTemplates).set(template).where(eq(coverTemplates.id, id)).returning();
        return result[0];
      }
      async deleteCoverTemplate(id) {
        const result = await this.db.delete(coverTemplates).where(eq(coverTemplates.id, id));
        return result.rowCount > 0;
      }
      // Infographic Template operations
      async getInfographicTemplate(id) {
        const result = await this.db.select().from(infographicTemplates).where(eq(infographicTemplates.id, id)).limit(1);
        return result[0];
      }
      async getInfographicTemplates(opts = {}) {
        const conditions = [];
        if (!opts.includeInactive) {
          conditions.push(eq(infographicTemplates.isActive, true));
        }
        if (opts.status && opts.status !== "all") {
          conditions.push(eq(infographicTemplates.approvalStatus, opts.status));
        } else if (!opts.includeInactive) {
          conditions.push(eq(infographicTemplates.approvalStatus, "approved"));
        }
        if (opts.category) {
          conditions.push(eq(infographicTemplates.category, opts.category));
        }
        if (opts.descriptors && opts.descriptors.length > 0) {
          for (const descriptor of opts.descriptors) {
            conditions.push(sql2`${descriptor.toLowerCase()} = ANY(${infographicTemplates.descriptors})`);
          }
        }
        if (opts.q) {
          conditions.push(or(
            ilike(infographicTemplates.title, `%${opts.q}%`),
            sql2`${infographicTemplates.descriptors}::text ILIKE ${`%${opts.q}%`}`
          ));
        }
        if (typeof opts.min === "number") {
          conditions.push(gte(infographicTemplates.priceCents, opts.min));
        }
        if (typeof opts.max === "number") {
          conditions.push(lte(infographicTemplates.priceCents, opts.max));
        }
        const whereCondition = conditions.length > 0 ? and(...conditions) : void 0;
        return await this.db.select().from(infographicTemplates).where(whereCondition).orderBy(desc(infographicTemplates.createdAt));
      }
      async createInfographicTemplate(template) {
        const result = await this.db.insert(infographicTemplates).values(template).returning();
        return result[0];
      }
      async updateInfographicTemplate(id, template) {
        const result = await this.db.update(infographicTemplates).set(template).where(eq(infographicTemplates.id, id)).returning();
        return result[0];
      }
      async deleteInfographicTemplate(id) {
        const result = await this.db.delete(infographicTemplates).where(eq(infographicTemplates.id, id));
        return result.rowCount > 0;
      }
      // Cover Purchase operations
      async getCoverPurchase(id) {
        const result = await this.db.select().from(coverPurchases).where(eq(coverPurchases.id, id)).limit(1);
        return result[0];
      }
      async getUserCoverPurchases(userId) {
        return await this.db.select().from(coverPurchases).where(eq(coverPurchases.userId, userId));
      }
      async createCoverPurchase(purchase) {
        const result = await this.db.insert(coverPurchases).values(purchase).returning();
        return result[0];
      }
      async updateCoverPurchase(id, purchase) {
        const result = await this.db.update(coverPurchases).set(purchase).where(eq(coverPurchases.id, id)).returning();
        return result[0];
      }
      async markPurchasePaidBySession(sessionId, paymentIntent, downloadUrl, actualAmountCents, actualCurrency) {
        const updateData = {
          status: "paid",
          stripePaymentIntent: paymentIntent,
          downloadUrl
        };
        if (actualAmountCents !== void 0) updateData.amountCents = actualAmountCents;
        if (actualCurrency !== void 0) updateData.currency = actualCurrency;
        const result = await this.db.update(coverPurchases).set(updateData).where(eq(coverPurchases.stripeSessionId, sessionId)).returning();
        return result[0];
      }
      // Infographic Purchase operations
      async getInfographicPurchase(id) {
        const result = await this.db.select().from(infographicPurchases).where(eq(infographicPurchases.id, id)).limit(1);
        return result[0];
      }
      async getUserInfographicPurchases(userId) {
        return await this.db.select().from(infographicPurchases).where(eq(infographicPurchases.userId, userId));
      }
      async createInfographicPurchase(purchase) {
        const result = await this.db.insert(infographicPurchases).values(purchase).returning();
        return result[0];
      }
      async updateInfographicPurchase(id, purchase) {
        const result = await this.db.update(infographicPurchases).set(purchase).where(eq(infographicPurchases.id, id)).returning();
        return result[0];
      }
      async markInfographicPurchasePaidBySession(sessionId, paymentIntent, downloadUrl, actualAmountCents, actualCurrency) {
        const updateData = {
          status: "paid",
          stripePaymentIntent: paymentIntent,
          downloadUrl
        };
        if (actualAmountCents !== void 0) updateData.amountCents = actualAmountCents;
        if (actualCurrency !== void 0) updateData.currency = actualCurrency;
        const result = await this.db.update(infographicPurchases).set(updateData).where(eq(infographicPurchases.stripeSessionId, sessionId)).returning();
        return result[0];
      }
      // Presentation Template operations
      async getPresentationTemplate(id) {
        const result = await this.db.select().from(presentationTemplates).where(eq(presentationTemplates.id, id)).limit(1);
        return result[0];
      }
      async getPresentationTemplates(opts = {}) {
        const conditions = [];
        if (!opts.includeInactive) {
          conditions.push(eq(presentationTemplates.isActive, true));
        }
        if (opts.status && opts.status !== "all") {
          conditions.push(eq(presentationTemplates.approvalStatus, opts.status));
        } else if (!opts.includeInactive) {
          conditions.push(eq(presentationTemplates.approvalStatus, "approved"));
        }
        if (opts.category) {
          conditions.push(eq(presentationTemplates.category, opts.category));
        }
        if (opts.descriptors && opts.descriptors.length > 0) {
          for (const descriptor of opts.descriptors) {
            conditions.push(sql2`${descriptor.toLowerCase()} = ANY(${presentationTemplates.subcategories})`);
          }
        }
        if (opts.q) {
          conditions.push(or(
            ilike(presentationTemplates.title, `%${opts.q}%`),
            sql2`${presentationTemplates.subcategories}::text ILIKE ${`%${opts.q}%`}`
          ));
        }
        const whereCondition = conditions.length > 0 ? and(...conditions) : void 0;
        return await this.db.select().from(presentationTemplates).where(whereCondition).orderBy(desc(presentationTemplates.createdAt));
      }
      async createPresentationTemplate(template) {
        const result = await this.db.insert(presentationTemplates).values(template).returning();
        return result[0];
      }
      async updatePresentationTemplate(id, template) {
        const result = await this.db.update(presentationTemplates).set(template).where(eq(presentationTemplates.id, id)).returning();
        return result[0];
      }
      async deletePresentationTemplate(id) {
        const result = await this.db.delete(presentationTemplates).where(eq(presentationTemplates.id, id));
        return result.rowCount > 0;
      }
      // Presentation Purchase operations
      async getPresentationPurchase(id) {
        const result = await this.db.select().from(presentationPurchases).where(eq(presentationPurchases.id, id)).limit(1);
        return result[0];
      }
      async getUserPresentationPurchases(userId) {
        return await this.db.select().from(presentationPurchases).where(eq(presentationPurchases.userId, userId));
      }
      async createPresentationPurchase(purchase) {
        const result = await this.db.insert(presentationPurchases).values(purchase).returning();
        return result[0];
      }
      async updatePresentationPurchase(id, purchase) {
        const result = await this.db.update(presentationPurchases).set(purchase).where(eq(presentationPurchases.id, id)).returning();
        return result[0];
      }
      async markPresentationPurchasePaidBySession(sessionId, paymentIntent, downloadUrl, actualAmountCents, actualCurrency) {
        const updateData = {
          status: "paid",
          stripePaymentIntent: paymentIntent,
          downloadUrl
        };
        if (actualAmountCents !== void 0) updateData.amountCents = actualAmountCents;
        if (actualCurrency !== void 0) updateData.currency = actualCurrency;
        const result = await this.db.update(presentationPurchases).set(updateData).where(eq(presentationPurchases.stripeSessionId, sessionId)).returning();
        return result[0];
      }
    };
    storage = new PostgreSQLStorage();
  }
});

// server/admin/firebaseAdmin.ts
async function initializeFirebaseAdmin() {
  if (isInitialized) return admin;
  try {
    const firebaseAdminModule = await import("firebase-admin");
    admin = firebaseAdminModule.default || firebaseAdminModule;
    const creds = {
      projectId: process.env.FIREBASE_PROJECT_ID,
      clientEmail: process.env.FIREBASE_CLIENT_EMAIL,
      privateKey: (process.env.FIREBASE_PRIVATE_KEY || "").replace(/\\n/g, "\n")
    };
    if (!admin.apps.length) {
      admin.initializeApp({ credential: admin.credential.cert(creds) });
    }
    isInitialized = true;
    return admin;
  } catch (error) {
    console.warn("Firebase Admin SDK not available:", error);
    return null;
  }
}
async function verifyAdminBearer(authHeader, minimumRole = "staff") {
  const adminInstance = await initializeFirebaseAdmin();
  if (!adminInstance) {
    throw new Error("Firebase Admin SDK not initialized");
  }
  if (!authHeader?.startsWith("Bearer ")) throw new Error("missing");
  const token = authHeader.slice(7);
  const decoded = await adminInstance.auth().verifyIdToken(token, true);
  if (decoded.role) {
    const userRole = decoded.role;
    if (!ADMIN_ROLES.includes(userRole)) {
      console.log(`User ${decoded.uid} has non-admin role: ${userRole}`);
      throw new Error("insufficient_role");
    }
    if (ROLE_HIERARCHY[userRole] < ROLE_HIERARCHY[minimumRole]) {
      console.log(`User ${decoded.uid} role ${userRole} insufficient for minimum ${minimumRole}`);
      throw new Error("insufficient_role");
    }
    console.log(`\u2705 Role-based auth success: ${decoded.uid} (${userRole})`);
    return { ...decoded, role: userRole };
  }
  if (decoded.admin === true) {
    console.log(`\u26A0\uFE0F Legacy admin token detected for ${decoded.uid}, treating as 'owner'`);
    return { ...decoded, role: "owner" };
  }
  console.log(`\u274C No valid admin role or legacy admin claim for ${decoded.uid}`);
  throw new Error("not_admin");
}
async function setUserRole(uid, role, setByUid) {
  const adminInstance = await initializeFirebaseAdmin();
  if (!adminInstance) {
    throw new Error("Firebase Admin SDK not initialized");
  }
  try {
    await adminInstance.auth().setCustomUserClaims(uid, { role });
    console.log(`\u2705 Set role '${role}' for user ${uid}${setByUid ? ` (set by ${setByUid})` : ""}`);
    const user = await adminInstance.auth().getUser(uid);
    if (user.customClaims?.admin !== void 0) {
      const updatedClaims = { ...user.customClaims };
      delete updatedClaims.admin;
      updatedClaims.role = role;
      await adminInstance.auth().setCustomUserClaims(uid, updatedClaims);
      console.log(`\u{1F504} Migrated legacy admin claim to role '${role}' for user ${uid}`);
    }
  } catch (error) {
    console.error(`\u274C Failed to set role '${role}' for user ${uid}:`, error);
    throw error;
  }
}
async function getUserRole(uid) {
  const adminInstance = await initializeFirebaseAdmin();
  if (!adminInstance) {
    throw new Error("Firebase Admin SDK not initialized");
  }
  try {
    const user = await adminInstance.auth().getUser(uid);
    const customClaims = user.customClaims || {};
    if (customClaims.role) {
      return customClaims.role;
    }
    if (customClaims.admin === true) {
      return "owner";
    }
    return null;
  } catch (error) {
    console.error(`\u274C Failed to get role for user ${uid}:`, error);
    throw error;
  }
}
function hasRolePermission(userRole, requiredRole) {
  return ROLE_HIERARCHY[userRole] >= ROLE_HIERARCHY[requiredRole];
}
async function getFirebaseAdmin() {
  return await initializeFirebaseAdmin();
}
var admin, isInitialized, ROLE_HIERARCHY, ADMIN_ROLES;
var init_firebaseAdmin = __esm({
  "server/admin/firebaseAdmin.ts"() {
    "use strict";
    isInitialized = false;
    ROLE_HIERARCHY = {
      "owner": 4,
      "management": 3,
      "manager": 3,
      // Compatibility alias for management
      "creator": 2.5,
      "staff": 2,
      "analyst": 1,
      "pro": 0,
      "user": 0
    };
    ADMIN_ROLES = ["owner", "management", "manager", "staff", "analyst"];
  }
});

// server/middleware/adminGuard.ts
function isOwnerEmailServerSide(email) {
  if (!email) return false;
  const normalizedEmail = email.trim().toLowerCase();
  const isOwner = OWNER_EMAILS.includes(normalizedEmail);
  console.log(`\u{1F510} Admin Guard - Owner check for ${email}: ${isOwner}`);
  return isOwner;
}
async function requireAdmin(req, res, next) {
  const adminKey = req.header("x-admin-key");
  const expectedKey = process.env.MANAGER_KEY;
  if (expectedKey && adminKey === expectedKey) {
    console.log("\u2705 Admin access granted via MANAGER_KEY");
    return next();
  }
  try {
    const authHeader = req.headers.authorization;
    const token = authHeader && authHeader.split(" ")[1];
    if (token) {
      const admin2 = await getFirebaseAdmin();
      if (admin2) {
        const decodedToken = await admin2.auth().verifyIdToken(token);
        const userEmail = decodedToken.email;
        if (isOwnerEmailServerSide(userEmail)) {
          console.log(`\u2705 Admin access granted to owner: ${userEmail}`);
          req.user = decodedToken;
          return next();
        }
      }
    }
  } catch (error) {
    console.error("Firebase auth verification failed:", error);
  }
  if (!expectedKey) {
    console.error("MANAGER_KEY not configured in environment variables");
    return res.status(500).json({ error: "Admin authentication not configured" });
  }
  return res.status(403).json({ error: "Admin access denied. Provide valid admin key or authenticate as owner." });
}
var OWNER_EMAILS;
var init_adminGuard = __esm({
  "server/middleware/adminGuard.ts"() {
    "use strict";
    init_firebaseAdmin();
    OWNER_EMAILS = (process.env.IBRANDBIZ_OWNER_EMAILS || "jrichards@ibrandbiz.com").split(",").map((email) => email.trim().toLowerCase()).filter((email) => email.length > 0);
  }
});

// server/config/priceQuotas.js
var init_priceQuotas = __esm({
  "server/config/priceQuotas.js"() {
    "use strict";
  }
});

// server/services/entitlements.js
import fs from "fs";
import path from "path";
function ensureDB() {
  if (!fs.existsSync(DB_DIR)) fs.mkdirSync(DB_DIR, { recursive: true });
  if (!fs.existsSync(DB_FILE)) {
    fs.writeFileSync(DB_FILE, JSON.stringify({ users: {} }, null, 2));
  }
}
function load() {
  ensureDB();
  return JSON.parse(fs.readFileSync(DB_FILE, "utf8"));
}
function save(db2) {
  fs.writeFileSync(DB_FILE, JSON.stringify(db2, null, 2));
}
function getUser(db2, userId) {
  if (!db2.users[userId]) db2.users[userId] = { licenses: {}, quotas: [] };
  return db2.users[userId];
}
function grantLicenses(userId, assetIds = []) {
  if (!userId || !assetIds.length) return;
  const db2 = load();
  const user = getUser(db2, userId);
  for (const id of assetIds) user.licenses[id] = true;
  save(db2);
}
function hasLicense(userId, assetId) {
  if (!userId) return false;
  const db2 = load();
  const user = getUser(db2, userId);
  return !!user.licenses[assetId];
}
function getTotalRemaining(userId, now = Date.now()) {
  if (!userId) return 0;
  const db2 = load();
  const user = getUser(db2, userId);
  return user.quotas.filter((q) => q.periodStart <= now && now < q.periodEnd).reduce((sum, q) => sum + Math.max(0, q.remaining || 0), 0);
}
function decrementOne(userId, now = Date.now()) {
  if (!userId) return false;
  const db2 = load();
  const user = getUser(db2, userId);
  const active = user.quotas.filter((q) => q.periodStart <= now && now < q.periodEnd && (q.remaining || 0) > 0).sort((a, b) => a.periodEnd - b.periodEnd);
  if (!active.length) return false;
  active[0].remaining = Math.max(0, (active[0].remaining || 0) - 1);
  active[0].updatedAt = now;
  save(db2);
  return true;
}
var DB_DIR, DB_FILE;
var init_entitlements = __esm({
  "server/services/entitlements.js"() {
    "use strict";
    init_priceQuotas();
    DB_DIR = path.join(process.cwd(), "data");
    DB_FILE = path.join(DB_DIR, "entitlements-db.json");
  }
});

// server/firebaseAdmin.ts
var firebaseAdmin_exports = {};
__export(firebaseAdmin_exports, {
  adminApp: () => adminApp,
  bucket: () => bucket,
  db: () => db
});
import { initializeApp, getApps, getApp } from "firebase-admin/app";
import { getStorage } from "firebase-admin/storage";
import { getFirestore } from "firebase-admin/firestore";
import { cert } from "firebase-admin/app";
function initializeFirebaseAdmin2() {
  if (getApps().length > 0) {
    return getApp();
  }
  const serviceAccount = process.env.FIREBASE_SERVICE_ACCOUNT_KEY;
  if (!serviceAccount) {
    throw new Error("FIREBASE_SERVICE_ACCOUNT_KEY environment variable not set");
  }
  const serviceAccountData = JSON.parse(serviceAccount);
  const app2 = initializeApp({
    credential: cert(serviceAccountData),
    storageBucket: STORAGE_BUCKET
  });
  console.log("[Admin] Storage bucket:", STORAGE_BUCKET);
  return app2;
}
var STORAGE_BUCKET, adminApp, bucket, db;
var init_firebaseAdmin2 = __esm({
  "server/firebaseAdmin.ts"() {
    "use strict";
    STORAGE_BUCKET = process.env.FB_STORAGE_BUCKET || "ibrandbiz-bcfbe.firebasestorage.app";
    adminApp = initializeFirebaseAdmin2();
    bucket = getStorage(adminApp).bucket(STORAGE_BUCKET);
    db = getFirestore(adminApp);
    console.log("[Admin] Storage bucket bound to:", bucket.name);
  }
});

// server/ai-section.ts
var ai_section_exports = {};
__export(ai_section_exports, {
  generateFallbackContent: () => generateFallbackContent,
  generateStructuredTemplate: () => generateStructuredTemplate,
  processAiSectionJob: () => processAiSectionJob
});
import OpenAI4 from "openai";
async function processAiSectionJob(job) {
  try {
    if (!job.action || !job.sectionKind || !job.sectionTitle) {
      return {
        success: false,
        error: "Missing required fields: action, sectionKind, and sectionTitle are required"
      };
    }
    const tone = job.tone || "Professional";
    if (!["generate", "rephrase", "expand", "summarize"].includes(job.action)) {
      return {
        success: false,
        error: `Invalid action: ${job.action}. Must be one of: generate, rephrase, expand, summarize`
      };
    }
    if (tone && !["Professional", "Friendly", "Bold", "Minimal"].includes(tone)) {
      return {
        success: false,
        error: `Invalid tone: ${tone}. Must be one of: Professional, Friendly, Bold, Minimal`
      };
    }
    if (["rephrase", "expand", "summarize"].includes(job.action) && (!job.existingContent || job.existingContent.trim().length === 0)) {
      return {
        success: false,
        error: `Action "${job.action}" requires existing content to work with`
      };
    }
    const systemPrompt = TONE_SYSTEM_PROMPTS2[job.tone];
    const actionPromptFunction = ACTION_PROMPTS[job.action];
    const userPrompt = actionPromptFunction(job);
    console.log(`\u{1F916} Processing AI section job: ${job.action} for "${job.sectionTitle}" in ${job.tone} tone`);
    try {
      const startTime = Date.now();
      const completion = await openai4.chat.completions.create({
        model: DEFAULT_CONFIG.model,
        messages: [
          {
            role: "system",
            content: systemPrompt
          },
          {
            role: "user",
            content: userPrompt
          }
        ],
        max_completion_tokens: DEFAULT_CONFIG.maxTokens
      });
      const latencyMs = Date.now() - startTime;
      const content = completion.choices[0]?.message?.content;
      if (!content) {
        throw new Error("No content received from GPT-5");
      }
      const cleanedContent = content.trim().replace(/\n{3,}/g, "\n\n");
      console.log(`\u2705 AI section job completed: ${job.action} for "${job.sectionTitle}" | model: ${DEFAULT_CONFIG.model} | latency: ${latencyMs}ms | prompt_tokens: ${completion.usage?.prompt_tokens || 0} | completion_tokens: ${completion.usage?.completion_tokens || 0} | fallback: false`);
      return {
        success: true,
        content: cleanedContent,
        usage: {
          tokens: completion.usage?.total_tokens || 0,
          model: DEFAULT_CONFIG.model
        }
      };
    } catch (gpt5Error) {
      console.warn("GPT-5 failed, falling back to gpt-4o-mini:", gpt5Error);
      const fallbackStartTime = Date.now();
      const completion = await openai4.chat.completions.create({
        model: "gpt-4o-mini",
        messages: [
          {
            role: "system",
            content: systemPrompt
          },
          {
            role: "user",
            content: userPrompt
          }
        ],
        temperature: DEFAULT_CONFIG.temperature,
        max_tokens: Math.min(DEFAULT_CONFIG.maxTokens, 4e3),
        top_p: 0.9
      });
      const fallbackLatencyMs = Date.now() - fallbackStartTime;
      const content = completion.choices[0]?.message?.content;
      if (!content) {
        throw new Error("No content received from gpt-4o-mini fallback");
      }
      const cleanedContent = content.trim().replace(/\n{3,}/g, "\n\n");
      console.log(`\u2705 AI section job completed: ${job.action} for "${job.sectionTitle}" | model: gpt-4o-mini | latency: ${fallbackLatencyMs}ms | prompt_tokens: ${completion.usage?.prompt_tokens || 0} | completion_tokens: ${completion.usage?.completion_tokens || 0} | fallback: true`);
      return {
        success: true,
        content: cleanedContent,
        usage: {
          tokens: completion.usage?.total_tokens || 0,
          model: "gpt-4o-mini"
        }
      };
    }
  } catch (error) {
    console.error("AI section job failed:", error);
    let errorMessage = "An unexpected error occurred while processing your request";
    if (error instanceof Error) {
      if (error.message.includes("insufficient_quota") || error.message.includes("billing")) {
        errorMessage = "AI service is temporarily unavailable due to quota limits. Please try again later.";
      } else if (error.message.includes("rate_limit")) {
        errorMessage = "Too many requests. Please wait a moment and try again.";
      } else if (error.message.includes("invalid_api_key") || error.message.includes("authentication")) {
        errorMessage = "AI service authentication error. Please contact support.";
      } else {
        errorMessage = `AI processing error: ${error.message}`;
      }
    }
    return {
      success: false,
      error: errorMessage
    };
  }
}
async function generateStructuredTemplate(templateKey, businessBrief, config = DEFAULT_CONFIG) {
  const seedDrafts = {
    swot: {
      strengths: "\u2022 Strong value proposition\n\u2022 Experienced team\n\u2022 Market opportunity",
      weaknesses: "\u2022 Limited brand awareness\n\u2022 Resource constraints\n\u2022 Market competition",
      opportunities: "\u2022 Growing market demand\n\u2022 Strategic partnerships\n\u2022 Product expansion",
      threats: "\u2022 Competitive pressure\n\u2022 Market shifts\n\u2022 Economic factors"
    },
    persona: {
      name: "Target Customer",
      demographics: "Age 25-45, urban, college-educated, mid-income",
      jobs: "Seeking efficient solutions, looking to save time, wanting quality results",
      pain: "Current solutions are too expensive, complex, or time-consuming",
      channels: "Online search, social media, word of mouth, industry events"
    },
    porter5: {
      threat_new: "Moderate barrier to entry; established players have brand advantage",
      bargain_sup: "Multiple suppliers available; moderate switching costs",
      bargain_buy: "Customers have alternatives; price sensitivity varies by segment",
      threat_sub: "Some substitute products exist; differentiation is key",
      rivalry: "Competitive market with several established players"
    },
    tam_sam_som: {
      tam: "Total addressable market represents the overall industry opportunity",
      sam: "Serviceable market focuses on our target segments and regions",
      som: "Obtainable market reflects realistic capture rate in first 3 years",
      sources: "Industry reports, market research, competitive analysis"
    },
    pricing_table: {
      rows: "Starter \u2013 $29/mo \u2013 Essential features\nPro \u2013 $79/mo \u2013 Most popular\nEnterprise \u2013 Custom \u2013 Full suite"
    }
  };
  const templates = {
    swot: {
      fields: ["strengths", "weaknesses", "opportunities", "threats"],
      prompt: `Using the Business Brief, generate concise SWOT bullets (S/W/O/T). Practical, skimmable. Return ONLY a JSON object with keys: strengths, weaknesses, opportunities, threats. Each value should be 2-4 concise bullet points starting with \u2022. No placeholders.`
    },
    persona: {
      fields: ["name", "demographics", "jobs", "pain", "channels"],
      prompt: `1\u20132 primary personas: Name/Role, Goals, Pain Points, Buying Triggers. Short blocks. Return ONLY a JSON object with keys: name (creative persona name), demographics (age, location, income, education), jobs (goals/jobs-to-be-done), pain (pain points), channels (acquisition channels). Keep each field concise, no placeholders.`
    },
    porter5: {
      fields: ["threat_new", "bargain_sup", "bargain_buy", "threat_sub", "rivalry"],
      prompt: `Five Forces: 1\u20132 lines each tied to our market. Return ONLY a JSON object with keys: threat_new (threat of new entrants), bargain_sup (supplier power), bargain_buy (buyer power), threat_sub (substitutes), rivalry (industry rivalry). Each 1-2 sentences, no placeholders.`
    },
    tam_sam_som: {
      fields: ["tam", "sam", "som", "sources"],
      prompt: `Rough, logical size estimates; short justification; simple bullets. Return ONLY a JSON object with keys: tam (total addressable market), sam (serviceable available market), som (serviceable obtainable market), sources (research sources). Keep qualitative if numbers unknown, no placeholders.`
    },
    pricing_table: {
      fields: ["rows"],
      prompt: `3 tiers (Starter/Pro/Business): price points + key features; compact table-like bullets. Return ONLY a JSON object with key: rows. Format rows as: "Tier \u2013 $Price/mo \u2013 Key features" separated by \\n. No placeholders.`
    }
  };
  const template = templates[templateKey];
  if (!template) {
    throw new Error(`Unknown template: ${templateKey}`);
  }
  let context = "";
  if (businessBrief) {
    const parts = [];
    if (S(businessBrief.company)) parts.push(`Company: ${S(businessBrief.company)}`);
    if (S(businessBrief.industry)) parts.push(`Industry: ${S(businessBrief.industry)}`);
    if (S(businessBrief.businessModel)) parts.push(`Business Model: ${S(businessBrief.businessModel)}`);
    if (S(businessBrief.offeringsFull)) parts.push(`Offerings: ${S(businessBrief.offeringsFull)}`);
    if (S(businessBrief.market)) parts.push(`Target Market: ${S(businessBrief.market)}`);
    if (S(businessBrief.differentiator)) parts.push(`Competitive Edge: ${S(businessBrief.differentiator)}`);
    if (S(businessBrief.financialHeadline)) parts.push(`Financial Headline: ${S(businessBrief.financialHeadline)}`);
    if (parts.length > 0) {
      context = `Business Context:
${parts.join("\n")}

`;
    }
  }
  const fullPrompt = `${context}${template.prompt}

IMPORTANT: Return ONLY valid JSON, no markdown, no explanation, no code blocks. Example format: {"field1": "value", "field2": "value"}`;
  try {
    const startTime = Date.now();
    console.log(`\u{1F3AF} Generating structured template: ${templateKey} (GPT-5 primary)`);
    const completion = await openai4.chat.completions.create({
      model: "gpt-5",
      messages: [
        {
          role: "system",
          content: "You are a business analysis expert. Generate structured, concise business plan content. Always return valid JSON only."
        },
        {
          role: "user",
          content: fullPrompt
        }
      ],
      max_completion_tokens: 1500
    });
    const latencyMs = Date.now() - startTime;
    const responseText = completion.choices[0]?.message?.content?.trim();
    const promptTokens = completion.usage?.prompt_tokens || 0;
    const completionTokens = completion.usage?.completion_tokens || 0;
    console.log(`\u2705 Template generation: ${templateKey} | model: gpt-5 | latency: ${latencyMs}ms | prompt_tokens: ${promptTokens} | completion_tokens: ${completionTokens} | fallback: false`);
    if (!responseText || completionTokens === 0) {
      throw new Error("No content generated from GPT-5");
    }
    let jsonText = responseText;
    if (jsonText.startsWith("```")) {
      jsonText = jsonText.replace(/```json\n?/g, "").replace(/```\n?/g, "").trim();
    }
    const parsedData = JSON.parse(jsonText);
    const result = {};
    let hasAnyContent = false;
    for (const field of template.fields) {
      const value = S(parsedData[field]);
      result[field] = value;
      if (value) hasAnyContent = true;
    }
    if (!hasAnyContent) {
      throw new Error("Parsed JSON has no content");
    }
    return { data: result, isSeedDraft: false };
  } catch (gpt5Error) {
    console.warn(`\u26A0\uFE0F GPT-5 failed for ${templateKey}, falling back to gpt-4o-mini:`, gpt5Error);
    try {
      const fallbackStartTime = Date.now();
      const fallbackCompletion = await openai4.chat.completions.create({
        model: "gpt-4o-mini",
        messages: [
          {
            role: "system",
            content: "You are a business analysis expert. Generate structured, concise business plan content. Always return valid JSON only."
          },
          {
            role: "user",
            content: fullPrompt
          }
        ],
        temperature: 0.7,
        max_tokens: 1500
      });
      const fallbackLatencyMs = Date.now() - fallbackStartTime;
      const fallbackText = fallbackCompletion.choices[0]?.message?.content?.trim();
      const fallbackPromptTokens = fallbackCompletion.usage?.prompt_tokens || 0;
      const fallbackCompletionTokens = fallbackCompletion.usage?.completion_tokens || 0;
      console.log(`\u2705 Template generation: ${templateKey} | model: gpt-4o-mini | latency: ${fallbackLatencyMs}ms | prompt_tokens: ${fallbackPromptTokens} | completion_tokens: ${fallbackCompletionTokens} | fallback: true`);
      if (!fallbackText || fallbackCompletionTokens === 0) {
        throw new Error("No content from gpt-4o-mini fallback");
      }
      let jsonText = fallbackText;
      if (jsonText.startsWith("```")) {
        jsonText = jsonText.replace(/```json\n?/g, "").replace(/```\n?/g, "").trim();
      }
      const parsedData = JSON.parse(jsonText);
      const result = {};
      let hasAnyContent = false;
      for (const field of template.fields) {
        const value = S(parsedData[field]);
        result[field] = value;
        if (value) hasAnyContent = true;
      }
      if (!hasAnyContent) {
        throw new Error("Fallback JSON has no content");
      }
      return { data: result, isSeedDraft: false };
    } catch (fallbackError) {
      console.error(`\u274C Both GPT-5 and fallback failed for ${templateKey}, using seed draft:`, fallbackError);
      const seedDraft = seedDrafts[templateKey] || {};
      console.log(`\u{1F331} Using seed draft for ${templateKey}`);
      return { data: seedDraft, isSeedDraft: true };
    }
  }
}
function generateFallbackContent(job) {
  console.log("\u{1F504} Generating fallback content for AI section job");
  let content = "";
  switch (job.action) {
    case "generate":
      content = `## ${job.sectionTitle}

This section of your business plan is ready for your input. Consider including:

- Key objectives and goals for this area
- Relevant details specific to your business
- Supporting data and evidence
- Strategic considerations and next steps

*This is placeholder content. Please replace with your specific business information.*`;
      break;
    case "rephrase":
      content = job.existingContent || "Content to be rephrased";
      break;
    case "expand":
      content = `${job.existingContent || ""}

*Additional details and expansion would be added here based on your specific business context and requirements.*`;
      break;
    case "summarize":
      content = job.existingContent?.slice(0, Math.floor(job.existingContent.length * 0.6)) || "Summary content";
      break;
  }
  return {
    success: true,
    content,
    usage: {
      tokens: 0,
      model: "fallback"
    }
  };
}
var openai4, DEFAULT_CONFIG, TONE_SYSTEM_PROMPTS2, SECTION_BASE_PROMPTS, ACTION_PROMPTS, S;
var init_ai_section = __esm({
  "server/ai-section.ts"() {
    "use strict";
    openai4 = new OpenAI4({
      apiKey: process.env.OPENAI_API_KEY
    });
    DEFAULT_CONFIG = {
      model: "gpt-5",
      maxTokens: 2e3,
      temperature: 0.7
    };
    TONE_SYSTEM_PROMPTS2 = {
      Professional: `You are a professional business consultant and writer. Write in a polished, confident, and authoritative tone. Use business terminology appropriately and maintain a formal, credible style throughout. Be comprehensive but concise.`,
      Friendly: `You are a friendly business mentor and advisor. Write in a warm, encouraging, and conversational tone while maintaining professionalism. Use inclusive language that makes the reader feel supported and motivated. Explain concepts clearly and avoid unnecessary jargon.`,
      Bold: `You are a dynamic business strategist and thought leader. Write with confidence, conviction, and impact. Use strong, decisive language that inspires action. Be direct and ambitious in your recommendations. Emphasize competitive advantages and growth opportunities.`,
      Minimal: `You are a minimalist business writer who values clarity and brevity. Write in a clean, simple, and direct style. Use short sentences and paragraphs. Focus on essential information only. Avoid redundancy and filler words.`
    };
    SECTION_BASE_PROMPTS = {
      "executive-summary": (company) => `Write a concise, investor-ready executive summary for ${company || "{{company}}"} using: business model, offerings (full suite), target market, competitive edge, and financialHeadline (Launch/Growth/Scale phrasing if present). No placeholders.`,
      "company-overview": () => `Mission, vision, value prop, origin, legal structure/location, current stage \u2014 factual and compact.`,
      "products-services": () => `3\u20137 bullets (1 line each) + 1-paragraph value prop. If tiers/pricing exist, summarize in \u22643 lines.`,
      "market-analysis": () => `ICP, 3\u20134 trends, 2\u20134 competitors with one-line differentiation, and a mini-SWOT (one line per S/W/O/T). Keep TAM/SAM/SOM qualitative if unknown.`,
      "marketing-sales": () => `Positioning, 3\u20136 channels, TOFU\u2192MOFU\u2192BOFU in one line, retention tactics, and 4\u20136 KPIs (CAC, LTV, MRR, churn).`,
      "operations-plan": () => `Tech/infra, processes (support, releases, QA, billing), key vendors/tools, SLAs/security, and 3\u20135 ops KPIs.`,
      "org-management": () => `Leadership roles; include 'Strategic AI Partner: Nova AI \u2014 Co-Founder / Operations & Data Intelligence' if relevant; hiring plan; optional advisors.`,
      "financial-plan": (year0) => `Revenue streams, assumptions, forecast using Launch (Q4 year0), Growth (year1), Scale (year2). Mention break-even if implied; add 2\u20133 risks + mitigations. Use financialHeadline if present; no invented numbers.`,
      "milestones-roadmap": () => `4\u20138 bullets grouped by phase: Launch, Growth, Scale, Beyond. Each bullet starts with a verb and includes an outcome metric if present.`,
      "future-expansion": () => `2\u20134 expansion vectors (integrations, adjacent products, partnerships/channels, long-term vision) tied back to model/market.`,
      "partnerships-note": () => `Rationale, partner types, criteria, engagement model (referrals, rev-share, white-label), and the customer benefit \u2014 brief, practical.`,
      "exit-strategy": () => `Primary path (typical acquirers), alternatives (IPO/private growth), timing triggers, and value narrative \u2014 neutral if signals are light.`,
      "custom": () => `Provide relevant business plan content based on the section title and context provided.`
    };
    ACTION_PROMPTS = {
      generate: (job) => {
        const systemPrompt = `You are drafting a professional business plan section. Be accurate, clear, and business-appropriate. No bracket placeholders like [Company Name]. Use the provided context. If data is missing, phrase it neutrally.`;
        const brief = job.context?.businessBrief;
        let briefContext = "";
        if (brief) {
          const briefParts = [];
          if (brief.company) briefParts.push(`Company: ${brief.company}`);
          if (brief.industry) briefParts.push(`Industry: ${brief.industry}`);
          if (brief.businessModel) briefParts.push(`Business Model: ${brief.businessModel}`);
          if (brief.productsServices) briefParts.push(`Products/Services: ${brief.productsServices}`);
          if (brief.offeringsFull) briefParts.push(`Offerings (Full Suite): ${brief.offeringsFull}`);
          if (brief.market) briefParts.push(`Target Market: ${brief.market}`);
          if (brief.differentiator) briefParts.push(`Competitive Edge: ${brief.differentiator}`);
          if (brief.financialHeadline) briefParts.push(`Financial Headline: ${brief.financialHeadline}`);
          if (briefParts.length > 0) {
            briefContext = `

Business Brief:
${briefParts.join("\n")}`;
          }
        }
        const sectionContext = `
Section: ${job.sectionKind}`;
        const basePromptFn = SECTION_BASE_PROMPTS[job.sectionKind] || SECTION_BASE_PROMPTS.custom;
        const company = brief?.company || job.context?.businessName;
        const year0 = brief?.financialHeadline?.match(/20\d{2}/)?.[0] || (/* @__PURE__ */ new Date()).getFullYear().toString();
        const basePrompt = typeof basePromptFn === "function" ? basePromptFn(job.sectionKind === "executive-summary" ? company : job.sectionKind === "financial-plan" ? year0 : void 0) : basePromptFn;
        const taskContext = `

Task: ${basePrompt}`;
        const userPromptContext = job.userPrompt && job.userPrompt.trim().length > 0 ? `

User Instructions:
${job.userPrompt}` : "";
        const editorContext = job.existingContent && job.existingContent.trim().length > 0 ? `

Existing Draft Context:
${job.existingContent}` : "";
        const length = job.length || "Standard";
        const wordTargets = {
          "Short": "120-160 words",
          "Standard": "200-300 words",
          "Long": "350-500 words"
        };
        const lengthGuidance = wordTargets[length] || wordTargets.Standard;
        const tone = job.tone || "Professional";
        const styleContext = `

Style: ${tone} tone, ${lengthGuidance}. Concise, investor-ready, no marketing fluff.`;
        return `${systemPrompt}${briefContext}${sectionContext}${taskContext}${userPromptContext}${editorContext}${styleContext}

Important:
- Write in markdown format
- Do not include a section title header - just the content
- Maximum 500 words
- No bracket placeholders
- If Business Brief data is missing, use neutral phrasing (e.g., "The company offers a range of services...")`;
      },
      rephrase: (job) => {
        const tone = job.tone || "Professional";
        const brief = job.context?.businessBrief;
        let briefContext = "";
        if (brief) {
          const briefParts = [];
          if (brief.company) briefParts.push(`Company: ${brief.company}`);
          if (brief.productsServices) briefParts.push(`Products/Services: ${brief.productsServices}`);
          if (brief.offeringsFull) briefParts.push(`Offerings: ${brief.offeringsFull}`);
          if (briefParts.length > 0) {
            briefContext = `

Business Brief (for consistency):
${briefParts.join("\n")}
`;
          }
        }
        return `Rewrite the following business plan content for clarity. Keep the same meaning with shorter sentences and better flow.${briefContext}

Original content:
${job.existingContent}

Requirements:
- Rewrite with same meaning, shorter sentences, better flow
- Maintain all key facts, figures, and points
- Use ${tone.toLowerCase()} tone
- Use Business Brief context to keep names/offerings consistent
- Use markdown formatting
- Do not add new information`;
      },
      expand: (job) => {
        const tone = job.tone || "Professional";
        const brief = job.context?.businessBrief;
        let briefContext = "";
        if (brief) {
          const briefParts = [];
          if (brief.company) briefParts.push(`Company: ${brief.company}`);
          if (brief.productsServices) briefParts.push(`Products/Services: ${brief.productsServices}`);
          if (brief.offeringsFull) briefParts.push(`Full Suite: ${brief.offeringsFull}`);
          if (brief.market) briefParts.push(`Target Market: ${brief.market}`);
          if (brief.differentiator) briefParts.push(`Competitive Edge: ${brief.differentiator}`);
          if (briefParts.length > 0) {
            briefContext = `

Business Brief:
${briefParts.join("\n")}
`;
          }
        }
        return `Add detail or examples to the following business plan content.${briefContext}

Current content:
${job.existingContent}

Requirements:
- Add specific details, examples, sub-bullets
- Stay within 30-40% longer max (avoid runaway length)
- Pull in Business Brief for specifics if missing
- Use markdown formatting
- Maintain ${tone.toLowerCase()} tone
- Maximum 500 words total`;
      },
      summarize: (job) => {
        const tone = job.tone || "Professional";
        return `Make the following business plan content more concise.

Current content:
${job.existingContent}

Requirements:
- Condense to ~50-60% of original length
- Keep all critical points; remove fluff
- Keep all essential facts, figures, and main points
- Remove redundancy and unnecessary details
- Maintain logical flow and structure
- Maintain a ${tone.toLowerCase()} tone
- Use markdown formatting
- Aim to reduce the content by 30-50% while retaining value
- Do not lose any critical business information`;
      }
    };
    S = (v) => (v ?? "").trim();
  }
});

// server/lib/markup.ts
function round2(n) {
  return Math.round((Number(n) + Number.EPSILON) * 100) / 100;
}
function applyMarkup({ wholesale, tld, config = {} }) {
  const cfg = {
    flat: DEFAULTS2.flat,
    percent: DEFAULTS2.percent,
    perTld: { ...DEFAULTS2.perTld, ...config.perTld || {} }
  };
  const key = (tld || "").toLowerCase();
  const ovr = cfg.perTld[key] || {};
  const flat = ovr.flat ?? cfg.flat;
  const percent = ovr.percent ?? cfg.percent;
  let retail = Number(wholesale);
  if (!Number.isFinite(retail)) throw new Error("Invalid wholesale price");
  retail = retail * (1 + Number(percent) / 100);
  retail = retail + Number(flat);
  return round2(retail);
}
function extractTld(domain) {
  const m = String(domain).toLowerCase().match(/(\.[a-z0-9-]+)$/i);
  return m ? m[1] : "";
}
var DEFAULTS2;
var init_markup = __esm({
  "server/lib/markup.ts"() {
    "use strict";
    DEFAULTS2 = {
      flat: 3,
      // default fallback
      percent: 10,
      perTld: {
        ".com": { flat: 2.5, percent: 10 },
        ".net": { flat: 2.34, percent: 10 },
        ".org": { flat: 11.5, percent: 10 },
        ".biz": { flat: 0, percent: 10 },
        ".info": { flat: 0, percent: 10 },
        ".co": { flat: 12.49, percent: 10 },
        ".ai": { flat: 0, percent: 10 }
      }
    };
  }
});

// server/domains/pricing.ts
function getDomainPricing(domain) {
  const tld = domain.split(".").pop()?.toLowerCase() || "com";
  const row = WHOLESALE_TABLE[tld];
  const wholesaleCents = row?.wholesaleCents || 1699;
  const currency = row?.currency || "USD";
  const wholesaleDollars = wholesaleCents / 100;
  const tldWithDot = extractTld(domain);
  const retailDollars = applyMarkup({
    wholesale: wholesaleDollars,
    tld: tldWithDot
  });
  const retailCents = Math.round(retailDollars * 100);
  return {
    wholesale: {
      priceCents: wholesaleCents,
      currency
    },
    retail: {
      priceCents: retailCents,
      currency
    }
  };
}
function getRetailPriceForDomain(domain) {
  const pricing = getDomainPricing(domain);
  return {
    priceCents: pricing.retail.priceCents,
    currency: pricing.retail.currency
  };
}
var WHOLESALE_TABLE;
var init_pricing = __esm({
  "server/domains/pricing.ts"() {
    "use strict";
    init_markup();
    WHOLESALE_TABLE = {
      com: { wholesaleCents: 1450 },
      // $14.50 wholesale → $18.99 retail (vs GoDaddy $20.99)
      net: { wholesaleCents: 1999 },
      // $19.99 wholesale → $20.99 retail (vs GoDaddy $22.99)
      org: { wholesaleCents: 1499 },
      // $14.99 wholesale → $21.49 retail (vs GoDaddy $23.99)
      co: { wholesaleCents: 1499 },
      // $14.99 wholesale → $26.99 retail (vs GoDaddy $29.99)
      io: { wholesaleCents: 4500 },
      // $45.00 wholesale → maintain current .io pricing
      ai: { wholesaleCents: 16950 }
      // $169.50 wholesale → $179.99 retail (vs GoDaddy $199.99)
    };
  }
});

// server/domains/providers/opensrs.ts
import { createHash as createHash2 } from "crypto";
import { DOMParser } from "@xmldom/xmldom";
var DEFAULT_TLDS, OpenSRSRegistrar, opensrs;
var init_opensrs = __esm({
  "server/domains/providers/opensrs.ts"() {
    "use strict";
    init_pricing();
    DEFAULT_TLDS = [".com", ".net", ".co", ".io", ".ai"];
    OpenSRSRegistrar = class {
      config;
      constructor() {
        const envMode = process.env.OPENSRS_MODE || "ote";
        const mode = envMode === "live" ? "live" : "test";
        const baseUrl = mode === "test" ? "https://horizon.opensrs.net:55443" : "https://rr-n1-tor.opensrs.net:55443";
        const username = (process.env.OPENSRS_USER || "").trim();
        const key = (process.env.OPENSRS_KEY || "").trim();
        this.config = {
          mode,
          baseUrl,
          credentials: {
            username,
            key
          },
          defaultNameservers: process.env.DOMAIN_DEFAULT_NAMESERVERS?.split(",") || ["ns1.opensrs.net", "ns2.opensrs.net"],
          defaultYears: parseInt(process.env.DOMAIN_DEFAULT_YEARS || "1")
        };
        const hasUsername = !!username && username.length > 0;
        const hasKey = !!key && key.length > 0;
        const isFullyConfigured = hasUsername && hasKey;
        console.log(`[OpenSRS] Initialization - mode=${mode}, baseUrl=${baseUrl}`);
        console.log(`[OpenSRS] Credentials - OPENSRS_USER present: ${hasUsername}, OPENSRS_KEY present: ${hasKey}, configured: ${isFullyConfigured}`);
        if (!isFullyConfigured) {
          console.warn(`[OpenSRS] \u26A0\uFE0F  Missing credentials - domain search will use demo fallback mode`);
          console.warn(`[OpenSRS] Required env vars: OPENSRS_USER, OPENSRS_KEY, OPENSRS_MODE (optional, defaults to 'ote')`);
        }
      }
      isConfigured() {
        return !!(this.config.credentials.username && this.config.credentials.key);
      }
      async getSupportedTlds() {
        return DEFAULT_TLDS.map((tld) => {
          const domain = `example${tld}`;
          const pricing = getRetailPriceForDomain(domain);
          return {
            tld,
            priceCents: pricing.priceCents
          };
        });
      }
      parseDomainQuery(query, availableTlds) {
        const allKnownTlds = [.../* @__PURE__ */ new Set([...availableTlds, ...DEFAULT_TLDS, ".co.uk", ".com.au", ".net.au", ".org.uk"])];
        const sortedTlds = allKnownTlds.sort((a, b) => b.length - a.length);
        for (const tld of sortedTlds) {
          if (query.endsWith(tld)) {
            const label = query.substring(0, query.length - tld.length);
            if (label && label.length > 0 && !label.endsWith(".")) {
              return {
                label,
                existingTld: tld,
                fullDomain: query
              };
            }
          }
        }
        return {
          label: query,
          existingTld: null,
          fullDomain: query
        };
      }
      async search(input) {
        const { query } = input;
        const tlds = input.tlds || DEFAULT_TLDS;
        const parsedQuery = this.parseDomainQuery(query.toLowerCase().trim(), tlds);
        const domains2 = [];
        if (parsedQuery.existingTld) {
          domains2.push(parsedQuery.fullDomain);
        } else {
          domains2.push(...tlds.map((tld) => `${parsedQuery.label}${tld}`));
        }
        const results = [];
        for (const domain of domains2) {
          try {
            const available = await this.checkDomainAvailability(domain);
            const isPremium = this.isPremiumDomain(domain);
            const pricing = getRetailPriceForDomain(domain);
            if (isPremium && available) {
              results.push({
                domain,
                available: false,
                // Block purchase
                priceCents: void 0,
                type: "premium",
                premium: true,
                errorMessage: "Premium domains not supported yet"
              });
            } else {
              results.push({
                domain,
                available,
                priceCents: available ? pricing.priceCents : void 0,
                type: "standard"
              });
            }
          } catch (error) {
            console.error(`[OpenSRS] \u274C Error checking domain ${domain}:`, error);
            console.error(`[OpenSRS] Error details:`, {
              message: error instanceof Error ? error.message : "Unknown error",
              stack: error instanceof Error ? error.stack : void 0,
              raw: error
            });
            const isLikelyAvailable = this.getDemoAvailability(domain);
            const isPremium = this.isPremiumDomain(domain);
            const pricing = getRetailPriceForDomain(domain);
            if (isPremium && isLikelyAvailable) {
              results.push({
                domain,
                available: false,
                // Block purchase
                priceCents: void 0,
                type: "premium",
                premium: true,
                errorMessage: "Premium domains not supported yet"
              });
            } else {
              results.push({
                domain,
                available: isLikelyAvailable,
                priceCents: isLikelyAvailable ? pricing.priceCents : void 0,
                type: "standard"
              });
            }
          }
        }
        return results;
      }
      async register(input) {
        const { domain, years, contact, privacy, nameservers } = input;
        if (!this.isConfigured()) {
          return {
            success: false,
            message: "OpenSRS not configured - missing credentials"
          };
        }
        try {
          const privacySettings = this.mapPrivacySettings(domain, privacy);
          const result = await this.callOpenSRS("SW_REGISTER", "DOMAIN", {
            domain,
            period: years,
            nameserver_list: nameservers?.length ? nameservers : this.config.defaultNameservers,
            contact_set: {
              owner: this.mapContactToOpenSRS(contact),
              admin: this.mapContactToOpenSRS(contact),
              billing: this.mapContactToOpenSRS(contact),
              tech: this.mapContactToOpenSRS(contact)
            },
            ...privacySettings
          });
          if (result.is_success) {
            return {
              success: true,
              providerRegId: result.attributes?.registration_id || result.attributes?.order_id,
              message: result.response_text || "Domain registered successfully"
            };
          } else {
            return {
              success: false,
              message: result.response_text || result.attributes?.error || "Domain registration failed"
            };
          }
        } catch (error) {
          console.error("OpenSRS registration error:", error);
          return {
            success: false,
            message: error instanceof Error ? error.message : "Unknown registration error"
          };
        }
      }
      async checkDomainAvailability(domain) {
        if (!this.isConfigured()) {
          throw new Error("OpenSRS not configured - missing credentials");
        }
        console.log(`[OpenSRS] Checking availability for: ${domain}`);
        const result = await this.callOpenSRS("LOOKUP", "DOMAIN", {
          domain,
          search_type: "domain"
        });
        const available = this.parseAvailabilityFromResponse(result);
        console.log(`[OpenSRS] ${domain} availability: ${available ? "AVAILABLE" : "TAKEN"}`);
        return available;
      }
      async callOpenSRS(action, object, attributes) {
        const bodyString = this.buildXMLRequest(action, object, attributes);
        try {
          const url = new URL(this.config.baseUrl);
          console.log(`[domain] OpenSRS upstream \u2192 host=${url.host} path=${url.pathname} action=${action}`);
        } catch {
          console.log(`[domain] OpenSRS upstream \u2192 ${this.config.baseUrl} action=${action}`);
        }
        if (action === "SW_REGISTER") {
          const redactedBody = this.redactPIIFromXML(bodyString);
          console.log(`OpenSRS Request (${action} ${object}) - PII redacted:`, redactedBody.substring(0, 1e3));
        } else {
          console.log(`OpenSRS Request XML (${action} ${object}):`, bodyString.substring(0, 1e3));
        }
        const signature = this.computeSignature(bodyString);
        const response = await fetch(this.config.baseUrl, {
          method: "POST",
          headers: {
            "Content-Type": "text/xml; charset=UTF-8",
            "Accept": "text/xml",
            "X-Username": this.config.credentials.username,
            "X-Signature": signature
          },
          body: bodyString
        });
        if (!response.ok) {
          const errorText = await response.text();
          throw new Error(`OpenSRS API error: ${response.status} ${response.statusText} - ${errorText}`);
        }
        const responseText = await response.text();
        let result;
        if (responseText.trim().startsWith("<?xml")) {
          result = this.parseXMLResponse(responseText);
        } else {
          try {
            result = JSON.parse(responseText);
          } catch (error) {
            throw new Error(`Failed to parse OpenSRS response: ${responseText.substring(0, 200)}...`);
          }
        }
        if (!result.is_success || result.is_success === 0) {
          const errorMsg = result.response_text || result.attributes?.error || `OpenSRS error ${result.response_code || "unknown"}`;
          throw new Error(errorMsg);
        }
        return result;
      }
      parseXMLResponse(xmlText) {
        try {
          const parser = new DOMParser();
          const doc = parser.parseFromString(xmlText, "text/xml");
          const envelope = doc.getElementsByTagName("OPS_envelope")[0];
          if (!envelope) {
            throw new Error("Invalid OpenSRS XML format - missing OPS_envelope");
          }
          const body = envelope.getElementsByTagName("body")[0];
          if (!body) {
            throw new Error("Invalid OpenSRS XML format - missing body");
          }
          const dataBlock = body.getElementsByTagName("data_block")[0];
          if (!dataBlock) {
            throw new Error("Invalid OpenSRS XML format - missing data_block");
          }
          const result = {
            is_success: false,
            response_code: void 0,
            response_text: void 0,
            attributes: {}
          };
          const topLevelAssoc = dataBlock.getElementsByTagName("dt_assoc")[0];
          if (!topLevelAssoc) {
            throw new Error("Invalid OpenSRS XML format - missing top-level dt_assoc");
          }
          const items = Array.from(topLevelAssoc.childNodes).filter(
            (node) => node.nodeType === 1 && node.nodeName === "item"
          );
          for (const item of items) {
            const key = item.getAttribute("key");
            if (key === "is_success") {
              const value = item.textContent?.trim();
              result.is_success = value === "1" || value === "true";
            } else if (key === "response_code") {
              result.response_code = item.textContent?.trim();
            } else if (key === "response_text") {
              result.response_text = item.textContent?.trim();
            } else if (key === "attributes") {
              const nestedAssoc = item.getElementsByTagName("dt_assoc")[0];
              if (nestedAssoc) {
                result.attributes = this.parseXMLAttributesFromAssoc(nestedAssoc);
              }
            }
          }
          if (!result.is_success || result.is_success === 0) {
            console.log("OpenSRS XML Response Debug (first 1000 chars):", xmlText.substring(0, 1e3));
          }
          return result;
        } catch (error) {
          console.error("XML parsing error:", error);
          console.log("Failed XML Response (first 1000 chars):", xmlText.substring(0, 1e3));
          throw new Error(`Failed to parse OpenSRS XML response: ${error instanceof Error ? error.message : "Unknown error"}`);
        }
      }
      parseXMLAttributesFromAssoc(assocElement) {
        const attributes = {};
        const items = Array.from(assocElement.childNodes).filter(
          (node) => node.nodeType === 1 && node.nodeName === "item"
        );
        for (const item of items) {
          const key = item.getAttribute("key");
          if (key) {
            attributes[key] = this.parseXMLValueFromItem(item);
          }
        }
        return attributes;
      }
      parseXMLAttributes(element) {
        const attributes = {};
        const assocElements = element.getElementsByTagName("dt_assoc");
        for (let i = 0; i < assocElements.length; i++) {
          const item = assocElements[i];
          const key = item.getAttribute("key");
          if (key) {
            attributes[key] = this.parseXMLValue(item);
          }
        }
        const directChildren = Array.from(element.childNodes).filter(
          (node) => node.nodeType === 1 && node.nodeName === "dt_assoc"
        );
        for (const child of directChildren) {
          const key = child.getAttribute("key");
          if (key) {
            attributes[key] = this.parseXMLValue(child);
          }
        }
        return attributes;
      }
      parseXMLValueFromItem(item) {
        const nestedAssocs = item.getElementsByTagName("dt_assoc");
        if (nestedAssocs.length > 0) {
          return this.parseXMLAttributesFromAssoc(nestedAssocs[0]);
        }
        const arrays = item.getElementsByTagName("dt_array");
        if (arrays.length > 0) {
          const result = [];
          for (let i = 0; i < arrays.length; i++) {
            const arrayItem = arrays[i];
            const arrayItems = Array.from(arrayItem.childNodes).filter(
              (node) => node.nodeType === 1 && node.nodeName === "item"
            );
            for (const arrayItemElement of arrayItems) {
              result.push(this.parseXMLValueFromItem(arrayItemElement));
            }
          }
          return result;
        }
        const textContent = item.textContent?.trim();
        if (textContent && !isNaN(Number(textContent))) {
          return Number(textContent);
        }
        if (textContent === "1" || textContent === "true") {
          return true;
        }
        if (textContent === "0" || textContent === "false") {
          return false;
        }
        return textContent || "";
      }
      parseXMLValue(element) {
        const nestedAssocs = element.getElementsByTagName("dt_assoc");
        if (nestedAssocs.length > 0) {
          return this.parseXMLAttributes(element);
        }
        const arrays = element.getElementsByTagName("dt_array");
        if (arrays.length > 0) {
          const result = [];
          for (let i = 0; i < arrays.length; i++) {
            const arrayItem = arrays[i];
            result.push(this.parseXMLValue(arrayItem));
          }
          return result;
        }
        const textContent = element.textContent?.trim();
        if (textContent && !isNaN(Number(textContent))) {
          return Number(textContent);
        }
        if (textContent === "1" || textContent === "true") {
          return true;
        }
        if (textContent === "0" || textContent === "false") {
          return false;
        }
        return textContent || "";
      }
      buildXMLRequest(action, object, attributes) {
        const mainItems = [
          `<item key="protocol">XCP</item>`,
          `<item key="action">${this.escapeXML(action)}</item>`,
          `<item key="object">${this.escapeXML(object)}</item>`
        ];
        for (const [key, value] of Object.entries(attributes)) {
          mainItems.push(this.valueToXMLItem(key, value));
        }
        const xmlBody = `<?xml version="1.0" encoding="UTF-8" standalone="no"?>
<!DOCTYPE OPS_envelope SYSTEM "ops.dtd">
<OPS_envelope>
  <header>
    <version>0.9</version>
  </header>
  <body>
    <data_block>
      <dt_assoc>
        ${mainItems.join("\n        ")}
      </dt_assoc>
    </data_block>
  </body>
</OPS_envelope>`;
        return xmlBody;
      }
      objectToXML(obj) {
        const items = [];
        for (const [key, value] of Object.entries(obj)) {
          items.push(this.valueToXMLItem(key, value));
        }
        return `<dt_assoc>
${items.join("\n")}
</dt_assoc>`;
      }
      valueToXMLItem(key, value) {
        if (value === null || value === void 0) {
          return `<item key="${this.escapeXML(key)}"></item>`;
        }
        if (Array.isArray(value)) {
          const arrayItems = value.map((item, index2) => {
            if (typeof item === "object" && item !== null) {
              return `<item key="${index2}">${this.objectToXML(item)}</item>`;
            } else {
              return `<item key="${index2}">${this.escapeXML(String(item))}</item>`;
            }
          }).join("\n");
          return `<item key="${this.escapeXML(key)}"><dt_array>
${arrayItems}
</dt_array></item>`;
        }
        if (typeof value === "object" && value !== null) {
          return `<item key="${this.escapeXML(key)}">${this.objectToXML(value)}</item>`;
        }
        return `<item key="${this.escapeXML(key)}">${this.escapeXML(String(value))}</item>`;
      }
      escapeXML(text2) {
        return text2.replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;").replace(/'/g, "&#x27;");
      }
      computeSignature(body) {
        const bodyBytes = Buffer.from(body, "utf8");
        const keyBytes = Buffer.from(this.config.credentials.key, "utf8");
        const innerHash = createHash2("md5").update(Buffer.concat([bodyBytes, keyBytes])).digest("hex");
        const signature = createHash2("md5").update(innerHash + this.config.credentials.key).digest("hex");
        return signature;
      }
      // Security: Redact PII from XML request logs for SW_REGISTER operations
      redactPIIFromXML(xmlString) {
        const piiFields = [
          "first_name",
          "last_name",
          "email",
          "phone",
          "org_name",
          "address1",
          "address2",
          "city",
          "state",
          "postal_code"
        ];
        let redacted = xmlString;
        piiFields.forEach((field) => {
          const regex = new RegExp(`(<item key="${field}">)[^<]*(</item>)`, "gi");
          redacted = redacted.replace(regex, `$1[REDACTED]$2`);
        });
        redacted = redacted.replace(/\b[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\.[A-Z|a-z]{2,}\b/g, "[EMAIL_REDACTED]");
        redacted = redacted.replace(/(\+?1?[-.\s]?)?\(?[0-9]{3}\)?[-.\s]?[0-9]{3}[-.\s]?[0-9]{4}/g, "[PHONE_REDACTED]");
        return redacted;
      }
      mapContactToOpenSRS(contact) {
        return {
          first_name: contact.firstName,
          last_name: contact.lastName,
          email: contact.email,
          phone: contact.phone,
          org_name: contact.organization || "",
          address1: contact.address,
          address2: "",
          city: contact.city,
          state: contact.state || "",
          postal_code: contact.postalCode || "",
          country: contact.country
        };
      }
      extractTldFromDomain(domain, tlds) {
        const sortedTlds = [...tlds].sort((a, b) => b.length - a.length);
        for (const tld of sortedTlds) {
          if (domain.endsWith(tld)) {
            return tld;
          }
        }
        const lastDotIndex = domain.lastIndexOf(".");
        return lastDotIndex >= 0 ? domain.substring(lastDotIndex) : ".com";
      }
      getDemoAvailability(domain) {
        const commonTakenWords = ["google", "facebook", "amazon", "microsoft", "apple"];
        const domainLower = domain.toLowerCase();
        if (commonTakenWords.some((word) => domainLower.includes(word))) {
          return false;
        }
        const hash = domain.split("").reduce((a, b) => {
          a = (a << 5) - a + b.charCodeAt(0);
          return a & a;
        }, 0);
        return Math.abs(hash) % 10 < 8;
      }
      isPremiumDomain(domain) {
        const label = domain.split(".")[0].toLowerCase();
        if (label.length <= 3) return true;
        const premiumPatterns = [
          "ai",
          "app",
          "buy",
          "car",
          "cash",
          "crypto",
          "deal",
          "fast",
          "free",
          "game",
          "golf",
          "home",
          "hot",
          "news",
          "online",
          "pay",
          "pro",
          "real",
          "sale",
          "shop",
          "tax",
          "tech",
          "trade",
          "web",
          "win"
        ];
        return premiumPatterns.some((pattern) => label.includes(pattern));
      }
      parseAvailabilityFromResponse(result) {
        const attrs = result.attributes;
        if (!attrs) return false;
        if (attrs.is_available !== void 0) {
          return !!(attrs.is_available === true || attrs.is_available === 1 || attrs.is_available === "1");
        }
        if (attrs["is-available"] !== void 0) {
          return !!(attrs["is-available"] === true || attrs["is-available"] === 1 || attrs["is-available"] === "1");
        }
        if (attrs.status !== void 0) {
          return attrs.status === "available" || attrs.status === "AVAILABLE";
        }
        if (attrs.status_text !== void 0) {
          return attrs.status_text.toLowerCase().includes("available");
        }
        if (result.response_text) {
          return result.response_text.toLowerCase().includes("available");
        }
        return false;
      }
      mapPrivacySettings(domain, privacy) {
        if (!privacy) {
          return { whois_privacy: false };
        }
        const settings = {
          whois_privacy: true
        };
        const tld = domain.substring(domain.lastIndexOf("."));
        switch (tld) {
          case ".ca":
            settings.ca_privacy = true;
            break;
          case ".eu":
            settings.eu_privacy = true;
            break;
          default:
            break;
        }
        return settings;
      }
    };
    opensrs = new OpenSRSRegistrar();
  }
});

// server/services/watermark.ts
import sharp4 from "sharp";
import crypto3 from "crypto";
async function autoWatermarkColor(input) {
  const stats = await sharp4(input).stats();
  const r = stats.channels[0].mean;
  const g = stats.channels[1].mean;
  const b = stats.channels[2].mean;
  const brightness = 0.2126 * r + 0.7152 * g + 0.0722 * b;
  return brightness > 140 ? "#000000" : "#FFFFFF";
}
function toTenDigitCode(seed) {
  if (!seed) {
    return (Math.floor(1e9 + Math.random() * 9e9).toString() + Math.floor(Math.random() * 10)).slice(0, 10);
  }
  const hash = crypto3.createHash("sha256").update(String(seed)).digest("hex");
  const digits = hash.replace(/[a-f]/g, (c) => (parseInt(c, 16) % 10).toString()).slice(0, 10);
  return digits.padEnd(10, "0");
}
function buildWatermarkSVG(width, height, color, opacity, stockCode) {
  const bigFont = Math.round(Math.min(width, height) * 0.18);
  const smallFont = Math.round(Math.min(width, height) * 0.065);
  const angle = -30;
  const label = "IBrandBiz";
  const codeLabel = `IBrandBiz | #${stockCode}`;
  const tiles = [];
  const cols = 3;
  const rows = 3;
  for (let r = -1; r <= rows; r++) {
    for (let c = -1; c <= cols; c++) {
      tiles.push({ x: (c + 0.5) * (width / cols), y: (r + 0.5) * (height / rows) });
    }
  }
  const codeX = Math.round(width * 0.04);
  const codeY = Math.round(height * 0.5);
  const codeFont = Math.round(Math.min(width, height) * 0.05);
  const svg = `
<svg xmlns="http://www.w3.org/2000/svg" width="${width}" height="${height}">
  <defs>
    <style><![CDATA[
      .wm-big { font-family: Arial, Helvetica, sans-serif; font-weight: 700; font-size: ${bigFont}px; fill: ${color}; opacity: ${opacity}; }
      .wm-small { font-family: Arial, Helvetica, sans-serif; font-weight: 700; font-size: ${smallFont}px; fill: ${color}; opacity: ${opacity}; }
      .wm-code { font-family: Arial, Helvetica, sans-serif; font-weight: 700; font-size: ${codeFont}px; fill: ${color}; opacity: ${opacity}; }
    ]]></style>
  </defs>

  <!-- Big center label -->
  <g transform="translate(${width / 2}, ${height / 2}) rotate(${angle})">
    <text class="wm-big" text-anchor="middle" dominant-baseline="middle">${label}</text>
  </g>

  <!-- Repeated small diagonals -->
  ${tiles.map((t) => `
  <g transform="translate(${t.x}, ${t.y}) rotate(${angle})">
    <text class="wm-small" text-anchor="middle" dominant-baseline="middle">${label}</text>
  </g>`).join("")}

  <!-- Vertical stock code along left side -->
  <g transform="translate(${codeX}, ${codeY}) rotate(-90)">
    <text class="wm-code" text-anchor="middle" dominant-baseline="middle">${codeLabel}</text>
  </g>
</svg>`.trim();
  return Buffer.from(svg);
}
async function applyWatermark(input, opts = {}) {
  const { stockSeed, opacity = 0.15 } = opts;
  const img = sharp4(input);
  const meta = await img.metadata();
  const width = meta.width || 2e3;
  const height = meta.height || 1200;
  const color = await autoWatermarkColor(input);
  const code = toTenDigitCode(stockSeed);
  const overlay = buildWatermarkSVG(width, height, color, opacity, code);
  const pipeline = sharp4(input).composite([{ input: overlay, gravity: "center" }]).withMetadata();
  if (meta.format === "jpeg" || meta.format === "jpg") {
    return pipeline.jpeg({ quality: 90 }).toBuffer();
  } else if (meta.format === "png") {
    return pipeline.png({ compressionLevel: 9 }).toBuffer();
  } else if (meta.format === "webp") {
    return pipeline.webp({ quality: 90 }).toBuffer();
  } else if (meta.format === "avif") {
    return pipeline.avif({ quality: 50 }).toBuffer();
  }
  return pipeline.png({ compressionLevel: 9 }).toBuffer();
}
var init_watermark = __esm({
  "server/services/watermark.ts"() {
    "use strict";
  }
});

// server/jobs/jobQueue.ts
import { EventEmitter as EventEmitter2 } from "events";
var JobQueue, jobQueue;
var init_jobQueue = __esm({
  "server/jobs/jobQueue.ts"() {
    "use strict";
    JobQueue = class extends EventEmitter2 {
      jobs = /* @__PURE__ */ new Map();
      processingJobs = /* @__PURE__ */ new Set();
      workers = /* @__PURE__ */ new Map();
      isProcessing = false;
      processingTimeouts = /* @__PURE__ */ new Map();
      constructor() {
        super();
        this.startProcessing();
      }
      // Register a job worker for a specific job type
      registerWorker(jobType, worker) {
        this.workers.set(jobType, worker);
        console.log(`\u{1F4CB} Job worker registered for type: ${jobType}`);
      }
      // Add a new job to the queue
      enqueue(type, data, options = {}) {
        const jobId = `${type}_${Date.now()}_${Math.random().toString(36).substr(2, 9)}`;
        const job = {
          id: jobId,
          type,
          data,
          retries: 0,
          maxRetries: options.maxRetries || 3,
          createdAt: /* @__PURE__ */ new Date(),
          updatedAt: /* @__PURE__ */ new Date(),
          status: "pending"
        };
        this.jobs.set(jobId, job);
        console.log(`\u{1F4CB} Job enqueued: ${jobId} (type: ${type})`);
        this.processJobs();
        return jobId;
      }
      // Get job status
      getJob(jobId) {
        return this.jobs.get(jobId);
      }
      // Get all jobs (for debugging/monitoring)
      getAllJobs() {
        return Array.from(this.jobs.values());
      }
      // Get jobs by status
      getJobsByStatus(status) {
        return Array.from(this.jobs.values()).filter((job) => job.status === status);
      }
      // Start processing jobs continuously with exponential backoff
      startProcessing() {
        this.processJobs();
        setInterval(() => {
          this.processJobs();
        }, 5e3);
      }
      // Process pending jobs
      async processJobs() {
        if (this.isProcessing) return;
        this.isProcessing = true;
        try {
          const pendingJobs = this.getJobsByStatus("pending");
          const now = /* @__PURE__ */ new Date();
          const readyJobs = pendingJobs.filter((job) => {
            if (!job.nextRunAt) return true;
            return job.nextRunAt <= now;
          });
          for (const job of readyJobs) {
            if (this.processingJobs.has(job.id)) continue;
            const worker = this.workers.get(job.type);
            if (!worker) {
              console.warn(`\u26A0\uFE0F No worker registered for job type: ${job.type}`);
              continue;
            }
            this.processingJobs.add(job.id);
            job.status = "processing";
            job.updatedAt = /* @__PURE__ */ new Date();
            job.nextRunAt = void 0;
            this.processJob(job, worker);
          }
        } finally {
          this.isProcessing = false;
        }
      }
      // Process individual job
      async processJob(job, worker) {
        try {
          console.log(`\u{1F504} Processing job: ${job.id} (type: ${job.type})`);
          await worker(job);
          job.status = "completed";
          job.updatedAt = /* @__PURE__ */ new Date();
          this.processingJobs.delete(job.id);
          console.log(`\u2705 Job completed: ${job.id}`);
          this.emit("jobCompleted", job);
        } catch (error) {
          console.error(`\u274C Job failed: ${job.id}`, error);
          job.retries++;
          job.error = error instanceof Error ? error.message : String(error);
          job.updatedAt = /* @__PURE__ */ new Date();
          if (job.retries >= job.maxRetries) {
            job.status = "failed";
            console.error(`\u{1F4A5} Job failed permanently after ${job.retries} retries: ${job.id}`);
            this.emit("jobFailed", job);
            this.processingJobs.delete(job.id);
          } else {
            job.status = "pending";
            const delay = this.calculateRetryDelay(job.retries);
            const nextRunAt = new Date(Date.now() + delay);
            job.nextRunAt = nextRunAt;
            console.log(`\u{1F504} Job will retry (${job.retries}/${job.maxRetries}) at ${nextRunAt.toISOString()}: ${job.id}`);
            this.processingJobs.delete(job.id);
          }
        }
      }
      // Clean up old completed/failed jobs (call periodically)
      cleanup(olderThanHours = 24) {
        const cutoffTime = new Date(Date.now() - olderThanHours * 60 * 60 * 1e3);
        let cleaned = 0;
        for (const [jobId, job] of this.jobs.entries()) {
          if ((job.status === "completed" || job.status === "failed") && job.updatedAt < cutoffTime) {
            this.jobs.delete(jobId);
            cleaned++;
          }
        }
        if (cleaned > 0) {
          console.log(`\u{1F9F9} Cleaned up ${cleaned} old jobs`);
        }
      }
      // Calculate exponential backoff delay with jitter
      calculateRetryDelay(retryAttempt) {
        const baseDelay = Math.min(Math.pow(2, retryAttempt) * 1e3, 5 * 60 * 1e3);
        const jitterFactor = 0.5 + Math.random() * 0.5;
        const finalDelay = Math.floor(baseDelay * jitterFactor);
        return Math.max(finalDelay, 1e3);
      }
    };
    jobQueue = new JobQueue();
    setInterval(() => {
      jobQueue.cleanup(24);
    }, 60 * 60 * 1e3);
  }
});

// server/jobs/registerDomain.ts
async function registerDomainWorker(job) {
  const data = job.data;
  console.log(`\u{1F310} Starting domain registration for: ${data.domain} (attempt ${job.retries + 1}/${job.maxRetries + 1})`);
  try {
    const domainOrder = await storage.getDomainOrder(data.domainOrderId);
    if (!domainOrder) {
      throw new Error(`Domain order not found: ${data.domainOrderId}`);
    }
    if (domainOrder.status === "active") {
      console.log(`Domain order already active: ${data.domainOrderId}`);
      return;
    }
    await storage.updateDomainOrder(data.domainOrderId, {
      status: "registering"
    });
    console.log(`\u{1F517} Calling OpenSRS to register domain: ${data.domain}`);
    const registrationResult = await opensrs.register({
      domain: data.domain,
      years: data.years,
      contact: data.contact,
      privacy: data.privacy,
      nameservers: data.nameservers
    });
    if (registrationResult.success) {
      console.log(`\u2705 Domain registration successful: ${data.domain}`);
      await storage.updateDomainOrder(data.domainOrderId, {
        status: "active",
        providerRegId: registrationResult.providerRegId
      });
      await storage.createNotification(
        data.userId,
        `Domain ${data.domain} has been successfully registered!`,
        "success"
      );
      console.log(`\u{1F389} Domain registration completed successfully: ${data.domain}`);
    } else {
      const isRetryable = isRetryableRegistrationError(registrationResult.message);
      console.error(`\u274C Domain registration failed: ${data.domain} - ${registrationResult.message} (retryable: ${isRetryable})`);
      if (isRetryable && job.retries < job.maxRetries) {
        throw new Error(`Domain registration failed (retryable): ${registrationResult.message}`);
      }
      await storage.updateDomainOrder(data.domainOrderId, {
        status: "failed",
        errorMessage: getUserFriendlyErrorMessage(registrationResult.message)
      });
      await storage.createNotification(
        data.userId,
        `Domain registration failed for ${data.domain}. ${getUserFriendlyErrorMessage(registrationResult.message)}`,
        "error"
      );
      throw new Error(`Domain registration failed: ${registrationResult.message}`);
    }
  } catch (error) {
    const errorMessage = error instanceof Error ? error.message : String(error);
    const isRetryable = isRetryableError(errorMessage);
    console.error(`\u{1F4A5} Domain registration job failed for ${data.domain} (attempt ${job.retries + 1}/${job.maxRetries + 1}):`, error, `(retryable: ${isRetryable})`);
    if (isRetryable && job.retries < job.maxRetries) {
      throw error;
    }
    await storage.updateDomainOrder(data.domainOrderId, {
      status: "failed",
      errorMessage: getUserFriendlyErrorMessage(errorMessage)
    });
    await storage.createNotification(
      data.userId,
      `Domain registration failed for ${data.domain}. ${getUserFriendlyErrorMessage(errorMessage)} Please contact support if the issue persists.`,
      "error"
    );
    throw error;
  }
}
function isRetryableError(errorMessage) {
  const retryablePatterns = [
    "Authentication Failed",
    "Connection timeout",
    "Network error",
    "Service temporarily unavailable",
    "Internal server error",
    "Gateway timeout",
    "Service unavailable",
    "Temporary failure",
    "Rate limit exceeded"
  ];
  const lowerError = errorMessage.toLowerCase();
  return retryablePatterns.some(
    (pattern) => lowerError.includes(pattern.toLowerCase())
  );
}
function isRetryableRegistrationError(errorMessage) {
  const retryablePatterns = [
    "Authentication Failed",
    "Temporary failure",
    "Service temporarily unavailable",
    "Rate limit exceeded",
    "Connection timeout"
  ];
  const lowerError = errorMessage.toLowerCase();
  return retryablePatterns.some(
    (pattern) => lowerError.includes(pattern.toLowerCase())
  );
}
function getUserFriendlyErrorMessage(errorMessage) {
  const lowerError = errorMessage.toLowerCase();
  if (lowerError.includes("authentication failed")) {
    return "Registrar authentication is not configured. Please contact support.";
  }
  if (lowerError.includes("domain already exists") || lowerError.includes("domain not available")) {
    return "This domain is no longer available for registration.";
  }
  if (lowerError.includes("invalid contact") || lowerError.includes("contact information")) {
    return "There was an issue with the contact information provided.";
  }
  if (lowerError.includes("payment") || lowerError.includes("billing")) {
    return "There was a payment processing issue.";
  }
  if (lowerError.includes("rate limit")) {
    return "Too many requests. The registration will be retried automatically.";
  }
  return "An unexpected error occurred during registration.";
}
var init_registerDomain = __esm({
  "server/jobs/registerDomain.ts"() {
    "use strict";
    init_storage();
    init_opensrs();
  }
});

// server/jobs/index.ts
var jobs_exports = {};
__export(jobs_exports, {
  jobQueue: () => jobQueue
});
var init_jobs = __esm({
  "server/jobs/index.ts"() {
    "use strict";
    init_jobQueue();
    init_registerDomain();
    jobQueue.registerWorker("registerDomain", registerDomainWorker);
    console.log("\u{1F680} Job system initialized with workers:");
    console.log("  - registerDomain: Domain registration processing");
  }
});

// server/routes/stockLibraryRoutes.js
var stockLibraryRoutes_exports = {};
__export(stockLibraryRoutes_exports, {
  default: () => stockLibraryRoutes_default
});
import path7 from "path";
import fs7 from "fs/promises";
import express5 from "express";
import multer3 from "multer";
async function getAllPhotos() {
  try {
    const dbPath = path7.join(process.cwd(), "uploads", "photos-db.json");
    const data = await fs7.readFile(dbPath, "utf8");
    return JSON.parse(data);
  } catch (error) {
    return [];
  }
}
async function savePhotoToDB(photo) {
  try {
    const dbPath = path7.join(process.cwd(), "uploads", "photos-db.json");
    const photos = await getAllPhotos();
    photos.push(photo);
    await fs7.writeFile(dbPath, JSON.stringify(photos, null, 2));
    return photo;
  } catch (error) {
    console.error("Error saving photo to DB:", error);
    throw error;
  }
}
async function getAllMockups() {
  try {
    const dbPath = path7.join(process.cwd(), "uploads", "mockups-db.json");
    const data = await fs7.readFile(dbPath, "utf8");
    return JSON.parse(data);
  } catch (error) {
    return [];
  }
}
async function saveMockupToDB(mockup) {
  try {
    const dbPath = path7.join(process.cwd(), "uploads", "mockups-db.json");
    const mockups = await getAllMockups();
    mockups.push(mockup);
    await fs7.writeFile(dbPath, JSON.stringify(mockups, null, 2));
    return mockup;
  } catch (error) {
    console.error("Error saving mockup to DB:", error);
    throw error;
  }
}
async function deletePhotoFromDB(id) {
  try {
    const dbPath = path7.join(process.cwd(), "uploads", "photos-db.json");
    const photos = await getAllPhotos();
    const filteredPhotos = photos.filter((photo) => photo.id !== id);
    await fs7.writeFile(dbPath, JSON.stringify(filteredPhotos, null, 2));
    console.log(`\u2705 Deleted photo ${id} from database`);
    return true;
  } catch (error) {
    console.error("Error deleting photo from DB:", error);
    throw error;
  }
}
async function deleteMockupFromDB(id) {
  try {
    const dbPath = path7.join(process.cwd(), "uploads", "mockups-db.json");
    const mockups = await getAllMockups();
    const filteredMockups = mockups.filter((mockup) => mockup.id !== id);
    await fs7.writeFile(dbPath, JSON.stringify(filteredMockups, null, 2));
    console.log(`\u2705 Deleted mockup ${id} from database`);
    return true;
  } catch (error) {
    console.error("Error deleting mockup from DB:", error);
    throw error;
  }
}
async function insertStockDBRecord({ originalName, mimeType, uploaderId }) {
  const id = Math.floor(Date.now() / 1e3).toString(36) + Math.floor(Math.random() * 1e6).toString(36);
  return { id, originalName, mimeType, uploaderId };
}
var router16, uploadDir, storage2, upload3, stockLibraryRoutes_default;
var init_stockLibraryRoutes = __esm({
  "server/routes/stockLibraryRoutes.js"() {
    "use strict";
    init_watermark();
    init_objectStorage();
    init_entitlements();
    init_adminGuard();
    router16 = express5.Router();
    uploadDir = path7.join(process.cwd(), "uploads", "photos");
    storage2 = multer3.diskStorage({
      destination: async (_req, _file, cb) => {
        await fs7.mkdir(uploadDir, { recursive: true });
        cb(null, uploadDir);
      },
      filename: (_req, file2, cb) => {
        const stamp = Date.now();
        const safe = file2.originalname.replace(/\s+/g, "_");
        cb(null, `${stamp}_${safe}`);
      }
    });
    upload3 = multer3({
      storage: storage2,
      limits: { fileSize: 25 * 1024 * 1024 }
      // 25MB
    });
    router16.post("/upload", upload3.single("file"), async (req, res) => {
      try {
        if (!req.file) return res.status(400).json({ error: "No file uploaded" });
        const dbRow = await insertStockDBRecord({
          originalName: file.originalname,
          mimeType: file.mimetype,
          uploaderId: req.user?.id || "admin"
        });
        const tenDigit = toTenDigitCode(dbRow.id);
        const originalBuf = await fs7.readFile(file.path);
        const objectStorage2 = new ObjectStorageService();
        const publicPaths = objectStorage2.getPublicObjectSearchPaths();
        const originalPath = `${publicPaths[0]}/stock/original/${dbRow.id}/${file.filename}`;
        try {
          await objectStorage2.uploadFile(originalPath, originalBuf);
          console.log(`\u2705 Uploaded original to object storage: ${originalPath}`);
        } catch (uploadError) {
          console.warn(`\u26A0\uFE0F Object storage upload failed, saving locally:`, uploadError);
        }
        const wmBuf = await applyWatermark(originalBuf, { stockSeed: dbRow.id, opacity: 0.15 });
        const previewPath = `${publicPaths[0]}/stock/preview/${dbRow.id}/${file.filename}`;
        try {
          await objectStorage2.uploadFile(previewPath, wmBuf);
          console.log(`\u2705 Uploaded preview to object storage: ${previewPath}`);
        } catch (uploadError) {
          console.warn(`\u26A0\uFE0F Preview upload failed, saving locally:`, uploadError);
          const localPreviewDir = path7.join(process.cwd(), "uploads", "previews", dbRow.id);
          await fs7.mkdir(localPreviewDir, { recursive: true });
          const localPreviewPath = path7.join(localPreviewDir, file.filename);
          await fs7.writeFile(localPreviewPath, wmBuf);
        }
        await fs7.unlink(file.path).catch(() => {
        });
        const photoRecord = {
          id: dbRow.id,
          name: file.originalname,
          filename: file.filename,
          mimeType: file.mimetype,
          uploadedAt: (/* @__PURE__ */ new Date()).toISOString(),
          uploaderId: req.user?.id || "admin"
        };
        await savePhotoToDB(photoRecord);
        res.json({
          id: dbRow.id,
          code: tenDigit,
          name: file.originalname,
          mimeType: file.mimetype,
          previewUrl: `/api/stock/${dbRow.id}/preview`,
          originalKey: originalPath
          // private
        });
      } catch (err) {
        console.error("Upload error:", err);
        res.status(500).json({ error: "Upload failed" });
      }
    });
    router16.post("/photos", upload3.array("files"), async (req, res) => {
      try {
        if (!req.files || req.files.length === 0) return res.status(400).json({ error: "No files uploaded" });
        const file2 = req.files[0];
        const dbRow = await insertStockDBRecord({
          originalName: file2.originalname,
          mimeType: file2.mimetype,
          uploaderId: req.user?.id || "admin"
        });
        const tenDigit = toTenDigitCode(dbRow.id);
        const originalBuf = await fs7.readFile(file2.path);
        const objectStorage2 = new ObjectStorageService();
        const publicPaths = objectStorage2.getPublicObjectSearchPaths();
        const originalPath = `${publicPaths[0]}/stock/original/${dbRow.id}/${file2.filename}`;
        try {
          await objectStorage2.uploadFile(originalPath, originalBuf);
          console.log(`\u2705 Uploaded original to object storage: ${originalPath}`);
        } catch (uploadError) {
          console.warn(`\u26A0\uFE0F Object storage upload failed, saving locally:`, uploadError);
        }
        const wmBuf = await applyWatermark(originalBuf, { stockSeed: dbRow.id, opacity: 0.15 });
        const previewPath = `${publicPaths[0]}/stock/preview/${dbRow.id}/${file2.filename}`;
        try {
          await objectStorage2.uploadFile(previewPath, wmBuf);
          console.log(`\u2705 Uploaded preview to object storage: ${previewPath}`);
        } catch (uploadError) {
          console.warn(`\u26A0\uFE0F Preview upload failed, saving locally:`, uploadError);
          const localPreviewDir = path7.join(process.cwd(), "uploads", "previews", dbRow.id);
          await fs7.mkdir(localPreviewDir, { recursive: true });
          const localPreviewPath = path7.join(localPreviewDir, file2.filename);
          await fs7.writeFile(localPreviewPath, wmBuf);
        }
        await fs7.unlink(file2.path).catch(() => {
        });
        const photoRecord = {
          id: dbRow.id,
          name: file2.originalname,
          filename: file2.filename,
          mimeType: file2.mimetype,
          uploadedAt: (/* @__PURE__ */ new Date()).toISOString(),
          uploaderId: req.user?.id || "admin"
        };
        await savePhotoToDB(photoRecord);
        res.json({
          id: dbRow.id,
          code: tenDigit,
          name: file2.originalname,
          mimeType: file2.mimetype,
          previewUrl: `/api/stock/${dbRow.id}/preview`,
          originalKey: originalPath
          // private
        });
      } catch (err) {
        console.error("Upload error:", err);
        res.status(500).json({ error: "Upload failed" });
      }
    });
    router16.post("/mockups", upload3.array("files", 10), async (req, res) => {
      try {
        if (!req.files || req.files.length === 0) return res.status(400).json({ error: "No files uploaded" });
        const results = [];
        const objectStorage2 = new ObjectStorageService();
        const publicPaths = objectStorage2.getPublicObjectSearchPaths();
        for (const file2 of req.files) {
          const dbRow = await insertStockDBRecord({
            originalName: file2.originalname,
            mimeType: file2.mimetype,
            uploaderId: req.user?.id || "admin"
          });
          const tenDigit = toTenDigitCode(dbRow.id);
          const originalBuf = await fs7.readFile(file2.path);
          const originalPath = `${publicPaths[0]}/mockups/original/${dbRow.id}/${file2.filename}`;
          try {
            await objectStorage2.uploadFile(originalPath, originalBuf, file2.mimetype);
            console.log(`\u2705 Uploaded original mockup to object storage: ${originalPath}`);
          } catch (uploadError) {
            console.warn(`\u26A0\uFE0F Object storage upload failed, saving locally:`, uploadError);
          }
          const wmBuf = await applyWatermark(originalBuf, { stockSeed: dbRow.id, opacity: 0.15 });
          const previewPath = `${publicPaths[0]}/mockups/preview/${dbRow.id}/${file2.filename}`;
          try {
            await objectStorage2.uploadFile(previewPath, wmBuf, file2.mimetype);
            console.log(`\u2705 Uploaded mockup preview to object storage: ${previewPath}`);
          } catch (uploadError) {
            console.warn(`\u26A0\uFE0F Mockup preview upload failed, saving locally:`, uploadError);
            const localPreviewDir = path7.join(process.cwd(), "uploads", "mockup-previews", dbRow.id);
            await fs7.mkdir(localPreviewDir, { recursive: true });
            const localPreviewPath = path7.join(localPreviewDir, file2.filename);
            await fs7.writeFile(localPreviewPath, wmBuf);
          }
          await fs7.unlink(file2.path).catch(() => {
          });
          const mockupRecord = {
            id: dbRow.id,
            name: file2.originalname,
            filename: file2.filename,
            mimeType: file2.mimetype,
            uploadedAt: (/* @__PURE__ */ new Date()).toISOString(),
            uploaderId: req.user?.id || "admin"
          };
          await saveMockupToDB(mockupRecord);
          results.push({
            id: dbRow.id,
            code: tenDigit,
            name: file2.originalname,
            mimeType: file2.mimetype,
            previewUrl: `/api/mockups/${dbRow.id}/preview`,
            originalKey: originalPath
            // private
          });
        }
        res.json({ uploaded: results });
      } catch (err) {
        console.error("Mockup upload error:", err);
        res.status(500).json({ error: "Upload failed" });
      }
    });
    router16.delete("/photos/:id", requireAdmin, async (req, res) => {
      try {
        const { id } = req.params;
        console.log(`\u{1F5D1}\uFE0F Deleting photo ${id}...`);
        const objectStorage2 = new ObjectStorageService();
        const searchPaths = objectStorage2.getPublicObjectSearchPaths();
        for (const searchPath of searchPaths) {
          const parts = searchPath.split("/");
          const bucketName = parts[1];
          const basePrefix = parts.slice(2).join("/");
          const bucket2 = objectStorageClient.bucket(bucketName);
          try {
            const originalPrefix = `${basePrefix}/stock/original/${id}/`;
            const [originalFiles] = await bucket2.getFiles({ prefix: originalPrefix });
            for (const file2 of originalFiles) {
              await file2.delete();
              console.log(`\u2705 Deleted original from object storage: ${file2.name}`);
            }
          } catch (originalError) {
            console.warn(`\u26A0\uFE0F Failed to delete original from object storage:`, originalError);
          }
          try {
            const previewPrefix = `${basePrefix}/stock/preview/${id}/`;
            const [previewFiles] = await bucket2.getFiles({ prefix: previewPrefix });
            for (const file2 of previewFiles) {
              await file2.delete();
              console.log(`\u2705 Deleted preview from object storage: ${file2.name}`);
            }
          } catch (previewError) {
            console.warn(`\u26A0\uFE0F Failed to delete preview from object storage:`, previewError);
          }
        }
        try {
          const localPhotosDir = path7.join(process.cwd(), "uploads", "photos");
          try {
            const localFiles = await fs7.readdir(localPhotosDir);
            for (const filename of localFiles) {
              if (filename.includes(id)) {
                const localFilePath = path7.join(localPhotosDir, filename);
                await fs7.unlink(localFilePath);
                console.log(`\u2705 Deleted local photo file: ${filename}`);
              }
            }
          } catch (localPhotosError) {
            console.warn(`\u26A0\uFE0F No local photos to clean up or error:`, localPhotosError);
          }
          const localPreviewDir = path7.join(process.cwd(), "uploads", "previews", id);
          try {
            await fs7.rmdir(localPreviewDir, { recursive: true });
            console.log(`\u2705 Deleted local preview directory: ${localPreviewDir}`);
          } catch (localPreviewError) {
            console.warn(`\u26A0\uFE0F No local preview to clean up or error:`, localPreviewError);
          }
        } catch (cleanupError) {
          console.warn(`\u26A0\uFE0F Local file cleanup error:`, cleanupError);
        }
        await deletePhotoFromDB(id);
        console.log(`\u2705 Successfully deleted photo ${id}`);
        res.json({ success: true, message: `Photo ${id} deleted successfully` });
      } catch (err) {
        console.error("Delete photo error:", err);
        res.status(500).json({ error: "Failed to delete photo" });
      }
    });
    router16.delete("/mockups/:id", requireAdmin, async (req, res) => {
      try {
        const { id } = req.params;
        console.log(`\u{1F5D1}\uFE0F Deleting mockup ${id}...`);
        const objectStorage2 = new ObjectStorageService();
        const searchPaths = objectStorage2.getPublicObjectSearchPaths();
        for (const searchPath of searchPaths) {
          const parts = searchPath.split("/");
          const bucketName = parts[1];
          const basePrefix = parts.slice(2).join("/");
          const bucket2 = objectStorageClient.bucket(bucketName);
          try {
            const originalPrefix = `${basePrefix}/mockups/original/${id}/`;
            const [originalFiles] = await bucket2.getFiles({ prefix: originalPrefix });
            for (const file2 of originalFiles) {
              await file2.delete();
              console.log(`\u2705 Deleted original mockup from object storage: ${file2.name}`);
            }
          } catch (originalError) {
            console.warn(`\u26A0\uFE0F Failed to delete original mockup from object storage:`, originalError);
          }
          try {
            const previewPrefix = `${basePrefix}/mockups/preview/${id}/`;
            const [previewFiles] = await bucket2.getFiles({ prefix: previewPrefix });
            for (const file2 of previewFiles) {
              await file2.delete();
              console.log(`\u2705 Deleted mockup preview from object storage: ${file2.name}`);
            }
          } catch (previewError) {
            console.warn(`\u26A0\uFE0F Failed to delete mockup preview from object storage:`, previewError);
          }
        }
        try {
          const localMockupsDir = path7.join(process.cwd(), "uploads", "mockups");
          try {
            const localFiles = await fs7.readdir(localMockupsDir);
            for (const filename of localFiles) {
              if (filename.includes(id)) {
                const localFilePath = path7.join(localMockupsDir, filename);
                await fs7.unlink(localFilePath);
                console.log(`\u2705 Deleted local mockup file: ${filename}`);
              }
            }
          } catch (localMockupsError) {
            console.warn(`\u26A0\uFE0F No local mockups to clean up or error:`, localMockupsError);
          }
          const localPreviewDir = path7.join(process.cwd(), "uploads", "mockup-previews", id);
          try {
            await fs7.rmdir(localPreviewDir, { recursive: true });
            console.log(`\u2705 Deleted local mockup preview directory: ${localPreviewDir}`);
          } catch (localPreviewError) {
            console.warn(`\u26A0\uFE0F No local mockup preview to clean up or error:`, localPreviewError);
          }
        } catch (cleanupError) {
          console.warn(`\u26A0\uFE0F Local file cleanup error:`, cleanupError);
        }
        await deleteMockupFromDB(id);
        console.log(`\u2705 Successfully deleted mockup ${id}`);
        res.json({ success: true, message: `Mockup ${id} deleted successfully` });
      } catch (err) {
        console.error("Delete mockup error:", err);
        res.status(500).json({ error: "Failed to delete mockup" });
      }
    });
    router16.get("/photos", async (req, res) => {
      try {
        const photos = await getAllPhotos();
        res.json(photos);
      } catch (err) {
        console.error("Error listing photos:", err);
        res.status(500).json({ error: "Failed to list photos" });
      }
    });
    router16.get("/mockups", async (req, res) => {
      try {
        const mockups = await getAllMockups();
        const formattedMockups = mockups.map((mockup) => ({
          id: mockup.id,
          name: mockup.name,
          mimeType: mockup.mimeType,
          code: toTenDigitCode(mockup.id),
          previewUrl: `/api/stock/${mockup.id}/mockup-preview`,
          createdAt: new Date(mockup.uploadedAt).getTime(),
          tags: mockup.tags || [],
          category: mockup.category || "mockup",
          url: `/api/stock/${mockup.id}/mockup-preview`
          // For compatibility
        }));
        res.json({ mockups: formattedMockups });
      } catch (err) {
        console.error("Error listing mockups:", err);
        res.status(500).json({ error: "Failed to list mockups" });
      }
    });
    router16.get("/:id/preview", async (req, res) => {
      try {
        const { id } = req.params;
        const objectStorage2 = new ObjectStorageService();
        const searchPaths = objectStorage2.getPublicObjectSearchPaths();
        let file2 = null;
        for (const searchPath of searchPaths) {
          const parts = searchPath.split("/");
          const bucketName = parts[1];
          const basePrefix = parts.slice(2).join("/");
          const prefix = `${basePrefix}/stock/preview/${id}/`;
          const bucket2 = objectStorageClient.bucket(bucketName);
          try {
            const [files] = await bucket2.getFiles({ prefix });
            if (files.length > 0) {
              file2 = files[0];
              break;
            }
          } catch (searchError) {
            continue;
          }
        }
        if (file2) {
          console.log(`\u2705 Found cloud preview for stock ID ${id}: ${file2.name}`);
          return await objectStorage2.downloadObject(file2, res);
        }
        try {
          const localPreviewDir = path7.join(process.cwd(), "uploads", "previews", id);
          const files = await fs7.readdir(localPreviewDir);
          if (files.length > 0) {
            const filename = files[0];
            const localFilePath = path7.join(localPreviewDir, filename);
            const ext = path7.extname(filename).toLowerCase();
            const mimeType = ext === ".png" ? "image/png" : "image/jpeg";
            res.setHeader("Content-Type", mimeType);
            res.setHeader("Cache-Control", "public, max-age=31536000");
            const fileStream = fs7.createReadStream(localFilePath);
            return fileStream.pipe(res);
          }
        } catch (localError) {
          console.warn(`Local fallback failed for ${id}:`, localError);
        }
        res.status(404).send("Preview not found");
      } catch (err) {
        console.error("Preview error:", err);
        res.status(500).send("Preview error");
      }
    });
    router16.get("/:id/download", async (req, res) => {
      try {
        const { id } = req.params;
        const userId = req.user?.id || null;
        async function streamOriginal() {
          const objectStorage2 = new ObjectStorageService();
          const searchPaths = objectStorage2.getPublicObjectSearchPaths();
          let file2 = null;
          for (const searchPath of searchPaths) {
            const parts = searchPath.split("/");
            const bucketName = parts[1];
            const basePrefix = parts.slice(2).join("/");
            const prefix = `${basePrefix}/stock/original/${id}/`;
            const bucket2 = objectStorageClient.bucket(bucketName);
            try {
              const [files] = await bucket2.getFiles({ prefix });
              if (files.length > 0) {
                file2 = files[0];
                break;
              }
            } catch (searchError) {
              continue;
            }
          }
          if (!file2) {
            return res.status(404).send("Original not found");
          }
          res.setHeader("Content-Disposition", `attachment; filename="IBrandBiz_${id}.jpg"`);
          res.setHeader("Content-Type", file2.metadata?.contentType || "image/jpeg");
          return await objectStorage2.downloadObject(file2, res);
        }
        async function streamPreviewWithHeaders(extraHeaders = {}) {
          const objectStorage2 = new ObjectStorageService();
          const searchPaths = objectStorage2.getPublicObjectSearchPaths();
          let file2 = null;
          for (const searchPath of searchPaths) {
            const parts = searchPath.split("/");
            const bucketName = parts[1];
            const basePrefix = parts.slice(2).join("/");
            const prefix = `${basePrefix}/stock/preview/${id}/`;
            const bucket2 = objectStorageClient.bucket(bucketName);
            try {
              const [files] = await bucket2.getFiles({ prefix });
              if (files.length > 0) {
                file2 = files[0];
                break;
              }
            } catch (searchError) {
              continue;
            }
          }
          if (file2) {
            for (const [k, v] of Object.entries(extraHeaders)) res.setHeader(k, v);
            res.setHeader("Content-Type", file2.metadata?.contentType || "image/jpeg");
            return await objectStorage2.downloadObject(file2, res);
          }
          try {
            const localPreviewDir = path7.join(process.cwd(), "uploads", "previews", id);
            const files = await fs7.readdir(localPreviewDir);
            if (files.length > 0) {
              const filename = files[0];
              const localFilePath = path7.join(localPreviewDir, filename);
              const ext = path7.extname(filename).toLowerCase();
              const mimeType = ext === ".png" ? "image/png" : "image/jpeg";
              for (const [k, v] of Object.entries(extraHeaders)) res.setHeader(k, v);
              res.setHeader("Content-Type", mimeType);
              const fileStream = fs7.createReadStream(localFilePath);
              return fileStream.pipe(res);
            }
          } catch (localError) {
            console.warn(`Local preview fallback failed for ${id}:`, localError);
          }
          return res.status(404).send("Preview not found");
        }
        if (!userId) {
          return streamPreviewWithHeaders({ "X-Quota-Remaining": "0", "X-License": "none" });
        }
        if (hasLicense(userId, id)) {
          res.setHeader("X-License", "owned");
          return streamOriginal();
        }
        const remaining = getTotalRemaining(userId);
        if (remaining > 0) {
          const ok = decrementOne(userId);
          if (ok) {
            grantLicenses(userId, [id]);
            res.setHeader("X-Quota-Remaining", String(remaining - 1));
            res.setHeader("X-License", "newly-granted");
            return streamOriginal();
          }
        }
        return streamPreviewWithHeaders({ "X-Quota-Remaining": "0", "X-License": "none" });
      } catch (err) {
        console.error(err);
        res.status(500).send("Download error");
      }
    });
    router16.get("/:id/entitlement", async (req, res) => {
      try {
        const { id } = req.params;
        const userId = req.user?.id || null;
        const licensed = userId ? hasLicense(userId, id) : false;
        const quotaRemaining = userId ? getTotalRemaining(userId) : 0;
        res.json({
          userId: userId || null,
          licensed,
          quotaRemaining,
          canDownloadOriginal: licensed || quotaRemaining > 0
        });
      } catch (e) {
        console.error("entitlement error", e);
        res.status(500).json({ error: "entitlement_failed" });
      }
    });
    stockLibraryRoutes_default = router16;
  }
});

// server/routes/mockupLibraryRoutes.js
var mockupLibraryRoutes_exports = {};
__export(mockupLibraryRoutes_exports, {
  default: () => mockupLibraryRoutes_default
});
import path8 from "path";
import fs8 from "fs";
import fsPromises from "fs/promises";
import express6 from "express";
import multer4 from "multer";
async function getAllMockups2() {
  try {
    const dbPath = path8.join(process.cwd(), "uploads", "mockups-db.json");
    const data = await fsPromises.readFile(dbPath, "utf8");
    return JSON.parse(data);
  } catch (error) {
    return [];
  }
}
async function saveMockupToDB2(mockup) {
  try {
    const dbPath = path8.join(process.cwd(), "uploads", "mockups-db.json");
    const mockups = await getAllMockups2();
    mockups.push(mockup);
    await fsPromises.writeFile(dbPath, JSON.stringify(mockups, null, 2));
    return mockup;
  } catch (error) {
    console.error("Error saving mockup to DB:", error);
    throw error;
  }
}
async function insertMockupDBRecord({ originalName, mimeType, uploaderId }) {
  const id = Math.floor(Date.now() / 1e3).toString(36) + Math.floor(Math.random() * 1e6).toString(36);
  return { id, originalName, mimeType, uploaderId };
}
var router17, uploadDir2, storage3, upload4, mockupLibraryRoutes_default;
var init_mockupLibraryRoutes = __esm({
  "server/routes/mockupLibraryRoutes.js"() {
    "use strict";
    init_watermark();
    init_objectStorage();
    init_entitlements();
    router17 = express6.Router();
    uploadDir2 = path8.join(process.cwd(), "uploads", "mockups");
    storage3 = multer4.diskStorage({
      destination: async (_req, _file, cb) => {
        await fsPromises.mkdir(uploadDir2, { recursive: true });
        cb(null, uploadDir2);
      },
      filename: (_req, file2, cb) => {
        const stamp = Date.now();
        const safe = file2.originalname.replace(/\s+/g, "_");
        cb(null, `${stamp}_${safe}`);
      }
    });
    upload4 = multer4({
      storage: storage3,
      limits: { fileSize: 25 * 1024 * 1024 }
      // 25MB
    });
    router17.post("/upload", upload4.single("file"), async (req, res) => {
      try {
        if (!req.file) return res.status(400).json({ error: "No file uploaded" });
        const dbRow = await insertMockupDBRecord({
          originalName: req.file.originalname,
          mimeType: req.file.mimetype,
          uploaderId: req.user?.id || "admin"
        });
        const tenDigit = toTenDigitCode(dbRow.id);
        const originalBuf = await fsPromises.readFile(req.file.path);
        const objectStorage2 = new ObjectStorageService();
        const publicPaths = objectStorage2.getPublicObjectSearchPaths();
        const originalPath = `${publicPaths[0]}/mockups/original/${dbRow.id}/${req.file.filename}`;
        try {
          await objectStorage2.uploadObject(originalPath, originalBuf);
          console.log(`\u2705 Uploaded original mockup to object storage: ${originalPath}`);
        } catch (uploadError) {
          console.warn(`\u26A0\uFE0F Object storage upload failed, saving locally:`, uploadError);
        }
        const wmBuf = await applyWatermark(originalBuf, { stockSeed: dbRow.id, opacity: 0.15 });
        const previewPath = `${publicPaths[0]}/mockups/preview/${dbRow.id}/${req.file.filename}`;
        try {
          await objectStorage2.uploadObject(previewPath, wmBuf);
          console.log(`\u2705 Uploaded mockup preview to object storage: ${previewPath}`);
        } catch (uploadError) {
          console.warn(`\u26A0\uFE0F Mockup preview upload failed, saving locally:`, uploadError);
          const localPreviewDir = path8.join(process.cwd(), "uploads", "mockup-previews", dbRow.id);
          await fsPromises.mkdir(localPreviewDir, { recursive: true });
          const localPreviewPath = path8.join(localPreviewDir, req.file.filename);
          await fsPromises.writeFile(localPreviewPath, wmBuf);
        }
        await fsPromises.unlink(req.file.path).catch(() => {
        });
        const mockupRecord = {
          id: dbRow.id,
          name: req.file.originalname,
          filename: req.file.filename,
          mimeType: req.file.mimetype,
          uploadedAt: (/* @__PURE__ */ new Date()).toISOString(),
          uploaderId: req.user?.id || "admin"
        };
        await saveMockupToDB2(mockupRecord);
        res.json({
          id: dbRow.id,
          code: tenDigit,
          name: req.file.originalname,
          mimeType: req.file.mimetype,
          previewUrl: `/api/mockups/${dbRow.id}/preview`,
          originalKey: originalPath
          // private
        });
      } catch (err) {
        console.error("Mockup upload error:", err);
        res.status(500).json({ error: "Upload failed" });
      }
    });
    router17.get("/list", async (req, res) => {
      try {
        const mockups = await getAllMockups2();
        const formattedMockups = mockups.map((mockup) => ({
          id: mockup.id,
          name: mockup.name,
          mimeType: mockup.mimeType,
          code: toTenDigitCode(mockup.id),
          previewUrl: `/api/mockups/${mockup.id}/preview`,
          createdAt: new Date(mockup.uploadedAt).getTime(),
          tags: [],
          category: "mockup",
          url: `/api/mockups/${mockup.id}/preview`
          // For compatibility
        }));
        res.json({ mockups: formattedMockups });
      } catch (err) {
        console.error("Error listing mockups:", err);
        res.status(500).json({ error: "Failed to list mockups" });
      }
    });
    router17.get("/:id/preview", async (req, res) => {
      try {
        const { id } = req.params;
        const objectStorage2 = new ObjectStorageService();
        const searchPaths = objectStorage2.getPublicObjectSearchPaths();
        let file2 = null;
        for (const searchPath of searchPaths) {
          const parts = searchPath.split("/");
          const bucketName = parts[1];
          const basePrefix = parts.slice(2).join("/");
          const prefix = `${basePrefix}/mockups/preview/${id}/`;
          const bucket2 = objectStorageClient.bucket(bucketName);
          try {
            const [files] = await bucket2.getFiles({ prefix });
            if (files.length > 0) {
              file2 = files[0];
              break;
            }
          } catch (searchError) {
            continue;
          }
        }
        if (file2) {
          console.log(`\u2705 Found cloud preview for mockup ID ${id}: ${file2.name}`);
          return await objectStorage2.downloadObject(file2, res);
        }
        try {
          const localPreviewDir = path8.join(process.cwd(), "uploads", "mockup-previews", id);
          const files = await fsPromises.readdir(localPreviewDir);
          if (files.length > 0) {
            const filename = files[0];
            const localFilePath = path8.join(localPreviewDir, filename);
            const ext = path8.extname(filename).toLowerCase();
            const mimeType = ext === ".png" ? "image/png" : "image/jpeg";
            res.setHeader("Content-Type", mimeType);
            res.setHeader("Cache-Control", "public, max-age=31536000");
            const fileStream = fs8.createReadStream(localFilePath);
            return fileStream.pipe(res);
          }
        } catch (localError) {
          console.warn(`Local fallback failed for mockup ${id}:`, localError);
        }
        res.status(404).send("Preview not found");
      } catch (err) {
        console.error("Mockup preview error:", err);
        res.status(500).send("Preview error");
      }
    });
    router17.get("/:id/download", async (req, res) => {
      try {
        const { id } = req.params;
        const userId = req.user?.id || null;
        async function streamOriginal() {
          const objectStorage2 = new ObjectStorageService();
          const searchPaths = objectStorage2.getPublicObjectSearchPaths();
          let file2 = null;
          for (const searchPath of searchPaths) {
            const parts = searchPath.split("/");
            const bucketName = parts[1];
            const basePrefix = parts.slice(2).join("/");
            const prefix = `${basePrefix}/mockups/original/${id}/`;
            const bucket2 = objectStorageClient.bucket(bucketName);
            try {
              const [files] = await bucket2.getFiles({ prefix });
              if (files.length > 0) {
                file2 = files[0];
                break;
              }
            } catch (searchError) {
              continue;
            }
          }
          if (!file2) {
            return res.status(404).send("Original not found");
          }
          res.setHeader("Content-Disposition", `attachment; filename="IBrandBiz_Mockup_${id}.png"`);
          res.setHeader("Content-Type", file2.metadata?.contentType || "image/png");
          return await objectStorage2.downloadObject(file2, res);
        }
        async function streamPreviewWithHeaders(extraHeaders = {}) {
          const objectStorage2 = new ObjectStorageService();
          const searchPaths = objectStorage2.getPublicObjectSearchPaths();
          let file2 = null;
          for (const searchPath of searchPaths) {
            const parts = searchPath.split("/");
            const bucketName = parts[1];
            const basePrefix = parts.slice(2).join("/");
            const prefix = `${basePrefix}/mockups/preview/${id}/`;
            const bucket2 = objectStorageClient.bucket(bucketName);
            try {
              const [files] = await bucket2.getFiles({ prefix });
              if (files.length > 0) {
                file2 = files[0];
                break;
              }
            } catch (searchError) {
              continue;
            }
          }
          if (file2) {
            for (const [k, v] of Object.entries(extraHeaders)) res.setHeader(k, v);
            res.setHeader("Content-Type", file2.metadata?.contentType || "image/png");
            return await objectStorage2.downloadObject(file2, res);
          }
          try {
            const localPreviewDir = path8.join(process.cwd(), "uploads", "mockup-previews", id);
            const files = await fsPromises.readdir(localPreviewDir);
            if (files.length > 0) {
              const filename = files[0];
              const localFilePath = path8.join(localPreviewDir, filename);
              const ext = path8.extname(filename).toLowerCase();
              const mimeType = ext === ".png" ? "image/png" : "image/jpeg";
              for (const [k, v] of Object.entries(extraHeaders)) res.setHeader(k, v);
              res.setHeader("Content-Type", mimeType);
              const fileStream = fs8.createReadStream(localFilePath);
              return fileStream.pipe(res);
            }
          } catch (localError) {
            console.warn(`Local mockup preview fallback failed for ${id}:`, localError);
          }
          return res.status(404).send("Preview not found");
        }
        if (!userId) {
          return streamPreviewWithHeaders({ "X-Quota-Remaining": "0", "X-License": "none" });
        }
        if (hasLicense(userId, id)) {
          res.setHeader("X-License", "owned");
          return streamOriginal();
        }
        const remaining = getTotalRemaining(userId);
        if (remaining > 0) {
          const ok = decrementOne(userId);
          if (ok) {
            grantLicenses(userId, [id]);
            res.setHeader("X-Quota-Remaining", String(remaining - 1));
            res.setHeader("X-License", "newly-granted");
            return streamOriginal();
          }
        }
        return streamPreviewWithHeaders({ "X-Quota-Remaining": "0", "X-License": "none" });
      } catch (err) {
        console.error(err);
        res.status(500).send("Download error");
      }
    });
    router17.get("/:id/entitlement", async (req, res) => {
      try {
        const { id } = req.params;
        const userId = req.user?.id || null;
        const licensed = userId ? hasLicense(userId, id) : false;
        const quotaRemaining = userId ? getTotalRemaining(userId) : 0;
        res.json({
          userId: userId || null,
          licensed,
          quotaRemaining,
          canDownloadOriginal: licensed || quotaRemaining > 0
        });
      } catch (e) {
        console.error("mockup entitlement error", e);
        res.status(500).json({ error: "entitlement_failed" });
      }
    });
    mockupLibraryRoutes_default = router17;
  }
});

// server/routes/checkoutRoutes.js
var checkoutRoutes_exports = {};
__export(checkoutRoutes_exports, {
  default: () => checkoutRoutes_default
});
import express7 from "express";
import Stripe3 from "stripe";
var router18, stripe3, checkoutRoutes_default;
var init_checkoutRoutes = __esm({
  "server/routes/checkoutRoutes.js"() {
    "use strict";
    router18 = express7.Router();
    stripe3 = new Stripe3(process.env.STRIPE_SECRET_KEY, {
      apiVersion: "2024-06-20"
    });
    router18.post("/create-session", async (req, res) => {
      try {
        const { items = [], successPath = "/", cancelPath = "/cart" } = req.body || {};
        if (!Array.isArray(items) || items.length === 0) {
          return res.status(400).json({ error: "Cart is empty" });
        }
        const line_items = [];
        const purchasedAssetIds = [];
        for (const item of items) {
          if (item.kind === "stock") {
            const unit_amount = Number(item.priceCents || 699);
            const qty = Number(item.qty || 1);
            purchasedAssetIds.push(item.assetId);
            line_items.push({
              price_data: {
                currency: "usd",
                unit_amount,
                product_data: {
                  name: `Stock Photo: ${item.name || item.assetId}`
                }
              },
              quantity: qty
            });
          } else if (item.kind === "price") {
            if (!item.lookupKey) continue;
            const prices = await stripe3.prices.list({ lookup_keys: [item.lookupKey], expand: ["data.product"] });
            const price = prices.data?.[0];
            if (!price) throw new Error(`Price not found for lookupKey ${item.lookupKey}`);
            line_items.push({
              price: price.id,
              quantity: Number(item.qty || 1)
            });
          }
        }
        if (line_items.length === 0) {
          return res.status(400).json({ error: "No valid items" });
        }
        const domain = process.env.DOMAIN_URL || process.env.FRONTEND_URL || "http://localhost:5000";
        const session = await stripe3.checkout.sessions.create({
          mode: line_items.some((li) => !li.price) ? "payment" : "subscription",
          // if any price_data exists, it's a one-time payment; otherwise subscription
          line_items,
          success_url: `${domain}${successPath}?session_id={CHECKOUT_SESSION_ID}`,
          cancel_url: `${domain}${cancelPath}`,
          // attach user + assets for fulfillment
          metadata: {
            userId: String(req.user?.id || "anon"),
            assetIds: purchasedAssetIds.join(",")
            // "" if none
          },
          allow_promotion_codes: true
        });
        return res.json({ url: session.url });
      } catch (err) {
        console.error("create-session error", err);
        return res.status(500).json({ error: "Failed to create checkout" });
      }
    });
    checkoutRoutes_default = router18;
  }
});

// vite.config.ts
import { defineConfig } from "vite";
import react from "@vitejs/plugin-react";
import path11 from "path";
import runtimeErrorOverlay from "@replit/vite-plugin-runtime-error-modal";
var vite_config_default;
var init_vite_config = __esm({
  async "vite.config.ts"() {
    "use strict";
    vite_config_default = defineConfig({
      plugins: [
        react(),
        runtimeErrorOverlay(),
        ...process.env.NODE_ENV !== "production" && process.env.REPL_ID !== void 0 ? [
          await import("@replit/vite-plugin-cartographer").then(
            (m) => m.cartographer()
          )
        ] : []
      ],
      resolve: {
        alias: {
          "@": path11.resolve(import.meta.dirname, "client", "src"),
          "@shared": path11.resolve(import.meta.dirname, "shared"),
          "@assets": path11.resolve(import.meta.dirname, "attached_assets")
        }
      },
      root: path11.resolve(import.meta.dirname, "client"),
      build: {
        outDir: path11.resolve(import.meta.dirname, "dist/public"),
        emptyOutDir: true
      },
      server: {
        fs: {
          strict: true,
          deny: ["**/.*"]
        }
      }
    });
  }
});

// server/vite.ts
var vite_exports = {};
__export(vite_exports, {
  log: () => log,
  serveStatic: () => serveStatic,
  setupVite: () => setupVite
});
import express12 from "express";
import fs11 from "fs";
import path12 from "path";
import { createServer as createViteServer, createLogger } from "vite";
import { nanoid } from "nanoid";
function log(message, source = "express") {
  const formattedTime = (/* @__PURE__ */ new Date()).toLocaleTimeString("en-US", {
    hour: "numeric",
    minute: "2-digit",
    second: "2-digit",
    hour12: true
  });
  console.log(`${formattedTime} [${source}] ${message}`);
}
async function setupVite(app2, server) {
  const serverOptions = {
    middlewareMode: true,
    hmr: { server },
    allowedHosts: true
  };
  const vite = await createViteServer({
    ...vite_config_default,
    configFile: false,
    customLogger: {
      ...viteLogger,
      error: (msg, options) => {
        viteLogger.error(msg, options);
        process.exit(1);
      }
    },
    server: serverOptions,
    appType: "custom"
  });
  app2.use(vite.middlewares);
  app2.use("*", async (req, res, next) => {
    const url = req.originalUrl;
    try {
      const clientTemplate = path12.resolve(
        import.meta.dirname,
        "..",
        "client",
        "index.html"
      );
      let template = await fs11.promises.readFile(clientTemplate, "utf-8");
      template = template.replace(
        `src="/src/main.tsx"`,
        `src="/src/main.tsx?v=${nanoid()}"`
      );
      const page = await vite.transformIndexHtml(url, template);
      res.status(200).set({ "Content-Type": "text/html" }).end(page);
    } catch (e) {
      vite.ssrFixStacktrace(e);
      next(e);
    }
  });
}
function serveStatic(app2) {
  const distPath = path12.resolve(import.meta.dirname, "public");
  if (!fs11.existsSync(distPath)) {
    throw new Error(
      `Could not find the build directory: ${distPath}, make sure to build the client first`
    );
  }
  app2.use(express12.static(distPath));
  app2.use("*", (_req, res) => {
    res.sendFile(path12.resolve(distPath, "index.html"));
  });
}
var viteLogger;
var init_vite = __esm({
  async "server/vite.ts"() {
    "use strict";
    await init_vite_config();
    viteLogger = createLogger();
  }
});

// server/index.ts
import express13 from "express";
import cors from "cors";

// server/routes.ts
init_storage();
import express8 from "express";
import { createServer } from "http";
import os from "os";
import { performance } from "perf_hooks";
import { Readable } from "stream";

// server/admin/routes.ts
init_firebaseAdmin();
import { Router } from "express";

// server/admin/auditLogger.ts
var auditLog = [];
var MAX_AUDIT_ENTRIES = 1e3;
function logAuditEvent(event) {
  const auditEvent = {
    id: generateAuditId(),
    timestamp: (/* @__PURE__ */ new Date()).toISOString(),
    ...event
  };
  auditLog.unshift(auditEvent);
  if (auditLog.length > MAX_AUDIT_ENTRIES) {
    auditLog = auditLog.slice(0, MAX_AUDIT_ENTRIES);
  }
  console.log(`\u{1F50D} AUDIT: ${event.action} by ${event.adminUserId} (${event.adminRole})${event.targetUserId ? ` on ${event.targetUserId}` : ""}${event.details ? ` - ${event.details}` : ""}`);
}
function getRecentAuditEvents(limit = 50) {
  return auditLog.slice(0, limit);
}
function getAuditEventsForUser(userId, limit = 20) {
  return auditLog.filter((event) => event.targetUserId === userId || event.adminUserId === userId).slice(0, limit);
}
function generateAuditId() {
  return `audit_${Date.now()}_${Math.random().toString(36).substr(2, 9)}`;
}

// server/admin/routes.ts
init_storage();

// server/middleware/authz.ts
init_firebaseAdmin();
function requireRole(minimumRole) {
  return async (req, res, next) => {
    try {
      if (req.user) {
        if (!hasRolePermission(req.user.role, minimumRole)) {
          return res.status(403).json({
            error: "Insufficient permissions",
            userRole: req.user.role,
            requiredRole: minimumRole
          });
        }
        logAuditEvent({
          adminUserId: req.user.uid,
          adminRole: req.user.role,
          action: "API_ACCESS",
          details: `Accessed ${req.method} ${req.path} with role ${req.user.role}`
        });
        return next();
      }
      const authHeader = req.headers.authorization;
      const adminUser = await verifyAdminBearer(authHeader, minimumRole);
      req.user = {
        uid: adminUser.uid,
        role: adminUser.role,
        email: adminUser.email,
        ...adminUser
      };
      logAuditEvent({
        adminUserId: adminUser.uid,
        adminRole: adminUser.role,
        action: "API_ACCESS",
        details: `Accessed ${req.method} ${req.path} with role ${adminUser.role}`
      });
      next();
    } catch (error) {
      console.error(`Role guard failed for ${minimumRole}:`, error);
      const statusCode = error.message === "missing" ? 401 : error.message === "not_admin" || error.message === "insufficient_role" ? 403 : 500;
      res.status(statusCode).json({
        error: statusCode === 401 ? "Authentication required" : statusCode === 403 ? "Insufficient permissions" : "Internal server error",
        requiredRole: minimumRole
      });
    }
  };
}
var requireOwner = requireRole("owner");
var requireManagementOrAbove = requireRole("management");
var requireStaffOrAbove = requireRole("staff");
var requireAnalystOrAbove = requireRole("analyst");
function devBypass(fallbackRole = "owner") {
  return (req, res, next) => {
    if (process.env.NODE_ENV === "development" && !process.env.FIREBASE_PROJECT_ID) {
      console.log(`\u{1F513} Development mode: bypassing auth with role '${fallbackRole}'`);
      req.user = {
        uid: "dev-user",
        role: fallbackRole,
        email: "dev@localhost"
      };
    }
    next();
  };
}

// server/admin/routes.ts
init_schema();
import Stripe from "stripe";
var router = Router();
var stripe = null;
function getStripe() {
  if (stripe) return stripe;
  const stripeKey = process.env.STRIPE_SECRET_KEY;
  if (!stripeKey) {
    console.warn("STRIPE_SECRET_KEY not found - Stripe functionality will be disabled");
    return null;
  }
  try {
    stripe = new Stripe(stripeKey, {
      apiVersion: "2023-10-16"
    });
    return stripe;
  } catch (error) {
    console.error("Failed to initialize Stripe:", error);
    return null;
  }
}
var startOfMonth = () => new Date((/* @__PURE__ */ new Date()).getFullYear(), (/* @__PURE__ */ new Date()).getMonth(), 1);
var startOfYear = () => new Date((/* @__PURE__ */ new Date()).getFullYear(), 0, 1);
router.get("/api/admin/health", async (req, res) => {
  try {
    if (process.env.NODE_ENV === "development" || !process.env.FIREBASE_PROJECT_ID) {
      return res.json({
        ok: true,
        ts: Date.now(),
        mode: "development",
        firebase: "bypassed",
        database: "http-connection",
        roleSystem: "active"
      });
    }
    const adminUser = await verifyAdminBearer(req.headers.authorization, "staff");
    res.json({
      ok: true,
      ts: Date.now(),
      mode: "production",
      userRole: adminUser.role,
      roleSystem: "active"
    });
  } catch (error) {
    res.status(403).json({
      error: "Forbidden",
      details: process.env.NODE_ENV === "development" ? "Firebase Admin SDK not configured" : "Authentication failed"
    });
  }
});
router.get("/api/admin/users/count", devBypass("staff"), requireStaffOrAbove, async (req, res) => {
  try {
    logAuditEvent({
      adminUserId: req.user.uid,
      adminRole: req.user.role,
      action: "VIEW_USER_COUNT",
      details: "Requested user count statistics"
    });
    const users2 = await storage.getAllUsers();
    res.json({ users: users2.length });
  } catch (error) {
    console.error("Admin users/count error:", error);
    res.status(500).json({ error: "Internal server error" });
  }
});
router.get("/api/admin/users", devBypass("management"), requireManagementOrAbove, async (req, res) => {
  try {
    logAuditEvent({
      adminUserId: req.user.uid,
      adminRole: req.user.role,
      action: "VIEW_ALL_USERS",
      details: "Accessed full user database"
    });
    const users2 = await storage.getAllUsers();
    res.json({ users: users2 });
  } catch (error) {
    console.error("Admin users error:", error);
    res.status(500).json({ error: "Internal server error" });
  }
});
router.get("/api/admin/stats", devBypass("analyst"), requireAnalystOrAbove, async (req, res) => {
  try {
    logAuditEvent({
      adminUserId: req.user.uid,
      adminRole: req.user.role,
      action: "VIEW_PLATFORM_STATS",
      details: "Accessed platform statistics"
    });
    if (process.env.NODE_ENV === "development") {
      try {
        const { neon: neon2 } = await import("@neondatabase/serverless");
        const sql3 = neon2(process.env.DATABASE_URL);
        const userCountResult = await sql3`SELECT COUNT(*) as count FROM users`;
        const freeUsersResult = await sql3`SELECT COUNT(*) as count FROM users WHERE is_paid = false OR is_paid IS NULL`;
        const proUsersResult = await sql3`SELECT COUNT(*) as count FROM users WHERE is_paid = true`;
        const today = /* @__PURE__ */ new Date();
        const startOfDay = new Date(today.getFullYear(), today.getMonth(), today.getDate());
        const startOfWeek = new Date(today.setDate(today.getDate() - today.getDay()));
        const startOfMonth2 = new Date(today.getFullYear(), today.getMonth(), 1);
        const newPayingTodayResult = await sql3`SELECT COUNT(*) as count FROM users WHERE is_paid = true AND pro_activated_at >= ${startOfDay.toISOString()}`;
        const newPayingWeekResult = await sql3`SELECT COUNT(*) as count FROM users WHERE is_paid = true AND pro_activated_at >= ${startOfWeek.toISOString()}`;
        const newPayingMonthResult = await sql3`SELECT COUNT(*) as count FROM users WHERE is_paid = true AND pro_activated_at >= ${startOfMonth2.toISOString()}`;
        const recentUsersResult = await sql3`SELECT id, email, display_name, created_at, is_paid FROM users ORDER BY created_at DESC LIMIT 5`;
        const stats2 = {
          totalUsers: parseInt(userCountResult[0].count),
          freeUsers: parseInt(freeUsersResult[0].count),
          proUsers: parseInt(proUsersResult[0].count),
          newPayingUsersToday: parseInt(newPayingTodayResult[0].count),
          newPayingUsersThisWeek: parseInt(newPayingWeekResult[0].count),
          newPayingUsersThisMonth: parseInt(newPayingMonthResult[0].count),
          recentUsers: recentUsersResult.map((u) => ({
            id: u.id,
            email: u.email,
            displayName: u.display_name,
            createdAt: u.created_at,
            isPaid: u.is_paid
          }))
        };
        console.log("\u2705 Successfully fetched real database stats:", stats2);
        return res.json(stats2);
      } catch (sqlError) {
        console.log("Direct SQL failed, trying storage layer:", sqlError);
        try {
          const users3 = await storage.getAllUsers();
          const brandKits3 = await storage.getAllBrandKits();
          const businessNames3 = await storage.getAllBusinessNames();
          const freeUsers2 = users3.filter((u) => !u.isPaid).length;
          const proUsers2 = users3.filter((u) => u.isPaid).length;
          const stats2 = {
            totalUsers: users3.length,
            freeUsers: freeUsers2,
            proUsers: proUsers2,
            totalBrandKits: brandKits3.length,
            totalBusinessNames: businessNames3.length,
            recentUsers: users3.sort((a, b) => new Date(b.createdAt).getTime() - new Date(a.createdAt).getTime()).slice(0, 5).map((u) => ({
              id: u.id,
              email: u.email,
              displayName: u.displayName,
              createdAt: u.createdAt,
              isPaid: u.isPaid
            }))
          };
          return res.json(stats2);
        } catch (storageError) {
          console.log("All database access failed, using mock data");
          return res.json({
            totalUsers: 42,
            freeUsers: 35,
            proUsers: 7,
            totalBrandKits: 18,
            totalBusinessNames: 156,
            recentUsers: [
              {
                id: "1",
                email: "user1@example.com",
                displayName: "Test User 1",
                createdAt: (/* @__PURE__ */ new Date()).toISOString(),
                isPaid: false
              }
            ],
            note: "Using mock data due to database connectivity issues"
          });
        }
      }
    }
    const users2 = await storage.getAllUsers();
    const brandKits2 = await storage.getAllBrandKits();
    const businessNames2 = await storage.getAllBusinessNames();
    const freeUsers = users2.filter((u) => !u.isPaid).length;
    const proUsers = users2.filter((u) => u.isPaid).length;
    const stats = {
      totalUsers: users2.length,
      freeUsers,
      proUsers,
      totalBrandKits: brandKits2.length,
      totalBusinessNames: businessNames2.length,
      recentUsers: users2.sort((a, b) => new Date(b.createdAt).getTime() - new Date(a.createdAt).getTime()).slice(0, 5).map((u) => ({
        id: u.id,
        email: u.email,
        displayName: u.displayName,
        createdAt: u.createdAt,
        isPaid: u.isPaid
      }))
    };
    res.json(stats);
  } catch (error) {
    console.error("Admin stats error:", error);
    res.status(500).json({ error: "Internal server error" });
  }
});
router.get("/api/admin/visitor-stats", devBypass("analyst"), requireAnalystOrAbove, async (req, res) => {
  try {
    logAuditEvent({
      adminUserId: req.user.uid,
      adminRole: req.user.role,
      action: "VIEW_VISITOR_STATS",
      details: "Accessed visitor analytics statistics"
    });
    const endDate = /* @__PURE__ */ new Date();
    const startDate = /* @__PURE__ */ new Date();
    startDate.setDate(endDate.getDate() - 30);
    const startDateStr = startDate.toISOString().split("T")[0];
    const endDateStr = endDate.toISOString().split("T")[0];
    const dailyStats = await storage.getDailyVisitorStatsRange(startDateStr, endDateStr);
    const statsMap = /* @__PURE__ */ new Map();
    dailyStats.forEach((stat) => {
      statsMap.set(stat.date, stat);
    });
    const filledStats = [];
    for (let d = new Date(startDate); d <= endDate; d.setDate(d.getDate() + 1)) {
      const dateStr = d.toISOString().split("T")[0];
      const stat = statsMap.get(dateStr);
      filledStats.push({
        date: dateStr,
        uniqueVisitors: stat?.uniqueVisitors || 0,
        totalPageViews: stat?.totalPageViews || 0,
        countries: stat?.countries || {},
        topPages: stat?.topPages || {}
      });
    }
    const today = endDateStr;
    const weekAgo = /* @__PURE__ */ new Date();
    weekAgo.setDate(weekAgo.getDate() - 7);
    const weekAgoStr = weekAgo.toISOString().split("T")[0];
    const todayStats = statsMap.get(today);
    const weekStats = dailyStats.filter((stat) => stat.date >= weekAgoStr);
    const totalToday = todayStats?.uniqueVisitors || 0;
    const totalThisWeek = weekStats.reduce((sum, stat) => sum + stat.uniqueVisitors, 0);
    res.json({
      dailyStats: filledStats,
      totalToday,
      totalThisWeek,
      dateRange: {
        start: startDateStr,
        end: endDateStr
      }
    });
  } catch (error) {
    console.error("Admin visitor stats error:", error);
    res.status(500).json({ error: "Internal server error" });
  }
});
router.get("/api/admin/visitor-locations", devBypass("analyst"), requireAnalystOrAbove, async (req, res) => {
  try {
    logAuditEvent({
      adminUserId: req.user.uid,
      adminRole: req.user.role,
      action: "VIEW_VISITOR_LOCATIONS",
      details: "Accessed visitor location data for world map"
    });
    const recentSessions = await storage.getRecentVisitorSessions(30, 1e3);
    const locationMap = /* @__PURE__ */ new Map();
    recentSessions.forEach((session) => {
      if (session.latitude && session.longitude && session.country) {
        const key = `${session.latitude},${session.longitude}`;
        if (locationMap.has(key)) {
          const existing = locationMap.get(key);
          existing.count += session.pageViews;
          existing.sessions += 1;
        } else {
          locationMap.set(key, {
            latitude: parseFloat(session.latitude),
            longitude: parseFloat(session.longitude),
            country: session.country,
            countryCode: session.countryCode,
            city: session.city,
            count: session.pageViews,
            sessions: 1
          });
        }
      }
    });
    const locations = Array.from(locationMap.values()).filter((loc) => loc.latitude && loc.longitude).sort((a, b) => b.count - a.count).slice(0, 500);
    const countryStats = /* @__PURE__ */ new Map();
    recentSessions.forEach((session) => {
      if (session.countryCode && session.country) {
        const existing = countryStats.get(session.countryCode) || {
          country: session.country,
          countryCode: session.countryCode,
          visitors: 0,
          pageViews: 0
        };
        existing.visitors += 1;
        existing.pageViews += session.pageViews;
        countryStats.set(session.countryCode, existing);
      }
    });
    const countries = Array.from(countryStats.values()).sort((a, b) => b.visitors - a.visitors).slice(0, 50);
    res.json({
      locations,
      countries,
      summary: {
        totalLocations: locations.length,
        totalCountries: countries.length,
        totalSessions: recentSessions.length,
        dateRange: {
          days: 30,
          description: "Last 30 days"
        }
      }
    });
  } catch (error) {
    console.error("Admin visitor locations error:", error);
    res.status(500).json({ error: "Internal server error" });
  }
});
router.post("/api/admin/users/:userId/role", devBypass("owner"), requireOwner, async (req, res) => {
  try {
    const { userId } = req.params;
    const { role } = req.body;
    if (!role || !["owner", "management", "staff", "analyst", "user", "pro"].includes(role)) {
      return res.status(400).json({ error: "Invalid role" });
    }
    const user = await storage.getUser(userId);
    if (!user) {
      return res.status(404).json({ error: "User not found" });
    }
    const firebaseUid = user.firebaseUid;
    if (req.user.uid === firebaseUid && req.user.role === "owner" && role !== "owner") {
      return res.status(400).json({ error: "Cannot demote yourself from owner role" });
    }
    const oldRole = await getUserRole(firebaseUid);
    await setUserRole(firebaseUid, role, req.user.uid);
    logAuditEvent({
      adminUserId: req.user.uid,
      adminRole: req.user.role,
      action: "CHANGE_USER_ROLE",
      targetUserId: firebaseUid,
      oldValue: oldRole,
      newValue: role,
      details: `Role changed from ${oldRole || "none"} to ${role} for user ${user.email}`
    });
    res.json({ success: true, userId, newRole: role, oldRole });
  } catch (error) {
    console.error("Admin set role error:", error);
    const errorMessage = error.message || error.toString();
    res.status(error.message === "insufficient_role" ? 403 : 500).json({
      error: error.message === "insufficient_role" ? "Insufficient permissions" : errorMessage
    });
  }
});
router.get("/api/admin/users/:userId/role", devBypass("management"), requireManagementOrAbove, async (req, res) => {
  try {
    const { userId } = req.params;
    const user = await storage.getUser(userId);
    if (!user) {
      return res.status(404).json({ error: "User not found" });
    }
    const role = await getUserRole(user.firebaseUid);
    console.log(`\u{1F50D} Role lookup: ${userId} (${user.firebaseUid}) -> ${role || "none"} (by ${req.user.uid})`);
    res.json({ userId, role });
  } catch (error) {
    console.error("Admin get role error:", error);
    res.status(500).json({ error: "Internal server error" });
  }
});
router.get("/api/admin/audit", devBypass("management"), requireManagementOrAbove, async (req, res) => {
  try {
    const { limit = 50, userId } = req.query;
    logAuditEvent({
      adminUserId: req.user.uid,
      adminRole: req.user.role,
      action: "VIEW_AUDIT_LOG",
      details: userId ? `Viewed audit log for user ${userId}` : "Viewed general audit log"
    });
    const auditEvents = userId ? getAuditEventsForUser(userId, parseInt(limit)) : getRecentAuditEvents(parseInt(limit));
    res.json({
      auditEvents,
      total: auditEvents.length,
      requestedBy: req.user.uid,
      requestedAt: (/* @__PURE__ */ new Date()).toISOString()
    });
  } catch (error) {
    console.error("Admin audit error:", error);
    res.status(500).json({ error: "Internal server error" });
  }
});
router.get("/api/admin/test/role-system", devBypass("analyst"), requireAnalystOrAbove, async (req, res) => {
  try {
    logAuditEvent({
      adminUserId: req.user.uid,
      adminRole: req.user.role,
      action: "TEST_ROLE_SYSTEM",
      details: "Tested role-based authentication system"
    });
    res.json({
      success: true,
      message: "Role-based authentication system is working",
      adminUser: {
        uid: req.user.uid,
        role: req.user.role,
        email: req.user.email
      },
      systemInfo: {
        roleHierarchy: {
          owner: 4,
          management: 3,
          staff: 2,
          analyst: 1,
          pro: 0,
          user: 0
        },
        adminRoles: ["owner", "management", "staff", "analyst"],
        backwardCompatibility: "Supports legacy admin=true tokens as owner role"
      },
      timestamp: (/* @__PURE__ */ new Date()).toISOString()
    });
  } catch (error) {
    console.error("Role system test error:", error);
    res.status(500).json({ error: "Internal server error" });
  }
});
router.get("/api/admin/metrics", devBypass("owner"), requireOwner, async (req, res) => {
  try {
    logAuditEvent({
      adminUserId: req.user.uid,
      adminRole: req.user.role,
      action: "VIEW_ADMIN_METRICS",
      details: "Accessed owner KPI dashboard metrics"
    });
    const { neon: neon2 } = await import("@neondatabase/serverless");
    const sql3 = neon2(process.env.DATABASE_URL);
    const freeUsersResult = await sql3`SELECT COUNT(*) as count FROM users WHERE is_paid = false OR is_paid IS NULL`;
    const proUsersResult = await sql3`SELECT COUNT(*) as count FROM users WHERE is_paid = true`;
    const freeUsers = parseInt(freeUsersResult[0].count);
    const proUsers = parseInt(proUsersResult[0].count);
    const pausedUsersResult = await sql3`SELECT COUNT(*) as count FROM users WHERE subscription_status = 'paused'`;
    const pausedUsers = parseInt(pausedUsersResult[0].count);
    const startMonth = startOfMonth();
    const newProResult = await sql3`SELECT COUNT(*) as count FROM users WHERE is_paid = true AND pro_activated_at >= ${startMonth.toISOString()}`;
    const newProThisMonth = parseInt(newProResult[0].count);
    let mtdRevenue = 0;
    let ytdRevenue = 0;
    let churnThisMonthCount = 0;
    let activeSubs = proUsers;
    let stripeConfigured = false;
    try {
      const stripeClient = getStripe();
      if (stripeClient) {
        stripeConfigured = true;
        const mtdInvoices = await stripeClient.invoices.list({
          status: "paid",
          created: { gte: Math.floor(startOfMonth().getTime() / 1e3) },
          limit: 100
        });
        mtdRevenue = mtdInvoices.data.reduce((sum, inv) => sum + (inv.total || 0), 0) / 100;
        const ytdInvoices = await stripeClient.invoices.list({
          status: "paid",
          created: { gte: Math.floor(startOfYear().getTime() / 1e3) },
          limit: 100
        });
        ytdRevenue = ytdInvoices.data.reduce((sum, inv) => sum + (inv.total || 0), 0) / 100;
        const activeSubscriptions = await stripeClient.subscriptions.list({
          status: "active",
          limit: 100
        });
        const pausedSubscriptions = await stripeClient.subscriptions.list({
          status: "paused",
          limit: 100
        });
        activeSubs = activeSubscriptions.data.length + pausedSubscriptions.data.length;
        const canceledSubs = await stripeClient.subscriptions.list({
          status: "canceled",
          created: { gte: Math.floor(startOfMonth().getTime() / 1e3) },
          limit: 100
        });
        churnThisMonthCount = canceledSubs.data.length;
      } else {
        console.warn("Stripe not configured - revenue metrics will show zeros");
      }
    } catch (stripeError) {
      console.warn("Stripe API error (falling back to database counts):", stripeError);
      stripeConfigured = false;
    }
    const churnThisMonthRate = proUsers > 0 ? Number((churnThisMonthCount / proUsers * 100).toFixed(1)) : 0;
    const totalUsers = freeUsers + proUsers;
    const conversionRate = totalUsers > 0 ? Number((newProThisMonth / totalUsers * 100).toFixed(1)) : 0;
    let unsatisfiedPct = 0;
    try {
      const allCancellations = await storage.getAllCancellations();
      const thisMonthCancellations = allCancellations.filter(
        (c) => c.createdAt && new Date(c.createdAt) >= startOfMonth()
      );
      if (thisMonthCancellations.length > 0) {
        const unsatisfiedCancellations = thisMonthCancellations.filter(
          (c) => c.reason === CANCELLATION_REASONS.DIDNT_GET_VALUE
        );
        unsatisfiedPct = Number((unsatisfiedCancellations.length / thisMonthCancellations.length * 100).toFixed(1));
      }
    } catch (error) {
      console.warn("Failed to calculate unsatisfied percentage:", error);
      unsatisfiedPct = 0;
    }
    let recentPauses = [];
    try {
      recentPauses = await storage.getRecentPauses(10);
    } catch (error) {
      console.warn("Failed to fetch recent pauses:", error);
    }
    const metrics = {
      mtdRevenue,
      ytdRevenue,
      activePro: proUsers,
      churnThisMonthCount,
      churnThisMonthRate,
      newProThisMonth,
      freeUsers,
      proUsers,
      pausedUsers,
      // New: count of paused users
      activeSubs,
      unsatisfiedPct,
      conversionRate,
      // Free to Pro conversion this month
      totalUsers,
      recentPauses,
      // New: recent pauses for owner dashboard
      stripeConfigured
      // Flag to indicate if Stripe data is reliable
    };
    console.log("\u2705 Owner KPI metrics:", metrics);
    res.json(metrics);
  } catch (error) {
    console.error("Admin metrics error:", error);
    res.status(500).json({
      error: "metrics_failed",
      message: error instanceof Error ? error.message : "Failed to fetch admin metrics"
    });
  }
});
var routes_default = router;

// server/routes/icons.ts
import { Router as Router3 } from "express";

// server/util/sanitize.ts
function sanitizeSvg(input) {
  let s = input.trim();
  if (!s || !s.includes("<svg") && !s.includes("<?xml")) {
    console.warn("[sanitizeSvg] Input does not contain valid SVG content");
    return s;
  }
  s = s.replace(/<\?xml[^>]*>/gi, "");
  s = s.replace(/<!DOCTYPE[^>]*>/gi, "");
  s = s.replace(/<script[\s\S]*?<\/script>/gi, "");
  s = s.replace(/<foreignObject[\s\S]*?<\/foreignObject>/gi, "");
  s = s.replace(/<iframe[\s\S]*?<\/iframe>/gi, "");
  s = s.replace(/<object[\s\S]*?<\/object>/gi, "");
  s = s.replace(/<embed[\s\S]*?<\/embed>/gi, "");
  s = s.replace(/<link[\s\S]*?>/gi, "");
  s = s.replace(/\son[a-z]+\s*=\s*"[^"]*"/gi, "");
  s = s.replace(/\son[a-z]+\s*=\s*'[^']*'/gi, "");
  s = s.replace(/\son[a-z]+\s*=\s*[^\s>"']+/gi, "");
  s = s.replace(/\s(xlink:)?href\s*=\s*"https?:[^"]*"/gi, "");
  s = s.replace(/\s(xlink:)?href\s*=\s*'https?:[^']*'/gi, "");
  s = s.replace(/\s(xlink:)?href\s*=\s*"javascript:[^"]*"/gi, "");
  s = s.replace(/\s(xlink:)?href\s*=\s*'javascript:[^']*'/gi, "");
  s = s.replace(/\s(xlink:)?href\s*=\s*"data:[^"]*"/gi, "");
  s = s.replace(/\s(xlink:)?href\s*=\s*'data:[^']*'/gi, "");
  s = s.replace(/\s(xlink:)?href\s*=\s*"vbscript:[^"]*"/gi, "");
  s = s.replace(/\s(xlink:)?href\s*=\s*'vbscript:[^']*'/gi, "");
  s = s.replace(/\sstyle\s*=\s*"[^"]*"/gi, "");
  s = s.replace(/\sstyle\s*=\s*'[^']*'/gi, "");
  s = s.replace(/<style[\s\S]*?<\/style>/gi, "");
  s = s.replace(/\swidth\s*=\s*"[^"]*"/gi, "");
  s = s.replace(/\sheight\s*=\s*"[^"]*"/gi, "");
  s = s.replace(/\swidth\s*=\s*'[^']*'/gi, "");
  s = s.replace(/\sheight\s*=\s*'[^']*'/gi, "");
  if (s && !s.startsWith("<svg") && s.includes("<svg")) {
    const svgMatch = s.match(/<svg[\s\S]*?<\/svg>/i);
    if (svgMatch) {
      s = svgMatch[0];
    }
  }
  if (s.includes("<svg") && !/viewBox\s*=/i.test(s)) {
    const widthMatch = s.match(/width\s*=\s*["']?([\d.]+)/i);
    const heightMatch = s.match(/height\s*=\s*["']?([\d.]+)/i);
    let viewBox = "0 0 24 24";
    if (widthMatch && heightMatch) {
      viewBox = `0 0 ${widthMatch[1]} ${heightMatch[1]}`;
    }
    s = s.replace(
      /<svg([^>]*)>/i,
      (match, attrs) => {
        if (!/viewBox/i.test(attrs)) {
          return `<svg${attrs} viewBox="${viewBox}">`;
        }
        return match;
      }
    );
  }
  s = s.replace(/fill\s*=\s*"(#[0-9a-fA-F]{3,6}|rgb\([^)]*\)|[a-zA-Z]+)"/gi, 'fill="currentColor"');
  s = s.replace(/stroke\s*=\s*"(#[0-9a-fA-F]{3,6}|rgb\([^)]*\)|[a-zA-Z]+)"/gi, 'stroke="currentColor"');
  s = s.replace(/fill\s*=\s*'(#[0-9a-fA-F]{3,6}|rgb\([^)]*\)|[a-zA-Z]+)'/gi, 'fill="currentColor"');
  s = s.replace(/stroke\s*=\s*'(#[0-9a-fA-F]{3,6}|rgb\([^)]*\)|[a-zA-Z]+)'/gi, 'stroke="currentColor"');
  s = s.replace(/fill="currentColor"/gi, (match, offset) => {
    const before = s.substring(Math.max(0, offset - 20), offset);
    if (before.includes('fill="none"') || before.includes("fill='none'")) {
      return 'fill="none"';
    }
    return match;
  });
  s = s.replace(/stroke="currentColor"/gi, (match, offset) => {
    const before = s.substring(Math.max(0, offset - 20), offset);
    if (before.includes('stroke="none"') || before.includes("stroke='none'")) {
      return 'stroke="none"';
    }
    return match;
  });
  const finalResult = s.trim();
  if (!finalResult.startsWith("<svg")) {
    console.warn("[sanitizeSvg] Result does not start with <svg> tag");
    return "";
  }
  if (!finalResult.includes("</svg>")) {
    console.warn("[sanitizeSvg] Result does not have closing </svg> tag");
    return "";
  }
  return finalResult;
}
function shouldInlineSvg(svgContent) {
  return svgContent.length < 2048;
}
function extractIconId(path13) {
  const parts = path13.split("/");
  const filename = parts[parts.length - 1];
  return filename.replace(/\.(png|svg)$/i, "");
}

// server/util/svg-gen.ts
function generateSvgFromPrompt(prompt, style) {
  const p = prompt.toLowerCase();
  const shape = p.includes("rocket") ? "rocket" : p.includes("star") ? "star" : p.includes("chart") || p.includes("bar") ? "barchart" : p.includes("heart") ? "heart" : p.includes("user") || p.includes("person") || p.includes("profile") ? "user" : p.includes("home") || p.includes("house") ? "home" : p.includes("folder") ? "folder" : p.includes("shield") ? "shield" : p.includes("link") ? "link" : "circle";
  const cfg = styleToConfig(style);
  const inner = iconFor(shape, cfg);
  return `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"${cfg.svgAttrs}>${inner}</svg>`;
}
function styleToConfig(style) {
  switch (style) {
    case "solid":
      return {
        svgAttrs: ` fill="currentColor"`,
        stroke: `none`,
        fill: `currentColor`,
        strokeWidth: 0,
        rounded: false
      };
    case "flat":
      return {
        svgAttrs: ` fill="currentColor"`,
        stroke: `none`,
        fill: `currentColor`,
        strokeWidth: 0,
        rounded: false
      };
    case "handdrawn":
      return {
        svgAttrs: ``,
        stroke: `currentColor`,
        fill: `none`,
        strokeWidth: 2,
        rounded: true,
        dash: "2 2"
      };
    case "isometric":
      return {
        svgAttrs: ``,
        stroke: `currentColor`,
        fill: `none`,
        strokeWidth: 2,
        rounded: false
      };
    case "material":
      return {
        svgAttrs: ` fill="currentColor"`,
        stroke: `none`,
        fill: `currentColor`,
        strokeWidth: 0,
        rounded: false
      };
    case "classic":
      return {
        svgAttrs: ``,
        stroke: `currentColor`,
        fill: `none`,
        strokeWidth: 2,
        rounded: false
      };
    case "modern":
      return {
        svgAttrs: ``,
        stroke: `currentColor`,
        fill: `none`,
        strokeWidth: 2,
        rounded: true
      };
    case "outlined":
    default:
      return {
        svgAttrs: ``,
        stroke: `currentColor`,
        fill: `none`,
        strokeWidth: 2,
        rounded: false
      };
  }
}
function iconFor(shape, cfg) {
  const capjoin = cfg.rounded ? ` stroke-linecap="round" stroke-linejoin="round"` : ``;
  const dash = cfg.dash ? ` stroke-dasharray="${cfg.dash}"` : ``;
  switch (shape) {
    case "rocket":
      return cfg.fill === "currentColor" ? `<path d="M12 2l4 2c1.5.8 2.5 2.3 2.5 4l-3.5 3.5L10.5 6.5 12 2Z" fill="${cfg.fill}"/><path d="M6 18l2-2m-1 3l1-1" fill="none" stroke="currentColor" stroke-width="${cfg.strokeWidth}"${capjoin}/>` : `<g fill="${cfg.fill}" stroke="${cfg.stroke}" stroke-width="${cfg.strokeWidth}"${capjoin}${dash}>
             <path d="M14 4.1c1.14-.07 2.28.28 3.16 1.16c.88.88 1.23 2.02 1.16 3.16L14.6 12l-4.6-4.6L14 4.1Z"/>
             <path d="M5 19l3-3m-1 4l2-2"/>
             <path d="m8.28 13.72l2 2"/>
             <circle cx="15" cy="9" r="1"/>
           </g>`;
    case "star":
      return cfg.fill === "currentColor" ? `<path d="m12 2 3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77 6 21.02 7 14.14 2 9.27l6.91-1.01z" fill="${cfg.fill}"/>` : `<path d="m12 2 3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77 6 21.02 7 14.14 2 9.27l6.91-1.01z" fill="none" stroke="${cfg.stroke}" stroke-width="${cfg.strokeWidth}"${capjoin}${dash}/>`;
    case "barchart":
      return cfg.fill === "currentColor" ? `<g><rect x="3" y="10" width="3" height="10" rx="1" fill="${cfg.fill}"/><rect x="9" y="6" width="3" height="14" rx="1" fill="${cfg.fill}"/><rect x="15" y="3" width="3" height="17" rx="1" fill="${cfg.fill}"/></g>` : `<g fill="none" stroke="${cfg.stroke}" stroke-width="${cfg.strokeWidth}"${capjoin}${dash}><rect x="3" y="10" width="3" height="10" rx="1"/><rect x="9" y="6" width="3" height="14" rx="1"/><rect x="15" y="3" width="3" height="17" rx="1"/></g>`;
    case "heart":
      return `<path d="M12 20s-6-3.3-8.5-6.5C1 10.5 3 6 6.5 6C9 6 10.5 8 12 9.5C13.5 8 15 6 17.5 6C21 6 23 10.5 20.5 13.5C18 16.7 12 20 12 20Z" fill="${cfg.fill}" stroke="${cfg.stroke}" stroke-width="${cfg.strokeWidth}"${capjoin}${dash}/>`;
    case "user":
      return `<g fill="${cfg.fill}" stroke="${cfg.stroke}" stroke-width="${cfg.strokeWidth}"${capjoin}${dash}><circle cx="12" cy="8" r="4"/><path d="M4 20c0-3.314 3.582-6 8-6s8 2.686 8 6"/></g>`;
    case "home":
      return cfg.fill === "currentColor" ? `<path d="M12 3l9 8h-3v9H6v-9H3l9-8z" fill="${cfg.fill}"/>` : `<g fill="none" stroke="${cfg.stroke}" stroke-width="${cfg.strokeWidth}"${capjoin}${dash}><path d="M12 3l9 8H3l9-8z"/><path d="M6 11v9h12v-9"/></g>`;
    case "folder":
      return `<path d="M3 7a2 2 0 0 1 2-2h4l2 2h8a2 2 0 0 1 2 2v7a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z" fill="${cfg.fill}" stroke="${cfg.stroke}" stroke-width="${cfg.strokeWidth}"${capjoin}${dash}/>`;
    case "shield":
      return cfg.fill === "currentColor" ? `<path d="M12 3l7 3v6c0 5-3.5 8.5-7 9c-3.5-.5-7-4-7-9V6l7-3Z" fill="${cfg.fill}"/>` : `<path d="M12 3l7 3v6c0 5-3.5 8.5-7 9c-3.5-.5-7-4-7-9V6l7-3Z" fill="${cfg.fill}" stroke="${cfg.stroke}" stroke-width="${cfg.strokeWidth}"${capjoin}${dash}/>`;
    case "link":
      return `<g fill="${cfg.fill}" stroke="${cfg.stroke}" stroke-width="${cfg.strokeWidth}"${capjoin}${dash}><path d="M10 14a5 5 0 0 1 0-7l1-1a5 5 0 0 1 7 7l-1 1"/><path d="M14 10a5 5 0 0 1 0 7l-1 1a5 5 0 1 1-7-7l1-1"/></g>`;
    case "circle":
    default:
      return cfg.fill === "currentColor" ? `<circle cx="12" cy="12" r="8" fill="${cfg.fill}"/>` : `<circle cx="12" cy="12" r="8" fill="${cfg.fill}" stroke="${cfg.stroke}" stroke-width="${cfg.strokeWidth}"${capjoin}${dash}/>`;
  }
}

// server/routes/icons.ts
import { z as z3 } from "zod";

// server/routes/icons/import-individual-files.ts
import { Router as Router2 } from "express";
import multer from "multer";
import sharp from "sharp";
import { Potrace } from "potrace";
import { z as z2 } from "zod";
import pLimit from "p-limit";
function validateFileFormat(buffer, mimetype, filename) {
  if (buffer.length < 8) return false;
  const signature = buffer.subarray(0, 8);
  switch (mimetype) {
    case "image/png":
      return signature[0] === 137 && signature[1] === 80 && signature[2] === 78 && signature[3] === 71;
    case "image/jpeg":
    case "image/jpg":
      return signature[0] === 255 && signature[1] === 216 && signature[2] === 255;
    case "image/svg+xml":
      const content = buffer.toString("utf-8", 0, Math.min(100, buffer.length));
      return content.includes("<svg") || content.includes("<?xml");
    default:
      return false;
  }
}
var upload = multer({
  storage: multer.memoryStorage(),
  limits: {
    fileSize: 10 * 1024 * 1024,
    // 10MB per file
    files: 20
    // Max 20 files
  },
  fileFilter: (req, file2, cb) => {
    const allowedTypes = ["image/png", "image/jpg", "image/jpeg", "image/svg+xml"];
    if (!allowedTypes.includes(file2.mimetype)) {
      return cb(new Error(`File ${file2.originalname}: Only PNG, JPG, JPEG, and SVG files are allowed`));
    }
    const allowedExtensions = [".png", ".jpg", ".jpeg", ".svg"];
    const fileExtension = file2.originalname.toLowerCase().match(/\.[^.]+$/)?.[0];
    if (!fileExtension || !allowedExtensions.includes(fileExtension)) {
      return cb(new Error(`File ${file2.originalname}: Invalid file extension`));
    }
    cb(null, true);
  }
});
var importIndividualFilesSchema = z2.object({
  threshold: z2.coerce.number().int().min(0).max(255).default(180),
  invert: z2.coerce.boolean().default(false)
});
var router2 = Router2();
router2.post("/", upload.array("files", 20), async (req, res) => {
  try {
    const files = req.files;
    if (!files || files.length === 0) {
      return res.status(400).json({ error: "No files uploaded" });
    }
    if (files.length > 20) {
      return res.status(400).json({ error: "Maximum 20 files allowed" });
    }
    for (const file2 of files) {
      if (!validateFileFormat(file2.buffer, file2.mimetype, file2.originalname)) {
        return res.status(400).json({
          error: `Invalid file format for ${file2.originalname}: file signature doesn't match MIME type`
        });
      }
    }
    const validatedParams = importIndividualFilesSchema.parse(req.body);
    const { threshold, invert } = validatedParams;
    const limit = pLimit(4);
    async function convertImageToSvg(buffer, filename) {
      return new Promise((resolve, reject) => {
        const startTime = Date.now();
        const timeout = setTimeout(() => {
          reject(new Error(`Timeout processing ${filename}: operation took too long`));
        }, 45e3);
        const sharpImage = sharp(buffer);
        sharpImage.metadata((metaErr, metadata) => {
          if (metaErr) {
            clearTimeout(timeout);
            return reject(new Error(`Failed to read image metadata for ${filename}: ${metaErr.message}`));
          }
          const originalWidth = metadata.width || 256;
          const originalHeight = metadata.height || 256;
          const resizeWidth = Math.min(originalWidth, 256);
          const resizeHeight = Math.min(originalHeight, 256);
          console.log(`[icons/import-individual-files] Processing ${filename}: ${originalWidth}x${originalHeight} -> ${resizeWidth}x${resizeHeight}`);
          let imageProcessor = sharp(buffer).grayscale().threshold(threshold);
          if (invert) {
            imageProcessor = imageProcessor.negate();
          }
          imageProcessor = imageProcessor.resize({
            width: resizeWidth,
            height: resizeHeight,
            fit: "inside"
          });
          const sharpStartTime = Date.now();
          imageProcessor.toBuffer((sharpErr, processedBuffer) => {
            const sharpProcessingTime = Date.now() - sharpStartTime;
            if (sharpErr) {
              clearTimeout(timeout);
              return reject(new Error(`Sharp processing failed for ${filename}: ${sharpErr.message}`));
            }
            console.log(`[icons/import-individual-files] Sharp processing for ${filename} completed in ${sharpProcessingTime}ms`);
            const potrace = new Potrace({
              threshold,
              turdSize: 2,
              turnPolicy: Potrace.TURNPOLICY_MINORITY,
              color: "#000000",
              background: "#FFFFFF"
            });
            const potraceStartTime = Date.now();
            potrace.loadImage(processedBuffer, (loadErr) => {
              if (loadErr) {
                clearTimeout(timeout);
                return reject(new Error(`Potrace loading failed for ${filename}: ${loadErr.message}`));
              }
              potrace.getSVG((svgErr, svg) => {
                clearTimeout(timeout);
                const potraceProcessingTime = Date.now() - potraceStartTime;
                const totalProcessingTime = Date.now() - startTime;
                if (svgErr) {
                  return reject(new Error(`SVG generation failed for ${filename}: ${svgErr.message}`));
                }
                console.log(`[icons/import-individual-files] Potrace processing for ${filename} completed in ${potraceProcessingTime}ms`);
                console.log(`[icons/import-individual-files] Total processing time for ${filename}: ${totalProcessingTime}ms`);
                resolve(svg);
              });
            });
          });
        });
      });
    }
    const processedIcons = [];
    const processingTasks = files.map((file2, i) => {
      const id = `file-${i}`;
      return limit(async () => {
        try {
          let svg;
          if (file2.mimetype === "image/svg+xml") {
            const svgContent = file2.buffer.toString("utf-8");
            console.log(`[icons/import-individual-files] Original SVG content for ${file2.originalname} (first 200 chars):`, svgContent.substring(0, 200));
            svg = sanitizeSvg(svgContent);
            console.log(`[icons/import-individual-files] Sanitized SVG content for ${file2.originalname} (first 200 chars):`, svg.substring(0, 200));
            console.log(`[icons/import-individual-files] SVG starts with '<svg':`, svg.startsWith("<svg"));
            if (!svg.trim().startsWith("<svg")) {
              console.error(`[icons/import-individual-files] Invalid SVG content for ${file2.originalname}. Content after sanitization:`, svg.substring(0, 500));
              throw new Error("Invalid SVG content after sanitization");
            }
          } else {
            svg = await convertImageToSvg(file2.buffer, file2.originalname);
            svg = sanitizeSvg(svg);
            if (!svg.startsWith("<svg")) {
              throw new Error("Invalid SVG generated after conversion and sanitization");
            }
          }
          return {
            id,
            svg,
            filename: file2.originalname
          };
        } catch (fileError) {
          console.error(`[icons/import-individual-files] Error processing file ${file2.originalname}:`, fileError);
          return {
            id,
            svg: "",
            filename: file2.originalname,
            error: `Failed to process ${file2.originalname}: ${fileError.message}`
          };
        }
      });
    });
    const processingPromise = Promise.all(processingTasks);
    const timeoutPromise = new Promise((_, reject) => {
      setTimeout(() => reject(new Error("Processing timeout: batch operation took too long")), 18e4);
    });
    const results = await Promise.race([processingPromise, timeoutPromise]);
    processedIcons.push(...results);
    const successfulIcons = processedIcons.filter((icon) => !icon.error);
    const failedIcons = processedIcons.filter((icon) => icon.error);
    res.json({
      icons: successfulIcons,
      successful: successfulIcons.length,
      failed: failedIcons.length,
      errors: failedIcons.length > 0 ? failedIcons.map((icon) => ({ filename: icon.filename, error: icon.error })) : void 0
    });
  } catch (e) {
    console.error("[icons/import-individual-files]", e);
    if (e instanceof z2.ZodError) {
      return res.status(400).json({
        error: "Invalid parameters",
        details: e.errors
      });
    }
    res.status(500).json({ error: "Failed to process individual files" });
  }
});
var import_individual_files_default = router2;

// server/routes/icons.ts
init_storage();
init_adminGuard();
init_objectStorage();
import { randomUUID as randomUUID2 } from "crypto";
import sharp2 from "sharp";
var router3 = Router3();
var objectStorageService = new ObjectStorageService();
async function generatePreviewFromSvg(svgContent, size = 256) {
  try {
    const pngBuffer = await sharp2(Buffer.from(svgContent)).resize(size, size, {
      fit: "inside",
      background: { r: 255, g: 255, b: 255, alpha: 0 }
      // transparent background
    }).png().toBuffer();
    return pngBuffer;
  } catch (error) {
    console.error("Error generating preview from SVG:", error);
    throw new Error("Failed to generate preview image");
  }
}
var generateIconSchema = z3.object({
  prompt: z3.string().min(2, "Prompt must be at least 2 characters").max(120, "Prompt must not exceed 120 characters").transform((s) => s.trim()),
  style: z3.enum([
    "modern",
    "classic",
    "flat",
    "outlined",
    "solid",
    "handdrawn",
    "isometric",
    "material"
  ]).optional().default("outlined")
});
router3.post("/generate", async (req, res) => {
  try {
    const validatedInput = generateIconSchema.parse(req.body);
    const { prompt, style } = validatedInput;
    const rawSvg = generateSvgFromPrompt(prompt, style);
    const svg = sanitizeSvg(rawSvg);
    if (!svg.startsWith("<svg") || svg.length > 32e3) {
      return res.status(422).json({ error: "Invalid SVG generated." });
    }
    return res.json({ svg });
  } catch (e) {
    console.error("[/icons/generate] error", e);
    if (e instanceof z3.ZodError) {
      return res.status(400).json({
        error: "Validation failed",
        details: e.errors
      });
    }
    return res.status(500).json({ error: "Failed to generate icon." });
  }
});
var saveImportedIconsSchema = z3.object({
  icons: z3.array(z3.object({
    name: z3.string().min(1).trim(),
    svg: z3.string().min(1),
    style: z3.enum(["modern", "classic", "flat", "outlined", "solid", "handdrawn", "isometric", "material"]).default("flat"),
    tags: z3.array(z3.string()).default([])
  })).min(1, "At least one icon is required")
});
router3.post("/save-imported", requireAdmin, async (req, res) => {
  try {
    const validatedInput = saveImportedIconsSchema.parse(req.body);
    const { icons } = validatedInput;
    const adminUserId = req.user?.uid;
    if (!adminUserId) {
      return res.status(401).json({ error: "Admin authentication required" });
    }
    const savedIconsInfo = [];
    const errors = [];
    for (const icon of icons) {
      try {
        const iconId = randomUUID2();
        const cleanSvg = sanitizeSvg(icon.svg);
        if (!cleanSvg || !cleanSvg.startsWith("<svg")) {
          errors.push({ name: icon.name, error: "Invalid SVG content" });
          continue;
        }
        const sanitizedName = icon.name.replace(/[^a-zA-Z0-9-_]/g, "_");
        const svgFileName = `${sanitizedName}.svg`;
        const pngFileName = `${sanitizedName}.png`;
        const publicPaths = objectStorageService.getPublicObjectSearchPaths();
        const basePath = publicPaths[0];
        const svgPath = `${basePath}/icons/svg/${iconId}/${svgFileName}`;
        const previewPath = `${basePath}/icons/preview/${iconId}/${pngFileName}`;
        await objectStorageService.uploadFile(
          svgPath,
          Buffer.from(cleanSvg, "utf-8"),
          "image/svg+xml"
        );
        const previewBuffer = await generatePreviewFromSvg(cleanSvg, 256);
        await objectStorageService.uploadFile(
          previewPath,
          previewBuffer,
          "image/png"
        );
        savedIconsInfo.push({
          id: iconId,
          name: icon.name,
          svgPath: `icons/svg/${iconId}/${svgFileName}`,
          previewPath: `icons/preview/${iconId}/${pngFileName}`,
          style: icon.style,
          tags: icon.tags
        });
      } catch (iconError) {
        console.error(`Error saving icon "${icon.name}":`, iconError);
        errors.push({
          name: icon.name,
          error: iconError.message || "Failed to save icon"
        });
      }
    }
    const response = {
      success: true,
      count: savedIconsInfo.length,
      saved: savedIconsInfo.length,
      icons: savedIconsInfo
    };
    if (errors.length > 0) {
      response.errors = errors;
      response.failed = errors.length;
    }
    return res.json(response);
  } catch (e) {
    console.error("[/icons/save-imported] error", e);
    if (e instanceof z3.ZodError) {
      return res.status(400).json({
        error: "Validation failed",
        details: e.errors
      });
    }
    return res.status(500).json({ error: "Failed to save icons to object storage" });
  }
});
router3.get("/imported", async (req, res) => {
  try {
    const { style, search } = req.query;
    let icons;
    if (search && typeof search === "string") {
      icons = await storage.searchImportedIcons(search);
    } else if (style && typeof style === "string") {
      icons = await storage.getImportedIconsByStyle(style);
    } else {
      icons = await storage.getAllImportedIcons();
    }
    return res.json({ icons });
  } catch (e) {
    console.error("[/icons/imported] error", e);
    return res.status(500).json({ error: "Failed to fetch imported icons" });
  }
});
router3.delete("/imported/:id", requireAdmin, async (req, res) => {
  try {
    const { id } = req.params;
    if (!id) {
      return res.status(400).json({ error: "Icon ID is required" });
    }
    const deleted = await storage.deleteImportedIcon(id);
    if (!deleted) {
      return res.status(404).json({ error: "Icon not found or already deleted" });
    }
    return res.json({ success: true, message: "Icon deleted successfully" });
  } catch (e) {
    console.error("[/icons/imported/:id] error", e);
    return res.status(500).json({ error: "Failed to delete imported icon" });
  }
});
router3.use("/import-individual-files", requireAdmin, import_individual_files_default);
var icons_default = router3;

// server/routes/iconLibraryRoutes.js
init_objectStorage();
init_entitlements();
import express from "express";
import archiver from "archiver";
import fs2 from "fs/promises";
import path2 from "path";

// server/services/iconEntitlements.ts
init_storage();
async function userHasIconsNoAttribution(userId) {
  if (!userId) {
    return false;
  }
  try {
    return await storage.hasEntitlement(userId, "icons_no_attribution", "global");
  } catch (error) {
    console.error(`\u274C Error checking icons no-attribution for user ${userId}:`, error);
    return false;
  }
}
async function userOwnsIcon(userId, iconId) {
  if (!userId || !iconId) {
    return false;
  }
  try {
    const hasGlobalLicense = await userHasIconsNoAttribution(userId);
    if (hasGlobalLicense) {
      return true;
    }
    return false;
  } catch (error) {
    console.error(`\u274C Error checking icon ownership for user ${userId}, icon ${iconId}:`, error);
    return false;
  }
}

// server/routes/iconLibraryRoutes.js
init_adminGuard();
var router4 = express.Router();
var objectStorageService2 = new ObjectStorageService();
function guessType(filename) {
  const ext = path2.extname(filename).toLowerCase();
  const mimeTypes = {
    ".png": "image/png",
    ".jpg": "image/jpeg",
    ".jpeg": "image/jpeg",
    ".gif": "image/gif",
    ".svg": "image/svg+xml",
    ".webp": "image/webp"
  };
  return mimeTypes[ext] || "application/octet-stream";
}
router4.get("/list", async (req, res) => {
  try {
    const files = await objectStorageService2.listPrefix("icons/preview/");
    const processedIcons = /* @__PURE__ */ new Map();
    await Promise.all(files.map(async (f) => {
      try {
        const baseName = extractIconId(f.key);
        const id = baseName;
        const name = baseName.replace(/[_-]/g, " ").replace(/\b\w/g, (l) => l.toUpperCase());
        if (processedIcons.has(baseName)) {
          return;
        }
        let svgContent = null;
        let svgUrl = null;
        try {
          const pathParts = f.key.split("/");
          let svgKey = null;
          let rawSvgContent = null;
          if (pathParts.length >= 3) {
            const uuid = pathParts[pathParts.length - 2];
            const iconFileName = pathParts[pathParts.length - 1].replace(".png", ".svg");
            svgKey = `icons/svg/${uuid}/${iconFileName}`;
            try {
              const svgStream = await objectStorageService2.getStream(svgKey);
              const chunks = [];
              for await (const chunk of svgStream) {
                chunks.push(chunk);
              }
              rawSvgContent = Buffer.concat(chunks).toString("utf8");
            } catch (uuidError) {
              try {
                const allSvgFiles = await objectStorageService2.listPrefix(`icons/svg/`);
                const matchingFile = allSvgFiles.find(
                  (file2) => file2.key.includes(baseName) && file2.key.endsWith(".svg")
                );
                if (matchingFile) {
                  svgKey = matchingFile.key;
                  const svgStream = await objectStorageService2.getStream(svgKey);
                  const chunks = [];
                  for await (const chunk of svgStream) {
                    chunks.push(chunk);
                  }
                  rawSvgContent = Buffer.concat(chunks).toString("utf8");
                }
              } catch (fallbackError) {
                console.warn(`No SVG found for icon ${baseName} using any method`);
              }
            }
          }
          if (rawSvgContent) {
            const sanitizedSvg = sanitizeSvg(rawSvgContent);
            if (sanitizedSvg) {
              if (shouldInlineSvg(sanitizedSvg)) {
                svgContent = sanitizedSvg;
              } else {
                svgUrl = `/api/icons/${id}/svg`;
              }
            }
          }
        } catch (svgError) {
          console.warn(`Could not fetch SVG content for icon ${baseName}:`, svgError.message);
        }
        const iconData = {
          id,
          name,
          style: "outlined",
          tags: [],
          previewUrl: objectStorageService2.publicUrlFromKey(f.key),
          formats: ["svg", "png"],
          createdAt: Date.now(),
          // SuperNova's data structure: svg field for small files, svgUrl for large ones
          ...svgContent ? { svg: svgContent } : {},
          ...svgUrl ? { svgUrl } : {}
        };
        processedIcons.set(baseName, iconData);
      } catch (itemError) {
        console.warn(`Error processing icon file ${f.key}:`, itemError.message);
      }
    }));
    const items = Array.from(processedIcons.values());
    const visibleIcons = items.filter((x) => !hiddenIcons.has(x.id));
    const userId = req.user?.id || null;
    if (userId) {
      const hasGlobalLicense = await userHasIconsNoAttribution(userId);
      visibleIcons.forEach((icon) => {
        const licensed = hasGlobalLicense;
        icon.entitlement = {
          licensed,
          requiresAttribution: !licensed,
          canDownload: true
        };
      });
      console.log(`[Icons] Listed ${visibleIcons.length} icons with embedded entitlements for user ${userId}`);
    } else {
      visibleIcons.forEach((icon) => {
        icon.entitlement = {
          licensed: false,
          requiresAttribution: true,
          canDownload: true
        };
      });
      console.log(`[Icons] Listed ${visibleIcons.length} icons for anonymous user`);
    }
    console.log(`[Icons] ${visibleIcons.filter((i) => i.svg).length} with inline SVG, ${visibleIcons.filter((i) => i.svgUrl).length} with SVG URLs`);
    res.json({ icons: visibleIcons });
  } catch (error) {
    console.error("Error listing icons:", error);
    res.json({ icons: [] });
  }
});
router4.get("/:id/entitlement", async (req, res) => {
  try {
    const userId = req.user?.id || null;
    const iconId = req.params.id;
    if (!userId) {
      return res.json({
        licensed: false,
        requiresAttribution: true,
        canDownload: true
      });
    }
    const hasGlobalLicense = await userHasIconsNoAttribution(userId);
    const hasIconLicense = await userOwnsIcon(userId, iconId);
    const licensed = hasGlobalLicense || hasIconLicense;
    const legacyLicense = hasLicense(userId, iconId);
    const finalLicensed = licensed || legacyLicense;
    res.json({
      licensed: finalLicensed,
      requiresAttribution: !finalLicensed,
      canDownload: true
    });
  } catch (error) {
    console.error("Error checking entitlement:", error);
    res.status(500).json({ error: "Failed to check entitlement" });
  }
});
router4.get("/:id/download", async (req, res) => {
  try {
    const id = req.params.id;
    const fmt = (req.query.format || "svg").toString().toLowerCase();
    const base = fmt === "png" ? "icons/png" : "icons/svg";
    const files = await objectStorageService2.listPrefix(`${base}/${id}/`);
    const file2 = files[0];
    if (!file2) {
      return res.status(404).json({ error: "Icon not found" });
    }
    const userId = req.user?.id || null;
    const licensed = userId ? hasLicense(userId, id) || userHasPro(userId) : false;
    if (licensed) {
      const stream = await objectStorageService2.getStream(file2.key);
      res.setHeader("Content-Type", fmt === "png" ? "image/png" : "image/svg+xml");
      res.setHeader("Content-Disposition", `attachment; filename="IBrandBiz_${id}.${fmt}"`);
      return stream.pipe(res);
    }
    const archive = archiver("zip", { zlib: { level: 9 } });
    res.setHeader("Content-Type", "application/zip");
    res.setHeader("Content-Disposition", `attachment; filename="IBrandBiz_${id}_${fmt}_FREE.zip"`);
    const credit = [
      "Thank you for using IBrandBiz Icons!",
      "",
      "License: Free with Attribution",
      'You MUST include visible credit: "Icons by IBrandBiz Icons \u2014 Free with Attribution (https://ibrandbiz.com/icons)"',
      "Full license: https://ibrandbiz.com/license/icons/free",
      "Upgrade to IBrandBiz Pro to remove attribution: https://ibrandbiz.com/pricing",
      ""
    ].join("\n");
    archive.append(credit, { name: "CREDIT.txt" });
    const fileStream = await objectStorageService2.getStream(file2.key);
    archive.append(fileStream, { name: `icon.${fmt}` });
    archive.finalize();
    archive.pipe(res);
  } catch (error) {
    console.error("Error downloading icon:", error);
    res.status(500).json({ error: "Failed to download icon" });
  }
});
router4.get("/:id/svg", async (req, res) => {
  try {
    const id = req.params.id;
    let svgKey = null;
    let rawSvgContent = null;
    try {
      const allSvgFiles = await objectStorageService2.listPrefix(`icons/svg/`);
      const matchingFile = allSvgFiles.find(
        (file2) => file2.key.includes(id) && file2.key.endsWith(".svg")
      );
      if (matchingFile) {
        svgKey = matchingFile.key;
        const svgStream = await objectStorageService2.getStream(svgKey);
        const chunks = [];
        for await (const chunk of svgStream) {
          chunks.push(chunk);
        }
        rawSvgContent = Buffer.concat(chunks).toString("utf8");
      } else {
        return res.status(404).json({ error: "SVG file not found" });
      }
    } catch (error) {
      console.error(`Error finding SVG for icon ${id}:`, error);
      return res.status(404).json({ error: "SVG file not found" });
    }
    if (!rawSvgContent) {
      return res.status(404).json({ error: "SVG content not found" });
    }
    const sanitizedSvg = sanitizeSvg(rawSvgContent);
    if (!sanitizedSvg) {
      return res.status(500).json({ error: "Failed to process SVG content" });
    }
    res.setHeader("Content-Type", "image/svg+xml");
    res.setHeader("Cache-Control", "public, max-age=31536000");
    res.setHeader("Access-Control-Allow-Origin", "*");
    res.send(sanitizedSvg);
  } catch (error) {
    console.error(`Error serving SVG for icon ${req.params.id}:`, error);
    res.status(500).json({ error: "Failed to serve SVG" });
  }
});
router4.get("/:id/preview", async (req, res) => {
  try {
    const id = req.params.id;
    let previewBuffer = null;
    let contentType = "image/png";
    try {
      const allPreviewFiles = await objectStorageService2.listPrefix(`icons/preview/`);
      const matchingFile = allPreviewFiles.find(
        (file2) => file2.key.includes(id) && (file2.key.endsWith(".png") || file2.key.endsWith(".jpg"))
      );
      if (matchingFile) {
        const previewStream = await objectStorageService2.getStream(matchingFile.key);
        const chunks = [];
        for await (const chunk of previewStream) {
          chunks.push(chunk);
        }
        previewBuffer = Buffer.concat(chunks);
        contentType = guessType(matchingFile.key);
      }
    } catch (error) {
      console.warn(`Error finding preview for icon ${id}:`, error);
    }
    if (!previewBuffer) {
      return res.status(404).json({ error: "Preview image not found" });
    }
    res.setHeader("Content-Type", contentType);
    res.setHeader("Cache-Control", "public, max-age=31536000");
    res.setHeader("Access-Control-Allow-Origin", "*");
    res.send(previewBuffer);
  } catch (error) {
    console.error(`Error serving preview for icon ${req.params.id}:`, error);
    res.status(500).json({ error: "Failed to serve preview image" });
  }
});
router4.delete("/:id", requireAdmin, async (req, res) => {
  try {
    const id = req.params.id;
    if (!id) {
      return res.status(400).json({ error: "Icon ID is required" });
    }
    console.log(`\u{1F5D1}\uFE0F Admin attempting to delete icon: ${id}`);
    let deletedAny = false;
    try {
      const svgDeleted = await objectStorageService2.deleteFilesByPattern(`icons/svg/*/${id}.svg`);
      if (svgDeleted) {
        deletedAny = true;
        console.log(`\u2705 Deleted SVG files for icon: ${id}`);
      }
    } catch (svgError) {
      console.warn(`Error deleting SVG files for ${id}:`, svgError);
    }
    try {
      const previewDeleted = await objectStorageService2.deleteFilesByPattern(`icons/preview/*/${id}.*`);
      if (previewDeleted) {
        deletedAny = true;
        console.log(`\u2705 Deleted preview files for icon: ${id}`);
      }
    } catch (previewError) {
      console.warn(`Error deleting preview files for ${id}:`, previewError);
    }
    try {
      const allFiles = await objectStorageService2.listPrefix(`icons/`);
      const matchingFiles = allFiles.filter(
        (file2) => file2.key.includes(id) && (file2.key.includes("svg/") || file2.key.includes("preview/") || file2.key.includes("png/"))
      );
      for (const file2 of matchingFiles) {
        try {
          await objectStorageService2.deleteFile(file2.key);
          deletedAny = true;
          console.log(`\u2705 Deleted specific file: ${file2.key}`);
        } catch (fileError) {
          console.warn(`Failed to delete file ${file2.key}:`, fileError);
        }
      }
    } catch (listError) {
      console.warn(`Error listing files for cleanup:`, listError);
    }
    if (!deletedAny) {
      console.log(`\u26A0\uFE0F No files found to delete for icon: ${id}`);
      return res.status(404).json({ error: "Icon not found or already deleted" });
    }
    console.log(`\u2705 Successfully deleted icon: ${id}`);
    return res.json({ success: true, message: "Icon deleted successfully from object storage" });
  } catch (error) {
    console.error(`\u274C Error deleting icon ${req.params.id}:`, error);
    return res.status(500).json({ error: "Failed to delete icon from object storage" });
  }
});
var hiddenIcons = /* @__PURE__ */ new Set();
var HIDDEN_ICONS_FILE = path2.join(process.cwd(), "server", "data", "hidden-icons.json");
async function loadHiddenIcons() {
  try {
    const data = await fs2.readFile(HIDDEN_ICONS_FILE, "utf8");
    const hiddenArray = JSON.parse(data);
    hiddenIcons = new Set(hiddenArray);
    console.log(`[Icons] Loaded ${hiddenIcons.size} hidden icons from file`);
  } catch (error) {
    hiddenIcons = /* @__PURE__ */ new Set();
    console.log(`[Icons] No hidden icons file found, starting fresh`);
  }
}
async function saveHiddenIcons() {
  try {
    await fs2.mkdir(path2.dirname(HIDDEN_ICONS_FILE), { recursive: true });
    await fs2.writeFile(HIDDEN_ICONS_FILE, JSON.stringify([...hiddenIcons], null, 2));
    console.log(`[Icons] Saved ${hiddenIcons.size} hidden icons to file`);
  } catch (error) {
    console.error(`[Icons] Failed to save hidden icons:`, error);
  }
}
loadHiddenIcons();
router4.post("/admin/:id/disable", requireAdmin, async (req, res) => {
  try {
    const iconId = req.params.id;
    if (!iconId) {
      return res.status(400).json({ error: "Icon ID is required" });
    }
    hiddenIcons.add(iconId);
    await saveHiddenIcons();
    console.log(`[Icons] Admin disabled icon: ${iconId}`);
    res.json({
      success: true,
      message: `Icon ${iconId} has been marked as hidden`,
      hiddenIconsCount: hiddenIcons.size
    });
  } catch (error) {
    console.error(`Error disabling icon ${req.params.id}:`, error);
    res.status(500).json({ error: "Failed to disable icon" });
  }
});
router4.post("/admin/:id/purge-files", requireAdmin, async (req, res) => {
  try {
    const iconId = req.params.id;
    if (!iconId) {
      return res.status(400).json({ error: "Icon ID is required" });
    }
    if (!hiddenIcons.has(iconId)) {
      return res.status(400).json({ error: "Icon must be disabled before purging files" });
    }
    console.log(`\u{1F5D1}\uFE0F Admin purging files for hidden icon: ${iconId}`);
    let deletedAny = false;
    try {
      const svgDeleted = await objectStorageService2.deleteFilesByPattern(`icons/svg/*/${iconId}.svg`);
      if (svgDeleted) {
        deletedAny = true;
        console.log(`\u2705 Purged SVG files for icon: ${iconId}`);
      }
    } catch (svgError) {
      console.warn(`Error purging SVG files for ${iconId}:`, svgError);
    }
    try {
      const previewDeleted = await objectStorageService2.deleteFilesByPattern(`icons/preview/*/${iconId}.*`);
      if (previewDeleted) {
        deletedAny = true;
        console.log(`\u2705 Purged preview files for icon: ${iconId}`);
      }
    } catch (previewError) {
      console.warn(`Error purging preview files for ${iconId}:`, previewError);
    }
    try {
      const allFiles = await objectStorageService2.listPrefix(`icons/`);
      const matchingFiles = allFiles.filter(
        (file2) => file2.key.includes(iconId) && (file2.key.includes("svg/") || file2.key.includes("preview/") || file2.key.includes("png/"))
      );
      for (const file2 of matchingFiles) {
        try {
          await objectStorageService2.deleteFile(file2.key);
          deletedAny = true;
          console.log(`\u2705 Purged specific file: ${file2.key}`);
        } catch (fileError) {
          console.warn(`Failed to purge file ${file2.key}:`, fileError);
        }
      }
    } catch (listError) {
      console.warn(`Error listing files for purge:`, listError);
    }
    res.json({
      success: true,
      message: `Files purged for hidden icon ${iconId}`,
      filesDeleted: deletedAny
    });
  } catch (error) {
    console.error(`\u274C Error purging files for icon ${req.params.id}:`, error);
    return res.status(500).json({ error: "Failed to purge icon files" });
  }
});
var iconLibraryRoutes_default = router4;

// server/routes.ts
init_adminGuard();

// server/routes/stock.ts
import { Router as Router4 } from "express";
import fetch2 from "node-fetch";
var router5 = Router4();
router5.get("/photos", async (req, res) => {
  try {
    const query = req.query.query;
    const limit = Math.min(parseInt(req.query.limit) || 12, 30);
    if (!query || query.trim().length === 0) {
      return res.status(400).json({
        error: "Query parameter is required",
        results: []
      });
    }
    const results = [];
    const unsplashKey = process.env.UNSPLASH_ACCESS_KEY;
    if (unsplashKey) {
      try {
        const unsplashResults = await searchUnsplash(query, limit, unsplashKey);
        results.push(...unsplashResults);
      } catch (error) {
        console.warn("Unsplash API error:", error);
      }
    }
    const pexelsKey = process.env.PEXELS_API_KEY;
    if (pexelsKey && results.length < limit) {
      try {
        const remaining = limit - results.length;
        const pexelsResults = await searchPexels(query, remaining, pexelsKey);
        results.push(...pexelsResults);
      } catch (error) {
        console.warn("Pexels API error:", error);
      }
    }
    if (!unsplashKey && !pexelsKey) {
      return res.status(503).json({
        error: "Stock photo search unavailable - no API keys configured",
        message: "Configure UNSPLASH_ACCESS_KEY or PEXELS_API_KEY environment variables to enable stock photo search",
        results: []
      });
    }
    res.json({
      query,
      total: results.length,
      results: results.slice(0, limit)
    });
  } catch (error) {
    console.error("Stock photo search error:", error);
    res.status(500).json({
      error: "Failed to search stock photos",
      results: []
    });
  }
});
async function searchUnsplash(query, limit, apiKey) {
  const url = `https://api.unsplash.com/search/photos?query=${encodeURIComponent(query)}&per_page=${limit}&orientation=landscape`;
  const response = await fetch2(url, {
    headers: {
      "Authorization": `Client-ID ${apiKey}`,
      "Accept-Version": "v1"
    }
  });
  if (!response.ok) {
    throw new Error(`Unsplash API error: ${response.status} ${response.statusText}`);
  }
  const data = await response.json();
  return data.results.map((photo) => ({
    id: `unsplash-${photo.id}`,
    thumb: photo.urls.thumb,
    full: photo.urls.regular,
    // Use regular instead of full for better performance
    credit: `Photo by ${photo.user.name} on Unsplash`
  }));
}
async function searchPexels(query, limit, apiKey) {
  const url = `https://api.pexels.com/v1/search?query=${encodeURIComponent(query)}&per_page=${limit}&orientation=landscape`;
  const response = await fetch2(url, {
    headers: {
      "Authorization": apiKey
    }
  });
  if (!response.ok) {
    throw new Error(`Pexels API error: ${response.status} ${response.statusText}`);
  }
  const data = await response.json();
  return data.photos.map((photo) => ({
    id: `pexels-${photo.id}`,
    thumb: photo.src.medium,
    full: photo.src.large,
    credit: `Photo by ${photo.photographer} on Pexels`
  }));
}
var stock_default = router5;

// server/routes/ppt.ts
import { Router as Router5 } from "express";
import PPTXGenJS from "pptxgenjs";
var router6 = Router5();
router6.post("/build-template", async (req, res) => {
  try {
    const b = req.body;
    const pptx = new PPTXGenJS();
    pptx.layout = b.size === "4x3" ? "LAYOUT_4x3" : "LAYOUT_16x9";
    const slideW = pptx.width, slideH = pptx.height;
    if (b.coverDividers) {
      const cd = normalizeCD(b.coverDividers, b.size);
      defineCoverMasterFromCD(pptx, cd, slideW, slideH);
      defineDividerMasterFromCD(pptx, cd, slideW, slideH);
    } else {
      pptx.defineSlideMaster({
        title: "CoverMaster",
        background: { color: rgb(b.brand.accents[0], "0EA5E9") },
        objects: [
          { text: { text: b.brand.name || "Your Company", options: { x: 1, y: 2, fontSize: 36, color: "FFFFFF", fontFace: b.brand.fonts.heading, bold: true } } },
          ...b.assets.logoDataUrl && b.assets.logoPlacement !== "none" ? [logoObject(b.assets, slideW, slideH)] : []
        ]
      });
      pptx.defineSlideMaster({
        title: "DividerMaster",
        background: { color: rgb(b.brand.accents[1], "F99F1B") },
        objects: [
          { text: { text: "Section Title", options: { x: 1, y: 2, fontSize: 28, color: "FFFFFF", fontFace: b.brand.fonts.heading, bold: true } } },
          ...b.assets.logoDataUrl && b.assets.logoPlacement !== "none" ? [logoObject(b.assets, slideW, slideH)] : []
        ]
      });
    }
    pptx.addSlide({ masterName: "CoverMaster" }).addText("", { x: 0, y: 0, w: 0, h: 0 });
    pptx.addSlide({ masterName: "DividerMaster" });
    b.selections.layouts.forEach((layoutId) => {
      const s = pptx.addSlide();
      s.addText(layoutId, { x: 1, y: 0.6, fontSize: 20, fontFace: b.brand.fonts.heading });
      s.addText("Content area", { x: 1, y: 1.4, fontSize: 14, fontFace: b.brand.fonts.body, color: rgb(b.brand.accents[2], "333333") });
      addLogoToSlide(s, b.assets, slideW, slideH);
    });
    b.selections.infographics.forEach((inf) => {
      const s = pptx.addSlide();
      s.addText(`Infographic: ${inf}`, { x: 1, y: 0.6, fontSize: 20, fontFace: b.brand.fonts.heading });
      const sections = parseInt(inf.match(/\d+/)?.[0] || "2", 10);
      const totalW = slideW - 1;
      const boxW = (totalW - (sections - 1) * 0.1) / sections;
      for (let i = 0; i < sections; i++) {
        s.addShape(pptx.ShapeType.rect, {
          x: 0.5 + i * (boxW + 0.1),
          y: 1.6,
          w: boxW,
          h: 2.2,
          fill: { color: rgb(b.brand.accents[i % b.brand.accents.length], "6B7280") }
        });
      }
      addLogoToSlide(s, b.assets, slideW, slideH);
    });
    if (b.infographicsDetailed && b.infographicsDetailed.length > 0) {
      b.infographicsDetailed.forEach((item) => {
        const s = pptx.addSlide();
        addInfographicDetailed(pptx, s, item, b.brand.fonts, b.brand.accents, slideW, slideH);
        addLogoToSlide(s, b.assets, slideW, slideH);
      });
    }
    const buf = await pptx.write("nodebuffer");
    res.setHeader("Content-Disposition", 'attachment; filename="ibrandbiz-template.pptx"');
    res.setHeader("Content-Type", "application/vnd.openxmlformats-officedocument.presentationml.presentation");
    res.send(buf);
  } catch (e) {
    console.error("PPT build error", e);
    res.status(500).json({ error: "Failed to build PPTX" });
  }
});
var ppt_default = router6;
function addInfographicDetailed(pptx, s, item, fonts, colors, slideW, slideH) {
  const col = (i) => rgb(colors[i % colors.length], "0EA5E9");
  const center = { x: slideW / 2, y: slideH / 2 };
  const count = Math.max(2, Math.min(item.count || 6, 12));
  if (item.layout === "hubSpoke") {
    const R = Math.min(slideW, slideH) * 0.22;
    const node = Math.min(slideW, slideH) * 0.11;
    s.addShape(pptx.ShapeType.ellipse, { x: center.x - node * 0.7 / 2, y: center.y - node * 0.7 / 2, w: node * 0.7, h: node * 0.7, fill: { color: "0F172A" }, line: { color: "FFFFFF", width: 1 } });
    s.addText(item.centerTitle || "Topic", { x: center.x - 2.5, y: center.y - 0.4, w: 5, h: 0.8, align: "center", fontFace: fonts.heading, fontSize: 22, bold: true, color: "FFFFFF" });
    for (let i = 0; i < count; i++) {
      const a = Math.PI * 2 * i / count - Math.PI / 2;
      const nx = center.x + R * Math.cos(a), ny = center.y + R * Math.sin(a);
      s.addShape(pptx.ShapeType.line, { x: center.x, y: center.y, w: nx - center.x, h: ny - center.y, line: { color: "CBD5E1", width: 1.5 } });
      s.addShape(pptx.ShapeType.ellipse, { x: nx - node / 2, y: ny - node / 2, w: node, h: node, fill: { color: col(i) }, line: { color: "FFFFFF", width: 1 } });
      const lbl = item.labels?.[i] ?? `Point ${i + 1}`;
      const note = item.notes?.[i] ?? "";
      s.addText(
        [
          { text: `${lbl}
`, options: { bold: true, fontFace: fonts.heading, fontSize: 14, color: "1F2937" } },
          ...note ? [{ text: note, options: { fontFace: fonts.body, fontSize: 12, color: "475569" } }] : []
        ],
        { x: nx - 1.6, y: ny + node / 2 + 0.1, w: 3.2, h: 1, align: "center" }
      );
    }
  }
  if (item.layout === "stepsHorizontal") {
    const marginX = 0.7, gap = 0.25;
    const availableW = slideW - marginX * 2 - gap * (count - 1);
    const boxW = availableW / count;
    const boxH = 1.4;
    const y = slideH * 0.42;
    for (let i = 0; i < count; i++) {
      const x = marginX + i * (boxW + gap);
      s.addShape(pptx.ShapeType.roundRect, { x, y, w: boxW, h: boxH, fill: { color: col(i) }, line: { color: "FFFFFF", width: 1 }, rectRadius: 0.15 });
      s.addText(String(i + 1).padStart(2, "0"), { x: x + 0.15, y: y + 0.18, w: 0.6, h: 0.4, fontFace: fonts.heading, fontSize: 14, bold: true, color: "FFFFFF" });
      const lbl = item.labels?.[i] ?? `Step ${i + 1}`;
      const note = item.notes?.[i] ?? "";
      s.addText(
        [
          { text: `${lbl}
`, options: { bold: true, fontFace: fonts.heading, fontSize: 14, color: "FFFFFF" } },
          ...note ? [{ text: note, options: { fontFace: fonts.body, fontSize: 12, color: "F8FAFC" } }] : []
        ],
        { x: x + 0.85, y: y + 0.2, w: boxW - 1.05, h: boxH - 0.4, align: "left" }
      );
    }
    s.addShape(pptx.ShapeType.line, { x: marginX, y: y + boxH + 0.15, w: slideW - marginX * 2, h: 0, line: { color: "CBD5E1", width: 1 } });
  }
  if (item.layout === "mindmap") {
    const node = 1.3;
    s.addShape(pptx.ShapeType.ellipse, { x: center.x - node, y: center.y - node * 0.7, w: node * 2, h: node * 1.4, fill: { color: "0F172A" }, line: { color: "FFFFFF", width: 1 } });
    s.addText(item.centerTitle || "Topic", { x: center.x - 2.5, y: center.y - 0.2, w: 5, h: 0.8, align: "center", fontFace: fonts.heading, fontSize: 22, bold: true, color: "FFFFFF" });
    const perSide = Math.ceil(count / 2);
    const leftX = 1, rightX = slideW - 4;
    const topY = slideH * 0.2, stepY = slideH * 0.6 / (perSide - 1 || 1);
    let idx = 0;
    for (let j = 0; j < perSide && idx < count; j++, idx++) {
      const y = topY + j * stepY;
      s.addShape(pptx.ShapeType.line, { x: center.x - 0.2, y: center.y, w: leftX + 2.2 - (center.x - 0.2), h: y - center.y, line: { color: "94A3B8", width: 1.25 } });
      s.addShape(pptx.ShapeType.roundRect, { x: leftX, y, w: 3.2, h: 1, rectRadius: 0.12, fill: { color: col(idx) }, line: { color: "FFFFFF", width: 1 } });
      const lbl = item.labels?.[idx] ?? `Point ${idx + 1}`;
      const note = item.notes?.[idx] ?? "";
      s.addText(
        [
          { text: lbl + "\n", options: { bold: true, fontFace: fonts.heading, fontSize: 14, color: "FFFFFF" } },
          ...note ? [{ text: note, options: { fontFace: fonts.body, fontSize: 12, color: "F8FAFC" } }] : []
        ],
        { x: leftX + 0.25, y: y + 0.12, w: 2.7, h: 0.8, align: "left" }
      );
    }
    for (let j = 0; j < perSide && idx < count; j++, idx++) {
      const y = topY + j * stepY;
      s.addShape(pptx.ShapeType.line, { x: center.x + 0.2, y: center.y, w: rightX - (center.x + 0.2), h: y - center.y, line: { color: "94A3B8", width: 1.25 } });
      s.addShape(pptx.ShapeType.roundRect, { x: rightX, y, w: 3.2, h: 1, rectRadius: 0.12, fill: { color: col(idx) }, line: { color: "FFFFFF", width: 1 } });
      const lbl = item.labels?.[idx] ?? `Point ${idx + 1}`;
      const note = item.notes?.[idx] ?? "";
      s.addText(
        [
          { text: lbl + "\n", options: { bold: true, fontFace: fonts.heading, fontSize: 14, color: "FFFFFF" } },
          ...note ? [{ text: note, options: { fontFace: fonts.body, fontSize: 12, color: "F8FAFC" } }] : []
        ],
        { x: rightX + 0.25, y: y + 0.12, w: 2.7, h: 0.8, align: "left" }
      );
    }
  }
  if (item.layout === "circularList") {
    const R = Math.min(slideW, slideH) * 0.25;
    const dotSize = Math.min(slideW, slideH) * 0.08;
    for (let i = 0; i < count; i++) {
      const angle = Math.PI * 2 * i / count - Math.PI / 2;
      const dotX = center.x + R * Math.cos(angle);
      const dotY = center.y + R * Math.sin(angle);
      s.addShape(pptx.ShapeType.ellipse, {
        x: dotX - dotSize / 2,
        y: dotY - dotSize / 2,
        w: dotSize,
        h: dotSize,
        fill: { color: col(i) },
        line: { color: "FFFFFF", width: 2 }
      });
      s.addText(String(i + 1), {
        x: dotX - dotSize / 2,
        y: dotY - dotSize / 2,
        w: dotSize,
        h: dotSize,
        align: "center",
        valign: "middle",
        fontFace: fonts.heading,
        fontSize: Math.max(10, Math.floor(dotSize * 18)),
        bold: true,
        color: "FFFFFF"
      });
      const labelRadius = R + dotSize / 2 + 0.5;
      const labelX = center.x + labelRadius * Math.cos(angle);
      const labelY = center.y + labelRadius * Math.sin(angle);
      s.addShape(pptx.ShapeType.line, {
        x: dotX,
        y: dotY,
        w: labelX - dotX,
        h: labelY - dotY,
        line: { color: "CBD5E1", width: 1.5 }
      });
      const textBoxW = 2.5;
      const textBoxH = 1;
      let textX = labelX - textBoxW / 2;
      let textY = labelY - textBoxH / 2;
      let textAlign = "center";
      if (Math.cos(angle) < -0.3) {
        textX = labelX - textBoxW;
        textAlign = "right";
      } else if (Math.cos(angle) > 0.3) {
        textX = labelX;
        textAlign = "left";
      }
      const lbl = item.labels?.[i] ?? `Point ${i + 1}`;
      const note = item.notes?.[i] ?? "";
      s.addText(
        [
          { text: `${lbl}
`, options: { bold: true, fontFace: fonts.heading, fontSize: 12, color: "1F2937" } },
          ...note ? [{ text: note, options: { fontFace: fonts.body, fontSize: 10, color: "475569" } }] : []
        ],
        {
          x: textX,
          y: textY,
          w: textBoxW,
          h: textBoxH,
          align: textAlign
        }
      );
    }
  }
}
function rgb(maybeHex, fallbackHex) {
  const h = (maybeHex || fallbackHex || "000000").replace("#", "");
  return h.length === 6 ? h.toUpperCase() : "000000";
}
function addLogoToSlide(slide, assets2, slideW, slideH) {
  if (!assets2.logoDataUrl || assets2.logoPlacement === "none") return;
  const base = 1.2;
  const w = base * (assets2.logoScale || 1);
  const h = w;
  const m = 0.25;
  let x = m, y = m;
  switch (assets2.logoPlacement) {
    case "top-left":
      x = m;
      y = m;
      break;
    case "top-right":
      x = slideW - w - m;
      y = m;
      break;
    case "bottom-left":
      x = m;
      y = slideH - h - m;
      break;
    case "bottom-right":
      x = slideW - w - m;
      y = slideH - h - m;
      break;
  }
  slide.addImage({ data: assets2.logoDataUrl, x, y, w, h });
}
function logoObject(assets2, slideW, slideH) {
  const base = 1.2;
  const w = base * (assets2.logoScale || 1);
  const h = w;
  const m = 0.25;
  let x = -999, y = -999;
  switch (assets2.logoPlacement) {
    case "top-left":
      x = m;
      y = m;
      break;
    case "top-right":
      x = slideW - w - m;
      y = m;
      break;
    case "bottom-left":
      x = m;
      y = slideH - h - m;
      break;
    case "bottom-right":
      x = slideW - w - m;
      y = slideH - h - m;
      break;
    case "none":
    default:
      break;
  }
  return { image: { data: assets2.logoDataUrl, x, y, w, h } };
}
function normalizeCD(cd, currentSize) {
  if (cd.size === currentSize) return cd;
  return { ...cd, size: currentSize };
}
function defineCoverMasterFromCD(pptx, cd, slideW, slideH) {
  const objects = [];
  if (cd.style === "band") {
    objects.push({ rect: { x: 0, y: 0, w: "100%", h: "100%", fill: { color: rgb(cd.brand.accents[2], "111827") } } });
    objects.push({ rect: { x: 0, y: slideH * 0.32, w: "100%", h: slideH * 0.36, fill: { color: rgb(cd.brand.accents[0], "0EA5E9") } } });
  } else if (cd.style === "left") {
    objects.push({ rect: { x: 0, y: 0, w: "100%", h: "100%", fill: { color: rgb(cd.brand.accents[2], "111827") } } });
    objects.push({ rect: { x: 0.6, y: slideH * 0.26, w: 0.12, h: slideH * 0.48, fill: { color: rgb(cd.brand.accents[1], "F99F1B") } } });
  } else if (cd.style === "wash") {
    objects.push({ rect: { x: 0, y: 0, w: "100%", h: "100%", fill: { color: rgb(cd.brand.accents[2], "111827") } } });
    objects.push({ rect: { x: 0, y: 0, w: "100%", h: "100%", fill: { color: rgb(cd.brand.accents[0], "0EA5E9"), transparency: 60 } } });
  } else {
    objects.push({ rect: { x: 0, y: 0, w: "100%", h: "100%", fill: { color: rgb(cd.brand.accents[0], "0EA5E9") } } });
  }
  objects.push({
    text: { text: cd.content.title || "Title", options: { x: 0.8, y: slideH * 0.32, w: slideW - 1.6, h: 1.6, align: "center", fontFace: cd.brand.fonts.heading, fontSize: 42, bold: true, color: "FFFFFF" } }
  });
  if (cd.content.subtitle?.trim()) {
    objects.push({
      text: { text: cd.content.subtitle, options: { x: 1.2, y: slideH * 0.48, w: slideW - 2.4, h: 1.1, align: "center", fontFace: cd.brand.fonts.body, fontSize: 20, color: "FFFFFF" } }
    });
  }
  if (cd.assets.logoDataUrl && cd.assets.logoPlacement !== "none") {
    objects.push(logoObject(cd.assets, slideW, slideH));
  }
  pptx.defineSlideMaster({ title: "CoverMaster", objects });
}
function defineDividerMasterFromCD(pptx, cd, slideW, slideH) {
  const objects = [];
  if (cd.style === "band") {
    objects.push({ rect: { x: 0, y: 0, w: "100%", h: "100%", fill: { color: rgb(cd.brand.accents[2], "111827") } } });
    objects.push({ rect: { x: 0, y: slideH * 0.35, w: "100%", h: slideH * 0.3, fill: { color: rgb(cd.brand.accents[1], "F99F1B") } } });
  } else if (cd.style === "left") {
    objects.push({ rect: { x: 0, y: 0, w: "100%", h: "100%", fill: { color: rgb(cd.brand.accents[0], "0EA5E9") } } });
    objects.push({ rect: { x: 0.6, y: slideH * 0.3, w: 0.12, h: slideH * 0.4, fill: { color: "FFFFFF" } } });
  } else if (cd.style === "wash") {
    objects.push({ rect: { x: 0, y: 0, w: "100%", h: "100%", fill: { color: rgb(cd.brand.accents[2], "111827") } } });
    objects.push({ rect: { x: 0, y: 0, w: "100%", h: "100%", fill: { color: rgb(cd.brand.accents[1], "F99F1B"), transparency: 65 } } });
  } else {
    objects.push({ rect: { x: 0, y: 0, w: "100%", h: "100%", fill: { color: rgb(cd.brand.accents[1], "F99F1B") } } });
  }
  objects.push({
    text: { text: "Section Title", options: { x: 0.8, y: slideH * 0.4, w: slideW - 1.6, h: 1.2, align: "center", fontFace: cd.brand.fonts.heading, fontSize: 32, bold: true, color: "FFFFFF" } }
  });
  if (cd.assets.logoDataUrl && cd.assets.logoPlacement !== "none") {
    objects.push(logoObject(cd.assets, slideW, slideH));
  }
  pptx.defineSlideMaster({ title: "DividerMaster", objects });
}

// server/routes/infographics.ts
import { Router as Router6 } from "express";
import PPTXGenJS2 from "pptxgenjs";
var router7 = Router6();
router7.post("/", async (req, res) => {
  try {
    let addLogo2 = function(slide) {
      const a = b.assets;
      if (!a?.logoDataUrl || !a.logoPlacement || a.logoPlacement === "none") return;
      const base = 1, w = base * (a.logoScale || 1), h = w, m = 0.25;
      let x = m, y = m;
      switch (a.logoPlacement) {
        case "top-left":
          x = m;
          y = m;
          break;
        case "top-right":
          x = W - w - m;
          y = m;
          break;
        case "bottom-left":
          x = m;
          y = H - h - m;
          break;
        case "bottom-right":
          x = W - w - m;
          y = H - h - m;
          break;
      }
      slide.addImage({ data: a.logoDataUrl, x, y, w, h });
    };
    var addLogo = addLogo2;
    const b = req.body;
    const count = Math.max(2, Math.min(b.count ?? 6, 12));
    const fonts = {
      heading: b.brand?.fonts?.heading || "Inter",
      body: b.brand?.fonts?.body || "Inter"
    };
    const palette = b.colors && b.colors.length ? b.colors : b.brand?.accents || ["#0EA5E9", "#F59E0B", "#10B981", "#8B5CF6", "#EF4444", "#64748B"];
    const pptx = new PPTXGenJS2();
    pptx.layout = b.size === "4x3" ? "LAYOUT_4x3" : "LAYOUT_16x9";
    const W = pptx.width;
    const H = pptx.height;
    const col = (i) => hex(palette[i % palette.length]);
    const center = { x: W / 2, y: H / 2 };
    const s = pptx.addSlide();
    if (b.layout === "hubSpoke") {
      const R = Math.min(W, H) * 0.22;
      const node = Math.min(W, H) * 0.11;
      const cx = center.x, cy = center.y;
      s.addShape(pptx.ShapeType.ellipse, {
        x: cx - node * 0.7 / 2,
        y: cy - node * 0.7 / 2,
        w: node * 0.7,
        h: node * 0.7,
        fill: { color: hex("#0F172A") },
        line: { color: "FFFFFF", width: 1 }
      });
      s.addText(b.centerTitle || "Topic", {
        x: cx - 2.5,
        y: cy - 0.4,
        w: 5,
        h: 0.8,
        align: "center",
        fontFace: fonts.heading,
        fontSize: 22,
        bold: true,
        color: "FFFFFF"
      });
      for (let i = 0; i < count; i++) {
        const angle = Math.PI * 2 * i / count - Math.PI / 2;
        const nx = cx + R * Math.cos(angle);
        const ny = cy + R * Math.sin(angle);
        s.addShape(pptx.ShapeType.line, {
          x: cx,
          y: cy,
          w: nx - cx,
          h: ny - cy,
          line: { color: hex("#CBD5E1"), width: 1.5 }
        });
        s.addShape(pptx.ShapeType.ellipse, {
          x: nx - node / 2,
          y: ny - node / 2,
          w: node,
          h: node,
          fill: { color: col(i) },
          line: { color: "FFFFFF", width: 1 }
        });
        const icon = b.iconsSvg?.[i];
        if (icon) {
          s.addImage({ data: icon, x: nx - node * 0.28, y: ny - node * 0.28, w: node * 0.56, h: node * 0.56 });
        }
        const lbl = b.labels?.[i] ?? `Point ${i + 1}`;
        const note = b.notes?.[i] ?? "";
        s.addText(
          [
            { text: `${lbl}
`, options: { bold: true, fontFace: fonts.heading, fontSize: 14, color: "1F2937" } },
            ...note ? [{ text: note, options: { fontFace: fonts.body, fontSize: 12, color: "475569" } }] : []
          ],
          {
            x: nx - 1.6,
            y: ny + node / 2 + 0.1,
            w: 3.2,
            h: 1,
            align: "center"
          }
        );
      }
      addLogo2(s);
    }
    if (b.layout === "stepsHorizontal") {
      const marginX = 0.7, gap = 0.25;
      const availableW = W - marginX * 2 - gap * (count - 1);
      const boxW = availableW / count;
      const boxH = 1.4;
      const y = H * 0.42;
      for (let i = 0; i < count; i++) {
        const x = marginX + i * (boxW + gap);
        s.addShape(pptx.ShapeType.roundRect, {
          x,
          y,
          w: boxW,
          h: boxH,
          fill: { color: col(i) },
          line: { color: "FFFFFF", width: 1 },
          rectRadius: 0.15
        });
        s.addText(String(i + 1).padStart(2, "0"), {
          x: x + 0.15,
          y: y + 0.18,
          w: 0.6,
          h: 0.4,
          fontFace: fonts.heading,
          fontSize: 14,
          bold: true,
          color: "FFFFFF"
        });
        const lbl = b.labels?.[i] ?? `Step ${i + 1}`;
        const note = b.notes?.[i] ?? "";
        s.addText(
          [
            { text: `${lbl}
`, options: { bold: true, fontFace: fonts.heading, fontSize: 14, color: "FFFFFF" } },
            ...note ? [{ text: note, options: { fontFace: fonts.body, fontSize: 12, color: "F8FAFC" } }] : []
          ],
          { x: x + 0.85, y: y + 0.2, w: boxW - 1.05, h: boxH - 0.4, align: "left" }
        );
      }
      s.addShape(pptx.ShapeType.line, {
        x: marginX,
        y: y + boxH + 0.15,
        w: W - marginX * 2,
        h: 0,
        line: { color: hex("#CBD5E1"), width: 1 }
      });
      addLogo2(s);
    }
    if (b.layout === "mindmap") {
      const node = 1.3;
      s.addShape(pptx.ShapeType.ellipse, {
        x: center.x - node,
        y: center.y - node * 0.7,
        w: node * 2,
        h: node * 1.4,
        fill: { color: hex("#0F172A") },
        line: { color: "FFFFFF", width: 1 }
      });
      s.addText(b.centerTitle || "Topic", {
        x: center.x - 2.5,
        y: center.y - 0.2,
        w: 5,
        h: 0.8,
        align: "center",
        fontFace: fonts.heading,
        fontSize: 22,
        bold: true,
        color: "FFFFFF"
      });
      const perSide = Math.ceil(count / 2);
      const leftX = 1, rightX = W - 4;
      const topY = H * 0.2, stepY = H * 0.6 / (perSide - 1 || 1);
      let idx = 0;
      for (let j = 0; j < perSide && idx < count; j++, idx++) {
        const y = topY + j * stepY;
        s.addShape(pptx.ShapeType.line, {
          x: center.x - 0.2,
          y: center.y,
          w: leftX + 2.2 - (center.x - 0.2),
          h: y - center.y,
          line: { color: hex("#94A3B8"), width: 1.25 }
        });
        s.addShape(pptx.ShapeType.roundRect, {
          x: leftX,
          y,
          w: 3.2,
          h: 1,
          rectRadius: 0.12,
          fill: { color: col(idx) },
          line: { color: "FFFFFF", width: 1 }
        });
        const lbl = b.labels?.[idx] ?? `Point ${idx + 1}`;
        const note = b.notes?.[idx] ?? "";
        s.addText(
          [
            { text: lbl + "\n", options: { bold: true, fontFace: fonts.heading, fontSize: 14, color: "FFFFFF" } },
            ...note ? [{ text: note, options: { fontFace: fonts.body, fontSize: 12, color: "F8FAFC" } }] : []
          ],
          { x: leftX + 0.25, y: y + 0.12, w: 2.7, h: 0.8, align: "left" }
        );
      }
      for (let j = 0; j < perSide && idx < count; j++, idx++) {
        const y = topY + j * stepY;
        s.addShape(pptx.ShapeType.line, {
          x: center.x + 0.2,
          y: center.y,
          w: rightX - (center.x + 0.2),
          h: y - center.y,
          line: { color: hex("#94A3B8"), width: 1.25 }
        });
        s.addShape(pptx.ShapeType.roundRect, {
          x: rightX,
          y,
          w: 3.2,
          h: 1,
          rectRadius: 0.12,
          fill: { color: col(idx) },
          line: { color: "FFFFFF", width: 1 }
        });
        const lbl = b.labels?.[idx] ?? `Point ${idx + 1}`;
        const note = b.notes?.[idx] ?? "";
        s.addText(
          [
            { text: lbl + "\n", options: { bold: true, fontFace: fonts.heading, fontSize: 14, color: "FFFFFF" } },
            ...note ? [{ text: note, options: { fontFace: fonts.body, fontSize: 12, color: "F8FAFC" } }] : []
          ],
          { x: rightX + 0.25, y: y + 0.12, w: 2.7, h: 0.8, align: "left" }
        );
      }
      addLogo2(s);
    }
    if (b.layout === "circularList") {
      const cx = W / 2, cy = H / 2;
      const R = Math.min(W, H) * 0.3;
      const dot = 0.35;
      const labelW = 2.8;
      s.addShape(pptx.ShapeType.ellipse, {
        x: cx - R,
        y: cy - R,
        w: R * 2,
        h: R * 2,
        line: { color: hex("#CBD5E1"), width: 1.2 }
      });
      for (let i = 0; i < count; i++) {
        const a = Math.PI * 2 * i / count - Math.PI / 2;
        const nx = cx + R * Math.cos(a);
        const ny = cy + R * Math.sin(a);
        s.addShape(pptx.ShapeType.ellipse, {
          x: nx - dot / 2,
          y: ny - dot / 2,
          w: dot,
          h: dot,
          fill: { color: col(i) },
          line: { color: "FFFFFF", width: 1 }
        });
        s.addText(String(i + 1), {
          x: nx - 0.18,
          y: ny - 0.18,
          w: 0.36,
          h: 0.36,
          align: "center",
          fontFace: fonts.heading,
          fontSize: 12,
          bold: true,
          color: "FFFFFF"
        });
        const lx = cx + (R + 0.6) * Math.cos(a) - labelW / 2;
        const ly = cy + (R + 0.6) * Math.sin(a) - 0.4;
        const align = Math.cos(a) > 0.3 ? "left" : Math.cos(a) < -0.3 ? "right" : "center";
        const lbl = b.labels?.[i] ?? `Item ${i + 1}`;
        const note = b.notes?.[i] ?? "";
        s.addText(
          [
            { text: `${lbl}
`, options: { bold: true, fontFace: fonts.heading, fontSize: 14, color: "1F2937" } },
            ...note ? [{ text: note, options: { fontFace: fonts.body, fontSize: 12, color: "475569" } }] : []
          ],
          { x: lx, y: ly, w: labelW, h: 0.9, align }
        );
        s.addShape(pptx.ShapeType.line, {
          x: nx,
          y: ny,
          w: lx + labelW / 2 - nx,
          h: ly + 0.45 - ny,
          line: { color: hex("#CBD5E1"), width: 0.75 }
        });
      }
      addLogo2(s);
    }
    const buf = await pptx.write("nodebuffer");
    res.setHeader("Content-Disposition", 'attachment; filename="infographic.pptx"');
    res.setHeader("Content-Type", "application/vnd.openxmlformats-officedocument.presentationml.presentation");
    res.send(buf);
  } catch (e) {
    console.error("[infographics/generate] error", e);
    res.status(500).json({ error: "Failed to generate infographic" });
  }
});
var infographics_default = router7;
function hex(h) {
  const v = (h || "").replace("#", "");
  return v.length === 6 ? v.toUpperCase() : "000000";
}

// server/routes/presentationTemplates.ts
init_storage();
init_schema();
init_adminGuard();
import { Router as Router7 } from "express";
import { z as z4 } from "zod";
import Stripe2 from "stripe";
var stripe2 = null;
function getStripe2() {
  if (stripe2) return stripe2;
  const stripeKey = process.env.STRIPE_SECRET_KEY;
  if (!stripeKey) {
    console.warn("STRIPE_SECRET_KEY not found - Stripe functionality will be disabled");
    return null;
  }
  try {
    stripe2 = new Stripe2(stripeKey, {
      apiVersion: "2023-10-16"
    });
    return stripe2;
  } catch (error) {
    console.error("Failed to initialize Stripe:", error);
    return null;
  }
}
function buildSecureRedirectUrl(path13, origin) {
  const allowedBaseUrls = [
    process.env.DOMAIN_URL,
    process.env.FRONTEND_URL,
    process.env.VITE_BASE_URL,
    origin
    // Use request origin as fallback if provided
  ].filter(Boolean);
  let baseUrl = allowedBaseUrls[0];
  if (!baseUrl) {
    if (process.env.NODE_ENV === "development") {
      baseUrl = "http://localhost:5000";
    } else {
      console.warn("[buildSecureRedirectUrl] No DOMAIN_URL/FRONTEND_URL configured in production");
      baseUrl = "";
    }
  }
  const cleanPath = path13.startsWith("/") ? path13 : `/${path13}`;
  return `${baseUrl}${cleanPath}`;
}
var router8 = Router7();
var getTemplatesQuerySchema = z4.object({
  q: z4.string().optional(),
  category: z4.string().optional(),
  descriptors: z4.array(z4.string()).or(z4.string()).optional().transform((val) => {
    if (typeof val === "string") return val.split(",").filter(Boolean);
    return val || [];
  }),
  min: z4.coerce.number().optional(),
  max: z4.coerce.number().optional(),
  includeInactive: z4.coerce.boolean().default(false),
  status: z4.string().optional()
});
router8.get("/", async (req, res) => {
  try {
    const query = getTemplatesQuerySchema.parse(req.query);
    const templates = await storage.getPresentationTemplates({
      q: query.q,
      category: query.category,
      descriptors: query.descriptors,
      min: query.min,
      max: query.max,
      includeInactive: query.includeInactive,
      status: query.status
    });
    return res.json({ templates });
  } catch (e) {
    console.error("[GET /presentations] error", e);
    if (e instanceof z4.ZodError) {
      return res.status(400).json({
        error: "Invalid query parameters",
        details: e.errors
      });
    }
    return res.status(500).json({ error: "Failed to fetch presentation templates" });
  }
});
router8.get("/:id", async (req, res) => {
  try {
    const { id } = req.params;
    if (!id) {
      return res.status(400).json({ error: "Template ID is required" });
    }
    const template = await storage.getPresentationTemplate(id);
    if (!template) {
      return res.status(404).json({ error: "Presentation template not found" });
    }
    if (!template.isActive || template.approvalStatus !== "approved") {
      return res.status(404).json({ error: "Presentation template not available" });
    }
    return res.json({ template });
  } catch (e) {
    console.error("[GET /presentations/:id] error", e);
    return res.status(500).json({ error: "Failed to fetch presentation template" });
  }
});
router8.post("/", requireAdmin, async (req, res) => {
  try {
    const validatedData = insertPresentationTemplateSchema.parse(req.body);
    const template = await storage.createPresentationTemplate(validatedData);
    return res.status(201).json({ template });
  } catch (e) {
    console.error("[POST /presentations] error", e);
    if (e instanceof z4.ZodError) {
      return res.status(400).json({
        error: "Validation failed",
        details: e.errors
      });
    }
    return res.status(500).json({ error: "Failed to create presentation template" });
  }
});
router8.put("/:id", requireAdmin, async (req, res) => {
  try {
    const { id } = req.params;
    if (!id) {
      return res.status(400).json({ error: "Template ID is required" });
    }
    const validatedData = insertPresentationTemplateSchema.partial().parse(req.body);
    const template = await storage.updatePresentationTemplate(id, validatedData);
    if (!template) {
      return res.status(404).json({ error: "Presentation template not found" });
    }
    return res.json({ template });
  } catch (e) {
    console.error("[PUT /presentations/:id] error", e);
    if (e instanceof z4.ZodError) {
      return res.status(400).json({
        error: "Validation failed",
        details: e.errors
      });
    }
    return res.status(500).json({ error: "Failed to update presentation template" });
  }
});
router8.delete("/:id", requireAdmin, async (req, res) => {
  try {
    const { id } = req.params;
    if (!id) {
      return res.status(400).json({ error: "Template ID is required" });
    }
    const deleted = await storage.deletePresentationTemplate(id);
    if (!deleted) {
      return res.status(404).json({ error: "Presentation template not found" });
    }
    return res.json({ success: true, message: "Presentation template deleted successfully" });
  } catch (e) {
    console.error("[DELETE /presentations/:id] error", e);
    return res.status(500).json({ error: "Failed to delete presentation template" });
  }
});
async function authenticateToken(req, res, next) {
  try {
    const isDevelopment = process.env.NODE_ENV === "development";
    const devBypassHeader = req.headers["x-dev-bypass"];
    if (isDevelopment && devBypassHeader === "development") {
      console.warn("\u{1F6A8} DEV AUTH BYPASS ACTIVE for presentation checkout");
      req.user = {
        uid: "dev-user-123",
        email: "dev@example.com",
        displayName: "Development User"
      };
      return next();
    }
    const authHeader = req.headers.authorization;
    const token = authHeader && authHeader.split(" ")[1];
    if (!token) {
      return res.status(401).json({ error: "Access token required" });
    }
    req.user = {
      uid: "mock-user-id",
      email: "user@example.com",
      displayName: "Mock User"
    };
    next();
  } catch (error) {
    console.error("Presentation checkout authentication error:", error);
    return res.status(403).json({ error: "Invalid or expired token" });
  }
}
router8.post("/checkout/regular", authenticateToken, async (req, res) => {
  try {
    const stripe7 = getStripe2();
    if (!stripe7) {
      return res.status(503).json({ error: "Payment processing is currently unavailable" });
    }
    const userId = req.user?.uid;
    if (!userId) {
      return res.status(401).json({ error: "Authentication required" });
    }
    const schema = z4.object({
      baseTemplateId: z4.string().min(1)
    });
    const { baseTemplateId } = schema.parse(req.body);
    const template = await storage.getPresentationTemplate(baseTemplateId);
    if (!template || !template.isActive || template.approvalStatus !== "approved") {
      return res.status(404).json({ error: "Presentation template not found or unavailable" });
    }
    const purchase = await storage.createPresentationPurchase({
      userId,
      type: "regular",
      baseTemplateId,
      amountCents: 2999,
      // $29.99
      currency: "usd",
      status: "pending"
    });
    const session = await stripe7.checkout.sessions.create({
      payment_method_types: ["card"],
      line_items: [
        {
          price_data: {
            currency: "usd",
            product_data: {
              name: `Presentation Template - ${template.title}`,
              description: "Professional presentation template with full customization rights"
            },
            unit_amount: 2999
          },
          quantity: 1
        }
      ],
      mode: "payment",
      success_url: buildSecureRedirectUrl(`/presentations/purchase-success?session_id={CHECKOUT_SESSION_ID}`),
      cancel_url: buildSecureRedirectUrl(`/presentations/${baseTemplateId}`),
      metadata: {
        purchaseId: purchase.id,
        userId,
        type: "presentation_regular",
        baseTemplateId
      }
    });
    await storage.updatePresentationPurchase(purchase.id, {
      stripeSessionId: session.id
    });
    return res.json({
      sessionId: session.id,
      url: session.url
    });
  } catch (e) {
    console.error("[POST /presentations/checkout/regular] error", e);
    if (e instanceof z4.ZodError) {
      return res.status(400).json({
        error: "Invalid request data",
        details: e.errors
      });
    }
    return res.status(500).json({ error: "Failed to create checkout session" });
  }
});
router8.post("/checkout/premium", authenticateToken, async (req, res) => {
  try {
    const stripe7 = getStripe2();
    if (!stripe7) {
      return res.status(503).json({ error: "Payment processing is currently unavailable" });
    }
    const userId = req.user?.uid;
    if (!userId) {
      return res.status(401).json({ error: "Authentication required" });
    }
    const schema = z4.object({
      baseTemplateId: z4.string().min(1),
      selectedCoverId: z4.string().optional(),
      selectedInfographicIds: z4.array(z4.string()).max(4).default([])
    });
    const { baseTemplateId, selectedCoverId, selectedInfographicIds } = schema.parse(req.body);
    const template = await storage.getPresentationTemplate(baseTemplateId);
    if (!template || !template.isActive || template.approvalStatus !== "approved") {
      return res.status(404).json({ error: "Presentation template not found or unavailable" });
    }
    if (selectedCoverId) {
      const cover = await storage.getCoverTemplate(selectedCoverId);
      if (!cover || !cover.isActive) {
        return res.status(404).json({ error: "Selected cover template not found or unavailable" });
      }
    }
    if (selectedInfographicIds.length > 0) {
      for (const infographicId of selectedInfographicIds) {
        const infographic = await storage.getInfographicTemplate(infographicId);
        if (!infographic || !infographic.isActive || infographic.approvalStatus !== "approved") {
          return res.status(404).json({ error: `Infographic template ${infographicId} not found or unavailable` });
        }
      }
    }
    const purchase = await storage.createPresentationPurchase({
      userId,
      type: "premium_plus",
      baseTemplateId,
      selectedCoverId,
      selectedInfographicIds,
      amountCents: 4999,
      // $49.99
      currency: "usd",
      status: "pending"
    });
    const features = [
      "Professional presentation template",
      "Full customization rights"
    ];
    if (selectedCoverId) features.push("Custom cover slide");
    if (selectedInfographicIds.length > 0) features.push(`${selectedInfographicIds.length} infographic slide${selectedInfographicIds.length > 1 ? "s" : ""}`);
    const session = await stripe7.checkout.sessions.create({
      payment_method_types: ["card"],
      line_items: [
        {
          price_data: {
            currency: "usd",
            product_data: {
              name: `Presentation Template Premium+ - ${template.title}`,
              description: features.join(" \u2022 ")
            },
            unit_amount: 4999
          },
          quantity: 1
        }
      ],
      mode: "payment",
      success_url: buildSecureRedirectUrl(`/presentations/purchase-success?session_id={CHECKOUT_SESSION_ID}`),
      cancel_url: buildSecureRedirectUrl(`/presentations/builder?template=${baseTemplateId}`),
      metadata: {
        purchaseId: purchase.id,
        userId,
        type: "presentation_premium",
        baseTemplateId,
        selectedCoverId: selectedCoverId || "",
        selectedInfographicIds: selectedInfographicIds.join(",")
      }
    });
    await storage.updatePresentationPurchase(purchase.id, {
      stripeSessionId: session.id
    });
    return res.json({
      sessionId: session.id,
      url: session.url
    });
  } catch (e) {
    console.error("[POST /presentations/checkout/premium] error", e);
    if (e instanceof z4.ZodError) {
      return res.status(400).json({
        error: "Invalid request data",
        details: e.errors
      });
    }
    return res.status(500).json({ error: "Failed to create checkout session" });
  }
});
router8.get("/purchases", async (req, res) => {
  try {
    const userId = req.query.userId;
    if (!userId) {
      return res.status(400).json({ error: "User ID is required" });
    }
    const purchases2 = await storage.getUserPresentationPurchases(userId);
    const enrichedPurchases = await Promise.all(
      purchases2.map(async (purchase) => {
        const template = await storage.getPresentationTemplate(purchase.baseTemplateId);
        let cover = null;
        let infographics = [];
        if (purchase.selectedCoverId) {
          cover = await storage.getCoverTemplate(purchase.selectedCoverId);
        }
        if (purchase.selectedInfographicIds && purchase.selectedInfographicIds.length > 0) {
          infographics = await Promise.all(
            purchase.selectedInfographicIds.map((id) => storage.getInfographicTemplate(id))
          );
        }
        return {
          ...purchase,
          template,
          cover,
          infographics: infographics.filter(Boolean)
        };
      })
    );
    return res.json({ purchases: enrichedPurchases });
  } catch (e) {
    console.error("[GET /presentations/purchases] error", e);
    return res.status(500).json({ error: "Failed to fetch presentation purchases" });
  }
});
var presentationTemplates_default = router8;

// server/routes/logoTemplates.ts
import { Router as Router8 } from "express";
import formidable from "formidable";
import fs3 from "fs";
import path3 from "path";
var router9 = Router8();
var ensureDir = (p) => {
  if (!fs3.existsSync(p)) fs3.mkdirSync(p, { recursive: true });
};
var sanitizeId = (id) => (id || "").toLowerCase().trim().replace(/[^a-z0-9\-]/g, "-").replace(/\-+/g, "-");
router9.post("/upload", (req, res) => {
  const form = formidable({ keepExtensions: true, maxFileSize: 20 * 1024 * 1024 });
  form.parse(req, (err, fields, files) => {
    if (err) return res.status(400).json({ error: err.message });
    const id = sanitizeId(String(fields.id || ""));
    const name = String(fields.name || "");
    const tags = String(fields.tags || "").split(",").map((t) => t.trim()).filter(Boolean);
    if (!id || !name) return res.status(400).json({ error: "id and name are required" });
    const svg = files.svg;
    const preview = files.preview;
    if (!svg || !preview) return res.status(400).json({ error: "svg and preview are required" });
    const svgOk = svg.mimetype && svg.mimetype === "image/svg+xml" || svg.originalFilename && svg.originalFilename.toLowerCase().endsWith(".svg");
    if (!svgOk) return res.status(400).json({ error: "SVG must be image/svg+xml" });
    const previewOk = preview.mimetype && /image\/(png|jpeg)/i.test(preview.mimetype) || preview.originalFilename && /\.(png|jpe?g)$/i.test(preview.originalFilename || "");
    if (!previewOk) return res.status(400).json({ error: "Preview must be PNG or JPG" });
    try {
      const baseDir = path3.join(process.cwd(), "public", "logo-templates", id);
      ensureDir(baseDir);
      const svgPathAbs = path3.join(baseDir, "template.svg");
      const previewExt = (preview.originalFilename || "").split(".").pop() || "png";
      const previewPathAbs = path3.join(baseDir, `preview.${previewExt}`);
      fs3.copyFileSync(svg.filepath, svgPathAbs);
      fs3.copyFileSync(preview.filepath, previewPathAbs);
      const manifestDir = path3.join(process.cwd(), "public", "logo-templates");
      ensureDir(manifestDir);
      const manifestPath = path3.join(manifestDir, "manifest.json");
      let manifest = [];
      if (fs3.existsSync(manifestPath)) {
        try {
          manifest = JSON.parse(fs3.readFileSync(manifestPath, "utf8"));
          if (!Array.isArray(manifest)) manifest = [];
        } catch {
          manifest = [];
        }
      }
      const svgPath = `/logo-templates/${id}/template.svg`;
      const previewPath = `/logo-templates/${id}/` + path3.basename(previewPathAbs);
      const item = {
        id,
        name,
        tags,
        svgPath,
        previewPath,
        createdAt: (/* @__PURE__ */ new Date()).toISOString()
      };
      const idx = manifest.findIndex((m) => m.id === id);
      if (idx >= 0) manifest[idx] = item;
      else manifest.push(item);
      fs3.writeFileSync(manifestPath, JSON.stringify(manifest, null, 2), "utf8");
      res.json({ ok: true, item });
    } catch (error) {
      console.error("Logo template upload error:", error);
      res.status(500).json({ error: error?.message || "Upload failed" });
    }
  });
});
router9.get("/", (req, res) => {
  try {
    const manifestPath = path3.join(process.cwd(), "public", "logo-templates", "manifest.json");
    if (!fs3.existsSync(manifestPath)) {
      return res.json([]);
    }
    const manifest = JSON.parse(fs3.readFileSync(manifestPath, "utf8"));
    res.json(Array.isArray(manifest) ? manifest : []);
  } catch (error) {
    console.error("Error reading logo templates manifest:", error);
    res.status(500).json({ error: "Failed to load logo templates" });
  }
});
var logoTemplates_default = router9;

// server/routes/logoTemplatesPublic.ts
import express2 from "express";

// server/services/logoTemplates.ts
init_firebaseAdmin2();
async function listLogoTemplates() {
  const allTemplates = [];
  const seenIds = /* @__PURE__ */ new Set();
  const collections = ["templates", "logo_templates"];
  for (const collectionName of collections) {
    try {
      const snapshot = await db.collection(collectionName).get();
      for (const doc of snapshot.docs) {
        const data = doc.data();
        const templateId = data.templateId || doc.id;
        if (seenIds.has(templateId)) continue;
        seenIds.add(templateId);
        const template = {
          id: templateId,
          name: data.name || templateId,
          description: data.description || "",
          tags: data.tags || [],
          version: data.version || 1,
          status: data.status || "active",
          storagePaths: {
            svg: data.storagePaths?.svg || "",
            preview: data.storagePaths?.preview || data.storagePaths?.raster || "",
            raster: data.storagePaths?.raster || ""
          },
          downloadURLs: {
            svg: data.downloadURLs?.svg || "",
            preview: data.downloadURLs?.preview || data.downloadURLs?.raster || "",
            raster: data.downloadURLs?.raster || ""
          },
          defaults: {
            brandName: data.defaults?.brandName || data.brandName || "Your Brand",
            tagline: data.defaults?.tagline || data.tagline || "Your Tagline",
            estYear: data.defaults?.estYear || data.estYear || "2025"
          },
          createdBy: data.ownerId || data.createdBy || "",
          createdAt: data.createdAt,
          updatedAt: data.updatedAt
        };
        allTemplates.push(template);
      }
    } catch (error) {
      console.warn(`Failed to read ${collectionName} collection:`, error);
    }
  }
  return allTemplates;
}
async function getLogoTemplateById(id) {
  const collections = ["templates", "logo_templates"];
  const searchIds = [id];
  if (id.startsWith("logo-wordmark-")) {
    searchIds.push(id.replace("logo-wordmark-", ""));
  }
  for (const collectionName of collections) {
    try {
      const snapshot = await db.collection(collectionName).get();
      for (const doc of snapshot.docs) {
        const data = doc.data();
        const templateId = data.templateId || doc.id;
        if (!searchIds.includes(templateId)) continue;
        return {
          id: templateId,
          name: data.name || templateId,
          description: data.description || "",
          tags: data.tags || [],
          version: data.version || 1,
          status: data.status || "active",
          storagePaths: {
            svg: data.storagePaths?.svg || "",
            preview: data.storagePaths?.preview || data.storagePaths?.raster || "",
            raster: data.storagePaths?.raster || ""
          },
          downloadURLs: {
            svg: data.downloadURLs?.svg || "",
            preview: data.downloadURLs?.preview || data.downloadURLs?.raster || "",
            raster: data.downloadURLs?.raster || ""
          },
          defaults: {
            brandName: data.defaults?.brandName || data.brandName || "Your Brand",
            tagline: data.defaults?.tagline || data.tagline || "Your Tagline",
            estYear: data.defaults?.estYear || data.estYear || "2025"
          },
          createdBy: data.ownerId || data.createdBy || "",
          createdAt: data.createdAt,
          updatedAt: data.updatedAt
        };
      }
    } catch (error) {
      console.warn(`Failed to read ${collectionName} collection:`, error);
    }
  }
  return null;
}
async function getSignedUrl(storagePath) {
  if (!storagePath) return "";
  try {
    const file2 = bucket.file(storagePath);
    const [url] = await file2.getSignedUrl({
      action: "read",
      expires: Date.now() + 15 * 60 * 1e3
      // 15 minutes
    });
    return url;
  } catch (error) {
    console.error(`Failed to generate signed URL for ${storagePath}:`, error);
    return "";
  }
}

// server/routes/logoTemplatesPublic.ts
var router10 = express2.Router();
router10.get("/list", async (_req, res) => {
  try {
    const items = await listLogoTemplates();
    const dto = await Promise.all(items.map(async (t) => {
      let svgDownloadUrl = t.downloadURLs?.svg || "";
      let previewDownloadUrl = t.downloadURLs?.preview || t.downloadURLs?.raster || "";
      if (!svgDownloadUrl && t.storagePaths?.svg) {
        svgDownloadUrl = await getSignedUrl(t.storagePaths.svg);
      }
      if (!previewDownloadUrl && (t.storagePaths?.preview || t.storagePaths?.raster)) {
        previewDownloadUrl = await getSignedUrl(t.storagePaths?.preview || t.storagePaths?.raster || "");
      }
      return {
        id: t.id,
        name: t.name,
        description: t.description,
        tags: t.tags || [],
        version: t.version,
        status: t.status,
        assets: {
          svgPath: t.storagePaths?.svg || "",
          previewPngPath: t.storagePaths?.preview || t.storagePaths?.raster || "",
          svgDownloadUrl,
          previewDownloadUrl
        },
        defaults: {
          brandName: t.defaults?.brandName || t.defaults?.Brand_Name || "Your Brand",
          tagline: t.defaults?.tagline || t.defaults?.Tagline || "Your Tagline",
          estYear: t.defaults?.estYear || t.defaults?.Est_Year || "2025"
        },
        createdBy: t.createdBy,
        createdAt: t.createdAt,
        updatedAt: t.updatedAt
      };
    }));
    res.set("Cache-Control", "public, max-age=60");
    res.json({ items: dto });
  } catch (err) {
    console.error("[logo-templates:list] error", err);
    res.status(500).json({ error: "Failed to list logo templates" });
  }
});
router10.get("/:id", async (req, res) => {
  try {
    const { id } = req.params;
    const template = await getLogoTemplateById(id);
    if (!template) {
      return res.status(404).json({ error: "Template not found" });
    }
    let svgDownloadUrl = template.downloadURLs?.svg || "";
    let previewDownloadUrl = template.downloadURLs?.preview || template.downloadURLs?.raster || "";
    if (!svgDownloadUrl && template.storagePaths?.svg) {
      svgDownloadUrl = await getSignedUrl(template.storagePaths.svg);
    }
    if (!previewDownloadUrl && (template.storagePaths?.preview || template.storagePaths?.raster)) {
      previewDownloadUrl = await getSignedUrl(template.storagePaths?.preview || template.storagePaths?.raster || "");
    }
    const dto = {
      id: template.id,
      name: template.name,
      description: template.description,
      tags: template.tags || [],
      version: template.version,
      status: template.status,
      assets: {
        svgPath: template.storagePaths?.svg || "",
        previewPngPath: template.storagePaths?.preview || template.storagePaths?.raster || "",
        svgDownloadUrl,
        previewDownloadUrl
      },
      defaults: {
        brandName: template.defaults?.brandName || template.defaults?.Brand_Name || "Your Brand",
        tagline: template.defaults?.tagline || template.defaults?.Tagline || "Your Tagline",
        estYear: template.defaults?.estYear || template.defaults?.Est_Year || "2025"
      },
      createdBy: template.createdBy,
      createdAt: template.createdAt,
      updatedAt: template.updatedAt
    };
    res.set("Cache-Control", "public, max-age=300");
    res.json(dto);
  } catch (err) {
    console.error("[logo-templates:get] error", err);
    res.status(500).json({ error: "Failed to get logo template" });
  }
});
var logoTemplatesPublic_default = router10;

// server/routes/bpTemplates.ts
import { Router as Router9 } from "express";
import formidable2 from "formidable";
import fs4 from "fs";
import path4 from "path";
var router11 = Router9();
function ensureDir2(dir) {
  if (!fs4.existsSync(dir)) {
    fs4.mkdirSync(dir, { recursive: true });
  }
}
function sanitizeId2(raw) {
  return raw.toLowerCase().replace(/[^a-z0-9\-]/g, "-").replace(/-+/g, "-").replace(/^-|-$/g, "");
}
router11.post("/upload", (req, res) => {
  const form = formidable2({ keepExtensions: true, maxFileSize: 50 * 1024 * 1024 });
  form.parse(req, (err, fields, files) => {
    if (err) return res.status(400).json({ error: err.message });
    const id = sanitizeId2(String(fields.id || ""));
    const name = String(fields.name || "");
    const category = String(fields.category || "");
    const tags = String(fields.tags || "").split(",").map((t) => t.trim()).filter(Boolean);
    const sections = String(fields.sections || "").split("\n").map((s) => s.trim()).filter(Boolean);
    if (!id || !name) {
      return res.status(400).json({ error: "id and name are required" });
    }
    const docx = files.docx;
    const preview = files.preview;
    if (!docx || !preview) {
      return res.status(400).json({ error: "docx and preview files are required" });
    }
    const docxOk = docx.mimetype && docx.mimetype === "application/vnd.openxmlformats-officedocument.wordprocessingml.document" || docx.originalFilename && docx.originalFilename.toLowerCase().endsWith(".docx");
    if (!docxOk) {
      return res.status(400).json({ error: "DOCX file must be a valid Word document" });
    }
    const previewOk = preview.mimetype && /image\/(png|jpeg)/i.test(preview.mimetype) || preview.originalFilename && /\.(png|jpe?g)$/i.test(preview.originalFilename || "");
    if (!previewOk) {
      return res.status(400).json({ error: "Preview must be PNG or JPG" });
    }
    try {
      const templatesDir = path4.join(process.cwd(), "public", "templates", "business-plan");
      const docsDir = path4.join(templatesDir, "docs");
      const previewsDir = path4.join(templatesDir, "previews");
      const dataDir = path4.join(process.cwd(), "public", "site", "data");
      ensureDir2(docsDir);
      ensureDir2(previewsDir);
      ensureDir2(dataDir);
      const docxExt = (docx.originalFilename || "").split(".").pop() || "docx";
      const previewExt = (preview.originalFilename || "").split(".").pop() || "jpg";
      const docxFileName = `${id}.${docxExt}`;
      const previewFileName = `${id}.${previewExt}`;
      const docxPathAbs = path4.join(docsDir, docxFileName);
      const previewPathAbs = path4.join(previewsDir, previewFileName);
      fs4.copyFileSync(docx.filepath, docxPathAbs);
      fs4.copyFileSync(preview.filepath, previewPathAbs);
      const manifestPath = path4.join(dataDir, "manifest.bp.json");
      let manifest = {
        collection: "business-plan",
        version: 1,
        items: []
      };
      if (fs4.existsSync(manifestPath)) {
        try {
          const data = JSON.parse(fs4.readFileSync(manifestPath, "utf8"));
          if (data && data.collection === "business-plan" && Array.isArray(data.items)) {
            manifest = data;
          }
        } catch {
        }
      }
      const docxUrl = `/templates/business-plan/docs/${docxFileName}`;
      const previewUrl = `/templates/business-plan/previews/${previewFileName}`;
      const item = {
        id,
        name,
        category: category || void 0,
        tags: tags.length > 0 ? tags : void 0,
        previewUrl,
        docxUrl,
        updatedAt: (/* @__PURE__ */ new Date()).toISOString().split("T")[0],
        // YYYY-MM-DD
        sections: sections.length > 0 ? sections : void 0
      };
      const idx = manifest.items.findIndex((m) => m.id === id);
      if (idx >= 0) {
        manifest.items[idx] = item;
      } else {
        manifest.items.push(item);
      }
      manifest.items.sort((a, b) => a.name.localeCompare(b.name));
      fs4.writeFileSync(manifestPath, JSON.stringify(manifest, null, 2), "utf8");
      res.json({ ok: true, item });
    } catch (error) {
      console.error("Business plan template upload error:", error);
      res.status(500).json({ error: error?.message || "Upload failed" });
    }
  });
});
var bpTemplates_default = router11;

// server/routes/bpImportCsv.ts
import { Router as Router10 } from "express";
import multer2 from "multer";
import { parse } from "csv-parse/sync";

// client/src/lib/bp-io.ts
import path5 from "path";
import fs5 from "fs";
var PUBLIC_DIR = path5.join(process.cwd(), "public");
var DOC_DIR = path5.join(PUBLIC_DIR, "templates", "business-plan", "docs");
var PREV_DIR = path5.join(PUBLIC_DIR, "templates", "business-plan", "previews");
var DATA_DIR = path5.join(PUBLIC_DIR, "site", "data");
var MANIFEST = path5.join(DATA_DIR, "manifest.bp.json");
function ensureDirs() {
  [DOC_DIR, PREV_DIR, DATA_DIR].forEach((d) => {
    if (!fs5.existsSync(d)) fs5.mkdirSync(d, { recursive: true });
  });
}
function loadManifest() {
  ensureDirs();
  if (!fs5.existsSync(MANIFEST)) {
    const fresh = { collection: "business-plan", version: 1, items: [] };
    fs5.writeFileSync(MANIFEST, JSON.stringify(fresh, null, 2), "utf8");
    return fresh;
  }
  const raw = fs5.readFileSync(MANIFEST, "utf8");
  try {
    const json = JSON.parse(raw);
    json.collection = "business-plan";
    json.version = Number(json.version || 1);
    json.items = Array.isArray(json.items) ? json.items : [];
    return json;
  } catch {
    return { collection: "business-plan", version: 1, items: [] };
  }
}
function saveManifest(m) {
  m.collection = "business-plan";
  m.version = Number(m.version || 1);
  fs5.writeFileSync(MANIFEST, JSON.stringify(m, null, 2), "utf8");
}
var kebab = (s) => (s || "").toLowerCase().trim().replace(/[^a-z0-9\-]/g, "-").replace(/\-+/g, "-");
function upsert(items, item) {
  const idx = items.findIndex((x) => x.id === item.id);
  if (idx >= 0) items[idx] = item;
  else items.push(item);
  return items;
}

// server/routes/bpImportCsv.ts
var upload2 = multer2();
var router12 = Router10();
router12.post("/import-csv", upload2.single("csv"), (req, res) => {
  try {
    if (!req.file) return res.status(400).json({ error: "CSV file required" });
    const csv = req.file.buffer.toString("utf8");
    const rows = parse(csv, { columns: true, skip_empty_lines: true, trim: true });
    const manifest = loadManifest();
    const today = (/* @__PURE__ */ new Date()).toISOString().slice(0, 10);
    let count = 0;
    for (const r of rows) {
      const id = kebab(r.id || r.name);
      if (!id) continue;
      const item = {
        id,
        name: r.name || `Business Plan \u2014 ${id}`,
        category: r.category || "General",
        tags: (r.tags || "").split("|").map((t) => t.trim()).filter(Boolean),
        previewUrl: r.previewUrl,
        docxUrl: r.docxUrl,
        updatedAt: r.updatedAt || today,
        sections: (r.sections || "").split("|").map((t) => t.trim()).filter(Boolean)
      };
      if (!item.previewUrl || !item.docxUrl) continue;
      upsert(manifest.items, item);
      count++;
    }
    saveManifest(manifest);
    res.json({ ok: true, imported: count, total: manifest.items.length });
  } catch (e) {
    console.error(e);
    res.status(500).json({ error: e?.message || "Server error" });
  }
});
var bpImportCsv_default = router12;

// server/routes/businessPlanTemplatesFirebase.ts
import { Router as Router11 } from "express";
import formidable3 from "formidable";

// server/services/businessPlanTemplates.ts
init_firebaseAdmin2();
import { FieldValue } from "firebase-admin/firestore";
var BusinessPlanTemplateService = class {
  bucket;
  db;
  constructor() {
    this.bucket = bucket;
    this.db = db;
    console.log("[BusinessPlanTemplates] Using bucket:", this.bucket.name);
  }
  /**
   * Upload DOCX file to Firebase Storage
   * SN's path: templates/business-plan/docs/<slug>/<slug>-<version>.docx
   */
  async uploadDocx(slug, version, buffer) {
    const filePath = `templates/business-plan/docs/${slug}/${slug}-${version}.docx`;
    const file2 = this.bucket.file(filePath);
    await file2.save(buffer, {
      metadata: {
        contentType: "application/vnd.openxmlformats-officedocument.wordprocessingml.document",
        cacheControl: "public, max-age=3600"
      },
      public: true
    });
    await file2.makePublic();
    return filePath;
  }
  /**
   * Upload PDF file to Firebase Storage
   * SN's path: templates/business-plan/pdfs/<slug>/<slug>-<version>.pdf
   */
  async uploadPdf(slug, version, buffer) {
    const filePath = `templates/business-plan/pdfs/${slug}/${slug}-${version}.pdf`;
    const file2 = this.bucket.file(filePath);
    await file2.save(buffer, {
      metadata: {
        contentType: "application/pdf",
        cacheControl: "public, max-age=3600"
      },
      public: true
    });
    await file2.makePublic();
    return filePath;
  }
  /**
   * Upload preview image (WebP) to Firebase Storage
   * SN's path: templates/business-plan/previews/<slug>/<slug>-<version>-preview.webp
   */
  async uploadPreviewImage(slug, version, buffer) {
    const filePath = `templates/business-plan/previews/${slug}/${slug}-${version}-preview.webp`;
    const file2 = this.bucket.file(filePath);
    await file2.save(buffer, {
      metadata: {
        contentType: "image/webp",
        cacheControl: "public, max-age=31536000"
        // 1 year for images
      },
      public: true
    });
    await file2.makePublic();
    return filePath;
  }
  /**
   * Upload thumbnail image (WebP) to Firebase Storage
   * SN's canonical path: templates/business-plan/thumbs/<slug>/<slug>-<version>-thumb.webp
   */
  async uploadThumbImage(slug, version, buffer) {
    const filePath = `templates/business-plan/thumbs/${slug}/${slug}-${version}-thumb.webp`;
    const file2 = this.bucket.file(filePath);
    await file2.save(buffer, {
      metadata: {
        contentType: "image/webp",
        cacheControl: "public, max-age=31536000"
        // 1 year for images
      },
      public: true
    });
    await file2.makePublic();
    return filePath;
  }
  /**
   * Create or update template metadata in Firestore
   * SN's path: templates/business-plan/types/<slug>
   */
  async saveMetadata(metadata) {
    const docRef = this.db.collection("templates").doc("business-plan").collection("types").doc(metadata.slug);
    await docRef.set(metadata, { merge: true });
  }
  /**
   * Get template metadata from Firestore
   * SN's path: templates/business-plan/types/<slug>
   */
  async getMetadata(slug) {
    const docRef = this.db.collection("templates").doc("business-plan").collection("types").doc(slug);
    const doc = await docRef.get();
    if (!doc.exists) {
      return null;
    }
    return doc.data();
  }
  /**
   * Update template metadata (title, category, tags/industries)
   */
  async updateMetadata(slug, updates) {
    const docRef = this.db.collection("templates").doc("business-plan").collection("types").doc(slug);
    await docRef.update({
      ...updates,
      updatedAt: FieldValue.serverTimestamp()
    });
  }
  /**
   * List all active templates from Firestore
   */
  async listTemplates() {
    const snapshot = await this.db.collection("templates").doc("business-plan").collection("types").where("isActive", "==", true).get();
    return snapshot.docs.map((doc) => doc.data());
  }
  /**
   * Save version subdocument
   * SN's path: templates/business-plan/types/<slug>/versions/<version>
   */
  async saveVersion(slug, versionData) {
    const versionRef = this.db.collection("templates").doc("business-plan").collection("types").doc(slug).collection("versions").doc(versionData.version);
    await versionRef.set(versionData);
  }
  /**
   * Atomic master template flag management
   * Implements SN's transaction requirement:
   * 1. Set isMaster: false on all other templates AND their versions
   * 2. Set isMaster: true on the target template and target version
   * 3. Update global settings document
   */
  async setMasterTemplate(slug, version) {
    await this.db.runTransaction(async (transaction) => {
      const typesRef = this.db.collection("templates").doc("business-plan").collection("types");
      const settingsRef = this.db.collection("settings").doc("templates");
      const targetRef = typesRef.doc(slug);
      const targetVersionsRef = targetRef.collection("versions");
      const snapshot = await transaction.get(typesRef);
      const targetVersionsSnapshot = await transaction.get(targetVersionsRef);
      snapshot.docs.forEach((doc) => {
        if (doc.id !== slug && doc.data().isMaster) {
          transaction.update(doc.ref, { isMaster: false });
        }
      });
      transaction.update(targetRef, {
        isMaster: true,
        currentVersion: version,
        updatedAt: FieldValue.serverTimestamp()
      });
      targetVersionsSnapshot.docs.forEach((versionDoc) => {
        transaction.update(versionDoc.ref, { isMaster: false });
      });
      const targetVersionRef = targetVersionsRef.doc(version);
      transaction.update(targetVersionRef, { isMaster: true });
      transaction.set(settingsRef, {
        "business-plan": {
          masterSlug: slug,
          masterVersion: version,
          lastRotatedAt: FieldValue.serverTimestamp()
        }
      }, { merge: true });
    });
  }
  /**
   * Generate Google Docs viewer URL
   */
  generateGDocsUrl(docxUrl) {
    return `https://docs.google.com/gview?embedded=1&url=${encodeURIComponent(docxUrl)}`;
  }
  /**
   * Generate signed download URL for public access
   * Expires in 1 hour
   */
  async getSignedDownloadUrl(storagePath, filename) {
    const file2 = this.storage.file(storagePath);
    const [url] = await file2.getSignedUrl({
      action: "read",
      expires: Date.now() + 60 * 60 * 1e3,
      // 1 hour
      responseDisposition: `attachment; filename="${filename}.docx"`
    });
    return url;
  }
  /**
   * Delete template completely (Firestore + Storage)
   */
  async deleteTemplate(slug) {
    const templateRef = this.db.collection("templates").doc("business-plan").collection("types").doc(slug);
    const templateDoc = await templateRef.get();
    if (!templateDoc.exists) {
      throw new Error(`Template ${slug} not found`);
    }
    const data = templateDoc.data();
    const pathsToDelete = [];
    if (data?.storagePaths?.docx) pathsToDelete.push(data.storagePaths.docx);
    if (data?.storagePaths?.pdf) pathsToDelete.push(data.storagePaths.pdf);
    if (data?.storagePaths?.preview) pathsToDelete.push(data.storagePaths.preview);
    if (data?.storagePaths?.thumb) pathsToDelete.push(data.storagePaths.thumb);
    const prefixes = [
      `templates/business-plan/docs/${slug}/`,
      `templates/business-plan/pdfs/${slug}/`,
      `templates/business-plan/previews/${slug}/`,
      `templates/business-plan/thumbs/${slug}/`
    ];
    for (const prefix of prefixes) {
      try {
        const [files] = await this.bucket.getFiles({ prefix });
        for (const file2 of files) {
          await file2.delete();
          console.log(`\u{1F5D1}\uFE0F Deleted: ${file2.name}`);
        }
      } catch (error) {
        console.warn(`Warning: Could not delete files with prefix ${prefix}:`, error);
      }
    }
    const versionsRef = templateRef.collection("versions");
    const versionsSnapshot = await versionsRef.get();
    for (const versionDoc of versionsSnapshot.docs) {
      await versionDoc.ref.delete();
    }
    await templateRef.delete();
    if (data?.isMaster) {
      const settingsRef = this.db.collection("settings").doc("templates");
      await settingsRef.set({
        "business-plan": {
          masterSlug: null,
          masterVersion: null,
          lastRotatedAt: FieldValue.serverTimestamp()
        }
      }, { merge: true });
    }
    console.log(`\u2705 Template ${slug} deleted completely`);
  }
};
var businessPlanTemplateService = new BusinessPlanTemplateService();
function docToTemplate(data, id) {
  return {
    title: data.title,
    slug: data.slug ?? id,
    category: data.category ?? "General",
    industries: data.industries || data.tags || [],
    tags: data.tags || [],
    isActive: data.isActive ?? true,
    isMaster: data.isMaster ?? false,
    currentVersion: data.currentVersion ?? null,
    storagePaths: data.storagePaths || {},
    sections: data.sections || [],
    createdAt: data.createdAt || null,
    updatedAt: data.updatedAt || null
  };
}
async function listBusinessPlanTemplates() {
  const snap = await db.collection("templates").doc("business-plan").collection("types").where("isActive", "==", true).get();
  return snap.docs.map((d) => docToTemplate(d.data(), d.id));
}
async function getMasterBusinessPlanTemplate() {
  const pointer = await db.collection("settings").doc("templates").get();
  if (pointer.exists) {
    const data = pointer.data();
    const slug = data?.["business-plan"]?.masterSlug;
    if (slug) {
      const doc = await db.collection("templates").doc("business-plan").collection("types").doc(slug).get();
      if (doc.exists) return docToTemplate(doc.data(), doc.id);
    }
  }
  const q = await db.collection("templates").doc("business-plan").collection("types").where("isMaster", "==", true).limit(1).get();
  if (q.empty) return null;
  const d = q.docs[0];
  return docToTemplate(d.data(), d.id);
}
async function getBusinessPlanTemplateBySlug(slug) {
  const doc = await db.collection("templates").doc("business-plan").collection("types").doc(slug).get();
  return doc.exists ? docToTemplate(doc.data(), doc.id) : null;
}

// server/services/businessPlanPreviewGenerator.ts
import sharp3 from "sharp";
var BusinessPlanPreviewGenerator = class {
  /**
   * TODO: Convert DOCX to PDF using LibreOffice headless
   * Command: soffice --headless --convert-to pdf --outdir <dir> <docx>
   * When implemented, this will enable real document conversion instead of placeholder previews
   */
  async convertDocxToPdf(docxBuffer) {
    throw new Error("TODO: Implement LibreOffice DOCX \u2192 PDF conversion");
  }
  /**
   * TODO: Convert PDF pages to JPEG images using Poppler or Ghostscript
   * Poppler command: pdftoppm -jpeg -r 150 <pdf> <output-prefix>
   * Ghostscript command: gs -dBATCH -dNOPAUSE -sDEVICE=jpeg -r150 -sOutputFile=page-%d.jpg <pdf>
   * When implemented, this will extract real preview images from PDFs
   */
  async pdfToJpegPages(pdfBuffer) {
    throw new Error("TODO: Implement Poppler/Ghostscript PDF \u2192 JPEG conversion");
  }
  /**
   * Generate preview images from DOCX content
   * Current: Generates styled placeholder images using Sharp
   * SN's spec: Output WebP format
   * - Preview: 1024px wide (full preview)
   * - Thumb: 360px wide (card thumbnail)
   */
  async generatePreviewPages(title, category, sections) {
    const previewWidth = 1024;
    const thumbWidth = 360;
    const aspectRatio = 1.294;
    const previewHeight = Math.round(previewWidth * aspectRatio);
    const thumbHeight = Math.round(thumbWidth * aspectRatio);
    const coverSvg = this.generateCoverPage(title, category, previewWidth, previewHeight);
    const previewBuffer = await sharp3(Buffer.from(coverSvg)).webp({ quality: 85 }).toBuffer();
    const thumbBuffer = await sharp3(Buffer.from(coverSvg)).resize(thumbWidth, thumbHeight).webp({ quality: 80 }).toBuffer();
    return { preview: previewBuffer, thumb: thumbBuffer };
  }
  generateCoverPage(title, category, width, height) {
    const escapedTitle = this.escapeXml(title);
    const escapedCategory = this.escapeXml(category);
    return `
      <svg width="${width}" height="${height}" xmlns="http://www.w3.org/2000/svg">
        <defs>
          <linearGradient id="grad" x1="0%" y1="0%" x2="0%" y2="100%">
            <stop offset="0%" style="stop-color:#1e3a5f;stop-opacity:1" />
            <stop offset="100%" style="stop-color:#2d5a8a;stop-opacity:1" />
          </linearGradient>
        </defs>
        
        <rect width="${width}" height="${height}" fill="url(#grad)"/>
        <rect x="0" y="${height * 0.15}" width="${width}" height="8" fill="#ff8800"/>
        
        <text x="${width / 2}" y="${height * 0.35}" 
              font-family="Arial, sans-serif" font-size="48" font-weight="bold" 
              fill="#ffffff" text-anchor="middle">BUSINESS PLAN</text>
        
        <text x="${width / 2}" y="${height * 0.45}" 
              font-family="Arial, sans-serif" font-size="36" 
              fill="#ffffff" text-anchor="middle">${escapedTitle}</text>
        
        <line x1="${width * 0.3}" y1="${height * 0.5}" x2="${width * 0.7}" y2="${height * 0.5}" 
              stroke="#ffffff" stroke-width="2"/>
        
        <text x="${width / 2}" y="${height * 0.85}" 
              font-family="Arial, sans-serif" font-size="18" 
              fill="#cccccc" text-anchor="middle">${escapedCategory}</text>
        
        <text x="${width / 2}" y="${height * 0.9}" 
              font-family="Arial, sans-serif" font-size="16" 
              fill="#cccccc" text-anchor="middle">Professional Business Plan Template</text>
      </svg>
    `;
  }
  generateContentPage(sectionTitle, planTitle, width, height) {
    const escapedSection = this.escapeXml(sectionTitle.toUpperCase());
    const escapedPlanTitle = this.escapeXml(planTitle);
    const contentItems = [
      "Overview and introduction",
      "Key strategies and approaches",
      "Detailed analysis",
      "Future considerations"
    ];
    const contentBlocks = contentItems.map((item, i) => {
      const y = 280 + i * 120;
      return `
        <rect x="80" y="${y}" width="640" height="80" fill="#f5f5f5" rx="8"/>
        <text x="100" y="${y + 45}" font-family="Arial, sans-serif" font-size="20" fill="#333333">${this.escapeXml(item)}</text>
        <line x1="100" y1="${y + 60}" x2="720" y2="${y + 60}" stroke="#e0e0e0" stroke-width="1"/>
      `;
    }).join("");
    return `
      <svg width="${width}" height="${height}" xmlns="http://www.w3.org/2000/svg">
        <rect width="${width}" height="${height}" fill="#ffffff"/>
        
        <!-- Header -->
        <rect x="0" y="0" width="${width}" height="120" fill="#1e3a5f"/>
        <rect x="0" y="120" width="${width}" height="6" fill="#ff8800"/>
        
        <text x="${width / 2}" y="75" 
              font-family="Arial, sans-serif" font-size="32" font-weight="bold" 
              fill="#ffffff" text-anchor="middle">${escapedSection}</text>
        
        <!-- Content sections -->
        ${contentBlocks}
        
        <!-- Footer -->
        <rect x="0" y="${height - 60}" width="${width}" height="60" fill="#f8f8f8"/>
        <text x="${width / 2}" y="${height - 25}" 
              font-family="Arial, sans-serif" font-size="14" 
              fill="#666666" text-anchor="middle">${escapedPlanTitle} Business Plan</text>
      </svg>
    `;
  }
  escapeXml(text2) {
    return text2.replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;").replace(/'/g, "&apos;");
  }
};
var previewGenerator = new BusinessPlanPreviewGenerator();

// server/routes/businessPlanTemplatesFirebase.ts
var router13 = Router11();
router13.post("/upload", async (req, res) => {
  const form = formidable3({ keepExtensions: true, maxFileSize: 50 * 1024 * 1024 });
  form.parse(req, async (err, fields, files) => {
    if (err) {
      return res.status(400).json({ error: err.message });
    }
    try {
      const title = String(fields.title || "");
      const category = String(fields.category || "");
      const tags = String(fields.tags || "").split(",").map((t) => t.trim()).filter(Boolean);
      const sections = String(fields.sections || "").split("\n").map((s) => s.trim()).filter(Boolean);
      console.log("\u{1F4CB} Upload form data:", { title, category, tags, sections: sections.length });
      if (!title || !category) {
        return res.status(400).json({ error: "Title and category are required" });
      }
      const docxFileRaw = files.docx;
      const docxFile = Array.isArray(docxFileRaw) ? docxFileRaw[0] : docxFileRaw;
      const pdfFileRaw = files.pdf;
      const pdfFile = Array.isArray(pdfFileRaw) ? pdfFileRaw[0] : pdfFileRaw;
      console.log("\u{1F4C1} Upload debug:", {
        hasDocxRaw: !!docxFileRaw,
        hasPdfRaw: !!pdfFileRaw,
        isArray: Array.isArray(docxFileRaw),
        docxFile: docxFile ? {
          originalFilename: docxFile.originalFilename,
          newFilename: docxFile.newFilename,
          mimetype: docxFile.mimetype,
          size: docxFile.size
        } : null,
        pdfFile: pdfFile ? {
          originalFilename: pdfFile.originalFilename,
          newFilename: pdfFile.newFilename,
          mimetype: pdfFile.mimetype,
          size: pdfFile.size
        } : null,
        allFileKeys: Object.keys(files)
      });
      if (!docxFile) {
        return res.status(400).json({ error: "DOCX file is required" });
      }
      if (!pdfFile) {
        return res.status(400).json({ error: "PDF file is required" });
      }
      const docxFilename = docxFile.originalFilename || docxFile.newFilename || "";
      const isDocx = docxFilename.toLowerCase().endsWith(".docx");
      if (!isDocx) {
        return res.status(400).json({
          error: "File must be a valid DOCX document",
          debug: { filename: docxFilename, isDocx }
        });
      }
      const pdfFilename = pdfFile.originalFilename || pdfFile.newFilename || "";
      const isPdf = pdfFilename.toLowerCase().endsWith(".pdf");
      if (!isPdf) {
        return res.status(400).json({
          error: "File must be a valid PDF document",
          debug: { filename: pdfFilename, isPdf }
        });
      }
      const fs12 = await import("fs");
      const docxBuffer = fs12.readFileSync(docxFile.filepath);
      const pdfBuffer = fs12.readFileSync(pdfFile.filepath);
      const slug = title.toLowerCase().replace(/[^a-z0-9]+/g, "-").replace(/^-|-$/g, "");
      const version = "v1";
      const metadata = {
        slug,
        title,
        category,
        isActive: true,
        isMaster: false,
        // Will be set via transaction
        currentVersion: version,
        storagePaths: {
          docx: "",
          pdf: "",
          preview: "",
          thumb: ""
        },
        tags,
        sections: sections.length > 0 ? sections : ["Executive Summary", "Market Analysis", "Financial Projections"],
        createdAt: null,
        // Will be set to serverTimestamp
        updatedAt: null
      };
      await businessPlanTemplateService.saveMetadata(metadata);
      processTemplate(slug, version, title, category, tags, sections, docxBuffer, pdfBuffer).catch(console.error);
      res.json({
        ok: true,
        slug,
        message: "Template upload started. Processing previews..."
      });
    } catch (error) {
      console.error("Business plan template upload error:", error);
      res.status(500).json({ error: error?.message || "Upload failed" });
    }
  });
});
router13.get("/list", async (req, res) => {
  try {
    const templates = await businessPlanTemplateService.listTemplates();
    res.json({ items: templates });
  } catch (error) {
    console.error("Error fetching templates:", error);
    res.status(500).json({ error: error?.message || "Failed to fetch templates" });
  }
});
router13.get("/:slug", async (req, res) => {
  try {
    const { slug } = req.params;
    const metadata = await businessPlanTemplateService.getMetadata(slug);
    if (!metadata) {
      return res.status(404).json({ error: "Template not found" });
    }
    res.json(metadata);
  } catch (error) {
    console.error("Error fetching template:", error);
    res.status(500).json({ error: error?.message || "Failed to fetch template" });
  }
});
async function processTemplate(slug, version, title, category, tags, sections, docxBuffer, pdfBuffer) {
  try {
    const docxPath = await businessPlanTemplateService.uploadDocx(slug, version, docxBuffer);
    const pdfPath = await businessPlanTemplateService.uploadPdf(slug, version, pdfBuffer);
    const { preview, thumb } = await previewGenerator.generatePreviewPages(
      title,
      category,
      sections
    );
    const previewPath = await businessPlanTemplateService.uploadPreviewImage(slug, version, preview);
    const thumbPath = await businessPlanTemplateService.uploadThumbImage(slug, version, thumb);
    const { FieldValue: FieldValue2 } = await import("firebase-admin/firestore");
    const updatedMetadata = {
      slug,
      title,
      category,
      isActive: true,
      isMaster: false,
      // Set via transaction below
      currentVersion: version,
      storagePaths: {
        docx: docxPath,
        pdf: pdfPath,
        preview: previewPath,
        thumb: thumbPath
      },
      tags,
      sections,
      createdAt: FieldValue2.serverTimestamp(),
      updatedAt: FieldValue2.serverTimestamp()
    };
    await businessPlanTemplateService.saveMetadata(updatedMetadata);
    const versionData = {
      version,
      isMaster: false,
      // Will be set to true by setMasterTemplate transaction
      notes: `Initial release of ${title}`,
      storagePaths: {
        docx: docxPath,
        pdf: pdfPath,
        preview: previewPath,
        thumb: thumbPath
      },
      sections,
      createdAt: FieldValue2.serverTimestamp()
    };
    await businessPlanTemplateService.saveVersion(slug, versionData);
    await businessPlanTemplateService.setMasterTemplate(slug, version);
    console.log(`\u2705 Template ${slug} ${version} processed and set as master successfully`);
  } catch (error) {
    console.error(`\u274C Error processing template ${slug}:`, error);
  }
}
router13.patch("/:slug", async (req, res) => {
  try {
    const { slug } = req.params;
    const { title, category, industries } = req.body;
    if (!slug) {
      return res.status(400).json({ error: "Slug is required" });
    }
    const updates = {};
    if (title) updates.title = title;
    if (category) updates.category = category;
    if (industries) {
      updates.tags = typeof industries === "string" ? industries.split(",").map((i) => i.trim()).filter(Boolean) : industries;
    }
    await businessPlanTemplateService.updateMetadata(slug, updates);
    res.json({
      ok: true,
      message: `Template ${slug} updated successfully`
    });
  } catch (error) {
    console.error("Error updating template:", error);
    res.status(500).json({ error: error?.message || "Failed to update template" });
  }
});
router13.delete("/:slug", async (req, res) => {
  try {
    const { slug } = req.params;
    if (!slug) {
      return res.status(400).json({ error: "Slug is required" });
    }
    await businessPlanTemplateService.deleteTemplate(slug);
    res.json({
      ok: true,
      message: `Template ${slug} deleted successfully`
    });
  } catch (error) {
    console.error("Error deleting template:", error);
    res.status(500).json({ error: error?.message || "Failed to delete template" });
  }
});
var businessPlanTemplatesFirebase_default = router13;

// server/routes/bpTemplatesPublic.ts
import express3 from "express";

// server/services/downloadUrl.ts
init_firebaseAdmin2();
import https from "https";
var TEST_TTL_MS = 10 * 60 * 1e3;
var lastMode = null;
var lastChecked = 0;
function publicUrl(storagePath) {
  const bkt = bucket.name;
  return `https://firebasestorage.googleapis.com/v0/b/${bkt}/o/${encodeURIComponent(storagePath)}?alt=media`;
}
async function head(url) {
  return new Promise((resolve) => {
    const req = https.request(url, { method: "HEAD" }, (res) => {
      resolve(res.statusCode || 0);
    });
    req.on("error", () => resolve(0));
    req.end();
  });
}
async function signedUrl(storagePath, ttlSeconds = 900) {
  const file2 = bucket.file(storagePath);
  const [url] = await file2.getSignedUrl({
    version: "v4",
    action: "read",
    expires: Date.now() + ttlSeconds * 1e3,
    responseDisposition: `attachment; filename="${storagePath.split("/").pop()}"`
  });
  return url;
}
async function signedUrlInline(storagePath, ttlSeconds = 900) {
  const file2 = bucket.file(storagePath);
  const [url] = await file2.getSignedUrl({
    version: "v4",
    action: "read",
    expires: Date.now() + ttlSeconds * 1e3,
    responseDisposition: "inline"
  });
  return url;
}
async function getDownloadUrlAuto(storagePath) {
  const now = Date.now();
  if (lastMode && now - lastChecked < TEST_TTL_MS) {
    return lastMode === "public" ? publicUrl(storagePath) : signedUrl(storagePath);
  }
  const url = publicUrl(storagePath);
  const status = await head(url);
  if (status === 200) {
    lastMode = "public";
    lastChecked = now;
    return url;
  }
  lastMode = "signed";
  lastChecked = now;
  return signedUrl(storagePath);
}
async function getViewerUrlAuto(storagePath) {
  return signedUrlInline(storagePath);
}

// server/services/analytics.ts
import { createHash } from "crypto";
import { getFirestore as getFirestore2 } from "firebase-admin/firestore";
async function logDownloadEvent(event) {
  try {
    const db2 = getFirestore2();
    const eventData = {
      slug: event.slug,
      version: event.version,
      mode: event.mode,
      ts: Date.now()
    };
    if (event.userAgent) {
      eventData.ua = event.userAgent;
    }
    if (event.referrer) {
      eventData.ref = event.referrer;
    }
    if (event.ip) {
      eventData.ipHash = createHash("sha256").update(event.ip).digest("hex");
    }
    await db2.collection("analytics").doc("downloads").collection("events").add(eventData);
  } catch (err) {
    console.error("[Analytics] Failed to log download event:", err);
  }
}

// server/routes/bpTemplatesPublic.ts
var router14 = express3.Router();
router14.get("/list", async (_req, res) => {
  try {
    const items = await listBusinessPlanTemplates();
    const dto = await Promise.all(items.map(async (t) => {
      const previewUrl = t.storagePaths?.preview ? await getDownloadUrlAuto(t.storagePaths.preview) : null;
      const thumbUrl = t.storagePaths?.thumb ? await getDownloadUrlAuto(t.storagePaths.thumb) : null;
      const docxUrl = t.storagePaths?.docx ? await getDownloadUrlAuto(t.storagePaths.docx) : null;
      const pdfUrl = t.storagePaths?.pdf ? await getDownloadUrlAuto(t.storagePaths.pdf) : null;
      const viewerUrl = t.storagePaths?.pdf ? await getViewerUrlAuto(t.storagePaths.pdf) : t.storagePaths?.docx ? await getViewerUrlAuto(t.storagePaths.docx) : null;
      return {
        title: t.title,
        slug: t.slug,
        category: t.category,
        tags: t.tags || [],
        industries: t.industries || [],
        sections: t.sections || [],
        isMaster: !!t.isMaster,
        currentVersion: t.currentVersion,
        storagePaths: {
          preview: previewUrl,
          thumb: thumbUrl,
          docx: docxUrl,
          pdf: pdfUrl
        },
        viewerUrl,
        updatedAt: t.updatedAt || null
      };
    }));
    res.set("Cache-Control", "public, max-age=60");
    res.json(dto);
  } catch (err) {
    console.error("[public:list] error", err);
    res.status(500).json({ error: "Failed to list templates" });
  }
});
router14.get("/master", async (_req, res) => {
  try {
    const t = await getMasterBusinessPlanTemplate();
    if (!t) return res.status(404).json({ error: "No master template found" });
    const originalPdfPath = t.storagePaths?.pdf;
    const originalDocxPath = t.storagePaths?.docx;
    if (t.storagePaths?.preview) {
      t.storagePaths.preview = await getDownloadUrlAuto(t.storagePaths.preview);
    }
    if (t.storagePaths?.thumb) {
      t.storagePaths.thumb = await getDownloadUrlAuto(t.storagePaths.thumb);
    }
    if (t.storagePaths?.docx) {
      t.storagePaths.docx = await getDownloadUrlAuto(t.storagePaths.docx);
    }
    if (t.storagePaths?.pdf) {
      t.storagePaths.pdf = await getDownloadUrlAuto(t.storagePaths.pdf);
    }
    const viewerUrl = originalPdfPath ? await getViewerUrlAuto(originalPdfPath) : originalDocxPath ? await getViewerUrlAuto(originalDocxPath) : null;
    res.set("Cache-Control", "public, max-age=60");
    res.json({ ...t, viewerUrl });
  } catch (err) {
    console.error("[public:master] error", err);
    res.status(500).json({ error: "Failed to resolve master template" });
  }
});
router14.get("/:slug", async (req, res) => {
  try {
    const t = await getBusinessPlanTemplateBySlug(req.params.slug);
    if (!t) return res.status(404).json({ error: "Template not found" });
    const originalPdfPath = t.storagePaths?.pdf;
    const originalDocxPath = t.storagePaths?.docx;
    if (t.storagePaths?.preview) {
      t.storagePaths.preview = await getDownloadUrlAuto(t.storagePaths.preview);
    }
    if (t.storagePaths?.thumb) {
      t.storagePaths.thumb = await getDownloadUrlAuto(t.storagePaths.thumb);
    }
    if (t.storagePaths?.docx) {
      t.storagePaths.docx = await getDownloadUrlAuto(t.storagePaths.docx);
    }
    if (t.storagePaths?.pdf) {
      t.storagePaths.pdf = await getDownloadUrlAuto(t.storagePaths.pdf);
    }
    const viewerUrl = originalPdfPath ? await getViewerUrlAuto(originalPdfPath) : originalDocxPath ? await getViewerUrlAuto(originalDocxPath) : null;
    res.set("Cache-Control", "public, max-age=60");
    res.json({ ...t, viewerUrl });
  } catch (err) {
    console.error("[public:getBySlug] error", err);
    res.status(500).json({ error: "Failed to fetch template" });
  }
});
router14.get("/:slug/download", async (req, res) => {
  try {
    const t = await getBusinessPlanTemplateBySlug(req.params.slug);
    if (!t) return res.status(404).json({ error: "Template not found" });
    const docxPath = t.storagePaths?.docx;
    if (!docxPath) return res.status(400).json({ error: "Template has no DOCX path" });
    const url = await getDownloadUrlAuto(docxPath);
    const mode = url.includes("token=") ? "signed" : "public";
    logDownloadEvent({
      slug: t.slug,
      version: t.currentVersion || "1.0",
      mode,
      userAgent: req.headers["user-agent"],
      referrer: req.headers.referer || req.headers.referrer,
      ip: req.ip || req.socket.remoteAddress
    }).catch((err) => console.error("[Analytics] Log failed:", err));
    res.set("Cache-Control", "public, max-age=60");
    return res.redirect(302, url);
  } catch (err) {
    console.error("[public:download] error", err);
    res.status(500).json({ error: "Failed to generate download URL" });
  }
});
router14.get("/:slug/debug-all", async (req, res) => {
  try {
    const { bucket: bucket2 } = await Promise.resolve().then(() => (init_firebaseAdmin2(), firebaseAdmin_exports));
    const slug = req.params.slug;
    const prefix = `templates/business-plan/`;
    const [files] = await bucket2.getFiles({ prefix });
    const related = files.filter((f) => f.name.includes(slug)).map((f) => ({
      name: f.name,
      publicUrl: `https://storage.googleapis.com/${bucket2.name}/${f.name}`
    }));
    res.json({ count: related.length, files: related });
  } catch (err) {
    res.status(500).json({ error: err.message });
  }
});
var bpTemplatesPublic_default = router14;

// server/routes/healthBpTemplates.ts
import express4 from "express";
import https2 from "https";
import { URL as URL2 } from "url";
var router15 = express4.Router();
function head2(url) {
  return new Promise((resolve) => {
    try {
      const u = new URL2(url);
      const req = https2.request(
        {
          method: "HEAD",
          hostname: u.hostname,
          path: u.pathname + (u.search || ""),
          protocol: u.protocol
        },
        (res) => {
          resolve(res.statusCode || 0);
        }
      );
      req.on("error", () => resolve(0));
      req.end();
    } catch {
      resolve(0);
    }
  });
}
router15.get("/bp-templates", async (_req, res) => {
  const started = Date.now();
  try {
    const master = await getMasterBusinessPlanTemplate();
    if (!master) {
      return res.status(503).json({ ok: false, error: "No master template set" });
    }
    const slug = master.slug;
    const version = master.currentVersion || "unknown";
    const docxPath = master.storagePaths?.docx || "";
    const previewPath = master.storagePaths?.preview || "";
    const thumbPath = master.storagePaths?.thumb || "";
    const docxUrl = docxPath ? await getDownloadUrlAuto(docxPath) : "";
    const previewUrl = previewPath ? await getDownloadUrlAuto(previewPath) : "";
    const thumbUrl = thumbPath ? await getDownloadUrlAuto(thumbPath) : "";
    const [docxStatus, previewStatus, thumbStatus] = await Promise.all([
      docxUrl ? head2(docxUrl) : Promise.resolve(0),
      previewUrl ? head2(previewUrl) : Promise.resolve(0),
      thumbUrl ? head2(thumbUrl) : Promise.resolve(0)
    ]);
    const mode = docxUrl.includes("X-Goog-Algorithm=") ? "signed" : "public";
    const payload = {
      ok: docxStatus === 200,
      time: (/* @__PURE__ */ new Date()).toISOString(),
      ms: Date.now() - started,
      master: {
        slug,
        version,
        isMaster: !!master.isMaster
      },
      storagePaths: { docxPath, previewPath, thumbPath },
      urls: { docxUrl, previewUrl, thumbUrl, mode },
      statuses: { docxStatus, previewStatus, thumbStatus }
    };
    const statusCode = payload.ok ? 200 : 503;
    res.set("Cache-Control", "no-cache, no-store, must-revalidate");
    return res.status(statusCode).json(payload);
  } catch (error) {
    return res.status(500).json({ ok: false, error: error?.message || "Health check failed" });
  }
});
var healthBpTemplates_default = router15;

// server/routes.ts
init_objectStorage();
init_firebaseAdmin();

// server/middleware/visitorTracking.ts
init_storage();
import crypto from "crypto";
var locationCache = /* @__PURE__ */ new Map();
var cacheExpiry = 24 * 60 * 60 * 1e3;
var maxRequestsPerMinute = 10;
var requestCounts = /* @__PURE__ */ new Map();
var getServerSecret = () => {
  return process.env.VISITOR_HASH_SECRET || "default-dev-secret-change-in-production";
};
async function getIpLocation(ip) {
  const cached = locationCache.get(ip);
  if (cached && Date.now() - cached.timestamp < cacheExpiry) {
    return cached.data;
  }
  if (cached && Date.now() - cached.timestamp >= cacheExpiry) {
    locationCache.delete(ip);
  }
  if (isPrivateIP(ip)) {
    return null;
  }
  if (!checkRateLimit(ip)) {
    console.warn(`Rate limit exceeded for IP geolocation: ${ip}`);
    return null;
  }
  try {
    const controller = new AbortController();
    const timeoutId = setTimeout(() => controller.abort(), 5e3);
    const response = await fetch(`https://ipapi.co/${ip}/json/`, {
      signal: controller.signal,
      headers: {
        "User-Agent": "IBrandBiz-Analytics/1.0"
      }
    });
    clearTimeout(timeoutId);
    if (!response.ok) {
      console.warn(`IP geolocation API error for ${ip}:`, response.status);
      return null;
    }
    const data = await response.json();
    if (data.error) {
      console.warn(`IP geolocation error for ${ip}:`, data.reason);
      return null;
    }
    locationCache.set(ip, {
      data,
      timestamp: Date.now(),
      requestCount: 1
    });
    cleanupLocationCache();
    return data;
  } catch (error) {
    if (error.name === "AbortError") {
      console.warn(`Geolocation API timeout for IP ${ip}`);
    } else {
      console.warn(`Failed to get geolocation for IP ${ip}:`, error);
    }
    return null;
  }
}
function checkRateLimit(ip) {
  const now = Date.now();
  const minute = Math.floor(now / 6e4);
  const current = requestCounts.get(ip);
  if (!current || current.resetTime !== minute) {
    requestCounts.set(ip, { count: 1, resetTime: minute });
    return true;
  }
  if (current.count >= maxRequestsPerMinute) {
    return false;
  }
  current.count++;
  return true;
}
function cleanupLocationCache() {
  const now = Date.now();
  const maxSize = 1e3;
  for (const [key, entry] of locationCache) {
    if (now - entry.timestamp >= cacheExpiry) {
      locationCache.delete(key);
    }
  }
  if (locationCache.size > maxSize) {
    const entries = Array.from(locationCache.entries()).sort((a, b) => a[1].timestamp - b[1].timestamp);
    const toRemove = entries.slice(0, entries.length - maxSize);
    toRemove.forEach(([key]) => locationCache.delete(key));
  }
  const currentMinute = Math.floor(now / 6e4);
  for (const [ip, record] of requestCounts) {
    if (record.resetTime < currentMinute - 5) {
      requestCounts.delete(ip);
    }
  }
}
function isPrivateIP(ip) {
  const privateRanges = [
    /^127\./,
    // 127.0.0.1 (localhost)
    /^192\.168\./,
    // 192.168.x.x (private)
    /^10\./,
    // 10.x.x.x (private)
    /^172\.1[6-9]\./,
    // 172.16-19.x.x (private)
    /^172\.2[0-9]\./,
    // 172.20-29.x.x (private) 
    /^172\.3[0-1]\./,
    // 172.30-31.x.x (private)
    /^::1$/,
    // IPv6 localhost
    /^fc00:/,
    // IPv6 private
    /^fe80:/
    // IPv6 link-local
  ];
  return privateRanges.some((range) => range.test(ip));
}
function hashIP(ip) {
  const secret = getServerSecret();
  return crypto.createHash("sha256").update(`${ip}${secret}`).digest("hex");
}
function generateSessionId(ip, date, userAgent) {
  const data = `${ip}-${date}-${userAgent || "unknown"}`;
  return crypto.createHash("sha256").update(data).digest("hex").substring(0, 32);
}
function getClientIP(req) {
  const xForwardedFor = req.headers["x-forwarded-for"];
  const xRealIP = req.headers["x-real-ip"];
  const connectionRemoteAddress = req.connection?.remoteAddress;
  const socketRemoteAddress = req.socket?.remoteAddress;
  if (xForwardedFor) {
    return xForwardedFor.split(",")[0].trim();
  }
  if (xRealIP) {
    return xRealIP;
  }
  return connectionRemoteAddress || socketRemoteAddress || "unknown";
}
function isBot(userAgent) {
  const botPatterns = [
    // Search engine crawlers
    /googlebot/i,
    /bingbot/i,
    /slurp/i,
    /duckduckbot/i,
    /baiduspider/i,
    // Social media crawlers
    /facebookexternalhit/i,
    /twitterbot/i,
    /linkedinbot/i,
    /whatsapp/i,
    // Monitoring and security
    /pingdom/i,
    /uptimerobot/i,
    /statuscake/i,
    /site24x7/i,
    // Generic patterns
    /bot\b/i,
    /crawl/i,
    /spider/i,
    /scraper/i,
    /archiver/i,
    /curl/i,
    /wget/i,
    /python-requests/i,
    /node-fetch/i,
    // Headless browsers often used by bots
    /headlesschrome/i,
    /phantomjs/i,
    /puppeteer/i
  ];
  return botPatterns.some((pattern) => pattern.test(userAgent));
}
function isPublicPage(path13) {
  const normalizedPath = path13.split("?")[0].split("#")[0].replace(/\/+$/, "") || "/";
  const publicRoutes = [
    "/",
    "/about",
    "/pricing",
    "/services",
    "/contact",
    "/privacy",
    "/terms",
    "/features",
    "/help",
    "/faq",
    "/blog",
    "/resources"
  ];
  const excludePatterns = [
    /^\/api\//,
    /^\/admin/,
    /^\/auth/,
    /^\/assets/,
    /^\/static/,
    /^\/uploads/,
    /^\/_/,
    /^\/favicon/,
    /^\/robots/,
    /^\/sitemap/,
    /^\/\.well-known/,
    /\.(js|css|png|jpg|jpeg|gif|ico|svg|woff|woff2|ttf|eot|pdf|zip|txt|xml|json)$/i
  ];
  if (excludePatterns.some((pattern) => pattern.test(normalizedPath))) {
    return false;
  }
  return publicRoutes.some(
    (route) => normalizedPath === route || route !== "/" && normalizedPath.startsWith(route + "/")
  );
}
function isAuthenticatedAdmin(req) {
  const authHeader = req.headers.authorization;
  const sessionCookie = req.headers.cookie;
  return !!(authHeader && authHeader.includes("admin")) || !!(sessionCookie && sessionCookie.includes("admin"));
}
async function updateDailyStats(date, isNewUniqueVisitor, countryCode, pageUrl) {
  try {
    let stats = await storage.getDailyVisitorStatsByDate(date);
    if (!stats) {
      const newStats = {
        date,
        uniqueVisitors: isNewUniqueVisitor ? 1 : 0,
        totalPageViews: 1,
        countries: countryCode ? { [countryCode]: 1 } : {},
        topPages: pageUrl ? { [pageUrl]: 1 } : {}
      };
      await storage.createDailyVisitorStats(newStats);
    } else {
      const countries = { ...stats.countries || {} };
      const topPages = { ...stats.topPages || {} };
      if (countryCode) {
        countries[countryCode] = (countries[countryCode] || 0) + 1;
      }
      if (pageUrl) {
        topPages[pageUrl] = (topPages[pageUrl] || 0) + 1;
      }
      await storage.updateDailyVisitorStats(stats.id, {
        uniqueVisitors: stats.uniqueVisitors + (isNewUniqueVisitor ? 1 : 0),
        totalPageViews: stats.totalPageViews + 1,
        countries,
        topPages
      });
    }
  } catch (error) {
    console.error("Failed to update daily visitor stats:", error);
  }
}
async function trackVisitor(req, res, next) {
  if (!isPublicPage(req.path)) {
    return next();
  }
  const userAgent = req.headers["user-agent"] || "";
  if (isBot(userAgent)) {
    return next();
  }
  if (isAuthenticatedAdmin(req)) {
    return next();
  }
  try {
    const ip = getClientIP(req);
    const today = (/* @__PURE__ */ new Date()).toISOString().split("T")[0];
    const sessionId = generateSessionId(ip, today, userAgent);
    const ipHash = hashIP(ip);
    const pageUrl = req.path;
    const referrer = req.headers.referer || req.headers.referrer;
    let session = await storage.getVisitorSessionBySessionId(sessionId);
    let isNewUniqueVisitor = false;
    if (session) {
      await storage.updateVisitorSession(session.id, {
        pageViews: session.pageViews + 1,
        lastPageUrl: pageUrl,
        updatedAt: /* @__PURE__ */ new Date()
      });
    } else {
      isNewUniqueVisitor = true;
      const locationData = await getIpLocation(ip);
      const newSession = {
        sessionId,
        ipHash,
        // Store hashed IP instead of raw IP
        country: locationData?.country_name,
        countryCode: locationData?.country_code,
        city: locationData?.city,
        latitude: locationData?.latitude,
        // Now numeric as per schema
        longitude: locationData?.longitude,
        userAgent,
        pageViews: 1,
        firstPageUrl: pageUrl,
        lastPageUrl: pageUrl,
        referrer,
        isPublicPage: true,
        date: today
        // Track date for daily unique counting
      };
      await storage.createVisitorSession(newSession);
    }
    await updateDailyStats(
      today,
      isNewUniqueVisitor,
      session?.countryCode || (await getIpLocation(ip))?.country_code,
      pageUrl
    );
  } catch (error) {
    console.error("Visitor tracking error:", error);
  }
  next();
}

// server/routes.ts
init_schema();
import multer5 from "multer";
import { authenticator } from "otplib";
import * as crypto4 from "crypto";
import QRCode from "qrcode";

// server/ai-business-names.ts
import OpenAI from "openai";
var TRADEMARK_BLOCKLIST = [
  "apple",
  "google",
  "microsoft",
  "amazon",
  "facebook",
  "meta",
  "tesla",
  "netflix",
  "uber",
  "airbnb",
  "paypal",
  "visa",
  "mastercard",
  "walmart",
  "target",
  "starbucks"
];
var NSFW_BLOCKLIST = [
  "sex",
  "porn",
  "nude",
  "adult",
  "escort",
  "casino",
  "gambling",
  "drug",
  "weed",
  "marijuana",
  "cocaine",
  "heroin",
  "meth",
  "weapon",
  "gun",
  "bomb",
  "terror"
];
function normalizeString(str) {
  return str.trim().toLowerCase().replace(/\s+/g, "");
}
function isValidBusinessName(name) {
  return /^[a-zA-Z][a-zA-Z\s-]*[a-zA-Z]$/.test(name) && name.trim().split(/\s+/).length <= 2;
}
function filterBlocklists(names) {
  return names.filter((name) => {
    const normalized = normalizeString(name);
    if (TRADEMARK_BLOCKLIST.some((blocked) => normalized.includes(blocked))) {
      return false;
    }
    if (NSFW_BLOCKLIST.some((blocked) => normalized.includes(blocked))) {
      return false;
    }
    return true;
  });
}
function deduplicateNames(names) {
  const seen = /* @__PURE__ */ new Set();
  return names.filter((name) => {
    const normalized = normalizeString(name);
    if (seen.has(normalized)) {
      return false;
    }
    seen.add(normalized);
    return true;
  });
}
var openai = new OpenAI({
  apiKey: process.env.OPENAI_API_KEY
});
async function generateBusinessNames(request) {
  const {
    industry,
    keywords,
    style = "Modern",
    count = 12,
    creativity = 60,
    starts_with,
    must_include,
    must_exclude,
    length_range = [6, 10],
    // Default length range
    description,
    vibe
  } = request;
  const temperature = 0.2 + creativity / 100 * 0.8;
  const generateCount = Math.min(count * 2, 30);
  let businessContext = "";
  if (industry && keywords) {
    businessContext = `Generate ${generateCount} creative business names for a ${industry} business.`;
  } else if (industry) {
    businessContext = `Generate ${generateCount} creative business names for a ${industry} business.`;
  } else {
    businessContext = `Generate ${generateCount} creative business names inspired by these concepts.`;
  }
  let prompt = businessContext + `

Style: ${vibe || style || "Modern"}`;
  if (keywords) {
    prompt += `
Keywords to incorporate or inspire: ${keywords}`;
  }
  if (industry) {
    prompt += `
Industry/Category: ${industry}`;
  }
  if (description) {
    prompt += `
Business description: ${description}`;
  }
  prompt += `

Special Requirements:`;
  if (starts_with) {
    prompt += `
- ALL names MUST start with "${starts_with}"`;
  }
  if (must_include) {
    prompt += `
- Names MUST include one of these words: ${must_include}`;
  }
  if (must_exclude) {
    prompt += `
- Names MUST NOT contain any of these words: ${must_exclude}`;
  }
  if (length_range) {
    const [min, max] = length_range;
    prompt += `
- Names must be between ${min} and ${max} characters long`;
  }
  prompt += `

General Requirements:
- Focus on short, pronounceable patterns (CVVC/VCCV/CVCV)
- Keep names \u226410 characters unless specified otherwise
- Avoid numbers, symbols, and clich\xE9d terms
- Names should be memorable, brandable, and professional
- Mix of approaches: descriptive, invented, compound words
- Avoid trademark-like terms and existing brand names
- Each name should be 1-2 words maximum

Return ONLY a JSON array of strings (business names only):
["BusinessName1", "BusinessName2", "BusinessName3", ...]

Focus on creating names that:
- Sound professional and trustworthy
- Are easy to pronounce and remember${industry ? `
- Work well for ${industry} industry` : ""}
- Reflect ${vibe || style || "Modern"} style characteristics
- Can be inspired by: ${keywords}
- Are short and brandable (avoid long descriptive phrases)`;
  try {
    const completion = await openai.chat.completions.create({
      model: "gpt-4o-mini",
      messages: [
        {
          role: "system",
          content: "You are a professional brand naming expert. Generate creative, memorable business names that are brandable and professional. Always return valid JSON array format with only the business names as strings."
        },
        {
          role: "user",
          content: prompt
        }
      ],
      temperature,
      top_p: 0.9,
      max_tokens: 1e3
    });
    const content = completion.choices[0]?.message?.content;
    if (!content) {
      throw new Error("No response from OpenAI");
    }
    let rawNames;
    try {
      let cleanContent = content.trim();
      if (cleanContent.startsWith("```json")) {
        cleanContent = cleanContent.replace(/^```json\s*/, "").replace(/\s*```$/, "");
      }
      if (cleanContent.startsWith("```")) {
        cleanContent = cleanContent.replace(/^```\s*/, "").replace(/\s*```$/, "");
      }
      rawNames = JSON.parse(cleanContent);
      if (!Array.isArray(rawNames)) {
        throw new Error("Expected array of strings");
      }
      rawNames = rawNames.map((item) => typeof item === "string" ? item : String(item)).filter((name) => name && name.trim().length > 0).map((name) => name.trim());
    } catch (parseError) {
      console.error("Failed to parse OpenAI response:", content);
      rawNames = [
        "BrightPath",
        "NextGen",
        "Velocity",
        "Innovation",
        "DigitalForge",
        "Momentum",
        "CoreTech",
        "PrimeVenture",
        "SwiftFlow",
        "NovaLabs",
        "Zenith",
        "Catalyst",
        "Fusion",
        "Apex",
        "Vertex",
        "Matrix"
      ];
    }
    let processedNames = rawNames.filter(isValidBusinessName).slice();
    processedNames = filterBlocklists(processedNames);
    if (starts_with) {
      const startsWithLower = starts_with.toLowerCase().trim();
      processedNames = processedNames.filter(
        (name) => name.toLowerCase().startsWith(startsWithLower)
      );
    }
    if (must_include) {
      const includeWords = must_include.split(",").map((w) => w.trim().toLowerCase()).filter(Boolean);
      processedNames = processedNames.filter((name) => {
        const nameLower = name.toLowerCase();
        return includeWords.some((word) => nameLower.includes(word));
      });
    }
    if (must_exclude) {
      const excludeWords = must_exclude.split(",").map((w) => w.trim().toLowerCase()).filter(Boolean);
      processedNames = processedNames.filter((name) => {
        const nameLower = name.toLowerCase();
        return !excludeWords.some((word) => nameLower.includes(word));
      });
    }
    const [minLen, maxLen] = length_range;
    processedNames = processedNames.filter(
      (name) => name.length >= minLen && name.length <= maxLen
    );
    processedNames = deduplicateNames(processedNames);
    const finalCount = Math.min(count, 20);
    processedNames = processedNames.slice(0, finalCount);
    if (processedNames.length < finalCount) {
      const fallbacks = [
        "BrightCore",
        "NextFlow",
        "VelocityLab",
        "InnovateTech",
        "DigitalMint",
        "MomentumHub",
        "CoreStream",
        "PrimeForge",
        "SwiftNova",
        "ZenithLab",
        "CatalystFlow",
        "FusionCore",
        "ApexMint",
        "VertexHub",
        "MatrixLab"
      ].filter((name) => !processedNames.includes(name));
      let filteredFallbacks = fallbacks.filter(isValidBusinessName);
      filteredFallbacks = filterBlocklists(filteredFallbacks);
      if (starts_with) {
        const startsWithLower = starts_with.toLowerCase().trim();
        filteredFallbacks = filteredFallbacks.filter(
          (name) => name.toLowerCase().startsWith(startsWithLower)
        );
      }
      if (must_include) {
        const includeWords = must_include.split(",").map((w) => w.trim().toLowerCase()).filter(Boolean);
        filteredFallbacks = filteredFallbacks.filter((name) => {
          const nameLower = name.toLowerCase();
          return includeWords.some((word) => nameLower.includes(word));
        });
      }
      if (must_exclude) {
        const excludeWords = must_exclude.split(",").map((w) => w.trim().toLowerCase()).filter(Boolean);
        filteredFallbacks = filteredFallbacks.filter((name) => {
          const nameLower = name.toLowerCase();
          return !excludeWords.some((word) => nameLower.includes(word));
        });
      }
      filteredFallbacks = filteredFallbacks.filter(
        (name) => name.length >= minLen && name.length <= maxLen
      );
      const needed = finalCount - processedNames.length;
      processedNames.push(...filteredFallbacks.slice(0, needed));
    }
    return { names: processedNames };
  } catch (error) {
    console.error("Error generating business names:", error);
    return {
      names: [
        "BrightPath",
        "NextGen",
        "Velocity",
        "Innovation",
        "DigitalForge",
        "Momentum",
        "CoreTech",
        "PrimeVenture",
        "SwiftFlow",
        "NovaLabs"
      ].slice(0, Math.min(count, 10))
    };
  }
}

// server/ai-slogan.ts
import OpenAI2 from "openai";
var openai2 = new OpenAI2({
  apiKey: process.env.OPENAI_API_KEY
});
var TONE_SEED_PROMPTS = {
  Professional: `Generate concise, confident, and trustworthy slogans. 
Emphasize reliability, expertise, and authority. 
Avoid humor or slang. Keep it polished and businesslike.`,
  Playful: `Generate lighthearted, witty, and fun slogans. 
Use casual language, puns, or humor where natural. 
Make it feel approachable and energetic.`,
  Bold: `Generate strong, daring, and attention-grabbing slogans. 
Short punchy words. Impactful tone. 
Make the brand sound fearless and memorable.`,
  Minimal: `Generate clean, simple, and stripped-down slogans. 
Prefer 2\u20134 words max. No filler. 
Focus on clarity and elegance.`,
  Luxury: `Generate elegant, premium-sounding slogans. 
Emphasize sophistication, exclusivity, and timeless appeal. 
Avoid slang, keep the tone upscale and refined.`,
  Friendly: `Generate warm, approachable, and inviting slogans. 
Use inclusive and encouraging language. 
Make the brand feel like a helpful friend.`
};
function getSystemMessage(tone) {
  const baseSysMessage = "You are Nova, an expert brand strategist. Generate short, memorable taglines with punch. Avoid clich\xE9s and trademarked phrases.";
  const toneSeedPrompt = TONE_SEED_PROMPTS[tone];
  if (toneSeedPrompt) {
    return `${baseSysMessage}

${toneSeedPrompt}`;
  }
  return baseSysMessage;
}
function parsePlainTextSlogans(content, maxResults, brandName) {
  let lines = content.split("\n").map((line) => line.trim()).filter((line) => line.length > 0).filter((line) => !/^[^\w\s]*$/.test(line)).map((line) => {
    line = line.replace(/^[\d\.\)\-\*\+•>\s]*/, "").trim();
    line = line.replace(/^["'`]|["'`]$/g, "").trim();
    return line;
  }).filter((line) => line.length > 0);
  const uniqueSuggestions = [];
  const seenLowercase = /* @__PURE__ */ new Set();
  for (const slogan of lines) {
    const lowerSlogan = slogan.toLowerCase();
    if (!seenLowercase.has(lowerSlogan)) {
      seenLowercase.add(lowerSlogan);
      uniqueSuggestions.push(slogan);
      if (uniqueSuggestions.length >= maxResults) {
        break;
      }
    }
  }
  while (uniqueSuggestions.length < maxResults) {
    const fallbacks = [
      `${brandName} - Excellence Redefined`,
      `Your Success, Our Mission`,
      `Innovation That Inspires`,
      `Quality You Can Trust`,
      `${brandName} - Leading the Way`,
      `Experience the Difference`,
      `Where Quality Meets Innovation`,
      `Your Partner in Success`,
      `${brandName} - Beyond Expectations`,
      `Crafted for Excellence`,
      `Your Vision, Our Expertise`,
      `${brandName} - Trusted Choice`
    ];
    for (const fallback of fallbacks) {
      const lowerFallback = fallback.toLowerCase();
      if (!seenLowercase.has(lowerFallback) && uniqueSuggestions.length < maxResults) {
        seenLowercase.add(lowerFallback);
        uniqueSuggestions.push(fallback);
      }
    }
    if (uniqueSuggestions.length === 0) {
      uniqueSuggestions.push(`${brandName} - Excellence Redefined`);
      break;
    }
  }
  return { suggestions: uniqueSuggestions };
}
async function generateSlogans(request) {
  const {
    brandName,
    description = "",
    tone = "Professional",
    industry = "",
    audience = "",
    maxResults = 8
  } = request;
  const clampedMaxResults = Math.max(1, Math.min(12, maxResults));
  const prompt = `Brand name: ${brandName}
Description: ${description || "Not specified"}
Tone: ${tone}
Industry: ${industry || "Not specified"}
Audience: ${audience || "Not specified"}

Generate ${clampedMaxResults} memorable taglines. Return as a plain-text list, one per line.`;
  let response;
  try {
    const completion = await openai2.chat.completions.create({
      model: "gpt-5",
      messages: [
        {
          role: "system",
          content: getSystemMessage(tone)
        },
        {
          role: "user",
          content: prompt
        }
      ],
      temperature: 0.8,
      max_tokens: 400
    });
    const content = completion.choices[0]?.message?.content;
    if (!content) {
      throw new Error("No response from OpenAI");
    }
    response = parsePlainTextSlogans(content, clampedMaxResults, brandName);
  } catch (error) {
    console.log("GPT-5 failed, falling back to gpt-4o-mini:", error);
    try {
      const completion = await openai2.chat.completions.create({
        model: "gpt-4o-mini",
        messages: [
          {
            role: "system",
            content: getSystemMessage(tone)
          },
          {
            role: "user",
            content: prompt
          }
        ],
        temperature: 0.8,
        max_tokens: 400
      });
      const content = completion.choices[0]?.message?.content;
      if (!content) {
        throw new Error("No response from OpenAI fallback");
      }
      response = parsePlainTextSlogans(content, clampedMaxResults, brandName);
    } catch (fallbackError) {
      console.error("Both GPT-5 and gpt-4o-mini failed:", fallbackError);
      response = {
        suggestions: [
          `${brandName} - Excellence Redefined`,
          `Your Success, Our Mission`,
          `Innovation That Inspires`,
          `Quality You Can Trust`,
          `${brandName} - Leading the Way`,
          `Experience the Difference`,
          `Where Quality Meets Innovation`,
          `Your Partner in Success`
        ].slice(0, clampedMaxResults)
      };
    }
  }
  return response;
}

// server/ai-plan.ts
import OpenAI3 from "openai";
var openai3 = new OpenAI3({
  apiKey: process.env.OPENAI_API_KEY
});
var TONE_SYSTEM_PROMPTS = {
  Professional: `You are a senior business strategy consultant with extensive experience helping startups and established companies develop comprehensive business plans. Write in a polished, confident, and authoritative tone. Use business terminology appropriately and maintain a formal, credible style throughout.`,
  Friendly: `You are an approachable business mentor who explains complex business concepts in warm, encouraging language. Write in a conversational but professional tone, using inclusive language that makes the reader feel supported and motivated. Avoid jargon when simpler terms work better.`,
  Bold: `You are a dynamic business strategist who writes with confidence and conviction. Use strong, impactful language that inspires action. Be direct and decisive in your recommendations. Emphasize competitive advantages and ambitious goals with energetic, compelling prose.`,
  Minimal: `You are a strategic business advisor who values clarity and brevity. Write in clean, concise language that gets straight to the point. Use short sentences and bullet points when appropriate. Eliminate unnecessary words while maintaining substance and actionability.`
};
var LEAN_PLAN_SECTIONS = [
  { id: "executive_summary", title: "Executive Summary" },
  { id: "customer_problem", title: "Customer & Problem" },
  { id: "offer", title: "Your Offer" },
  { id: "go_to_market", title: "Go-to-Market Strategy" },
  { id: "objectives_90_day", title: "90-Day Objectives" }
];
var FULL_PLAN_SECTIONS = [
  { id: "executive_summary", title: "Executive Summary" },
  { id: "company_overview", title: "Company Overview" },
  { id: "market_analysis", title: "Market Analysis" },
  { id: "customer_problem", title: "Customer & Problem" },
  { id: "solution_product", title: "Solution & Product" },
  { id: "competitive_advantage", title: "Competitive Advantage" },
  { id: "business_model", title: "Business Model & Revenue" },
  { id: "marketing_strategy", title: "Marketing & Sales Strategy" },
  { id: "operations", title: "Operations & Implementation" },
  { id: "risk_mitigation", title: "Risk Assessment & Mitigation" },
  { id: "milestones", title: "Key Milestones & Timeline" },
  { id: "next_steps", title: "Immediate Next Steps" }
];
function getLeanPlanPrompt(request) {
  const {
    businessName,
    description,
    industry = "Not specified",
    audience = "Not specified",
    problem = "Not specified",
    solution = "Not specified",
    advantage = "Not specified",
    pricing = "Not specified",
    timeframeMonths = 12
  } = request;
  return `Generate a lean business plan for: ${businessName}

Business Details:
- Description: ${description}
- Industry: ${industry}
- Target Audience: ${audience}
- Problem Solved: ${problem}
- Solution Approach: ${solution}
- Key Advantage: ${advantage}
- Pricing Strategy: ${pricing}
- Planning Timeframe: ${timeframeMonths} months

Create exactly 5 sections as specified below. Each section should be 50-110 words, actionable, and specific to this business.

Required sections:
1. Executive Summary - Brief overview of the business, its mission, and key value proposition
2. Customer & Problem - Who your customers are and what specific problem you solve for them
3. Your Offer - What you're selling and how it addresses the customer problem
4. Go-to-Market Strategy - How you'll reach customers and acquire them initially
5. 90-Day Objectives - Specific, measurable goals for the first 90 days

Return ONLY a valid JSON object in this exact format:
{
  "sections": [
    {"id": "executive_summary", "title": "Executive Summary", "content": "..."},
    {"id": "customer_problem", "title": "Customer & Problem", "content": "..."},
    {"id": "offer", "title": "Your Offer", "content": "..."},
    {"id": "go_to_market", "title": "Go-to-Market Strategy", "content": "..."},
    {"id": "objectives_90_day", "title": "90-Day Objectives", "content": "..."}
  ]
}`;
}
function getFullPlanPrompt(request) {
  const {
    businessName,
    description,
    industry = "Not specified",
    audience = "Not specified",
    problem = "Not specified",
    solution = "Not specified",
    advantage = "Not specified",
    pricing = "Not specified",
    timeframeMonths = 12
  } = request;
  return `Generate a comprehensive business plan for: ${businessName}

Business Details:
- Description: ${description}
- Industry: ${industry}
- Target Audience: ${audience}
- Problem Solved: ${problem}
- Solution Approach: ${solution}
- Key Advantage: ${advantage}
- Pricing Strategy: ${pricing}
- Planning Timeframe: ${timeframeMonths} months

Create exactly 12 sections as specified below. Each section should be 80-180 words, detailed, and actionable.

Also include a financial snapshot with realistic projections for ${timeframeMonths} months.

Return ONLY a valid JSON object in this exact format:
{
  "sections": [
    {"id": "executive_summary", "title": "Executive Summary", "content": "..."},
    {"id": "company_overview", "title": "Company Overview", "content": "..."},
    {"id": "market_analysis", "title": "Market Analysis", "content": "..."},
    {"id": "customer_problem", "title": "Customer & Problem", "content": "..."},
    {"id": "solution_product", "title": "Solution & Product", "content": "..."},
    {"id": "competitive_advantage", "title": "Competitive Advantage", "content": "..."},
    {"id": "business_model", "title": "Business Model & Revenue", "content": "..."},
    {"id": "marketing_strategy", "title": "Marketing & Sales Strategy", "content": "..."},
    {"id": "operations", "title": "Operations & Implementation", "content": "..."},
    {"id": "risk_mitigation", "title": "Risk Assessment & Mitigation", "content": "..."},
    {"id": "milestones", "title": "Key Milestones & Timeline", "content": "..."},
    {"id": "next_steps", "title": "Immediate Next Steps", "content": "..."}
  ],
  "finance": {
    "assumptions": {
      "revenueGrowthMonthly": 15,
      "customerAcquisitionCost": 50,
      "averageRevenuePerUser": 100,
      "churnRateMonthly": 5
    },
    "projections": [
      {"month": 1, "revenue": 1000, "expenses": 2000, "profit": -1000, "customers": 10},
      {"month": 2, "revenue": 1500, "expenses": 2100, "profit": -600, "customers": 15},
      {"month": 3, "revenue": 2250, "expenses": 2200, "profit": 50, "customers": 23}
    ],
    "summary": {
      "breakEvenMonth": 3,
      "totalRevenue12Month": 50000,
      "totalProfit12Month": 15000
    }
  }
}

Provide realistic financial projections based on the business model. Include monthly data for the full timeframe. Ensure all numbers are realistic for the described business.`;
}
function parseBusinessPlanResponse(content, mode) {
  try {
    const parsed = JSON.parse(content);
    if (!parsed.sections || !Array.isArray(parsed.sections)) {
      throw new Error("Invalid response format: missing or invalid sections array");
    }
    const expectedSections = mode === "lean" ? LEAN_PLAN_SECTIONS : FULL_PLAN_SECTIONS;
    const sections = [];
    for (const expectedSection of expectedSections) {
      const section = parsed.sections.find((s) => s.id === expectedSection.id);
      if (!section || !section.content) {
        throw new Error(`Missing required section: ${expectedSection.id}`);
      }
      const maxWords = mode === "lean" ? 110 : 180;
      const words = section.content.split(/\s+/);
      const cappedContent = words.length > maxWords ? words.slice(0, maxWords).join(" ") + "..." : section.content;
      sections.push({
        id: section.id,
        title: section.title || expectedSection.title,
        content: cappedContent
      });
    }
    const response = {
      mode,
      sections
    };
    if (mode === "full" && parsed.finance) {
      response.finance = parsed.finance;
    }
    return response;
  } catch (error) {
    console.error("Failed to parse business plan response:", error);
    throw new Error("Invalid JSON response from AI model");
  }
}
function generateFallbackPlan(request) {
  const { businessName, mode } = request;
  if (mode === "lean") {
    return {
      mode: "lean",
      sections: [
        {
          id: "executive_summary",
          title: "Executive Summary",
          content: `${businessName} is an innovative business focused on delivering value to customers through our unique approach. We aim to solve key market problems while building a sustainable and profitable operation.`
        },
        {
          id: "customer_problem",
          title: "Customer & Problem",
          content: `Our target customers face significant challenges in their daily operations. ${businessName} addresses these pain points by providing efficient, cost-effective solutions that save time and improve outcomes.`
        },
        {
          id: "offer",
          title: "Your Offer",
          content: `We offer a comprehensive solution that combines quality, affordability, and excellent customer service. Our approach is designed to meet customer needs while maintaining competitive pricing.`
        },
        {
          id: "go_to_market",
          title: "Go-to-Market Strategy",
          content: `Our initial market entry will focus on digital marketing, word-of-mouth referrals, and strategic partnerships. We'll prioritize customer satisfaction to build a strong reputation and organic growth.`
        },
        {
          id: "objectives_90_day",
          title: "90-Day Objectives",
          content: `Within 90 days, we aim to establish our initial customer base, refine our offering based on feedback, and build operational processes that support sustainable growth.`
        }
      ]
    };
  } else {
    return {
      mode: "full",
      sections: [
        {
          id: "executive_summary",
          title: "Executive Summary",
          content: `${businessName} represents a strategic opportunity to capture market share in our target industry. With a clear value proposition and strong execution plan, we are positioned for sustainable growth and profitability.`
        },
        {
          id: "company_overview",
          title: "Company Overview",
          content: `${businessName} is structured to deliver exceptional value while maintaining operational efficiency. Our team brings together diverse expertise to execute our business strategy effectively.`
        },
        {
          id: "market_analysis",
          title: "Market Analysis",
          content: `The market presents significant opportunities for growth, with increasing demand for solutions like ours. We've identified key trends that support our business model and growth projections.`
        },
        {
          id: "customer_problem",
          title: "Customer & Problem",
          content: `Our research indicates that customers in our target market face persistent challenges that current solutions fail to address adequately. This creates a clear opportunity for ${businessName}.`
        },
        {
          id: "solution_product",
          title: "Solution & Product",
          content: `Our solution is designed to directly address customer pain points through innovative features and superior user experience. We focus on delivering measurable value and positive outcomes.`
        },
        {
          id: "competitive_advantage",
          title: "Competitive Advantage",
          content: `${businessName} differentiates itself through unique capabilities, superior customer service, and strategic positioning. Our competitive moat will strengthen over time through network effects.`
        },
        {
          id: "business_model",
          title: "Business Model & Revenue",
          content: `Our revenue model is designed for predictability and scalability. We've structured pricing to align customer value with business sustainability, creating win-win relationships.`
        },
        {
          id: "marketing_strategy",
          title: "Marketing & Sales Strategy",
          content: `Our marketing approach combines digital channels, content marketing, and strategic partnerships. We focus on building trust and demonstrating value through education and social proof.`
        },
        {
          id: "operations",
          title: "Operations & Implementation",
          content: `Operational excellence is critical to our success. We've designed systems and processes that scale efficiently while maintaining quality standards and customer satisfaction.`
        },
        {
          id: "risk_mitigation",
          title: "Risk Assessment & Mitigation",
          content: `We've identified key business risks and developed mitigation strategies. Our approach includes diversification, contingency planning, and continuous monitoring of external factors.`
        },
        {
          id: "milestones",
          title: "Key Milestones & Timeline",
          content: `Our roadmap includes specific milestones for product development, customer acquisition, and revenue growth. Each milestone has defined success metrics and timeline targets.`
        },
        {
          id: "next_steps",
          title: "Immediate Next Steps",
          content: `The immediate priority is executing our launch strategy, establishing initial customer relationships, and iterating based on market feedback. Success requires disciplined execution.`
        }
      ],
      finance: {
        assumptions: {
          revenueGrowthMonthly: 10,
          customerAcquisitionCost: 75,
          averageRevenuePerUser: 150,
          churnRateMonthly: 3
        },
        projections: [
          { month: 1, revenue: 1500, expenses: 3e3, profit: -1500, customers: 10 },
          { month: 2, revenue: 2250, expenses: 3200, profit: -950, customers: 15 },
          { month: 3, revenue: 3375, expenses: 3400, profit: -25, customers: 23 },
          { month: 4, revenue: 5062, expenses: 3600, profit: 1462, customers: 34 },
          { month: 5, revenue: 7593, expenses: 3800, profit: 3793, customers: 51 },
          { month: 6, revenue: 11390, expenses: 4e3, profit: 7390, customers: 76 }
        ],
        summary: {
          breakEvenMonth: 4,
          totalRevenue12Month: 15e4,
          totalProfit12Month: 45e3
        }
      }
    };
  }
}
async function generateBusinessPlan(request) {
  const {
    mode = "lean",
    businessName,
    description,
    tone = "Professional"
  } = request;
  if (!businessName || !description) {
    throw new Error("businessName and description are required");
  }
  const systemMessage = TONE_SYSTEM_PROMPTS[tone];
  const prompt = mode === "lean" ? getLeanPlanPrompt(request) : getFullPlanPrompt(request);
  try {
    const completion = await openai3.chat.completions.create({
      model: "gpt-5",
      messages: [
        {
          role: "system",
          content: systemMessage
        },
        {
          role: "user",
          content: prompt
        }
      ],
      temperature: 0.7,
      top_p: 0.9,
      max_completion_tokens: mode === "lean" ? 1200 : 3e3
    });
    const content = completion.choices[0]?.message?.content;
    if (!content) {
      throw new Error("No response from OpenAI");
    }
    return parseBusinessPlanResponse(content, mode);
  } catch (error) {
    console.log("GPT-5 failed, falling back to gpt-4o-mini:", error);
    try {
      const completion = await openai3.chat.completions.create({
        model: "gpt-4o-mini",
        messages: [
          {
            role: "system",
            content: systemMessage
          },
          {
            role: "user",
            content: prompt
          }
        ],
        temperature: 0.7,
        top_p: 0.9,
        max_completion_tokens: mode === "lean" ? 1200 : 3e3
      });
      const content = completion.choices[0]?.message?.content;
      if (!content) {
        throw new Error("No response from OpenAI fallback");
      }
      return parseBusinessPlanResponse(content, mode);
    } catch (fallbackError) {
      console.error("Both GPT-5 and gpt-4o-mini failed:", fallbackError);
      console.log("Using fallback business plan");
      return generateFallbackPlan(request);
    }
  }
}

// server/routes.ts
init_ai_section();
import OpenAI5 from "openai";
import { exec } from "child_process";
import { promises as fs9 } from "fs";
import fsSync from "fs";
import path9 from "path";

// server/services/exportTemplates.ts
import PDFDocument from "pdfkit";
import { Document, Packer, Paragraph, HeadingLevel, TextRun, Table, TableRow, TableCell, AlignmentType, PageBreak } from "docx";
var DEFAULTS = {
  titleFontSize: 22,
  h2Size: 16,
  bodySize: 11,
  primaryHex: "#0b6fa4",
  textHex: "#222222"
};
function renderPlanPDF(plan, meta) {
  const doc = new PDFDocument({
    size: "LETTER",
    margins: { top: 72, bottom: 72, left: 72, right: 72 },
    info: {
      Title: `${meta.businessName} \u2014 ${meta.subtitle ?? "Business Plan"}`,
      Author: "IBrandBiz",
      Subject: "Business Plan",
      Creator: "IBrandBiz Export Service",
      Producer: "PDFKit"
    }
  });
  doc.fillColor(DEFAULTS.primaryHex);
  doc.fontSize(28).font("Helvetica-Bold").text(meta.businessName, { align: "center" });
  doc.moveDown(0.3);
  doc.fontSize(14).font("Helvetica").fillColor(DEFAULTS.textHex).text(meta.subtitle ?? "Business Plan", { align: "center" });
  doc.moveDown(1);
  doc.fontSize(10).fillColor("#666666").text(`Generated: ${new Date(meta.generatedAt ?? /* @__PURE__ */ new Date()).toLocaleString()}`, { align: "center" });
  doc.moveDown(2);
  const mid = doc.page.width / 2 - 100;
  doc.rect(mid, doc.y, 200, 4).fill(DEFAULTS.primaryHex);
  doc.fillColor(DEFAULTS.textHex);
  doc.addPage();
  if (plan.mode === "full") {
    doc.fontSize(18).font("Helvetica-Bold").fillColor(DEFAULTS.primaryHex).text("Table of Contents");
    doc.moveDown(0.75);
    doc.fontSize(11).font("Helvetica").fillColor(DEFAULTS.textHex);
    plan.sections.forEach((s, idx) => {
      doc.text(`${idx + 1}. ${s.title}`);
    });
    doc.addPage();
  }
  plan.sections.forEach((s, idx) => {
    if (idx > 0) doc.moveDown(0.5);
    doc.fontSize(DEFAULTS.h2Size).font("Helvetica-Bold").fillColor(DEFAULTS.primaryHex).text(s.title);
    doc.moveDown(0.2);
    doc.fontSize(DEFAULTS.bodySize).font("Helvetica").fillColor(DEFAULTS.textHex);
    const lines = s.content.split(/\r?\n/).filter(Boolean);
    if (lines.some((l) => /^(\-|\•)\s+/.test(l))) {
      doc.moveDown(0.2);
      lines.forEach((l) => {
        const m = l.match(/^(\-|\•)\s+(.*)$/);
        if (m) {
          doc.circle(doc.x + 3, doc.y + 6, 2).fill(DEFAULTS.primaryHex).fillColor(DEFAULTS.textHex);
          doc.text(m[2], doc.x + 12, doc.y - 6, { width: 450 });
          doc.moveDown(0.2);
        } else {
          doc.text(l, { width: 470 });
        }
      });
    } else {
      doc.text(s.content, { width: 470 });
    }
    if (plan.mode === "full" && idx === plan.sections.length - 1 && plan.finance) {
      doc.addPage();
      doc.fontSize(DEFAULTS.h2Size).font("Helvetica-Bold").fillColor(DEFAULTS.primaryHex).text("Financial Snapshot");
      doc.moveDown(0.3);
      if (plan.finance.assumptions?.length) {
        doc.fontSize(DEFAULTS.bodySize).font("Helvetica").fillColor(DEFAULTS.textHex).text("Assumptions:");
        doc.moveDown(0.2);
        plan.finance.assumptions.forEach((a) => {
          doc.circle(doc.x + 3, doc.y + 6, 2).fill(DEFAULTS.primaryHex).fillColor(DEFAULTS.textHex);
          doc.text(a, doc.x + 12, doc.y - 6, { width: 470 });
          doc.moveDown(0.1);
        });
        doc.moveDown(0.5);
      }
      if (plan.finance.monthly_table?.length) {
        const header = ["Month", "Revenue", "Costs", "Profit"];
        const rows = plan.finance.monthly_table.map((r) => [
          r.month,
          `$${r.revenue.toLocaleString()}`,
          `$${r.costs.toLocaleString()}`,
          `$${r.profit.toLocaleString()}`
        ]);
        const colWidths = [90, 120, 120, 120];
        const startX = doc.x;
        let y = doc.y;
        doc.font("Helvetica-Bold").fillColor(DEFAULTS.primaryHex);
        header.forEach((h, i) => doc.text(h, startX + colWidths.slice(0, i).reduce((a, b) => a + b, 0), y, { width: colWidths[i] }));
        y += 18;
        doc.font("Helvetica").fillColor(DEFAULTS.textHex);
        rows.forEach((row) => {
          row.forEach((cell, i) => {
            doc.text(cell, startX + colWidths.slice(0, i).reduce((a, b) => a + b, 0), y, { width: colWidths[i] });
          });
          y += 16;
          if (y > doc.page.height - 72) {
            doc.addPage();
            y = doc.y;
          }
        });
      }
    }
    if (doc.y > doc.page.height - 120 && idx < plan.sections.length - 1) {
      doc.addPage();
    }
  });
  return doc;
}
async function renderPlanDOCX(plan, meta) {
  const children = [];
  children.push(
    new Paragraph({
      alignment: AlignmentType.CENTER,
      spacing: { after: 200 },
      children: [
        new TextRun({ text: meta.businessName, bold: true, size: 48, color: "0B6FA4" })
      ]
    }),
    new Paragraph({
      alignment: AlignmentType.CENTER,
      spacing: { after: 200 },
      children: [new TextRun({ text: meta.subtitle ?? "Business Plan", size: 24 })]
    }),
    new Paragraph({
      alignment: AlignmentType.CENTER,
      spacing: { after: 400 },
      children: [new TextRun({ text: `Generated: ${new Date(meta.generatedAt ?? /* @__PURE__ */ new Date()).toLocaleString()}`, size: 18, color: "666666" })]
    }),
    new Paragraph({ children: [new PageBreak()] })
  );
  if (plan.mode === "full") {
    children.push(new Paragraph({ text: "Table of Contents", heading: HeadingLevel.HEADING_1 }));
    plan.sections.forEach((s, idx) => {
      children.push(new Paragraph({ text: `${idx + 1}. ${s.title}`, spacing: { after: 120 } }));
    });
    children.push(new Paragraph({ children: [new PageBreak()] }));
  }
  for (const s of plan.sections) {
    children.push(new Paragraph({ text: s.title, heading: HeadingLevel.HEADING_2 }));
    const lines = s.content.split(/\r?\n/).filter(Boolean);
    if (lines.some((l) => /^(\-|\•)\s+/.test(l))) {
      for (const l of lines) {
        const m = l.match(/^(\-|\•)\s+(.*)$/);
        if (m) {
          children.push(new Paragraph({
            bullet: { level: 0 },
            children: [new TextRun({ text: m[2], size: 22 })],
            spacing: { after: 60 }
          }));
        } else {
          children.push(new Paragraph({ text: l, spacing: { after: 120 } }));
        }
      }
    } else {
      children.push(new Paragraph({ text: s.content, spacing: { after: 200 } }));
    }
  }
  if (plan.mode === "full" && plan.finance) {
    children.push(new Paragraph({ children: [new PageBreak()] }));
    children.push(new Paragraph({ text: "Financial Snapshot", heading: HeadingLevel.HEADING_2 }));
    if (plan.finance.assumptions?.length) {
      children.push(new Paragraph({ text: "Assumptions", heading: HeadingLevel.HEADING_3 }));
      for (const a of plan.finance.assumptions) {
        children.push(new Paragraph({ bullet: { level: 0 }, children: [new TextRun({ text: a })] }));
      }
    }
    if (plan.finance.monthly_table?.length) {
      const header = ["Month", "Revenue", "Costs", "Profit"];
      const tableRows = [];
      tableRows.push(new TableRow({
        children: header.map((h) => new TableCell({
          children: [new Paragraph({ text: h })]
        }))
      }));
      for (const r of plan.finance.monthly_table) {
        tableRows.push(new TableRow({
          children: [
            new TableCell({ children: [new Paragraph({ text: r.month })] }),
            new TableCell({ children: [new Paragraph({ text: `$${r.revenue.toLocaleString()}` })] }),
            new TableCell({ children: [new Paragraph({ text: `$${r.costs.toLocaleString()}` })] }),
            new TableCell({ children: [new Paragraph({ text: `$${r.profit.toLocaleString()}` })] })
          ]
        }));
      }
      children.push(new Paragraph({ text: "Monthly Table", heading: HeadingLevel.HEADING_3 }));
      children.push(new Table({ rows: tableRows, width: { size: 100, type: "pct" } }));
    }
  }
  const doc = new Document({ sections: [{ properties: {}, children }] });
  const buffer = await Packer.toBuffer(doc);
  return buffer;
}
function inferBusinessName(plan) {
  const guess = plan.sections.find((s) => /executive summary|summary/i.test(s.title));
  if (!guess) return void 0;
  const m = guess.content.match(/^\s*([A-Z][A-Za-z0-9&\-\s]{2,40})\s+(?:is|builds|creates|designs)\b/);
  return m?.[1]?.trim();
}
function slugify(s) {
  return s.replace(/[^\w\s\-\.]/g, "").replace(/\s+/g, "-");
}

// server/routes.ts
init_notifications();
import { z as z5 } from "zod";

// server/services/streamTokens.ts
import crypto2 from "crypto";
var StreamTokenService = class {
  tokens = /* @__PURE__ */ new Map();
  cleanupInterval = null;
  TOKEN_TTL = 5 * 60 * 1e3;
  // 5 minutes
  CLEANUP_INTERVAL = 60 * 1e3;
  // 1 minute
  constructor() {
    this.startCleanup();
  }
  // Generate a secure opaque token
  generateToken(userId) {
    this.cleanupExpiredTokens();
    const token = crypto2.randomBytes(32).toString("hex");
    const now = /* @__PURE__ */ new Date();
    const expiresAt = new Date(now.getTime() + this.TOKEN_TTL);
    this.tokens.set(token, {
      token,
      userId,
      createdAt: now,
      expiresAt,
      used: false
    });
    console.log(`Generated stream token for user ${userId} (expires in 5 minutes)`);
    return token;
  }
  // Validate and consume a token (single-use)
  validateAndConsumeToken(token) {
    const tokenData = this.tokens.get(token);
    if (!tokenData) {
      return { valid: false, reason: "Token not found" };
    }
    if (tokenData.used) {
      return { valid: false, reason: "Token already used" };
    }
    if (/* @__PURE__ */ new Date() > tokenData.expiresAt) {
      this.tokens.delete(token);
      return { valid: false, reason: "Token expired" };
    }
    tokenData.used = true;
    const userId = tokenData.userId;
    this.tokens.delete(token);
    console.log(`Stream token validated and consumed for user ${userId}`);
    return { valid: true, userId };
  }
  // Revoke a specific token
  revokeToken(token) {
    return this.tokens.delete(token);
  }
  // Revoke all tokens for a user
  revokeUserTokens(userId) {
    let revokedCount = 0;
    for (const [token, tokenData] of this.tokens) {
      if (tokenData.userId === userId) {
        this.tokens.delete(token);
        revokedCount++;
      }
    }
    console.log(`Revoked ${revokedCount} tokens for user ${userId}`);
    return revokedCount;
  }
  // Clean up expired tokens
  cleanupExpiredTokens() {
    const now = /* @__PURE__ */ new Date();
    let cleanedCount = 0;
    for (const [token, tokenData] of this.tokens) {
      if (now > tokenData.expiresAt) {
        this.tokens.delete(token);
        cleanedCount++;
      }
    }
    if (cleanedCount > 0) {
      console.log(`Cleaned up ${cleanedCount} expired stream tokens`);
    }
  }
  // Start periodic cleanup
  startCleanup() {
    if (this.cleanupInterval) {
      clearInterval(this.cleanupInterval);
    }
    this.cleanupInterval = setInterval(() => {
      this.cleanupExpiredTokens();
    }, this.CLEANUP_INTERVAL);
  }
  // Get service stats
  getStats() {
    const now = /* @__PURE__ */ new Date();
    const validTokens = Array.from(this.tokens.values()).filter((t) => !t.used && now <= t.expiresAt);
    return {
      totalTokens: this.tokens.size,
      validTokens: validTokens.length,
      expiredTokens: this.tokens.size - validTokens.length,
      tokensByUser: validTokens.reduce((acc, token) => {
        acc[token.userId] = (acc[token.userId] || 0) + 1;
        return acc;
      }, {})
    };
  }
  // Cleanup all tokens (for shutdown)
  cleanup() {
    if (this.cleanupInterval) {
      clearInterval(this.cleanupInterval);
      this.cleanupInterval = null;
    }
    this.tokens.clear();
    console.log("Stream token service cleanup completed");
  }
};
var streamTokenService = new StreamTokenService();
process.on("SIGTERM", () => {
  console.log("SIGTERM received, cleaning up stream token service...");
  streamTokenService.cleanup();
});
process.on("SIGINT", () => {
  console.log("SIGINT received, cleaning up stream token service...");
  streamTokenService.cleanup();
});

// server/routes.ts
init_opensrs();
init_pricing();
init_watermark();
import Stripe4 from "stripe";

// server/version.ts
import fs6 from "fs";
import path6 from "path";
var buildInfo = null;
try {
  const buildInfoPath = path6.join(process.cwd(), "dist", "build-info.json");
  if (fs6.existsSync(buildInfoPath)) {
    buildInfo = JSON.parse(fs6.readFileSync(buildInfoPath, "utf-8"));
  }
} catch (e) {
}
var BUILD = buildInfo || {
  sha: process.env.REPL_SLUG || process.env.GIT_COMMIT || (/* @__PURE__ */ new Date()).getTime().toString(36),
  time: (/* @__PURE__ */ new Date()).toISOString(),
  env: process.env.NODE_ENV || "development"
};

// server/routes.ts
var stripe4 = null;
function getStripe3() {
  if (stripe4) return stripe4;
  const stripeKey = process.env.STRIPE_SECRET_KEY;
  if (!stripeKey) {
    console.warn("STRIPE_SECRET_KEY not found - Stripe functionality will be disabled");
    return null;
  }
  try {
    stripe4 = new Stripe4(stripeKey, {
      apiVersion: "2023-10-16"
    });
    return stripe4;
  } catch (error) {
    console.error("Failed to initialize Stripe:", error);
    return null;
  }
}
function buildSecureRedirectUrl2(path13, origin) {
  const allowedBaseUrls = [
    process.env.DOMAIN_URL,
    process.env.FRONTEND_URL,
    process.env.VITE_BASE_URL,
    origin
    // Use request origin as fallback if provided
  ].filter(Boolean);
  let baseUrl = allowedBaseUrls[0];
  if (!baseUrl) {
    if (process.env.NODE_ENV === "development") {
      baseUrl = "http://localhost:5000";
    } else {
      console.warn("[buildSecureRedirectUrl] No DOMAIN_URL/FRONTEND_URL configured, using empty baseUrl - Stripe may fail");
      baseUrl = "";
    }
  }
  const cleanPath = path13.startsWith("/") ? path13 : `/${path13}`;
  return `${baseUrl}${cleanPath}`;
}
function isValidStateTransition(fromStatus, toStatus) {
  const validTransitions = {
    [CREATOR_ONBOARDING_STATUSES.PENDING]: [CREATOR_ONBOARDING_STATUSES.IN_PROGRESS],
    [CREATOR_ONBOARDING_STATUSES.IN_PROGRESS]: [CREATOR_ONBOARDING_STATUSES.COMPLETED, CREATOR_ONBOARDING_STATUSES.PENDING],
    // Can go back to pending if issues
    [CREATOR_ONBOARDING_STATUSES.COMPLETED]: [],
    // Completed is final state
    [CREATOR_ONBOARDING_STATUSES.REJECTED]: [CREATOR_ONBOARDING_STATUSES.PENDING]
    // Can be re-approved
  };
  return validTransitions[fromStatus]?.includes(toStatus) ?? false;
}
function handleStripeUnavailable(res, context = "this operation") {
  res.status(503).json({
    error: "Payment processing service temporarily unavailable",
    message: "Stripe Connect is not properly configured. Please contact support or try again later.",
    details: `${context} requires Stripe Connect integration`,
    code: "STRIPE_UNAVAILABLE",
    retryable: true
  });
}
var DEFAULT_DOMAIN_CREDIT_CAP_CENTS = Number(process.env.FREE_DOMAIN_WHOLESALE_CAP || 1500);
var DEFAULT_ELIGIBLE_TLDS = (process.env.FREE_DOMAIN_TLDS || ".com,.net,.org,.co").split(",").map((s) => s.trim().toLowerCase()).filter(Boolean);
var CREDIT_EXPIRY_DAYS = Number(process.env.FREE_DOMAIN_CREDIT_EXPIRY_DAYS || 60);
var OWNER_EMAILS2 = (process.env.IBRANDBIZ_OWNER_EMAILS || "jrichards@ibrandbiz.com").split(",").map((email) => email.trim().toLowerCase()).filter((email) => email.length > 0);
function isOwnerEmailServerSide2(email) {
  if (!email) return false;
  const normalizedEmail = email.trim().toLowerCase();
  const isOwner = OWNER_EMAILS2.includes(normalizedEmail);
  console.log(`\u{1F510} Server-side owner check - Email: ${email}, Owner: ${isOwner}, Owner list: [${OWNER_EMAILS2.join(", ")}]`);
  return isOwner;
}
async function authenticateToken2(req, res, next) {
  try {
    const isDevelopment = process.env.NODE_ENV === "development";
    const devBypassEnabled = process.env.DEV_BYPASS === "true";
    const devBypassHeader = req.headers["x-dev-bypass"];
    if (isDevelopment && devBypassEnabled && devBypassHeader === "development") {
      console.warn("\u{1F6A8} DEV AUTH BYPASS ACTIVE - Only use in development!");
      req.user = {
        uid: "dev-user-123",
        email: "dev@example.com",
        displayName: "Development User"
      };
      return next();
    }
    const admin2 = await getFirebaseAdmin();
    if (!admin2) {
      if (process.env.NODE_ENV === "production") {
        console.error("\u{1F6A8} CRITICAL: Firebase Admin not available in production");
        return res.status(500).json({ error: "Authentication service unavailable" });
      }
      if (isDevelopment && devBypassEnabled) {
        console.warn("\u{1F6A8} Firebase unavailable in development with DEV_BYPASS enabled, using mock user");
        req.user = {
          uid: "dev-user-123",
          email: "dev@example.com",
          displayName: "Development User"
        };
        return next();
      }
      return res.status(500).json({ error: "Authentication service unavailable" });
    }
    const authHeader = req.headers.authorization;
    const token = authHeader && authHeader.split(" ")[1];
    if (!token) {
      return res.status(401).json({ error: "Access token required" });
    }
    const decodedToken = await admin2.auth().verifyIdToken(token);
    req.user = {
      uid: decodedToken.uid,
      email: decodedToken.email,
      displayName: decodedToken.name
    };
    next();
  } catch (error) {
    console.error("Authentication error:", error);
    return res.status(403).json({ error: "Invalid or expired token" });
  }
}
async function hasProAccess(req, res, next) {
  try {
    if (!req.user) {
      return res.status(401).json({ error: "User not authenticated" });
    }
    const user = await storage.getUserByFirebaseUid(req.user.uid);
    if (!user) {
      return res.status(404).json({ error: "User not found" });
    }
    const isOwner = user.role === "owner" || isOwnerEmailServerSide2(user.email);
    const hasPro = user.isPaid || isOwner;
    if (!hasPro) {
      return res.status(402).json({
        error: "Pro subscription required",
        message: "This feature requires a Pro subscription. Please upgrade to continue.",
        feature: "premium_api_access"
      });
    }
    next();
  } catch (error) {
    console.error("Pro access check error:", error);
    return res.status(500).json({ error: "Failed to verify Pro access" });
  }
}
function handleError(res, error, defaultMessage) {
  console.error(error);
  if (error instanceof z5.ZodError) {
    return res.status(400).json({
      error: "Validation failed",
      details: error.errors
    });
  }
  return res.status(500).json({ error: defaultMessage });
}
var TELEMETRY = [];
var pushEvent = (e) => {
  TELEMETRY.push(e);
  if (TELEMETRY.length > 200) TELEMETRY.shift();
};
async function registerRoutes(app2) {
  const objectStorageService3 = new ObjectStorageService();
  console.log("\u{1F680} Initializing job system...");
  await Promise.resolve().then(() => (init_jobs(), jobs_exports));
  const uploadDirs = [
    path9.join(process.cwd(), "uploads", "photos"),
    path9.join(process.cwd(), "uploads", "mockups"),
    path9.join(process.cwd(), "tmp")
    // For database files
  ];
  for (const dir of uploadDirs) {
    try {
      await fs9.mkdir(dir, { recursive: true });
      console.log(`\u{1F4C1} Created directory: ${dir}`);
    } catch (error) {
      console.warn(`Failed to create directory ${dir}:`, error);
    }
  }
  console.log("\u{1F512} Secure asset serving enabled - no public file exposure");
  app2.use(trackVisitor);
  console.log("\u{1F4CA} Visitor tracking middleware enabled");
  const upload5 = multer5({
    dest: "uploads/",
    limits: {
      fileSize: 5 * 1024 * 1024
      // 5MB limit
    },
    fileFilter: (req, file2, cb) => {
      if (file2.mimetype.startsWith("image/")) {
        cb(null, true);
      } else {
        cb(new Error("Only image files are allowed"));
      }
    }
  });
  app2.get("/assets/logo.png", (req, res) => {
    const logoPath = path9.resolve(import.meta.dirname, "..", "dist", "public", "assets");
    fs9.readdir(logoPath).then((files) => {
      const logoFile = files.find((file2) => file2.startsWith("IBrandBiz Logo 2025-") && file2.endsWith(".svg"));
      if (logoFile) {
        const fullPath = path9.join(logoPath, logoFile);
        res.setHeader("Content-Type", "image/svg+xml");
        res.setHeader("Cache-Control", "public, max-age=31536000");
        res.sendFile(fullPath);
      } else {
        res.status(404).send("Logo not found");
      }
    }).catch((error) => {
      console.error("Error serving logo:", error);
      res.status(500).send("Error serving logo");
    });
  });
  app2.get("/assets/logo-reverse.png", (req, res) => {
    const logoPath = path9.resolve(import.meta.dirname, "..", "client", "public", "assets", "IBrandBiz_Logo_Reversed_2025.png");
    res.setHeader("Content-Type", "image/png");
    res.setHeader("Cache-Control", "public, max-age=31536000");
    res.sendFile(logoPath, (err) => {
      if (err) {
        console.error("Error serving reverse logo:", err);
        res.status(404).send("Reverse logo not found");
      }
    });
  });
  app2.get("/api/firebase-proxy", async (req, res) => {
    try {
      const { url } = req.query;
      if (!url || typeof url !== "string") {
        return res.status(400).json({ error: "URL parameter required" });
      }
      if (!url.includes("firebasestorage.googleapis.com")) {
        return res.status(403).json({ error: "Only Firebase Storage URLs allowed" });
      }
      const response = await fetch(url);
      if (!response.ok) {
        return res.status(response.status).json({ error: `Firebase fetch failed: ${response.statusText}` });
      }
      const content = await response.text();
      res.setHeader("Content-Type", "image/svg+xml");
      res.send(content);
    } catch (error) {
      console.error("Firebase proxy error:", error);
      res.status(500).json({ error: "Failed to fetch Firebase content" });
    }
  });
  app2.use(routes_default);
  app2.use("/api/icons", icons_default);
  app2.use("/api/icons", iconLibraryRoutes_default);
  app2.get("/api/icons/imported", (req, res) => {
    req.url = "/list";
    iconLibraryRoutes_default.handle(req, res);
  });
  app2.use("/api/external-stock", stock_default);
  const { default: stockLibraryRoutesNew } = await Promise.resolve().then(() => (init_stockLibraryRoutes(), stockLibraryRoutes_exports));
  app2.use("/api/stock", stockLibraryRoutesNew);
  const { default: mockupLibraryRoutes } = await Promise.resolve().then(() => (init_mockupLibraryRoutes(), mockupLibraryRoutes_exports));
  app2.use("/api/mockups", mockupLibraryRoutes);
  app2.use("/api/ppt", ppt_default);
  app2.use("/api/infographics", infographics_default);
  app2.use("/api/presentations", presentationTemplates_default);
  app2.use("/api/logo-templates", logoTemplates_default);
  app2.use("/api/bp-templates", bpTemplates_default);
  app2.use("/api/bp-templates", bpImportCsv_default);
  app2.use("/api/bp-templates-firebase", bpTemplatesPublic_default);
  app2.use("/api/bp-templates-firebase/admin", requireAdmin, businessPlanTemplatesFirebase_default);
  app2.use("/health", healthBpTemplates_default);
  app2.use("/api/logo-templates-firebase", logoTemplatesPublic_default);
  const pdfCacheDir = path9.join(process.cwd(), "tmp", "pdf-cache");
  await fs9.mkdir(pdfCacheDir, { recursive: true });
  const cleanupCache = async () => {
    try {
      const files = await fs9.readdir(pdfCacheDir);
      const now = Date.now();
      for (const file2 of files) {
        const filePath = path9.join(pdfCacheDir, file2);
        const stat = await fs9.stat(filePath);
        if (now - stat.mtimeMs > 60 * 60 * 1e3) {
          await fs9.unlink(filePath);
          console.log(`[PDF Cache] Cleaned up old file: ${file2}`);
        }
      }
    } catch (e) {
      console.error("[PDF Cache] Cleanup error:", e);
    }
  };
  setInterval(cleanupCache, 30 * 60 * 1e3);
  cleanupCache();
  app2.get("/api/preview/pdf", async (req, res) => {
    try {
      const u = req.query.u;
      if (!u) return res.status(400).send("Missing ?u");
      const url = decodeURIComponent(String(u));
      const allowed = /^(https:\/\/(?:storage\.googleapis\.com|firebasestorage\.googleapis\.com|[^/]+\.firebasestorage\.app)\/)/i;
      if (!allowed.test(url)) return res.status(400).send("Blocked");
      const headers = {};
      if (req.headers.range) headers.Range = req.headers.range;
      if (req.headers["if-none-match"]) headers["If-None-Match"] = req.headers["if-none-match"];
      if (req.headers["if-modified-since"]) headers["If-Modified-Since"] = req.headers["if-modified-since"];
      const upstream = await fetch(url, { headers, redirect: "follow" });
      res.status(upstream.status);
      for (const h of [
        "content-type",
        "content-length",
        "accept-ranges",
        "content-range",
        "etag",
        "last-modified",
        "cache-control",
        "vary",
        "date"
      ]) {
        const v = upstream.headers.get(h);
        if (v) res.setHeader(h, v);
      }
      const filename = (req.query.filename || "document.pdf").toString();
      if (!res.getHeader("content-disposition")) {
        res.setHeader("Content-Disposition", `inline; filename="${filename}"`);
      }
      if (!res.getHeader("content-type")) res.setHeader("Content-Type", "application/pdf");
      if (upstream.status === 304) return res.end();
      if (!upstream.body) return res.end();
      const { Readable: Readable2 } = await import("node:stream");
      Readable2.fromWeb(upstream.body).pipe(res);
    } catch (e) {
      console.error("PDF proxy error", e);
      res.status(502).send("Proxy error");
    }
  });
  app2.get("/public-objects/:filePath(*)", async (req, res) => {
    const filePath = req.params.filePath;
    try {
      if (!filePath.startsWith("assets/previews/")) {
        return res.status(403).json({ error: "Access denied - previews only" });
      }
      const file2 = await objectStorageService3.searchPublicObject(filePath);
      if (!file2) {
        return res.status(404).json({ error: "File not found" });
      }
      res.set({
        "X-Content-Type-Options": "nosniff",
        "X-Frame-Options": "DENY",
        "Cache-Control": "public, max-age=3600"
      });
      objectStorageService3.downloadObject(file2, res);
    } catch (error) {
      console.error("Error searching for public object:", error);
      return res.status(500).json({ error: "Internal server error" });
    }
  });
  app2.get("/api/assets/:assetId/download", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "Authentication required" });
      }
      const assetId = req.params.assetId;
      const asset = await storage.getAsset(assetId);
      if (!asset) {
        return res.status(404).json({ error: "Asset not found" });
      }
      const creatorAssets2 = await storage.getCreatorAssetsByAssetId(assetId);
      const creatorAsset = creatorAssets2[0];
      if (!creatorAsset) {
        return res.status(404).json({ error: "Marketplace asset not found" });
      }
      if (creatorAsset.approvalStatus !== "approved") {
        return res.status(403).json({ error: "Asset not available for download" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const creator = await storage.getCreatorByUserId(user.id);
      const isCreatorOwner = creator && creator.id === creatorAsset.creatorId;
      if (!isCreatorOwner) {
        const hasEntitlement = await storage.getUserEntitlementByUserAndItem(
          user.id,
          "creator_asset",
          creatorAsset.id
        );
        if (!hasEntitlement || hasEntitlement.status !== "active") {
          return res.status(402).json({
            error: "Purchase required",
            message: "This asset requires a purchase to download the original file.",
            assetId: creatorAsset.id,
            previewUrl: asset.previewUrl
            // Provide preview URL as alternative
          });
        }
      }
      const privateDir = objectStorageService3.getPrivateObjectDir();
      const filePath = asset.fileUrl.startsWith(privateDir) ? asset.fileUrl : `${privateDir}/${asset.fileUrl}`;
      try {
        const parseObjectPath2 = (path13) => {
          if (!path13.startsWith("/")) {
            path13 = `/${path13}`;
          }
          const pathParts = path13.split("/");
          if (pathParts.length < 3) {
            throw new Error("Invalid path: must contain at least a bucket name");
          }
          const bucketName2 = pathParts[1];
          const objectName2 = pathParts.slice(2).join("/");
          return { bucketName: bucketName2, objectName: objectName2 };
        };
        const { bucketName, objectName } = parseObjectPath2(filePath);
        const bucket2 = objectStorageClient.bucket(bucketName);
        const file2 = bucket2.file(objectName);
        const [exists] = await file2.exists();
        if (!exists) {
          console.error(`Asset file not found in storage: ${filePath}`);
          return res.status(404).json({ error: "Asset file not found" });
        }
        const isSvgOrPdf = asset.mimeType === "image/svg+xml" || asset.mimeType === "application/pdf";
        const filename = asset.originalFileName || asset.fileName;
        res.set({
          "Content-Type": asset.mimeType,
          "Content-Disposition": isSvgOrPdf ? `attachment; filename="${filename}"` : `inline; filename="${filename}"`,
          "X-Content-Type-Options": "nosniff",
          "X-Frame-Options": "DENY",
          "Cache-Control": "private, no-cache, no-store, must-revalidate"
        });
        const stream = file2.createReadStream();
        stream.on("error", (err) => {
          console.error("Download stream error:", err);
          if (!res.headersSent) {
            res.status(500).json({ error: "Error streaming file" });
          }
        });
        await storage.incrementAssetDownloadCount(assetId);
        console.log(`\u{1F512} Secure download: User ${user.email} downloaded asset ${creatorAsset.title} (${assetId})`);
        stream.pipe(res);
      } catch (storageError) {
        console.error("Storage error during secure download:", storageError);
        return res.status(500).json({ error: "Failed to retrieve asset file" });
      }
    } catch (error) {
      console.error("Secure asset download error:", error);
      handleError(res, error, "Failed to download asset");
    }
  });
  app2.get("/api/assets/:assetId/preview", async (req, res) => {
    try {
      const assetId = req.params.assetId;
      const asset = await storage.getAsset(assetId);
      if (!asset) {
        return res.status(404).json({ error: "Asset not found" });
      }
      const creatorAssets2 = await storage.getCreatorAssetsByAssetId(assetId);
      const creatorAsset = creatorAssets2[0];
      if (!creatorAsset || creatorAsset.approvalStatus !== "approved") {
        return res.status(404).json({ error: "Asset preview not available" });
      }
      if (asset.previewUrl) {
        try {
          const previewPath = asset.previewUrl.replace("/public-objects/", "");
          const file2 = await objectStorageService3.searchPublicObject(previewPath);
          if (file2) {
            res.set({
              "Content-Type": asset.mimeType,
              "Cache-Control": "public, max-age=3600",
              "X-Content-Type-Options": "nosniff"
            });
            return objectStorageService3.downloadObject(file2, res);
          }
        } catch (previewError) {
          console.warn("Preview file not found, falling back to original:", previewError);
        }
      }
      return res.status(404).json({
        error: "Preview not available",
        message: "Asset preview has not been generated yet"
      });
    } catch (error) {
      console.error("Asset preview error:", error);
      res.status(500).json({ error: "Failed to serve asset preview" });
    }
  });
  app2.post("/api/upload-url", authenticateToken2, async (req, res) => {
    try {
      const { fileName } = req.body;
      if (!fileName) {
        return res.status(400).json({ error: "fileName is required" });
      }
      const uploadURL = await objectStorageService3.getUploadURL(fileName, true);
      res.json({ uploadURL });
    } catch (error) {
      console.error("Error getting upload URL:", error);
      res.status(500).json({ error: "Internal server error" });
    }
  });
  app2.get("/api/auth/me", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const isOwner = isOwnerEmailServerSide2(user.email);
      const isDevelopment = process.env.NODE_ENV === "development" || process.env.NODE_ENV !== "production";
      const simulateProUser = isDevelopment && req.headers["x-simulate-pro"] === "true";
      res.json({
        authenticated: true,
        email: user.email,
        displayName: user.displayName,
        company: user.company,
        avatarUrl: user.avatarUrl,
        isPaid: simulateProUser || user.isPaid || isOwner,
        // Owner gets paid access
        isOwner,
        proActivatedAt: simulateProUser ? user.proActivatedAt || (/* @__PURE__ */ new Date()).toISOString() : user.proActivatedAt,
        proWelcomeDismissed: !!user.proWelcomeDismissed
      });
    } catch (error) {
      handleError(res, error, "Failed to get user info");
    }
  });
  app2.get("/api/auth/verify-owner", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const isOwner = isOwnerEmailServerSide2(user.email);
      res.json({
        isOwner,
        email: user.email,
        verifiedAt: (/* @__PURE__ */ new Date()).toISOString()
      });
    } catch (error) {
      handleError(res, error, "Failed to verify owner status");
    }
  });
  app2.post("/api/auth/revoke-sessions", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const clientIp = req.ip || req.connection.remoteAddress || "unknown";
      if (!checkPasswordRateLimit(req.user.uid, clientIp)) {
        return res.status(429).json({
          error: "Too many password-related requests. Please wait before trying again.",
          message: "Rate limit exceeded: Maximum 5 password changes per minute per user.",
          retryAfter: Math.ceil(PASSWORD_RATE_WINDOW / 1e3)
        });
      }
      const admin2 = await getFirebaseAdmin();
      if (!admin2) {
        return res.status(500).json({ error: "Authentication service unavailable" });
      }
      await admin2.auth().revokeRefreshTokens(req.user.uid);
      console.log(`\u{1F512} Session tokens revoked for user: ${req.user.email} (${req.user.uid})`);
      res.json({
        success: true,
        message: "All refresh tokens have been revoked",
        revokedAt: (/* @__PURE__ */ new Date()).toISOString()
      });
    } catch (error) {
      console.error("Session revocation error:", error);
      return res.status(500).json({
        error: "Failed to revoke sessions",
        message: "Unable to revoke refresh tokens. Please try again."
      });
    }
  });
  app2.post("/api/profile/dismiss-pro-welcome", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      await storage.updateUser(user.id, { proWelcomeDismissed: true });
      res.json({ ok: true });
    } catch (error) {
      handleError(res, error, "Failed to dismiss Pro welcome");
    }
  });
  app2.post("/api/profile/update", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const { name, company } = req.body || {};
      await storage.updateUserByFirebaseUid(req.user.uid, {
        displayName: name,
        company
      });
      res.json({ name, company });
    } catch (error) {
      handleError(res, error, "Failed to update profile");
    }
  });
  app2.get("/api/profile/preferences", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const preferences = await storage.getUserPreferences(req.user.uid);
      res.json(preferences);
    } catch (error) {
      console.error("Get preferences error:", error);
      res.json({
        emailNews: true,
        marketingEmails: false,
        productUpdates: true
      });
    }
  });
  app2.post("/api/profile/preferences", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const { emailNews, marketingEmails, productUpdates, systemNotifications, billingNotifications, projectNotifications } = req.body || {};
      await storage.setUserPreferences(req.user.uid, {
        emailNews: !!emailNews,
        marketingEmails: !!marketingEmails,
        productUpdates: !!productUpdates,
        systemNotifications: !!systemNotifications,
        billingNotifications: !!billingNotifications,
        projectNotifications: !!projectNotifications
      });
      res.json({ ok: true });
    } catch (error) {
      handleError(res, error, "Failed to save preferences");
    }
  });
  app2.get("/api/user/settings", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const defaultSettings = {
        theme: "system",
        timezone: "",
        fontScale: 1,
        notifications: {
          system: true,
          billing: true,
          project: true
        }
      };
      res.json(defaultSettings);
    } catch (error) {
      handleError(res, error, "Failed to get settings");
    }
  });
  app2.post("/api/user/settings", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      let fontScale = req.body.fontScale ?? 1;
      if (typeof fontScale === "number") {
        fontScale = Math.max(0.85, Math.min(1.3, fontScale));
      } else {
        fontScale = 1;
      }
      const settings = {
        theme: req.body.theme || "system",
        timezone: req.body.timezone || "",
        fontScale,
        notifications: {
          system: req.body.notifications?.system ?? true,
          billing: req.body.notifications?.billing ?? true,
          project: req.body.notifications?.project ?? true
        }
      };
      res.json(settings);
    } catch (error) {
      handleError(res, error, "Failed to save settings");
    }
  });
  app2.post("/api/profile/avatar", authenticateToken2, upload5.single("file"), async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      if (!req.file) {
        return res.status(400).json({ error: "No file uploaded" });
      }
      const url = `/uploads/${req.file.filename}`;
      await storage.updateUserByFirebaseUid(req.user.uid, { avatarUrl: url });
      res.json({ url });
    } catch (error) {
      handleError(res, error, "Avatar upload failed");
    }
  });
  app2.post("/api/profile/change-password", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const { current, next } = req.body || {};
      if (!current || !next) {
        return res.status(400).json({ error: "Current and new passwords are required" });
      }
      if (next.length < 6) {
        return res.status(400).json({ error: "New password must be at least 6 characters long" });
      }
      res.json({ ok: true });
    } catch (error) {
      handleError(res, error, "Failed to update password");
    }
  });
  app2.post("/api/billing/checkout", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const stripeClient = getStripe3();
      if (!stripeClient) {
        return res.status(500).json({ error: "Stripe not configured" });
      }
      const { priceType, successUrl, cancelUrl } = req.body;
      if (!["monthly", "yearly"].includes(priceType)) {
        return res.status(400).json({ error: 'Invalid price type. Must be "monthly" or "yearly"' });
      }
      let user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        console.log(`\u{1F504} Auto-creating database record for Firebase user: ${req.user.email}`);
        const userData = insertUserSchema.parse({
          firebaseUid: req.user.uid,
          email: req.user.email || "",
          displayName: req.user.displayName || "User",
          role: "user"
        });
        user = await storage.createUser(userData);
        console.log(`\u2705 Created database user record for: ${user.email}`);
      }
      if (user.isPaid) {
        return res.status(409).json({ error: "User already has an active subscription" });
      }
      const priceIds = {
        monthly: process.env.STRIPE_MONTHLY_PRICE_ID,
        yearly: process.env.STRIPE_YEARLY_PRICE_ID
      };
      const priceId = priceIds[priceType];
      if (!priceId) {
        console.error(`Missing Stripe Price ID for ${priceType}. Please set STRIPE_${priceType.toUpperCase()}_PRICE_ID environment variable.`);
        return res.status(500).json({
          error: "Stripe configuration required",
          message: `Missing Stripe Price ID for ${priceType} subscription. You need to create subscription products in your Stripe Dashboard and set the Price IDs as environment variables.`,
          setup: {
            steps: [
              "1. Go to your Stripe Dashboard \u2192 Products \u2192 Create Product",
              "2. Create a 'Pro Monthly' product with recurring billing at $19/month",
              "3. Create a 'Pro Yearly' product with recurring billing at $190/year",
              "4. Copy the Price IDs (they start with 'price_') from each product",
              "5. Set environment variables: STRIPE_MONTHLY_PRICE_ID and STRIPE_YEARLY_PRICE_ID"
            ],
            required: {
              STRIPE_MONTHLY_PRICE_ID: "Your monthly subscription Price ID from Stripe Dashboard",
              STRIPE_YEARLY_PRICE_ID: "Your yearly subscription Price ID from Stripe Dashboard"
            }
          }
        });
      }
      console.log(`\u{1F50D} Using Stripe Price ID: ${priceId} for ${priceType} subscription`);
      try {
        const price = await stripeClient.prices.retrieve(priceId);
        console.log(`\u2705 Price ID validated: ${price.id} - ${price.currency} ${price.unit_amount / 100}/${price.recurring?.interval}`);
        if (!price.active) {
          console.error(`\u274C Price ID ${priceId} is not active in Stripe`);
          return res.status(500).json({
            error: "Invalid Stripe configuration",
            message: `The Price ID ${priceId} exists but is not active. Please activate it in your Stripe Dashboard or create a new one.`,
            details: {
              priceId,
              status: "inactive",
              helpUrl: "https://dashboard.stripe.com/products"
            }
          });
        }
      } catch (stripeError) {
        console.error(`\u274C Stripe Price ID validation failed:`, stripeError.message);
        if (stripeError.code === "resource_missing") {
          return res.status(500).json({
            error: "Invalid Stripe Price ID",
            message: `The Price ID "${priceId}" does not exist in your Stripe account. This commonly happens when:`,
            possibleCauses: [
              "\u2022 You're using test mode Price IDs with live mode Stripe keys (or vice versa)",
              "\u2022 The Price ID was copied incorrectly",
              "\u2022 The Price was deleted or archived in Stripe Dashboard",
              "\u2022 You're connected to a different Stripe account"
            ],
            solution: {
              immediate: "Check your Stripe Dashboard to verify your Price IDs match your current mode (test/live)",
              longTerm: "Create new subscription products in Stripe Dashboard and update your environment variables"
            },
            details: {
              currentPriceId: priceId,
              priceType,
              stripeError: stripeError.message,
              dashboardUrl: "https://dashboard.stripe.com/products"
            }
          });
        }
        return res.status(500).json({
          error: "Stripe validation error",
          message: stripeError.message,
          details: { priceId, priceType }
        });
      }
      let customer;
      const existingCustomers = await stripeClient.customers.list({
        email: user.email,
        limit: 1
      });
      if (existingCustomers.data.length > 0) {
        customer = existingCustomers.data[0];
      } else {
        customer = await stripeClient.customers.create({
          email: user.email,
          name: user.displayName || void 0,
          metadata: {
            uid: req.user.uid,
            user_email: user.email
          }
        });
      }
      const baseUrl = successUrl ? new URL(successUrl).origin : req.headers.origin;
      const finalSuccessUrl = successUrl || `${baseUrl}/dashboard?welcome=pro`;
      const finalCancelUrl = cancelUrl || `${baseUrl}/pricing?cancelled=true`;
      console.log(`\u{1F517} Stripe URLs - Success: ${finalSuccessUrl}, Cancel: ${finalCancelUrl}`);
      const session = await stripeClient.checkout.sessions.create({
        customer: customer.id,
        payment_method_types: ["card"],
        line_items: [
          {
            price: priceId,
            quantity: 1
          }
        ],
        mode: "subscription",
        subscription_data: {
          trial_end: "now",
          // No trial period - immediate payment required
          metadata: {
            uid: req.user.uid,
            email: user.email,
            user_email: user.email
          }
        },
        success_url: finalSuccessUrl,
        cancel_url: finalCancelUrl,
        allow_promotion_codes: true,
        billing_address_collection: "auto"
      });
      console.log(`\u2705 Created Stripe checkout session for ${user.email} - ${priceType} subscription`);
      res.json({
        checkoutUrl: session.url,
        sessionId: session.id,
        priceId
      });
    } catch (e) {
      const msg = e?.raw?.message || e?.message || "Stripe checkout error";
      const code = e?.raw?.code || e?.code || "unknown_error";
      console.error("checkout error:", { code, msg, fullError: e });
      return res.status(400).json({ error: msg, code });
    }
  });
  app2.post("/api/billing/create-subscription", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const stripeClient = getStripe3();
      if (!stripeClient) {
        return res.status(500).json({ error: "Stripe not configured" });
      }
      const { billingType, email } = req.body;
      if (!billingType || !["monthly", "yearly"].includes(billingType)) {
        return res.status(400).json({ error: "Missing or invalid billingType. Must be 'monthly' or 'yearly'" });
      }
      const priceId = billingType === "monthly" ? process.env.STRIPE_MONTHLY_PRICE_ID : process.env.STRIPE_YEARLY_PRICE_ID;
      if (!priceId) {
        console.error(`Missing Stripe price ID for ${billingType} billing`);
        return res.status(500).json({ error: `${billingType} subscription not configured` });
      }
      const customerEmail = email || req.user.email;
      let customer;
      if (customerEmail) {
        const existing = await stripeClient.customers.list({ email: customerEmail, limit: 1 });
        customer = existing.data[0] ?? await stripeClient.customers.create({ email: customerEmail });
      } else {
        customer = await stripeClient.customers.create();
      }
      const subscription = await stripeClient.subscriptions.create({
        customer: customer.id,
        items: [{ price: priceId }],
        payment_behavior: "default_incomplete",
        expand: ["latest_invoice.payment_intent"]
      });
      const paymentIntent = subscription.latest_invoice.payment_intent;
      if (!paymentIntent?.client_secret) {
        return res.status(500).json({ error: "No client secret on payment intent." });
      }
      return res.json({
        clientSecret: paymentIntent.client_secret,
        subscriptionId: subscription.id
      });
    } catch (err) {
      console.error("create-subscription failed", err);
      return res.status(500).json({ error: err.message || "Stripe error" });
    }
  });
  app2.post("/api/billing/cancel", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const cancellationData = insertCancellationSchema.parse(req.body);
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const cancellation = await storage.createCancellation({
        userId: user.id,
        firebaseUid: req.user.uid,
        email: req.user.email || user.email,
        reason: cancellationData.reason,
        note: cancellationData.note || null
      });
      try {
        if (user.isPaid) {
          const stripeClient = getStripe3();
          if (!stripeClient) {
            console.warn("Stripe not configured - skipping subscription cancellation, but updating user status");
            await storage.updateUser(user.id, { isPaid: false });
          } else {
            const customers = await stripeClient.customers.list({
              email: user.email,
              limit: 1
            });
            if (customers.data.length > 0) {
              const customerId = customers.data[0].id;
              const subscriptions = await stripeClient.subscriptions.list({
                customer: customerId,
                status: "active",
                limit: 10
              });
              for (const subscription of subscriptions.data) {
                await stripeClient.subscriptions.update(subscription.id, {
                  cancel_at_period_end: true
                });
                console.log(`\u2705 Scheduled Stripe subscription cancellation at period end: ${subscription.id} for user: ${user.email}`);
              }
            }
            await storage.updateUser(user.id, { isPaid: false });
          }
        }
      } catch (stripeError) {
        console.error("Stripe cancellation error:", stripeError);
        console.warn("Failed to cancel Stripe subscription, but survey data saved");
      }
      res.json({
        success: true,
        message: "Subscription cancelled successfully",
        cancellationId: cancellation.id
      });
    } catch (error) {
      handleError(res, error, "Failed to cancel subscription");
    }
  });
  async function getOrCreateCustomer(stripeClient, userEmail, displayName, uid) {
    const existingCustomers = await stripeClient.customers.list({
      email: userEmail,
      limit: 1
    });
    if (existingCustomers.data.length > 0) {
      return existingCustomers.data[0];
    } else {
      return await stripeClient.customers.create({
        email: userEmail,
        name: displayName || void 0,
        metadata: {
          uid: uid || "",
          user_email: userEmail
        }
      });
    }
  }
  app2.post("/api/stripe/elements/create-subscription", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const stripeClient = getStripe3();
      if (!stripeClient) {
        return res.status(500).json({ error: "Stripe not configured" });
      }
      const { priceType } = req.body;
      if (!["monthly", "yearly"].includes(priceType)) {
        return res.status(400).json({ error: 'Invalid price type. Must be "monthly" or "yearly"' });
      }
      let user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        console.log(`\u{1F504} Auto-creating database record for Firebase user: ${req.user.email}`);
        const userData = insertUserSchema.parse({
          firebaseUid: req.user.uid,
          email: req.user.email || "",
          displayName: req.user.displayName || "User",
          role: "user"
        });
        user = await storage.createUser(userData);
        console.log(`\u2705 Created database user record for: ${user.email}`);
      }
      if (user.isPaid) {
        return res.status(409).json({ error: "User already has an active subscription" });
      }
      const priceIds = {
        monthly: process.env.STRIPE_MONTHLY_PRICE_ID,
        yearly: process.env.STRIPE_YEARLY_PRICE_ID
      };
      const priceId = priceIds[priceType];
      if (!priceId) {
        return res.status(500).json({
          error: "Stripe Price ID not configured",
          message: `The ${priceType} Price ID is not set in environment variables. Please set STRIPE_${priceType.toUpperCase()}_PRICE_ID.`,
          priceType
        });
      }
      console.log(`\u{1F50D} Using Stripe Price ID: ${priceId} for ${priceType} subscription`);
      try {
        const price = await stripeClient.prices.retrieve(priceId);
        console.log(`\u2705 Price ID validated: ${priceId} - ${price.currency} ${(price.unit_amount || 0) / 100}/${price.recurring?.interval}`);
      } catch (stripeError) {
        console.error(`\u274C Stripe Price ID validation failed:`, stripeError.message);
        return res.status(500).json({
          error: "Invalid Stripe Price ID",
          message: `The Price ID "${priceId}" does not exist in your Stripe account.`,
          priceType
        });
      }
      const customer = await getOrCreateCustomer(stripeClient, user.email, user.displayName, req.user.uid);
      const subscription = await stripeClient.subscriptions.create({
        customer: customer.id,
        items: [{
          price: priceId
        }],
        payment_behavior: "default_incomplete",
        payment_settings: { save_default_payment_method: "on_subscription" },
        expand: ["latest_invoice.payment_intent"],
        trial_end: "now",
        // No trial period - immediate payment required
        metadata: {
          uid: req.user.uid,
          email: user.email,
          user_email: user.email
        }
      });
      const invoice = subscription.latest_invoice;
      const paymentIntent = invoice.payment_intent;
      console.log(`\u2705 Created Stripe subscription for ${user.email} - ${priceType} subscription (status: ${subscription.status})`);
      if (!paymentIntent) {
        console.error(`\u274C No payment intent found - subscription creation failed`);
        return res.status(500).json({
          error: "Subscription creation failed - no payment intent found",
          message: "Unable to process payment. Please try again."
        });
      }
      res.json({
        subscriptionId: subscription.id,
        clientSecret: paymentIntent.client_secret,
        customerId: customer.id,
        priceId
      });
    } catch (e) {
      const msg = e?.raw?.message || e?.message || "Stripe subscription creation error";
      const code = e?.raw?.code || e?.code || "unknown_error";
      console.error("subscription creation error:", { code, msg, fullError: e });
      return res.status(400).json({ error: msg, code });
    }
  });
  app2.post("/api/checkout/creator-marketplace", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const stripeClient = getStripe3();
      if (!stripeClient) {
        return handleStripeUnavailable(res, "Creator marketplace checkout");
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const { cartItems: cartItems2 } = req.body;
      if (!cartItems2 || !Array.isArray(cartItems2) || cartItems2.length === 0) {
        return res.status(400).json({ error: "Cart is empty or invalid" });
      }
      const PLATFORM_FEE_BPS = Number(process.env.PLATFORM_FEE_BPS) || 3e3;
      console.log(`\u{1F6D2} Processing creator marketplace checkout for ${cartItems2.length} items`);
      const cartItemSchema = z5.object({
        id: z5.string(),
        itemType: z5.literal("creator_asset"),
        itemId: z5.string(),
        // creatorAssetId
        quantity: z5.number().optional(),
        // We'll validate this explicitly below
        metadata: z5.object({
          creatorId: z5.string().optional(),
          assetId: z5.string().optional()
        }).optional()
      });
      let validatedCartItems;
      try {
        validatedCartItems = cartItems2.map((item) => cartItemSchema.parse(item));
      } catch (validationError) {
        return res.status(400).json({
          error: "Invalid cart item structure",
          details: validationError instanceof z5.ZodError ? validationError.errors : validationError
        });
      }
      const invalidQuantityItems = validatedCartItems.filter((item) => item.quantity && item.quantity > 1);
      if (invalidQuantityItems.length > 0) {
        return res.status(400).json({
          error: "Invalid quantity for digital licenses",
          message: "Creator assets are digital licenses limited to one copy per asset",
          violatingItems: invalidQuantityItems.map((item) => ({ id: item.id, quantity: item.quantity }))
        });
      }
      const itemIds = validatedCartItems.map((item) => item.itemId);
      const duplicateItemIds = itemIds.filter((id, index2) => itemIds.indexOf(id) !== index2);
      if (duplicateItemIds.length > 0) {
        return res.status(400).json({
          error: "Duplicate creator assets detected",
          message: "Each creator asset can only appear once in the cart",
          duplicateItemIds: [...new Set(duplicateItemIds)]
        });
      }
      const clientCreatorIds = validatedCartItems.map((item) => item.metadata?.creatorId).filter(Boolean);
      if (clientCreatorIds.length > 0) {
        const uniqueClientCreatorIds = [...new Set(clientCreatorIds)];
        if (uniqueClientCreatorIds.length > 1) {
          return res.status(400).json({
            error: "Mixed creator cart detected in client data",
            message: "Cart contains assets from multiple creators according to client metadata",
            clientCreatorIds: uniqueClientCreatorIds
          });
        }
      }
      const creatorAssets2 = await Promise.all(
        validatedCartItems.map(async (item) => {
          const creatorAsset = await storage.getCreatorAsset(item.itemId);
          if (!creatorAsset) {
            throw new Error(`Creator asset not found: ${item.itemId}`);
          }
          if (creatorAsset.approvalStatus !== "approved") {
            throw new Error(`Asset not available: ${creatorAsset.title} (status: ${creatorAsset.approvalStatus})`);
          }
          const priceCents = creatorAsset.price;
          if (priceCents < CREATOR_MIN_PRICE_CENTS || priceCents > CREATOR_MAX_PRICE_CENTS) {
            throw new Error(`Asset price $${priceCents / 100} is outside allowed range ($${CREATOR_MIN_PRICE_CENTS / 100} - $${CREATOR_MAX_PRICE_CENTS / 100})`);
          }
          return creatorAsset;
        })
      );
      const creatorIds = [...new Set(creatorAssets2.map((asset) => asset.creatorId))];
      if (creatorIds.length > 1) {
        return res.status(400).json({
          error: "Mixed creator cart not allowed",
          message: "All items in cart must be from the same creator",
          creatorIds
        });
      }
      const creatorId = creatorIds[0];
      const creator = await storage.getCreator(creatorId);
      if (!creator) {
        return res.status(404).json({ error: "Creator not found" });
      }
      if (!creator.stripeConnectAccountId) {
        return res.status(400).json({
          error: "Creator payment setup incomplete",
          message: "This creator has not completed their payment setup yet"
        });
      }
      if (!creator.payoutEnabled) {
        return res.status(400).json({
          error: "Creator payouts disabled",
          message: "This creator is not currently accepting payments"
        });
      }
      let connectAccount;
      try {
        connectAccount = await stripeClient.accounts.retrieve(creator.stripeConnectAccountId);
      } catch (stripeError) {
        console.error("Failed to retrieve Stripe Connect account:", stripeError);
        return res.status(502).json({
          error: "Creator payment account unavailable",
          message: "Unable to process payments to this creator at the moment"
        });
      }
      if (!connectAccount.charges_enabled || !connectAccount.payouts_enabled) {
        return res.status(400).json({
          error: "Creator account not ready",
          message: "This creator's payment account is not fully set up for receiving payments",
          details: {
            charges_enabled: connectAccount.charges_enabled,
            payouts_enabled: connectAccount.payouts_enabled,
            requirements: connectAccount.requirements?.currently_due || []
          }
        });
      }
      let totalAmount = 0;
      const lineItems = validatedCartItems.map((item, index2) => {
        const creatorAsset = creatorAssets2[index2];
        const authoritativePrice = creatorAsset.price;
        const quantity = 1;
        const itemTotal = authoritativePrice * quantity;
        totalAmount += itemTotal;
        return {
          price_data: {
            currency: "usd",
            unit_amount: authoritativePrice,
            product_data: {
              name: creatorAsset.title,
              // Use DB title, not client name
              description: creatorAsset.description || void 0,
              metadata: {
                creator_asset_id: creatorAsset.id,
                asset_id: creatorAsset.assetId,
                creator_id: creatorId
              }
            }
          },
          quantity
        };
      });
      const platformFeeAmount = Math.round(totalAmount * PLATFORM_FEE_BPS / 1e4);
      const creatorNetAmount = totalAmount - platformFeeAmount;
      console.log(`\u{1F4B0} Checkout totals - Total: $${totalAmount / 100}, Platform Fee: $${platformFeeAmount / 100}, Creator Net: $${creatorNetAmount / 100}`);
      const customer = await getOrCreateCustomer(stripeClient, user.email, user.displayName, req.user.uid);
      const finalSuccessUrl = buildSecureRedirectUrl2("/marketplace/success");
      const finalCancelUrl = buildSecureRedirectUrl2("/marketplace/cart");
      const sessionData = {
        customer: customer.id,
        payment_method_types: ["card"],
        line_items: lineItems,
        mode: "payment",
        success_url: `${finalSuccessUrl}?session_id={CHECKOUT_SESSION_ID}`,
        cancel_url: finalCancelUrl,
        allow_promotion_codes: false,
        // Disabled for creator marketplace
        billing_address_collection: "required",
        metadata: {
          userId: user.id,
          creatorId,
          buyerUserId: user.id,
          // SECURITY: Add buyerUserId for fulfillment
          assetIds: creatorAssets2.map((a) => a.assetId).join(","),
          // SECURITY: Add assetIds array
          feeBps: PLATFORM_FEE_BPS.toString(),
          // SECURITY: Add feeBps for fulfillment
          totalItems: validatedCartItems.length.toString(),
          totalAmount: totalAmount.toString(),
          platformFeeAmount: platformFeeAmount.toString(),
          checkoutType: "creator_marketplace"
        }
      };
      if (platformFeeAmount > 0) {
        sessionData.payment_intent_data = {
          application_fee_amount: platformFeeAmount,
          transfer_data: {
            destination: creator.stripeConnectAccountId
          },
          metadata: {
            creator_id: creatorId,
            platform_fee_bps: PLATFORM_FEE_BPS.toString(),
            asset_ids: creatorAssets2.map((a) => a.assetId).join(",")
          }
        };
      }
      const session = await stripeClient.checkout.sessions.create(sessionData);
      const purchaseData = {
        userId: user.id,
        stripeSessionId: session.id,
        totalAmount,
        currency: "USD",
        status: "pending",
        // SECURITY: Store authoritative data from DB, not client input
        itemsData: validatedCartItems.map((item, index2) => ({
          id: item.id,
          itemType: item.itemType,
          itemId: item.itemId,
          itemName: creatorAssets2[index2].title,
          // Use DB title
          itemPrice: creatorAssets2[index2].price,
          // Use DB price
          quantity: 1,
          // Force quantity=1
          metadata: {
            creatorId,
            assetId: creatorAssets2[index2].assetId
          }
        })),
        metadata: {
          checkoutType: "creator_marketplace",
          creatorId,
          platformFeeAmount,
          creatorNetAmount,
          assetIds: creatorAssets2.map((a) => a.assetId)
        }
      };
      await storage.createPurchase(purchaseData);
      console.log(`\u2705 Created creator marketplace checkout session: ${session.id} for creator: ${creatorId}`);
      res.json({
        sessionId: session.id,
        checkoutUrl: session.url,
        totalAmount,
        platformFeeAmount,
        creatorNetAmount,
        creatorId,
        itemCount: validatedCartItems.length
      });
    } catch (error) {
      console.error("Creator marketplace checkout error:", error);
      if (error.message.includes("Creator asset not found")) {
        return res.status(404).json({
          error: "Asset not found",
          message: error.message
        });
      }
      if (error.message.includes("Asset not available")) {
        return res.status(400).json({
          error: "Asset not available",
          message: error.message
        });
      }
      if (error.type === "StripeCardError") {
        return res.status(400).json({
          error: "Payment error",
          message: error.message,
          code: error.code
        });
      }
      return res.status(500).json({
        error: "Checkout failed",
        message: "An unexpected error occurred during checkout",
        details: error.message
      });
    }
  });
  app2.post("/api/stripe/customer-portal", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const stripeClient = getStripe3();
      if (!stripeClient) {
        return res.status(500).json({ error: "Stripe not configured" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const customer = await getOrCreateCustomer(stripeClient, user.email, user.displayName, req.user.uid);
      const { returnUrl } = req.body;
      const baseUrl = returnUrl ? new URL(returnUrl).origin : req.headers.origin;
      const finalReturnUrl = returnUrl || `${baseUrl}/dashboard`;
      const portalSession = await stripeClient.billingPortal.sessions.create({
        customer: customer.id,
        return_url: finalReturnUrl
      });
      res.json({
        portalUrl: portalSession.url
      });
    } catch (e) {
      const msg = e?.raw?.message || e?.message || "Customer portal error";
      console.error("customer portal error:", e);
      return res.status(400).json({ error: msg });
    }
  });
  app2.post("/api/billing/pause", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const pauseData = insertPauseSchema.parse({
        ...req.body,
        uid: req.user.uid,
        email: req.user.email,
        resumeAt: new Date(Date.now() + (req.body.months || 1) * 30 * 24 * 60 * 60 * 1e3)
        // Calculate resume date
      });
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      if (!user.isPaid) {
        return res.status(400).json({ error: "User does not have an active subscription" });
      }
      try {
        const stripeClient = getStripe3();
        if (!stripeClient) {
          return res.status(500).json({ error: "Stripe not configured - unable to pause subscription" });
        }
        const customers = await stripeClient.customers.list({
          email: user.email,
          limit: 1
        });
        if (customers.data.length === 0) {
          return res.status(404).json({ error: "Stripe customer not found" });
        }
        const customerId = customers.data[0].id;
        const subscriptions = await stripeClient.subscriptions.list({
          customer: customerId,
          status: "active",
          limit: 10
        });
        if (subscriptions.data.length === 0) {
          return res.status(404).json({ error: "No active subscription found" });
        }
        const subscription = subscriptions.data[0];
        const pauseEndDate = Math.floor(pauseData.resumeAt.getTime() / 1e3);
        await stripeClient.subscriptions.update(subscription.id, {
          pause_collection: {
            behavior: "mark_uncollectible",
            resumes_at: pauseEndDate
          },
          metadata: {
            uid: req.user.uid,
            email: req.user.email || user.email,
            pause_reason: pauseData.reason || ""
          }
        });
        console.log(`\u2705 Paused Stripe subscription: ${subscription.id} for user: ${user.email} until ${pauseData.resumeAt}`);
        const pause = await storage.createPause({
          uid: req.user.uid,
          email: req.user.email || user.email,
          stripeSubId: subscription.id,
          months: pauseData.months,
          reason: pauseData.reason || null,
          note: pauseData.note || null,
          resumeAt: pauseData.resumeAt
        });
        await storage.updateUser(user.id, {
          subscriptionStatus: "paused",
          pausedAt: /* @__PURE__ */ new Date(),
          resumeAt: pauseData.resumeAt
        });
        res.json({
          ok: true,
          resumeAt: pauseData.resumeAt,
          pauseId: pause.id,
          message: `Subscription paused for ${pauseData.months} month${pauseData.months > 1 ? "s" : ""}`
        });
      } catch (stripeError) {
        console.error("Stripe pause error:", stripeError);
        return res.status(500).json({ error: "Failed to pause Stripe subscription" });
      }
    } catch (error) {
      handleError(res, error, "Failed to pause subscription");
    }
  });
  const { default: checkoutRoutes } = await Promise.resolve().then(() => (init_checkoutRoutes(), checkoutRoutes_exports));
  app2.use("/api/checkout", checkoutRoutes);
  app2.get("/api/notifications", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const notifications2 = await storage.getNotifications(req.user.uid);
      res.json(notifications2);
    } catch (error) {
      handleError(res, error, "Failed to get notifications");
    }
  });
  app2.post("/api/notifications/mark-read/:id", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const { id } = req.params;
      if (!id) {
        return res.status(400).json({ error: "Notification ID is required" });
      }
      const success = await storage.markNotificationRead(id, req.user.uid);
      if (!success) {
        return res.status(404).json({ error: "Notification not found or access denied" });
      }
      res.json({ ok: true });
    } catch (error) {
      handleError(res, error, "Failed to mark notification as read");
    }
  });
  app2.post("/api/notifications/stream-token", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const streamToken = streamTokenService.generateToken(req.user.uid);
      res.json({
        streamToken,
        expiresIn: 300,
        // 5 minutes
        endpoint: "/api/notifications/stream"
      });
    } catch (error) {
      handleError(res, error, "Failed to generate stream token");
    }
  });
  app2.get("/api/notifications/stream", async (req, res) => {
    try {
      const streamToken = req.query.token;
      if (!streamToken) {
        res.status(401).json({ error: "Stream token required" });
        return;
      }
      const tokenResult = streamTokenService.validateAndConsumeToken(streamToken);
      if (!tokenResult.valid) {
        console.warn(`SSE connection denied: ${tokenResult.reason}`);
        res.status(401).json({ error: "Invalid or expired stream token" });
        return;
      }
      const userId = tokenResult.userId;
      console.log(`SSE connection authenticated for user ${userId}`);
      res.writeHead(200, {
        "Content-Type": "text/event-stream",
        "Cache-Control": "no-cache",
        "Connection": "keep-alive",
        "X-Accel-Buffering": "no"
        // Disable nginx buffering
      });
      notificationBroadcaster.addConnection(streamToken, userId, res);
    } catch (error) {
      console.error("SSE endpoint error:", error);
      res.status(500).json({ error: "Internal server error" });
    }
  });
  app2.post("/api/notifications/test", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const { type = "info", message = "Test notification from the enhanced SSE system! \u{1F389}" } = req.body;
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const notification = await storage.createNotification(user.id, message, type);
      res.json({
        success: true,
        message: "Test notification created and broadcast via SSE",
        notification
      });
    } catch (error) {
      handleError(res, error, "Failed to create test notification");
    }
  });
  app2.use("/uploads", express8.static("uploads"));
  app2.use(express8.static("public"));
  const logoUpload = multer5({
    storage: multer5.memoryStorage(),
    limits: { fileSize: 10 * 1024 * 1024 }
    // 10MB limit
  });
  app2.post("/api/logo-templates/upload", requireAdmin, logoUpload.fields([
    { name: "svg", maxCount: 1 },
    { name: "preview", maxCount: 1 }
  ]), (req, res) => {
    try {
      const id = String(req.body.id || "").trim();
      const name = String(req.body.name || "").trim();
      const brandName = String(req.body.brandName || "");
      const tagline = String(req.body.tagline || "");
      const estYear = String(req.body.estYear || "");
      const primary = String(req.body.primary || "#231f20");
      const secondary = String(req.body.secondary || "#978752");
      const accent = String(req.body.accent || "#6dc282");
      const tags = String(req.body.tags || "").split(",").map((s) => s.trim()).filter(Boolean);
      if (!id || !/^[a-z0-9\-]+$/.test(id)) {
        return res.status(400).json({ error: "Invalid id (use kebab-case letters/numbers)" });
      }
      if (!name) {
        return res.status(400).json({ error: "Name is required" });
      }
      const svgFile = req.files?.svg?.[0];
      const previewFile = req.files?.preview?.[0];
      if (!svgFile) return res.status(400).json({ error: "SVG file is required" });
      if (!previewFile) return res.status(400).json({ error: "Preview file is required" });
      const svgText = svgFile.buffer.toString("utf-8");
      const tokenIssues = [];
      ["{Brand_Name}", "{Tagline}", "{Est_Year}"].forEach((tok) => {
        if (!svgText.includes(tok)) tokenIssues.push(`Missing ${tok}`);
      });
      ["--primary", "--secondary", "--accent"].forEach((v) => {
        if (!svgText.includes(v)) tokenIssues.push(`Missing ${v}`);
      });
      if (!/^\s*<svg[\s\S]*<\/svg>\s*$/i.test(svgText)) {
        tokenIssues.push("Not a valid <svg>\u2026</svg>");
      }
      if (tokenIssues.length) {
        return res.status(400).json({ error: "SVG validation failed", details: tokenIssues });
      }
      const PUBLIC_DIR2 = path9.resolve("public");
      const MANIFEST_PATH = path9.join(PUBLIC_DIR2, "site", "data", "manifest.logo.json");
      const SRC_DIR = path9.join(PUBLIC_DIR2, "templates", "logo", "source");
      const PREV_DIR2 = path9.join(PUBLIC_DIR2, "templates", "logo", "previews");
      [PUBLIC_DIR2, path9.dirname(MANIFEST_PATH), SRC_DIR, PREV_DIR2].forEach((p) => {
        if (!fsSync.existsSync(p)) fsSync.mkdirSync(p, { recursive: true });
      });
      const svgOut = path9.join(SRC_DIR, `${id}.svg`);
      fsSync.writeFileSync(svgOut, svgFile.buffer);
      const ext = previewFile.mimetype === "image/png" ? "png" : "jpg";
      const prevOut = path9.join(PREV_DIR2, `${id}.${ext}`);
      fsSync.writeFileSync(prevOut, previewFile.buffer);
      let manifest = { collection: "logo", version: 1, items: [] };
      if (fsSync.existsSync(MANIFEST_PATH)) {
        try {
          manifest = JSON.parse(fsSync.readFileSync(MANIFEST_PATH, "utf-8"));
        } catch (e) {
          console.error("Failed to parse existing manifest:", e);
        }
      }
      manifest.collection = "logo";
      manifest.version = Number(manifest.version || 1);
      const previewUrl = `/templates/logo/previews/${id}.${ext}`;
      const svgUrl = `/templates/logo/source/${id}.svg`;
      const item = {
        id,
        name,
        previewUrl,
        svgUrl,
        defaultFields: {
          Brand_Name: brandName,
          Tagline: tagline,
          Est_Year: estYear
        },
        fieldOrder: ["Brand_Name", "Tagline", "Est_Year"],
        defaultColors: { primary, secondary, accent },
        tags
      };
      const idx = (manifest.items || []).findIndex((x) => x.id === id);
      if (idx >= 0) {
        manifest.items[idx] = item;
      } else {
        manifest.items.push(item);
      }
      fsSync.writeFileSync(MANIFEST_PATH, JSON.stringify(manifest, null, 2));
      return res.json({ ok: true, item });
    } catch (e) {
      console.error("Logo template upload error:", e);
      return res.status(500).json({ error: "Server error", detail: String(e?.message || e) });
    }
  });
  app2.post("/api/users", async (req, res) => {
    try {
      const userData = insertUserSchema.parse(req.body);
      const existingUser = await storage.getUserByFirebaseUid(userData.firebaseUid);
      if (existingUser) {
        return res.status(200).json(existingUser);
      }
      const user = await storage.createUser(userData);
      res.status(201).json(user);
    } catch (error) {
      handleError(res, error, "Failed to create user");
    }
  });
  app2.get("/api/users/profile", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      res.json(user);
    } catch (error) {
      handleError(res, error, "Failed to get user profile");
    }
  });
  app2.post("/api/brand-kits", authenticateToken2, hasProAccess, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const brandKitData = insertBrandKitSchema.parse({
        ...req.body,
        userId: user.id
      });
      const brandKit = await storage.createBrandKit(brandKitData);
      res.status(201).json(brandKit);
    } catch (error) {
      handleError(res, error, "Failed to create brand kit");
    }
  });
  app2.get("/api/brand-kits", authenticateToken2, hasProAccess, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const brandKits2 = await storage.getBrandKitsByUserId(user.id);
      res.json(brandKits2);
    } catch (error) {
      handleError(res, error, "Failed to get brand kits");
    }
  });
  app2.post("/api/creators/apply", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const existingCreator = await storage.getCreatorByUserId(user.id);
      if (existingCreator) {
        return res.status(200).json({
          success: true,
          message: "Creator application already exists",
          creator: existingCreator,
          idempotent: true
          // Flag to indicate this was an idempotent response
        });
      }
      const profileDataSchema = z5.object({
        name: z5.string().min(1, "Name is required"),
        bio: z5.string().min(10, "Bio must be at least 10 characters"),
        portfolio: z5.string().url("Portfolio must be a valid URL").optional(),
        socialLinks: z5.array(z5.string().url()).optional(),
        skills: z5.array(z5.string()).optional()
      });
      const profileData = profileDataSchema.parse(req.body);
      const creatorData = {
        userId: user.id,
        onboardingStatus: CREATOR_ONBOARDING_STATUSES.PENDING,
        profileData,
        isActive: true
      };
      const creator = await storage.createCreator(creatorData);
      await storage.createNotification(
        user.id,
        "\u{1F3A8} Your creator application has been submitted! We'll review it and get back to you soon.",
        "success"
      );
      res.status(201).json({
        success: true,
        message: "Creator application submitted successfully",
        creator
      });
    } catch (error) {
      console.error("Creator application error:", error);
      handleError(res, error, "Failed to submit creator application");
    }
  });
  app2.post("/api/creators/stripe-connect/create", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const creator = await storage.getCreatorByUserId(user.id);
      if (!creator) {
        return res.status(404).json({ error: "Creator profile not found. Please apply first." });
      }
      if (creator.onboardingStatus !== CREATOR_ONBOARDING_STATUSES.PENDING) {
        return res.status(400).json({
          error: "Creator onboarding not available",
          status: creator.onboardingStatus
        });
      }
      if (creator.stripeConnectAccountId) {
        return res.json({
          success: true,
          message: "Stripe Connect account already exists",
          accountId: creator.stripeConnectAccountId,
          creator,
          idempotent: true
          // Flag to indicate this was an idempotent response
        });
      }
      const stripeInstance = getStripe3();
      if (!stripeInstance) {
        return handleStripeUnavailable(res, "Creating Stripe Connect accounts");
      }
      if (!isValidStateTransition(creator.onboardingStatus, CREATOR_ONBOARDING_STATUSES.IN_PROGRESS)) {
        return res.status(400).json({
          error: "Invalid state transition",
          message: `Cannot transition from '${creator.onboardingStatus}' to 'in_progress'`,
          currentStatus: creator.onboardingStatus
        });
      }
      const account = await stripeInstance.accounts.create({
        type: "express",
        country: "US",
        // Default to US, could be made configurable
        email: user.email,
        metadata: {
          userId: user.id,
          creatorId: creator.id,
          createdBy: "creator-marketplace",
          createdAt: (/* @__PURE__ */ new Date()).toISOString()
        }
      });
      const updatedCreator = await storage.updateCreator(creator.id, {
        stripeConnectAccountId: account.id,
        onboardingStatus: CREATOR_ONBOARDING_STATUSES.IN_PROGRESS
      });
      await storage.createNotification(
        user.id,
        "\u{1F4B3} Stripe Connect account created! Complete your onboarding to start receiving payments.",
        "success"
      );
      res.json({
        success: true,
        message: "Stripe Connect account created successfully",
        accountId: account.id,
        creator: updatedCreator
      });
    } catch (error) {
      console.error("Stripe Connect account creation error:", error);
      handleError(res, error, "Failed to create Stripe Connect account");
    }
  });
  app2.post("/api/creators/stripe-connect/onboarding-link", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const creator = await storage.getCreatorByUserId(user.id);
      if (!creator) {
        return res.status(404).json({ error: "Creator profile not found. Please apply first." });
      }
      if (!creator.stripeConnectAccountId) {
        return res.status(404).json({
          error: "Stripe Connect account not found",
          message: "Please create your Stripe Connect account first before generating onboarding link.",
          action: "create_stripe_account"
        });
      }
      const allowedStatuses = [CREATOR_ONBOARDING_STATUSES.PENDING, CREATOR_ONBOARDING_STATUSES.IN_PROGRESS];
      if (!allowedStatuses.includes(creator.onboardingStatus)) {
        return res.status(400).json({
          error: "Onboarding link not available",
          message: `Onboarding links can only be generated for creators in 'pending' or 'in_progress' status`,
          currentStatus: creator.onboardingStatus,
          allowedStatuses
        });
      }
      const stripeInstance = getStripe3();
      if (!stripeInstance) {
        return handleStripeUnavailable(res, "Generating onboarding links");
      }
      try {
        await stripeInstance.accounts.retrieve(creator.stripeConnectAccountId);
      } catch (stripeError) {
        console.error("Stripe account verification failed:", stripeError);
        if (stripeError.code === "resource_missing") {
          return res.status(404).json({
            error: "Stripe account not found",
            message: "The Stripe Connect account appears to have been deleted. Please create a new account.",
            action: "recreate_stripe_account"
          });
        }
        throw stripeError;
      }
      const refreshUrl = buildSecureRedirectUrl2("/creator/dashboard?refresh=true");
      const returnUrl = buildSecureRedirectUrl2("/creator/dashboard?onboarding=complete");
      const accountLink = await stripeInstance.accountLinks.create({
        account: creator.stripeConnectAccountId,
        refresh_url: refreshUrl,
        return_url: returnUrl,
        type: "account_onboarding"
      });
      res.json({
        success: true,
        onboardingUrl: accountLink.url,
        expiresAt: accountLink.expires_at,
        refreshUrl,
        returnUrl,
        accountId: creator.stripeConnectAccountId
      });
    } catch (error) {
      console.error("Stripe Connect onboarding link error:", error);
      handleError(res, error, "Failed to generate onboarding link");
    }
  });
  app2.get("/api/creators/stripe-connect/status", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const creator = await storage.getCreatorByUserId(user.id);
      if (!creator) {
        return res.status(404).json({ error: "Creator profile not found" });
      }
      if (!creator.stripeConnectAccountId) {
        return res.status(404).json({
          error: "Stripe Connect account not found",
          message: "No Stripe Connect account associated with this creator profile",
          onboardingStatus: creator.onboardingStatus
        });
      }
      const stripeInstance = getStripe3();
      if (!stripeInstance) {
        return handleStripeUnavailable(res, "Checking account status");
      }
      let account;
      try {
        account = await stripeInstance.accounts.retrieve(creator.stripeConnectAccountId);
      } catch (stripeError) {
        console.error("Failed to retrieve Stripe account:", stripeError);
        if (stripeError.code === "resource_missing") {
          return res.status(404).json({
            error: "Stripe account not found",
            message: "The Stripe Connect account appears to have been deleted",
            code: "STRIPE_ACCOUNT_MISSING"
          });
        }
        return res.status(502).json({
          error: "Stripe service error",
          message: "Unable to retrieve account status from Stripe",
          code: "STRIPE_SERVICE_ERROR"
        });
      }
      const charges_enabled = account.charges_enabled;
      const payouts_enabled = account.payouts_enabled;
      const requirements = account.requirements;
      const currently_due = requirements?.currently_due || [];
      const eventually_due = requirements?.eventually_due || [];
      let newOnboardingStatus = creator.onboardingStatus;
      let payoutEnabled = creator.payoutEnabled;
      let onboardingCompletedAt = creator.onboardingCompletedAt;
      if (charges_enabled && payouts_enabled && currently_due.length === 0) {
        newOnboardingStatus = CREATOR_ONBOARDING_STATUSES.COMPLETED;
        payoutEnabled = true;
        if (!creator.onboardingCompletedAt) {
          onboardingCompletedAt = /* @__PURE__ */ new Date();
        }
      } else if (currently_due.length > 0) {
        newOnboardingStatus = CREATOR_ONBOARDING_STATUSES.IN_PROGRESS;
        payoutEnabled = false;
      }
      if (newOnboardingStatus !== creator.onboardingStatus) {
        if (!isValidStateTransition(creator.onboardingStatus, newOnboardingStatus)) {
          console.warn(`Invalid state transition attempted: ${creator.onboardingStatus} -> ${newOnboardingStatus} for creator ${creator.id}`);
        }
      }
      const hasStatusChanged = newOnboardingStatus !== creator.onboardingStatus;
      const hasPayoutChanged = payoutEnabled !== creator.payoutEnabled;
      const hasCompletionChanged = onboardingCompletedAt !== creator.onboardingCompletedAt;
      if (hasStatusChanged || hasPayoutChanged || hasCompletionChanged) {
        await storage.updateCreator(creator.id, {
          onboardingStatus: newOnboardingStatus,
          payoutEnabled,
          onboardingCompletedAt
        });
        if (newOnboardingStatus === CREATOR_ONBOARDING_STATUSES.COMPLETED && creator.onboardingStatus !== CREATOR_ONBOARDING_STATUSES.COMPLETED) {
          await storage.createNotification(
            user.id,
            "\u{1F389} Creator onboarding completed! You can now receive payments for your assets.",
            "success"
          );
        }
      }
      res.json({
        onboardingStatus: newOnboardingStatus,
        stripeAccountStatus: {
          charges_enabled,
          payouts_enabled,
          currently_due,
          eventually_due,
          disabled_reason: account.requirements?.disabled_reason,
          details_submitted: account.details_submitted,
          payouts_enabled: account.payouts_enabled
        },
        payoutEnabled,
        onboardingCompletedAt,
        requiresAction: currently_due.length > 0,
        statusChanged: hasStatusChanged,
        lastUpdated: (/* @__PURE__ */ new Date()).toISOString()
      });
    } catch (error) {
      console.error("Stripe Connect status check error:", error);
      handleError(res, error, "Failed to check Stripe Connect status");
    }
  });
  app2.get("/api/creators/profile", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const creator = await storage.getCreatorByUserId(user.id);
      if (!creator) {
        return res.status(404).json({ error: "Creator profile not found" });
      }
      const creatorAssets2 = await storage.getCreatorAssetsByCreatorId(creator.id);
      const creatorEarnings2 = await storage.getCreatorEarningsByCreatorId(creator.id);
      const totalEarnings = creatorEarnings2.reduce((sum, earning) => sum + earning.amountCents, 0);
      const pendingPayouts = creatorEarnings2.filter((earning) => earning.payoutStatus === "pending").reduce((sum, earning) => sum + earning.amountCents, 0);
      const approvedAssets = creatorAssets2.filter((asset) => asset.approvalStatus === "approved").length;
      const totalSales = creatorAssets2.reduce((sum, asset) => sum + (asset.salesCount || 0), 0);
      let stripeAccountStatus = null;
      if (creator.stripeConnectAccountId) {
        const stripeInstance = getStripe3();
        if (stripeInstance) {
          try {
            const account = await stripeInstance.accounts.retrieve(creator.stripeConnectAccountId);
            stripeAccountStatus = {
              charges_enabled: account.charges_enabled,
              payouts_enabled: account.payouts_enabled,
              currently_due: account.requirements?.currently_due || [],
              eventually_due: account.requirements?.eventually_due || [],
              disabled_reason: account.requirements?.disabled_reason,
              details_submitted: account.details_submitted
            };
          } catch (stripeError) {
            console.warn("Failed to fetch Stripe account status for profile:", stripeError);
            stripeAccountStatus = {
              error: "Unable to fetch current status",
              charges_enabled: false,
              payouts_enabled: false,
              currently_due: ["status_check_failed"]
            };
          }
        } else {
          stripeAccountStatus = {
            error: "Stripe service unavailable",
            charges_enabled: false,
            payouts_enabled: false,
            currently_due: ["stripe_service_unavailable"]
          };
        }
      }
      res.json({
        creator,
        profileData: creator.profileData,
        onboardingStatus: creator.onboardingStatus,
        stripeAccountStatus,
        earningsSummary: {
          totalEarnings,
          pendingPayouts,
          approvedAssets,
          totalSales,
          payoutEnabled: creator.payoutEnabled
        },
        stats: {
          assetsCount: creatorAssets2.length,
          approvedAssetsCount: approvedAssets,
          pendingAssetsCount: creatorAssets2.filter((asset) => asset.approvalStatus === "pending").length,
          rejectedAssetsCount: creatorAssets2.filter((asset) => asset.approvalStatus === "rejected").length
        }
      });
    } catch (error) {
      console.error("Creator profile error:", error);
      handleError(res, error, "Failed to get creator profile");
    }
  });
  const assetUpload = multer5({
    dest: "uploads/assets/",
    limits: {
      fileSize: 25 * 1024 * 1024
      // 25MB limit for digital assets
    },
    fileFilter: (req, file2, cb) => {
      const allowedTypes = [
        "image/jpeg",
        "image/jpg",
        "image/png",
        "image/gif",
        "image/webp",
        "image/svg+xml",
        "application/pdf",
        "application/zip",
        "text/plain"
      ];
      if (allowedTypes.includes(file2.mimetype)) {
        cb(null, true);
      } else {
        cb(new Error(`File type ${file2.mimetype} not allowed. Supported types: images, SVGs, PDFs, ZIP files, and text files.`));
      }
    }
  });
  app2.get("/api/creator/my-assets", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const creator = await storage.getCreatorByUserId(user.id);
      if (!creator) {
        return res.status(404).json({ error: "Creator profile not found" });
      }
      const status = req.query.status;
      if (status && !["active", "cancelled", "pending", "rejected"].includes(status)) {
        return res.status(400).json({ error: "Invalid status filter. Must be: active, cancelled, pending, or rejected" });
      }
      const creatorAssets2 = await storage.getCreatorAssetsByCreatorId(creator.id);
      let filteredAssets = creatorAssets2;
      if (status === "active") {
        filteredAssets = creatorAssets2.filter((asset) => asset.approvalStatus === "approved");
      } else if (status === "cancelled") {
        filteredAssets = creatorAssets2.filter((asset) => asset.approvalStatus === "cancelled");
      } else if (status) {
        filteredAssets = creatorAssets2.filter((asset) => asset.approvalStatus === status);
      }
      const enrichedAssets = await Promise.all(
        filteredAssets.map(async (creatorAsset) => {
          const asset = await storage.getAsset(creatorAsset.assetId);
          if (!asset) return null;
          return {
            id: creatorAsset.id,
            assetId: creatorAsset.assetId,
            title: creatorAsset.title,
            description: creatorAsset.description,
            price: creatorAsset.price,
            isExclusive: creatorAsset.isExclusive,
            salesCount: creatorAsset.salesCount,
            status: creatorAsset.approvalStatus === "approved" ? "active" : creatorAsset.approvalStatus,
            createdAt: creatorAsset.createdAt,
            asset: {
              fileName: asset.originalFileName,
              fileUrl: asset.cloudUrl,
              previewUrl: asset.previewUrl,
              fileSize: asset.fileSize,
              mimeType: asset.mimeType,
              assetType: asset.assetType,
              category: asset.category,
              tags: asset.tags,
              downloadCount: asset.downloadCount
            }
          };
        })
      );
      const validAssets = enrichedAssets.filter((asset) => asset !== null);
      validAssets.sort((a, b) => new Date(b.createdAt).getTime() - new Date(a.createdAt).getTime());
      res.json(validAssets);
    } catch (error) {
      console.error("Creator my-assets error:", error);
      handleError(res, error, "Failed to get creator assets");
    }
  });
  app2.post("/api/creator/assets/:id/cancel", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const creator = await storage.getCreatorByUserId(user.id);
      if (!creator) {
        return res.status(404).json({ error: "Creator profile not found" });
      }
      const creatorAsset = await storage.getCreatorAsset(req.params.id);
      if (!creatorAsset) {
        return res.status(404).json({ error: "Asset not found" });
      }
      if (creatorAsset.creatorId !== creator.id) {
        return res.status(403).json({ error: "Access denied. You can only cancel your own assets." });
      }
      if (creatorAsset.approvalStatus === "cancelled") {
        return res.status(400).json({ error: "Asset is already cancelled" });
      }
      await storage.updateCreatorAsset(creatorAsset.id, {
        approvalStatus: "cancelled",
        updatedAt: (/* @__PURE__ */ new Date()).toISOString()
      });
      console.log(`\u2705 Asset ${creatorAsset.id} cancelled by creator ${creator.id}`);
      res.json({
        success: true,
        message: "Asset cancelled successfully",
        assetId: creatorAsset.id
      });
    } catch (error) {
      console.error("Creator asset cancellation error:", error);
      handleError(res, error, "Failed to cancel asset");
    }
  });
  app2.get("/api/creator/payouts/summary", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const creator = await storage.getCreatorByUserId(user.id);
      if (!creator) {
        return res.status(404).json({ error: "Creator profile not found" });
      }
      const creatorEarnings2 = await storage.getCreatorEarningsByCreatorId(creator.id);
      const lifetimeEarningsCents = creatorEarnings2.reduce((sum, earning) => sum + earning.amountCents, 0);
      const pendingPayoutCents = creatorEarnings2.filter((earning) => earning.payoutStatus === "pending").reduce((sum, earning) => sum + earning.amountCents, 0);
      const paidEarnings = creatorEarnings2.filter((earning) => earning.payoutStatus === "paid").sort((a, b) => new Date(b.createdAt).getTime() - new Date(a.createdAt).getTime());
      const lastPayoutAt = paidEarnings.length > 0 ? paidEarnings[0].createdAt : void 0;
      res.json({
        lifetimeEarningsCents,
        pendingPayoutCents,
        lastPayoutAt
      });
    } catch (error) {
      console.error("Creator payouts summary error:", error);
      handleError(res, error, "Failed to get payouts summary");
    }
  });
  app2.get("/api/creator/me/marketplace", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const creator = await storage.getCreatorByUserId(user.id);
      if (!creator) {
        return res.status(404).json({ error: "Creator profile not found" });
      }
      const creatorAssets2 = await storage.getCreatorAssetsByCreatorId(creator.id);
      const groupByStatus = (status) => creatorAssets2.filter((asset) => asset.approvalStatus === status);
      const enrichAssets = async (assets2) => {
        const enriched = await Promise.all(
          assets2.map(async (creatorAsset) => {
            const asset = await storage.getAsset(creatorAsset.assetId);
            if (!asset) return null;
            return {
              id: creatorAsset.id,
              title: creatorAsset.title,
              description: creatorAsset.description,
              price: creatorAsset.price,
              salesCount: creatorAsset.salesCount || 0,
              createdAt: creatorAsset.createdAt,
              previewUrl: asset.previewUrl,
              approvalStatus: creatorAsset.approvalStatus
            };
          })
        );
        return enriched.filter(Boolean);
      };
      const [approved, pending, rejected, cancelled] = await Promise.all([
        enrichAssets(groupByStatus("approved")),
        enrichAssets(groupByStatus("pending")),
        enrichAssets(groupByStatus("rejected")),
        enrichAssets(groupByStatus("cancelled"))
      ]);
      const totalSales = creatorAssets2.reduce((sum, asset) => sum + (asset.salesCount || 0), 0);
      const totalRevenueCents = creatorAssets2.reduce((sum, asset) => sum + (asset.totalRevenue || 0), 0);
      res.json({
        assets: {
          approved,
          pending,
          rejected,
          cancelled
        },
        stats: {
          totalSales,
          totalRevenueCents
        }
      });
    } catch (error) {
      console.error("Creator marketplace overview error:", error);
      handleError(res, error, "Failed to load creator marketplace");
    }
  });
  app2.get("/api/creator/me/payouts/summary", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const creator = await storage.getCreatorByUserId(user.id);
      if (!creator) {
        return res.status(404).json({ error: "Creator profile not found" });
      }
      const creatorEarnings2 = await storage.getCreatorEarningsByCreatorId(creator.id);
      const lifetimeEarningsCents = creatorEarnings2.reduce((sum, earning) => sum + earning.amountCents, 0);
      const pendingPayoutCents = creatorEarnings2.filter((earning) => earning.payoutStatus === "pending").reduce((sum, earning) => sum + earning.amountCents, 0);
      const paidEarnings = creatorEarnings2.filter((earning) => earning.payoutStatus === "paid").sort((a, b) => new Date(b.createdAt).getTime() - new Date(a.createdAt).getTime());
      const lastPayoutAt = paidEarnings.length > 0 ? paidEarnings[0].createdAt : void 0;
      res.json({
        lifetimeEarningsCents,
        pendingPayoutCents,
        lastPayoutAt
      });
    } catch (error) {
      console.error("Creator payouts summary error:", error);
      handleError(res, error, "Failed to get payouts summary");
    }
  });
  app2.post("/api/creators/assets/upload", authenticateToken2, assetUpload.single("file"), async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      if (!req.file) {
        return res.status(400).json({ error: "No file uploaded" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const creator = await storage.getCreatorByUserId(user.id);
      if (!creator) {
        return res.status(403).json({ error: "Creator profile required. Please apply first." });
      }
      if (!creator.isActive || creator.onboardingStatus !== CREATOR_ONBOARDING_STATUSES.COMPLETED) {
        return res.status(403).json({
          error: "Creator account not active or onboarding not completed",
          status: creator.onboardingStatus
        });
      }
      const metadataSchema = z5.object({
        title: z5.string().min(1, "Title is required").max(100, "Title too long"),
        description: z5.string().optional(),
        tags: z5.array(z5.string()).default([]),
        category: z5.string().optional(),
        price: z5.number().int().min(CREATOR_MIN_PRICE_CENTS).max(CREATOR_MAX_PRICE_CENTS)
      });
      const metadata = metadataSchema.parse({
        title: req.body.title,
        description: req.body.description,
        tags: req.body.tags ? Array.isArray(req.body.tags) ? req.body.tags : JSON.parse(req.body.tags) : [],
        category: req.body.category,
        price: parseInt(req.body.price)
      });
      const fileExtension = req.file.originalname.split(".").pop() || "";
      const uniqueFileName = `${Date.now()}-${Math.random().toString(36).substr(2, 9)}.${fileExtension}`;
      const objectStorageService4 = new ObjectStorageService();
      const privateDir = objectStorageService4.getPrivateObjectDir();
      const publicPaths = objectStorageService4.getPublicObjectSearchPaths();
      const publicDir = publicPaths[0];
      const originalPath = `${privateDir}/assets/originals/${creator.id}/${uniqueFileName}`;
      const previewFileName = `preview_${uniqueFileName}`;
      const previewPath = `${publicDir}/assets/previews/${creator.id}/${previewFileName}`;
      const fileBuffer = await fs9.readFile(req.file.path);
      await objectStorageService4.uploadFile(originalPath, fileBuffer, req.file.mimetype);
      console.log(`\u{1F512} Original asset stored privately: ${originalPath}`);
      let previewUrl = null;
      if (req.file.mimetype.startsWith("image/") && req.file.mimetype !== "image/svg+xml") {
        try {
          const assetCode = toTenDigitCode(uniqueFileName);
          const watermarkedBuffer = await applyWatermark(fileBuffer, {
            opacity: 0.15,
            stockCode: assetCode
          });
          await objectStorageService4.uploadFile(previewPath, watermarkedBuffer, req.file.mimetype);
          previewUrl = `/public-objects/${previewPath.replace(publicDir + "/", "")}`;
          console.log(`\u{1F4F7} Watermarked preview generated: ${previewPath}`);
        } catch (watermarkError) {
          console.warn("Failed to generate watermarked preview:", watermarkError);
        }
      }
      await fs9.unlink(req.file.path);
      let assetType = "document";
      if (req.file.mimetype.startsWith("image/")) {
        assetType = req.file.mimetype === "image/svg+xml" ? "svg" : "image";
      } else if (req.file.mimetype === "application/pdf") {
        assetType = "pdf";
      } else if (req.file.mimetype === "application/zip") {
        assetType = "archive";
      }
      const assetData = {
        creatorId: creator.id,
        fileName: uniqueFileName,
        originalFileName: req.file.originalname,
        fileUrl: originalPath,
        // Private original path
        previewUrl,
        // Public preview path (if generated)
        fileSize: req.file.size,
        mimeType: req.file.mimetype,
        assetType,
        category: metadata.category,
        tags: metadata.tags,
        metadata: {
          uploadedBy: user.id,
          uploadedAt: (/* @__PURE__ */ new Date()).toISOString(),
          hasWatermarkedPreview: !!previewUrl
        },
        isPublic: false
        // Assets start as private until approved
      };
      const asset = await storage.createAsset(assetData);
      const creatorAssetData = {
        creatorId: creator.id,
        assetId: asset.id,
        title: metadata.title,
        description: metadata.description,
        price: metadata.price,
        approvalStatus: "pending",
        isExclusive: false
      };
      const creatorAsset = await storage.createCreatorAsset(creatorAssetData);
      await storage.createNotification(
        user.id,
        `\u{1F3A8} Asset "${metadata.title}" uploaded successfully! It's now pending approval for the marketplace.`,
        "success"
      );
      res.status(201).json({
        success: true,
        message: "Asset uploaded successfully",
        asset: {
          id: creatorAsset.id,
          assetId: asset.id,
          title: creatorAsset.title,
          description: creatorAsset.description,
          price: creatorAsset.price,
          approvalStatus: creatorAsset.approvalStatus,
          fileName: asset.fileName,
          originalFileName: asset.originalFileName,
          fileSize: asset.fileSize,
          assetType: asset.assetType,
          category: asset.category,
          tags: asset.tags,
          createdAt: creatorAsset.createdAt
        }
      });
    } catch (error) {
      if (req.file?.path) {
        try {
          await fs9.unlink(req.file.path);
        } catch (cleanupError) {
          console.warn("Failed to clean up temporary file:", cleanupError);
        }
      }
      console.error("Asset upload error:", error);
      handleError(res, error, "Failed to upload asset");
    }
  });
  app2.get("/api/creators/assets", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const creator = await storage.getCreatorByUserId(user.id);
      if (!creator) {
        return res.status(403).json({ error: "Creator profile not found" });
      }
      const creatorAssets2 = await storage.getCreatorAssetsByCreatorId(creator.id);
      const enrichedAssets = await Promise.all(
        creatorAssets2.map(async (creatorAsset) => {
          const asset = await storage.getAsset(creatorAsset.assetId);
          return {
            id: creatorAsset.id,
            assetId: creatorAsset.assetId,
            title: creatorAsset.title,
            description: creatorAsset.description,
            price: creatorAsset.price,
            approvalStatus: creatorAsset.approvalStatus,
            rejectionReason: creatorAsset.rejectionReason,
            isExclusive: creatorAsset.isExclusive,
            salesCount: creatorAsset.salesCount,
            totalEarnings: creatorAsset.totalEarnings,
            createdAt: creatorAsset.createdAt,
            updatedAt: creatorAsset.updatedAt,
            // Asset file details
            fileName: asset?.fileName,
            originalFileName: asset?.originalFileName,
            fileSize: asset?.fileSize,
            assetType: asset?.assetType,
            category: asset?.category,
            tags: asset?.tags,
            downloadCount: asset?.downloadCount
          };
        })
      );
      const stats = {
        total: enrichedAssets.length,
        pending: enrichedAssets.filter((a) => a.approvalStatus === "pending").length,
        approved: enrichedAssets.filter((a) => a.approvalStatus === "approved").length,
        rejected: enrichedAssets.filter((a) => a.approvalStatus === "rejected").length,
        totalSales: enrichedAssets.reduce((sum, a) => sum + (a.salesCount || 0), 0),
        totalEarnings: enrichedAssets.reduce((sum, a) => sum + (a.totalEarnings || 0), 0)
      };
      res.json({
        assets: enrichedAssets,
        stats
      });
    } catch (error) {
      console.error("Creator assets list error:", error);
      handleError(res, error, "Failed to get creator assets");
    }
  });
  app2.get("/api/creators/assets/:id", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const creator = await storage.getCreatorByUserId(user.id);
      if (!creator) {
        return res.status(403).json({ error: "Creator profile not found" });
      }
      const creatorAsset = await storage.getCreatorAsset(req.params.id);
      if (!creatorAsset) {
        return res.status(404).json({ error: "Asset not found" });
      }
      if (creatorAsset.creatorId !== creator.id) {
        return res.status(403).json({ error: "Access denied" });
      }
      const asset = await storage.getAsset(creatorAsset.assetId);
      if (!asset) {
        return res.status(404).json({ error: "Asset file not found" });
      }
      const enrichedAsset = {
        id: creatorAsset.id,
        assetId: creatorAsset.assetId,
        title: creatorAsset.title,
        description: creatorAsset.description,
        price: creatorAsset.price,
        approvalStatus: creatorAsset.approvalStatus,
        rejectionReason: creatorAsset.rejectionReason,
        isExclusive: creatorAsset.isExclusive,
        salesCount: creatorAsset.salesCount,
        totalEarnings: creatorAsset.totalEarnings,
        createdAt: creatorAsset.createdAt,
        updatedAt: creatorAsset.updatedAt,
        // Asset file details
        fileName: asset.fileName,
        originalFileName: asset.originalFileName,
        fileSize: asset.fileSize,
        assetType: asset.assetType,
        category: asset.category,
        tags: asset.tags,
        downloadCount: asset.downloadCount,
        metadata: asset.metadata
      };
      res.json(enrichedAsset);
    } catch (error) {
      console.error("Creator asset details error:", error);
      handleError(res, error, "Failed to get asset details");
    }
  });
  app2.patch("/api/creators/assets/:id", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const creator = await storage.getCreatorByUserId(user.id);
      if (!creator) {
        return res.status(403).json({ error: "Creator profile not found" });
      }
      const creatorAsset = await storage.getCreatorAsset(req.params.id);
      if (!creatorAsset) {
        return res.status(404).json({ error: "Asset not found" });
      }
      if (creatorAsset.creatorId !== creator.id) {
        return res.status(403).json({ error: "Access denied" });
      }
      if (creatorAsset.approvalStatus === "approved") {
        return res.status(400).json({
          error: "Cannot edit approved assets. Contact support if changes are needed."
        });
      }
      const updateSchema = z5.object({
        title: z5.string().min(1, "Title is required").max(100, "Title too long").optional(),
        description: z5.string().optional(),
        price: z5.number().int().min(CREATOR_MIN_PRICE_CENTS).max(CREATOR_MAX_PRICE_CENTS).optional(),
        tags: z5.array(z5.string()).optional(),
        category: z5.string().optional()
      });
      const updateData = updateSchema.parse(req.body);
      const updatedCreatorAsset = await storage.updateCreatorAsset(req.params.id, updateData);
      if (!updatedCreatorAsset) {
        return res.status(404).json({ error: "Asset not found" });
      }
      if (updateData.tags !== void 0 || updateData.category !== void 0) {
        const assetUpdates = {};
        if (updateData.tags !== void 0) assetUpdates.tags = updateData.tags;
        if (updateData.category !== void 0) assetUpdates.category = updateData.category;
        if (Object.keys(assetUpdates).length > 0) {
          await storage.updateAsset(updatedCreatorAsset.assetId, assetUpdates);
        }
      }
      res.json({
        success: true,
        message: "Asset updated successfully",
        asset: updatedCreatorAsset
      });
    } catch (error) {
      console.error("Creator asset update error:", error);
      handleError(res, error, "Failed to update asset");
    }
  });
  app2.delete("/api/creators/assets/:id", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const creator = await storage.getCreatorByUserId(user.id);
      if (!creator) {
        return res.status(403).json({ error: "Creator profile not found" });
      }
      const creatorAsset = await storage.getCreatorAsset(req.params.id);
      if (!creatorAsset) {
        return res.status(404).json({ error: "Asset not found" });
      }
      if (creatorAsset.creatorId !== creator.id) {
        return res.status(403).json({ error: "Access denied" });
      }
      const deleted = await storage.deleteCreatorAsset(req.params.id);
      if (!deleted) {
        return res.status(404).json({ error: "Asset not found" });
      }
      await storage.updateAsset(creatorAsset.assetId, { isPublic: false });
      res.status(204).send();
    } catch (error) {
      console.error("Creator asset delete error:", error);
      handleError(res, error, "Failed to delete asset");
    }
  });
  app2.get("/api/marketplace/assets", async (req, res) => {
    try {
      const page = parseInt(req.query.page) || 1;
      const limit = Math.min(parseInt(req.query.limit) || 20, 100);
      const category = req.query.category;
      const search = req.query.search;
      const minPrice = req.query.minPrice ? parseInt(req.query.minPrice) : void 0;
      const maxPrice = req.query.maxPrice ? parseInt(req.query.maxPrice) : void 0;
      const assetType = req.query.assetType;
      const sortBy = req.query.sortBy || "newest";
      const approvedAssets = await storage.getCreatorAssetsByStatus("approved");
      let filteredAssets = approvedAssets;
      if (search) {
        const searchLower = search.toLowerCase();
        filteredAssets = filteredAssets.filter(
          (asset) => asset.title.toLowerCase().includes(searchLower) || asset.description && asset.description.toLowerCase().includes(searchLower)
        );
      }
      if (minPrice !== void 0) {
        filteredAssets = filteredAssets.filter((asset) => asset.price >= minPrice);
      }
      if (maxPrice !== void 0) {
        filteredAssets = filteredAssets.filter((asset) => asset.price <= maxPrice);
      }
      const enrichedAssets = await Promise.all(
        filteredAssets.map(async (creatorAsset) => {
          const asset = await storage.getAsset(creatorAsset.assetId);
          const creator = await storage.getCreator(creatorAsset.creatorId);
          if (!asset || !creator) return null;
          if (category && asset.category !== category) return null;
          if (assetType && asset.assetType !== assetType) return null;
          return {
            id: creatorAsset.id,
            assetId: creatorAsset.assetId,
            title: creatorAsset.title,
            description: creatorAsset.description,
            price: creatorAsset.price,
            isExclusive: creatorAsset.isExclusive,
            salesCount: creatorAsset.salesCount,
            createdAt: creatorAsset.createdAt,
            // Asset details
            originalFileName: asset.originalFileName,
            fileSize: asset.fileSize,
            assetType: asset.assetType,
            category: asset.category,
            tags: asset.tags,
            downloadCount: asset.downloadCount,
            // Creator details (minimal for privacy)
            creator: {
              id: creator.id,
              name: creator.profileData?.name || "Anonymous Creator"
              // Don't expose sensitive creator data
            }
          };
        })
      );
      const validAssets = enrichedAssets.filter((asset) => asset !== null);
      validAssets.sort((a, b) => {
        switch (sortBy) {
          case "oldest":
            return new Date(a.createdAt).getTime() - new Date(b.createdAt).getTime();
          case "price_low":
            return a.price - b.price;
          case "price_high":
            return b.price - a.price;
          case "popular":
            return b.salesCount + b.downloadCount - (a.salesCount + a.downloadCount);
          case "newest":
          default:
            return new Date(b.createdAt).getTime() - new Date(a.createdAt).getTime();
        }
      });
      const startIndex = (page - 1) * limit;
      const endIndex = startIndex + limit;
      const paginatedAssets = validAssets.slice(startIndex, endIndex);
      const categories = [...new Set(validAssets.map((a) => a.category).filter(Boolean))];
      const assetTypes = [...new Set(validAssets.map((a) => a.assetType))];
      res.json({
        assets: paginatedAssets,
        pagination: {
          page,
          limit,
          total: validAssets.length,
          pages: Math.ceil(validAssets.length / limit),
          hasNext: endIndex < validAssets.length,
          hasPrev: page > 1
        },
        filters: {
          categories: categories.sort(),
          assetTypes: assetTypes.sort(),
          priceRange: {
            min: Math.min(...validAssets.map((a) => a.price)),
            max: Math.max(...validAssets.map((a) => a.price))
          }
        }
      });
    } catch (error) {
      console.error("Marketplace assets browse error:", error);
      handleError(res, error, "Failed to browse marketplace assets");
    }
  });
  app2.get("/api/marketplace/assets/:id", async (req, res) => {
    try {
      const creatorAsset = await storage.getCreatorAsset(req.params.id);
      if (!creatorAsset) {
        return res.status(404).json({ error: "Asset not found" });
      }
      if (creatorAsset.approvalStatus !== "approved") {
        return res.status(404).json({ error: "Asset not available" });
      }
      const asset = await storage.getAsset(creatorAsset.assetId);
      if (!asset) {
        return res.status(404).json({ error: "Asset file not found" });
      }
      const creator = await storage.getCreator(creatorAsset.creatorId);
      if (!creator) {
        return res.status(404).json({ error: "Creator not found" });
      }
      const publicAssetDetails = {
        id: creatorAsset.id,
        assetId: creatorAsset.assetId,
        title: creatorAsset.title,
        description: creatorAsset.description,
        price: creatorAsset.price,
        isExclusive: creatorAsset.isExclusive,
        salesCount: creatorAsset.salesCount,
        createdAt: creatorAsset.createdAt,
        // Asset details
        originalFileName: asset.originalFileName,
        fileSize: asset.fileSize,
        assetType: asset.assetType,
        category: asset.category,
        tags: asset.tags,
        downloadCount: asset.downloadCount,
        // Creator details (minimal for privacy)
        creator: {
          id: creator.id,
          name: creator.profileData?.name || "Anonymous Creator",
          bio: creator.profileData?.bio || null
          // Don't expose sensitive creator data like earnings, etc.
        }
      };
      res.json(publicAssetDetails);
    } catch (error) {
      console.error("Marketplace asset details error:", error);
      handleError(res, error, "Failed to get asset details");
    }
  });
  app2.get("/api/marketplace/creators/:creatorId/assets", async (req, res) => {
    try {
      const creator = await storage.getCreator(req.params.creatorId);
      if (!creator) {
        return res.status(404).json({ error: "Creator not found" });
      }
      if (!creator.isActive) {
        return res.status(404).json({ error: "Creator not available" });
      }
      const creatorAssets2 = await storage.getCreatorAssetsByCreatorId(creator.id);
      const approvedAssets = creatorAssets2.filter((asset) => asset.approvalStatus === "approved");
      const enrichedAssets = await Promise.all(
        approvedAssets.map(async (creatorAsset) => {
          const asset = await storage.getAsset(creatorAsset.assetId);
          if (!asset) return null;
          return {
            id: creatorAsset.id,
            assetId: creatorAsset.assetId,
            title: creatorAsset.title,
            description: creatorAsset.description,
            price: creatorAsset.price,
            isExclusive: creatorAsset.isExclusive,
            salesCount: creatorAsset.salesCount,
            createdAt: creatorAsset.createdAt,
            // Asset details
            originalFileName: asset.originalFileName,
            fileSize: asset.fileSize,
            assetType: asset.assetType,
            category: asset.category,
            tags: asset.tags,
            downloadCount: asset.downloadCount
          };
        })
      );
      const validAssets = enrichedAssets.filter((asset) => asset !== null);
      validAssets.sort((a, b) => new Date(b.createdAt).getTime() - new Date(a.createdAt).getTime());
      res.json({
        creator: {
          id: creator.id,
          name: creator.profileData?.name || "Anonymous Creator",
          bio: creator.profileData?.bio || null,
          portfolio: creator.profileData?.portfolio || null
        },
        assets: validAssets,
        stats: {
          totalAssets: validAssets.length,
          totalSales: validAssets.reduce((sum, a) => sum + (a.salesCount || 0), 0)
        }
      });
    } catch (error) {
      console.error("Creator marketplace assets error:", error);
      handleError(res, error, "Failed to get creator assets");
    }
  });
  const buildEnrichedAssetResponse = async (creatorAssets2, page = 1, limit = 50, sortOrder = "asc") => {
    const enrichedAssets = await Promise.all(
      creatorAssets2.map(async (creatorAsset) => {
        const asset = await storage.getAsset(creatorAsset.assetId);
        const creator = await storage.getCreator(creatorAsset.creatorId);
        const user = creator ? await storage.getUser(creator.userId) : null;
        return {
          id: creatorAsset.id,
          assetId: creatorAsset.assetId,
          title: creatorAsset.title,
          description: creatorAsset.description,
          price: creatorAsset.price,
          isExclusive: creatorAsset.isExclusive,
          createdAt: creatorAsset.createdAt,
          approvalStatus: creatorAsset.approvalStatus,
          rejectionReason: creatorAsset.rejectionReason,
          // Asset details
          fileName: asset?.fileName,
          originalFileName: asset?.originalFileName,
          fileSize: asset?.fileSize,
          assetType: asset?.assetType,
          category: asset?.category,
          tags: asset?.tags,
          fileUrl: asset?.fileUrl,
          // Admin can see file URLs for review
          // Creator details (for admin review)
          creator: {
            id: creator?.id,
            userId: creator?.userId,
            name: creator?.profileData?.name,
            email: user?.email,
            onboardingStatus: creator?.onboardingStatus
          }
        };
      })
    );
    enrichedAssets.sort((a, b) => {
      const aTime = new Date(a.createdAt).getTime();
      const bTime = new Date(b.createdAt).getTime();
      return sortOrder === "asc" ? aTime - bTime : bTime - aTime;
    });
    const startIndex = (page - 1) * limit;
    const endIndex = startIndex + limit;
    const paginatedAssets = enrichedAssets.slice(startIndex, endIndex);
    return {
      assets: paginatedAssets,
      count: paginatedAssets.length,
      total: enrichedAssets.length,
      page,
      limit,
      totalPages: Math.ceil(enrichedAssets.length / limit),
      hasNextPage: endIndex < enrichedAssets.length,
      hasPrevPage: page > 1
    };
  };
  app2.get("/api/admin/assets/pending", requireAdmin, async (req, res) => {
    try {
      const page = parseInt(req.query.page) || 1;
      const limit = Math.min(parseInt(req.query.limit) || 50, 100);
      const pendingAssets = await storage.getCreatorAssetsByStatus("pending");
      const response = await buildEnrichedAssetResponse(pendingAssets, page, limit, "asc");
      res.json(response);
    } catch (error) {
      console.error("Admin pending assets error:", error);
      handleError(res, error, "Failed to get pending assets");
    }
  });
  app2.get("/api/admin/assets/approved", requireAdmin, async (req, res) => {
    try {
      const page = parseInt(req.query.page) || 1;
      const limit = Math.min(parseInt(req.query.limit) || 50, 100);
      const approvedAssets = await storage.getCreatorAssetsByStatus("approved");
      const response = await buildEnrichedAssetResponse(approvedAssets, page, limit, "desc");
      res.json(response);
    } catch (error) {
      console.error("Admin approved assets error:", error);
      handleError(res, error, "Failed to get approved assets");
    }
  });
  app2.get("/api/admin/assets/rejected", requireAdmin, async (req, res) => {
    try {
      const page = parseInt(req.query.page) || 1;
      const limit = Math.min(parseInt(req.query.limit) || 50, 100);
      const rejectedAssets = await storage.getCreatorAssetsByStatus("rejected");
      const response = await buildEnrichedAssetResponse(rejectedAssets, page, limit, "desc");
      res.json(response);
    } catch (error) {
      console.error("Admin rejected assets error:", error);
      handleError(res, error, "Failed to get rejected assets");
    }
  });
  app2.post("/api/admin/assets/:id/approve", requireAdmin, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "Admin not authenticated" });
      }
      const creatorAsset = await storage.getCreatorAsset(req.params.id);
      if (!creatorAsset) {
        return res.status(404).json({ error: "Asset not found" });
      }
      if (creatorAsset.approvalStatus !== "pending") {
        return res.status(400).json({
          error: "Asset is not pending approval",
          currentStatus: creatorAsset.approvalStatus
        });
      }
      const approvedAsset = await storage.approveCreatorAsset(req.params.id, req.user.uid);
      if (!approvedAsset) {
        return res.status(404).json({ error: "Asset not found" });
      }
      await storage.updateAsset(approvedAsset.assetId, { isPublic: true });
      const creator = await storage.getCreator(approvedAsset.creatorId);
      if (creator) {
        await storage.createNotification(
          creator.userId,
          `\u{1F389} Your asset "${approvedAsset.title}" has been approved and is now live in the marketplace!`,
          "success"
        );
      }
      console.log(`\u2705 Asset ${req.params.id} approved by admin ${req.user.uid}`);
      res.json({
        success: true,
        message: "Asset approved successfully",
        asset: approvedAsset
      });
    } catch (error) {
      console.error("Admin asset approval error:", error);
      handleError(res, error, "Failed to approve asset");
    }
  });
  app2.post("/api/admin/assets/:id/reject", requireAdmin, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "Admin not authenticated" });
      }
      const creatorAsset = await storage.getCreatorAsset(req.params.id);
      if (!creatorAsset) {
        return res.status(404).json({ error: "Asset not found" });
      }
      if (creatorAsset.approvalStatus !== "pending") {
        return res.status(400).json({
          error: "Asset is not pending approval",
          currentStatus: creatorAsset.approvalStatus
        });
      }
      const rejectionSchema = z5.object({
        reason: z5.string().min(10, "Rejection reason must be at least 10 characters")
      });
      const { reason } = rejectionSchema.parse(req.body);
      const rejectedAsset = await storage.rejectCreatorAsset(req.params.id, reason);
      if (!rejectedAsset) {
        return res.status(404).json({ error: "Asset not found" });
      }
      const creator = await storage.getCreator(rejectedAsset.creatorId);
      if (creator) {
        await storage.createNotification(
          creator.userId,
          `\u274C Your asset "${rejectedAsset.title}" was not approved. Reason: ${reason}`,
          "warning"
        );
      }
      console.log(`\u274C Asset ${req.params.id} rejected by admin ${req.user.uid}: ${reason}`);
      res.json({
        success: true,
        message: "Asset rejected",
        asset: rejectedAsset,
        rejectionReason: reason
      });
    } catch (error) {
      console.error("Admin asset rejection error:", error);
      handleError(res, error, "Failed to reject asset");
    }
  });
  app2.get("/api/brand-kits/:id", authenticateToken2, hasProAccess, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const brandKit = await storage.getBrandKit(req.params.id);
      if (!brandKit) {
        return res.status(404).json({ error: "Brand kit not found" });
      }
      if (brandKit.userId !== user.id) {
        return res.status(403).json({ error: "Access denied" });
      }
      res.json(brandKit);
    } catch (error) {
      handleError(res, error, "Failed to get brand kit");
    }
  });
  app2.put("/api/brand-kits/:id", authenticateToken2, hasProAccess, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const existingBrandKit = await storage.getBrandKit(req.params.id);
      if (!existingBrandKit) {
        return res.status(404).json({ error: "Brand kit not found" });
      }
      if (existingBrandKit.userId !== user.id) {
        return res.status(403).json({ error: "Access denied" });
      }
      const updateData = insertBrandKitSchema.partial().parse(req.body);
      const updatedBrandKit = await storage.updateBrandKit(req.params.id, updateData);
      if (!updatedBrandKit) {
        return res.status(404).json({ error: "Brand kit not found" });
      }
      res.json(updatedBrandKit);
    } catch (error) {
      handleError(res, error, "Failed to update brand kit");
    }
  });
  app2.delete("/api/brand-kits/:id", authenticateToken2, hasProAccess, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const existingBrandKit = await storage.getBrandKit(req.params.id);
      if (!existingBrandKit) {
        return res.status(404).json({ error: "Brand kit not found" });
      }
      if (existingBrandKit.userId !== user.id) {
        return res.status(403).json({ error: "Access denied" });
      }
      const deleted = await storage.deleteBrandKit(req.params.id);
      if (!deleted) {
        return res.status(404).json({ error: "Brand kit not found" });
      }
      res.status(204).send();
    } catch (error) {
      handleError(res, error, "Failed to delete brand kit");
    }
  });
  app2.post("/api/business-names", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const businessNameData = insertBusinessNameSchema.parse({
        ...req.body,
        userId: user.id
      });
      const businessName = await storage.createBusinessName(businessNameData);
      res.status(201).json(businessName);
    } catch (error) {
      handleError(res, error, "Failed to create business name");
    }
  });
  app2.get("/api/business-names", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const businessNames2 = await storage.getBusinessNamesByUserId(user.id);
      res.json(businessNames2);
    } catch (error) {
      handleError(res, error, "Failed to get business names");
    }
  });
  app2.get("/api/business-names/:id", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const businessName = await storage.getBusinessName(req.params.id);
      if (!businessName) {
        return res.status(404).json({ error: "Business name not found" });
      }
      if (businessName.userId !== user.id) {
        return res.status(403).json({ error: "Access denied" });
      }
      res.json(businessName);
    } catch (error) {
      handleError(res, error, "Failed to get business name");
    }
  });
  app2.put("/api/business-names/:id", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const existingBusinessName = await storage.getBusinessName(req.params.id);
      if (!existingBusinessName) {
        return res.status(404).json({ error: "Business name not found" });
      }
      if (existingBusinessName.userId !== user.id) {
        return res.status(403).json({ error: "Access denied" });
      }
      const updateData = insertBusinessNameSchema.partial().parse(req.body);
      const updatedBusinessName = await storage.updateBusinessName(req.params.id, updateData);
      if (!updatedBusinessName) {
        return res.status(404).json({ error: "Business name not found" });
      }
      res.json(updatedBusinessName);
    } catch (error) {
      handleError(res, error, "Failed to update business name");
    }
  });
  app2.delete("/api/business-names/:id", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const existingBusinessName = await storage.getBusinessName(req.params.id);
      if (!existingBusinessName) {
        return res.status(404).json({ error: "Business name not found" });
      }
      if (existingBusinessName.userId !== user.id) {
        return res.status(403).json({ error: "Access denied" });
      }
      const deleted = await storage.deleteBusinessName(req.params.id);
      if (!deleted) {
        return res.status(404).json({ error: "Business name not found" });
      }
      res.status(204).send();
    } catch (error) {
      handleError(res, error, "Failed to delete business name");
    }
  });
  app2.get("/api/business-names/saved", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const savedBusinessNames = await storage.getSavedBusinessNamesByUserId(user.id);
      res.json(savedBusinessNames);
    } catch (error) {
      handleError(res, error, "Failed to get saved business names");
    }
  });
  app2.post("/api/business-names/saved", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const businessNameData = insertBusinessNameSchema.parse({
        ...req.body,
        userId: user.id,
        isSaved: true
      });
      const businessName = await storage.createBusinessName(businessNameData);
      res.status(201).json(businessName);
    } catch (error) {
      handleError(res, error, "Failed to save business name");
    }
  });
  app2.delete("/api/business-names/saved/:id", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const existingBusinessName = await storage.getBusinessName(req.params.id);
      if (!existingBusinessName) {
        return res.status(404).json({ error: "Business name not found" });
      }
      if (existingBusinessName.userId !== user.id) {
        return res.status(403).json({ error: "Access denied" });
      }
      if (!existingBusinessName.isSaved) {
        return res.status(400).json({ error: "Business name is not saved" });
      }
      const deleted = await storage.deleteBusinessName(req.params.id);
      if (!deleted) {
        return res.status(404).json({ error: "Business name not found" });
      }
      res.status(204).send();
    } catch (error) {
      handleError(res, error, "Failed to delete saved business name");
    }
  });
  app2.post("/api/business-names/generate", async (req, res) => {
    try {
      const {
        industry,
        keywords,
        style,
        count,
        creativity,
        description,
        vibe,
        length_range,
        starts_with,
        must_include,
        must_exclude
      } = req.body;
      if (!industry && !keywords) {
        return res.status(400).json({ error: "Either industry or keywords is required" });
      }
      const result = await generateBusinessNames({
        industry,
        keywords,
        style,
        count,
        creativity,
        description,
        vibe,
        length_range,
        starts_with,
        must_include,
        must_exclude
      });
      res.json(result);
    } catch (error) {
      handleError(res, error, "Failed to generate business names");
    }
  });
  const sloganRateLimit = /* @__PURE__ */ new Map();
  const SLOGAN_RATE_LIMIT = 30;
  const SLOGAN_RATE_WINDOW = 60 * 1e3;
  const planRateLimit = /* @__PURE__ */ new Map();
  const PLAN_RATE_LIMIT = 20;
  const PLAN_RATE_WINDOW = 60 * 1e3;
  const passwordRateLimit = /* @__PURE__ */ new Map();
  const PASSWORD_RATE_LIMIT = 5;
  const PASSWORD_RATE_WINDOW = 60 * 1e3;
  function checkSloganRateLimit(ip) {
    const now = Date.now();
    const clientData = sloganRateLimit.get(ip);
    if (!clientData || now > clientData.resetTime) {
      sloganRateLimit.set(ip, { count: 1, resetTime: now + SLOGAN_RATE_WINDOW });
      return true;
    }
    if (clientData.count >= SLOGAN_RATE_LIMIT) {
      return false;
    }
    clientData.count++;
    return true;
  }
  function checkPlanRateLimit(ip) {
    const now = Date.now();
    const clientData = planRateLimit.get(ip);
    if (!clientData || now > clientData.resetTime) {
      planRateLimit.set(ip, { count: 1, resetTime: now + PLAN_RATE_WINDOW });
      return true;
    }
    if (clientData.count >= PLAN_RATE_LIMIT) {
      return false;
    }
    clientData.count++;
    return true;
  }
  function checkPasswordRateLimit(userIdentifier, ip) {
    const now = Date.now();
    const compositeKey = `${userIdentifier}:${ip}`;
    const clientData = passwordRateLimit.get(compositeKey);
    if (!clientData || now > clientData.resetTime) {
      passwordRateLimit.set(compositeKey, { count: 1, resetTime: now + PASSWORD_RATE_WINDOW });
      return true;
    }
    if (clientData.count >= PASSWORD_RATE_LIMIT) {
      return false;
    }
    clientData.count++;
    return true;
  }
  let TOTP_ENCRYPTION_KEY = process.env.TOTP_ENCRYPTION_KEY;
  if (!TOTP_ENCRYPTION_KEY) {
    if (process.env.NODE_ENV === "production") {
      console.error("\u{1F6A8} CRITICAL: TOTP_ENCRYPTION_KEY environment variable is required for TOTP functionality");
      throw new Error("TOTP_ENCRYPTION_KEY is required in production");
    } else {
      TOTP_ENCRYPTION_KEY = "1d58cc60fc25367aaf564abd6051ad5f37cf9f52727bc1a726cbfb3990e3118a";
      console.warn("\u26A0\uFE0F Using temporary TOTP encryption key for development. Set TOTP_ENCRYPTION_KEY environment variable for production use.");
    }
  }
  function encryptTotpSecret(secret) {
    if (!TOTP_ENCRYPTION_KEY) {
      throw new Error("TOTP encryption key not configured");
    }
    const iv = crypto4.randomBytes(16);
    const cipher = crypto4.createCipherGCM("aes-256-gcm", Buffer.from(TOTP_ENCRYPTION_KEY, "hex"));
    cipher.setIVLength(16);
    let encrypted = cipher.update(secret, "utf8", "hex");
    encrypted += cipher.final("hex");
    const authTag = cipher.getAuthTag();
    return iv.toString("hex") + ":" + authTag.toString("hex") + ":" + encrypted;
  }
  function decryptTotpSecret(encryptedSecret) {
    if (!TOTP_ENCRYPTION_KEY) {
      throw new Error("TOTP encryption key not configured");
    }
    const parts = encryptedSecret.split(":");
    if (parts.length !== 3) {
      throw new Error("Invalid encrypted secret format");
    }
    const iv = Buffer.from(parts[0], "hex");
    const authTag = Buffer.from(parts[1], "hex");
    const encrypted = parts[2];
    const decipher = crypto4.createDecipherGCM("aes-256-gcm", Buffer.from(TOTP_ENCRYPTION_KEY, "hex"));
    decipher.setAuthTag(authTag);
    let decrypted = decipher.update(encrypted, "hex", "utf8");
    decrypted += decipher.final("utf8");
    return decrypted;
  }
  function generateBackupCodes() {
    const codes = [];
    for (let i = 0; i < 10; i++) {
      const code = crypto4.randomBytes(4).toString("hex").toUpperCase();
      codes.push(code);
    }
    return codes;
  }
  async function hashBackupCodes(codes) {
    const hashedCodes = [];
    for (const code of codes) {
      const hashed = await bcrypt.hash(code, 12);
      hashedCodes.push(hashed);
    }
    return hashedCodes;
  }
  async function verifyBackupCode(plainCode, hashedCodes) {
    for (let i = 0; i < hashedCodes.length; i++) {
      const isMatch = await bcrypt.compare(plainCode, hashedCodes[i]);
      if (isMatch) {
        const remainingCodes = hashedCodes.filter((_, index2) => index2 !== i);
        return { isValid: true, remainingCodes };
      }
    }
    return { isValid: false, remainingCodes: hashedCodes };
  }
  app2.post("/api/security/totp/setup", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const clientIp = req.ip || req.connection.remoteAddress || "unknown";
      if (!checkPasswordRateLimit(req.user.uid, clientIp)) {
        return res.status(429).json({
          error: "Too many security requests. Please wait before trying again.",
          retryAfter: Math.ceil(PASSWORD_RATE_WINDOW / 1e3)
        });
      }
      const secret = authenticator.generateSecret();
      const serviceName = "IBrandBiz";
      const accountName = req.user.email || req.user.uid;
      const otpauthURL = authenticator.keyuri(accountName, serviceName, secret);
      const qrCodeDataUrl = await QRCode.toDataURL(otpauthURL);
      const encryptedSecret = encryptTotpSecret(secret);
      await storage.setTotpSecret(req.user.uid, encryptedSecret);
      res.json({
        qrCode: qrCodeDataUrl,
        secret,
        // Send plaintext for manual entry
        backupCodes: []
        // Will be generated after verification
      });
    } catch (error) {
      console.error("TOTP setup error:", error);
      handleError(res, error, "Failed to setup TOTP");
    }
  });
  app2.post("/api/security/totp/verify", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const clientIp = req.ip || req.connection.remoteAddress || "unknown";
      if (!checkPasswordRateLimit(req.user.uid, clientIp)) {
        return res.status(429).json({
          error: "Too many security requests. Please wait before trying again.",
          retryAfter: Math.ceil(PASSWORD_RATE_WINDOW / 1e3)
        });
      }
      const { token } = req.body;
      if (!token) {
        return res.status(400).json({ error: "TOTP token is required" });
      }
      const encryptedSecret = await storage.getTotpSecret(req.user.uid);
      if (!encryptedSecret) {
        return res.status(400).json({ error: "TOTP setup not initiated. Please start setup first." });
      }
      const secret = decryptTotpSecret(encryptedSecret);
      const isValid = authenticator.verify({
        token: token.toString(),
        secret,
        window: 2
        // Allow 2 steps tolerance
      });
      if (!isValid) {
        return res.status(400).json({ error: "Invalid TOTP token. Please try again." });
      }
      const plaintextBackupCodes = generateBackupCodes();
      const hashedBackupCodes = await hashBackupCodes(plaintextBackupCodes);
      await storage.enableTotp(req.user.uid, hashedBackupCodes);
      res.json({
        success: true,
        backupCodes: plaintextBackupCodes,
        // Return plaintext codes to user (one-time display)
        message: "Two-factor authentication has been successfully enabled. Save these backup codes securely!"
      });
    } catch (error) {
      console.error("TOTP verification error:", error);
      handleError(res, error, "Failed to verify TOTP");
    }
  });
  app2.post("/api/security/totp/disable", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const clientIp = req.ip || req.connection.remoteAddress || "unknown";
      if (!checkPasswordRateLimit(req.user.uid, clientIp)) {
        return res.status(429).json({
          error: "Too many security requests. Please wait before trying again.",
          retryAfter: Math.ceil(PASSWORD_RATE_WINDOW / 1e3)
        });
      }
      const { currentPassword, totpToken } = req.body;
      if (!currentPassword && !totpToken) {
        return res.status(400).json({
          error: "Current password or TOTP token required to disable two-factor authentication"
        });
      }
      if (totpToken) {
        const encryptedSecret = await storage.getTotpSecret(req.user.uid);
        if (encryptedSecret) {
          const secret = decryptTotpSecret(encryptedSecret);
          const isValid = authenticator.verify({
            token: totpToken.toString(),
            secret,
            window: 2
          });
          if (!isValid) {
            return res.status(400).json({ error: "Invalid TOTP token" });
          }
        }
      }
      await storage.disableTotp(req.user.uid);
      res.json({
        success: true,
        message: "Two-factor authentication has been disabled."
      });
    } catch (error) {
      console.error("TOTP disable error:", error);
      handleError(res, error, "Failed to disable TOTP");
    }
  });
  app2.get("/api/security/totp/status", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      res.json({
        enabled: !!user.totpEnabled,
        hasBackupCodes: !!(user.totpBackupCodes && user.totpBackupCodes.length > 0),
        backupCodesCount: user.totpBackupCodes?.length || 0
      });
    } catch (error) {
      console.error("TOTP status error:", error);
      handleError(res, error, "Failed to get TOTP status");
    }
  });
  app2.post("/api/security/totp/verify-backup", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const clientIp = req.ip || req.connection.remoteAddress || "unknown";
      if (!checkPasswordRateLimit(req.user.uid, clientIp)) {
        return res.status(429).json({
          error: "Too many security requests. Please wait before trying again.",
          retryAfter: Math.ceil(PASSWORD_RATE_WINDOW / 1e3)
        });
      }
      const { backupCode } = req.body;
      if (!backupCode) {
        return res.status(400).json({ error: "Backup code is required" });
      }
      const hashedBackupCodes = await storage.getTotpBackupCodes(req.user.uid);
      if (!hashedBackupCodes || hashedBackupCodes.length === 0) {
        return res.status(400).json({ error: "No backup codes available" });
      }
      const { isValid, remainingCodes } = await verifyBackupCode(backupCode, hashedBackupCodes);
      if (!isValid) {
        return res.status(400).json({ error: "Invalid backup code" });
      }
      await storage.updateTotpBackupCodes(req.user.uid, remainingCodes);
      res.json({
        success: true,
        message: "Backup code verified successfully",
        remainingBackupCodes: remainingCodes.length
      });
    } catch (error) {
      console.error("Backup code verification error:", error);
      handleError(res, error, "Failed to verify backup code");
    }
  });
  app2.post("/api/ai/slogan", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const clientIp = req.ip || req.connection.remoteAddress || "unknown";
      if (!checkSloganRateLimit(clientIp)) {
        return res.status(429).json({
          error: "Rate limit exceeded. Maximum 30 requests per minute."
        });
      }
      const { brandName, description, tone, industry, audience, maxResults } = req.body;
      if (!brandName || typeof brandName !== "string" || brandName.trim().length === 0) {
        return res.status(400).json({ error: "brandName is required and must be a non-empty string" });
      }
      let user;
      try {
        user = await storage.getUserByFirebaseUid(req.user.uid);
      } catch (dbError) {
        const isDevelopment = process.env.NODE_ENV === "development" || process.env.NODE_ENV !== "production";
        if (isDevelopment) {
          console.warn("Database unavailable, using mock user for testing:", dbError);
          user = {
            id: "dev-user-123",
            firebaseUid: req.user.uid,
            email: req.user.email || "dev@example.com",
            subscriptionTier: "free"
            // Default to free tier for testing
          };
        } else {
          throw dbError;
        }
      }
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      let clampedMaxResults = 8;
      if (maxResults !== void 0) {
        if (typeof maxResults === "number" && !isNaN(maxResults)) {
          clampedMaxResults = Math.max(1, Math.min(12, Math.floor(maxResults)));
        }
      }
      const isPaid = false;
      if (!isPaid) {
        clampedMaxResults = 1;
      } else {
        clampedMaxResults = Math.min(clampedMaxResults, 8);
      }
      const slogans = await generateSlogans({
        brandName: brandName.trim(),
        description,
        tone,
        industry,
        audience,
        maxResults: clampedMaxResults
      });
      res.json(slogans);
    } catch (error) {
      handleError(res, error, "Failed to generate slogans");
    }
  });
  app2.post("/api/slogan", async (req, res) => {
    try {
      const clientIp = req.ip || req.connection.remoteAddress || "unknown";
      if (!checkSloganRateLimit(clientIp)) {
        return res.status(429).json({
          error: "Rate limit exceeded. Maximum 30 requests per minute."
        });
      }
      const { brandName, description = "", tone = "Professional", industry = "", audience = "", maxResults = 8 } = req.body || {};
      if (!brandName || typeof brandName !== "string" || brandName.trim().length === 0) {
        return res.status(400).json({ error: "brandName is required and must be a non-empty string" });
      }
      const n = Math.min(Math.max(Number(maxResults) || 8, 3), 20);
      const system = `You are a branding copywriter. Return only short, punchy, original slogans (max ~8 words). No clich\xE9s.`;
      const user = `Brand: ${brandName}
Tone: ${tone}
Industry: ${industry || "General"}
Audience: ${audience || "General"}
About: ${description || "N/A"}

Write ${n} distinct, catchy slogans. Vary structure and rhythm. Return as a simple numbered list.`;
      const openai5 = new OpenAI5({
        apiKey: process.env.OPENAI_API_KEY
      });
      const r = await openai5.chat.completions.create({
        model: "gpt-4o-mini",
        temperature: 0.9,
        top_p: 0.9,
        frequency_penalty: 0.4,
        presence_penalty: 0.3,
        max_tokens: 300,
        messages: [{ role: "system", content: system }, { role: "user", content: user }]
      });
      if (!r.choices?.[0]?.message?.content) {
        return res.status(502).json({ error: "Upstream error", detail: "No content from AI" });
      }
      const raw = r.choices[0].message.content.trim();
      const suggestions = raw.split(/\n+/).map((l) => l.replace(/^\d+[\).\s-]?\s*/, "").trim()).filter(Boolean);
      res.json({ suggestions });
    } catch (e) {
      res.status(500).json({ error: "Server error", detail: e?.message || e });
    }
  });
  app2.post("/api/ai/plan", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const clientIP = req.ip || req.socket.remoteAddress || "unknown";
      if (!checkPlanRateLimit(clientIP)) {
        return res.status(429).json({
          error: "Too many requests. Please try again later.",
          retryAfter: 60
        });
      }
      let user;
      try {
        user = await storage.getUserByFirebaseUid(req.user.uid);
      } catch (dbError) {
        const isDevelopment = process.env.NODE_ENV === "development" || process.env.NODE_ENV !== "production";
        if (isDevelopment) {
          console.warn("Database unavailable, using mock user for testing:", dbError);
          user = {
            id: "dev-user-123",
            firebaseUid: req.user.uid,
            email: req.user.email || "dev@example.com",
            subscriptionTier: "free"
            // Default to free tier for testing
          };
        } else {
          throw dbError;
        }
      }
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const {
        mode = "lean",
        businessName,
        description,
        industry,
        audience,
        problem,
        solution,
        advantage,
        pricing,
        timeframeMonths,
        tone = "Professional"
      } = req.body;
      if (!businessName || typeof businessName !== "string" || businessName.trim().length === 0) {
        return res.status(400).json({ error: "businessName is required and must be a non-empty string" });
      }
      if (!description || typeof description !== "string" || description.trim().length === 0) {
        return res.status(400).json({ error: "description is required and must be a non-empty string" });
      }
      if (!["lean", "full"].includes(mode)) {
        return res.status(400).json({ error: 'mode must be either "lean" or "full"' });
      }
      if (!["Professional", "Friendly", "Bold", "Minimal"].includes(tone)) {
        return res.status(400).json({ error: "tone must be one of: Professional, Friendly, Bold, Minimal" });
      }
      const isPaidUser = false;
      if (mode === "full" && !isPaidUser) {
        return res.status(402).json({
          error: "Full business plans require a Pro subscription",
          code: "PAYWALL",
          message: "Upgrade to Pro to access comprehensive business plans with financial projections"
        });
      }
      const planRequest = {
        mode,
        businessName: businessName.trim(),
        description: description.trim(),
        industry: industry?.trim(),
        audience: audience?.trim(),
        problem: problem?.trim(),
        solution: solution?.trim(),
        advantage: advantage?.trim(),
        pricing: pricing?.trim(),
        timeframeMonths: timeframeMonths ? Math.max(1, Math.min(60, parseInt(timeframeMonths))) : 12,
        tone
      };
      const businessPlan = await generateBusinessPlan(planRequest);
      console.log(`Business plan generated successfully for user ${user.id}, mode: ${mode}, businessName: ${businessName}`);
      res.json(businessPlan);
    } catch (error) {
      console.error("Business plan generation error:", error);
      if (error instanceof Error) {
        if (error.message.includes("required")) {
          return res.status(400).json({ error: error.message });
        }
        if (error.message.includes("Invalid JSON")) {
          return res.status(500).json({ error: "AI response formatting error. Please try again." });
        }
      }
      handleError(res, error, "Failed to generate business plan");
    }
  });
  app2.post("/api/ai/section", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const clientIP = req.ip || req.socket.remoteAddress || "unknown";
      if (!checkPlanRateLimit(clientIP)) {
        return res.status(429).json({
          error: "Too many requests. Please try again later.",
          retryAfter: 60
        });
      }
      let user;
      try {
        user = await storage.getUserByFirebaseUid(req.user.uid);
      } catch (dbError) {
        const isDevelopment = process.env.NODE_ENV === "development" || process.env.NODE_ENV !== "production";
        if (isDevelopment) {
          console.warn("Database unavailable, using mock user for testing:", dbError);
          user = {
            id: "dev-user-123",
            firebaseUid: req.user.uid,
            email: req.user.email || "dev@example.com",
            isPaid: true
            // Allow AI features in development
          };
        } else {
          throw dbError;
        }
      }
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const aiJob = req.body;
      if (!aiJob.action || !aiJob.tone || !aiJob.sectionKind || !aiJob.sectionTitle) {
        return res.status(400).json({
          error: "Missing required fields: action, tone, sectionKind, and sectionTitle are required"
        });
      }
      if (!["generate", "rephrase", "expand", "summarize"].includes(aiJob.action)) {
        return res.status(400).json({
          error: `Invalid action: ${aiJob.action}. Must be one of: generate, rephrase, expand, summarize`
        });
      }
      if (!["Professional", "Friendly", "Bold", "Minimal"].includes(aiJob.tone)) {
        return res.status(400).json({
          error: `Invalid tone: ${aiJob.tone}. Must be one of: Professional, Friendly, Bold, Minimal`
        });
      }
      if (["rephrase", "expand", "summarize"].includes(aiJob.action) && (!aiJob.existingContent || aiJob.existingContent.trim().length === 0)) {
        return res.status(400).json({
          error: `Action "${aiJob.action}" requires existing content to work with`
        });
      }
      console.log(`\u{1F916} Processing AI section request: ${aiJob.action} for "${aiJob.sectionTitle}" by user ${user.email}`);
      const response = await processAiSectionJob(aiJob);
      res.json(response);
    } catch (error) {
      console.error("AI section endpoint error:", error);
      handleError(res, error, "Failed to process AI section request");
    }
  });
  app2.post("/api/ai/structured-template", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      let user;
      try {
        user = await storage.getUserByFirebaseUid(req.user.uid);
      } catch (dbError) {
        const isDevelopment = process.env.NODE_ENV === "development" || process.env.NODE_ENV !== "production";
        if (isDevelopment) {
          user = {
            id: "dev-user-123",
            firebaseUid: req.user.uid,
            email: req.user.email || "dev@example.com",
            isPaid: true
          };
        } else {
          throw dbError;
        }
      }
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const { templateKey, businessBrief } = req.body;
      if (!templateKey) {
        return res.status(400).json({ error: "templateKey is required" });
      }
      console.log(`\u{1F3AF} Generating structured template: ${templateKey} for user ${user.email}`);
      const { generateStructuredTemplate: generateStructuredTemplate2 } = await Promise.resolve().then(() => (init_ai_section(), ai_section_exports));
      const result = await generateStructuredTemplate2(templateKey, businessBrief);
      res.json({ success: true, data: result.data, isSeedDraft: result.isSeedDraft });
    } catch (error) {
      console.error("Structured template generation error:", error);
      handleError(res, error, "Failed to generate structured template");
    }
  });
  app2.post("/api/ai/plan/export", authenticateToken2, hasProAccess, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      let user;
      try {
        user = await storage.getUserByFirebaseUid(req.user.uid);
      } catch (dbError) {
        const isDevelopment = process.env.NODE_ENV === "development" || process.env.NODE_ENV !== "production";
        if (isDevelopment) {
          console.warn("Database unavailable, using mock user for testing:", dbError);
          user = {
            id: "dev-user-123",
            firebaseUid: req.user.uid,
            email: req.user.email || "dev@example.com",
            subscriptionTier: "free"
            // Default to free tier for testing
          };
        } else {
          throw dbError;
        }
      }
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const { plan, format, businessName } = req.body;
      if (!plan || !format) {
        return res.status(400).json({ error: "Missing plan or format" });
      }
      if (!["pdf", "docx"].includes(format)) {
        return res.status(400).json({ error: 'Invalid format. Must be "pdf" or "docx"' });
      }
      if (!plan.sections || !Array.isArray(plan.sections) || plan.sections.length === 0) {
        return res.status(400).json({ error: "Plan must contain sections" });
      }
      const isPaidUser = false;
      if (!isPaidUser) {
        return res.status(402).json({
          error: "Export functionality requires a Pro subscription",
          code: "PAYWALL",
          message: "Upgrade to Pro to export your business plans as PDF or DOCX files"
        });
      }
      const meta = {
        businessName: businessName || inferBusinessName(plan) || "Your Business",
        subtitle: "Business Plan",
        generatedAt: /* @__PURE__ */ new Date()
      };
      if (format === "pdf") {
        const doc = renderPlanPDF(plan, meta);
        const filename = slugify(`${meta.businessName}-Business-Plan.pdf`);
        res.setHeader("Content-Type", "application/pdf");
        res.setHeader("Content-Disposition", `attachment; filename="${filename}"`);
        doc.pipe(res);
        doc.end();
        console.log(`Business plan PDF exported successfully for user ${user.id}, businessName: ${meta.businessName}`);
        return;
      }
      if (format === "docx") {
        const buffer = await renderPlanDOCX(plan, meta);
        const filename = slugify(`${meta.businessName}-Business-Plan.docx`);
        res.setHeader("Content-Type", "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
        res.setHeader("Content-Disposition", `attachment; filename="${filename}"`);
        console.log(`Business plan DOCX exported successfully for user ${user.id}, businessName: ${meta.businessName}`);
        return res.send(buffer);
      }
      return res.status(400).json({ error: "Invalid format" });
    } catch (error) {
      console.error("Business plan export error:", error);
      if (error instanceof Error) {
        if (error.message.includes("required") || error.message.includes("Missing")) {
          return res.status(400).json({ error: error.message });
        }
        if (error.message.includes("PDF") || error.message.includes("DOCX")) {
          return res.status(500).json({ error: "Document generation error. Please try again." });
        }
      }
      handleError(res, error, "Failed to export business plan");
    }
  });
  app2.post("/api/ai/plan/export/google-doc", authenticateToken2, hasProAccess, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      let user;
      try {
        user = await storage.getUserByFirebaseUid(req.user.uid);
      } catch (dbError) {
        const isDevelopment2 = process.env.NODE_ENV === "development" || process.env.NODE_ENV !== "production";
        if (isDevelopment2) {
          console.warn("Database unavailable, using mock user for testing:", dbError);
          user = {
            id: "dev-user-123",
            firebaseUid: req.user.uid,
            email: req.user.email || "dev@example.com",
            subscriptionTier: "free"
            // Default to free tier for testing
          };
        } else {
          throw dbError;
        }
      }
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const { plan, businessName, accessToken } = req.body;
      if (!plan || !businessName || !accessToken) {
        return res.status(400).json({ error: "Missing plan, businessName, or accessToken" });
      }
      if (!plan.sections || !Array.isArray(plan.sections) || plan.sections.length === 0) {
        return res.status(400).json({ error: "Plan must contain sections" });
      }
      const isPaidUser = false;
      const allowGoogleDocsDev = process.env.ALLOW_GOOGLE_DOCS_DEV === "true";
      const isDevelopment = process.env.NODE_ENV === "development" || process.env.NODE_ENV !== "production";
      if (!isPaidUser && !(isDevelopment && allowGoogleDocsDev)) {
        return res.status(402).json({
          error: "Google Docs export requires a Pro subscription",
          code: "PAYWALL",
          message: "Upgrade to Pro to save your business plans to Google Docs"
        });
      }
      const { google } = await import("googleapis");
      const auth = new google.auth.OAuth2();
      auth.setCredentials({ access_token: accessToken });
      const drive = google.drive({ version: "v3", auth });
      const meta = {
        businessName: businessName || inferBusinessName(plan) || "Your Business",
        subtitle: "Business Plan",
        generatedAt: /* @__PURE__ */ new Date()
      };
      const docxBuffer = await renderPlanDOCX(plan, meta);
      const sanitizedName = meta.businessName.replace(/[^a-zA-Z0-9\s-]/g, "").trim();
      const modeLabel = plan.mode === "full" ? "Full" : "Lean";
      const fileName = `${sanitizedName} - ${modeLabel} Business Plan`;
      const fileMetadata = {
        name: fileName,
        mimeType: "application/vnd.google-apps.document"
        // Convert to Google Doc
      };
      const media = {
        mimeType: "application/vnd.openxmlformats-officedocument.wordprocessingml.document",
        body: Readable.from(docxBuffer)
      };
      const response = await drive.files.create({
        requestBody: fileMetadata,
        media,
        fields: "id,name,webViewLink"
      });
      const fileId = response.data.id;
      const fileUrl = response.data.webViewLink;
      const createdFileName = response.data.name;
      if (!fileId || !fileUrl) {
        throw new Error("Failed to create Google Doc - missing file ID or URL");
      }
      console.log(`Business plan exported to Google Docs successfully for user ${user.id}, businessName: ${meta.businessName}, fileId: ${fileId}`);
      res.json({
        fileId,
        fileUrl,
        fileName: createdFileName
      });
    } catch (error) {
      console.error("Google Docs export error:", error);
      if (error instanceof Error) {
        if (error.message.includes("required") || error.message.includes("Missing")) {
          return res.status(400).json({ error: error.message });
        }
        if (error.message.includes("Google") || error.message.includes("Drive")) {
          return res.status(500).json({ error: "Google Drive API error. Please check your Google account permissions and try again." });
        }
        if (error.message.includes("access_token") || error.message.includes("authentication")) {
          return res.status(401).json({ error: "Google authentication failed. Please sign in to Google again." });
        }
        if (error.message.includes("scope") || error.message.includes("permission")) {
          return res.status(403).json({ error: "Insufficient Google Drive permissions. Please grant access to create files." });
        }
      }
      handleError(res, error, "Failed to save business plan to Google Docs");
    }
  });
  const getLatestVersion = async (token) => {
    const resp = await fetch("https://api.replicate.com/v1/models/recraft-ai/recraft-v3-svg", {
      headers: { Authorization: `Token ${token}` },
      cache: "no-store"
    });
    if (!resp.ok) {
      const text2 = await resp.text();
      throw new Error(`Failed to read model info (${resp.status}): ${text2}`);
    }
    const json = await resp.json();
    const id = json?.latest_version?.id;
    if (!id) throw new Error("No latest_version.id on model payload");
    return id;
  };
  const pickSvgUrl = (output) => {
    console.log("[DEBUG] pickSvgUrl - output type:", typeof output);
    console.log("[DEBUG] pickSvgUrl - output structure:", JSON.stringify(output, null, 2));
    if (typeof output === "string") {
      console.log("[DEBUG] Case 1: string URL:", output);
      if (isValidImageUrl(output)) return output;
      return null;
    }
    if (Array.isArray(output)) {
      console.log("[DEBUG] Case 2: array of URLs, length:", output.length);
      const svg = output.find((u) => typeof u === "string" && isValidImageUrl(u));
      if (typeof svg === "string") {
        console.log("[DEBUG] Found SVG in array:", svg);
        return svg;
      }
      for (const item of output) {
        if (item && typeof item === "object") {
          const maybe = item.url || item.uri || item.href;
          if (typeof maybe === "string" && isValidImageUrl(maybe)) {
            console.log("[DEBUG] Found image in object field:", maybe);
            return maybe;
          }
        }
      }
      for (const item of output) {
        if (typeof item === "string") {
          console.log("[DEBUG] Found string in array:", item);
          if (item.includes("replicate") || item.includes("svg")) {
            console.log("[DEBUG] Returning suspected SVG URL:", item);
            return item;
          }
        }
      }
      return null;
    }
    if (output && typeof output === "object") {
      console.log("[DEBUG] Case 3: object");
      const obj = output;
      const candidates = [obj.svg, obj.svg_url, obj.url, obj.uri, obj.href];
      console.log("[DEBUG] Candidates:", candidates);
      for (const c of candidates) {
        if (typeof c === "string") {
          console.log("[DEBUG] Checking candidate:", c);
          if (isValidImageUrl(c)) {
            console.log("[DEBUG] Found image in object candidate:", c);
            return c;
          }
        }
      }
      for (const [key, value] of Object.entries(obj)) {
        if (typeof value === "string" && (value.includes("replicate") || value.includes("svg"))) {
          console.log("[DEBUG] Found potential URL in object key", key, ":", value);
          return value;
        }
      }
    }
    console.log("[DEBUG] No valid image URL found in output");
    return null;
  };
  const isSvgUrl = (u) => {
    const lower = u.toLowerCase();
    return lower.endsWith(".svg") || lower.includes(".svg?");
  };
  const isValidImageUrl = (u) => {
    const lower = u.toLowerCase();
    return lower.endsWith(".svg") || lower.includes(".svg?") || lower.endsWith(".webp") || lower.includes(".webp") || lower.endsWith(".png") || lower.includes(".png") || lower.includes("replicate.delivery");
  };
  const sanitizeReplicateToken = () => {
    const raw = process.env.REPLICATE_API_TOKEN || "";
    const token = raw.normalize("NFKC").replace(/[''‚‛]/g, "'").replace(/[""„‟]/g, '"').replace(/^(Token|Bearer)\s+(?!r8_)/i, "").replace(/^['"]+|['"]+$/g, "").trim();
    if (!token || /[^\x20-\x7E]/.test(token)) {
      return {
        error: "Invalid REPLICATE_API_TOKEN format. Please re-enter the token with plain ASCII (no quotes)."
      };
    }
    return { token, authHeader: `Token ${token}` };
  };
  app2.post("/api/recraft/create", authenticateToken2, async (req, res) => {
    try {
      const tokenResult = sanitizeReplicateToken();
      if ("error" in tokenResult) {
        return res.status(500).json({ error: tokenResult.error });
      }
      const { token, authHeader } = tokenResult;
      const { prompt } = req.body;
      if (!prompt || typeof prompt !== "string" || !prompt.trim()) {
        return res.status(400).json({ error: "Missing prompt" });
      }
      const enhancedPrompt = `${prompt.trim()}, transparent background, no background fill, isolated logo icon, vector graphic`;
      console.log("[recraft] enhanced prompt:", enhancedPrompt);
      let version = "";
      try {
        version = await getLatestVersion(token);
        console.log("[recraft] resolved latest version:", version);
      } catch (e) {
        console.error("[recraft] Failed to resolve version:", e.message);
        return res.status(502).json({ error: `Could not resolve version: ${e.message}` });
      }
      const createRes = await fetch("https://api.replicate.com/v1/predictions", {
        method: "POST",
        headers: {
          Authorization: authHeader,
          "Content-Type": "application/json"
        },
        body: JSON.stringify({
          version,
          input: {
            prompt: enhancedPrompt,
            output_format: "svg",
            // ask explicitly for SVG
            background: "transparent",
            // first try
            remove_background: true,
            // fallback param some models use
            vectorize: true,
            // Ensure vector output
            no_text: true
            // Remove text elements that could create backgrounds
          }
        })
      });
      const rawCreate = await createRes.text();
      if (!createRes.ok) {
        console.error("[recraft] create failed:", createRes.status, rawCreate);
        return res.status(createRes.status || 502).json({ error: `Create failed: ${rawCreate}` });
      }
      const start = JSON.parse(rawCreate);
      const predictionId = start?.id;
      if (!predictionId) {
        console.error("[recraft] no prediction id. payload:", start);
        return res.status(502).json({ error: "No prediction id" });
      }
      console.log("[recraft] created prediction:", predictionId);
      return res.json({ predictionId, version });
    } catch (error) {
      console.error("[recraft] create route error:", error);
      handleError(res, error, "Failed to create Recraft prediction");
    }
  });
  app2.get("/api/recraft/status/:predictionId", async (req, res) => {
    try {
      const tokenResult = sanitizeReplicateToken();
      if ("error" in tokenResult) {
        return res.status(500).json({ error: tokenResult.error });
      }
      const { authHeader } = tokenResult;
      const { predictionId } = req.params;
      if (!predictionId) {
        return res.status(400).json({ error: "Missing predictionId" });
      }
      const stRes = await fetch(`https://api.replicate.com/v1/predictions/${predictionId}`, {
        headers: { Authorization: authHeader },
        cache: "no-store"
      });
      const rawStatus = await stRes.text();
      if (!stRes.ok) {
        console.error("[recraft] status failed:", stRes.status, rawStatus);
        return res.status(stRes.status || 502).json({ error: `Status failed: ${rawStatus}` });
      }
      const data = JSON.parse(rawStatus);
      console.log(`[recraft] status for ${predictionId}:`, data.status);
      const response = {
        status: data.status,
        predictionId,
        rawOutputShape: data.output ? typeof data.output : null
      };
      if (data.status === "succeeded") {
        const svgUrl = pickSvgUrl(data.output);
        if (svgUrl) {
          response.svgUrl = svgUrl;
          console.log("[recraft] extracted SVG URL:", svgUrl);
        } else {
          console.error("[recraft] no svgUrl resolved from output:", JSON.stringify(data.output));
          response.error = "No valid SVG URL found in output";
          response.debugOutput = data.output;
        }
      } else if (data.status === "failed") {
        console.error("[recraft] generation failed:", rawStatus);
        response.error = data.error || "Generation failed";
      }
      return res.json(response);
    } catch (error) {
      console.error("[recraft] status route error:", error);
      handleError(res, error, "Failed to check Recraft status");
    }
  });
  app2.post("/api/generate-fonts", authenticateToken2, hasProAccess, async (req, res) => {
    try {
      const tokenResult = sanitizeReplicateToken();
      if ("error" in tokenResult) {
        return res.status(500).json({ error: tokenResult.error });
      }
      const { token, authHeader } = tokenResult;
      const prompt = "Generate 120 distinct, professional font options for branding kits. Each font should be listed by name only (no extra description). Return them as a clean JSON array of strings.";
      console.log("[fonts] generating fonts with prompt:", prompt);
      const createRes = await fetch("https://api.replicate.com/v1/predictions", {
        method: "POST",
        headers: {
          Authorization: authHeader,
          "Content-Type": "application/json"
        },
        body: JSON.stringify({
          version: "02e509c789964a7ea8736978a43525956ef40397be9033abf9fd2badfe68c9e3",
          // meta/llama-2-70b-chat
          input: {
            prompt,
            max_tokens: 1e3,
            temperature: 0.2,
            top_p: 1,
            system_prompt: "You are a typography expert. Generate exactly 120 professional, real font names that are commonly available for branding projects. Return only a clean JSON array of strings with no additional text or explanation."
          }
        })
      });
      const rawCreate = await createRes.text();
      if (!createRes.ok) {
        console.error("[fonts] create failed:", createRes.status, rawCreate);
        return res.status(createRes.status || 502).json({ error: `Font generation failed: ${rawCreate}` });
      }
      const start = JSON.parse(rawCreate);
      const predictionId = start?.id;
      if (!predictionId) {
        console.error("[fonts] no prediction id. payload:", start);
        return res.status(502).json({ error: "No prediction id" });
      }
      console.log("[fonts] created prediction:", predictionId);
      const timeoutAt = Date.now() + 12e4;
      let pollCount = 0;
      while (Date.now() < timeoutAt) {
        pollCount++;
        if (pollCount > 1) {
          await new Promise((resolve) => setTimeout(resolve, 2e3));
        }
        const statusRes = await fetch(`https://api.replicate.com/v1/predictions/${predictionId}`, {
          headers: { Authorization: authHeader },
          cache: "no-store"
        });
        const rawStatus = await statusRes.text();
        if (!statusRes.ok) {
          console.error("[fonts] status failed:", statusRes.status, rawStatus);
          return res.status(statusRes.status || 502).json({ error: `Status check failed: ${rawStatus}` });
        }
        const data = JSON.parse(rawStatus);
        console.log(`[fonts] poll #${pollCount} for ${predictionId}: ${data.status}`);
        if (data.status === "succeeded") {
          try {
            let outputText = "";
            if (typeof data.output === "string") {
              outputText = data.output;
            } else if (Array.isArray(data.output)) {
              outputText = data.output.join("");
            } else {
              throw new Error("Unexpected output format");
            }
            console.log("[fonts] raw output:", outputText.substring(0, 200) + "...");
            let fontArray = [];
            const jsonMatch = outputText.match(/\[[\s\S]*?\]/);
            if (jsonMatch) {
              fontArray = JSON.parse(jsonMatch[0]);
            } else {
              fontArray = JSON.parse(outputText.trim());
            }
            if (!Array.isArray(fontArray)) {
              throw new Error("Output is not an array");
            }
            const cleanedFonts = fontArray.filter((font) => typeof font === "string" && font.trim().length > 0).map((font) => font.trim()).slice(0, 120);
            if (cleanedFonts.length === 0) {
              throw new Error("No valid fonts found in output");
            }
            console.log(`[fonts] successfully generated ${cleanedFonts.length} fonts`);
            return res.json({ fonts: cleanedFonts });
          } catch (parseError) {
            console.error("[fonts] failed to parse output:", parseError.message);
            console.error("[fonts] raw output for debugging:", data.output);
            const fallbackFonts = [
              "Inter",
              "Poppins",
              "Roboto",
              "Lato",
              "Open Sans",
              "Montserrat",
              "Nunito",
              "Raleway",
              "Playfair Display",
              "Merriweather",
              "Lora",
              "PT Serif",
              "Crimson Text",
              "Spectral",
              "Arvo",
              "Roboto Slab",
              "Noto Serif Display",
              "Zilla Slab",
              "Alegreya",
              "Bebas Neue",
              "Oswald",
              "Orbitron",
              "Anton",
              "Fjalla One",
              "Righteous",
              "Pacifico",
              "Dancing Script",
              "Great Vibes",
              "Sacramento",
              "Amatic SC"
            ];
            return res.json({
              fonts: fallbackFonts,
              fallback: true,
              error: "Used fallback fonts due to parsing error"
            });
          }
        } else if (data.status === "failed") {
          console.error("[fonts] generation failed:", rawStatus);
          return res.status(500).json({ error: data.error || "Font generation failed" });
        }
      }
      console.error("[fonts] timeout waiting for completion");
      return res.status(408).json({ error: "Font generation timed out" });
    } catch (error) {
      console.error("[fonts] route error:", error);
      handleError(res, error, "Failed to generate fonts");
    }
  });
  app2.post("/api/social-media-kits", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const socialMediaKitData = insertSocialMediaKitSchema.parse({
        ...req.body,
        userId: user.id
      });
      const socialMediaKit = await storage.createSocialMediaKit(socialMediaKitData);
      res.status(201).json(socialMediaKit);
    } catch (error) {
      handleError(res, error, "Failed to create social media kit");
    }
  });
  app2.get("/api/social-media-kits", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const socialMediaKits2 = await storage.getSocialMediaKitsByUserId(user.id);
      res.json(socialMediaKits2);
    } catch (error) {
      handleError(res, error, "Failed to get social media kits");
    }
  });
  app2.get("/api/social-media-kits/:id", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const socialMediaKit = await storage.getSocialMediaKit(req.params.id);
      if (!socialMediaKit) {
        return res.status(404).json({ error: "Social media kit not found" });
      }
      if (socialMediaKit.userId !== user.id) {
        return res.status(403).json({ error: "Access denied" });
      }
      res.json(socialMediaKit);
    } catch (error) {
      handleError(res, error, "Failed to get social media kit");
    }
  });
  app2.put("/api/social-media-kits/:id", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const existingSocialMediaKit = await storage.getSocialMediaKit(req.params.id);
      if (!existingSocialMediaKit) {
        return res.status(404).json({ error: "Social media kit not found" });
      }
      if (existingSocialMediaKit.userId !== user.id) {
        return res.status(403).json({ error: "Access denied" });
      }
      const updateData = insertSocialMediaKitSchema.partial().parse(req.body);
      const updatedSocialMediaKit = await storage.updateSocialMediaKit(req.params.id, updateData);
      if (!updatedSocialMediaKit) {
        return res.status(404).json({ error: "Social media kit not found" });
      }
      res.json(updatedSocialMediaKit);
    } catch (error) {
      handleError(res, error, "Failed to update social media kit");
    }
  });
  app2.delete("/api/social-media-kits/:id", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const existingSocialMediaKit = await storage.getSocialMediaKit(req.params.id);
      if (!existingSocialMediaKit) {
        return res.status(404).json({ error: "Social media kit not found" });
      }
      if (existingSocialMediaKit.userId !== user.id) {
        return res.status(403).json({ error: "Access denied" });
      }
      const deleted = await storage.deleteSocialMediaKit(req.params.id);
      if (!deleted) {
        return res.status(404).json({ error: "Social media kit not found" });
      }
      res.status(204).send();
    } catch (error) {
      handleError(res, error, "Failed to delete social media kit");
    }
  });
  app2.post("/api/website-templates", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const websiteTemplateData = insertWebsiteTemplateSchema.parse({
        ...req.body,
        userId: user.id
      });
      const websiteTemplate = await storage.createWebsiteTemplate(websiteTemplateData);
      res.status(201).json(websiteTemplate);
    } catch (error) {
      handleError(res, error, "Failed to create website template");
    }
  });
  app2.get("/api/website-templates", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const websiteTemplates2 = await storage.getWebsiteTemplatesByUserId(user.id);
      res.json(websiteTemplates2);
    } catch (error) {
      handleError(res, error, "Failed to get website templates");
    }
  });
  app2.get("/api/website-templates/:id", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const websiteTemplate = await storage.getWebsiteTemplate(req.params.id);
      if (!websiteTemplate) {
        return res.status(404).json({ error: "Website template not found" });
      }
      if (websiteTemplate.userId !== user.id) {
        return res.status(403).json({ error: "Access denied" });
      }
      res.json(websiteTemplate);
    } catch (error) {
      handleError(res, error, "Failed to get website template");
    }
  });
  app2.put("/api/website-templates/:id", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const existingWebsiteTemplate = await storage.getWebsiteTemplate(req.params.id);
      if (!existingWebsiteTemplate) {
        return res.status(404).json({ error: "Website template not found" });
      }
      if (existingWebsiteTemplate.userId !== user.id) {
        return res.status(403).json({ error: "Access denied" });
      }
      const updateData = insertWebsiteTemplateSchema.partial().parse(req.body);
      const updatedWebsiteTemplate = await storage.updateWebsiteTemplate(req.params.id, updateData);
      if (!updatedWebsiteTemplate) {
        return res.status(404).json({ error: "Website template not found" });
      }
      res.json(updatedWebsiteTemplate);
    } catch (error) {
      handleError(res, error, "Failed to update website template");
    }
  });
  app2.delete("/api/website-templates/:id", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const existingWebsiteTemplate = await storage.getWebsiteTemplate(req.params.id);
      if (!existingWebsiteTemplate) {
        return res.status(404).json({ error: "Website template not found" });
      }
      if (existingWebsiteTemplate.userId !== user.id) {
        return res.status(403).json({ error: "Access denied" });
      }
      const deleted = await storage.deleteWebsiteTemplate(req.params.id);
      if (!deleted) {
        return res.status(404).json({ error: "Website template not found" });
      }
      res.status(204).send();
    } catch (error) {
      handleError(res, error, "Failed to delete website template");
    }
  });
  app2.post("/api/template-customizations", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const customizationData = insertUserTemplateCustomizationSchema.parse({
        ...req.body,
        userId: user.id
      });
      const customization = await storage.createUserTemplateCustomization(customizationData);
      res.status(201).json(customization);
    } catch (error) {
      handleError(res, error, "Failed to create template customization");
    }
  });
  app2.get("/api/template-customizations", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const customizations = await storage.getUserTemplateCustomizationsByUserId(user.id);
      res.json(customizations);
    } catch (error) {
      handleError(res, error, "Failed to get template customizations");
    }
  });
  app2.get("/api/template-customizations/template/:templateId", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const customization = await storage.getUserTemplateCustomizationByTemplateId(user.id, req.params.templateId);
      if (!customization) {
        return res.status(404).json({ error: "Template customization not found" });
      }
      res.json(customization);
    } catch (error) {
      handleError(res, error, "Failed to get template customization");
    }
  });
  app2.get("/api/template-customizations/:id", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const customization = await storage.getUserTemplateCustomization(req.params.id);
      if (!customization) {
        return res.status(404).json({ error: "Template customization not found" });
      }
      if (customization.userId !== user.id) {
        return res.status(403).json({ error: "Access denied" });
      }
      res.json(customization);
    } catch (error) {
      handleError(res, error, "Failed to get template customization");
    }
  });
  app2.put("/api/template-customizations/:id", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const existingCustomization = await storage.getUserTemplateCustomization(req.params.id);
      if (!existingCustomization) {
        return res.status(404).json({ error: "Template customization not found" });
      }
      if (existingCustomization.userId !== user.id) {
        return res.status(403).json({ error: "Access denied" });
      }
      const updateData = insertUserTemplateCustomizationSchema.partial().parse(req.body);
      const updatedCustomization = await storage.updateUserTemplateCustomization(req.params.id, updateData);
      if (!updatedCustomization) {
        return res.status(404).json({ error: "Template customization not found" });
      }
      res.json(updatedCustomization);
    } catch (error) {
      handleError(res, error, "Failed to update template customization");
    }
  });
  app2.delete("/api/template-customizations/:id", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const existingCustomization = await storage.getUserTemplateCustomization(req.params.id);
      if (!existingCustomization) {
        return res.status(404).json({ error: "Template customization not found" });
      }
      if (existingCustomization.userId !== user.id) {
        return res.status(403).json({ error: "Access denied" });
      }
      const deleted = await storage.deleteUserTemplateCustomization(req.params.id);
      if (!deleted) {
        return res.status(404).json({ error: "Template customization not found" });
      }
      res.status(204).send();
    } catch (error) {
      handleError(res, error, "Failed to delete template customization");
    }
  });
  app2.post("/api/template-customizations/:id/duplicate", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const existingCustomization = await storage.getUserTemplateCustomization(req.params.id);
      if (!existingCustomization) {
        return res.status(404).json({ error: "Template customization not found" });
      }
      if (existingCustomization.userId !== user.id) {
        return res.status(403).json({ error: "Access denied" });
      }
      const { name } = req.body;
      if (!name || typeof name !== "string") {
        return res.status(400).json({ error: "Name is required for duplication" });
      }
      const duplicatedCustomization = await storage.duplicateUserTemplateCustomization(req.params.id, name);
      if (!duplicatedCustomization) {
        return res.status(500).json({ error: "Failed to duplicate template customization" });
      }
      res.status(201).json(duplicatedCustomization);
    } catch (error) {
      handleError(res, error, "Failed to duplicate template customization");
    }
  });
  app2.put("/api/website-templates/:id/customization", authenticateToken2, hasProAccess, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const template = await storage.getWebsiteTemplate(req.params.id);
      if (!template) {
        return res.status(404).json({ error: "Website template not found" });
      }
      if (template.userId && template.userId !== user.id) {
        return res.status(403).json({ error: "Access denied" });
      }
      let customization = await storage.getUserTemplateCustomizationByTemplateId(user.id, req.params.id);
      const customizationData = {
        configurations: req.body.configurations,
        contentOverrides: req.body.contentOverrides,
        styleOverrides: req.body.styleOverrides
      };
      if (customization) {
        const updatedCustomization = await storage.updateUserTemplateCustomization(customization.id, customizationData);
        res.json(updatedCustomization);
      } else {
        const newCustomizationData = insertUserTemplateCustomizationSchema.parse({
          userId: user.id,
          templateId: req.params.id,
          customizationName: `${template.name || "Template"} Customization`,
          ...customizationData
        });
        const newCustomization = await storage.createUserTemplateCustomization(newCustomizationData);
        res.status(201).json(newCustomization);
      }
    } catch (error) {
      handleError(res, error, "Failed to save template customization");
    }
  });
  app2.get("/api/version", (_req, res) => {
    res.json(BUILD);
  });
  app2.get("/api/health", async (_req, res) => {
    const corsOrigins2 = (process.env.CORS_ORIGINS || "").split(",").map((s) => s.trim()).filter(Boolean);
    const whmcsUrl = process.env.WHMCS_API_URL || null;
    const domainProvider = process.env.DOMAIN_PROVIDER || (whmcsUrl ? "whmcs" : "opensrs");
    let whmcsUrlHost = null;
    if (whmcsUrl) {
      try {
        whmcsUrlHost = new URL(whmcsUrl).host;
      } catch {
        whmcsUrlHost = whmcsUrl;
      }
    }
    let serverPublicIp = null;
    try {
      const ipResponse = await fetch("https://api.ipify.org?format=json");
      if (ipResponse.ok) {
        const ipData = await ipResponse.json();
        serverPublicIp = ipData.ip;
      }
    } catch {
    }
    res.json({
      ok: true,
      env: process.env.NODE_ENV || "development",
      hostname: os.hostname(),
      serverPublicIp,
      uptimeSec: Math.floor(process.uptime()),
      corsOrigins: corsOrigins2,
      opensrsConfigured: opensrs.isConfigured(),
      opensrsMode: process.env.OPENSRS_MODE || null,
      domainProvider,
      whmcsUrlHost,
      domainUrl: process.env.DOMAIN_URL || process.env.FRONTEND_URL || null,
      time: (/* @__PURE__ */ new Date()).toISOString()
    });
  });
  app2.get("/api/domain/health", (_req, res) => {
    const configured = opensrs.isConfigured();
    res.json({ configured });
  });
  app2.get("/api/domain/ping", async (req, res) => {
    const user = process.env.OPENSRS_USER;
    const key = process.env.OPENSRS_KEY;
    const mode = process.env.OPENSRS_MODE || "ote";
    const configured = !!user && !!key;
    if (!configured) {
      return res.json({
        ok: false,
        provider: "OpenSRS",
        configured: false,
        mode,
        message: "OpenSRS not configured"
      });
    }
    const t0 = performance.now();
    try {
      const sampleDomain = "example.com";
      const available = await opensrs.checkDomainAvailability(sampleDomain);
      const latencyMs = Math.round(performance.now() - t0);
      return res.status(200).json({
        ok: true,
        provider: "OpenSRS",
        configured: true,
        mode,
        latencyMs,
        sample: sampleDomain,
        available
      });
    } catch (err) {
      const latencyMs = Math.round(performance.now() - t0);
      console.error("[domain.ping] error", err?.message);
      return res.status(200).json({
        ok: false,
        provider: "OpenSRS",
        configured: true,
        mode,
        latencyMs,
        sample: "example.com",
        message: err?.message || "Ping failed"
      });
    }
  });
  app2.get("/api/stripe/ping", async (req, res) => {
    const domainUrl = process.env.DOMAIN_URL || process.env.FRONTEND_URL || null;
    const stripeKeyPresent = !!(process.env.STRIPE_SECRET_KEY || process.env.STRIPE_KEY);
    const configured = !!domainUrl && stripeKeyPresent;
    if (!configured) {
      return res.json({
        ok: false,
        configured: false,
        stripeKeyPresent,
        domainUrl,
        message: "Stripe not fully configured (missing STRIPE key and/or DOMAIN_URL/FRONTEND_URL)."
      });
    }
    const successUrl = `${domainUrl.replace(/\/$/, "")}/billing/success`;
    const cancelUrl = `${domainUrl.replace(/\/$/, "")}/billing/cancel`;
    const urls = [successUrl, cancelUrl];
    const results = [];
    let okOverall = true;
    for (const u of urls) {
      const t0 = performance.now();
      try {
        const r = await fetch(u, { method: "HEAD" });
        const latencyMs = Math.round(performance.now() - t0);
        const ok = r.ok || r.status >= 200 && r.status < 400;
        results.push({ url: u, status: r.status, ok, latencyMs });
        if (!ok) okOverall = false;
      } catch (e) {
        const latencyMs = Math.round(performance.now() - t0);
        results.push({ url: u, ok: false, error: e?.message, latencyMs });
        okOverall = false;
      }
    }
    return res.json({
      ok: okOverall,
      configured: true,
      stripeKeyPresent,
      domainUrl,
      checks: results
    });
  });
  app2.post("/api/telemetry", express8.json(), (req, res) => {
    try {
      const body = req.body || {};
      const event = {
        t: String(body.t || "unknown"),
        path: body.path,
        from: body.from,
        meta: body.meta,
        ts: body.ts || Date.now()
      };
      pushEvent(event);
      if (event.t === "spa-404") {
        console.log(`[telemetry] 404 \u2192 ${event.path}`);
      } else if (event.t === "redirect") {
        console.log(`[telemetry] redirect \u2192 ${event.from} \u2192 ${event.path}`);
      } else {
        console.log(`[telemetry] ${event.t} \u2192`, event);
      }
      res.json({ ok: true });
    } catch (error) {
      res.json({ ok: true });
    }
  });
  app2.get("/api/telemetry/recent", (_req, res) => {
    res.json({ items: TELEMETRY.slice(-200).reverse() });
  });
  app2.post("/api/domains/search", async (req, res) => {
    try {
      const searchInputSchema = z5.object({
        query: z5.string().min(1, "Domain query is required").max(100),
        tlds: z5.array(z5.string()).optional()
      });
      const { query, tlds } = searchInputSchema.parse(req.body);
      console.log(`Domain search requested for: ${query}`);
      const hits = await opensrs.search({ query, tlds });
      const result = { hits };
      res.json(result);
    } catch (error) {
      console.error("Domain search error:", error);
      handleError(res, error, "Failed to search domains");
    }
  });
  app2.get("/api/domain/price", async (req, res) => {
    const startTime = Date.now();
    const requestId = Math.random().toString(36).substring(7);
    try {
      const name = String(req.query.q || "").trim().toLowerCase();
      if (!name.includes(".")) {
        return res.status(400).json({
          error: "Unsupported TLD",
          message: "Add a TLD like .com, .net, .org, or .co."
        });
      }
      const domain = name;
      const tldMatch = domain.match(/\.(\w+)$/);
      if (!tldMatch) {
        return res.status(400).json({
          error: "Invalid domain format",
          message: "Add a TLD like .com, .net, .org, or .co."
        });
      }
      const tld = "." + tldMatch[1].toLowerCase();
      const supportedTlds = await opensrs.getSupportedTlds();
      const supportedTldList = supportedTlds.map((t) => t.tld);
      if (!supportedTldList.includes(tld)) {
        return res.status(400).json({
          error: "Unsupported TLD",
          message: `TLD '${tld}' is not supported. Supported TLDs: ${supportedTldList.join(", ")}`,
          supportedTlds: supportedTldList
        });
      }
      let user = null;
      const authHeader = req.headers.authorization;
      if (authHeader?.startsWith("Bearer ")) {
        try {
          const token = authHeader.substring(7);
          const decodedToken = await getFirebaseAdmin().auth().verifyIdToken(token);
          user = await storage.getUserByFirebaseUid(decodedToken.uid);
        } catch (err) {
        }
      }
      let searchResults;
      let domainResult;
      try {
        searchResults = await opensrs.search({ query: domain });
        domainResult = searchResults.find((hit) => hit.domain === domain);
      } catch (opensrsError) {
        console.error("OpenSRS search error:", opensrsError);
        const errorMessage = opensrsError.message || "Domain lookup failed";
        if (errorMessage.includes("invalid domain") || errorMessage.includes("Invalid domain format") || errorMessage.includes("domain syntax") || errorMessage.includes("malformed domain") || errorMessage.toLowerCase().includes("validation")) {
          return res.status(400).json({
            error: "Invalid domain",
            message: errorMessage,
            domain
          });
        }
        return res.status(500).json({
          error: "Domain lookup service error",
          message: "Unable to check domain availability at this time. Please try again later."
        });
      }
      if (!domainResult) {
        return res.status(400).json({
          error: "Domain lookup failed",
          message: "Unable to retrieve domain information",
          domain
        });
      }
      const pricing = getDomainPricing(domain);
      let creditInfo = null;
      if (user) {
        const availableCredits = await storage.getAvailableDomainCredits(user.id);
        const sortedCredits = availableCredits.sort(
          (a, b) => new Date(a.expiresAt).getTime() - new Date(b.expiresAt).getTime()
        );
        if (sortedCredits.length > 0 && domainResult.available) {
          const credit = sortedCredits[0];
          const eligibleTlds = Array.isArray(credit.eligibleTlds) ? credit.eligibleTlds : DEFAULT_ELIGIBLE_TLDS;
          const isTldEligible = eligibleTlds.includes(tld);
          const isPremium = domainResult.premium || domainResult.type === "premium";
          if (isTldEligible && !isPremium) {
            const wholesaleCents = pricing.wholesale.priceCents;
            const coveredCents2 = Math.min(wholesaleCents, credit.capCents);
            creditInfo = {
              credit_id: credit.id,
              eligible: true,
              cap_cents: credit.capCents,
              covered_cents: coveredCents2,
              expires_at: credit.expiresAt
            };
          } else {
            creditInfo = {
              credit_id: credit.id,
              eligible: false,
              cap_cents: credit.capCents,
              covered_cents: 0,
              expires_at: credit.expiresAt,
              ineligible_reason: isPremium ? "Premium domains are not eligible for domain credits" : `TLD '${tld}' is not eligible for domain credits. Eligible TLDs: ${eligibleTlds.join(", ")}`
            };
          }
        }
      }
      const retailCents = pricing.retail.priceCents;
      const coveredCents = creditInfo?.covered_cents || 0;
      const outOfPocketCents = Math.max(0, retailCents - coveredCents);
      const response = {
        domain: domainResult.domain,
        tld,
        available: domainResult.available,
        premium: domainResult.premium || domainResult.type === "premium" || false,
        pricing: {
          wholesale: {
            registration: pricing.wholesale.priceCents / 100,
            currency: pricing.wholesale.currency
          },
          retail: {
            registration: pricing.retail.priceCents / 100,
            currency: pricing.retail.currency
          }
        },
        credit: creditInfo,
        // Convenience field for frontend cart calculations
        out_of_pocket_cents: outOfPocketCents
      };
      const duration = Date.now() - startTime;
      console.log(`[domain-price:${requestId}] \u2705 Success in ${duration}ms - ${domain}: available=${domainResult.available}, retail=$${pricing.retail.priceCents / 100}, credit_eligible=${creditInfo?.eligible || false}, out_of_pocket=$${outOfPocketCents / 100}`);
      res.json(response);
    } catch (error) {
      const duration = Date.now() - startTime;
      console.error(`[domain-price:${requestId}] \u274C Error after ${duration}ms:`, {
        message: error.message,
        stack: error.stack?.split("\n").slice(0, 3).join("\n"),
        type: error.constructor.name
      });
      if (error instanceof z5.ZodError) {
        return res.status(400).json({
          error: "Validation failed",
          details: error.errors,
          message: "Invalid request parameters"
        });
      }
      handleError(res, error, "Failed to check domain price");
    }
  });
  app2.post("/api/domains/order", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const orderInputSchema = insertDomainOrderSchema.omit({
        userId: true,
        status: true,
        priceCents: true,
        stripeSessionId: true,
        providerRegId: true,
        expiresAt: true,
        errorMessage: true
      });
      const orderData = orderInputSchema.parse(req.body);
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const searchResult = await opensrs.search({ query: orderData.domain });
      const domainResult = searchResult.find((hit) => hit.domain === orderData.domain);
      if (!domainResult || !domainResult.available) {
        return res.status(400).json({ error: "Domain is not available for registration" });
      }
      if (!domainResult.priceCents) {
        return res.status(400).json({ error: "Domain pricing not available" });
      }
      const stripe7 = getStripe3();
      if (!stripe7) {
        return res.status(500).json({ error: "Payment system not available" });
      }
      const domainOrder = await storage.createDomainOrder({
        ...orderData,
        userId: user.id,
        priceCents: domainResult.priceCents,
        status: "pending"
      });
      const session = await stripe7.checkout.sessions.create({
        mode: "payment",
        payment_method_types: ["card"],
        line_items: [{
          price_data: {
            currency: "usd",
            product_data: {
              name: `Domain Registration: ${orderData.domain}`,
              description: `${orderData.years} year${orderData.years > 1 ? "s" : ""} domain registration${orderData.privacy ? " with privacy protection" : ""}`
            },
            unit_amount: domainResult.priceCents
          },
          quantity: 1
        }],
        customer_email: user.email,
        metadata: {
          type: "domain_order",
          domainOrderId: domainOrder.id,
          userId: user.id,
          domain: orderData.domain
        },
        success_url: `${req.protocol}://${req.get("host")}/domains/orders/${domainOrder.id}?success=true`,
        cancel_url: `${req.protocol}://${req.get("host")}/domains/orders/${domainOrder.id}?canceled=true`
      });
      await storage.updateDomainOrder(domainOrder.id, {
        stripeSessionId: session.id
      });
      res.json({
        checkoutUrl: session.url,
        orderId: domainOrder.id
      });
    } catch (error) {
      console.error("Domain order error:", error);
      handleError(res, error, "Failed to create domain order");
    }
  });
  app2.get("/api/domains/orders/:id", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const domainOrder = await storage.getDomainOrder(req.params.id);
      if (!domainOrder) {
        return res.status(404).json({ error: "Domain order not found" });
      }
      if (domainOrder.userId !== user.id) {
        return res.status(403).json({ error: "Access denied" });
      }
      res.json(domainOrder);
    } catch (error) {
      console.error("Domain order fetch error:", error);
      handleError(res, error, "Failed to fetch domain order");
    }
  });
  app2.post("/api/domain/register", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const registerInputSchema = z5.object({
        domain: z5.string().min(1, "Domain is required").max(253, "Domain name too long").regex(
          /^[a-zA-Z0-9]([a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(\.[a-zA-Z0-9]([a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*\.[a-zA-Z]{2,}$/,
          "Invalid domain format"
        ).transform((val) => val.toLowerCase().trim()),
        contact: z5.object({
          firstName: z5.string().min(1, "First name is required"),
          lastName: z5.string().min(1, "Last name is required"),
          email: z5.string().email("Valid email is required"),
          phone: z5.string().min(1, "Phone number is required"),
          address: z5.string().min(1, "Address is required"),
          city: z5.string().min(1, "City is required"),
          state: z5.string().min(1, "State is required"),
          zip: z5.string().min(1, "ZIP code is required"),
          country: z5.string().min(2, "Country code is required").max(2),
          organization: z5.string().optional()
        }),
        nameservers: z5.array(z5.string()).optional(),
        payment_method_id: z5.string().optional()
        // Stripe payment method ID
      });
      const registrationData = registerInputSchema.parse(req.body);
      const { domain, contact, nameservers, payment_method_id } = registrationData;
      console.log(`Domain registration requested for: ${domain} by user ${req.user.uid}`);
      const user = await storage.getUserByFirebaseUid(req.user.uid);
      if (!user) {
        return res.status(404).json({ error: "User not found" });
      }
      const searchResults = await opensrs.search({ query: domain });
      const domainResult = searchResults.find((hit) => hit.domain === domain);
      if (!domainResult || !domainResult.available) {
        return res.status(400).json({
          error: "Domain not available",
          message: `Domain ${domain} is not available for registration`
        });
      }
      if (!domainResult.priceCents) {
        return res.status(400).json({ error: "Domain pricing not available" });
      }
      const pricing = getDomainPricing(domain);
      const tld = "." + domain.split(".").pop()?.toLowerCase();
      const availableCredits = await storage.getAvailableDomainCredits(user.id);
      const sortedCredits = availableCredits.sort(
        (a, b) => new Date(a.expiresAt).getTime() - new Date(b.expiresAt).getTime()
      );
      let creditInfo = null;
      let applicableCredit = null;
      let creditCoverageCents = 0;
      for (const credit of sortedCredits) {
        if (credit.eligibleTlds.includes(tld) && pricing.wholesale.priceCents <= credit.capCents) {
          applicableCredit = credit;
          creditCoverageCents = pricing.wholesale.priceCents;
          creditInfo = {
            id: credit.id,
            eligible: true,
            coverage_cents: creditCoverageCents,
            cap_cents: credit.capCents,
            expires_at: credit.expiresAt,
            reason: `Credit covers full wholesale cost ($${creditCoverageCents / 100})`
          };
          break;
        } else if (credit.eligibleTlds.includes(tld)) {
          applicableCredit = credit;
          creditCoverageCents = credit.capCents;
          creditInfo = {
            id: credit.id,
            eligible: true,
            coverage_cents: creditCoverageCents,
            cap_cents: credit.capCents,
            expires_at: credit.expiresAt,
            reason: `Credit provides partial coverage ($${creditCoverageCents / 100} of $${pricing.wholesale.priceCents / 100} wholesale)`
          };
          break;
        }
      }
      const outOfPocketCents = Math.max(0, pricing.wholesale.priceCents - creditCoverageCents);
      console.log(`Domain ${domain} pricing: wholesale=$${pricing.wholesale.priceCents / 100}, credit_coverage=$${creditCoverageCents / 100}, out_of_pocket=$${outOfPocketCents / 100}`);
      let paymentIntent = null;
      const stripe7 = getStripe3();
      if (outOfPocketCents > 0) {
        if (!payment_method_id) {
          return res.status(400).json({
            error: "Payment required",
            message: `Payment of $${outOfPocketCents / 100} is required. Please provide payment_method_id.`,
            out_of_pocket_cents: outOfPocketCents
          });
        }
        if (!stripe7) {
          return res.status(500).json({ error: "Payment system not available" });
        }
        let customerId = user.stripeCustomerId;
        if (!customerId) {
          const customer = await stripe7.customers.create({
            email: user.email,
            name: user.displayName || `${contact.firstName} ${contact.lastName}`,
            metadata: { user_id: user.id, firebase_uid: user.firebaseUid }
          });
          customerId = customer.id;
          await storage.updateUser(user.id, { stripeCustomerId: customerId });
        }
        paymentIntent = await stripe7.paymentIntents.create({
          amount: outOfPocketCents,
          currency: "usd",
          customer: customerId,
          payment_method: payment_method_id,
          confirmation_method: "manual",
          confirm: true,
          return_url: `${req.protocol}://${req.get("host")}/domains`,
          metadata: {
            type: "domain_registration",
            domain,
            user_id: user.id,
            credit_used: applicableCredit?.id || "none"
          },
          description: `Domain registration payment for ${domain}`
        });
        if (paymentIntent.status === "requires_action" || paymentIntent.status === "requires_source_action") {
          return res.json({
            requires_action: true,
            payment_intent: {
              id: paymentIntent.id,
              client_secret: paymentIntent.client_secret,
              status: paymentIntent.status
            }
          });
        }
        if (paymentIntent.status !== "succeeded") {
          return res.status(400).json({
            error: "Payment failed",
            message: `Payment status: ${paymentIntent.status}`,
            payment_intent_id: paymentIntent.id
          });
        }
        console.log(`Payment successful for ${domain}: ${paymentIntent.id}, amount=$${outOfPocketCents / 100}`);
      }
      const opensrsContact = {
        firstName: contact.firstName,
        lastName: contact.lastName,
        email: contact.email,
        phone: contact.phone,
        address: contact.address,
        city: contact.city,
        state: contact.state,
        zip: contact.zip,
        country: contact.country,
        organization: contact.organization
      };
      console.log(`Registering domain ${domain} via OpenSRS...`);
      const registrationResult = await opensrs.register({
        domain,
        years: 1,
        // Default to 1 year
        contact: opensrsContact,
        privacy: false,
        // Default to no privacy for now
        nameservers: nameservers?.length ? nameservers : void 0
      });
      if (!registrationResult.success) {
        if (paymentIntent && paymentIntent.status === "succeeded") {
          try {
            await stripe7.refunds.create({
              payment_intent: paymentIntent.id,
              reason: "requested_by_customer"
            });
            console.log(`Refunded payment ${paymentIntent.id} due to failed domain registration`);
          } catch (refundError) {
            console.error(`Failed to refund payment ${paymentIntent.id}:`, refundError);
          }
        }
        return res.status(400).json({
          error: "Domain registration failed",
          message: registrationResult.message || "Registration failed with registrar",
          opensrs_error: registrationResult.message
        });
      }
      console.log(`Domain registration successful: ${domain}, OpenSRS ID: ${registrationResult.providerRegId}`);
      const domainRecord = await storage.createDomain({
        userId: user.id,
        domain,
        expiresAt: new Date(Date.now() + 365 * 24 * 60 * 60 * 1e3),
        // 1 year from now
        autorenew: true,
        registrar: "opensrs",
        providerRegId: registrationResult.providerRegId,
        nameservers: nameservers || [],
        status: "active"
      });
      let creditUsed = null;
      if (applicableCredit && creditCoverageCents > 0) {
        await storage.updateDomainCreditStatus(
          applicableCredit.id,
          "used",
          domain,
          /* @__PURE__ */ new Date()
        );
        creditUsed = {
          credit_id: applicableCredit.id,
          amount_cents: creditCoverageCents
        };
        console.log(`Domain credit redeemed: ${applicableCredit.id}, amount=$${creditCoverageCents / 100} for domain ${domain}`);
        await storage.createNotification(
          user.id,
          `Domain credit of $${creditCoverageCents / 100} successfully applied to ${domain} registration!`,
          "success"
        );
      }
      await storage.createNotification(
        user.id,
        `Domain ${domain} has been successfully registered and is now active!`,
        "success"
      );
      const response = {
        success: true,
        domain: domainRecord,
        payment_intent: paymentIntent?.id || null,
        opensrs_order: registrationResult.providerRegId || null,
        credit_used: creditUsed,
        pricing: {
          wholesale_cents: pricing.wholesale.priceCents,
          credit_coverage_cents: creditCoverageCents,
          out_of_pocket_cents: outOfPocketCents
        }
      };
      console.log(`Domain registration completed successfully: ${domain}, user: ${user.id}, credit_used: ${creditUsed?.credit_id || "none"}, payment: ${paymentIntent?.id || "none"}`);
      res.json(response);
    } catch (error) {
      console.error("Domain registration error:", error);
      if (error instanceof z5.ZodError) {
        return res.status(400).json({
          error: "Validation failed",
          details: error.errors,
          message: "Invalid request parameters"
        });
      }
      if (error instanceof Error) {
        if (error.message.includes("OpenSRS")) {
          return res.status(500).json({
            error: "Domain registration service error",
            message: "Failed to communicate with domain registrar"
          });
        }
        if (error.message.includes("Stripe") || error.message.includes("payment")) {
          return res.status(500).json({
            error: "Payment processing error",
            message: "Failed to process payment"
          });
        }
      }
      handleError(res, error, "Failed to register domain");
    }
  });
  async function mcpAudit(event) {
    const line = `[${(/* @__PURE__ */ new Date()).toISOString()}] ${JSON.stringify(event)}
`;
    await fs9.appendFile("./mcp-audit.log", line).catch(() => {
    });
  }
  const mcpAuth = (req, res, next) => {
    const auth = (req.headers.authorization || "").split(" ")[1];
    const bearerToken = process.env.MCP_BEARER_TOKEN || "changeme";
    if (!auth || auth !== bearerToken) {
      mcpAudit({ type: "unauth", ip: req.ip, path: req.path, headers: { ua: req.headers["user-agent"] } }).catch(() => {
      });
      return res.status(401).json({ error: "Unauthorized" });
    }
    next();
  };
  const MCP_COMMAND_WHITELIST = {
    build: "npm run build",
    test: "npm test",
    lint: "npm run lint",
    typecheck: "npm run check",
    dev: "npm run dev",
    "seed:db": "node scripts/seed.js"
  };
  app2.get("/mcp/ping", mcpAuth, async (req, res) => {
    await mcpAudit({ type: "ping", requester: req.headers["x-requester"] || "unknown" });
    res.json({ ok: true, ts: Date.now() });
  });
  app2.post("/mcp/run", mcpAuth, async (req, res) => {
    const { cmdKey, args = [] } = req.body || {};
    const requester = req.headers["x-requester"] || "unknown";
    if (!cmdKey || !(cmdKey in MCP_COMMAND_WHITELIST)) {
      await mcpAudit({ type: "run_rejected", cmdKey, requester, ip: req.ip });
      return res.status(400).json({ error: "Invalid or non-whitelisted command key" });
    }
    const fullCmd = `${MCP_COMMAND_WHITELIST[cmdKey]} ${args.map((a) => `"${String(a).replace(/"/g, '\\"')}"`).join(" ")}`.trim();
    const requiresConfirm = ["seed:db"].includes(cmdKey);
    if (requiresConfirm && req.headers["x-confirm"] !== "yes") {
      await mcpAudit({ type: "run_needs_confirm", cmdKey, requester, fullCmd, ip: req.ip });
      return res.status(409).json({ error: "Command requires explicit confirmation header x-confirm: yes" });
    }
    await mcpAudit({ type: "run_start", cmdKey, requester, fullCmd, ip: req.ip });
    exec(fullCmd, { maxBuffer: 10 * 1024 * 1024 }, async (err, stdout, stderr) => {
      await mcpAudit({
        type: "run_finish",
        cmdKey,
        requester,
        fullCmd,
        exitCode: err ? err.code || "err" : 0,
        stdout: String(stdout).slice(0, 1e4),
        stderr: String(stderr).slice(0, 1e4)
      }).catch(() => {
      });
      res.json({
        cmdKey,
        fullCmd,
        success: !err,
        stdout: String(stdout),
        stderr: String(stderr),
        error: err ? err.message : void 0
      });
    });
  });
  app2.post("/mcp/files/read", mcpAuth, async (req, res) => {
    const { path: relPath } = req.body || {};
    if (!relPath) return res.status(400).json({ error: "path required" });
    const safePath = path9.resolve(process.cwd(), relPath);
    if (!safePath.startsWith(process.cwd())) return res.status(403).json({ error: "Forbidden" });
    try {
      const content = await fs9.readFile(safePath, "utf8");
      await mcpAudit({ type: "files_read", path: relPath, requester: req.headers["x-requester"] || "unknown" });
      res.json({ path: relPath, content });
    } catch (e) {
      await mcpAudit({ type: "files_read_error", path: relPath, error: e.message });
      res.status(500).json({ error: e.message });
    }
  });
  app2.post("/mcp/files/write", mcpAuth, async (req, res) => {
    const { path: relPath, content } = req.body || {};
    if (!relPath) return res.status(400).json({ error: "path required" });
    if (req.headers["x-confirm"] !== "yes") {
      await mcpAudit({ type: "files_write_needs_confirm", path: relPath, requester: req.headers["x-requester"] || "unknown" });
      return res.status(409).json({ error: "File writes require x-confirm: yes header" });
    }
    const safePath = path9.resolve(process.cwd(), relPath);
    if (!safePath.startsWith(process.cwd())) return res.status(403).json({ error: "Forbidden" });
    try {
      await fs9.mkdir(path9.dirname(safePath), { recursive: true });
      await fs9.writeFile(safePath, String(content || ""), "utf8");
      await mcpAudit({ type: "files_write", path: relPath, requester: req.headers["x-requester"] || "unknown" });
      res.json({ path: relPath, success: true });
    } catch (e) {
      await mcpAudit({ type: "files_write_error", path: relPath, error: e.message });
      res.status(500).json({ error: e.message });
    }
  });
  app2.get("/mcp/logs/tail", mcpAuth, async (req, res) => {
    const lines = parseInt(req.query.lines || "200", 10);
    const logfile = process.env.APP_LOG || "logs/app.log";
    try {
      const content = await fs9.readFile(logfile, "utf8");
      const all = content.split(/\r?\n/).filter(Boolean);
      const tail = all.slice(-lines).join("\n");
      await mcpAudit({ type: "logs_tail", lines, requester: req.headers["x-requester"] || "unknown" });
      res.type("text/plain").send(tail);
    } catch (e) {
      await mcpAudit({ type: "logs_error", error: e.message, path: logfile });
      res.status(500).json({ error: "Unable to read log file", details: e.message });
    }
  });
  app2.post("/mcp/env/get", mcpAuth, async (req, res) => {
    const { key } = req.body || {};
    if (!key) return res.status(400).json({ error: "key required" });
    await mcpAudit({ type: "env_get", key, requester: req.headers["x-requester"] || "unknown" });
    res.json({ key, value: process.env[key] || null });
  });
  app2.post("/mcp/env/set", mcpAuth, async (req, res) => {
    const { key, value } = req.body || {};
    if (!key) return res.status(400).json({ error: "key required" });
    if (req.headers["x-confirm"] !== "yes") {
      await mcpAudit({ type: "env_set_needs_confirm", key, requester: req.headers["x-requester"] || "unknown" });
      return res.status(409).json({ error: "Setting env requires x-confirm: yes" });
    }
    process.env[key] = String(value || "");
    await mcpAudit({ type: "env_set", key, requester: req.headers["x-requester"] || "unknown" });
    res.json({ success: true, key });
  });
  app2.post("/mcp/repo/pr", mcpAuth, async (req, res) => {
    const GITHUB_TOKEN = process.env.GITHUB_TOKEN;
    const REPO_OWNER = process.env.REPO_OWNER;
    const REPO_NAME = process.env.REPO_NAME;
    if (!GITHUB_TOKEN || !REPO_OWNER || !REPO_NAME) {
      return res.status(500).json({ error: "GitHub integration not configured" });
    }
    const { branchName, title, body } = req.body || {};
    if (!branchName || !title) return res.status(400).json({ error: "branchName and title required" });
    try {
      const api = `https://api.github.com/repos/${REPO_OWNER}/${REPO_NAME}/pulls`;
      const response = await fetch(api, {
        method: "POST",
        headers: { "Authorization": `token ${GITHUB_TOKEN}`, "Accept": "application/vnd.github.v3+json" },
        body: JSON.stringify({ title, head: branchName, base: "main", body: body || "" })
      });
      const data = await response.json();
      await mcpAudit({ type: "repo_pr", branchName, title, result: { status: response.status, id: data.number } });
      res.json({ ok: response.ok, status: response.status, data });
    } catch (e) {
      await mcpAudit({ type: "repo_pr_error", error: e.message });
      res.status(500).json({ error: e.message });
    }
  });
  app2.post("/api/brand-kit/queue", authenticateToken2, async (req, res) => {
    try {
      if (!req.user) {
        return res.status(401).json({ error: "User not authenticated" });
      }
      const { svgMarkup, brandName, colors, fonts } = req.body;
      if (!svgMarkup || !brandName) {
        return res.status(400).json({ error: "Missing required fields: svgMarkup, brandName" });
      }
      console.log("Brand kit requested:", {
        userId: req.user.uid,
        brandName,
        colorsCount: colors?.length || 0,
        fontsCount: fonts?.length || 0,
        svgLength: svgMarkup.length
      });
      res.json({
        success: true,
        message: "Logo sent to brand kit successfully"
      });
    } catch (error) {
      console.error("Brand kit queue error:", error);
      handleError(res, error, "Failed to send to brand kit");
    }
  });
  const httpServer = createServer(app2);
  return httpServer;
}

// server/routes/coverTemplates.ts
init_storage();
import express9 from "express";

// server/stripe/coverCheckout.ts
import Stripe5 from "stripe";
if (!process.env.STRIPE_SECRET_KEY) {
  throw new Error("Missing required Stripe secret: STRIPE_SECRET_KEY");
}
var stripe5 = new Stripe5(process.env.STRIPE_SECRET_KEY, { apiVersion: "2024-06-20" });
var PRICE_LOOKUP_KEY = "ibrandbiz_cover_divider_price_v1";
async function ensureGlobalCoverPrice() {
  const prices = await stripe5.prices.list({ lookup_keys: [PRICE_LOOKUP_KEY], active: true, limit: 1 });
  if (prices.data.length > 0) return prices.data[0];
  const products = await stripe5.products.list({ active: true, limit: 100 });
  let product = products.data.find((p) => p.metadata.code === "ibrandbiz_cover_divider");
  if (!product) {
    product = await stripe5.products.create({
      name: "Cover + Divider Template (Editable)",
      description: "Editable presentation cover & section divider. PPTX / Keynote / Google Slides.",
      metadata: { code: "ibrandbiz_cover_divider" }
    });
  }
  const unit_amount = parseInt(process.env.COVER_TEMPLATE_PRICE_CENTS || "1499", 10);
  const currency = (process.env.COVER_TEMPLATE_CURRENCY || "usd").toLowerCase();
  try {
    return await stripe5.prices.create({
      product: product.id,
      unit_amount,
      currency,
      lookup_key: PRICE_LOOKUP_KEY
    });
  } catch (error) {
    if (error.code === "resource_already_exists" || error.raw?.code === "resource_already_exists") {
      const retryPrices = await stripe5.prices.list({ lookup_keys: [PRICE_LOOKUP_KEY], active: true, limit: 1 });
      if (retryPrices.data.length > 0) return retryPrices.data[0];
    }
    throw error;
  }
}
async function createCheckoutSession(args) {
  const price = await ensureGlobalCoverPrice();
  return stripe5.checkout.sessions.create({
    mode: "payment",
    line_items: [{ price: price.id, quantity: 1 }],
    success_url: args.successUrl,
    cancel_url: args.cancelUrl,
    discounts: args.coupon ? [{ coupon: args.coupon }] : void 0,
    metadata: args.metadata
  });
}

// server/routes/coverTemplates.ts
init_schema();
import { and as and2, eq as eq2, desc as desc2 } from "drizzle-orm";
var router19 = express9.Router();
var authenticate = (req, res, next) => {
  if (process.env.NODE_ENV === "development") {
    req.user = {
      id: "dev-user-123",
      uid: "dev-user-123",
      email: "dev@example.com"
    };
    return next();
  }
  if (!req.user) {
    return res.status(401).json({ error: "Authentication required" });
  }
  next();
};
var authenticateAdmin = (req, res, next) => {
  if (process.env.NODE_ENV === "development") {
    return next();
  }
  if (!req.user?.isAdmin) {
    return res.status(403).json({ error: "Admin access required" });
  }
  next();
};
router19.get("/api/cover-templates", async (req, res) => {
  try {
    const rows = await storage.getCoverTemplates({
      q: req.query.q,
      category: req.query.category,
      top_tier: req.query.toptier,
      subcat: req.query.subcat,
      min: req.query.min ? parseInt(req.query.min, 10) : void 0,
      max: req.query.max ? parseInt(req.query.max, 10) : void 0
    });
    res.json(rows);
  } catch (error) {
    console.error("[cover-templates] Gallery error:", error);
    res.status(500).json({ error: "Failed to fetch templates" });
  }
});
router19.get("/api/cover-templates/:id", async (req, res) => {
  try {
    const tpl = await storage.getCoverTemplate(req.params.id);
    if (!tpl || !tpl.isActive || tpl.approvalStatus !== "approved") {
      return res.status(404).json({ error: "Not found" });
    }
    res.json(tpl);
  } catch (error) {
    console.error("[cover-templates] Single template error:", error);
    res.status(500).json({ error: "Failed to fetch template" });
  }
});
router19.post("/api/creator/cover-templates", authenticate, async (req, res) => {
  try {
    const {
      title,
      category,
      priceCents,
      previewUrl,
      downloadFile,
      top_tier,
      subcategories,
      cover_preview_url,
      divider1_preview_url,
      divider2_preview_url,
      divider3_preview_url
    } = req.body || {};
    if (!title || !category || !previewUrl) {
      return res.status(400).json({ error: "Missing required fields" });
    }
    const rec = await storage.createCoverTemplate({
      title,
      category,
      topTier: top_tier || "General",
      subcategories: subcategories || [],
      priceCents: priceCents ?? 1499,
      // Default to global price
      previewUrl,
      // Card thumbnail
      coverPreviewUrl: cover_preview_url,
      divider1PreviewUrl: divider1_preview_url,
      divider2PreviewUrl: divider2_preview_url,
      divider3PreviewUrl: divider3_preview_url,
      downloadFile,
      isActive: false,
      // Awaiting approval
      approvalStatus: "pending"
    });
    res.json({ success: true, template: rec });
  } catch (error) {
    console.error("[cover-templates] Creator upload error:", error);
    res.status(500).json({ error: "Failed to create template" });
  }
});
router19.post("/api/cover-templates/:id/checkout", authenticate, async (req, res) => {
  try {
    const tpl = await storage.getCoverTemplate(req.params.id);
    if (!tpl || !tpl.isActive || tpl.approvalStatus !== "approved") {
      return res.status(404).json({ error: "Template not found" });
    }
    const { customImageUrl, applyProDiscount } = req.body || {};
    const purchase = await storage.createCoverPurchase({
      userId: req.user.id,
      templateId: tpl.id,
      customImageUrl: customImageUrl || null,
      status: "pending"
    });
    const baseUrl = process.env.DOMAIN_URL || process.env.FRONTEND_URL || process.env.APP_BASE_URL || req.headers.origin || "";
    const successUrl = `${baseUrl}/business-assets/templates/cover-dividers?success=true&purchase=${purchase.id}`;
    const cancelUrl = `${baseUrl}/business-assets/templates/cover-dividers?cancel=true`;
    let coupon;
    if (applyProDiscount) {
      if (!process.env.STRIPE_COUPON_PRO_20) {
        return res.status(400).json({ error: "Pro discount not available" });
      }
      const user = await storage.getUser(req.user.id);
      if (!user || !user.isPaid) {
        return res.status(403).json({ error: "Pro discount requires active Pro subscription" });
      }
      coupon = process.env.STRIPE_COUPON_PRO_20;
    }
    const session = await createCheckoutSession({
      successUrl,
      cancelUrl,
      coupon,
      metadata: {
        templateId: tpl.id,
        customImageUrl: customImageUrl || "",
        userId: req.user.id,
        purchaseId: purchase.id
      }
    });
    res.json({ checkoutUrl: session.url, purchaseId: purchase.id });
  } catch (error) {
    console.error("[cover-templates] Checkout error:", error);
    res.status(500).json({ error: "Failed to create checkout session" });
  }
});
router19.get("/api/covers/purchases", authenticate, async (req, res) => {
  try {
    const purchases2 = await storage.getUserCoverPurchases(req.user.id);
    res.json(purchases2);
  } catch (error) {
    console.error("[cover-templates] Purchases error:", error);
    res.status(500).json({ error: "Failed to fetch purchases" });
  }
});
router19.get("/api/covers/templates", async (req, res) => {
  try {
    const rows = await storage.getCoverTemplates({
      q: req.query.q,
      category: req.query.category,
      top_tier: req.query.toptier,
      subcat: req.query.subcat,
      min: req.query.min ? parseInt(req.query.min, 10) : void 0,
      max: req.query.max ? parseInt(req.query.max, 10) : void 0
    });
    res.json(rows);
  } catch (error) {
    console.error("[cover-templates] Legacy templates error:", error);
    res.status(500).json({ error: "Failed to fetch templates" });
  }
});
router19.get("/api/admin/cover-templates", authenticateAdmin, async (req, res) => {
  try {
    const q = req.query.q || void 0;
    const category = req.query.category || void 0;
    const min = req.query.min ? parseInt(req.query.min, 10) : void 0;
    const max = req.query.max ? parseInt(req.query.max, 10) : void 0;
    const includeInactive = req.query.includeInactive === "true";
    const rows = await storage.getCoverTemplates({
      q,
      category,
      min,
      max,
      top_tier: req.query.toptier,
      subcat: req.query.subcat,
      includeInactive
    });
    res.json(rows);
  } catch (error) {
    console.error("[admin-cover-templates] Gallery error:", error);
    res.status(500).json({ error: "Failed to fetch templates" });
  }
});
router19.patch("/api/admin/cover-templates/:id/activate", authenticateAdmin, async (req, res) => {
  try {
    const { active } = req.body || {};
    const updated = await storage.updateCoverTemplate(req.params.id, { isActive: !!active });
    if (!updated) {
      return res.status(404).json({ error: "Template not found" });
    }
    res.json({ success: true, isActive: updated.isActive });
  } catch (error) {
    console.error("[admin-cover-templates] Activation error:", error);
    res.status(500).json({ error: "Failed to update template" });
  }
});
router19.get("/api/cover-templates/:id/my-status", authenticate, async (req, res) => {
  try {
    const purchases2 = await storage.db.select().from(coverPurchases).where(and2(
      eq2(coverPurchases.userId, req.user.id),
      eq2(coverPurchases.templateId, req.params.id),
      eq2(coverPurchases.status, "paid")
    )).orderBy(desc2(coverPurchases.createdAt)).limit(1);
    if (!purchases2.length) {
      return res.json({ owned: false });
    }
    return res.json({
      owned: true,
      download_url: purchases2[0].downloadUrl,
      purchase_id: purchases2[0].id
    });
  } catch (error) {
    console.error("[cover-templates] Ownership check error:", error);
    res.status(500).json({ error: "Failed to check ownership" });
  }
});
router19.get("/api/cover-templates/:id/download", authenticate, async (req, res) => {
  try {
    const purchase = await storage.db.select().from(coverPurchases).where(and2(
      eq2(coverPurchases.userId, req.user.id),
      eq2(coverPurchases.templateId, req.params.id),
      eq2(coverPurchases.status, "paid")
    )).orderBy(desc2(coverPurchases.createdAt)).limit(1);
    if (!purchase.length || !purchase[0].downloadUrl) {
      return res.status(403).json({ error: "Not purchased" });
    }
    return res.redirect(purchase[0].downloadUrl);
  } catch (error) {
    console.error("[cover-templates] Download error:", error);
    res.status(500).json({ error: "Failed to process download" });
  }
});
router19.get("/api/purchases/:id", authenticate, async (req, res) => {
  try {
    const purchase = await storage.db.select().from(coverPurchases).where(and2(
      eq2(coverPurchases.id, req.params.id),
      eq2(coverPurchases.userId, req.user.id)
    )).limit(1);
    if (!purchase.length) {
      return res.status(404).json({ error: "Not found" });
    }
    res.json({
      ...purchase[0],
      download_url: purchase[0].downloadUrl
    });
  } catch (error) {
    console.error("[cover-templates] Purchase lookup error:", error);
    res.status(500).json({ error: "Failed to fetch purchase" });
  }
});
router19.get("/api/me/cover-purchases", authenticate, async (req, res) => {
  try {
    const purchases2 = await storage.db.select().from(coverPurchases).where(eq2(coverPurchases.userId, req.user.id)).orderBy(desc2(coverPurchases.createdAt));
    res.json(purchases2);
  } catch (error) {
    console.error("[cover-templates] My purchases error:", error);
    res.status(500).json({ error: "Failed to fetch purchases" });
  }
});
var coverTemplates_default = router19;

// server/routes/infographicTemplates.ts
init_storage();
import express10 from "express";

// server/stripe/infographicCheckout.ts
import Stripe6 from "stripe";
if (!process.env.STRIPE_SECRET_KEY) {
  throw new Error("Missing required Stripe secret: STRIPE_SECRET_KEY");
}
var stripe6 = new Stripe6(process.env.STRIPE_SECRET_KEY, { apiVersion: "2024-06-20" });
var PRICE_LOOKUP_KEY2 = "ibrandbiz_infographic_bundle_price_v1";
async function ensureGlobalInfographicBundlePrice() {
  const prices = await stripe6.prices.list({ lookup_keys: [PRICE_LOOKUP_KEY2], active: true, limit: 1 });
  if (prices.data.length > 0) return prices.data[0];
  const products = await stripe6.products.list({ active: true, limit: 100 });
  let product = products.data.find((p) => p.metadata.code === "ibrandbiz_infographic_bundle");
  if (!product) {
    product = await stripe6.products.create({
      name: "Infographic Templates Bundle (1-4 Items)",
      description: "Professional infographic templates bundle. Choose 1-4 slides. PowerPoint, Keynote, Google Slides formats included.",
      metadata: { code: "ibrandbiz_infographic_bundle" }
    });
  }
  const unit_amount = parseInt(process.env.INFOGRAPHIC_BUNDLE_PRICE_CENTS || "1499", 10);
  const currency = (process.env.INFOGRAPHIC_BUNDLE_CURRENCY || "usd").toLowerCase();
  try {
    return await stripe6.prices.create({
      product: product.id,
      unit_amount,
      currency,
      lookup_key: PRICE_LOOKUP_KEY2
    });
  } catch (error) {
    if (error.code === "resource_already_exists" || error.raw?.code === "resource_already_exists") {
      const retryPrices = await stripe6.prices.list({ lookup_keys: [PRICE_LOOKUP_KEY2], active: true, limit: 1 });
      if (retryPrices.data.length > 0) return retryPrices.data[0];
    }
    throw error;
  }
}
async function createInfographicBundleCheckoutSession(args) {
  const price = await ensureGlobalInfographicBundlePrice();
  return stripe6.checkout.sessions.create({
    mode: "payment",
    line_items: [{ price: price.id, quantity: 1 }],
    // Always quantity 1 for bundle
    success_url: args.successUrl,
    cancel_url: args.cancelUrl,
    discounts: args.coupon ? [{ coupon: args.coupon }] : void 0,
    metadata: args.metadata
  });
}

// server/routes/infographicTemplates.ts
import { z as z6 } from "zod";
var router20 = express10.Router();
var checkoutRequestSchema = z6.object({
  selectedIds: z6.array(z6.string().min(1, "Template ID cannot be empty")).min(1, "Please select at least 1 infographic").max(4, "Maximum 4 infographics allowed per bundle").refine((arr) => new Set(arr).size === arr.length, "Duplicate selections not allowed")
});
var authenticate2 = (req, res, next) => {
  if (process.env.NODE_ENV === "development") {
    req.user = {
      id: "dev-user-123",
      uid: "dev-user-123",
      email: "dev@example.com"
    };
    return next();
  }
  if (!req.user) {
    return res.status(401).json({ error: "Authentication required" });
  }
  next();
};
var authenticateAdmin2 = (req, res, next) => {
  if (process.env.NODE_ENV === "development") {
    return next();
  }
  if (!req.user?.isAdmin) {
    return res.status(403).json({ error: "Admin access required" });
  }
  next();
};
router20.get("/api/infographics", async (req, res) => {
  try {
    const descriptorsParam = req.query.descriptors;
    const descriptors = descriptorsParam ? descriptorsParam.split(",").map((d) => d.trim()) : void 0;
    const rows = await storage.getInfographicTemplates({
      q: req.query.q,
      category: req.query.category,
      descriptors,
      min: req.query.min ? parseInt(req.query.min, 10) : void 0,
      max: req.query.max ? parseInt(req.query.max, 10) : void 0
    });
    res.json(rows);
  } catch (error) {
    console.error("[infographics] Gallery error:", error);
    res.status(500).json({ error: "Failed to fetch templates" });
  }
});
router20.get("/api/infographics/:id", async (req, res) => {
  try {
    const tpl = await storage.getInfographicTemplate(req.params.id);
    if (!tpl || !tpl.isActive || tpl.approvalStatus !== "approved") {
      return res.status(404).json({ error: "Not found" });
    }
    res.json(tpl);
  } catch (error) {
    console.error("[infographics] Single template error:", error);
    res.status(500).json({ error: "Failed to fetch template" });
  }
});
router20.post("/api/creator/infographics", authenticate2, async (req, res) => {
  try {
    const {
      title,
      category,
      priceCents,
      previewImageUrl,
      descriptors,
      topTier,
      subcategories,
      pptxUrl,
      keynoteUrl,
      gslidesUrl,
      downloadBundleUrl
    } = req.body || {};
    if (!title || !category || !previewImageUrl) {
      return res.status(400).json({ error: "Missing required fields: title, category, previewImageUrl" });
    }
    if (!descriptors || !Array.isArray(descriptors) || descriptors.length === 0) {
      return res.status(400).json({ error: "At least one descriptor is required" });
    }
    if (!pptxUrl && !keynoteUrl && !gslidesUrl && !downloadBundleUrl) {
      return res.status(400).json({ error: "At least one format URL must be provided" });
    }
    const rec = await storage.createInfographicTemplate({
      creatorId: req.user.id,
      // can be null for admin uploads
      title,
      topTier: topTier || "General",
      subcategories: subcategories || [],
      descriptors,
      // FIXED: Now properly accepting and storing descriptors
      category,
      priceCents: priceCents ?? 1499,
      // Default to bundle price
      currency: "usd",
      previewImageUrl,
      pptxUrl: pptxUrl || null,
      keynoteUrl: keynoteUrl || null,
      gslidesUrl: gslidesUrl || null,
      downloadBundleUrl: downloadBundleUrl || null,
      isActive: false,
      // Awaiting approval
      approvalStatus: "pending"
    });
    res.json({ success: true, template: rec });
  } catch (error) {
    console.error("[infographics] Creator upload error:", error);
    res.status(500).json({ error: "Failed to create template" });
  }
});
router20.post("/api/admin/seed-infographics", async (req, res) => {
  if (process.env.NODE_ENV !== "development") {
    return res.status(403).json({ error: "Only available in development" });
  }
  const sampleInfographics = [
    {
      title: "Financial Performance Dashboard",
      topTier: "FIG",
      subcategories: ["Finance & Insurance"],
      category: "business",
      priceCents: 1499,
      currency: "usd",
      previewImageUrl: "https://images.unsplash.com/photo-1551288049-bebda4e38f71?w=800&h=600",
      pptxUrl: "https://example.com/financial-dashboard.pptx",
      keynoteUrl: "https://example.com/financial-dashboard.key",
      gslidesUrl: "https://example.com/financial-dashboard",
      downloadBundleUrl: "https://example.com/financial-dashboard.zip",
      isActive: true,
      approvalStatus: "approved"
    },
    {
      title: "Technology Market Analysis",
      topTier: "TMT",
      subcategories: ["Information Technology (IT) / Information"],
      category: "professional",
      priceCents: 1499,
      currency: "usd",
      previewImageUrl: "https://images.unsplash.com/photo-1460925895917-afdab827c52f?w=800&h=600",
      pptxUrl: "https://example.com/tech-analysis.pptx",
      keynoteUrl: "https://example.com/tech-analysis.key",
      gslidesUrl: "https://example.com/tech-analysis",
      downloadBundleUrl: "https://example.com/tech-analysis.zip",
      isActive: true,
      approvalStatus: "approved"
    },
    {
      title: "Healthcare Industry Overview",
      topTier: "Healthcare/Pharma",
      subcategories: ["Healthcare"],
      category: "professional",
      priceCents: 1499,
      currency: "usd",
      previewImageUrl: "https://images.unsplash.com/photo-1559757148-5c350d0d3c56?w=800&h=600",
      pptxUrl: "https://example.com/healthcare-overview.pptx",
      keynoteUrl: "https://example.com/healthcare-overview.key",
      gslidesUrl: "https://example.com/healthcare-overview",
      downloadBundleUrl: "https://example.com/healthcare-overview.zip",
      isActive: true,
      approvalStatus: "approved"
    },
    {
      title: "Modern Business Process Flow",
      topTier: "General",
      subcategories: ["Professional, Scientific, & Technical Services"],
      category: "modern",
      priceCents: 1499,
      currency: "usd",
      previewImageUrl: "https://images.unsplash.com/photo-1507003211169-0a1dd7228f2d?w=800&h=600",
      pptxUrl: "https://example.com/business-process.pptx",
      keynoteUrl: "https://example.com/business-process.key",
      gslidesUrl: "https://example.com/business-process",
      downloadBundleUrl: "https://example.com/business-process.zip",
      isActive: true,
      approvalStatus: "approved"
    },
    {
      title: "Creative Marketing Funnel",
      topTier: "General",
      subcategories: ["Professional, Scientific, & Technical Services"],
      category: "creative",
      priceCents: 1499,
      currency: "usd",
      previewImageUrl: "https://images.unsplash.com/photo-1432888622747-4eb9a8efeb07?w=800&h=600",
      pptxUrl: "https://example.com/marketing-funnel.pptx",
      keynoteUrl: "https://example.com/marketing-funnel.key",
      gslidesUrl: "https://example.com/marketing-funnel",
      downloadBundleUrl: "https://example.com/marketing-funnel.zip",
      isActive: true,
      approvalStatus: "approved"
    }
  ];
  try {
    const created = [];
    for (const infographic of sampleInfographics) {
      const result = await storage.createInfographicTemplate(infographic);
      created.push(result);
    }
    res.json({ success: true, created: created.length, templates: created });
  } catch (error) {
    console.error("Seed error:", error);
    res.status(500).json({ error: "Failed to seed infographics" });
  }
});
router20.get("/api/admin/infographics", authenticateAdmin2, async (req, res) => {
  try {
    const rows = await storage.getInfographicTemplates({
      q: req.query.q,
      category: req.query.category,
      descriptors: req.query.descriptors ? req.query.descriptors.split(",") : void 0,
      min: req.query.min ? parseInt(req.query.min, 10) : void 0,
      max: req.query.max ? parseInt(req.query.max, 10) : void 0,
      includeInactive: req.query.includeInactive === "true",
      status: req.query.status
    });
    res.json(rows);
  } catch (error) {
    console.error("[admin-infographics] List templates error:", error);
    res.status(500).json({ error: "Failed to fetch templates" });
  }
});
router20.patch("/api/admin/infographics/:id/activate", authenticateAdmin2, async (req, res) => {
  try {
    const { active } = req.body;
    const updateData = {
      isActive: Boolean(active),
      approvalStatus: active ? "approved" : "pending"
    };
    const updated = await storage.updateInfographicTemplate(req.params.id, updateData);
    if (!updated) {
      return res.status(404).json({ error: "Template not found" });
    }
    res.json({ success: true, template: updated });
  } catch (error) {
    console.error("[infographics] Admin activate error:", error);
    res.status(500).json({ error: "Failed to update template" });
  }
});
router20.post("/api/infographics/checkout", authenticate2, async (req, res) => {
  try {
    const validationResult = checkoutRequestSchema.safeParse(req.body);
    if (!validationResult.success) {
      const errors = validationResult.error.errors.map((err) => ({
        field: err.path.join("."),
        message: err.message
      }));
      return res.status(400).json({
        error: "Validation failed",
        details: errors
      });
    }
    const { selectedIds } = validationResult.data;
    const templates = await Promise.all(
      selectedIds.map((id) => storage.getInfographicTemplate(id))
    );
    const unavailableTemplates = templates.filter(
      (tpl, index2) => !tpl || !tpl.isActive || tpl.approvalStatus !== "approved"
    );
    if (unavailableTemplates.length > 0) {
      return res.status(400).json({
        error: "One or more items are unavailable. Please reselect."
      });
    }
    const purchase = await storage.createInfographicPurchase({
      userId: req.user.id,
      // Server-controlled, not from client
      selectedIds,
      status: "pending",
      amountCents: 1499,
      // Server-controlled bundle price
      currency: "usd"
    });
    const baseUrl = process.env.DOMAIN_URL || process.env.FRONTEND_URL || process.env.APP_BASE_URL || req.headers.origin || "";
    const session = await createInfographicBundleCheckoutSession({
      successUrl: `${baseUrl}/business-assets/templates/infographics?success=true&purchase=${purchase.id}`,
      cancelUrl: `${baseUrl}/business-assets/templates/infographics?canceled=true`,
      metadata: {
        type: "infographic_bundle",
        purchaseId: purchase.id,
        selectedIds: selectedIds.join(","),
        userId: req.user.id
      }
    });
    await storage.updateInfographicPurchase(purchase.id, {
      stripeSessionId: session.id
    });
    res.json({
      sessionId: session.id,
      url: session.url,
      purchaseId: purchase.id
    });
  } catch (error) {
    console.error("[infographics] Checkout error:", error);
    res.status(500).json({ error: "Failed to process checkout" });
  }
});
router20.get("/api/infographics/purchases/:id", authenticate2, async (req, res) => {
  try {
    const purchase = await storage.getInfographicPurchase(req.params.id);
    if (!purchase || purchase.userId !== req.user.id) {
      return res.status(404).json({ error: "Purchase not found" });
    }
    res.json(purchase);
  } catch (error) {
    console.error("[infographics] Purchase status error:", error);
    res.status(500).json({ error: "Failed to fetch purchase" });
  }
});
router20.get("/api/infographics/purchases/:id/download", authenticate2, async (req, res) => {
  try {
    const purchase = await storage.getInfographicPurchase(req.params.id);
    if (!purchase || purchase.userId !== req.user.id) {
      return res.status(404).json({ error: "Purchase not found" });
    }
    if (purchase.status !== "paid") {
      return res.status(400).json({ error: "Purchase not completed" });
    }
    if (!purchase.downloadUrl) {
      return res.status(404).json({ error: "Download not ready" });
    }
    res.redirect(purchase.downloadUrl);
  } catch (error) {
    console.error("[infographics] Download error:", error);
    res.status(500).json({ error: "Failed to process download" });
  }
});
router20.get("/api/me/infographic-purchases", authenticate2, async (req, res) => {
  try {
    const purchases2 = await storage.getUserInfographicPurchases(req.user.id);
    res.json(purchases2);
  } catch (error) {
    console.error("[infographics] User purchases error:", error);
    res.status(500).json({ error: "Failed to fetch purchases" });
  }
});
var infographicTemplates_default = router20;

// server/routes/stripeWebhook.ts
init_storage();
import express11 from "express";
import Stripe7 from "stripe";

// server/services/infographicZipAssembly.ts
init_objectStorage();
init_storage();
import archiver2 from "archiver";
import fetch3 from "node-fetch";
import fs10 from "fs/promises";
import path10 from "path";
var objectStorage = new ObjectStorageService();
var ALLOWED_DOMAINS = [
  "example.com",
  "your-cdn.com",
  "firebasestorage.googleapis.com",
  "storage.googleapis.com",
  "drive.google.com",
  "docs.google.com"
];
var MAX_FILE_SIZE = 50 * 1024 * 1024;
var REQUEST_TIMEOUT = 3e4;
function isUrlAllowed(url) {
  try {
    const urlObj = new URL(url);
    return ALLOWED_DOMAINS.some(
      (domain) => urlObj.hostname === domain || urlObj.hostname.endsWith("." + domain)
    );
  } catch {
    return false;
  }
}
function sanitizeFilename(filename) {
  return filename.replace(/[\/\\:*?"<>|]/g, "_").replace(/^\./g, "_").replace(/\s+/g, "_").substring(0, 100).replace(/_+$/, "") || "untitled";
}
async function createInfographicBundle(purchaseId, selectedIds) {
  const templates = await Promise.all(
    selectedIds.map((id) => storage.getInfographicTemplate(id))
  );
  const validTemplates = templates.filter((t) => t !== null);
  if (validTemplates.length === 0) {
    throw new Error("No valid templates found for bundle creation");
  }
  const tmpDir = `/tmp/infographic-bundle-${purchaseId}`;
  await fs10.mkdir(tmpDir, { recursive: true });
  try {
    const zipPath = path10.join(tmpDir, `infographic-bundle-${purchaseId}.zip`);
    const output = await fs10.open(zipPath, "w");
    const stream = output.createWriteStream();
    const archive = archiver2("zip", {
      zlib: { level: 9 }
      // Maximum compression
    });
    archive.pipe(stream);
    const readmeContent = `Infographic Templates Bundle

Purchase ID: ${purchaseId}
Templates included: ${validTemplates.length}
Date: ${(/* @__PURE__ */ new Date()).toISOString().split("T")[0]}

Templates:
${validTemplates.map((t, i) => `${i + 1}. ${t.title}`).join("\n")}

Files included:
- PowerPoint (.pptx) files when available
- Keynote (.key) files when available  
- Google Slides links in text files when available
- Download bundles (.zip) when available

Compatible with:
- Microsoft PowerPoint
- Apple Keynote
- Google Slides

For support, contact support@ibrandbiz.com
`;
    archive.append(readmeContent, { name: "README.txt" });
    for (let i = 0; i < validTemplates.length; i++) {
      const template = validTemplates[i];
      const folderName = `${i + 1}. ${template.title.replace(/[^a-zA-Z0-9\-_\s]/g, "")}`;
      const templateInfo = `Template: ${template.title}
ID: ${template.id}
Formats available: ${[
        template.pptxUrl ? "PowerPoint (.pptx)" : null,
        template.keynoteUrl ? "Keynote (.key)" : null,
        template.gslidesUrl ? "Google Slides (link)" : null,
        template.downloadBundleUrl ? "Bundle (.zip)" : null
      ].filter(Boolean).join(", ")}
`;
      archive.append(templateInfo, { name: `${folderName}/info.txt` });
      if (template.pptxUrl) {
        try {
          if (!isUrlAllowed(template.pptxUrl)) {
            console.error(`PPTX URL not allowed for template ${template.id}: ${template.pptxUrl}`);
          } else {
            const response = await fetch3(template.pptxUrl, {
              timeout: REQUEST_TIMEOUT,
              size: MAX_FILE_SIZE,
              headers: { "User-Agent": "IBrandBiz-ZipAssembly/1.0" }
            });
            if (response.ok && response.headers.get("content-length")) {
              const contentLength = parseInt(response.headers.get("content-length") || "0");
              if (contentLength > MAX_FILE_SIZE) {
                console.error(`PPTX file too large for template ${template.id}: ${contentLength} bytes`);
              } else {
                const buffer = Buffer.from(await response.arrayBuffer());
                archive.append(buffer, { name: `${folderName}/${sanitizeFilename(template.title)}.pptx` });
              }
            }
          }
        } catch (error) {
          console.error(`Failed to download PPTX for template ${template.id}:`, error);
        }
      }
      if (template.keynoteUrl) {
        try {
          if (!isUrlAllowed(template.keynoteUrl)) {
            console.error(`Keynote URL not allowed for template ${template.id}: ${template.keynoteUrl}`);
          } else {
            const response = await fetch3(template.keynoteUrl, {
              timeout: REQUEST_TIMEOUT,
              size: MAX_FILE_SIZE,
              headers: { "User-Agent": "IBrandBiz-ZipAssembly/1.0" }
            });
            if (response.ok && response.headers.get("content-length")) {
              const contentLength = parseInt(response.headers.get("content-length") || "0");
              if (contentLength > MAX_FILE_SIZE) {
                console.error(`Keynote file too large for template ${template.id}: ${contentLength} bytes`);
              } else {
                const buffer = Buffer.from(await response.arrayBuffer());
                archive.append(buffer, { name: `${folderName}/${sanitizeFilename(template.title)}.key` });
              }
            }
          }
        } catch (error) {
          console.error(`Failed to download Keynote for template ${template.id}:`, error);
        }
      }
      if (template.downloadBundleUrl) {
        try {
          if (!isUrlAllowed(template.downloadBundleUrl)) {
            console.error(`Bundle URL not allowed for template ${template.id}: ${template.downloadBundleUrl}`);
          } else {
            const response = await fetch3(template.downloadBundleUrl, {
              timeout: REQUEST_TIMEOUT,
              size: MAX_FILE_SIZE,
              headers: { "User-Agent": "IBrandBiz-ZipAssembly/1.0" }
            });
            if (response.ok && response.headers.get("content-length")) {
              const contentLength = parseInt(response.headers.get("content-length") || "0");
              if (contentLength > MAX_FILE_SIZE) {
                console.error(`Bundle file too large for template ${template.id}: ${contentLength} bytes`);
              } else {
                const buffer = Buffer.from(await response.arrayBuffer());
                archive.append(buffer, { name: `${folderName}/${sanitizeFilename(template.title)}-bundle.zip` });
              }
            }
          }
        } catch (error) {
          console.error(`Failed to download bundle for template ${template.id}:`, error);
        }
      }
      if (template.gslidesUrl) {
        const linkContent = `Google Slides Template: ${template.title}

Link: ${template.gslidesUrl}

Instructions:
1. Click the link above or copy/paste it into your browser
2. Sign in to your Google account
3. Make a copy of the template to your Google Drive
4. Edit and customize as needed

Note: You'll need a Google account to access Google Slides templates.
`;
        archive.append(linkContent, { name: `${folderName}/${sanitizeFilename(template.title)}-Google-Slides-Link.txt` });
      }
    }
    await new Promise((resolve, reject) => {
      stream.on("close", resolve);
      stream.on("error", reject);
      archive.on("error", reject);
      archive.finalize();
    });
    const zipBuffer = await fs10.readFile(zipPath);
    const storageKey = `infographic-bundles/${purchaseId}/bundle-${Date.now()}.zip`;
    const uploadedUrl = await objectStorage.uploadFile(
      zipBuffer,
      storageKey,
      "application/zip"
    );
    console.log(`[infographic-zip] Created bundle for purchase ${purchaseId}: ${validTemplates.length} templates, ${zipBuffer.length} bytes`);
    return uploadedUrl;
  } finally {
    try {
      await fs10.rm(tmpDir, { recursive: true, force: true });
    } catch (error) {
      console.error(`Failed to clean up temp directory ${tmpDir}:`, error);
    }
  }
}

// server/routes/stripeWebhook.ts
var router21 = express11.Router();
router21.post("/", express11.raw({ type: "application/json" }), async (req, res) => {
  const sig = req.headers["stripe-signature"];
  const whSecret = process.env.STRIPE_WEBHOOK_SECRET;
  let event;
  try {
    const stripe7 = new Stripe7(process.env.STRIPE_SECRET_KEY, { apiVersion: "2024-06-20" });
    event = stripe7.webhooks.constructEvent(req.body, sig, whSecret);
  } catch (err) {
    console.error("[stripe/webhook] Signature verification failed:", err.message);
    return res.status(400).send(`Webhook Error: ${err.message}`);
  }
  try {
    if (event.type === "checkout.session.completed") {
      const session = event.data.object;
      const purchaseType = session.metadata?.type;
      if (purchaseType === "infographic_bundle") {
        const purchaseId = session.metadata?.purchaseId;
        const selectedIds = session.metadata?.selectedIds?.split(",") || [];
        const actualAmountCents = session.amount_total || 0;
        const actualCurrency = session.currency || "usd";
        try {
          const downloadUrl = await createInfographicBundle(purchaseId, selectedIds);
          const updatedPurchase = await storage.updateInfographicPurchase(purchaseId, {
            status: "paid",
            stripePaymentIntent: session.payment_intent,
            downloadUrl,
            actualAmountCents,
            actualCurrency
          });
          console.log(`[stripe/webhook] Infographic bundle purchase ${purchaseId} marked as paid - ${selectedIds.length} items - Amount: ${actualAmountCents} ${actualCurrency} - ZIP created`);
        } catch (error) {
          console.error(`[stripe/webhook] Failed to create ZIP bundle for purchase ${purchaseId}:`, error);
          const updatedPurchase = await storage.updateInfographicPurchase(purchaseId, {
            status: "paid",
            stripePaymentIntent: session.payment_intent,
            downloadUrl: null,
            actualAmountCents,
            actualCurrency
          });
        }
      } else {
        const tplId = session.metadata?.templateId;
        const customImageUrl = session.metadata?.customImageUrl || null;
        const tpl = await storage.getCoverTemplate(tplId);
        const download = tpl?.downloadFile || tpl?.pptxUrl || tpl?.keynoteUrl || tpl?.gslidesUrl || "";
        const actualAmountCents = session.amount_total || 0;
        const actualCurrency = session.currency || "usd";
        const updatedPurchase = await storage.markPurchasePaidBySession(
          session.id,
          session.payment_intent,
          download,
          actualAmountCents,
          actualCurrency
        );
        console.log(`[stripe/webhook] Cover template purchase ${session.metadata?.purchaseId || "unknown"} marked as paid for template ${tplId} - Amount: ${actualAmountCents} ${actualCurrency}`);
      }
    }
  } catch (e) {
    console.error("[stripe/webhook] Error processing webhook:", e);
  }
  res.json({ received: true });
});
var stripeWebhook_default = router21;

// server/index.ts
var app = express13();
app.set("trust proxy", 1);
var corsOrigins = (process.env.CORS_ORIGINS || "").split(",").filter(Boolean);
app.use(cors({
  origin: (origin, callback) => {
    if (!origin) return callback(null, true);
    if (app.get("env") === "development") {
      return callback(null, true);
    }
    if (corsOrigins.length === 0) {
      return callback(null, true);
    }
    callback(null, corsOrigins.includes(origin));
  },
  credentials: true
}));
app.use("/api/stripe/webhook", stripeWebhook_default);
app.use(express13.json());
app.use(express13.urlencoded({ extended: false }));
app.use((req, res, next) => {
  const start = Date.now();
  const path13 = req.path;
  let capturedJsonResponse = void 0;
  const originalResJson = res.json;
  res.json = function(bodyJson, ...args) {
    capturedJsonResponse = bodyJson;
    return originalResJson.apply(res, [bodyJson, ...args]);
  };
  res.on("finish", () => {
    const duration = Date.now() - start;
    if (path13.startsWith("/api")) {
      let logLine = `${req.method} ${path13} ${res.statusCode} in ${duration}ms`;
      if (capturedJsonResponse) {
        logLine += ` :: ${JSON.stringify(capturedJsonResponse)}`;
      }
      if (logLine.length > 80) {
        logLine = logLine.slice(0, 79) + "\u2026";
      }
      const formattedTime = (/* @__PURE__ */ new Date()).toLocaleTimeString("en-US", {
        hour: "numeric",
        minute: "2-digit",
        second: "2-digit",
        hour12: true
      });
      console.log(`${formattedTime} [express] ${logLine}`);
    }
  });
  next();
});
(async () => {
  console.log("[build]", BUILD);
  app.get("/api/firebase-proxy", async (req, res) => {
    try {
      const url = String(req.query.url || "");
      if (!/^https:\/\/(firebasestorage|storage|firestore)\.googleapis\.com\//i.test(url)) return res.status(400).send("blocked");
      const r = await fetch(url);
      if (!r.ok) return res.status(r.status).send(await r.text());
      res.setHeader("Content-Type", r.headers.get("content-type") || "application/octet-stream");
      res.send(await r.text());
    } catch (e) {
      res.status(500).send(e?.message || "proxy error");
    }
  });
  app.get("/business-templates*", (req, res) => {
    const newUrl = req.url.replace("/business-templates", "/business-assets/templates/business-plan");
    res.redirect(301, newUrl);
  });
  const server = await registerRoutes(app);
  app.use(coverTemplates_default);
  app.use(infographicTemplates_default);
  app.all("/api/domains/search", (req, res, next) => {
    if (req.method !== "POST") {
      return res.status(405).json({ error: "Method Not Allowed. Use POST." });
    }
    next();
  });
  app.use("/api", (req, res, next) => {
    res.type("application/json");
    next();
  });
  app.use("/api", (_req, res) => {
    res.status(404).json({ error: "API endpoint not found" });
  });
  app.use((err, _req, res, _next) => {
    const status = err.status || err.statusCode || 500;
    const message = err.message || "Internal Server Error";
    res.status(status).json({ message });
    throw err;
  });
  app.use((_req, res, next) => {
    const originalSend = res.send;
    const originalSendFile = res.sendFile;
    res.send = function(body) {
      if (res.getHeader("Content-Type")?.toString().includes("text/html")) {
        res.set("Cache-Control", "no-store");
        res.set("X-IBrandBiz-Build", `${BUILD.sha}@${BUILD.time}`);
      }
      return originalSend.call(this, body);
    };
    res.sendFile = function(path13, ...args) {
      if (path13?.toString().endsWith("index.html")) {
        res.set("Cache-Control", "no-store");
        res.set("X-IBrandBiz-Build", `${BUILD.sha}@${BUILD.time}`);
      }
      return originalSendFile.call(this, path13, ...args);
    };
    next();
  });
  if (app.get("env") === "development") {
    const { setupVite: setupVite2 } = await init_vite().then(() => vite_exports);
    await setupVite2(app, server);
  } else {
    const { serveStatic: serveStatic2 } = await init_vite().then(() => vite_exports);
    serveStatic2(app);
  }
  const port = parseInt(process.env.PORT || "5000", 10);
  server.listen({
    port,
    host: "0.0.0.0",
    reusePort: true
  }, () => {
    const formattedTime = (/* @__PURE__ */ new Date()).toLocaleTimeString("en-US", {
      hour: "numeric",
      minute: "2-digit",
      second: "2-digit",
      hour12: true
    });
    console.log(`${formattedTime} [express] serving on port ${port}`);
  });
})();
