// Telemetry utility for tracking client-side events

export const tlog = (event: {
  t: string;
  path?: string;
  from?: string;
  meta?: any;
}) =>
  fetch("/api/telemetry", {
    method: "POST",
    headers: { "Content-Type": "application/json" },
    body: JSON.stringify({ ...event, ts: Date.now() }),
  }).catch(() => {
    // Silent fail - don't break app if telemetry is down
  });
