// Slugify utilities for template ID generation following SuperNova's spec
export function slugify(input: string) {
  return input
    .toLowerCase()
    .replace(/['"]/g, "")
    .replace(/[^a-z0-9]+/g, "-")
    .replace(/^-+|-+$/g, "");
}

export function buildTemplateId(name: string, version = 1) {
  return `${slugify(name)}-v${version}`;
}