// src/utils/assetDisplay.ts
export function fileTypeFrom(asset: { mimeType?: string; name?: string }) {
  const t =
    asset.mimeType?.split("/")[1] ||
    (asset.name || "").split(".").pop() ||
    "";
  return t.toUpperCase();
}

// Derive the same 10-digit code if backend hasn't sent asset.code
export async function toTenDigitCode(seed: string): Promise<string> {
  const enc = new TextEncoder().encode(seed);
  const buf = await crypto.subtle.digest("SHA-256", enc);
  const hex = [...new Uint8Array(buf)]
    .map((b) => b.toString(16).padStart(2, "0"))
    .join("");
  const digits = hex.replace(/[a-f]/g, (c) => (parseInt(c, 16) % 10).toString()).slice(0, 10);
  return digits.padEnd(10, "0");
}