import { useEffect, useState } from "react";
import { BPManifestSchema, BPManifest, BPItem } from "./bp-manifest";

type State =
  | { status: "idle" | "loading" }
  | { status: "ready"; manifest: BPManifest; items: BPItem[] }
  | { status: "error"; error: string };

export function useBPManifest(path = "/site/data/manifest.bp.json"): State {
  const [state, setState] = useState<State>({ status: "idle" });

  useEffect(() => {
    let cancelled = false;
    (async () => {
      try {
        setState({ status: "loading" });
        const res = await fetch(path, { cache: "no-cache" });
        if (!res.ok) throw new Error(`HTTP ${res.status}`);
        const json = await res.json();
        const parsed = BPManifestSchema.safeParse(json);
        if (!parsed.success) throw new Error("Manifest validation failed: " + parsed.error.message);
        if (!cancelled) setState({ status: "ready", manifest: parsed.data, items: parsed.data.items });
      } catch (e: any) {
        if (!cancelled) setState({ status: "error", error: e?.message || "Unknown error" });
      }
    })();
    return () => { cancelled = true; };
  }, [path]);

  return state;
}