import { z } from "zod";

export const LogoComposerSchema = z.object({
  id: z.string(),
  name: z.string(),
  previewUrl: z.string().optional(),
  svgUrl: z.string(), // path to an SVG file on disk
  defaultFields: z.record(z.string()),
  fieldOrder: z.array(z.string()).optional(),
  defaultColors: z.object({
    primary: z.string(),
    secondary: z.string(),
    accent: z.string()
  }),
  tags: z.array(z.string()).optional()
});

export const LogoManifestSchema = z.object({
  collection: z.literal("logo"),
  version: z.number(),
  items: z.array(LogoComposerSchema)
});

export type LogoComposerManifest = z.infer<typeof LogoManifestSchema>;
export type LogoComposerItem = z.infer<typeof LogoComposerSchema>;