export type BrandPersonality = "Modern" | "Natural" | "Luxury" | "Friendly";

export interface Palette {
  name: string;
  primary: string;
  secondary: string;
  accent: string;
  neutral: string;
  surface: string;
  textPrimary: string;
  textOnPrimary: string;
  shades?: Record<string, string>;
}

export interface FontPair {
  heading: string; // e.g., "Barlow Condensed"
  body: string;    // e.g., "Inter"
  note?: string;   // why this pair
}

export interface LogoVariant {
  filename: string;   // e.g., "logo-primary.svg"
  svg: string;        // raw svg markup
}

export interface BrandKit {
  id?: string;
  userId?: string;
  businessName: string;
  industry?: string;
  personality: BrandPersonality;
  palette: Palette;
  fonts: FontPair;
  logos: LogoVariant[];
  createdAt?: number;
}