import { create } from "zustand";

type SurveyState = {
  open: boolean;
  surveyId: string | null;
  title: string;
  description?: string;
  options: { id: string; label: string }[];
  context: { userId?: string | null; planId?: string | null };
  set: (s: Partial<SurveyState>) => void;
  reset: () => void;
};

export const useSurveyStore = create<SurveyState>((set) => ({
  open: false,
  surveyId: null,
  title: "",
  description: undefined,
  options: [],
  context: {},
  set: (s) => set(s),
  reset: () =>
    set({
      open: false,
      surveyId: null,
      title: "",
      description: undefined,
      options: [],
      context: {},
    }),
}));