import { assembleMarkdownDoc } from "./assemblePlan";
import { useBrandKitStore } from "../../stores/useBrandKitStore";
import { exportPlanPdfBrandAware } from "../ai/planExportPdf";
import { exportPlanDocxBrandAware } from "../ai/planExportDocx";

export async function exportFullPlanPDF(opts: Parameters<typeof assembleMarkdownDoc>[0]){
  const brand = useBrandKitStore.getState().getCurrentKit();
  const doc = assembleMarkdownDoc(opts, brand || undefined);
  const filename = slugify(opts.title || "Business Plan") + ".pdf";
  await exportPlanPdfBrandAware(doc, filename);
  return { filename, meta: doc.meta };
}

export async function exportFullPlanDOCX(opts: Parameters<typeof assembleMarkdownDoc>[0]){
  const brand = useBrandKitStore.getState().getCurrentKit();
  const doc = assembleMarkdownDoc(opts, brand || undefined);
  const filename = slugify(opts.title || "Business Plan") + ".docx";
  await exportPlanDocxBrandAware(doc, filename);
  return { filename, meta: doc.meta };
}

function slugify(s: string){
  return (s||"").toLowerCase().replace(/[^a-z0-9]+/g, "-").replace(/(^-|-$)/g, "").slice(0,80);
}