// src/services/export/embedFonts.ts
import jsPDF from "jspdf";

/**
 * Register base64-encoded TTFs with jsPDF.
 * Add as many families/weights as you need.
 */
export function registerEmbeddedFonts(doc: jsPDF) {
  // ---- Inter Regular (400) ----
  // Replace the string with your real base64 (no data: prefix).
  // See the small Node script below to generate it.
  const INTER_REGULAR_BASE64 = "<<<BASE64_TTF_INTER_REGULAR>>>";

  // ---- Inter Bold (700) ----
  const INTER_BOLD_BASE64 = "<<<BASE64_TTF_INTER_BOLD>>>";

  // ---- Manrope Regular (400) ----
  const MANROPE_REGULAR_BASE64 = "<<<BASE64_TTF_MANROPE_REGULAR>>>";

  // ---- Manrope Bold (700) ----
  const MANROPE_BOLD_BASE64 = "<<<BASE64_TTF_MANROPE_BOLD>>>";

  // Register Inter
  if (INTER_REGULAR_BASE64 !== "<<<BASE64_TTF_INTER_REGULAR>>>") {
    doc.addFileToVFS("Inter-Regular.ttf", INTER_REGULAR_BASE64);
    doc.addFont("Inter-Regular.ttf", "Inter", "normal");
  }
  if (INTER_BOLD_BASE64 !== "<<<BASE64_TTF_INTER_BOLD>>>") {
    doc.addFileToVFS("Inter-Bold.ttf", INTER_BOLD_BASE64);
    doc.addFont("Inter-Bold.ttf", "Inter", "bold");
  }

  // Register Manrope
  if (MANROPE_REGULAR_BASE64 !== "<<<BASE64_TTF_MANROPE_REGULAR>>>") {
    doc.addFileToVFS("Manrope-Regular.ttf", MANROPE_REGULAR_BASE64);
    doc.addFont("Manrope-Regular.ttf", "Manrope", "normal");
  }
  if (MANROPE_BOLD_BASE64 !== "<<<BASE64_TTF_MANROPE_BOLD>>>") {
    doc.addFileToVFS("Manrope-Bold.ttf", MANROPE_BOLD_BASE64);
    doc.addFont("Manrope-Bold.ttf", "Manrope", "bold");
  }
}

/**
 * Pick a PDF-safe font name from your UI fontFamily string.
 * Falls back to Helvetica if the custom family wasn't embedded.
 */
export function pdfFontFor(uiFontFamily: string): { name: string; weight: "normal" | "bold" } {
  const first = uiFontFamily.replace(/["']/g, "").split(",")[0].trim();
  const fam = /inter/i.test(first) ? "Inter"
           : /manrope/i.test(first) ? "Manrope"
           : "helvetica";
  return { name: fam, weight: "bold" };
}