import { buildExportStyles } from "../../lib/exportStyles";
import { useBrandKitStore } from "../../stores/useBrandKitStore";

export async function exportPlanPdfBrandAware(plan: any, filename: string){
  const brand = useBrandKitStore.getState().getCurrentKit();
  const styles = buildExportStyles(brand || {} as any);

  // pseudo-code depending on your PDF engine:
  // markdownToPdf(plan.markdown, { styles })

  console.log("PDF export (brand-aware)", { filename, styles });
}