import { buildExportStyles } from "../../lib/exportStyles";
import { useBrandKitStore } from "../../stores/useBrandKitStore";

export async function exportPlanDocxBrandAware(plan: any, filename: string){
  const brand = useBrandKitStore.getState().getCurrentKit();
  const styles = buildExportStyles(brand || {} as any);

  // pseudo-code depending on your DOCX engine:
  // markdownToDocx(plan.markdown, { styles })

  console.log("DOCX export (brand-aware)", { filename, styles });
}