import { apiRequest } from "@/lib/queryClient";

export type StylePack = "balanced" | "monogram" | "badge";
export type VariantType = "geometric" | "monogram" | "badge";
export type MarkMode = "auto" | "icon" | "wordmark";

export async function generateAiLogos(payload: {
  businessName: string;
  personality: "Modern" | "Natural" | "Luxury" | "Friendly";
  palette?: { primary: string; secondary: string; accent: string };
  keywords?: string[];
  stylePack?: StylePack;
  variantType?: VariantType; // when rerolling a single card
  markMode?: MarkMode;                   // <-- NEW
}) {
  const data = await apiRequest("POST", "/api/logos/generate", payload) as { variants: { filename: string; svg: string }[] };
  return data.variants;
}