import React from "react";
import TemplatePage from "@/components/TemplatePage";
import { Button } from "@/components/ui/button";
import priceImage from "@/assets/price.png";
import { Link } from "wouter";

export default function WebServicesPricing() {
  const Check = (props: React.SVGProps<SVGSVGElement>) => (
    <svg
      viewBox="0 0 24 24"
      fill="none"
      aria-hidden="true"
      {...props}
      className={"w-5 h-5 " + (props.className ?? "")}
    >
      <path d="M20 6L9 17l-5-5" stroke="currentColor" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round" />
    </svg>
  );

  return (
    <TemplatePage 
      bannerTitle="Web Services Pricing" 
      bannerSubtitle="Professional web development and hosting solutions"
      bannerImage={priceImage}
      flipImage={true}
    >
      <div className="w-full">
        <div className="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
          
          {/* Web Hosting */}
          <div className="mb-12">
            <h2 className="text-2xl font-bold text-center mb-8">Web Hosting</h2>
            <div className="grid gap-8 md:grid-cols-3">
              
              {/* Starter */}
              <div className="rounded-xl border bg-white shadow-sm p-6 flex flex-col">
                <h3 className="text-xl font-bold text-center mb-4">Starter</h3>
                
                <div className="text-center mb-4">
                  <div className="flex justify-center items-baseline gap-2 mb-2">
                    <span className="text-2xl font-extrabold text-primary">$2.19</span>
                    <span className="text-gray-600">/month</span>
                  </div>
                  <div className="text-sm text-gray-500">
                    $24.99 /year
                  </div>
                </div>

                <p className="text-center text-gray-600 mb-6">
                  Perfect for single-site projects & personal sites
                </p>

                <ul className="space-y-3 mb-6 flex-grow">
                  <li className="flex items-start gap-2">
                    <Check className="text-green-500 mt-0.5" />
                    <span>1 Website</span>
                  </li>
                  <li className="flex items-start gap-2">
                    <Check className="text-green-500 mt-0.5" />
                    <span>10 GB SSD Storage</span>
                  </li>
                  <li className="flex items-start gap-2">
                    <Check className="text-green-500 mt-0.5" />
                    <span>Free SSL Certificate (Let's Encrypt)</span>
                  </li>
                  <li className="flex items-start gap-2">
                    <Check className="text-green-500 mt-0.5" />
                    <span>cPanel & One-Click App Installer</span>
                  </li>
                  <li className="flex items-start gap-2">
                    <Check className="text-green-500 mt-0.5" />
                    <span>5 Email Accounts & 5 Databases</span>
                  </li>
                  <li className="flex items-start gap-2">
                    <Check className="text-green-500 mt-0.5" />
                    <span>Basic Backups (7-day) & Standard Support</span>
                  </li>
                </ul>

                <p className="text-xs text-gray-500 mb-4 text-center">
                  Affordable starter hosting with SSD, free SSL, and easy management for personal sites and portfolios.
                </p>

                <a
                  href="https://billing.ibrandbiz.com/index.php?rp=/store/web-hosting/starter-pro-or-business"
                  target="_blank"
                  rel="noopener noreferrer"
                  className="block text-center bg-primary hover:bg-primary/90 text-white py-2 px-4 rounded-lg font-medium"
                >
                  Get Started — Starter
                </a>
              </div>

              {/* Professional */}
              <div className="rounded-xl border-2 border-primary bg-white shadow-lg p-6 flex flex-col relative">
                {/* Badge */}
                <div className="absolute -top-3 inset-x-0 flex justify-center">
                  <div className="px-3 py-1 rounded-full bg-primary text-white text-sm font-semibold shadow">
                    ★ Recommended
                  </div>
                </div>
                
                <h3 className="text-xl font-bold text-center mb-4 mt-2">Professional</h3>
                
                <div className="text-center mb-4">
                  <div className="flex justify-center items-baseline gap-2 mb-2">
                    <span className="text-2xl font-extrabold text-primary">$5.99</span>
                    <span className="text-gray-600">/month</span>
                  </div>
                  <div className="text-sm text-gray-500">
                    $59.99 /year
                  </div>
                </div>

                <p className="text-center text-gray-600 mb-6">
                  Everything you need for a professional online presence
                </p>

                <ul className="space-y-3 mb-6 flex-grow">
                  <li className="flex items-start gap-2">
                    <Check className="text-green-500 mt-0.5" />
                    <span>Up to 5 Websites</span>
                  </li>
                  <li className="flex items-start gap-2">
                    <Check className="text-green-500 mt-0.5" />
                    <span>50 GB SSD Storage</span>
                  </li>
                  <li className="flex items-start gap-2">
                    <Check className="text-green-500 mt-0.5" />
                    <span>Daily Backups</span>
                  </li>
                  <li className="flex items-start gap-2">
                    <Check className="text-green-500 mt-0.5" />
                    <span>Free Domain (1st year)</span>
                  </li>
                  <li className="flex items-start gap-2">
                    <Check className="text-green-500 mt-0.5" />
                    <span>Priority Support & Staging Tools</span>
                  </li>
                  <li className="flex items-start gap-2">
                    <Check className="text-green-500 mt-0.5" />
                    <span>25 Email Accounts, 25 Databases</span>
                  </li>
                </ul>

                <p className="text-xs text-gray-500 mb-4 text-center">
                  Scalable performance for growing businesses — more storage, backups, and premium support.
                </p>

                <a
                  href="https://billing.ibrandbiz.com/index.php?rp=/store/web-hosting/pro-plan"
                  target="_blank"
                  rel="noopener noreferrer"
                  className="block text-center bg-primary hover:bg-primary/90 text-white py-2 px-4 rounded-lg font-medium"
                >
                  Choose Professional
                </a>
              </div>

              {/* Business */}
              <div className="rounded-xl border bg-white shadow-sm p-6 flex flex-col">
                <h3 className="text-xl font-bold text-center mb-4">Business</h3>
                
                <div className="text-center mb-4">
                  <div className="flex justify-center items-baseline gap-2 mb-2">
                    <span className="text-2xl font-extrabold text-primary">$11.99</span>
                    <span className="text-gray-600">/month</span>
                  </div>
                  <div className="text-sm text-gray-500">
                    $119.99 /year
                  </div>
                </div>

                <p className="text-center text-gray-600 mb-6">
                  Advanced features for growing & mission-critical businesses
                </p>

                <ul className="space-y-3 mb-6 flex-grow">
                  <li className="flex items-start gap-2">
                    <Check className="text-green-500 mt-0.5" />
                    <span>Unlimited Websites</span>
                  </li>
                  <li className="flex items-start gap-2">
                    <Check className="text-green-500 mt-0.5" />
                    <span>200 GB SSD Storage</span>
                  </li>
                  <li className="flex items-start gap-2">
                    <Check className="text-green-500 mt-0.5" />
                    <span>Dedicated Resources & Performance Boosts</span>
                  </li>
                  <li className="flex items-start gap-2">
                    <Check className="text-green-500 mt-0.5" />
                    <span>Dedicated IP & Advanced Security</span>
                  </li>
                  <li className="flex items-start gap-2">
                    <Check className="text-green-500 mt-0.5" />
                    <span>Priority Managed Support & SLA options</span>
                  </li>
                  <li className="flex items-start gap-2">
                    <Check className="text-green-500 mt-0.5" />
                    <span>Free Migration & Advanced Backups</span>
                  </li>
                </ul>

                <p className="text-xs text-gray-500 mb-4 text-center">
                  Powerful hosting for high-traffic sites with premium performance and dedicated support.
                </p>

                <a
                  href="https://billing.ibrandbiz.com/index.php?rp=/store/web-hosting/business-plan"
                  target="_blank"
                  rel="noopener noreferrer"
                  className="block text-center bg-primary hover:bg-primary/90 text-white py-2 px-4 rounded-lg font-medium"
                >
                  Go Business — Get More
                </a>
              </div>
            </div>
          </div>

          {/* Add-On Services Teaser */}
          <div className="mb-12">
            <div className="bg-gradient-to-r from-primary/5 to-primary/10 rounded-2xl p-8 text-center">
              <p className="text-sm text-muted-foreground">
                Want to customize your hosting? <Link href="/pricing/addons" className="underline text-primary hover:text-primary/80">Explore powerful add-ons</Link> to upgrade your performance, security, and support.
              </p>
            </div>
          </div>

          {/* Domain Services */}
          <div className="mb-12">
            <h2 className="text-2xl font-bold text-center mb-8">Domain Services</h2>
            <div className="grid gap-6 md:grid-cols-2">
              
              {/* Domain Registration */}
              <div className="bg-white rounded-xl border shadow-sm p-6">
                <h3 className="text-xl font-bold mb-4">Domain Registration</h3>
                <p className="text-gray-600 mb-6">
                  Secure your perfect domain name with competitive pricing
                </p>
                
                <div className="grid grid-cols-2 gap-4 mb-6">
                  <div className="text-center p-3 bg-gray-50 rounded-lg">
                    <div className="font-bold text-lg">.com</div>
                    <div className="text-primary font-semibold">$11.99/year</div>
                  </div>
                  <div className="text-center p-3 bg-gray-50 rounded-lg">
                    <div className="font-bold text-lg">.net</div>
                    <div className="text-primary font-semibold">$11.99/year</div>
                  </div>
                  <div className="text-center p-3 bg-gray-50 rounded-lg">
                    <div className="font-bold text-lg">.org</div>
                    <div className="text-primary font-semibold">$14.99/year</div>
                  </div>
                  <div className="text-center p-3 bg-gray-50 rounded-lg">
                    <div className="font-bold text-lg">.io</div>
                    <div className="text-primary font-semibold">$49.99/year</div>
                  </div>
                </div>
                
                <Link href="/web-services/domains">
                  <Button className="w-full bg-primary hover:bg-primary/90 text-white">
                    Search Domains
                  </Button>
                </Link>
              </div>

              {/* Domain Management */}
              <div className="bg-white rounded-xl border shadow-sm p-6">
                <h3 className="text-xl font-bold mb-4">Domain Management</h3>
                <p className="text-gray-600 mb-6">
                  Professional domain management and DNS services
                </p>
                
                <ul className="space-y-3 mb-6">
                  <li className="flex items-start gap-2">
                    <Check className="text-green-500 mt-0.5" />
                    <span>DNS management</span>
                  </li>
                  <li className="flex items-start gap-2">
                    <Check className="text-green-500 mt-0.5" />
                    <span>Email forwarding</span>
                  </li>
                  <li className="flex items-start gap-2">
                    <Check className="text-green-500 mt-0.5" />
                    <span>Domain forwarding</span>
                  </li>
                  <li className="flex items-start gap-2">
                    <Check className="text-green-500 mt-0.5" />
                    <span>Privacy protection</span>
                  </li>
                  <li className="flex items-start gap-2">
                    <Check className="text-green-500 mt-0.5" />
                    <span>Auto-renewal</span>
                  </li>
                </ul>
                
                <Button className="w-full bg-primary hover:bg-primary/90 text-white">
                  Learn More
                </Button>
              </div>
            </div>
          </div>
        </div>
      </div>
    </TemplatePage>
  );
}