import { useEffect } from "react";
import TemplatePage from "@/components/TemplatePage";
import { Card, CardContent } from "@/components/ui/card";
import { AlertCircle } from "lucide-react";

export default function NotFound() {
  useEffect(() => {
    console.warn('[404]', window.location.pathname);
    window.dispatchEvent(new CustomEvent('spa-404', { detail: window.location.pathname }));
  }, []);

  return (
    <TemplatePage
      bannerTitle="404 - Page Not Found"
      bannerSubtitle="The page you're looking for doesn't exist or has been moved."
    >
      <div className="w-full flex items-center justify-center py-16" data-not-found>
        <Card className="w-full max-w-md mx-4">
          <CardContent className="pt-6 text-center">
            <AlertCircle className="h-12 w-12 text-red-500 mx-auto mb-4" />
            <p className="text-gray-600 mb-4">
              Let's get you back on track.
            </p>
            <a 
              href="/" 
              className="inline-block bg-primary text-white px-6 py-2 rounded-lg hover:bg-primary/90 transition-colors"
              data-testid="button-home"
            >
              Go Home
            </a>
          </CardContent>
        </Card>
      </div>
    </TemplatePage>
  );
}