import { DashboardTemplatePage } from "@/components/DashboardTemplatePage";
import { LogoAIGenerator } from "@/components/logo/LogoAIGenerator";
import { Breadcrumb, BreadcrumbList, BreadcrumbItem, BreadcrumbLink, BreadcrumbPage, BreadcrumbSeparator } from "@/components/ui/breadcrumb";
import { ChevronRight } from "lucide-react";
import { useLocation } from "wouter";
import { withPro } from "@/lib/withPro";

function AILogoCreatorPage() {
  const [, navigate] = useLocation();
  
  const handleAiLogoGenerated = (svg: string) => {
    const draftId = `draft-${crypto?.randomUUID?.() || Date.now()}`;
    sessionStorage.setItem(`logoDraft:${draftId}`, JSON.stringify({ svg }));
    navigate(`/brand-development/ai-logo-creator/logo-composer-${draftId}`);
  };

  return (
    <DashboardTemplatePage title="AI Logo Creator">
      {/* Breadcrumbs */}
      <Breadcrumb className="mb-[16px] -mt-1">
        <BreadcrumbList>
          <BreadcrumbItem>
            <BreadcrumbLink href="/dashboard" className="text-[#FF8B00] hover:text-[#e67d00]">Dashboard</BreadcrumbLink>
          </BreadcrumbItem>
          <BreadcrumbSeparator>
            <ChevronRight className="h-4 w-4 text-[#FF8B00]" />
          </BreadcrumbSeparator>
          <BreadcrumbItem>
            <BreadcrumbLink className="text-[#FF8B00] hover:text-[#e67d00]">Business Development</BreadcrumbLink>
          </BreadcrumbItem>
          <BreadcrumbSeparator>
            <ChevronRight className="h-4 w-4 text-[#FF8B00]" />
          </BreadcrumbSeparator>
          <BreadcrumbItem>
            <BreadcrumbPage className="text-[#FF8B00] font-semibold">AI Logo Creator</BreadcrumbPage>
          </BreadcrumbItem>
        </BreadcrumbList>
      </Breadcrumb>

      <div className="space-y-6">
        {/* Step 1 Header */}
        <div>
          <h2 className="text-xl font-semibold mb-2 text-gray-900 dark:text-gray-100">Step 1: Generate a Logo</h2>
          <p className="text-sm text-gray-600 dark:text-gray-400">
            Describe your vision and AI will create your logo. When you're happy with it, continue to customize.
          </p>
        </div>

        {/* AI Logo Generator Section */}
        <div className="p-6 rounded-lg border" style={{ backgroundColor: '#c9ddf9', borderColor: '#a5c9f5' }}>
          <h3 className="text-lg font-semibold mb-1 text-gray-900 dark:text-gray-100">Generate Custom Logo with AI</h3>
          <p className="text-xs text-gray-600 dark:text-gray-400 italic mb-3">
            Creates an icon-only SVG — text is added in the Composer.
          </p>
          <p className="text-sm text-gray-600 dark:text-gray-400 mb-4">
            Create a unique SVG logo using AI. Describe your vision and get a professional icon-only logo instantly.
          </p>
          <LogoAIGenerator
            onInsert={handleAiLogoGenerated}
            onReplace={handleAiLogoGenerated}
            hasExistingIcon={false}
            defaultOpen={true}
          />
        </div>
      </div>
    </DashboardTemplatePage>
  );
}

export default withPro(AILogoCreatorPage, {
  feature: "AI logo generation",
  description: "Generate custom logos with AI technology"
});