import React from "react";
import { DashboardTemplatePage } from "@/components/DashboardTemplatePage";
import { Breadcrumb, BreadcrumbList, BreadcrumbItem, BreadcrumbLink, BreadcrumbPage, BreadcrumbSeparator } from "@/components/ui/breadcrumb";
import { ChevronRight } from "lucide-react";

export default function WebHosting() {
  const Check = (props: React.SVGProps<SVGSVGElement>) => (
    <svg
      viewBox="0 0 24 24"
      fill="none"
      aria-hidden="true"
      {...props}
      className={"w-5 h-5 " + (props.className ?? "")}
    >
      <path d="M20 6L9 17l-5-5" stroke="currentColor" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round" />
    </svg>
  );

  return (
    <DashboardTemplatePage title="Web Hosting">
      {/* Breadcrumbs */}
      <Breadcrumb className="mb-[16px] -mt-1">
        <BreadcrumbList>
          <BreadcrumbItem>
            <BreadcrumbLink href="/dashboard" className="text-[#FF8B00] hover:text-[#e67d00]">Dashboard</BreadcrumbLink>
          </BreadcrumbItem>
          <BreadcrumbSeparator>
            <ChevronRight className="h-4 w-4 text-[#FF8B00]" />
          </BreadcrumbSeparator>
          <BreadcrumbItem>
            <BreadcrumbLink className="text-[#FF8B00] hover:text-[#e67d00]">Web Services</BreadcrumbLink>
          </BreadcrumbItem>
          <BreadcrumbSeparator>
            <ChevronRight className="h-4 w-4 text-[#FF8B00]" />
          </BreadcrumbSeparator>
          <BreadcrumbItem>
            <BreadcrumbPage className="text-[#FF8B00] font-semibold">Web Hosting</BreadcrumbPage>
          </BreadcrumbItem>
        </BreadcrumbList>
      </Breadcrumb>

      <div className="space-y-6">
        {/* Header */}
        <div className="text-center space-y-2">
          <h2 className="text-3xl font-bold">Web Hosting Services</h2>
          <p className="text-muted-foreground">
            Reliable, fast, and secure hosting solutions for your website and applications.
          </p>
        </div>

        {/* Website Templates & Hosting */}
        <div className="mb-12">
          <h2 className="text-2xl font-bold text-center mb-8">Website Templates & Hosting</h2>
          <div className="grid gap-8 md:grid-cols-3">
            
            {/* Starter */}
            <div className="rounded-xl border bg-white shadow-sm p-6 flex flex-col">
              <h3 className="text-xl font-bold text-center mb-4">Starter</h3>
              
              <div className="text-center mb-4">
                <div className="flex justify-center items-baseline gap-2 mb-2">
                  <span className="text-2xl font-extrabold text-primary">$2.19</span>
                  <span className="text-gray-600">/month</span>
                </div>
                <div className="text-sm text-gray-500">
                  $24.99 /year
                </div>
              </div>

              <p className="text-center text-gray-600 mb-6">
                Perfect for single-site projects & personal sites
              </p>

              <ul className="space-y-3 mb-6 flex-grow">
                <li className="flex items-start gap-2">
                  <Check className="text-green-500 mt-0.5" />
                  <span>1 Website</span>
                </li>
                <li className="flex items-start gap-2">
                  <Check className="text-green-500 mt-0.5" />
                  <span>10 GB SSD Storage</span>
                </li>
                <li className="flex items-start gap-2">
                  <Check className="text-green-500 mt-0.5" />
                  <span>Free SSL Certificate (Let's Encrypt)</span>
                </li>
                <li className="flex items-start gap-2">
                  <Check className="text-green-500 mt-0.5" />
                  <span>cPanel & One-Click App Installer</span>
                </li>
                <li className="flex items-start gap-2">
                  <Check className="text-green-500 mt-0.5" />
                  <span>5 Email Accounts & 5 Databases</span>
                </li>
                <li className="flex items-start gap-2">
                  <Check className="text-green-500 mt-0.5" />
                  <span>Basic Backups (7-day) & Standard Support</span>
                </li>
              </ul>

              <p className="text-xs text-gray-500 mb-4 text-center">
                Affordable starter hosting with SSD, free SSL, and easy management for personal sites and portfolios.
              </p>

              <a
                href="https://billing.ibrandbiz.com/index.php?rp=/store/web-hosting/starter-pro-or-business"
                target="_blank"
                rel="noopener noreferrer"
                className="block text-center bg-primary hover:bg-primary/90 text-white py-2 px-4 rounded-lg font-medium"
              >
                Get Started — Starter
              </a>
            </div>

            {/* Professional */}
            <div className="rounded-xl border-2 border-primary bg-white shadow-lg p-6 flex flex-col relative">
              {/* Badge */}
              <div className="absolute -top-3 inset-x-0 flex justify-center">
                <div className="px-3 py-1 rounded-full bg-primary text-white text-sm font-semibold shadow">
                  ★ Recommended
                </div>
              </div>
              
              <h3 className="text-xl font-bold text-center mb-4 mt-2">Professional</h3>
              
              <div className="text-center mb-4">
                <div className="flex justify-center items-baseline gap-2 mb-2">
                  <span className="text-2xl font-extrabold text-primary">$5.99</span>
                  <span className="text-gray-600">/month</span>
                </div>
                <div className="text-sm text-gray-500">
                  $59.99 /year
                </div>
              </div>

              <p className="text-center text-gray-600 mb-6">
                Everything you need for a professional online presence
              </p>

              <ul className="space-y-3 mb-6 flex-grow">
                <li className="flex items-start gap-2">
                  <Check className="text-green-500 mt-0.5" />
                  <span>Up to 5 Websites</span>
                </li>
                <li className="flex items-start gap-2">
                  <Check className="text-green-500 mt-0.5" />
                  <span>50 GB SSD Storage</span>
                </li>
                <li className="flex items-start gap-2">
                  <Check className="text-green-500 mt-0.5" />
                  <span>Daily Backups</span>
                </li>
                <li className="flex items-start gap-2">
                  <Check className="text-green-500 mt-0.5" />
                  <span>Free Domain (1st year)</span>
                </li>
                <li className="flex items-start gap-2">
                  <Check className="text-green-500 mt-0.5" />
                  <span>Priority Support & Staging Tools</span>
                </li>
                <li className="flex items-start gap-2">
                  <Check className="text-green-500 mt-0.5" />
                  <span>25 Email Accounts, 25 Databases</span>
                </li>
              </ul>

              <p className="text-xs text-gray-500 mb-4 text-center">
                Scalable performance for growing businesses — more storage, backups, and premium support.
              </p>

              <a
                href="https://billing.ibrandbiz.com/index.php?rp=/store/web-hosting/pro-plan"
                target="_blank"
                rel="noopener noreferrer"
                className="block text-center bg-primary hover:bg-primary/90 text-white py-2 px-4 rounded-lg font-medium"
              >
                Choose Professional
              </a>
            </div>

            {/* Business */}
            <div className="rounded-xl border bg-white shadow-sm p-6 flex flex-col">
              <h3 className="text-xl font-bold text-center mb-4">Business</h3>
              
              <div className="text-center mb-4">
                <div className="flex justify-center items-baseline gap-2 mb-2">
                  <span className="text-2xl font-extrabold text-primary">$11.99</span>
                  <span className="text-gray-600">/month</span>
                </div>
                <div className="text-sm text-gray-500">
                  $119.99 /year
                </div>
              </div>

              <p className="text-center text-gray-600 mb-6">
                Advanced features for growing & mission-critical businesses
              </p>

              <ul className="space-y-3 mb-6 flex-grow">
                <li className="flex items-start gap-2">
                  <Check className="text-green-500 mt-0.5" />
                  <span>Unlimited Websites</span>
                </li>
                <li className="flex items-start gap-2">
                  <Check className="text-green-500 mt-0.5" />
                  <span>200 GB SSD Storage</span>
                </li>
                <li className="flex items-start gap-2">
                  <Check className="text-green-500 mt-0.5" />
                  <span>Dedicated Resources & Performance Boosts</span>
                </li>
                <li className="flex items-start gap-2">
                  <Check className="text-green-500 mt-0.5" />
                  <span>Dedicated IP & Advanced Security</span>
                </li>
                <li className="flex items-start gap-2">
                  <Check className="text-green-500 mt-0.5" />
                  <span>Priority Managed Support & SLA options</span>
                </li>
                <li className="flex items-start gap-2">
                  <Check className="text-green-500 mt-0.5" />
                  <span>Free Migration & Advanced Backups</span>
                </li>
              </ul>

              <p className="text-xs text-gray-500 mb-4 text-center">
                Powerful hosting for high-traffic sites with premium performance and dedicated support.
              </p>

              <a
                href="https://billing.ibrandbiz.com/index.php?rp=/store/web-hosting/business-plan"
                target="_blank"
                rel="noopener noreferrer"
                className="block text-center bg-primary hover:bg-primary/90 text-white py-2 px-4 rounded-lg font-medium"
              >
                Go Business — Get More
              </a>
            </div>
          </div>
        </div>
      </div>
    </DashboardTemplatePage>
  );
}