import TemplatePage from "@/components/TemplatePage";
import { privacyImage } from "@/assets";

export default function Terms() {
  return (
    <TemplatePage
      bannerTitle="Terms and Conditions"
      bannerSubtitle="Please read these terms carefully before using our services."
      bannerImage={privacyImage}
    >
      <main className="py-16">
        <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="prose prose-lg max-w-none">
            <p className="text-sm text-gray-600 dark:text-gray-400 mb-8">
              The Terms and Conditions were last updated on March 5, 2024
            </p>

            <section className="mb-8">
              <h2 className="text-2xl font-bold text-gray-900 dark:text-white mb-4">1. Introduction</h2>
              <p className="text-gray-700 dark:text-gray-300 mb-4">
                These Terms and conditions apply to this website and to the transactions related to our products and services. You may be bound by additional contracts related to your relationship with us or any products or services that you receive from us. If any provisions of the additional contracts conflict with any provisions of these Terms, the provisions of these additional contracts will control and prevail.
              </p>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-bold text-gray-900 dark:text-white mb-4">2. Binding</h2>
              <p className="text-gray-700 dark:text-gray-300 mb-4">
                By registering with, accessing, or otherwise using this website, you hereby agree to be bound by these Terms and conditions set forth below. The mere use of this website implies the knowledge and acceptance of these Terms and conditions. In some particular cases, we can also ask you to explicitly agree.
              </p>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-bold text-gray-900 dark:text-white mb-4">3. Electronic communication</h2>
              <p className="text-gray-700 dark:text-gray-300 mb-4">
                By using this website or communicating with us by electronic means, you agree and acknowledge that we may communicate with you electronically on our website or by sending an email to you, and you agree that all agreements, notices, disclosures, and other communications that we provide to you electronically satisfy any legal requirement, including but not limited to the requirement that such communications should be in writing.
              </p>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-bold text-gray-900 dark:text-white mb-4">4. Intellectual property</h2>
              <p className="text-gray-700 dark:text-gray-300 mb-4">
                We or our licensors own and control all of the copyright and other intellectual property rights in the website and the data, information, and other resources displayed by or accessible within the website.
              </p>
              <h3 className="text-xl font-semibold text-gray-900 dark:text-white mb-3">4.1 All the rights are reserved</h3>
              <p className="text-gray-700 dark:text-gray-300 mb-4">
                Unless specific content dictates otherwise, you are not granted a license or any other right under Copyright, Trademark, Patent, or other Intellectual Property Rights. This means that you will not use, copy, reproduce, perform, display, distribute, embed into any electronic medium, alter, reverse engineer, decompile, transfer, download, transmit, monetize, sell, market, or commercialize any resources on this website in any form, without our prior written permission, except and only insofar as otherwise stipulated in regulations of mandatory law (such as the right to quote).
              </p>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-bold text-gray-900 dark:text-white mb-4">5. Third-party property</h2>
              <p className="text-gray-700 dark:text-gray-300 mb-4">
                Our website may include hyperlinks or other references to other party's websites. We do not monitor or review the content of other party's websites which are linked to from this website. Products or services offered by other websites shall be subject to the applicable Terms and Conditions of those third parties. Opinions expressed or material appearing on those websites are not necessarily shared or endorsed by us.
              </p>
              <p className="text-gray-700 dark:text-gray-300 mb-4">
                We will not be responsible for any privacy practices or content of these sites. You bear all risks associated with the use of these websites and any related third-party services. We will not accept any responsibility for any loss or damage in whatever manner, however caused, resulting from your disclosure to third parties of personal information.
              </p>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-bold text-gray-900 dark:text-white mb-4">6. Responsible use</h2>
              <p className="text-gray-700 dark:text-gray-300 mb-4">
                By visiting our website, you agree to use it only for the purposes intended and as permitted by these Terms, any additional contracts with us, and applicable laws, regulations, and generally accepted online practices and industry guidelines. You must not use our website or services to use, publish or distribute any material which consists of (or is linked to) malicious computer software; use data collected from our website for any direct marketing activity, or conduct any systematic or automated data collection activities on or in relation to our website.
              </p>
              <p className="text-gray-700 dark:text-gray-300 mb-4">
                Engaging in any activity that causes, or may cause, damage to the website or that interferes with the performance, availability, or accessibility of the website is strictly prohibited.
              </p>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-bold text-gray-900 dark:text-white mb-4">7. Registration</h2>
              <p className="text-gray-700 dark:text-gray-300 mb-4">
                You may register for an account with our website. During this process, you may be required to choose a password. You are responsible for maintaining the confidentiality of passwords and account information and agree not to share your passwords, account information, or secured access to our website or services with any other person. You must not allow any other person to use your account to access the website because you are responsible for all activities that occur through the use of your passwords or accounts. You must notify us immediately if you become aware of any disclosure of your password.
              </p>
              <p className="text-gray-700 dark:text-gray-300 mb-4">
                After account termination, you will not attempt to register a new account without our permission.
              </p>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-bold text-gray-900 dark:text-white mb-4">8. Refund and Return policy</h2>
              <h3 className="text-xl font-semibold text-gray-900 dark:text-white mb-3">8.1 Right of withdrawal</h3>
              <p className="text-gray-700 dark:text-gray-300 mb-4">
                You have the right to withdraw from this contract within 30 days without giving any reason.
              </p>
              <p className="text-gray-700 dark:text-gray-300 mb-4">
                The withdrawal period will expire after 30 days from the day of the conclusion of the contract.
              </p>
              <p className="text-gray-700 dark:text-gray-300 mb-4">
                To exercise the right of withdrawal, you must inform us of your decision to withdraw from this contract by an unequivocal statement (for example a letter sent by post, fax, or email). Our contact details can be found below. You may use the attached model withdrawal form, but it is not obligatory.
              </p>
              <p className="text-gray-700 dark:text-gray-300 mb-4">
                If you use this option, we will communicate to you an acknowledgement of receipt of such a withdrawal on a durable medium (for example by email) without delay.
              </p>
              <p className="text-gray-700 dark:text-gray-300 mb-4">
                To meet the withdrawal deadline, it is sufficient for you to send your communication concerning your exercise of the right of withdrawal before the withdrawal period has expired.
              </p>
              
              <h3 className="text-xl font-semibold text-gray-900 dark:text-white mb-3">8.2 Effects of withdrawal</h3>
              <p className="text-gray-700 dark:text-gray-300 mb-4">
                If you withdraw from this contract, we shall reimburse you all payments received from you, including the costs of delivery (with the exception of the supplementary costs resulting from your choice of a type of delivery other than the least expensive type of standard delivery offered by us), without undue delay and in any event not later than 14 days from the day on which we are informed about your decision to withdraw from this contract. We will carry out such reimbursement using the same means of payment as you used for the initial transaction unless you have expressly agreed otherwise; in any event, you will not incur any fees as a result of such reimbursement.
              </p>
              <p className="text-gray-700 dark:text-gray-300 mb-4">
                If you requested to begin the performance of services during the withdrawal period, you shall pay us an amount which is in proportion to what has been provided until you have communicated to us your withdrawal from this contract, in comparison with the full coverage of the contract.
              </p>
              <p className="text-gray-700 dark:text-gray-300 mb-4">
                Please note that there are some legal exceptions to the right to withdraw, and some items can therefore not be returned or exchanged. We will let you know if this applies in your particular case.
              </p>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-bold text-gray-900 dark:text-white mb-4">9. Content posted by you</h2>
              <p className="text-gray-700 dark:text-gray-300 mb-4">
                We may provide various open communication tools on our website, such as blog comments, blog posts, forums, message boards, ratings and reviews, and various social media services. It might not be feasible for us to screen or monitor all content that you or others may share or submit on or through our website. However, we reserve the right to review the content and to monitor all use of and activity on our website, and remove or reject any content in our sole discretion. By posting information or otherwise using any open communication tools as mentioned, you agree that your content will comply with these Terms and Conditions and must not be illegal or unlawful or infringe any person's legal rights.
              </p>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-bold text-gray-900 dark:text-white mb-4">10. Idea submission</h2>
              <p className="text-gray-700 dark:text-gray-300 mb-4">
                Do not submit any ideas, inventions, works of authorship, or other information that can be considered your own intellectual property that you would like to present to us unless we have first signed an agreement regarding the intellectual property or a non-disclosure agreement. If you disclose it to us absent such written agreement, you grant to us a worldwide, irrevocable, non-exclusive, royalty-free license to use, reproduce, store, adapt, publish, translate and distribute your content in any existing or future media.
              </p>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-bold text-gray-900 dark:text-white mb-4">11. Termination of use</h2>
              <p className="text-gray-700 dark:text-gray-300 mb-4">
                We may, in our sole discretion, at any time modify or discontinue access to, temporarily or permanently, the website or any Service thereon. You agree that we will not be liable to you or any third party for any such modification, suspension or discontinuance of your access to, or use of, the website or any content that you may have shared on the website. You will not be entitled to any compensation or other payment, even if certain features, settings, and/or any Content you have contributed or have come to rely on, are permanently lost. You must not circumvent or bypass, or attempt to circumvent or bypass, any access restriction measures on our website.
              </p>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-bold text-gray-900 dark:text-white mb-4">12. Warranties and liability</h2>
              <p className="text-gray-700 dark:text-gray-300 mb-4">
                Nothing in this section will limit or exclude any warranty implied by law that it would be unlawful to limit or to exclude. This website and all content on the website are provided on an "as is" and "as available" basis and may include inaccuracies or typographical errors. We expressly disclaim all warranties of any kind, whether express or implied, as to the availability, accuracy, or completeness of the Content. We make no warranty that:
              </p>
              <ul className="list-disc pl-6 text-gray-700 dark:text-gray-300 mb-4">
                <li>this website or our products or services will meet your requirements;</li>
                <li>this website will be available on an uninterrupted, timely, secure, or error-free basis;</li>
                <li>the quality of any product or service purchased or obtained by you through this website will meet your expectations.</li>
              </ul>
              <p className="text-gray-700 dark:text-gray-300 mb-4">
                Nothing on this website constitutes or is meant to constitute, legal, financial or medical advice of any kind. If you require advice you should consult an appropriate professional.
              </p>
              <p className="text-gray-700 dark:text-gray-300 mb-4">
                The following provisions of this section will apply to the maximum extent permitted by applicable law and will not limit or exclude our liability in respect of any matter which it would be unlawful or illegal for us to limit or to exclude our liability. In no event will we be liable for any direct or indirect damages (including any damages for loss of profits or revenue, loss or corruption of data, software or database, or loss of or harm to property or data) incurred by you or any third party, arising from your access to, or use of, our website.
              </p>
              <p className="text-gray-700 dark:text-gray-300 mb-4">
                Except to the extent any additional contract expressly states otherwise, our maximum liability to you for all damages arising out of or related to the website or any products and services marketed or sold through the website, regardless of the form of legal action that imposes liability (whether in contract, equity, negligence, intended conduct, tort or otherwise) will be limited to $1000. Such limit will apply in the aggregate to all of your claims, actions and causes of action of every kind and nature.
              </p>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-bold text-gray-900 dark:text-white mb-4">13. Privacy</h2>
              <p className="text-gray-700 dark:text-gray-300 mb-4">
                To access our website and/or services, you may be required to provide certain information about yourself as part of the registration process. You agree that any information you provide will always be accurate, correct, and up to date.
              </p>
              <p className="text-gray-700 dark:text-gray-300 mb-4">
                We take your personal data seriously and are committed to protecting your privacy. We will not use your email address for unsolicited mail. Any emails sent by us to you will only be in connection with the provision of agreed products or services.
              </p>
              <p className="text-gray-700 dark:text-gray-300 mb-4">
                We have developed a policy to address any privacy concerns you may have. For more information, please see our Privacy Statement and our Cookie Policy.
              </p>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-bold text-gray-900 dark:text-white mb-4">14. Accessibility</h2>
              <p className="text-gray-700 dark:text-gray-300 mb-4">
                We are committed to making the content we provide accessible to individuals with disabilities. If you have a disability and are unable to access any portion of our website due to your disability, we ask you to give us a notice including a detailed description of the issue you encountered. If the issue is readily identifiable and resolvable in accordance with industry-standard information technology tools and techniques we will promptly resolve it.
              </p>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-bold text-gray-900 dark:text-white mb-4">15. Export restrictions / Legal compliance</h2>
              <p className="text-gray-700 dark:text-gray-300 mb-4">
                Access to the website from territories or countries where the Content or purchase of the products or Services sold on the website is illegal is prohibited. You may not use this website in violation of export laws and regulations of United States.
              </p>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-bold text-gray-900 dark:text-white mb-4">16. Affiliate marketing</h2>
              <p className="text-gray-700 dark:text-gray-300 mb-4">
                Through this Website we may engage in affiliate marketing whereby we receive a percentage of or a commission on the sale of services or products on or through this website. We may also accept sponsorships or other forms of advertising compensation from businesses. This disclosure is intended to comply with legal requirements on marketing and advertising which may apply, such as the US Federal Trade Commission Rules.
              </p>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-bold text-gray-900 dark:text-white mb-4">17. Assignment</h2>
              <p className="text-gray-700 dark:text-gray-300 mb-4">
                You may not assign, transfer or sub-contract any of your rights and/or obligations under these Terms and conditions, in whole or in part, to any third party without our prior written consent. Any purported assignment in violation of this Section will be null and void.
              </p>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-bold text-gray-900 dark:text-white mb-4">18. Breaches of these Terms and conditions</h2>
              <p className="text-gray-700 dark:text-gray-300 mb-4">
                Without prejudice to our other rights under these Terms and Conditions, if you breach these Terms and Conditions in any way, we may take such action as we deem appropriate to deal with the breach, including temporarily or permanently suspending your access to the website, contacting your internet service provider to request that they block your access to the website, and/or commence legal action against you.
              </p>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-bold text-gray-900 dark:text-white mb-4">19. Force majeure</h2>
              <p className="text-gray-700 dark:text-gray-300 mb-4">
                Except for obligations to pay money hereunder, no delay, failure or omission by either party to carry out or observe any of its obligations hereunder will be deemed to be a breach of these Terms and conditions if and for as long as such delay, failure or omission arises from any cause beyond the reasonable control of that party.
              </p>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-bold text-gray-900 dark:text-white mb-4">20. Indemnification</h2>
              <p className="text-gray-700 dark:text-gray-300 mb-4">
                You agree to indemnify, defend and hold us harmless, from and against any and all claims, liabilities, damages, losses and expenses, relating to your violation of these Terms and conditions, and applicable laws, including intellectual property rights and privacy rights. You will promptly reimburse us for our damages, losses, costs and expenses relating to or arising out of such claims.
              </p>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-bold text-gray-900 dark:text-white mb-4">21. Waiver</h2>
              <p className="text-gray-700 dark:text-gray-300 mb-4">
                Failure to enforce any of the provisions set out in these Terms and Conditions and any Agreement, or failure to exercise any option to terminate, shall not be construed as waiver of such provisions and shall not affect the validity of these Terms and Conditions or of any Agreement or any part thereof, or the right thereafter to enforce each and every provision.
              </p>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-bold text-gray-900 dark:text-white mb-4">22. Language</h2>
              <p className="text-gray-700 dark:text-gray-300 mb-4">
                These Terms and Conditions will be interpreted and construed exclusively in English. All notices and correspondence will be written exclusively in that language.
              </p>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-bold text-gray-900 dark:text-white mb-4">23. Entire agreement</h2>
              <p className="text-gray-700 dark:text-gray-300 mb-4">
                These Terms and Conditions, together with our privacy statement and cookie policy, constitute the entire agreement between you and IBRandBiz in relation to your use of this website.
              </p>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-bold text-gray-900 dark:text-white mb-4">24. Updating of these Terms and conditions</h2>
              <p className="text-gray-700 dark:text-gray-300 mb-4">
                We may update these Terms and Conditions from time to time. It is your obligation to periodically check these Terms and Conditions for changes or updates. The date provided at the beginning of these Terms and Conditions is the latest revision date. Changes to these Terms and Conditions will become effective upon such changes being posted to this website. Your continued use of this website following the posting of changes or updates will be considered notice of your acceptance to abide by and be bound by these Terms and Conditions.
              </p>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-bold text-gray-900 dark:text-white mb-4">25. Choice of Law and Jurisdiction</h2>
              <p className="text-gray-700 dark:text-gray-300 mb-4">
                These Terms and Conditions shall be governed by the laws of United States. Any disputes relating to these Terms and Conditions shall be subject to the jurisdiction of the courts of United States. If any part or provision of these Terms and Conditions is found by a court or other authority to be invalid and/or unenforceable under applicable law, such part or provision will be modified, deleted and/or enforced to the maximum extent permissible so as to give effect to the intent of these Terms and Conditions. The other provisions will not be affected.
              </p>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-bold text-gray-900 dark:text-white mb-4">26. Contact information</h2>
              <p className="text-gray-700 dark:text-gray-300 mb-4">
                This website is owned and operated by IBRandBiz.
              </p>
              <p className="text-gray-700 dark:text-gray-300 mb-4">
                You may contact us regarding these Terms and Conditions by writing or emailing us at the following address: info@ibrandbiz.com<br />
                Houston, Texas
              </p>
            </section>

            <section className="mb-8">
              <h2 className="text-2xl font-bold text-gray-900 dark:text-white mb-4">27. Download</h2>
              <p className="text-gray-700 dark:text-gray-300 mb-4">
                You can also download our Terms and Conditions as a PDF.
              </p>
            </section>

          </div>
        </div>
      </main>
    </TemplatePage>
  );
}