import TemplatePage from "@/components/TemplatePage";
import { Briefcase, Gavel, FileText, DollarSign, BookOpen } from "lucide-react";
import { resourcesImage } from "@/assets";

export default function ResourcesPage() {

  return (
    <TemplatePage 
      bannerTitle="Business Resources" 
      bannerSubtitle="Helpful links for forming and protecting your business"
      bannerImage={resourcesImage}
    >
      <section className="max-w-4xl mx-auto py-12 space-y-10">

        <div className="flex items-start gap-3">
          <Briefcase className="w-6 h-6 text-black dark:text-white mt-1 flex-shrink-0" />
          <div>
            <h2 className="text-xl font-semibold mb-2">Business Formation</h2>
            <p className="text-gray-600 dark:text-gray-400 mb-4">
              Understand the differences between a DBA, LLC, and Corporation — and choose what's right for you.
            </p>
            <ul className="list-disc list-inside space-y-2 text-sm">
              <li><a className="text-blue-600 hover:underline" href="https://www.sba.gov/business-guide/launch/choose-business-structure" target="_blank" rel="noopener noreferrer">SBA: Choose a business structure</a></li>
              <li><a className="text-blue-600 hover:underline" href="https://www.nolo.com/legal-encyclopedia/llc" target="_blank" rel="noopener noreferrer">Nolo: LLC basics</a></li>
            </ul>
          </div>
        </div>

        <div className="flex items-start gap-3">
          <Gavel className="w-6 h-6 text-black dark:text-white mt-1 flex-shrink-0" />
          <div>
            <h2 className="text-xl font-semibold mb-2">Trademarks & IP</h2>
            <p className="text-gray-600 dark:text-gray-400 mb-4">
              Protect your brand identity with trademarks, patents, or copyrights.
            </p>
            <ul className="list-disc list-inside space-y-2 text-sm">
              <li><a className="text-blue-600 hover:underline" href="https://tmsearch.uspto.gov/" target="_blank" rel="noopener noreferrer">USPTO Trademark Search</a></li>
              <li><a className="text-blue-600 hover:underline" href="https://www.uspto.gov/trademarks/apply" target="_blank" rel="noopener noreferrer">USPTO: Apply for a trademark</a></li>
            </ul>
          </div>
        </div>

        <div className="flex items-start gap-3">
          <FileText className="w-6 h-6 text-black dark:text-white mt-1 flex-shrink-0" />
          <div>
            <h2 className="text-xl font-semibold mb-2">DBA (Doing Business As)</h2>
            <p className="text-gray-600 dark:text-gray-400 mb-4">
              A DBA lets you operate under a business name different from your legal name.
            </p>
            <ul className="list-disc list-inside space-y-2 text-sm">
              <li><a className="text-blue-600 hover:underline" href="https://www.sba.gov/business-guide/launch/choose-business-structure/dba" target="_blank" rel="noopener noreferrer">SBA: DBA basics</a></li>
            </ul>
          </div>
        </div>

        <div className="flex items-start gap-3">
          <DollarSign className="w-6 h-6 text-black dark:text-white mt-1 flex-shrink-0" />
          <div>
            <h2 className="text-xl font-semibold mb-2">Taxes & EIN</h2>
            <p className="text-gray-600 dark:text-gray-400 mb-4">
              Most businesses need an EIN to open bank accounts and file taxes.
            </p>
            <ul className="list-disc list-inside space-y-2 text-sm">
              <li><a className="text-blue-600 hover:underline" href="https://www.irs.gov/businesses/small-businesses-self-employed/apply-for-an-employer-identification-number-ein-online" target="_blank" rel="noopener noreferrer">IRS: Apply for EIN online</a></li>
            </ul>
          </div>
        </div>

        <div className="flex items-start gap-3">
          <BookOpen className="w-6 h-6 text-black dark:text-white mt-1 flex-shrink-0" />
          <div>
            <h2 className="text-xl font-semibold mb-2">Helpful Guides</h2>
            <ul className="list-disc list-inside space-y-2 text-sm">
              <li><a className="text-blue-600 hover:underline" href="https://www.score.org/find-mentor" target="_blank" rel="noopener noreferrer">SCORE: Free business mentorship</a></li>
              <li><a className="text-blue-600 hover:underline" href="https://www.sba.gov/business-guide" target="_blank" rel="noopener noreferrer">SBA Business Guide</a></li>
            </ul>
          </div>
        </div>

      </section>
    </TemplatePage>
  );
}