import { useAuth } from "@/contexts/AuthContext";
import { withPro } from "@/lib/withPro";

export function SubscriptionTab({ me }: any) {
  const { currentUser } = useAuth();

  const openPortal = async () => {
    if (!currentUser) return;
    
    try {
      const token = await currentUser.getIdToken();
      const res = await fetch("/api/pay/portal", { 
        method: "POST", 
        headers: {
          "Authorization": `Bearer ${token}`
        }
      });
      
      const out = await res.json();
      if (res.ok && out.url) {
        window.location.href = out.url;
      } else {
        alert(out.error || "Portal unavailable");
      }
    } catch (error) {
      console.error('Portal error:', error);
      alert("Unable to open billing portal");
    }
  };

  const handleUpgrade = () => {
    withPro(() => {}, { source: "profile_subscription" });
  };

  return (
    <div className="rounded-2xl border p-6">
      <h2 className="text-xl font-semibold mb-2">Subscription</h2>
      <div className="text-sm text-gray-600 mb-6">
        Current plan: <span className="font-semibold text-lg">{me.isPaid ? "Pro" : "Free"}</span>
      </div>

      {me.isPaid ? (
        <div className="space-y-4">
          <div className="bg-green-50 border border-green-200 rounded-lg p-4">
            <div className="flex items-center">
              <div className="flex-shrink-0">
                <svg className="h-5 w-5 text-green-400" viewBox="0 0 20 20" fill="currentColor">
                  <path fillRule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clipRule="evenodd" />
                </svg>
              </div>
              <div className="ml-3">
                <h3 className="text-sm font-medium text-green-800">Pro Plan Active</h3>
                <div className="mt-1 text-sm text-green-700">
                  You have access to all Pro features including unlimited generations, exports, and priority support.
                </div>
              </div>
            </div>
          </div>
          
          <button 
            className="rounded-xl bg-black text-white px-4 py-2 hover:bg-gray-800 transition-colors" 
            onClick={openPortal}
          >
            Manage billing
          </button>
        </div>
      ) : (
        <div className="space-y-4">
          <div className="bg-blue-50 border border-blue-200 rounded-lg p-4">
            <div className="flex items-center">
              <div className="flex-shrink-0">
                <svg className="h-5 w-5 text-blue-400" viewBox="0 0 20 20" fill="currentColor">
                  <path fillRule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clipRule="evenodd" />
                </svg>
              </div>
              <div className="ml-3">
                <h3 className="text-sm font-medium text-blue-800">Free Plan</h3>
                <div className="mt-1 text-sm text-blue-700">
                  Upgrade to Pro to unlock unlimited generations, advanced features, and export capabilities.
                </div>
              </div>
            </div>
          </div>
          
          <button 
            className="rounded-xl bg-black text-white px-4 py-2 hover:bg-gray-800 transition-colors" 
            onClick={handleUpgrade}
          >
            Upgrade to Pro
          </button>
        </div>
      )}

      <div className="mt-6 text-xs text-gray-500">
        <p>
          Need help with billing? Contact our support team at{" "}
          <a href="mailto:support@ibrandbiz.com" className="text-primary hover:underline">
            support@ibrandbiz.com
          </a>
        </p>
      </div>
    </div>
  );
}