import TemplatePage from "@/components/TemplatePage";
import { privacyImage } from "@/assets";

/**
 * IBrandBiz — Privacy Policy (Pre‑Login)
 * Framework: React + TailwindCSS
 * Tone: Clear, plain‑English policy suitable for a SaaS with AI tool, domains, and hosting.
 */

const COMPANY_NAME = "IBrandBiz";
const LEGAL_ENTITY = "IBrandBiz DBA";
const CONTACT_EMAIL = "info@ibrandbiz.com";
const BUSINESS_ADDRESS = "Houston, TX";
const EFFECTIVE_DATE = "2025-09-13";

export default function PrivacyPolicyPage() {
  return (
    <TemplatePage
      bannerTitle="Privacy Policy"
      bannerSubtitle="Learn how we collect, use, and protect your information when using our services"
      bannerImage={privacyImage}
    >
      <main className="mx-auto max-w-4xl px-6 py-12 text-slate-800 dark:text-slate-200">
      <header className="mb-8">
        <p className="text-xs uppercase tracking-wider text-slate-500 dark:text-slate-400">Privacy Policy</p>
        <h1 className="mt-1 text-3xl font-extrabold text-[#03222e] dark:text-white">{COMPANY_NAME} Privacy Policy</h1>
        <p className="mt-2 text-sm text-slate-600 dark:text-slate-400">Effective date: {EFFECTIVE_DATE}</p>
        <p className="mt-4 text-slate-700 dark:text-slate-300">
          This Privacy Policy explains how {LEGAL_ENTITY} ("{COMPANY_NAME}", "we", "us") collects, uses, shares, and protects
          your information when you use our websites, products, and services, including our Brand Name Wizard, domain search,
          and web hosting offerings (collectively, the "Services").
        </p>
      </header>

      <Section title="1) Information We Collect">
        <ul className="list-disc pl-6 space-y-2">
          <li><strong>Account & Contact Data:</strong> name, email, phone (optional), company, billing address.</li>
          <li><strong>Usage Data:</strong> interactions with the site and Services, pages viewed, clicks, feature usage, crash logs.</li>
          <li><strong>Brand Wizard Inputs:</strong> keywords, industries, preferences, and any text you provide for name generation.</li>
          <li><strong>Domain Search Data:</strong> queries, TLD preferences, and selections for availability checks.</li>
          <li><strong>Hosting Setup Data:</strong> chosen plan, domain mapping choices, configuration preferences.</li>
          <li><strong>Technical Data:</strong> IP address, device/browser info, cookies, and similar identifiers.</li>
          <li><strong>Payment Data:</strong> processed by our payment provider. We do not store full card numbers on our servers.</li>
        </ul>
      </Section>

      <Section title="2) How We Use Information">
        <ul className="list-disc pl-6 space-y-2">
          <li>Provide and improve the Services, including name generation, domain lookup, and hosting.</li>
          <li>Process orders, subscriptions, and payments; send transactional emails and service updates.</li>
          <li>Personalize content (e.g., recommended names or domain extensions).</li>
          <li>Monitor performance, debug issues, and enhance security.</li>
          <li>Comply with legal obligations and enforce terms.</li>
          <li>With your consent, send marketing communications you can unsubscribe from anytime.</li>
        </ul>
      </Section>

      <Section title="3) Cookies & Similar Technologies">
        <p className="mb-3">We use cookies and similar technologies to operate and improve the Services. Types include:</p>
        <ul className="list-disc pl-6 space-y-2">
          <li><strong>Essential:</strong> required for core functionality (authentication, preferences).</li>
          <li><strong>Analytics:</strong> to understand usage and improve features.</li>
          <li><strong>Marketing:</strong> to measure campaigns and show relevant content (only with consent where required).</li>
        </ul>
        <p className="mt-3">You can control cookies via your browser settings. Some features may not function without essential cookies.</p>
      </Section>

      <Section title="4) When We Share Information">
        <p className="mb-3">We share data only as needed to run the Services or as required by law:</p>
        <ul className="list-disc pl-6 space-y-2">
          <li><strong>Service Providers/Sub‑processors:</strong> trusted vendors who help us deliver the Services (e.g., domain registrars/marketplaces, hosting infrastructure, analytics, payments). They are bound by privacy and security obligations.</li>
          <li><strong>Domain Purchases:</strong> When you register or manage a domain, relevant data is shared with the registrar/registry and may be used for WHOIS/RDAP records per ICANN/registry rules (subject to privacy/proxy options where available).</li>
          <li><strong>Legal:</strong> to comply with laws, respond to lawful requests, or protect rights, safety, and security.</li>
          <li><strong>Business Transfers:</strong> in connection with a merger, acquisition, or asset sale, consistent with this Policy.</li>
        </ul>
      </Section>

      <Section title="5) International Transfers">
        <p>
          We may process and store information in the United States and other countries. Where required, we implement appropriate
          safeguards for cross‑border data transfers.
        </p>
      </Section>

      <Section title="6) Data Retention">
        <p>
          We retain personal information only as long as necessary to provide the Services, comply with legal obligations,
          resolve disputes, and enforce agreements. Retention periods may vary by data type and legal requirements.
        </p>
      </Section>

      <Section title="7) Security">
        <p>
          We employ administrative, technical, and physical safeguards designed to protect personal information. No method of
          transmission over the Internet or electronic storage is 100% secure; we continuously improve our protections.
        </p>
      </Section>

      <Section title="8) Your Rights & Choices">
        <ul className="list-disc pl-6 space-y-2">
          <li>Access, correct, or delete certain personal information.</li>
          <li>Opt out of marketing emails via the unsubscribe link.</li>
          <li>Control cookies through your browser or system settings.</li>
          <li>If you are in a region with specific privacy laws (e.g., GDPR/EEA, UK, California/CPRA), you may have additional rights. Contact us to exercise these rights.</li>
        </ul>
      </Section>

      <Section title="9) Children's Privacy">
        <p>
          Our Services are not directed to children under 13 (or the age defined by local law). We do not knowingly collect
          personal information from children. If you believe a child has provided us data, contact us to request deletion.
        </p>
      </Section>

      <Section title="10) Sub‑Processors">
        <p className="mb-3">We use third parties to help operate the Services. Examples include:</p>
        <ul className="list-disc pl-6 space-y-2">
          <li>Domain registrar/marketplace: <em>GoDaddy Operating Company, LLC</em> (domain search/registration workflow).</li>
          <li>Payment processing: <em>Stripe, Inc.</em> for secure payments.</li>
          <li>Analytics: <em>Google Analytics</em> for usage insights.</li>
          <li>Infrastructure/hosting: <em>Replit</em> / <em>Cloudflare</em> for application hosting and CDN services.</li>
        </ul>
      </Section>

      <Section title="11) Changes to This Policy">
        <p>
          We may update this Policy from time to time. If we make material changes, we will provide notice (e.g., by email or
          in‑app) and update the "Effective date" above.
        </p>
      </Section>

      <Section title="12) Contact Us">
        <p>
          Questions or requests? Email <a className="text-[#05445e] dark:text-blue-400 underline" href={`mailto:${CONTACT_EMAIL}`}>{CONTACT_EMAIL}</a> or write to us at {BUSINESS_ADDRESS}.
        </p>
      </Section>

      <footer className="mt-10 border-t pt-6 text-xs text-slate-500 dark:text-slate-400">
        <p>
          If there is any conflict between this Privacy Policy and your local law, we will apply the version that provides
          greater protection to you to the extent required by law.
        </p>
      </footer>
    </main>
    </TemplatePage>
  );
}

function Section({ title, children }: { title: string; children: React.ReactNode }) {
  return (
    <section className="mt-10">
      <h2 className="text-xl font-bold text-[#03222e] dark:text-white">{title}</h2>
      <div className="mt-3 text-slate-700 dark:text-slate-300 text-[15px] leading-7">{children}</div>
    </section>
  );
}