import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { Badge } from "@/components/ui/badge";
import { Check, Server, Shield, Zap, Globe } from "lucide-react";

export default function Hosting() {
  const hostingPlans = [
    {
      id: "starter",
      name: "Starter",
      price: "$9.99",
      period: "/month",
      description: "Perfect for personal websites and small projects",
      features: [
        "10 GB SSD Storage",
        "100 GB Bandwidth",
        "1 Website",
        "Free SSL Certificate",
        "24/7 Support",
        "99.9% Uptime Guarantee"
      ],
      popular: false,
      cta: "Get Started"
    },
    {
      id: "professional",
      name: "Professional",
      price: "$19.99",
      period: "/month",
      description: "Ideal for growing businesses and e-commerce sites",
      features: [
        "50 GB SSD Storage",
        "Unlimited Bandwidth",
        "5 Websites",
        "Free SSL Certificate",
        "Daily Backups",
        "Priority Support",
        "99.9% Uptime Guarantee",
        "Free Domain for 1 Year"
      ],
      popular: true,
      cta: "Get Started"
    },
    {
      id: "enterprise",
      name: "Enterprise",
      price: "$49.99",
      period: "/month",
      description: "For high-traffic websites and applications",
      features: [
        "200 GB SSD Storage",
        "Unlimited Bandwidth",
        "Unlimited Websites",
        "Free SSL Certificate",
        "Daily Backups",
        "Dedicated Support",
        "99.9% Uptime Guarantee",
        "Free Domain for 1 Year",
        "Advanced Security Features",
        "Performance Optimization"
      ],
      popular: false,
      cta: "Get Started"
    }
  ];

  const features = [
    {
      icon: <Server className="h-6 w-6" />,
      title: "High Performance",
      description: "Lightning-fast SSD storage and optimized servers for maximum speed"
    },
    {
      icon: <Shield className="h-6 w-6" />,
      title: "Advanced Security",
      description: "Built-in security features including SSL certificates and malware protection"
    },
    {
      icon: <Zap className="h-6 w-6" />,
      title: "99.9% Uptime",
      description: "Reliable hosting with guaranteed uptime and 24/7 monitoring"
    },
    {
      icon: <Globe className="h-6 w-6" />,
      title: "Global CDN",
      description: "Content delivery network for faster loading times worldwide"
    }
  ];

  return (
    <div className="max-w-7xl mx-auto">
      {/* Header */}
      <div className="text-center mb-12">
        <h1 className="text-4xl font-bold text-gray-900 dark:text-white mb-4">
          Web Hosting Plans
        </h1>
        <p className="text-xl text-muted-foreground max-w-3xl mx-auto">
          Fast, reliable hosting with built-in security and 24/7 uptime for your website. 
          Choose the perfect plan for your needs.
        </p>
      </div>

      {/* Features Grid */}
      <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-16">
        {features.map((feature) => (
          <div key={feature.title} className="text-center">
            <div className="w-12 h-12 bg-primary/10 rounded-lg flex items-center justify-center mx-auto mb-4">
              <div className="text-primary">
                {feature.icon}
              </div>
            </div>
            <h3 className="text-lg font-semibold mb-2">{feature.title}</h3>
            <p className="text-muted-foreground text-sm">{feature.description}</p>
          </div>
        ))}
      </div>

      {/* Pricing Plans */}
      <div className="grid grid-cols-1 md:grid-cols-3 gap-8 mb-16">
        {hostingPlans.map((plan) => (
          <Card 
            key={plan.id} 
            className={`relative ${plan.popular ? 'border-primary shadow-lg scale-105' : ''}`}
            data-testid={`card-hosting-plan-${plan.id}`}
          >
            {plan.popular && (
              <Badge className="absolute -top-3 left-1/2 transform -translate-x-1/2 bg-primary text-primary-foreground">
                Most Popular
              </Badge>
            )}
            <CardHeader className="text-center pb-4">
              <CardTitle className="text-2xl font-bold">{plan.name}</CardTitle>
              <CardDescription className="text-sm">{plan.description}</CardDescription>
              <div className="mt-4">
                <span className="text-4xl font-bold text-primary">{plan.price}</span>
                <span className="text-muted-foreground">{plan.period}</span>
              </div>
            </CardHeader>
            <CardContent>
              <ul className="space-y-3 mb-6">
                {plan.features.map((feature, index) => (
                  <li key={index} className="flex items-center text-sm">
                    <Check className="h-4 w-4 text-primary mr-3 flex-shrink-0" />
                    <span>{feature}</span>
                  </li>
                ))}
              </ul>
              <Button 
                className={`w-full font-bold ${plan.popular ? 'bg-primary hover:bg-primary/90 text-white' : ''}`}
                variant={plan.popular ? 'default' : 'outline'}
                data-testid={`button-plan-${plan.id}`}
              >
                {plan.cta}
              </Button>
            </CardContent>
          </Card>
        ))}
      </div>

      {/* Additional Information */}
      <div className="bg-gradient-to-r from-primary/5 to-accent/5 rounded-2xl p-8 text-center">
        <h2 className="text-2xl font-bold mb-4">Need Help Choosing?</h2>
        <p className="text-muted-foreground mb-6 max-w-2xl mx-auto">
          Our hosting experts are here to help you find the perfect plan for your website. 
          Contact us for personalized recommendations.
        </p>
        <div className="flex flex-col sm:flex-row gap-4 justify-center">
          <Button 
            size="lg" 
            className="bg-primary hover:bg-primary/90 text-white font-bold"
            data-testid="button-contact-support"
          >
            Contact Support
          </Button>
          <Button 
            variant="outline" 
            size="lg"
            className="border-primary text-primary hover:bg-primary hover:text-white font-bold"
            data-testid="button-view-features"
          >
            View All Features
          </Button>
        </div>
      </div>
    </div>
  );
}